/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.validator;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;

public class FallPriceFieldValidator
extends AbstractValidator {
    private static final String entry = "entry";
    private static final String provision_way = "provisionway";
    private static final String material_group = "materialgroup";
    private static final String material = "material";
    private static final String fall_price_scale = "fallpricescale";
    private static final String unitrealizable_amount = "unitrealizableamount";
    private static final String set_dimension = "setdimension";
    private static final String location = "location";
    private static final String warehouse_group = "warehousegroup";

    public void validate() {
        this.chenckEntryData();
    }

    private void chenckEntryData() {
        ExtendedDataEntity[] billInfos;
        for (ExtendedDataEntity billInfo : billInfos = this.getDataEntities()) {
            this.validatePvWay(billInfo);
            this.validateAmount(billInfo);
            this.validateSetDimension(billInfo);
        }
    }

    private void validatePvWay(ExtendedDataEntity billInfo) {
        DynamicObject bill = billInfo.getDataEntity();
        String way = bill.getString(provision_way);
        String validateField = "";
        String fieldName = "";
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection(entry);
        if ("A".equals(way)) {
            validateField = material;
            fieldName = ResManager.loadKDString((String)"\u7269\u6599", (String)"FallPriceFieldValidator_0", (String)"fi-cal-opplugin", (Object[])new Object[0]);
        } else if ("B".equals(way)) {
            validateField = material_group;
            fieldName = ResManager.loadKDString((String)"\u7269\u6599\u5206\u7c7b", (String)"FallPriceFieldValidator_1", (String)"fi-cal-opplugin", (Object[])new Object[0]);
        } else if ("C".equals(way)) {
            validateField = warehouse_group;
            fieldName = ResManager.loadKDString((String)"\u4ed3\u5e93\u5206\u7ec4", (String)"FallPriceFieldValidator_7", (String)"fi-cal-opplugin", (Object[])new Object[0]);
        }
        DynamicObject entryInfo = null;
        for (int i = 0; i < entrys.size(); ++i) {
            entryInfo = (DynamicObject)entrys.get(i);
            DynamicObject info = entryInfo.getDynamicObject(validateField);
            if (info != null) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55%2$s\u672a\u586b\u3002", (String)"FallPriceFieldValidator_11", (String)"fi-cal-opplugin", (Object[])new Object[0]), i + 1, fieldName);
            this.addErrorMessage(billInfo, msg);
        }
    }

    private void validateAmount(ExtendedDataEntity billInfo) {
        DynamicObject bill = billInfo.getDataEntity();
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection(entry);
        BigDecimal scale = null;
        BigDecimal amount = BigDecimal.ZERO;
        DynamicObject entryInfo = null;
        Boolean isScaleCheck = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.FALLPRICE_SCALE_CHECK);
        for (int i = 0; i < entrys.size(); ++i) {
            String msg;
            entryInfo = (DynamicObject)entrys.get(i);
            scale = entryInfo.getBigDecimal(fall_price_scale);
            amount = entryInfo.getBigDecimal(unitrealizable_amount);
            if (isScaleCheck.booleanValue()) {
                if (scale.compareTo(BigDecimal.ZERO) == 0 && amount.compareTo(BigDecimal.ZERO) == 0) {
                    msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u5355\u4f4d\u53ef\u53d8\u73b0\u51c0\u503c\u548c\u8dcc\u4ef7\u6bd4\u4f8b\u90fd\u672a\u5f55\u5165\uff0c\u8bf7\u7ef4\u62a4\u201c\u5355\u4f4d\u53ef\u53d8\u73b0\u51c0\u503c\u201d\u6216\u8005\u201c\u8dcc\u4ef7\u6bd4\u4f8b\u201d\u3002", (String)"FallPriceFieldValidator_12", (String)"fi-cal-opplugin", (Object[])new Object[0]), i + 1);
                    this.addErrorMessage(billInfo, msg);
                } else if (scale.compareTo(BigDecimal.ZERO) != 0 && amount.compareTo(BigDecimal.ZERO) != 0) {
                    msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u5355\u4f4d\u53ef\u53d8\u73b0\u51c0\u503c\u3001\u8dcc\u4ef7\u6bd4\u4f8b\uff0c\u53ea\u80fd\u7ef4\u62a4\u4e00\u4e2a\u3002", (String)"FallPriceFieldValidator_13", (String)"fi-cal-opplugin", (Object[])new Object[0]), i + 1);
                    this.addErrorMessage(billInfo, msg);
                }
            }
            if (amount.compareTo(BigDecimal.ZERO) >= 0) continue;
            msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7684\u5355\u4f4d\u53ef\u53d8\u73b0\u51c0\u503c\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"FallPriceFieldValidator_14", (String)"fi-cal-opplugin", (Object[])new Object[0]), i + 1);
            this.addErrorMessage(billInfo, msg);
        }
    }

    private void validateSetDimension(ExtendedDataEntity billInfo) {
        DynamicObject bill = billInfo.getDataEntity();
        String setDimension = bill.getString(set_dimension);
        if (setDimension == null || setDimension.isEmpty()) {
            return;
        }
        String[] dimensionArray = setDimension.split(",");
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection(entry);
        DynamicObject entryInfo = null;
        boolean isopenlocation = false;
        for (int i = 0; i < entrys.size(); ++i) {
            entryInfo = (DynamicObject)entrys.get(i);
            for (String str : dimensionArray) {
                Object fieldValueS;
                if ("x".equals(str) || str.isEmpty() || "configuredcode".equals(str) || location.equals(str) && !(isopenlocation = entryInfo.getBoolean("warehouse.isopenlocation")) || !StringUtils.isBlank((Object)(fieldValueS = entryInfo.get(str)))) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u8bf7\u586b\u5199\u8bbe\u7f6e\u7ef4\u5ea6\u52fe\u9009\u5b57\u6bb5\u3002", (String)"FallPriceFieldValidator_15", (String)"fi-cal-opplugin", (Object[])new Object[0]), i + 1);
                this.addErrorMessage(billInfo, msg);
            }
        }
    }
}

