/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class FallPriceRevBillDimValidator
extends AbstractValidator {
    private static final String entry = "entry";
    private static final String set_dimension = "setdimension";

    public void validate() {
        HashSet<Long> periodSet = new HashSet<Long>(this.dataEntities.length);
        HashSet<Long> orgSet = new HashSet<Long>(this.dataEntities.length);
        HashSet<Long> costAccountSet = new HashSet<Long>(this.dataEntities.length);
        for (ExtendedDataEntity billInfo : this.dataEntities) {
            DynamicObject bill = billInfo.getDataEntity();
            periodSet.add(bill.getLong("periodid.id"));
            orgSet.add(bill.getLong("org_id"));
            costAccountSet.add(bill.getLong("costaccount_id"));
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"cal_fallprice_setting");
        List setDimensions = ((MulComboProp)dataEntityType.getAllFields().get(set_dimension)).getComboItems();
        HashSet<String> dims = new HashSet<String>(setDimensions.size());
        HashSet<String> entryDims = new HashSet<String>(setDimensions.size());
        String fieldValue = "";
        for (ValueMapItem dim : setDimensions) {
            fieldValue = dim.getValue();
            if ("x".equals(fieldValue)) continue;
            dims.add(fieldValue);
            entryDims.add("entry." + fieldValue + " as " + fieldValue);
        }
        Map<Long, Map<String, Set<Object>>> periodDimensionMap = this.getPeriodDimensionMap(periodSet, dims, entryDims, orgSet, costAccountSet);
        this.validateUnqueDimension(periodDimensionMap, dims);
    }

    private Map<Long, Map<String, Set<Object>>> getPeriodDimensionMap(Set<Long> periodSet, Set<String> dims, Set<String> entryDims, Set<Long> orgSet, Set<Long> costAccountSet) {
        String entryDimSelects = StringUtils.join((Object[])entryDims.toArray(new String[entryDims.size()]), (String)",");
        HashMap<Long, Map<String, Set<Object>>> periodDimensionMap = new HashMap<Long, Map<String, Set<Object>>>(periodSet.size());
        QFilter qFilter = new QFilter("periodid", "in", periodSet);
        if (!orgSet.isEmpty()) {
            qFilter.and("org", "in", orgSet);
        }
        if (!costAccountSet.isEmpty()) {
            qFilter.and("costaccount", "in", costAccountSet);
        }
        String field = "id,org,costaccount,periodid.id as periodid,entry.materialgroup.id as materialgroup,entry.invagefrom as invagefrom,entry.invageto as invageto,entry.expirydatefrom expirydatefrom,entry.expirydateto expirydateto,entry.material.id as material," + entryDimSelects;
        try (DataSet revDataset = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "getPeriodDimensionMap(A)"), (String)"cal_price_provbill", (String)field, (QFilter[])qFilter.toArray(), null);
             DataSet proDataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "getPeriodDimensionMap(B)"), (String)"cal_price_revbill", (String)field, (QFilter[])qFilter.toArray(), null);
             DataSet allDataSet = revDataset.union(proDataSet);){
            StringBuilder valueBuilder = new StringBuilder();
            long org = 0L;
            long costAccount = 0L;
            long periodid = 0L;
            long material = 0L;
            int invagefrom = 0;
            int invageto = 0;
            for (Row row : allDataSet) {
                valueBuilder.setLength(0);
                org = row.getLong("org");
                costAccount = row.getLong("costaccount");
                periodid = row.getLong("periodid");
                material = row.getLong("material");
                invagefrom = row.getInteger("invagefrom");
                invageto = row.getInteger("invageto");
                int expiryDateFrom = row.getInteger("expirydatefrom");
                int expiryDateTo = row.getInteger("expirydateto");
                valueBuilder.append(org).append(',').append(costAccount).append(',').append(material).append(',').append(invagefrom).append(',').append(invageto).append(',').append(expiryDateFrom).append(',').append(expiryDateTo).append(',');
                for (String dim : dims) {
                    valueBuilder.append(row.get(dim));
                    valueBuilder.append(',');
                }
                periodDimensionMap.putIfAbsent(periodid, new HashMap(16));
                Map stringSetMap = (Map)periodDimensionMap.get(periodid);
                Set ids = stringSetMap.computeIfAbsent(valueBuilder.toString(), k -> new HashSet(16));
                ids.add(row.getLong("id"));
            }
        }
        return periodDimensionMap;
    }

    private String getFieldValue(DynamicObject o, String field) {
        Object value = null;
        value = o.get(field);
        if (value == null) {
            return "0";
        }
        if (value instanceof DynamicObject) {
            o = (DynamicObject)value;
            return o.getPkValue().toString();
        }
        return value.toString();
    }

    private void validateUnqueDimension(Map<Long, Map<String, Set<Object>>> periodDimensionMap, Set<String> dims) {
        long org = 0L;
        long costAccount = 0L;
        long periodid = 0L;
        long material = 0L;
        int invagefrom = 0;
        int invageto = 0;
        StringBuilder sBuilder = new StringBuilder();
        String sbString = "";
        for (ExtendedDataEntity billInfo : this.dataEntities) {
            DynamicObject bill = billInfo.getDataEntity();
            periodid = bill.getLong("periodid.id");
            org = bill.getLong("org_id");
            costAccount = bill.getLong("costaccount_id");
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection(entry);
            Object id = bill.getPkValue();
            for (DynamicObject entryInfo : entrys) {
                boolean onlySelf;
                sBuilder.setLength(0);
                material = entryInfo.getLong("material.id");
                invagefrom = entryInfo.getInt("invagefrom");
                invageto = entryInfo.getInt("invageto");
                int expiryDateFrom = entryInfo.getInt("expirydatefrom");
                int expiryDateTo = entryInfo.getInt("expirydateto");
                sBuilder.append(org).append(',').append(costAccount).append(',').append(material).append(',').append(invagefrom).append(',').append(invageto).append(',').append(expiryDateFrom).append(',').append(expiryDateTo).append(',');
                for (String dim : dims) {
                    sBuilder.append(this.getFieldValue(entryInfo, dim));
                    sBuilder.append(',');
                }
                sbString = sBuilder.toString();
                periodDimensionMap.putIfAbsent(periodid, new HashMap(16));
                Map<String, Set<Object>> stringSetMap = periodDimensionMap.get(periodid);
                Set existIds = stringSetMap.computeIfAbsent(sbString, k -> new HashSet(16));
                if (!bill.getDataEntityState().getFromDatabase()) {
                    id = billInfo.getDataEntityIndex();
                }
                if (onlySelf = existIds.size() == 1 && existIds.contains(id)) continue;
                if (!existIds.isEmpty()) {
                    this.addErrorMessage(billInfo, ResManager.loadKDString((String)"\u5f53\u671f\u7684\u8ba1\u63d0\u5355\u548c\u51b2\u56de\u5355\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u7269\u6599/\u7269\u6599\u5206\u7c7b+\u8bbe\u7f6e\u7ef4\u5ea6\u3002", (String)"FallPriceRevBillDimValidator_0", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    continue;
                }
                existIds.add(id);
            }
        }
    }
}

