/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.validator;

import java.math.BigDecimal;
import java.util.Iterator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class FallPriceRevBillFieldValidator
extends AbstractValidator {
    private static final String entry = "entry";

    public void validate() {
        for (ExtendedDataEntity billInfo : this.dataEntities) {
            this.removeEntry(billInfo);
        }
    }

    private void removeEntry(ExtendedDataEntity billInfo) {
        DynamicObject bill = billInfo.getDataEntity();
        DynamicObjectCollection entryInfos = bill.getDynamicObjectCollection(entry);
        BigDecimal rushAmount = BigDecimal.ZERO;
        Iterator entryIter = entryInfos.iterator();
        while (entryIter.hasNext()) {
            DynamicObject entryInfo = (DynamicObject)entryIter.next();
            rushAmount = entryInfo.getBigDecimal("curperiodrushamount");
            if (rushAmount.compareTo(BigDecimal.ZERO) != 0) continue;
            entryIter.remove();
        }
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection(entry);
        if (entrys.size() == 0) {
            this.addErrorMessage(billInfo, ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u9700\u8981\u81f3\u5c11\u6709\u4e00\u6761\u672c\u671f\u51b2\u56de\u91d1\u989d\u4e0d\u4e3a\u96f6\u7684\u5206\u5f55\u3002", (String)"FallPriceRevBillFieldValidator_0", (String)"fi-cal-opplugin", (Object[])new Object[0]));
            return;
        }
    }
}

