/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.validator;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.AccountType4CostAdjustHelper;
import kd.fi.cal.common.helper.CostTypeHelper;
import kd.fi.cal.common.helper.DecimalHelper;
import kd.fi.cal.common.helper.InitCalBillHelper;
import kd.fi.cal.common.helper.MaterialHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.SCMHelper;
import kd.fi.cal.common.helper.SynBizBillHelper;
import kd.fi.cal.common.model.SynBillErrInfo;

public class InitCalBillSubmitValidator
extends AbstractValidator {
    private static String[] COSTTYPE_FIELD = new String[]{"auditdate", "costaccount", "calorg", "storageorgunit", "accounttype"};
    private Set<Long> materialIdSet = new HashSet<Long>(512);
    private Set<Long> storageorgIdSet = new HashSet<Long>(16);
    private Set<Long> costAccountIdSet = new HashSet<Long>(16);
    private Set<String> storageorgNumSet = new HashSet<String>(16);
    private Set<Long> bizBillEntryIdSet = new HashSet<Long>(16);
    private Set<Long> bizBillIdSet = new HashSet<Long>(16);
    private Set<Long> errIspresentIdSet = new HashSet<Long>(16);
    private Set<Long> errAmountIdSet = new HashSet<Long>(16);
    private Map<Long, List<Object>> errCurrencyIdMap = new HashMap<Long, List<Object>>(16);
    private Map<String, DynamicObject> material2InvInf = new HashMap<String, DynamicObject>(this.materialIdSet.size());
    private Map<String, DynamicObject> material2GlobalInvInf = new HashMap<String, DynamicObject>(this.materialIdSet.size());
    private Map<Long, DynamicObject> costAcc2StartPeriod = new HashMap<Long, DynamicObject>(this.costAccountIdSet.size());
    private Map<Long, Boolean> costAcc2CalByEle = new HashMap<Long, Boolean>(this.costAccountIdSet.size());
    private Map<String, Long[]> storageWarehs = new HashMap<String, Long[]>(this.storageorgNumSet.size());
    boolean notCheckMatinvinfo;

    public OperateOption getOption() {
        return super.getOption();
    }

    public InitCalBillSubmitValidator(boolean isCheckMatinvinfo) {
        this.notCheckMatinvinfo = isCheckMatinvinfo;
    }

    public void validate() {
        ExtendedDataEntity[] billInfos = this.getDataEntities();
        this.preValidateData(billInfos);
        ArrayList<DynamicObject> billInfoList = new ArrayList<DynamicObject>(billInfos.length);
        this.doValidateBeforeReloadRange(billInfos, billInfoList);
        if (billInfoList.isEmpty()) {
            return;
        }
        AccountType4CostAdjustHelper helper = new AccountType4CostAdjustHelper(billInfoList.toArray(new DynamicObject[0]));
        helper.handleCalRangeAccType4InitBill();
        this.doValidateAfterReloadRange(billInfos);
    }

    private void preValidateData(ExtendedDataEntity[] billInfos) {
        Serializable bookDate;
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        for (int i = 0; i < billInfos.length; ++i) {
            DynamicObject costaccount;
            DynamicObject bill = billInfos[i].getDataEntity();
            if (bill == null || (costaccount = bill.getDynamicObject("costaccount")) == null) continue;
            costAccountIds.add(costaccount.getLong("id"));
        }
        HashMap<Long, Long> csIdAndExrateTableMap = new HashMap<Long, Long>(16);
        QFilter q = new QFilter("id", "in", costAccountIds);
        DataSet csIdAndExrateTable = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_bd_costaccount", (String)"id,calpolicy.exratetable as exratetable", (QFilter[])new QFilter[]{q}, null);
        for (Row row : csIdAndExrateTable) {
            Long id = row.getLong("id");
            Long exratetable = row.getLong("exratetable");
            csIdAndExrateTableMap.put(id, exratetable);
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>(16);
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("localcurrency", (DataType)DataType.LongType), new Field("billno", (DataType)DataType.StringType), new Field("entryid", (DataType)DataType.LongType), new Field("ispresent", (DataType)DataType.BooleanType), new Field("amount", (DataType)DataType.BigDecimalType), new Field("costdiff", (DataType)DataType.BigDecimalType), new Field("calbizid", (DataType)DataType.LongType), new Field("exratetable", (DataType)DataType.LongType)});
        for (int i = 0; i < billInfos.length; ++i) {
            DynamicObject bill = billInfos[i].getDataEntity();
            Date bizDate = bill.getDate("bizdate");
            bookDate = bill.getDate("bookdate");
            DynamicObject costAccount = bill.getDynamicObject("costaccount");
            DynamicObject calOrg = bill.getDynamicObject("calorg");
            long localcurrency = bill.getDynamicObject("localcurrency").getLong("id");
            String billno = bill.getString("billno");
            if (costAccount == null || bizDate == null || calOrg == null || bookDate == null) continue;
            this.costAccountIdSet.add(costAccount.getLong("id"));
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
            if (entrys == null || entrys.isEmpty()) continue;
            Long bizBillId = bill.getLong("bizbillid");
            if (Long.compare(bizBillId, 0L) != 0) {
                this.bizBillIdSet.add(bizBillId);
            }
            for (DynamicObject entry : entrys) {
                long entryId = entry.getLong("id");
                long bizbillentryid = entry.getLong("bizbillentryid");
                this.bizBillEntryIdSet.add(bizbillentryid);
                DynamicObject warehouse = entry.getDynamicObject("warehouse");
                DynamicObject material = entry.getDynamicObject("material");
                DynamicObject storageorgUnit = entry.getDynamicObject("storageorgunit");
                if (warehouse == null || material == null || storageorgUnit == null) continue;
                this.costAccountIdSet.add(costAccount.getLong("id"));
                this.materialIdSet.add(material.getLong("id"));
                this.storageorgIdSet.add(storageorgUnit.getLong("id"));
                this.storageorgNumSet.add(storageorgUnit.getString("number"));
                boolean ispresent = entry.getBoolean("ispresent");
                BigDecimal amount = entry.getBigDecimal("amount");
                BigDecimal costdiff = entry.getBigDecimal("costdiff");
                Object[] row = new Object[]{localcurrency, billno, entryId, ispresent, amount, costdiff, bizbillentryid, csIdAndExrateTableMap.get(costAccount.getLong("id"))};
                rows.add(row);
            }
        }
        QFilter bizEntryQF = new QFilter("billentry.id", "in", this.bizBillEntryIdSet);
        bizEntryQF.and("id", "in", this.bizBillIdSet);
        String bizFields = "currency,billentry.id as bizid,billentry.ispresent as bizispresent,billentry.amount as bizamount";
        AlgoContext context = Algo.newContext();
        bookDate = null;
        try {
            DataSet bizEntryDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_initbill", (String)bizFields, (QFilter[])new QFilter[]{bizEntryQF}, null);
            DataSet calEntryDataSet = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(rows, rowMeta);
            DataSet finish = calEntryDataSet.join(bizEntryDataSet).on("calbizid", "bizid").select(new String[]{"entryid", "calbizid", "localcurrency", "ispresent", "amount", "costdiff", "exratetable"}, new String[]{"bizid", "currency", "bizispresent", "bizamount"}).finish();
            for (Row row : finish) {
                Boolean ispresent = row.getBoolean("ispresent");
                Boolean bizispresent = row.getBoolean("bizispresent");
                Long entryid = row.getLong("entryid");
                if (!ispresent.equals(bizispresent)) {
                    this.errIspresentIdSet.add(entryid);
                }
                long localcurrency = row.getLong("localcurrency");
                long currency = row.getLong("currency");
                BigDecimal amount = row.getBigDecimal("amount");
                BigDecimal costdiff = row.getBigDecimal("costdiff");
                BigDecimal calamount = amount.add(costdiff);
                BigDecimal bizamount = row.getBigDecimal("bizamount");
                if (localcurrency == currency && bizamount.compareTo(BigDecimal.ZERO) != 0 && calamount.compareTo(bizamount) != 0) {
                    this.errAmountIdSet.add(row.getLong("entryid"));
                }
                if (localcurrency == currency) continue;
                ArrayList<Number> currencyIdList = new ArrayList<Number>(4);
                currencyIdList.add(row.getLong("currency"));
                currencyIdList.add(row.getBigDecimal("bizamount"));
                currencyIdList.add(row.getLong("exratetable"));
                this.errCurrencyIdMap.put(row.getLong("entryid"), currencyIdList);
            }
        }
        catch (Throwable throwable) {
            bookDate = throwable;
            throw throwable;
        }
        finally {
            if (context != null) {
                if (bookDate != null) {
                    try {
                        context.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)bookDate).addSuppressed(throwable);
                    }
                } else {
                    context.close();
                }
            }
        }
        Iterator<Object> iterator = this.storageorgIdSet.iterator();
        while (iterator.hasNext()) {
            long storageId = iterator.next();
            DynamicObjectCollection materialInvInfs = MaterialHelper.getMaterialInvInfs(this.materialIdSet, (long)storageId);
            for (DynamicObject materialInv : materialInvInfs) {
                this.material2InvInf.put(materialInv.get("createorg") + "_" + materialInv.get("masterid"), materialInv);
                this.material2GlobalInvInf.put(storageId + "_" + materialInv.get("masterid"), materialInv);
            }
        }
        iterator = this.costAccountIdSet.iterator();
        while (iterator.hasNext()) {
            long costAccountId = iterator.next();
            if (this.costAcc2StartPeriod.get(costAccountId) == null) {
                this.costAcc2StartPeriod.put(costAccountId, PeriodHelper.getStartPeriod((Long)costAccountId));
            }
            if (this.costAcc2CalByEle.get(costAccountId) != null) continue;
            this.costAcc2CalByEle.put(costAccountId, ParamsHelper.getCostElementByCostAccount((long)costAccountId));
        }
        for (String storageorgNum : this.storageorgNumSet) {
            this.storageWarehs.put(storageorgNum, SCMHelper.getAllInUseWarehouseIDs((String)storageorgNum));
        }
    }

    private void doValidateBeforeReloadRange(ExtendedDataEntity[] billInfos, List<DynamicObject> billInfoList) {
        for (ExtendedDataEntity billInfo : billInfos) {
            String errorMsg;
            Date beginDate;
            boolean isPassCheck = true;
            DynamicObject bill = billInfo.getDataEntity();
            Date bizDate = bill.getDate("bizdate");
            Date bookDate = bill.getDate("bookdate");
            DynamicObject costAccount = bill.getDynamicObject("costaccount");
            DynamicObject calOrg = bill.getDynamicObject("calorg");
            if (costAccount == null || bizDate == null || calOrg == null || bookDate == null) continue;
            long costAccountId = costAccount.getLong("id");
            DynamicObject startPeriod = this.costAcc2StartPeriod.get(costAccountId);
            if (startPeriod == null) {
                this.addErrorMessage(billInfo, ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u6ca1\u6709\u8bbe\u7f6e\u542f\u7528\u671f\u95f4\u3002", (String)"InitCalImportValidator_0", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (bizDate.compareTo(bookDate) > 0) {
                String content = ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\u5fc5\u987b\u5c0f\u4e8e\u8bb0\u8d26\u65e5\u671f\u201c%1$s\u201d\u3002", (String)"InitCalBillSubmitOp_28", (String)"fi-cal-opplugin", (Object[])new Object[0]);
                String bookdate = new SimpleDateFormat("yyyy-MM-dd").format(bookDate);
                String format = String.format(content, bookdate);
                this.addErrorMessage(billInfo, format);
                isPassCheck = false;
            }
            if (!bizDate.before(beginDate = startPeriod.getDate("begindate"))) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\u5fc5\u987b\u5c0f\u4e8e\u6210\u672c\u8d26\u7c3f\u542f\u7528\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f\u201c%1$s\u201d\u3002", (String)"InitCalBillSubmitOp_30", (String)"fi-cal-opplugin", (Object[])new Object[0]), new SimpleDateFormat("yyyy-MM-dd").format(beginDate));
                this.addErrorMessage(billInfo, errorMsg);
                isPassCheck = false;
            }
            if (!bookDate.before(beginDate)) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u5fc5\u987b\u5c0f\u4e8e\u6210\u672c\u8d26\u7c3f\u542f\u7528\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f\u201c%1$s\u201d\u3002", (String)"InitCalBillSubmitOp_31", (String)"fi-cal-opplugin", (Object[])new Object[0]), new SimpleDateFormat("yyyy-MM-dd").format(beginDate));
                this.addErrorMessage(billInfo, errorMsg);
                isPassCheck = false;
            }
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
            HashMap errMap = new HashMap(16);
            CostTypeHelper.getCostTypeByOrg((DynamicObject[])new DynamicObject[]{bill}, (String[])COSTTYPE_FIELD, errMap);
            if (errMap.size() > 0) {
                this.addErrorMessage(billInfo, ((SynBillErrInfo)errMap.get(bill.getLong("bizbillid"))).getErrorMsg());
                continue;
            }
            int seq = 0;
            ArrayList<String> selectKeys = new ArrayList<String>(16);
            selectKeys.add("isuseauxpty");
            selectKeys.add("name");
            selectKeys.add("auxptyentry");
            MainEntityType subType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)"bd_material", selectKeys);
            Map materialInfoMap = BusinessDataServiceHelper.loadFromCache((Object[])this.materialIdSet.toArray(), (DynamicObjectType)subType);
            for (DynamicObject entry : entrys) {
                DynamicObject materialInfo;
                DynamicObjectCollection auxCol;
                String storageOrgNum;
                Long[] warehsInfos;
                boolean hasWarehs;
                ++seq;
                Date stockInDate = entry.getDate("stockindate");
                if (stockInDate == null) {
                    stockInDate = bookDate;
                } else if (!stockInDate.before(beginDate)) {
                    String errorMsg2 = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\uff0c\u5165\u5e93\u65e5\u671f\u5fc5\u987b\u5c0f\u4e8e\u6210\u672c\u8d26\u7c3f\u542f\u7528\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f\u201c%2$s\u201d\u3002", (String)"InitCalBillSubmitOp_32", (String)"fi-cal-opplugin", (Object[])new Object[0]), seq, new SimpleDateFormat("yyyy-MM-dd").format(beginDate));
                    this.addErrorMessage(billInfo, errorMsg2);
                    isPassCheck = false;
                }
                DynamicObject warehouse = entry.getDynamicObject("warehouse");
                DynamicObject material = entry.getDynamicObject("material");
                DynamicObject storageorgUnit = entry.getDynamicObject("storageorgunit");
                if (warehouse == null || material == null || storageorgUnit == null) continue;
                DynamicObject calRange = entry.getDynamicObject("calrange");
                if (calRange == null) {
                    String errorMsg3 = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\u672a\u627e\u5230\u53ef\u7528\u7684\u6838\u7b97\u8303\u56f4\u3002", (String)"InitCalBillSubmitOp_33", (String)"fi-cal-opplugin", (Object[])new Object[0]), seq);
                    this.addErrorMessage(billInfo, errorMsg3);
                    isPassCheck = false;
                    continue;
                }
                long id = entry.getLong("id");
                if (this.errIspresentIdSet.contains(id)) {
                    String errorMsg4 = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\u8d60\u54c1\u4e0e\u4e0a\u6e38\u5e93\u5b58\u5355\u636e\u8d60\u54c1\u4e0d\u4e00\u81f4\u3002", (String)"InitCalBillSubmitOp_35", (String)"fi-cal-opplugin", (Object[])new Object[0]), seq);
                    this.addErrorMessage(billInfo, errorMsg4);
                    isPassCheck = false;
                }
                String warehsName = warehouse.getString("name");
                String storageOrgName = storageorgUnit.getString("name");
                String lot = entry.getString("lot");
                DynamicObject assist = entry.getDynamicObject("assist");
                long storageOrgId = storageorgUnit.getLong("id");
                long materialId = material.getLong("id");
                String invKey = storageOrgId + "_" + materialId;
                DynamicObject materialInv = this.material2InvInf.get(invKey);
                if (materialInv == null) {
                    materialInv = this.material2GlobalInvInf.get(invKey);
                }
                if (!this.notCheckMatinvinfo) {
                    if (materialInv == null) {
                        String errorMsg5 = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\u7269\u6599\u201c%2$s\u201d\u672a\u8bbe\u7f6e\u7269\u6599\u5e93\u5b58\u4fe1\u606f\uff0c\u6216\u8005\u5df2\u8bbe\u7f6e\u4f46\u672a\u542f\u7528\u6216\u672a\u5ba1\u6838\u3002", (String)"InitCalBillSubmitOp_36", (String)"fi-cal-opplugin", (Object[])new Object[0]), seq, material.getString("name"));
                        this.addErrorMessage(billInfo, errorMsg5);
                        isPassCheck = false;
                        continue;
                    }
                    boolean enablelot = materialInv.getBoolean("enablelot");
                    if (StringUtils.isNotEmpty((String)lot) && !enablelot) {
                        String errorMsg6 = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\u7269\u6599\u201c%2$s\u201d\u7684\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u6ca1\u6709\u542f\u7528\u6279\u53f7\u7ba1\u7406\uff0c\u4f46\u662f\u5f55\u5165\u4e86\u6279\u53f7\u3002", (String)"InitCalBillSubmitOp_38", (String)"fi-cal-opplugin", (Object[])new Object[0]), seq, material.getString("name"));
                        this.addErrorMessage(billInfo, errorMsg6);
                        isPassCheck = false;
                    }
                }
                if (!(hasWarehs = OrgHelper.checkWarehs((Long[])(warehsInfos = this.storageWarehs.get(storageOrgNum = storageorgUnit.getString("number"))), (long)warehouse.getLong("id")))) {
                    String errorMsg7 = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\u7ef4\u62a4\u7684\u4ed3\u5e93\u201c%2$s\u201d\u4e0d\u5c5e\u4e8e\u5e93\u5b58\u7ec4\u7ec7\u201c%3$s\u201d\u3002", (String)"InitCalBillSubmitOp_39", (String)"fi-cal-opplugin", (Object[])new Object[0]), seq, warehsName, storageOrgName);
                    this.addErrorMessage(billInfo, errorMsg7);
                    isPassCheck = false;
                }
                if (!material.getBoolean("isuseauxpty") || (auxCol = (materialInfo = (DynamicObject)materialInfoMap.get(material.getLong("id"))).getDynamicObjectCollection("auxptyentry")) == null || auxCol.size() == 0 || assist == null) continue;
                String auxValue = assist.get("value").toString();
                try {
                    Map map = (Map)JSONUtils.cast((String)auxValue, HashMap.class);
                    int billAuxSize = map.size();
                    if (auxCol.size() == billAuxSize) continue;
                    String content = String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u7269\u6599\u4fe1\u606f\u201d\u7b2c%1$s\u884c\u201c\u8f85\u52a9\u5c5e\u6027\u201d\u3002", (String)"CostAdjustBillSubmitOp_19", (String)"fi-cal-opplugin", (Object[])new Object[0]), seq);
                    this.addErrorMessage(billInfo, content);
                    isPassCheck = false;
                }
                catch (IOException e) {
                    String content = String.format(ResManager.loadKDString((String)"\u89e3\u6790\u8f85\u52a9\u5c5e\u6027\u503c\u662f\u5f02\u5e38%1$s", (String)"CostAdjustBillSubmitOp_20", (String)"fi-cal-opplugin", (Object[])new Object[0]), e.getMessage());
                    throw new KDBizException(content);
                }
            }
            if (!isPassCheck) continue;
            billInfoList.add(bill);
        }
    }

    private void doValidateAfterReloadRange(ExtendedDataEntity[] billInfos) {
        for (ExtendedDataEntity billInfo : billInfos) {
            DynamicObject bill = billInfo.getDataEntity();
            long billId = bill.getLong("id");
            DynamicObject localcurrency = bill.getDynamicObject("localcurrency");
            long currencyId = localcurrency.getLong("id");
            int amtprecision = localcurrency.getInt("amtprecision");
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
            DynamicObject costAccount = bill.getDynamicObject("costaccount");
            boolean enableStd = costAccount.getBoolean("enablestandardcost");
            long costAccountId = costAccount.getLong("id");
            boolean calByEle = this.costAcc2CalByEle.get(costAccountId);
            int seq = 0;
            for (DynamicObject entry : entrys) {
                String errorMsg;
                String accounttype;
                long id = entry.getLong("id");
                boolean numAndAmountAllZero = this.checkEntryQtyAndCostField(billInfo, ++seq, entry);
                if (calByEle) {
                    numAndAmountAllZero = this.checkSubEntryQtyAndCostField(billInfo, seq, entry, numAndAmountAllZero);
                }
                if (numAndAmountAllZero) {
                    this.addErrorMessage(billInfo, ResManager.loadKDString((String)MessageFormat.format("\u5206\u5f55\u7b2c\u3010{0}\u3011\u884c\uff0c\u540c\u4e00\u884c\u5206\u5f55\u4e0d\u5141\u8bb8\u6570\u91cf\u3001\u91d1\u989d\u3001\u5dee\u5f02\u3001\u672c\u5e74\u7d2f\u8ba1\u6536\u5165\u6570\u91cf\u3001\u6536\u5165\u91d1\u989d\u3001\u6536\u5165\u5dee\u5f02\u3001\u672c\u5e74\u7d2f\u8ba1\u53d1\u51fa\u6570\u91cf\u3001\u53d1\u51fa\u91d1\u989d\u3001\u53d1\u51fa\u5dee\u5f02\u540c\u65f6\u4e3a0\u3002", seq), (String)"InitCalBillSubmitOp_24", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                }
                if (this.errAmountIdSet.contains(id)) {
                    String errorMsg2 = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\u6210\u672c\u4e0e\u4e0a\u6e38\u521d\u59cb\u5e93\u5b58\u5355\u4e0d\u4e00\u81f4\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u63d0\u4ea4\u3002", (String)"InitCalBillSubmitOp_40", (String)"fi-cal-opplugin", (Object[])new Object[0]), seq);
                    this.addWarningMessage(billInfo, errorMsg2);
                }
                if (this.errCurrencyIdMap.containsKey(id)) {
                    List<Object> currencyList = this.errCurrencyIdMap.get(id);
                    Long bizCurrencyId = (Long)currencyList.get(0);
                    BigDecimal bizAmount = (BigDecimal)currencyList.get(1);
                    Long exratetableId = (Long)currencyList.get(2);
                    HashMap<Long, Long> calBillExratetableMap = new HashMap<Long, Long>(2);
                    calBillExratetableMap.put(billId, exratetableId);
                    Map exchangeRateMap = SynBizBillHelper.getInitExchangeRateMap((long)currencyId, (long)bizCurrencyId, calBillExratetableMap, (DynamicObject)bill);
                    BigDecimal resultAmount = InitCalBillHelper.getResultAmount((BigDecimal)bizAmount, (Integer)amtprecision, (Map)exchangeRateMap);
                    BigDecimal amount = DecimalHelper.getNotNullDecimal((BigDecimal)entry.getBigDecimal("amount"));
                    BigDecimal costdiff = DecimalHelper.getNotNullDecimal((BigDecimal)entry.getBigDecimal("costdiff"));
                    if (bizAmount.compareTo(BigDecimal.ZERO) != 0 && resultAmount.compareTo(amount.add(costdiff)) != 0) {
                        String errorMsg3 = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\u6210\u672c\u4e0e\u4e0a\u6e38\u521d\u59cb\u5e93\u5b58\u5355\u4e0d\u4e00\u81f4\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u63d0\u4ea4\u3002", (String)"InitCalBillSubmitOp_40", (String)"fi-cal-opplugin", (Object[])new Object[0]), seq);
                        this.addWarningMessage(billInfo, errorMsg3);
                    }
                }
                if (!InitCalBillHelper.isStd((boolean)enableStd, (String)(accounttype = entry.getString("accounttype")))) continue;
                if (entry.getBigDecimal("price").compareTo(BigDecimal.ZERO) == 0) {
                    String errorMsg4 = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u5df2\u542f\u7528\u6807\u51c6\u6210\u672c\u6216\u5206\u5f55\u7b2c%1$s\u884c\u8ba1\u4ef7\u65b9\u6cd5\u4e3a\u6807\u51c6\u6210\u672c\u6cd5\uff0c\u4f46\u5355\u4ef7\u4e3a\u7a7a\uff0c\u8bf7\u524d\u5f80\u201c\u5b58\u8d27\u6838\u7b97>\u57fa\u7840\u914d\u7f6e>\u6838\u7b97\u914d\u7f6e>\u6210\u672c\u7c7b\u578b\u4e0e\u7ec4\u7ec7\u5bf9\u5e94\u8868\u201d\u7ef4\u62a4\u5bf9\u5e94\u7684\u4fe1\u606f\u540e\u91cd\u65b0\u5f55\u5355\u3002", (String)"InitCalBillSubmitOp_48", (String)"fi-cal-opplugin", (Object[])new Object[0]), seq);
                    this.addErrorMessage(billInfo, errorMsg4);
                    continue;
                }
                if (!StringUtils.isEmpty((String)entry.getString("createtype"))) continue;
                boolean hasCostDiff = false;
                BigDecimal costdiff = entry.getBigDecimal("costdiff");
                if (costdiff.compareTo(BigDecimal.ZERO) != 0) {
                    hasCostDiff = true;
                }
                if (!hasCostDiff) {
                    DynamicObjectCollection subEntrys = entry.getDynamicObjectCollection("subentryentity");
                    for (DynamicObject subEntry : subEntrys) {
                        BigDecimal subCostDiff = subEntry.getBigDecimal("sub_costdiff");
                        if (subCostDiff.compareTo(BigDecimal.ZERO) == 0) continue;
                        hasCostDiff = true;
                        break;
                    }
                }
                if (!hasCostDiff) continue;
                if (calByEle) {
                    errorMsg = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\u5bf9\u5e94\u7684\u7ed3\u8f6c\u660e\u7ec6\u6709\u5f55\u5165\u5dee\u5f02\uff0c\u5dee\u5f02\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"InitCalBillSubmitOp_42", (String)"fi-cal-opplugin", (Object[])new Object[0]), seq);
                    this.addErrorMessage(billInfo, errorMsg);
                    continue;
                }
                errorMsg = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\u6709\u5f55\u5165\u5dee\u5f02\uff0c\u5dee\u5f02\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"InitCalBillSubmitOp_43", (String)"fi-cal-opplugin", (Object[])new Object[0]), seq);
                this.addErrorMessage(billInfo, errorMsg);
            }
        }
    }

    private boolean checkEntryQtyAndCostField(ExtendedDataEntity billInfo, int seq, DynamicObject entry) {
        boolean numAndAmountAllZero = false;
        BigDecimal perQty = DecimalHelper.getNotNullDecimal((BigDecimal)entry.getBigDecimal("baseqty"));
        BigDecimal perActualCost = DecimalHelper.getNotNullDecimal((BigDecimal)entry.getBigDecimal("amount"));
        BigDecimal costdiff = DecimalHelper.getNotNullDecimal((BigDecimal)entry.getBigDecimal("costdiff"));
        BigDecimal yearInQty = DecimalHelper.getNotNullDecimal((BigDecimal)entry.getBigDecimal("yearinqty"));
        BigDecimal yearInActualCost = DecimalHelper.getNotNullDecimal((BigDecimal)entry.getBigDecimal("yearincost"));
        BigDecimal yearInCostdiff = DecimalHelper.getNotNullDecimal((BigDecimal)entry.getBigDecimal("yearincost"));
        BigDecimal yearIssueQty = DecimalHelper.getNotNullDecimal((BigDecimal)entry.getBigDecimal("yearissueqty"));
        BigDecimal yearIssueActualCost = DecimalHelper.getNotNullDecimal((BigDecimal)entry.getBigDecimal("yearissuecost"));
        BigDecimal yearIssueCostdiff = DecimalHelper.getNotNullDecimal((BigDecimal)entry.getBigDecimal("yearissuecostdiff"));
        if (perQty.compareTo(BigDecimal.ZERO) == 0 && perActualCost.compareTo(BigDecimal.ZERO) == 0 && yearInQty.compareTo(BigDecimal.ZERO) == 0 && yearInActualCost.compareTo(BigDecimal.ZERO) == 0 && yearIssueQty.compareTo(BigDecimal.ZERO) == 0 && yearIssueActualCost.compareTo(BigDecimal.ZERO) == 0 && costdiff.compareTo(BigDecimal.ZERO) == 0 && yearInCostdiff.compareTo(BigDecimal.ZERO) == 0 && yearIssueCostdiff.compareTo(BigDecimal.ZERO) == 0) {
            numAndAmountAllZero = true;
        }
        this.checkQtyAndCostField(billInfo, seq, perQty, perActualCost, yearInQty, yearInActualCost, yearIssueQty, yearIssueActualCost, true);
        return numAndAmountAllZero;
    }

    private boolean checkSubEntryQtyAndCostField(ExtendedDataEntity billInfo, int seq, DynamicObject entry, boolean numAndAmountAllZero) {
        DynamicObjectCollection subEntrys = entry.getDynamicObjectCollection("subentryentity");
        for (int i = 0; i < subEntrys.size(); ++i) {
            String errMsg;
            DynamicObject subEntry = (DynamicObject)subEntrys.get(i);
            BigDecimal perQty = DecimalHelper.getNotNullDecimal((BigDecimal)subEntry.getBigDecimal("sub_baseqty"));
            BigDecimal perActualCost = DecimalHelper.getNotNullDecimal((BigDecimal)subEntry.getBigDecimal("sub_amount"));
            BigDecimal yearInQty = DecimalHelper.getNotNullDecimal((BigDecimal)subEntry.getBigDecimal("sub_yearinqty"));
            BigDecimal yearInActualCost = DecimalHelper.getNotNullDecimal((BigDecimal)subEntry.getBigDecimal("sub_yearincost"));
            BigDecimal yearIssueQty = DecimalHelper.getNotNullDecimal((BigDecimal)subEntry.getBigDecimal("sub_yearissueqty"));
            BigDecimal yearIssueActualCost = DecimalHelper.getNotNullDecimal((BigDecimal)subEntry.getBigDecimal("sub_yearissuecost"));
            if (numAndAmountAllZero && (DecimalHelper.getNotNullDecimal((BigDecimal)subEntry.getBigDecimal("sub_costdiff")).compareTo(BigDecimal.ZERO) != 0 || DecimalHelper.getNotNullDecimal((BigDecimal)subEntry.getBigDecimal("sub_yearincostdiff")).compareTo(BigDecimal.ZERO) != 0 || DecimalHelper.getNotNullDecimal((BigDecimal)subEntry.getBigDecimal("sub_yearissuecostdiff")).compareTo(BigDecimal.ZERO) != 0)) {
                numAndAmountAllZero = false;
            }
            if (!StringUtils.isNotEmpty((String)(errMsg = this.checkQtyAndCostField(billInfo, seq, perQty, perActualCost, yearInQty, yearInActualCost, yearIssueQty, yearIssueActualCost, false)))) continue;
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c\u3010%1$s\u3011\u884c\u5bf9\u5e94\u7684\u7ed3\u8f6c\u660e\u7ec6\u7684\u7b2c\u3010%2$s\u3011\u884c", (String)"InitCalBillSubmitOp_44", (String)"fi-cal-opplugin", (Object[])new Object[0]), seq, i + 1) + errMsg.substring(0, errMsg.length() - 1);
            this.addErrorMessage(billInfo, errorMsg);
        }
        return numAndAmountAllZero;
    }

    private String checkQtyAndCostField(ExtendedDataEntity billInfo, int seq, BigDecimal perQty, BigDecimal perActualCost, BigDecimal yearInQty, BigDecimal yearInActualCost, BigDecimal yearIssueQty, BigDecimal yearIssueActualCost, boolean checkEntry) {
        String errorMsg;
        int costSignum;
        int qtySignum;
        ArrayList<String> errMsgs = new ArrayList<String>(16);
        if (perQty.compareTo(BigDecimal.ZERO) != 0 && perActualCost.compareTo(BigDecimal.ZERO) != 0 && (qtySignum = perQty.signum()) != (costSignum = perActualCost.signum())) {
            if (checkEntry) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\u57fa\u672c\u6570\u91cf\u4e0e\u91d1\u989d\u6570\u636e\u65b9\u5411\u4e0d\u4e00\u81f4\u3002", (String)"InitCalBillSubmitOp_45", (String)"fi-cal-opplugin", (Object[])new Object[0]), seq);
                this.addErrorMessage(billInfo, errorMsg);
            } else {
                String qtyAmtNotSame = ResManager.loadKDString((String)"\u57fa\u672c\u6570\u91cf\u4e0e\u91d1\u989d\u6570\u636e\u65b9\u5411\u4e0d\u4e00\u81f4\u3002", (String)"InitCalBillSubmitOp_21", (String)"fi-cal-opplugin", (Object[])new Object[0]);
                errMsgs.add(qtyAmtNotSame);
            }
        }
        if (yearInQty.compareTo(BigDecimal.ZERO) != 0 && yearInActualCost.compareTo(BigDecimal.ZERO) != 0 && (qtySignum = yearInQty.signum()) != (costSignum = yearInActualCost.signum())) {
            if (checkEntry) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\u672c\u5e74\u7d2f\u8ba1\u6536\u5165\u6570\u91cf\u4e0e\u672c\u5e74\u7d2f\u8ba1\u6536\u5165\u91d1\u989d\u6570\u636e\u65b9\u5411\u4e0d\u4e00\u81f4\u3002", (String)"InitCalBillSubmitOp_46", (String)"fi-cal-opplugin", (Object[])new Object[0]), seq);
                this.addErrorMessage(billInfo, errorMsg);
            } else {
                String yearQtyAmtNotSame = ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u6536\u5165\u6570\u91cf\u4e0e\u672c\u5e74\u7d2f\u8ba1\u6536\u5165\u91d1\u989d\u6570\u636e\u65b9\u5411\u4e0d\u4e00\u81f4\u3002", (String)"InitCalBillSubmitOp_22", (String)"fi-cal-opplugin", (Object[])new Object[0]);
                errMsgs.add(yearQtyAmtNotSame);
            }
        }
        if (yearIssueQty.compareTo(BigDecimal.ZERO) != 0 && yearIssueActualCost.compareTo(BigDecimal.ZERO) != 0 && (qtySignum = yearIssueQty.signum()) != (costSignum = yearIssueActualCost.signum())) {
            if (checkEntry) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\u672c\u5e74\u7d2f\u8ba1\u53d1\u51fa\u6570\u91cf\u4e0e\u672c\u5e74\u7d2f\u8ba1\u53d1\u51fa\u91d1\u989d\u6570\u636e\u65b9\u5411\u4e0d\u4e00\u81f4\u3002", (String)"InitCalBillSubmitOp_50", (String)"fi-cal-opplugin", (Object[])new Object[0]), seq);
                this.addErrorMessage(billInfo, errorMsg);
            } else {
                String yearOutQtyAmtNotSame = ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u53d1\u51fa\u6570\u91cf\u4e0e\u672c\u5e74\u7d2f\u8ba1\u53d1\u51fa\u91d1\u989d\u6570\u636e\u65b9\u5411\u4e0d\u4e00\u81f4\u3002", (String)"InitCalBillSubmitOp_23", (String)"fi-cal-opplugin", (Object[])new Object[0]);
                errMsgs.add(yearOutQtyAmtNotSame);
            }
        }
        return errMsgs.isEmpty() ? "" : String.join((CharSequence)",", errMsgs);
    }
}

