/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.validator;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.AccountType4CostAdjustHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.IDGenerator;
import kd.fi.cal.common.helper.InitCalBillHelper;
import kd.fi.cal.common.helper.MaterialHelper;
import kd.fi.cal.common.helper.MustInputDimHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.SCMHelper;
import kd.fi.cal.common.model.MaterialCostInfo;

public class InitCalImportValidator
extends AbstractValidator {
    public void validate() {
        DynamicObject[] policyArr;
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        int size = dataEntities.length;
        DynamicObject[] billInfoArr = new DynamicObject[size];
        HashSet<Long> materialIdSet = new HashSet<Long>(512);
        HashSet<Long> storageorgIdSet = new HashSet<Long>(16);
        HashSet<Long> costAccountIdSet = new HashSet<Long>(16);
        HashSet<String> auxkeySet = new HashSet<String>(16);
        HashSet<String> storageorgNumSet = new HashSet<String>(16);
        HashSet<Long> mversionMatSet = new HashSet<Long>(32);
        HashSet<Long> calPolicyIdSet = new HashSet<Long>(16);
        Map accountDivideDimsMap = new HashMap(16);
        HashSet<Long> accountIdSet = new HashSet<Long>(16);
        for (ExtendedDataEntity billInfo : dataEntities) {
            Long costaccountId = billInfo.getDataEntity().getLong("costaccount.id");
            if (costaccountId == null || costaccountId == 0L) continue;
            accountIdSet.add(costaccountId);
        }
        accountDivideDimsMap = MustInputDimHelper.getAccountDivideDims(accountIdSet);
        this.cacheNeedColl(dataEntities, size, billInfoArr, materialIdSet, storageorgIdSet, costAccountIdSet, auxkeySet, storageorgNumSet, mversionMatSet, calPolicyIdSet);
        int matSize = materialIdSet.size();
        HashMap<String, DynamicObject> material2InvInf = new HashMap<String, DynamicObject>(matSize);
        HashMap<String, DynamicObject> material2GlobalInvInf = new HashMap<String, DynamicObject>(matSize);
        HashMap<Long, DynamicObject> policy2CurrencyMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject policy : policyArr = BusinessDataServiceHelper.load((String)"cal_bd_calpolicy", (String)"id,currency", (QFilter[])new QFilter[]{new QFilter("id", "in", calPolicyIdSet)})) {
            policy2CurrencyMap.put(policy.getLong("id"), policy.getDynamicObject("currency"));
        }
        HashMap<String, Boolean> privateEnableLotMap = new HashMap<String, Boolean>(16);
        HashMap<String, Boolean> publiceEnableLotMap = new HashMap<String, Boolean>(16);
        Iterator iterator = storageorgIdSet.iterator();
        while (iterator.hasNext()) {
            long storageId = (Long)iterator.next();
            DynamicObjectCollection materialInvInfs = MaterialHelper.getMaterialInvInfs(materialIdSet, (long)storageId);
            for (DynamicObject materialInv : materialInvInfs) {
                long material = materialInv.getLong("masterid");
                long createorg = materialInv.getLong("createorg");
                material2InvInf.put(createorg + "_" + material, materialInv);
                material2GlobalInvInf.put(storageId + "_" + material, materialInv);
                String key = storageId + "_" + material;
                boolean enableLot = materialInv.getBoolean("enablelot");
                if (Long.compare(storageId, createorg) == 0) {
                    privateEnableLotMap.put(key, enableLot);
                    continue;
                }
                publiceEnableLotMap.put(key, enableLot);
            }
        }
        HashMap<Long, Long> material2Mversion = new HashMap<Long, Long>(mversionMatSet.size());
        DynamicObjectCollection mversionColl = MaterialHelper.getMversionColl(mversionMatSet);
        for (DynamicObject mversionDyn : mversionColl) {
            long materialId = mversionDyn.getLong("material");
            if (material2Mversion.get(materialId) != null) continue;
            material2Mversion.put(materialId, mversionDyn.getLong("id"));
        }
        HashMap<Long, DynamicObject> costAcc2StartPeriod = new HashMap<Long, DynamicObject>(costAccountIdSet.size());
        HashMap<Long, Boolean> costAcc2CalByEle = new HashMap<Long, Boolean>(costAccountIdSet.size());
        Iterator materialId = costAccountIdSet.iterator();
        while (materialId.hasNext()) {
            long costAccountId = (Long)materialId.next();
            if (costAcc2StartPeriod.get(costAccountId) == null) {
                costAcc2StartPeriod.put(costAccountId, PeriodHelper.getStartPeriod((Long)costAccountId));
            }
            if (costAcc2CalByEle.get(costAccountId) != null) continue;
            costAcc2CalByEle.put(costAccountId, ParamsHelper.getCostElementByCostAccount((long)costAccountId));
        }
        HashMap<String, Long[]> storageWarehs = new HashMap<String, Long[]>(storageorgNumSet.size());
        for (String storageorgNum : storageorgNumSet) {
            storageWarehs.put(storageorgNum, SCMHelper.getAllInUseWarehouseIDs((String)storageorgNum));
        }
        ArrayList<String> selectKeys = new ArrayList<String>(16);
        selectKeys.add("isuseauxpty");
        selectKeys.add("name");
        selectKeys.add("auxptyentry");
        MainEntityType subType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)"bd_material", selectKeys);
        Map materialInfoMap = BusinessDataServiceHelper.loadFromCache((Object[])materialIdSet.toArray(), (DynamicObjectType)subType);
        new AccountType4CostAdjustHelper(billInfoArr).handleCalRangeAccType4InitBill();
        Map stdMaterialMap = InitCalBillHelper.cacheMatCostInfoMap((DynamicObject[])billInfoArr);
        Set defaultMatchElement = CostElementHelper.getAllCostEleStr();
        HashSet<String> dataEntityEle = new HashSet<String>(8);
        ArrayList<String> stdEleStrList = new ArrayList<String>(8);
        for (ExtendedDataEntity billInfo : dataEntities) {
            DynamicObjectCollection entrys;
            String errorMsg;
            DynamicObject bill = billInfo.getDataEntity();
            Date bizDate = bill.getDate("bizdate");
            Date bookDate = bill.getDate("bookdate");
            DynamicObject costAccount = bill.getDynamicObject("costaccount");
            DynamicObject calOrg = bill.getDynamicObject("calorg");
            if (costAccount == null || bizDate == null || calOrg == null || bookDate == null) continue;
            Set divdeAndDimensioDims = (Set)accountDivideDimsMap.get(costAccount.getLong("id"));
            long costAccountId = costAccount.getLong("id");
            boolean enableStd = costAccount.getBoolean("enablestandardcost");
            DynamicObject startPeriod = (DynamicObject)costAcc2StartPeriod.get(costAccountId);
            if (startPeriod == null) {
                this.addErrorMessage(billInfo, ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u6ca1\u6709\u8bbe\u7f6e\u542f\u7528\u671f\u95f4\u3002", (String)"InitCalImportValidator_0", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                continue;
            }
            Date beginDate = startPeriod.getDate("begindate");
            if (!bizDate.before(beginDate)) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\u5fc5\u987b\u5c0f\u4e8e\u6210\u672c\u8d26\u7c3f\u542f\u7528\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f\u201c%1$s\u201d\u3002", (String)"InitCalImportValidator_43", (String)"fi-cal-opplugin", (Object[])new Object[0]), new SimpleDateFormat("yyyy-MM-dd").format(beginDate));
                this.addErrorMessage(billInfo, errorMsg);
            }
            if (!bookDate.before(beginDate)) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u5fc5\u987b\u5c0f\u4e8e\u6210\u672c\u8d26\u7c3f\u542f\u7528\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f\u201c%1$s\u201d\u3002", (String)"InitCalImportValidator_44", (String)"fi-cal-opplugin", (Object[])new Object[0]), new SimpleDateFormat("yyyy-MM-dd").format(beginDate));
                this.addErrorMessage(billInfo, errorMsg);
            }
            if ((entrys = bill.getDynamicObjectCollection("entryentity")) == null || entrys.isEmpty()) {
                this.addErrorMessage(billInfo, ResManager.loadKDString((String)"\u5355\u636e\u5fc5\u987b\u81f3\u5c11\u6709\u4e00\u884c\u5355\u636e\u4f53\u3002", (String)"InitCalImportValidator_3", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                continue;
            }
            boolean calByEle = (Boolean)costAcc2CalByEle.get(costAccountId);
            DynamicObject localCurrency = (DynamicObject)policy2CurrencyMap.get(costAccount.getLong("calpolicy.id"));
            if (localCurrency == null) {
                this.addErrorMessage(billInfo, ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u7684\u6838\u7b97\u653f\u7b56\u672c\u4f4d\u5e01\u4e3a\u7a7a\u3002", (String)"InitCalImportValidator_14", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                continue;
            }
            for (DynamicObject entry : entrys) {
                String accType;
                boolean isStd;
                Boolean enablelot;
                DynamicObject warehouse = entry.getDynamicObject("warehouse");
                DynamicObject material = entry.getDynamicObject("material");
                DynamicObject storageorgUnit = entry.getDynamicObject("storageorgunit");
                if (material == null || storageorgUnit == null) continue;
                if (warehouse != null) {
                    String storageOrgNum = storageorgUnit.getString("number");
                    Long[] warehsInfos = (Long[])storageWarehs.get(storageOrgNum);
                    boolean hasWarehs = OrgHelper.checkWarehs((Long[])warehsInfos, (long)warehouse.getLong("id"));
                    if (!hasWarehs) {
                        this.addErrorMessage(billInfo, ResManager.loadKDString((String)"\u5f55\u5165\u7684\u4ed3\u5e93\u4e0d\u5c5e\u4e8e\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"InitCalImportValidator_9", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    }
                } else if (entry.getDynamicObject("location") != null) {
                    String errorMsg2 = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\uff0c\u672a\u5f55\u5165\u4ed3\u5e93\uff0c\u4f46\u662f\u5f55\u5165\u4e86\u4ed3\u4f4d\u3002", (String)"CostAdjustBillImportValidator_24", (String)"fi-cal-opplugin", (Object[])new Object[0]), entry.get("seq"));
                    this.addErrorMessage(billInfo, errorMsg2);
                }
                long storageOrgId = storageorgUnit.getLong("id");
                long materialId2 = material.getLong("id");
                String materialName = material.getString("name");
                String lot = entry.getString("lot");
                DynamicObject assist = entry.getDynamicObject("assist");
                String invKey = storageOrgId + "_" + materialId2;
                DynamicObject materialInvInf = (DynamicObject)material2InvInf.get(invKey);
                if (materialInvInf == null) {
                    materialInvInf = (DynamicObject)material2GlobalInvInf.get(invKey);
                }
                if (materialInvInf == null) {
                    this.addErrorMessage(billInfo, ResManager.loadKDString((String)"\u7269\u6599\u672a\u8bbe\u7f6e\u7269\u6599\u5e93\u5b58\u4fe1\u606f\uff0c\u6216\u8005\u5df2\u8bbe\u7f6e\u4f46\u672a\u542f\u7528\u6216\u672a\u5ba1\u6838\u3002", (String)"InitCalImportValidator_5", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                }
                if ((enablelot = (Boolean)privateEnableLotMap.get(invKey)) == null) {
                    enablelot = (Boolean)publiceEnableLotMap.get(invKey);
                }
                if (enablelot == null) {
                    enablelot = false;
                }
                if (StringUtils.isNotEmpty((String)lot) && !enablelot.booleanValue()) {
                    this.addErrorMessage(billInfo, ResManager.loadKDString((String)"\u7269\u6599\u5e93\u5b58\u7b56\u7565\u6ca1\u6709\u542f\u7528\u6279\u53f7\u7ba1\u7406\uff0c\u4f46\u662f\u5f55\u5165\u4e86\u6279\u53f7\u3002", (String)"InitCalImportValidator_7", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                }
                this.verifyAssist(billInfo, auxkeySet, entry, material, assist, materialInfoMap);
                boolean needCal = entry.getDynamicObject("invtype").getBoolean("isforwardamount");
                if (!needCal) {
                    this.addErrorMessage(billInfo, ResManager.loadKDString((String)"\u5f55\u5165\u7684\u5e93\u5b58\u7c7b\u578b\u4e3a\u4e0d\u53c2\u4e0e\u5b58\u8d27\u6838\u7b97\u3002", (String)"InitCalImportValidator_20", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                }
                if (isStd = InitCalBillHelper.isStd((boolean)enableStd, (String)(accType = entry.getString("accounttype")))) {
                    List stdCostInf = InitCalBillHelper.getStdCostInfFromMap((Map)stdMaterialMap, (DynamicObject)entry);
                    if (stdCostInf == null) {
                        String msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u5df2\u542f\u7528\u6807\u51c6\u6210\u672c\u6216\u7269\u6599\u8ba1\u4ef7\u65b9\u6cd5\u4e3a\u6807\u51c6\u6210\u672c\u6cd5\uff0c\u4f46\u672a\u7ef4\u62a4\u7269\u6599\u201c%1$s\u201d\u7684\u6210\u672c\u4fe1\u606f\uff0c\u6216\u5df2\u7ef4\u62a4\u4f46\u7269\u6599\u5c5e\u6027\u4e0e\u6210\u672c\u4fe1\u606f\u4e0d\u4e00\u81f4\u3002", (String)"InitCalImportValidator_18", (String)"fi-cal-opplugin", (Object[])new Object[0]), materialName);
                        this.addErrorMessage(billInfo, msg);
                    } else {
                        for (MaterialCostInfo costInfo : stdCostInf) {
                            stdEleStrList.add(costInfo.getElementId() + "|" + costInfo.getSubElementId());
                        }
                    }
                }
                Set elementMatchList = defaultMatchElement;
                this.checkEntryAndSubEntry(billInfo, calByEle, entry, isStd, dataEntityEle, elementMatchList, stdEleStrList, material, localCurrency);
            }
        }
    }

    private void checkEntryAndSubEntry(ExtendedDataEntity billInfo, boolean calByEle, DynamicObject entry, boolean isStd, Set<String> dataEntityEle, Set<String> elementMatchList, List<String> stdEleStrList, DynamicObject material, DynamicObject localCurrency) {
        String errorMsg;
        boolean isEntryImportDiff;
        boolean yearIssueCostIsZero;
        String materialName = material.getString("name");
        int priceprecision = localCurrency.getInt("priceprecision");
        BigDecimal entryPrice = entry.getBigDecimal("price");
        boolean entryPriceIsZero = entryPrice.compareTo(BigDecimal.ZERO) == 0;
        BigDecimal entryQty = entry.getBigDecimal("baseqty");
        boolean entryQtyIsZero = entryQty.compareTo(BigDecimal.ZERO) == 0;
        BigDecimal entryAmount = entry.getBigDecimal("amount");
        boolean entryAmountIsZero = entryAmount.compareTo(BigDecimal.ZERO) == 0;
        BigDecimal entryDiff = entry.getBigDecimal("costdiff");
        boolean entryDiffIsZero = entryDiff.compareTo(BigDecimal.ZERO) == 0;
        BigDecimal entryYearInQty = entry.getBigDecimal("yearinqty");
        BigDecimal entryYearInCost = entry.getBigDecimal("yearincostdiff");
        boolean yearInCostIsZero = entryYearInCost.compareTo(BigDecimal.ZERO) == 0;
        BigDecimal entryYearIssueQty = entry.getBigDecimal("yearissueqty");
        BigDecimal entryYearIssueCost = entry.getBigDecimal("yearissuecost");
        boolean bl = yearIssueCostIsZero = entryYearIssueCost.compareTo(BigDecimal.ZERO) == 0;
        if (!isStd && !calByEle) {
            this.checkDataConsistency(billInfo, entryQty, entryAmount, entryYearInQty, entryYearInCost, entryYearIssueQty, entryYearIssueCost);
            if (!this.checkPrecision(billInfo, localCurrency, entryPrice, entryQty, entryAmount, materialName)) {
                return;
            }
        }
        boolean isInputCostDiff = false;
        boolean isElementRepeat = false;
        boolean isElementNotMatch = false;
        boolean isImportDiff = false;
        boolean isImportErrPrice = false;
        boolean isEntryImportAmount = false;
        boolean isErrAlgo = false;
        String errAlgoMsg = "";
        boolean bl2 = isEntryImportDiff = !entryDiffIsZero || entry.getBigDecimal("yearincostdiff").compareTo(BigDecimal.ZERO) != 0 || entry.getBigDecimal("yearissuecostdiff").compareTo(BigDecimal.ZERO) != 0;
        if (!isStd && isEntryImportDiff) {
            isImportDiff = true;
            String errorMsg2 = String.format(ResManager.loadKDString((String)"\u975e\u6807\u51c6\u6210\u672c\u6cd5\u7269\u6599\u201c%1$s\u201d\u5355\u636e\u4f53\u4e0d\u53ef\u5f55\u5165\u5dee\u5f02\u6216\u672c\u5e74\u7d2f\u8ba1\u5dee\u5f02\u503c\u3002", (String)"InitCalImportValidator_45", (String)"fi-cal-opplugin", (Object[])new Object[0]), materialName);
            this.addErrorMessage(billInfo, errorMsg2);
        }
        boolean hasSubPriceNoAmt = false;
        if (calByEle) {
            String errorMsg3;
            if (isStd && isEntryImportDiff) {
                errorMsg3 = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u7684\u6838\u7b97\u653f\u7b56\u5df2\u5f00\u542f\u5206\u9879\u7ed3\u8f6c\uff0c\u7269\u6599\u201c%1$s\u201d\u5355\u636e\u4f53\u4e0d\u53ef\u5f55\u5165\u5dee\u5f02\u6216\u672c\u5e74\u7d2f\u8ba1\u5dee\u5f02\u503c\uff0c\u8bf7\u5728\u6210\u672c\u7ed3\u8f6c\u660e\u7ec6\u5f55\u503c\u3002", (String)"InitCalImportValidator_46", (String)"fi-cal-opplugin", (Object[])new Object[0]), materialName);
                this.addErrorMessage(billInfo, errorMsg3);
            }
            if (!yearInCostIsZero || !yearIssueCostIsZero) {
                errorMsg3 = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u7684\u6838\u7b97\u653f\u7b56\u5df2\u5f00\u542f\u5206\u9879\u7ed3\u8f6c\uff0c\u7269\u6599\u201c%1$s\u201d\u5355\u636e\u4f53\u4e0d\u53ef\u5f55\u672c\u5e74\u7d2f\u8ba1\u91d1\u989d\u503c\uff0c\u8bf7\u5728\u6210\u672c\u7ed3\u8f6c\u660e\u7ec6\u5f55\u503c\u3002", (String)"InitCalImportValidator_47", (String)"fi-cal-opplugin", (Object[])new Object[0]), materialName);
                this.addErrorMessage(billInfo, errorMsg3);
            }
            if (!entryPriceIsZero || !entryAmountIsZero) {
                isEntryImportAmount = true;
            }
            int amtprecision = localCurrency.getInt("amtprecision");
            DynamicObjectCollection subEntrys = entry.getDynamicObjectCollection("subentryentity");
            for (DynamicObject subEntry : subEntrys) {
                BigDecimal importSubamount;
                BigDecimal calAmout;
                boolean yearCostDiff;
                boolean hasCostDiff;
                boolean subamountIsZero;
                DynamicObject costelement = subEntry.getDynamicObject("costelement");
                DynamicObject subElement = subEntry.getDynamicObject("costsubelement");
                BigDecimal subprice = subEntry.getBigDecimal("sub_price");
                boolean subpriceIsZero = subprice.compareTo(BigDecimal.ZERO) == 0;
                BigDecimal subamount = subEntry.getBigDecimal("sub_amount");
                boolean bl3 = subamountIsZero = subamount.compareTo(BigDecimal.ZERO) == 0;
                if (!hasSubPriceNoAmt && !isStd && !subpriceIsZero && subamountIsZero) {
                    hasSubPriceNoAmt = true;
                }
                boolean bl4 = hasCostDiff = subEntry.getBigDecimal("sub_costdiff").compareTo(BigDecimal.ZERO) != 0;
                if (!isInputCostDiff && hasCostDiff) {
                    isInputCostDiff = true;
                }
                if (costelement == null || subElement == null) continue;
                String elementStr = costelement.getLong("id") + "|" + subElement.getLong("id");
                if (!isElementRepeat && !dataEntityEle.add(elementStr)) {
                    isElementRepeat = true;
                    String repeatErr = String.format(ResManager.loadKDString((String)"\u540c\u4e00\u5355\u636e\u4f53\u7269\u6599\u201c%1$s\u201d\u5bf9\u5e94\u7684\u6210\u672c\u5b50\u8981\u7d20\u201c%2$s\u201d\u5b58\u5728\u91cd\u590d\u3002", (String)"InitCalImportValidator_49", (String)"fi-cal-opplugin", (Object[])new Object[0]), materialName, subElement.getString("name"));
                    this.addErrorMessage(billInfo, repeatErr);
                }
                if (!(isElementNotMatch || elementMatchList.contains(elementStr) || isStd)) {
                    isElementNotMatch = true;
                    String notMatchErr = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u7684\u6210\u672c\u8981\u7d20\u201c%2$s\u201d\u4e0e\u5b50\u8981\u7d20\u201c%3$s\u201d\u4e0d\u662f\u5339\u914d\u5173\u7cfb\u3002", (String)"InitCalImportValidator_50", (String)"fi-cal-opplugin", (Object[])new Object[0]), materialName, costelement.getString("name"), subElement.getString("name"));
                    this.addErrorMessage(billInfo, notMatchErr);
                }
                boolean bl5 = yearCostDiff = subEntry.getBigDecimal("sub_yearincostdiff").compareTo(BigDecimal.ZERO) != 0 || subEntry.getBigDecimal("sub_yearissuecostdiff").compareTo(BigDecimal.ZERO) != 0;
                if (!isImportDiff && !isStd && (hasCostDiff || yearCostDiff)) {
                    isImportDiff = true;
                    String errorMsg4 = String.format(ResManager.loadKDString((String)"\u975e\u6807\u51c6\u6210\u672c\u6cd5\u7269\u6599\u201c%1$s\u201d\u7684\u7ed3\u8f6c\u660e\u7ec6\u4e0d\u53ef\u5f55\u5165\u5dee\u5f02\u6216\u672c\u5e74\u7d2f\u8ba1\u5dee\u5f02\u503c\u3002", (String)"InitCalImportValidator_51", (String)"fi-cal-opplugin", (Object[])new Object[0]), materialName);
                    this.addErrorMessage(billInfo, errorMsg4);
                }
                if (isStd || entryQtyIsZero || subpriceIsZero || subamountIsZero || (calAmout = subprice.multiply(entryQty).setScale(amtprecision, RoundingMode.HALF_UP)).compareTo(importSubamount = subamount.setScale(amtprecision, RoundingMode.HALF_UP)) == 0) continue;
                isErrAlgo = true;
                errAlgoMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u7684\u5355\u636e\u4f53\u6570\u91cf%2$s\u4e58\u4ee5\u7ed3\u8f6c\u660e\u7ec6\u5355\u4ef7%3$s\u4e0d\u7b49\u4e8e\u7ed3\u8f6c\u660e\u7ec6\u91d1\u989d%4$s\u3002", (String)"InitCalImportValidator_52", (String)"fi-cal-opplugin", (Object[])new Object[0]), materialName, entryQty.stripTrailingZeros().toPlainString(), subprice.stripTrailingZeros().toPlainString(), subamount.stripTrailingZeros().toPlainString());
                break;
            }
        } else {
            if (entryDiff.compareTo(BigDecimal.ZERO) != 0) {
                isInputCostDiff = true;
            }
            if (!(!isStd || entryPriceIsZero && entryAmountIsZero)) {
                isEntryImportAmount = true;
            }
        }
        dataEntityEle.clear();
        stdEleStrList.clear();
        if (isEntryImportAmount) {
            if (!isStd) {
                String errorMsg5 = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u7684\u6838\u7b97\u653f\u7b56\u5df2\u5f00\u542f\u5206\u9879\u7ed3\u8f6c\uff0c\u7269\u6599\u201c%1$s\u201d\u5355\u636e\u4f53\u4e0d\u53ef\u5f55\u5165\u5355\u4ef7\u548c\u91d1\u989d\u53ea\u9700\u5f55\u6570\u91cf\uff0c\u6839\u636e\u7269\u6599\u6210\u672c\u4fe1\u606f\u81ea\u52a8\u8ba1\u7b97\u91d1\u989d\u3002", (String)"InitCalImportValidator_53", (String)"fi-cal-opplugin", (Object[])new Object[0]), materialName);
                this.addErrorMessage(billInfo, errorMsg5);
            } else {
                String errorMsg6 = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u5df2\u542f\u7528\u6807\u51c6\u6210\u672c\u6216\u8ba1\u4ef7\u65b9\u6cd5\u4e3a\u6807\u51c6\u6210\u672c\u6cd5\uff0c\u7269\u6599\u201c%1$s\u201d\u5355\u636e\u4f53\u4e0d\u53ef\u5f55\u5165\u5355\u4ef7\u548c\u91d1\u989d\u53ea\u9700\u5f55\u6570\u91cf\uff0c\u6839\u636e\u7ed3\u8f6c\u660e\u7ec6\u7684\u5355\u4ef7\u81ea\u52a8\u8ba1\u7b97\u91d1\u989d\u3002", (String)"InitCalImportValidator_54", (String)"fi-cal-opplugin", (Object[])new Object[0]), materialName);
                this.addErrorMessage(billInfo, errorMsg6);
            }
        }
        if (entryQtyIsZero && hasSubPriceNoAmt) {
            String errorMsg7 = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u7ed3\u8f6c\u660e\u7ec6\u5f55\u4e86\u5355\u4ef7\uff0c\u5355\u636e\u4f53\u672a\u5f55\u5165\u6570\u91cf\u3002", (String)"InitCalImportValidator_55", (String)"fi-cal-opplugin", (Object[])new Object[0]), materialName);
            this.addErrorMessage(billInfo, errorMsg7);
        }
        if (isErrAlgo) {
            this.addErrorMessage(billInfo, ResManager.loadKDString((String)errAlgoMsg, (String)"InitCalImportValidator_36", (String)"fi-cal-opplugin", (Object[])new Object[0]));
        }
        String createType = entry.getString("createtype");
        if (isImportDiff) {
            return;
        }
        if (isInputCostDiff && StringUtils.isEmpty((String)createType)) {
            if (calByEle) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u6210\u672c\u7ed3\u8f6c\u660e\u7ec6\u5f55\u5165\u5dee\u5f02\u65f6\uff0c\u5355\u636e\u4f53\u7684\u5dee\u5f02\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"InitCalImportValidator_56", (String)"fi-cal-opplugin", (Object[])new Object[0]), materialName);
                this.addErrorMessage(billInfo, errorMsg);
            } else {
                errorMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u5355\u636e\u4f53\u5f55\u5165\u5dee\u5f02\u65f6\uff0c\u5dee\u5f02\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"InitCalImportValidator_57", (String)"fi-cal-opplugin", (Object[])new Object[0]), new Object[0]);
                this.addErrorMessage(billInfo, errorMsg);
            }
        } else if (!isInputCostDiff && !StringUtils.isEmpty((String)createType)) {
            if (calByEle) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u6210\u672c\u7ed3\u8f6c\u660e\u7ec6\u672a\u5f55\u5165\u5dee\u5f02\u65f6\uff0c\u5355\u636e\u4f53\u7684\u5dee\u5f02\u7c7b\u578b\u4e0d\u5141\u8bb8\u5f55\u5165\u503c\u3002", (String)"InitCalImportValidator_58", (String)"fi-cal-opplugin", (Object[])new Object[0]), materialName);
                this.addErrorMessage(billInfo, errorMsg);
            } else {
                errorMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u5355\u636e\u4f53\u672a\u5f55\u5165\u5dee\u5f02\u65f6\uff0c\u5dee\u5f02\u7c7b\u578b\u4e0d\u5141\u8bb8\u5f55\u5165\u503c\u3002", (String)"InitCalImportValidator_59", (String)"fi-cal-opplugin", (Object[])new Object[0]), materialName);
                this.addErrorMessage(billInfo, errorMsg);
            }
        }
    }

    private boolean checkPrecision(ExtendedDataEntity billInfo, DynamicObject localCurrency, BigDecimal price, BigDecimal qty, BigDecimal amount, String materialName) {
        String errorMsg;
        boolean verifyCorrect = true;
        if (amount.compareTo(BigDecimal.ZERO) != 0) {
            int priceprecision;
            BigDecimal calprice;
            BigDecimal calAmount;
            int amtprecision = localCurrency.getInt("amtprecision");
            if (amount.stripTrailingZeros().scale() > amtprecision) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u5bf9\u5e94\u5e01\u79cd\u7684\u91d1\u989d\u7cbe\u5ea6\u662f\u201c%1$s\u201d\uff0c\u5355\u636e\u4f53\u5f55\u5165\u7684\u91d1\u989d\u201c%2$s\u201d\u7cbe\u5ea6\u4e0d\u6b63\u786e\u3002", (String)"InitCalImportValidator_60", (String)"fi-cal-opplugin", (Object[])new Object[0]), amtprecision, amount.stripTrailingZeros().toPlainString());
                this.addErrorMessage(billInfo, errorMsg);
                verifyCorrect = false;
            } else if (price.compareTo(BigDecimal.ZERO) != 0 && qty.compareTo(BigDecimal.ZERO) != 0 && (calAmount = price.multiply(qty).setScale(amtprecision, RoundingMode.HALF_UP)).compareTo(amount) != 0 && (calprice = amount.divide(qty, priceprecision = localCurrency.getInt("amtprecision"), RoundingMode.HALF_UP)).compareTo(price) != 0) {
                this.addErrorMessage(billInfo, ResManager.loadKDString((String)MessageFormat.format("\u5355\u636e\u4f53\u9700\u6ee1\u8db3\u6570\u91cf*\u5355\u4ef7=\u91d1\u989d \u6216\u8005 \u91d1\u989d/\u6570\u91cf =\u5355\u4ef7\u3002", calAmount, amount.stripTrailingZeros().toPlainString()), (String)"InitCalImportValidator_37", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                verifyCorrect = false;
            }
        } else if (price.compareTo(BigDecimal.ZERO) != 0 && qty.compareTo(BigDecimal.ZERO) == 0) {
            this.addErrorMessage(billInfo, ResManager.loadKDString((String)"\u5355\u636e\u4f53\u53ea\u5f55\u4e86\u5355\u4ef7\uff0c\u672a\u5f55\u5165\u6570\u91cf\u6216\u91d1\u989d\uff0c\u6570\u636e\u65e0\u6548\u3002", (String)"InitCalImportValidator_38", (String)"fi-cal-opplugin", (Object[])new Object[0]));
            verifyCorrect = false;
        }
        if (price.compareTo(BigDecimal.ZERO) != 0) {
            int priceprecision = localCurrency.getInt("priceprecision");
            if (price.stripTrailingZeros().scale() > priceprecision) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u5bf9\u5e94\u5e01\u79cd\u7684\u5355\u4ef7\u7cbe\u5ea6\u662f\u201c%1$s\u201d\uff0c\u7269\u6599\u201c%2$s\u201d\u5355\u636e\u4f53\u5f55\u5165\u7684\u5355\u4ef7\u201c%3$s\u201d\u7cbe\u5ea6\u4e0d\u6b63\u786e\u3002", (String)"InitCalImportValidator_61", (String)"fi-cal-opplugin", (Object[])new Object[0]), priceprecision, materialName, price.stripTrailingZeros().toPlainString());
                this.addErrorMessage(billInfo, errorMsg);
                verifyCorrect = false;
            }
        }
        return verifyCorrect;
    }

    private Map<Long, Set<String>> cacheMat4Element(Set<Long> stdMaterialSet, Map<String, List<MaterialCostInfo>> stdMaterialMap) {
        HashMap<Long, Set<String>> mat4Element = new HashMap<Long, Set<String>>(stdMaterialSet.size());
        for (Map.Entry<String, List<MaterialCostInfo>> stdMatEntry : stdMaterialMap.entrySet()) {
            String key = stdMatEntry.getKey();
            List<MaterialCostInfo> matCostInfList = stdMatEntry.getValue();
            String[] keyArr = key.split("\\|");
            long materialId = Long.parseLong(keyArr[1]);
            HashSet<String> elementMatchList = (HashSet<String>)mat4Element.get(materialId);
            if (elementMatchList == null) {
                elementMatchList = new HashSet<String>(8);
            }
            for (MaterialCostInfo costInfo : matCostInfList) {
                elementMatchList.add(costInfo.getElementId() + "|" + costInfo.getSubElementId());
            }
            mat4Element.put(materialId, elementMatchList);
        }
        return mat4Element;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyAssist(ExtendedDataEntity billInfo, Set<String> auxkeySet, DynamicObject entry, DynamicObject material, DynamicObject assist, Map<Object, DynamicObject> materialInfoMap) {
        if (material.getBoolean("isuseauxpty")) {
            DynamicObject materialInfo = materialInfoMap.get(material.getLong("id"));
            DynamicObjectCollection auxCol = materialInfo.getDynamicObjectCollection("auxptyentry");
            if (auxCol == null || auxCol.size() == 0 || assist == null) return;
            String auxValue = assist.get("value").toString();
            try {
                Map map = (Map)JSONUtils.cast((String)auxValue, HashMap.class);
                int billAuxSize = map.size();
                if (auxCol.size() == billAuxSize) return;
                String errorMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u5b8c\u6574\u5f55\u5165\u7269\u6599\u201c%1$s\u201d\u7684\u201c\u8f85\u52a9\u5c5e\u6027\u201d\u3002", (String)"InitCalImportValidator_8", (String)"fi-cal-opplugin", (Object[])new Object[0]), material.getLocaleString("name"));
                this.addErrorMessage(billInfo, errorMsg);
                return;
            }
            catch (IOException e) {
                String msg = String.format(ResManager.loadKDString((String)"\u89e3\u6790\u8f85\u52a9\u5c5e\u6027\u503c\u662f\u5f02\u5e38%1$s", (String)"CostAdjustBillSubmitOp_21", (String)"fi-cal-opplugin", (Object[])new Object[0]), e.getMessage());
                throw new KDBizException(msg);
            }
        } else {
            if (assist == null) return;
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u884c\u53f7\u3010%1$s\u3011\uff0c\u7269\u6599\u3010%2$s\u3011\u672a\u542f\u7528\u8f85\u52a9\u5c5e\u6027\uff0c\u4f46\u662f\u5f55\u5165\u4e86\u8f85\u52a9\u5c5e\u6027\u503c\u3002", (String)"CostAdjustBillImportValidator_28", (String)"fi-cal-opplugin", (Object[])new Object[0]), entry.get("seq"), material.getLocaleString("name"));
            this.addErrorMessage(billInfo, errorMsg);
        }
    }

    private void checkDataConsistency(ExtendedDataEntity billInfo, BigDecimal baseqty, BigDecimal amount, BigDecimal yearInQty, BigDecimal yearInActualCost, BigDecimal yearIssueQty, BigDecimal yearIssueActualCost) {
        int costSignum;
        int qtySignum;
        if (baseqty.compareTo(BigDecimal.ZERO) == 0 && amount.compareTo(BigDecimal.ZERO) == 0 && yearInQty.compareTo(BigDecimal.ZERO) == 0 && yearInActualCost.compareTo(BigDecimal.ZERO) == 0 && yearIssueQty.compareTo(BigDecimal.ZERO) == 0 && yearIssueActualCost.compareTo(BigDecimal.ZERO) == 0) {
            this.addErrorMessage(billInfo, ResManager.loadKDString((String)"\u540c\u4e00\u884c\u5355\u636e\u4f53\u4e0d\u5141\u8bb8\u6570\u91cf\u3001\u91d1\u989d\u3001\u672c\u5e74\u7d2f\u8ba1\u6536\u5165\u6570\u91cf\u3001\u6536\u5165\u91d1\u989d\u3001\u672c\u5e74\u7d2f\u8ba1\u53d1\u51fa\u6570\u91cf\u3001\u53d1\u51fa\u91d1\u989d\u540c\u65f6\u4e3a0\u3002", (String)"InitCalImportValidator_10", (String)"fi-cal-opplugin", (Object[])new Object[0]));
        }
        if (baseqty.compareTo(BigDecimal.ZERO) != 0 && amount.compareTo(BigDecimal.ZERO) != 0 && (qtySignum = baseqty.signum()) != (costSignum = amount.signum())) {
            this.addErrorMessage(billInfo, ResManager.loadKDString((String)"\u57fa\u672c\u6570\u91cf\u4e0e\u91d1\u989d\u7684\u6570\u636e\u65b9\u5411\u4e0d\u4e00\u81f4\u3002", (String)"InitCalImportValidator_11", (String)"fi-cal-opplugin", (Object[])new Object[0]));
        }
        if (yearInQty.compareTo(BigDecimal.ZERO) != 0 && yearInActualCost.compareTo(BigDecimal.ZERO) != 0 && (qtySignum = yearInQty.signum()) != (costSignum = yearInActualCost.signum())) {
            this.addErrorMessage(billInfo, ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u6536\u5165\u6570\u91cf\u4e0e\u672c\u5e74\u7d2f\u8ba1\u6536\u5165\u91d1\u989d\u7684\u6570\u636e\u65b9\u5411\u4e0d\u4e00\u81f4\u3002", (String)"InitCalImportValidator_12", (String)"fi-cal-opplugin", (Object[])new Object[0]));
        }
        if (yearIssueQty.compareTo(BigDecimal.ZERO) != 0 && yearIssueActualCost.compareTo(BigDecimal.ZERO) != 0 && (qtySignum = yearIssueQty.signum()) != (costSignum = yearIssueActualCost.signum())) {
            this.addErrorMessage(billInfo, ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u53d1\u51fa\u6570\u91cf\u4e0e\u672c\u5e74\u7d2f\u8ba1\u53d1\u51fa\u91d1\u989d\u7684\u6570\u636e\u65b9\u5411\u4e0d\u4e00\u81f4\u3002", (String)"InitCalImportValidator_13", (String)"fi-cal-opplugin", (Object[])new Object[0]));
        }
    }

    private void cacheNeedColl(ExtendedDataEntity[] dataEntities, int size, DynamicObject[] billInfoArr, Set<Long> materialIdSet, Set<Long> storageorgIdSet, Set<Long> costAccountIdSet, Set<String> auxkeySet, Set<String> storageorgNumSet, Set<Long> mversionMatSet, Set<Long> calPolicyIdSet) {
        for (int i = 0; i < size; ++i) {
            DynamicObject bill;
            billInfoArr[i] = bill = dataEntities[i].getDataEntity();
            Date bizDate = bill.getDate("bizdate");
            DynamicObject costAccount = bill.getDynamicObject("costaccount");
            DynamicObject calOrg = bill.getDynamicObject("calorg");
            if (costAccount == null || bizDate == null || calOrg == null) continue;
            costAccountIdSet.add(costAccount.getLong("id"));
            calPolicyIdSet.add(costAccount.getLong("calpolicy_id"));
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
            if (entrys == null || entrys.isEmpty()) continue;
            IDGenerator eIdGenerator = new IDGenerator("t_cal_initbillentry");
            for (DynamicObject entry : entrys) {
                long entryId = entry.getLong("id");
                if (entryId == 0L) {
                    entry.set("id", (Object)eIdGenerator.getId());
                }
                DynamicObject warehouse = entry.getDynamicObject("warehouse");
                DynamicObject material = entry.getDynamicObject("material");
                DynamicObject storageorgUnit = entry.getDynamicObject("storageorgunit");
                if (material == null || storageorgUnit == null) continue;
                costAccountIdSet.add(costAccount.getLong("id"));
                long materialId = material.getLong("id");
                materialIdSet.add(materialId);
                if (material.getBoolean("isenablematerialversion")) {
                    mversionMatSet.add(materialId);
                }
                storageorgIdSet.add(storageorgUnit.getLong("id"));
                storageorgNumSet.add(storageorgUnit.getString("number"));
                DynamicObject auxpty = entry.getDynamicObject("assist");
                if (auxpty == null) continue;
                Map jsonMap = (Map)SerializationUtils.fromJsonString((String)auxpty.getString("value"), Map.class);
                auxkeySet.addAll(jsonMap.keySet());
            }
        }
    }
}

