/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class InitProvBillValidator
extends AbstractValidator {
    public void validate() {
        HashMap billIndexCalOrgAccountMap = new HashMap(16);
        HashSet<Object> calOrgIds = new HashSet<Object>(16);
        HashSet<Object> costAccountIds = new HashSet<Object>(16);
        for (ExtendedDataEntity entity : this.dataEntities) {
            boolean isinitbill;
            Integer dataIndex = entity.getDataEntityIndex();
            DynamicObject billDyc = entity.getDataEntity();
            DynamicObject calOrgDyc = billDyc.getDynamicObject("org");
            DynamicObject accountDyc = billDyc.getDynamicObject("costaccount");
            if (calOrgDyc == null || accountDyc == null || !(isinitbill = billDyc.getBoolean("isinitbill"))) continue;
            String calOrgAccountStr = calOrgDyc.getPkValue() + ",";
            calOrgAccountStr = calOrgAccountStr + accountDyc.getPkValue();
            billIndexCalOrgAccountMap.putIfAbsent(calOrgAccountStr, new HashSet(16));
            ((Set)billIndexCalOrgAccountMap.get(calOrgAccountStr)).add(dataIndex);
            calOrgIds.add(calOrgDyc.getPkValue());
            costAccountIds.add(accountDyc.getPkValue());
        }
        QFilter calOrgf = new QFilter("org", "in", calOrgIds);
        QFilter acctAcountf = new QFilter("costaccount", "in", costAccountIds);
        QFilter isNotInitf = new QFilter("isinitbill", "=", (Object)Boolean.FALSE);
        QFilter[] filters = new QFilter[]{calOrgf, acctAcountf, isNotInitf};
        try (DataSet provBillDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_price_provbill", (String)"org,costaccount", (QFilter[])filters, null);){
            DataSet provAndRevBillDs = provBillDs.groupBy(new String[]{"org", "costaccount"}).finish();
            provAndRevBillDs = provAndRevBillDs.addField("Cast(org as String) + ',' + Cast(costaccount as String)", "calorgaccount");
            for (Row row : provAndRevBillDs) {
                Set billIndexs = (Set)billIndexCalOrgAccountMap.get(row.getString("calorgaccount"));
                if (billIndexs == null) continue;
                for (Integer billIndex : billIndexs) {
                    ExtendedDataEntity dataEntity = this.dataEntities[billIndex];
                    DynamicObject billDyc = dataEntity.getDataEntity();
                    String msgFmt = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u6838\u7b97\u7ec4\u7ec7\u201c%2$s\u201d\u4e0b\u5b58\u5728\u975e\u521d\u59cb\u5316\u7684\u8ba1\u63d0\u5355\u3002", (String)"InitProvBillValidator_0", (String)"fi-cal-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, String.format(msgFmt, billDyc.getString("costaccount.name"), billDyc.getString("org.name")));
                }
            }
        }
    }
}

