/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.cal.common.enums.ProvisionWayEnum;

public class MTOValidator
extends AbstractValidator {
    private String configuredCodeField = "configuredcode";
    private String matField = "material";
    private String noCheckConfiguredCode = "noCheckConfiguredCode";

    public void validate() {
        if (this.dataEntities == null || this.dataEntities.length < 1) {
            return;
        }
        if ("save".equalsIgnoreCase(this.getOperateType()) && !this.getOption().getVariables().containsKey("importtype")) {
            return;
        }
        if (this.getOption().getVariables().containsKey(this.noCheckConfiguredCode)) {
            return;
        }
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject billDyc = entity.getDataEntity();
            IDataEntityProperty configuredCodeProp = EntityMetadataCache.getDataEntityType((String)this.getEntityKey()).findProperty(this.configuredCodeField);
            if (configuredCodeProp == null) break;
            if ("cal_fallprice_setting".equals(this.getEntityKey())) {
                boolean notContainConfigureCode;
                String setDimension = billDyc.getString("setdimension");
                boolean bl = notContainConfigureCode = setDimension == null || !setDimension.contains("configuredcode");
                if (!ProvisionWayEnum.MATERIAL.getValue().equals(billDyc.getString("provisionway")) || notContainConfigureCode) continue;
            }
            IDataEntityType parent = configuredCodeProp.getParent();
            String entryDisplayName = parent.getDisplayName().getLocaleValue();
            for (DynamicObject entryDyc : billDyc.getDynamicObjectCollection(parent.getName())) {
                boolean isConfigProp = "2".equals(entryDyc.getString(this.matField + ".configproperties"));
                if (!isConfigProp || entryDyc.getLong(configuredCodeProp + ".id") != 0L) continue;
                int seq = entryDyc.getInt("seq");
                String format = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%3$s\u201d\u7b2c%1$s\u884c:\u201c%2$s\u201d", (String)"MTOValidator_0", (String)"fi-cal-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(entity, String.format(format, seq, configuredCodeProp.getDisplayName().getLocaleValue(), entryDisplayName));
            }
        }
    }
}

