/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.account;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cal.common.helper.BillTreeBuildParameter;
import kd.fi.cal.common.helper.EntityParseHelper;

public class BalanceSettingPlugin
extends AbstractFormPlugin {
    private MainEntityType balMainType = EntityMetadataCache.getDataEntityType((String)"cal_balance");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"dividebasis", "caldimension"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        this.doClick(source.getKey());
    }

    private void doClick(String key) {
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(this.balMainType);
        parameter.setIncludePKField(false);
        parameter.setBaseDataOnlyShowRootNode(true);
        parameter.setIncludeDecimalAndDate(false);
        TreeNode srcBillNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter[])new BillTreeBuildParameter[]{parameter});
        this.showSelectFieldForm(srcBillNode, key);
    }

    private void showSelectFieldForm(TreeNode srcBillNode, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cal_bd_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.getCustomParams().put("ismulti", "true");
        ArrayList<String> list = new ArrayList<String>();
        list.add("cal_balance");
        list.add("billhead");
        showParameter.getCustomParams().put("notreturnnodes", list);
        showParameter.getCustomParams().put("nodeids", (String)this.getModel().getValue(sourceCtrlKey + "cols"));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String sourceFldKey = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (StringUtils.isBlank((Object)returnData)) {
            return;
        }
        this.getModel().setValue(sourceFldKey, (Object)this.getAliasNames((String)returnData));
        this.getModel().setValue(sourceFldKey + "cols", returnData);
    }

    public void createNewData(BizDataEventArgs e) {
        DynamicObject info = BusinessDataServiceHelper.loadSingle((Object)1L, (String)"cal_balance_setting");
        info.set("dividebasis", (Object)this.getAliasNames(info.getString("dividebasiscols")));
        info.set("caldimension", (Object)this.getAliasNames(info.getString("caldimensioncols")));
        e.setDataEntity((Object)info);
    }

    private String getAliasNames(String data) {
        String[] datas;
        StringBuilder sb = new StringBuilder();
        for (String s : datas = data.split(",")) {
            String aliasName = EntityParseHelper.buildPropFullCaption((EntityType)this.balMainType, (String)s, (boolean)false);
            sb.append(aliasName).append(',');
        }
        return sb.substring(0, sb.length() - 1);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        String value = (String)this.getModel().getValue(key);
        if (("dividebasis".equals(key) || "caldimension".equals(key)) && StringUtils.isBlank((CharSequence)value)) {
            this.getModel().setValue(key + "cols", null);
        }
    }
}

