/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.account;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.balance.BalanceOpInvoker;
import kd.fi.cal.business.calculate.billgroup.BillGroupRelationHelper;
import kd.fi.cal.business.calculate.billgroup.CostDomainGroupHelper;
import kd.fi.cal.business.calculate.bizbillgroup.BizGroupRecordHelper;
import kd.fi.cal.business.helper.DomainBalHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.util.DateUtils;

public class BillGroupSettingHandleTask
extends AbstractTask {
    private static final String DLOCK_KEY = "cal_refreshGroupLock#";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext arg0, Map<String, Object> paramMap) throws KDException {
        try (DLock lock = null;
             AlgoContext context = Algo.newContext();){
            if (CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.HAND_GROUPBILL_SETTING).booleanValue() && !(lock = DLock.create((String)(DLOCK_KEY + CacheKeyUtil.getAcctId()))).tryLock()) {
                ErrorCode errorCode = new ErrorCode("refresActGroupRunning", ResManager.loadKDString((String)"\u540e\u53f0\u6b63\u5728\u5237\u65b0\u6210\u7ec4\u5173\u7cfb\u6570\u636e\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"CostAccountGroupRecordHelper_2", (String)"fi-cal-business", (Object[])new Object[0]));
                throw new KDBizException(errorCode, new Object[0]);
            }
            String billnos = (String)paramMap.get("billnos");
            String startdateStr = (String)paramMap.get("startdate");
            String bizentityobjects = (String)paramMap.get("bizentityobjects");
            Date startdate = null;
            if (!StringUtils.isEmpty((String)startdateStr)) {
                startdate = new Date(Long.parseLong(startdateStr));
            }
            HashSet<String> billnoSet = new HashSet<String>(16);
            if (StringUtils.isNotEmpty((String)billnos)) {
                String[] billNos;
                billnos = billnos.trim();
                billnos = billnos.replaceAll("[\\s\\n\\r\\;]", ",");
                for (String string : billNos = billnos.split(",")) {
                    if (!StringUtils.isNotEmpty((String)string)) continue;
                    billnoSet.add(string.trim());
                }
            }
            HashSet<String> formids = new HashSet<String>(4);
            if (StringUtils.isNotEmpty((String)bizentityobjects)) {
                for (String entity : bizentityobjects.split(",")) {
                    formids.add(entity);
                }
            }
            Set<Object> createBizBillIds = new HashSet(4);
            if (AcctGroupModelHelper.isBizGroupModel()) {
                int splitDay = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.HAND_BIZGROUPBILL_SPLITDAY);
                if (splitDay <= 0 || startdate == null) {
                    createBizBillIds = new BizGroupRecordHelper().reCreateBizGroupRecord(formids, billnoSet, startdate, null);
                } else {
                    List splitDates = DateUtils.getSplitDate((Date)startdate, (int)splitDay);
                    for (Date[] splitDate : splitDates) {
                        TraceSpan span = Tracer.create((String)("BillGroupSettingHandleTask" + splitDates.size()), (String)("reCreateBizGroupRecord" + splitDates.size()));
                        Throwable throwable = null;
                        try {
                            createBizBillIds.addAll(new BizGroupRecordHelper().reCreateBizGroupRecord(formids, billnoSet, splitDate[0], splitDate[1]));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (span == null) continue;
                            if (throwable != null) {
                                try {
                                    span.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            span.close();
                        }
                    }
                }
            } else {
                createBizBillIds = this.rebuildGroupRecordByHand(startdate, billnoSet);
            }
            boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
            boolean needUpdateDomainBal = new DomainBalHelper().needUpdateDomainBal();
            if (needUpdateDomainBal && isNewBalance && createBizBillIds != null && !createBizBillIds.isEmpty()) {
                Set<Long> costRecIds = this.getCostRecIds(createBizBillIds);
                new BalanceOpInvoker().invokeCostRecordUpdateBalOp(costRecIds, null);
            }
        }
    }

    private Set<Long> rebuildGroupRecordByHand(Date startdate, Set<String> billnoSet) {
        Set<Long> auditCalBizBill = null;
        BillGroupRelationHelper groupHelper = new BillGroupRelationHelper();
        if (!billnoSet.isEmpty()) {
            QFilter deleteFilter = new QFilter("entryentity.billno", "in", billnoSet);
            auditCalBizBill = this.deleteGroupRecords(deleteFilter, billnoSet, startdate);
            QFilter qFilter = new QFilter("bizbillno", "in", billnoSet);
            groupHelper.createRelations(qFilter);
        } else if (startdate != null) {
            QFilter deleteFilter = new QFilter("entryentity.bookdate", ">=", (Object)startdate);
            this.deleteGroupRecords(deleteFilter, billnoSet, startdate);
            QFilter qFilter = new QFilter("bookdate", ">=", (Object)startdate);
            groupHelper.createRelations(qFilter);
        }
        if (auditCalBizBill != null && !auditCalBizBill.isEmpty() && AcctGroupModelHelper.isNewGroupModel()) {
            new CostDomainGroupHelper().insertAndUpdateCostDomainGroup(auditCalBizBill, null);
        }
        Set createBizBillIds = groupHelper.getCreateBizBillIds();
        return createBizBillIds;
    }

    private Set<Long> deleteGroupRecords(QFilter deleteFilter, Set<String> billnoSet, Date startdate) {
        HashSet<Long> auditCalBizBill = new HashSet<Long>(16);
        if (AcctGroupModelHelper.isNewGroupModel()) {
            QFilter bizFilter = QFilter.of((String)"1 != 1", (Object[])new Object[0]);
            if (!billnoSet.isEmpty()) {
                bizFilter = new QFilter("bizbillno", "in", billnoSet);
            } else if (startdate != null) {
                bizFilter = new QFilter("bookdate", ">=", (Object)startdate);
            }
            DynamicObjectCollection inCalBills = QueryServiceHelper.query((String)"cal_incalbill", (String)"id,billstatus,bizbillid", (QFilter[])bizFilter.toArray(), null);
            DynamicObjectCollection outCalBills = QueryServiceHelper.query((String)"cal_outcalbill", (String)"id,billstatus,bizbillid", (QFilter[])bizFilter.toArray(), null);
            HashSet<Long> calBillIds = new HashSet<Long>(16);
            inCalBills.addAll((Collection)outCalBills);
            for (DynamicObject inCalBill : inCalBills) {
                Long id = inCalBill.getLong("id");
                String status = inCalBill.getString("billstatus");
                calBillIds.add(id);
                if (!"C".equals(status)) continue;
                auditCalBizBill.add(id);
            }
            if (calBillIds.isEmpty()) {
                return auditCalBizBill;
            }
            new CostDomainGroupHelper().deleteAndUpdateCostDomainGroup(calBillIds);
            DeleteServiceHelper.delete((String)"cal_groupbillrecord", (QFilter[])new QFilter("entryentity.billid", "in", calBillIds).toArray());
            DeleteServiceHelper.delete((String)"cal_account_grouprecord", (QFilter[])new QFilter("entryentity.calbillid", "in", calBillIds).toArray());
        } else {
            try (DataSet recordDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_groupbillrecord", (String)"id,entryentity.bizbillid bizbillid", (QFilter[])deleteFilter.toArray(), null);){
                HashSet<Long> recordIds = new HashSet<Long>(16);
                for (Row row : recordDS) {
                    recordIds.add(row.getLong("id"));
                }
                if (recordIds.isEmpty()) {
                    HashSet<Long> hashSet = auditCalBizBill;
                    return hashSet;
                }
                DeleteServiceHelper.delete((String)"cal_groupbillrecord", (QFilter[])new QFilter("id", "in", recordIds).toArray());
                DeleteServiceHelper.delete((String)"cal_account_grouprecord", (QFilter[])new QFilter("bizgrouprecordid", "in", recordIds).toArray());
            }
        }
        return auditCalBizBill;
    }

    private Set<Long> getCostRecIds(Set<Long> allBizBillIds) {
        QFilter bizFilter = new QFilter("bizbillid", "in", allBizBillIds);
        HashSet<Long> costRecIds = new HashSet<Long>(16);
        DataSet costRecDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"id", (QFilter[])bizFilter.toArray(), null);
        for (Row row : costRecDs) {
            costRecIds.add(row.getLong("id"));
        }
        return costRecIds;
    }
}

