/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.account;

import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.formplugin.base.AbstractSchemeListPlugin;

public class CloseAccountLogListPlugin
extends AbstractSchemeListPlugin {
    private static final Long[] CHECKTASK_ID = new Long[]{1255063777360084992L};

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().put("isinit", "true");
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumns) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            boolean isInit = "true".equals(this.getPageCache().get("isinit"));
            if (!isInit || !"org.name".equals(fieldName)) continue;
            this.setDeFaultOrgs(commonFilterColumn);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        String fieldName = args.getFieldName();
        if (!"checkresult".equals(fieldName)) {
            return;
        }
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow row = billList.getCurrentSelectedRowInfo();
        QFilter q = new QFilter("id", "=", row.getPrimaryKeyValue());
        DynamicObject log = QueryServiceHelper.queryOne((String)"cal_closeaccountlog", (String)"id,taskid", (QFilter[])q.toArray());
        if (log.getLong("taskid") == 0L) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65e5\u5fd7\u6682\u65e0\u68c0\u67e5\u7ed3\u679c\u3002", (String)"CloseAccountLogListPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter checkQ = new QFilter("checkplan", "=", (Object)log.getLong("taskid"));
        checkQ.and("checktask", "in", (Object)CHECKTASK_ID);
        DynamicObject checkResult = QueryServiceHelper.queryOne((String)"cal_datacheck_result", (String)"id", (QFilter[])checkQ.toArray());
        if (checkResult == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65e5\u5fd7\u6682\u65e0\u68c0\u67e5\u7ed3\u679c\u3002", (String)"CloseAccountLogListPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setPkId((Object)checkResult.getLong("id"));
        showParameter.setFormId("cal_datacheck_result");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.setOrderBy("operationtime desc,org,owner");
        String filter = (String)this.getView().getFormShowParameter().getCustomParam("filter");
        String isInitStr = this.getPageCache().get("isinit");
        if ("true".equals(isInitStr) && StringUtils.isNotEmpty((CharSequence)filter)) {
            e.getQFilters().add(QFilter.of((String)filter, (Object[])new Object[0]));
        }
        this.getPageCache().put("isinit", "false");
    }

    @Override
    protected String getEntity() {
        return "cal_closeaccount";
    }
}

