/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.account;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.cal.formplugin.base.AbstractSchemeListPlugin;

public class SettleAccountLogListPlugin
extends AbstractSchemeListPlugin {
    private static final Long CLOSETASK_ID = 1255063777360084992L;
    private static final Long SETTLETASK_ID = 1266490172376219648L;

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        String fieldName = args.getFieldName();
        if (!"checkresult".equals(fieldName)) {
            return;
        }
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow row = billList.getCurrentSelectedRowInfo();
        QFilter q = new QFilter("id", "=", row.getPrimaryKeyValue());
        DynamicObject log = QueryServiceHelper.queryOne((String)"cal_settleaccountlog", (String)"id,taskid,settletype", (QFilter[])q.toArray());
        if (log.getLong("taskid") == 0L) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65e5\u5fd7\u6682\u65e0\u68c0\u67e5\u7ed3\u679c\u3002", (String)"CloseAccountLogListPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter checkQ = new QFilter("checkplan", "=", (Object)log.getLong("taskid"));
        if ("C".equals(log.getString("settletype"))) {
            checkQ.and("checktask", "in", (Object)CLOSETASK_ID);
        } else {
            checkQ.and("checktask", "in", (Object)SETTLETASK_ID);
        }
        DynamicObjectCollection checkResult = QueryServiceHelper.query((String)"cal_datacheck_result", (String)"id", (QFilter[])checkQ.toArray());
        if (checkResult == null || checkResult.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65e5\u5fd7\u6682\u65e0\u68c0\u67e5\u7ed3\u679c\u3002", (String)"CloseAccountLogListPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> rstIdSet = new HashSet<Long>(checkResult.size());
        for (DynamicObject rst : checkResult) {
            rstIdSet.add(rst.getLong("id"));
        }
        if (1 == rstIdSet.size()) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId(rstIdSet.iterator().next());
            showParameter.setFormId("cal_datacheck_result");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        } else {
            ListShowParameter listParameter = new ListShowParameter();
            listParameter.setBillFormId("cal_datacheck_result");
            listParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            QFilter listQ = new QFilter("id", "in", rstIdSet);
            listParameter.getListFilterParameter().setFilter(listQ);
            this.getView().showForm((FormShowParameter)listParameter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().put("isinit", "true");
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumns) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            boolean isInit = "true".equals(this.getPageCache().get("isinit"));
            if (!isInit || !"costaccount.calorg.name".equals(fieldName)) continue;
            this.setDeFaultOrgs(commonFilterColumn);
        }
    }

    @Override
    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        if ("costaccount.calorg.name".equals(args.getFieldName())) {
            List<Long> list = this.getAllPermOrgs();
            QFilter q = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
            if (list != null) {
                q = new QFilter("id", "in", list);
            }
            args.addCustomQFilter(q);
        }
    }

    private List<Long> getAllPermOrgs() {
        String appInnerId;
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)(appInnerId = AppMetadataCache.getAppInfo((String)"cal").getId()), (String)"cal_settleaccount", (String)"47150e89000000ac");
        if (!rs.hasAllOrgPerm()) {
            return rs.getHasPermOrgs();
        }
        return null;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.setOrderBy("operationtime desc,costaccount");
        String filter = (String)this.getView().getFormShowParameter().getCustomParam("filter");
        String isInitStr = this.getPageCache().get("isinit");
        if ("true".equals(isInitStr) && StringUtils.isNotEmpty((CharSequence)filter)) {
            e.getQFilters().add(QFilter.of((String)filter, (Object[])new Object[0]));
        }
        this.getPageCache().put("isinit", "false");
    }

    @Override
    protected String getEntity() {
        return "cal_settleaccount";
    }
}

