/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.account;

import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.account.ReconciliationParam;
import kd.fi.cal.business.account.SettleAccountTaskDispatcher;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.DateUtils;
import kd.fi.cal.formplugin.queryscheme.QuerySchemeHolder;
import kd.fi.cal.formplugin.queryscheme.SchemeSettingPlugin;

public class SettleAccountPlugin
extends SchemeSettingPlugin
implements ProgresssListener,
BeforeF7SelectListener {
    private static final String KEY_PROGRESSBAR = "progressbarap";
    public static final String CACHEKEY_PROGRESS = "progress";
    public static final String CACHEKEY_STARTPROPGRESS = "startprogress";
    public static final String MULCALORG = "mulcalorg";
    public static final String MULCOSTACCOUNT = "mulcostaccount";
    public static final String QUERY = "query";
    private boolean hasSuccess = false;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addItemClickListeners(new String[]{"itemsbar"});
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        progressBar.addProgressListener((ProgresssListener)this);
        this.addF7Listener(this, MULCALORG);
        this.addF7Listener(this, MULCOSTACCOUNT);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadCheckItemList();
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        for (String str : f7Name) {
            BasedataEdit f7Control = (BasedataEdit)this.getView().getControl(str);
            if (null == f7Control) continue;
            f7Control.addBeforeF7SelectListener(form);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        List<Long> orgList;
        String key = e.getProperty().getName();
        if (MULCOSTACCOUNT.equals(key)) {
            DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id", (QFilter[])new QFilter[]{this.getCalOrgQ()}, null);
            HashSet<Long> costAccountIdSet = new HashSet<Long>(costAccounts.size());
            for (DynamicObject costAccount : costAccounts) {
                costAccountIdSet.add(costAccount.getLong("id"));
            }
            QFilter sysCtrlQ = new QFilter("entry.costaccount", "in", costAccountIdSet);
            sysCtrlQ.and("entry.isenabled", "=", (Object)Boolean.TRUE);
            DynamicObjectCollection sysCtrlInfos = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"entry.costaccount", (QFilter[])sysCtrlQ.toArray());
            costAccountIdSet.clear();
            for (DynamicObject info : sysCtrlInfos) {
                costAccountIdSet.add(info.getLong("entry.costaccount"));
            }
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(new QFilter("id", "in", costAccountIdSet));
        } else if (MULCALORG.equals(key) && (orgList = this.getAllPermOrgs()) != null) {
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(new QFilter("id", "in", orgList));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (MULCALORG.equals(e.getProperty().getName())) {
            this.getModel().setValue(MULCOSTACCOUNT, null);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        EntryGrid entryGrid;
        int[] selectedRowIndexs;
        super.beforeDoOperation(event);
        FormOperate formOperate = (FormOperate)event.getSource();
        String key = formOperate.getOperateKey();
        if ("savescheme".equals(key) && (selectedRowIndexs = (entryGrid = (EntryGrid)this.getControl("entryentity")).getSelectRows()).length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u7ed3\u8d26\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"SettleAccountPlugin_21", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        String key = event.getOperateKey();
        if (QUERY.equals(key)) {
            this.loadGrid();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("btn_settleaccount".equals(evt.getItemKey())) {
            this.settleAccount();
        } else if ("btn_unsettleaccount".equals(evt.getItemKey())) {
            this.unSettleAccount();
        } else if ("btn_refresh".equals(evt.getItemKey())) {
            this.refresh();
            this.loadCheckItemList();
        } else if ("bar_querylog".equals(evt.getItemKey())) {
            this.queryLog();
        } else if ("openall".equals(evt.getItemKey())) {
            this.changeCheckEntryStatus(true);
        } else if ("closeall".equals(evt.getItemKey())) {
            this.changeCheckEntryStatus(false);
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loadGrid();
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_PROGRESSBAR});
        this.getView().getModel().setDataChanged(false);
    }

    public void onProgress(ProgressEvent e) {
        String startProgress = this.getPageCache().get(CACHEKEY_STARTPROPGRESS);
        if (StringUtils.isEmpty((String)startProgress)) {
            e.setProgress(0);
            e.setText(ResManager.loadKDString((String)" \u672a\u5f00\u59cb ", (String)"SettleAccountPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        int progress = 0;
        String text = ResManager.loadKDString((String)" \u8fdb\u884c\u4e2d ...", (String)"SettleAccountPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        String cacheProgress = this.getPageCache().get(CACHEKEY_PROGRESS);
        if (!StringUtils.isEmpty((String)cacheProgress)) {
            progress = Integer.parseInt(cacheProgress);
        }
        if (progress >= 100) {
            text = ResManager.loadKDString((String)" \u5b8c\u6210 ", (String)"SettleAccountPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        }
        if (startProgress.equals("false")) {
            text = ResManager.loadKDString((String)"\u5df2\u53d6\u6d88\u6267\u884c ", (String)"SettleAccountPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        }
        e.setProgress(progress);
        e.setText(text);
    }

    @Override
    protected void afterAddScheme() {
        super.afterAddScheme();
        this.loadCheckItemList();
        this.loadGrid();
    }

    @Override
    protected void afterSelScheme() {
        super.afterSelScheme();
        this.loadPeriod();
        this.setCheckItem();
    }

    private void settleAccount() {
        boolean isUpateInvBill;
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectedRowIndexs = entryGrid.getSelectRows();
        if (selectedRowIndexs.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"SettleAccountPlugin_4", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!this.doValidate(selectedRowIndexs, "4730fc9f000001ae", ResManager.loadKDString((String)"\u65e0\u201c\u671f\u672b\u7ed3\u8d26\u201d\u7684\u201c\u7ed3\u8d26\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SettleAccountPlugin_22", (String)"fi-cal-formplugin", (Object[])new Object[0]))) {
            return;
        }
        DynamicObject settAcctDyc = this.getModel().getDataEntity(true);
        Boolean isCheckSaveStatus = SettleAccountTaskDispatcher.isUpdateInvDate((DynamicObject)settAcctDyc, (String)"A");
        Boolean isCheckSubmitStatus = SettleAccountTaskDispatcher.isUpdateInvDate((DynamicObject)settAcctDyc, (String)"B");
        boolean bl = isUpateInvBill = isCheckSaveStatus != false || isCheckSubmitStatus != false;
        if (isUpateInvBill && this.isNeedCloseAccount().booleanValue()) {
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("updateInvDate", (IFormPlugin)this);
            String loadKDString = ResManager.loadKDString((String)"\u672a\u6821\u9a8c\u5e93\u5b58\u672a\u5ba1\u6838\u72b6\u6001\u5355\u636e\u65f6\uff0c\u5173\u8d26\u9ed8\u8ba4\u5c06\u6682\u5b58\u3001\u63d0\u4ea4\u72b6\u6001\u7684\u5e93\u5b58\u4e0e\u6838\u7b97\u5355\u636e\u8bb0\u8d26\u65e5\u671f\u4fee\u6539\u4e3a\u5173\u8d26\u65e5\u671f\u540e\u4e00\u5929\uff0c\u662f\u5426\u786e\u8ba4\u7ed3\u8d26\uff1f", (String)"CloseAccountPlugin_12", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(loadKDString, null, MessageBoxOptions.YesNo, null, callBackListener, null, "");
            return;
        }
        if (!this.checkPeriod(selectedRowIndexs)) {
            return;
        }
        this.doBizService(selectedRowIndexs);
    }

    private boolean doValidate(int[] selectedRowIndexs, String flag, String msg) {
        HashSet<Long> set = new HashSet<Long>(32);
        for (int i = 0; i < selectedRowIndexs.length; ++i) {
            DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount", selectedRowIndexs[i]);
            set.add(costaccount.getDynamicObject("calorg").getLong("id"));
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        for (Long calorgid : set) {
            int result = this.getCalOrgPermission(calorgid, userId, flag);
            if (result > 0) continue;
            this.getView().showErrorNotification(msg);
            return false;
        }
        return true;
    }

    private boolean afterDoBizService(int[] selectedRowIndexs) {
        DynamicObject settleAcctDyc = this.getModel().getDataEntity(true);
        SettleAccountTaskDispatcher settleAccountTaskDispatcher = new SettleAccountTaskDispatcher(settleAcctDyc);
        settleAccountTaskDispatcher.setSelectedRowIndexs(selectedRowIndexs);
        Long querySchemeId = new QuerySchemeHolder(this.getView()).getCurSchemeId();
        settleAccountTaskDispatcher.setQuerySchemeId(querySchemeId);
        settleAccountTaskDispatcher.dispatch();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBizService(int[] selectedRowIndexs) {
        block17: {
            ArrayList<DLock> lockList = new ArrayList<DLock>(16);
            try {
                for (int i = 0; i < selectedRowIndexs.length; ++i) {
                    int rowIndex = selectedRowIndexs[i];
                    DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount", rowIndex);
                    String lockId = "doBizService_SettleAccount" + costAccount.getLong("id");
                    DLock lock = DLock.create((String)lockId, (String)ResManager.loadKDString((String)"\u7ed3\u8d26\u9501", (String)"SettleAccountPlugin_26", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                    lockList.add(lock);
                    if (!lock.tryLock()) {
                        String msgStr = MessageFormat.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u6b63\u5728\u8fdb\u884c\u7ed3\u8d26\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"SettleAccountPlugin_27", (String)"fi-cal-formplugin", (Object[])new Object[0]), costAccount.getString("name"));
                        throw new KDBizException(msgStr);
                    }
                    DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccount.getLong("id"));
                    if (period == null) {
                        this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6210\u672c\u8d26\u7c3f\u201c{0}\u201d\u7684\u5f53\u524d\u671f\u95f4\uff0c\u8bf7\u68c0\u67e5\u6838\u7b97\u671f\u95f4\u8bbe\u7f6e\u3002", (String)"SettleAccountPlugin_20", (String)"fi-cal-formplugin", (Object[])new Object[0]), costAccount.getString("name")));
                        return;
                    }
                    Long costaccountid = costAccount.getLong("id");
                    Long periodid = period.getLong("id");
                    Long calorgid = costAccount.getLong("calorg.id");
                    ReconciliationParam param = new ReconciliationParam();
                    param.setPeriodId(periodid);
                    param.setAppNumber("cal");
                    param.setBizBookId(costaccountid);
                    param.setOrgId(calorgid);
                    param.setInit(false);
                    QFilter filter = new QFilter("entry.costaccount", "=", (Object)costaccountid);
                    DynamicObject dy = QueryServiceHelper.queryOne((String)"cal_accountparamssetting", (String)"entry.endaccountcheck", (QFilter[])new QFilter[]{filter});
                    if (dy == null) {
                        throw new KDBizException(ResManager.loadKDString((String)MessageFormat.format("\u8bf7\u5148\u5728\u6838\u7b97\u914d\u7f6e\u2192\u8d26\u7c3f\u7ea7\u53c2\u6570\u8bbe\u7f6e\u754c\u9762\uff0c\u914d\u7f6e\u6210\u672c\u8d26\u7c3f\u3010{0}\u3011\u7684\u5bf9\u5e94\u53c2\u6570", costAccount.getString("name")), (String)"CalSystemCtrlEditUIPlugin_14", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                    }
                    if (dy.getString("entry.endaccountcheck").equals("B")) {
                        this.hasSuccess = this.afterDoBizService(new int[]{rowIndex}) || this.hasSuccess;
                        continue;
                    }
                    String endaccountcheck = dy.getString("entry.endaccountcheck");
                    String code = "";
                    String openParam = "";
                    try {
                        DispatchServiceHelper.invokeBizService((String)"fi", (String)"frm", (String)"ReconciliationService", (String)"execute", (Object[])new Object[]{SerializationUtils.toJsonString((Object)param)});
                    }
                    catch (KDBizException e) {
                        if (e.getArgs().length > 0) {
                            openParam = e.getArgs()[0].toString();
                        }
                        ErrorCode ec = e.getErrorCode();
                        code = ec.getCode();
                    }
                    if ("2".equals(code)) {
                        if (endaccountcheck.equals("A")) {
                            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("callbackId", (IFormPlugin)this);
                            String loadKDString = ResManager.loadKDString((String)"\u5b58\u5728\u5bf9\u8d26\u4e0d\u5e73\u7684\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u8981\u7ed3\u8d26\uff1f", (String)"SettleAccountPlugin_8", (String)"fi-cal-formplugin", (Object[])new Object[0]);
                            JSONObject json = new JSONObject();
                            json.put(String.valueOf(rowIndex), (Object)openParam);
                            this.getView().showConfirm(loadKDString, null, MessageBoxOptions.YesNo, null, callBackListener, null, SerializationUtils.toJsonString((Object)json));
                            continue;
                        }
                        if (!endaccountcheck.equals("C")) continue;
                        FormShowParameter parame = new FormShowParameter();
                        parame.setFormId("frm_reconciliation_rst_fst");
                        parame.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                        parame.setCustomParam("model", (Object)openParam);
                        this.getView().showForm(parame);
                        continue;
                    }
                    this.hasSuccess = this.afterDoBizService(new int[]{rowIndex}) || this.hasSuccess;
                }
                if (!this.hasSuccess) break block17;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u8d26\u8bf7\u6c42\u5df2\u63d0\u4ea4\u5904\u7406\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u6216\u5237\u65b0\u754c\u9762\u3002", (String)"SettleAccountPlugin_7", (String)"fi-cal-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            }
            catch (Exception e) {
                this.getView().showTipNotification(ResManager.loadKDString((String)e.getMessage(), (String)"SettleAccountPlugin_25", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
            finally {
                for (DLock lock : lockList) {
                    if (lock == null) continue;
                    lock.close();
                }
            }
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        MessageBoxResult result = e.getResult();
        if (e.getCallBackId().equals("callbackId")) {
            String customVaule = e.getCustomVaule();
            Map map = (Map)SerializationUtils.fromJsonString((String)customVaule, Map.class);
            Set keySet = map.keySet();
            String index = "";
            Iterator iterator = keySet.iterator();
            while (iterator.hasNext()) {
                String string;
                index = string = (String)iterator.next();
            }
            if (MessageBoxResult.No.equals((Object)result)) {
                FormShowParameter parame = new FormShowParameter();
                parame.setFormId("ai_reconciliation_rst_fst");
                parame.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parame.setCustomParam("model", map.get(index));
                this.getView().showForm(parame);
            } else {
                this.hasSuccess = this.afterDoBizService(new int[]{Integer.parseInt(index)}) || this.hasSuccess;
            }
        } else if ("updateInvDate".equals(e.getCallBackId())) {
            EntryGrid entryGrid;
            int[] selectedRowIndexs;
            if (MessageBoxResult.Yes.equals((Object)result) && this.checkPeriod(selectedRowIndexs = (entryGrid = (EntryGrid)this.getControl("entryentity")).getSelectRows())) {
                this.doBizService(selectedRowIndexs);
            }
        } else if ("periodConfirm".equals(e.getCallBackId()) && MessageBoxResult.Yes.equals((Object)result)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectedRowIndexs = entryGrid.getSelectRows();
            this.doBizService(selectedRowIndexs);
        }
    }

    private void unSettleAccount() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectedRowIndexs = entryGrid.getSelectRows();
        if (selectedRowIndexs.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"SettleAccountPlugin_4", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!this.doValidate(selectedRowIndexs, "4730fc9f000010ae", ResManager.loadKDString((String)"\u65e0\u201c\u671f\u672b\u7ed3\u8d26\u201d\u7684\u201c\u53cd\u7ed3\u8d26\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SettleAccountPlugin_23", (String)"fi-cal-formplugin", (Object[])new Object[0]))) {
            return;
        }
        String msg = this.ValidateGLAccountPeriod(selectedRowIndexs);
        if (msg != null) {
            this.getView().showErrorNotification(msg);
            return;
        }
        DynamicObject settleAcctDyc = this.getModel().getDataEntity(true);
        SettleAccountTaskDispatcher settleAccountTaskDispatcher = new SettleAccountTaskDispatcher(settleAcctDyc);
        settleAccountTaskDispatcher.setSettleAccout(false);
        settleAccountTaskDispatcher.setSelectedRowIndexs(selectedRowIndexs);
        Long querySchemeId = new QuerySchemeHolder(this.getView()).getCurSchemeId();
        settleAccountTaskDispatcher.setQuerySchemeId(querySchemeId);
        settleAccountTaskDispatcher.dispatch();
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u53cd\u7ed3\u8d26\u8bf7\u6c42\u5df2\u63d0\u4ea4\u5904\u7406\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u6216\u5237\u65b0\u754c\u9762\u3002", (String)"SettleAccountPlugin_11", (String)"fi-cal-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
    }

    private void queryLog() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectedRowIndexs = entryGrid.getSelectRows();
        if (selectedRowIndexs.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"SettleAccountPlugin_4", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter listParameter = new ListShowParameter();
        listParameter.setBillFormId("cal_settleaccountlog");
        listParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashSet<Object> costAccountIds = new HashSet<Object>(16);
        HashMap<String, String> calOrgIdNameMap = new HashMap<String, String>(16);
        for (int selectedRowIndex : selectedRowIndexs) {
            DynamicObject calOrgDyc;
            DynamicObject costAccountDyc = (DynamicObject)this.getModel().getValue("costaccount", selectedRowIndex);
            if (costAccountDyc == null || (calOrgDyc = costAccountDyc.getDynamicObject("calorg")) == null) continue;
            costAccountIds.add(costAccountDyc.getPkValue());
            calOrgIdNameMap.put(calOrgDyc.getString("id"), calOrgDyc.getString("name"));
        }
        QFilter q = new QFilter("costaccount", "in", costAccountIds);
        listParameter.setCustomParam("filter", (Object)q.toString());
        listParameter.setCustomParam("calorg", calOrgIdNameMap);
        this.getView().showForm((FormShowParameter)listParameter);
    }

    private void refresh() {
        this.refreshPeriod();
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_PROGRESSBAR});
    }

    private void loadGrid() {
        DynamicObjectCollection costAccounts;
        this.getModel().deleteEntryData("entryentity");
        QFilter q = this.getCalOrgQ();
        DynamicObjectCollection costAccountCollention = (DynamicObjectCollection)this.getModel().getValue(MULCOSTACCOUNT);
        if (costAccountCollention.size() > 0) {
            ArrayList<Long> filterAccountList = new ArrayList<Long>();
            for (Object costAccount : costAccountCollention) {
                filterAccountList.add(costAccount.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("id", "in", filterAccountList);
        }
        if ((costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,calorg.name,calorg.number,calsystem.name,calsystem.number,calpolicy.name,calpolicy.number", (QFilter[])new QFilter[]{q}, (String)"calorg.number")).size() > 0) {
            HashSet<Long> set = new HashSet<Long>();
            for (DynamicObject info : costAccounts) {
                set.add(info.getLong("id"));
            }
            HashMap<Long, Long> map = new HashMap<Long, Long>();
            DynamicObjectCollection sysCtrlColl = PeriodHelper.getSysCtrlEntity((Long[])set.toArray(new Long[0]), null);
            for (DynamicObject info : sysCtrlColl) {
                map.put(info.getLong("costaccount"), info.getLong("currentperiod"));
            }
            int j = 0;
            this.getModel().beginInit();
            for (int i = 0; i < costAccounts.size(); ++i) {
                Long period = (Long)map.get(((DynamicObject)costAccounts.get(i)).getLong("id"));
                if (period == null || period == 0L) continue;
                this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("costaccount", ((DynamicObject)costAccounts.get(i)).get("id"), j);
                this.getModel().setValue("period", (Object)period, j);
                ++j;
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
    }

    private void refreshPeriod() {
        DynamicObjectCollection entryDycs = this.getModel().getEntryEntity("entryentity");
        HashSet<Long> accountIds = new HashSet<Long>(entryDycs.size());
        HashMap<Long, Long> acctPeriodMap = new HashMap<Long, Long>(16);
        HashMap<Long, Integer> acctIndexMap = new HashMap<Long, Integer>(16);
        for (int i = 0; i < entryDycs.size(); ++i) {
            Object costAccount = this.getModel().getValue("costaccount", i);
            if (costAccount == null) continue;
            Long accountId = (Long)((DynamicObject)costAccount).getPkValue();
            accountIds.add(accountId);
            acctIndexMap.put(accountId, i);
        }
        DynamicObjectCollection sysPeriodDyc = PeriodHelper.getSysCtrlEntity((Long[])accountIds.toArray(new Long[0]), null);
        for (DynamicObject info : sysPeriodDyc) {
            acctPeriodMap.put(info.getLong("costaccount"), info.getLong("currentperiod"));
        }
        for (Map.Entry item : acctIndexMap.entrySet()) {
            Long periodId = (Long)acctPeriodMap.get(item.getKey());
            this.getModel().setValue("period", (Object)periodId, ((Integer)item.getValue()).intValue());
        }
    }

    private List<Long> getAllPermOrgs() {
        String appInnerId;
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)(appInnerId = AppMetadataCache.getAppInfo((String)"cal").getId()), (String)"cal_settleaccount", (String)"47150e89000000ac");
        if (!rs.hasAllOrgPerm()) {
            return rs.getHasPermOrgs();
        }
        return null;
    }

    private int getCalOrgPermission(Long orgId, Long userId, String flag) {
        int result = PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)orgId, (String)"/KIUHEXROK3D", (String)"cal_settleaccount", (String)flag);
        return result;
    }

    private QFilter getCalOrgQ() {
        DynamicObjectCollection calorgs;
        List<Long> orgList = this.getAllPermOrgs();
        QFilter q = new QFilter("enable", "=", (Object)"1");
        if (orgList != null) {
            q.and("calorg", "in", orgList);
        }
        if ((calorgs = (DynamicObjectCollection)this.getModel().getValue(MULCALORG)).size() > 0) {
            ArrayList<Long> filterCalOrgList = new ArrayList<Long>();
            for (DynamicObject calorg : calorgs) {
                filterCalOrgList.add(calorg.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("calorg", "in", filterCalOrgList);
        }
        return q;
    }

    public boolean getIsCheckStatus() {
        return true;
    }

    private void loadCheckItemList() {
        String entryKey = "checkentry";
        DynamicObjectCollection checkItems = QueryServiceHelper.query((String)"cal_datacheck_task", (String)"purpose,entryentity.checkitem,entryentity.entryenable,entryentity.level", (QFilter[])new QFilter("id", "in", (Object)new Long[]{1255063777360084992L, 1266490172376219648L}).toArray(), (String)"purpose asc,entryentity.checkitem.number asc");
        if (checkItems.isEmpty()) {
            return;
        }
        this.getModel().deleteEntryData(entryKey);
        this.getModel().batchCreateNewEntryRow(entryKey, checkItems.size());
        int row = 0;
        for (DynamicObject item : checkItems) {
            this.getModel().setValue("purpose", (Object)item.getString("purpose"), row);
            this.getModel().setValue("checkitem", (Object)item.getLong("entryentity.checkitem"), row);
            this.getModel().setValue("ischeck", (Object)item.getBoolean("entryentity.entryenable"), row);
            this.getModel().setValue("level", (Object)item.getString("entryentity.level"), row);
            ++row;
        }
        this.getView().updateView(entryKey);
    }

    private Boolean isNeedCloseAccount() {
        Boolean isNeedCloseAccount = Boolean.FALSE;
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectedRowIndexs = entryGrid.getSelectRows();
        HashSet<Long> ownerIdSet = new HashSet<Long>(16);
        HashMap<Long, HashSet<Long>> accountOwnerMap = new HashMap<Long, HashSet<Long>>(16);
        HashMap<Long, Date> accountEndDateMap = new HashMap<Long, Date>(16);
        for (int i = 0; i < selectedRowIndexs.length; ++i) {
            Long[] ownerIds;
            int rowIndex = selectedRowIndexs[i];
            DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount", rowIndex);
            Long costAccountId = costAccount.getLong("id");
            DynamicObject period = (DynamicObject)this.getModel().getValue("period", rowIndex);
            if (period == null) {
                this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6210\u672c\u8d26\u7c3f\u201c{0}\u201d\u7684\u5f53\u524d\u671f\u95f4\uff0c\u8bf7\u68c0\u67e5\u6838\u7b97\u671f\u95f4\u8bbe\u7f6e\u3002", (String)"SettleAccountPlugin_20", (String)"fi-cal-formplugin", (Object[])new Object[0]), costAccount.getString("name")));
                continue;
            }
            for (Long ownerId : ownerIds = AccountingSysHelper.getOwners((Long)costAccount.getLong("id"))) {
                ownerIdSet.add(ownerId);
            }
            accountOwnerMap.put(costAccountId, ownerIdSet);
            Date enddate = ((DynamicObject)this.getModel().getValue("period", rowIndex)).getDate("enddate");
            accountEndDateMap.put(costAccountId, enddate);
        }
        QFilter q = new QFilter("owner", "in", ownerIdSet);
        q.and("isleaf", "=", (Object)Boolean.TRUE);
        DynamicObject[] infos = BusinessDataServiceHelper.load((String)"cal_closeaccounttable", (String)"id,calorg,costaccount,owner,isleaf,closedate", (QFilter[])new QFilter[]{q});
        if (infos.length == 0) {
            return true;
        }
        for (DynamicObject info : infos) {
            Long ownerId = info.getDynamicObject("owner").getLong("id");
            Date closeDate = info.getDate("closedate");
            if ((closeDate = DateUtils.getDayStartTime((Date)closeDate)) == null) {
                isNeedCloseAccount = Boolean.TRUE;
                break;
            }
            for (Map.Entry entry : accountOwnerMap.entrySet()) {
                Long accountId = (Long)entry.getKey();
                Set ownerIds = (Set)entry.getValue();
                if (!ownerIds.contains(ownerId)) continue;
                Date endDate = (Date)accountEndDateMap.get(accountId);
                if (!closeDate.before(endDate = DateUtils.getDayStartTime((Date)endDate))) continue;
                isNeedCloseAccount = Boolean.TRUE;
                break;
            }
            if (Boolean.TRUE == isNeedCloseAccount) break;
        }
        return isNeedCloseAccount;
    }

    private void changeCheckEntryStatus(boolean isOpen) {
        DynamicObjectCollection checkEntry = this.getModel().getEntryEntity("checkentry");
        for (DynamicObject item : checkEntry) {
            item.set("ischeck", (Object)isOpen);
        }
        this.getView().updateView("checkentry");
    }

    private void loadPeriod() {
        int entryCount = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < entryCount; ++i) {
            DynamicObject periodDyc;
            DynamicObject costAccountDyc = (DynamicObject)this.getModel().getValue("costaccount", i);
            if (costAccountDyc == null || (periodDyc = PeriodHelper.getCurrentPeriod((Long)costAccountDyc.getLong("id"))) == null) continue;
            this.getModel().setValue("period", periodDyc.getPkValue(), i);
        }
    }

    private void setCheckItem() {
        DynamicObject checkItemDyc;
        this.getModel().beginInit();
        String entryKey = "checkentry";
        DynamicObjectCollection checkEntryDycs = this.getModel().getEntryEntity(entryKey);
        HashMap<Long, Boolean> checkItemIdIsCheckMap = new HashMap<Long, Boolean>(16);
        for (DynamicObject checkEntryDyc : checkEntryDycs) {
            checkItemDyc = checkEntryDyc.getDynamicObject("checkitem");
            if (checkItemDyc == null) continue;
            checkItemIdIsCheckMap.put(checkItemDyc.getLong("id"), checkEntryDyc.getBoolean("ischeck"));
        }
        this.loadCheckItemList();
        checkEntryDycs = this.getModel().getEntryEntity(entryKey);
        for (DynamicObject checkEntryDyc : checkEntryDycs) {
            Boolean isCheck;
            checkItemDyc = checkEntryDyc.getDynamicObject("checkitem");
            if (checkItemDyc == null || (isCheck = (Boolean)checkItemIdIsCheckMap.get(checkItemDyc.getLong("id"))) == null) continue;
            checkEntryDyc.set("ischeck", (Object)isCheck);
        }
        this.getModel().endInit();
        this.getView().updateView(entryKey);
    }

    private String ValidateGLAccountPeriod(int[] selectedRowIndexs) {
        Integer syncPeriod;
        DynamicObject[] calpolicyInfos;
        HashSet<Long> accountIds = new HashSet<Long>(16);
        HashMap<Long, DynamicObject> accountMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, Long> calpolicyAndAccountMap = new HashMap<Long, Long>(16);
        QFilter glAccountQ = QFilter.of((String)"1 != 1", (Object[])new Object[0]);
        for (int i = 0; i < selectedRowIndexs.length; ++i) {
            int rowIndex = selectedRowIndexs[i];
            DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount", rowIndex);
            Long accountId = costAccount.getLong("id");
            calpolicyAndAccountMap.put(costAccount.getLong("calpolicy.id"), accountId);
            accountIds.add(accountId);
            accountMap.put(accountId, costAccount);
        }
        for (DynamicObject calpolicyInfo : calpolicyInfos = BusinessDataServiceHelper.load((String)"cal_bd_calpolicy", (String)"id,periodtype.id", (QFilter[])new QFilter("id", "in", calpolicyAndAccountMap.keySet()).toArray())) {
            QFilter accountQ = new QFilter("periodtype", "=", (Object)calpolicyInfo.getLong("periodtype.id"));
            accountQ.and("b_entry.b_relatebook.fbasedataid", "in", calpolicyAndAccountMap.get(calpolicyInfo.getLong("id")));
            glAccountQ.or(accountQ);
        }
        glAccountQ.and("enable", "=", (Object)Character.valueOf('1'));
        DynamicObjectCollection glAccounts = QueryServiceHelper.query((String)"gl_accountbook", (String)"number,b_entry.b_relatebook.fbasedataid.id,curperiod", (QFilter[])glAccountQ.toArray());
        Map accountAndCurPeriodMap = PeriodHelper.getCurrentPeriods(accountIds);
        if (glAccounts.size() > 0) {
            StringBuilder accountNameMsg = null;
            for (DynamicObject glAccount : glAccounts) {
                Long calAccountCurPeriodId;
                Long glAccountCurPeriodId = glAccount.getLong("curperiod");
                Long accountId = glAccount.getLong("b_entry.b_relatebook.fbasedataid.id");
                DynamicObject calAccountCurPeriod = (DynamicObject)accountAndCurPeriodMap.get(accountId);
                if (calAccountCurPeriod == null || (calAccountCurPeriodId = Long.valueOf(calAccountCurPeriod.getLong("id"))).compareTo(glAccountCurPeriodId) > 0) continue;
                accountNameMsg = accountNameMsg == null ? new StringBuilder() : accountNameMsg;
                accountNameMsg.append(',');
                accountNameMsg.append(((DynamicObject)accountMap.get(accountId)).getString("name"));
            }
            if (accountNameMsg != null) {
                return String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u5f53\u524d\u671f\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u603b\u8d26\u5f53\u524d\u4f1a\u8ba1\u671f\u95f4\u3002", (String)"SettleAccountPlugin_24", (String)"fi-cal-formplugin", (Object[])new Object[0]), CommonUtils.trimComma((String)accountNameMsg.toString()));
            }
        }
        if ((syncPeriod = CalDbParamServiceHelper.getInteger((String)"PrePeriodImBillSyncPeriod")) != null) {
            StringBuilder accountNameMsg = null;
            for (Map.Entry entry : accountAndCurPeriodMap.entrySet()) {
                int currentPeriodnumber;
                int currentPeriodyear;
                DynamicObject currentPeriodInfo = (DynamicObject)entry.getValue();
                if (currentPeriodInfo == null || (currentPeriodyear = currentPeriodInfo.getInt("periodyear")) * 100 + (currentPeriodnumber = currentPeriodInfo.getInt("periodnumber")) > syncPeriod) continue;
                accountNameMsg = accountNameMsg == null ? new StringBuilder() : accountNameMsg;
                accountNameMsg.append(',');
                accountNameMsg.append(((DynamicObject)accountMap.get(entry.getKey())).getString("name"));
            }
            if (accountNameMsg != null) {
                return String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u4e0d\u5141\u8bb8\u53cd\u7ed3\u8d26\u81f3\u8fc1\u79fb\u6570\u636e\u751f\u6210\u4e4b\u524d\u3002", (String)"SettleAccountPlugin_25", (String)"fi-cal-formplugin", (Object[])new Object[0]), CommonUtils.trimComma((String)accountNameMsg.toString()));
            }
        }
        return null;
    }

    private boolean checkPeriod(int[] selectedRowIndex) {
        ArrayList<Long> accountIds = new ArrayList<Long>(selectedRowIndex.length);
        for (int i = 0; i < selectedRowIndex.length; ++i) {
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("costaccount", selectedRowIndex[i]);
            Long costAccount = dynamicObject.getLong("id");
            accountIds.add(costAccount);
        }
        QFilter filter = new QFilter("entry.costaccount.id", "in", accountIds);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"entry.costaccount.name as costaccountname,entry.currentperiod currentperiod", (QFilter[])new QFilter[]{filter});
        Date nowDate = new Date();
        StringJoiner msg = new StringJoiner("\u3001");
        for (DynamicObject dynamicObject : dynamicObjects) {
            Date beginDate;
            String costAccountName = dynamicObject.getString("costaccountname");
            DynamicObject currentPeriod = PeriodHelper.getNextPeriod((Object)dynamicObject.getLong("currentperiod"));
            if (currentPeriod == null || !(beginDate = currentPeriod.getDate("begindate")).after(nowDate)) continue;
            msg.add(costAccountName);
        }
        String confirmMsg = msg.toString();
        if (StringUtils.isNotEmpty((String)confirmMsg)) {
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("periodConfirm", (IFormPlugin)this);
            String loadKDString = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u8584\u201c%1$s\u201d\u5bf9\u5e94\u7684\u7ed3\u8d26\u65e5\u671f\u5927\u4e8e\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4\uff0c\u662f\u5426\u7ee7\u7eed\u7ed3\u8d26\uff1f", (String)"SettleAccountPlugin_30", (String)"fi-cal-formplugin", (Object[])new Object[0]), confirmMsg);
            this.getView().showConfirm(loadKDString, null, MessageBoxOptions.YesNo, null, callBackListener, null, "");
            return false;
        }
        return true;
    }
}

