/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.account;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.message.api.MessageChannels;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.cal.business.account.SettleAccountFacade;
import kd.fi.cal.common.model.SimpleSettleAccountParam;

public class SettleAccountTask
extends AbstractTask {
    private String DLOCK_KEY = "settleaccount_cal";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext arg0, Map<String, Object> jobParams) throws KDException {
        SimpleSettleAccountParam param;
        String paramStr = (String)jobParams.get("param");
        try {
            param = (SimpleSettleAccountParam)JSONUtils.cast((String)paramStr, SimpleSettleAccountParam.class);
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        boolean isSettle = (Boolean)jobParams.get("isSettle");
        boolean isBackgroundInvoke = (Boolean)jobParams.get("backgroundInvoke");
        String settleName = ResManager.loadKDString((String)"\u7ed3\u8d26", (String)"SettleAccountTask_0", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        if (!isSettle) {
            settleName = ResManager.loadKDString((String)"\u53cd\u7ed3\u8d26", (String)"SettleAccountTask_1", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        }
        MessageInfo msgInfo = new MessageInfo();
        ArrayList<Long> userList = new ArrayList<Long>();
        userList.add(Long.valueOf(RequestContext.get().getUserId()));
        msgInfo.setUserIds(userList);
        msgInfo.setNotifyType(MessageChannels.MC.getNumber());
        String costAccountName = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u3010%1$s\u3011", (String)"CalculateInCostTask_11", (String)"fi-cal-formplugin", (Object[])new Object[0]), param.getCostAccountName());
        String content = String.format(ResManager.loadKDString((String)"%1$s\u5b8c\u6210", (String)"SettleAccountTask_4", (String)"fi-cal-formplugin", (Object[])new Object[0]), costAccountName + settleName);
        msgInfo.setContent(content);
        msgInfo.setTitle(settleName);
        long costAccountId = param.getCostAccountId();
        String key = this.DLOCK_KEY + costAccountId;
        try (DLock lock = DLock.create((String)key, (String)"fi-cal-settleaccount-dlock");){
            boolean isLocked = lock.tryLock();
            if (!isLocked) {
                String msg = String.format(ResManager.loadKDString((String)"%1$s\u6b63\u5728\u7ed3\u8d26\u6216\u53cd\u7ed3\u8d26\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"SettleAccountTask_5", (String)"fi-cal-formplugin", (Object[])new Object[0]), costAccountName);
                msgInfo.setContent(msg);
                return;
            }
            SettleAccountFacade settleAccountFacade = new SettleAccountFacade();
            settleAccountFacade.setBackgroundInvoke(isBackgroundInvoke);
            if (isSettle) {
                settleAccountFacade.doSettleAccount(new SimpleSettleAccountParam[]{param});
            } else {
                settleAccountFacade.doUnSettleAccount(new SimpleSettleAccountParam[]{param});
            }
        }
        finally {
            MessageCenterServiceHelper.sendMessage((MessageInfo)msgInfo);
        }
    }
}

