/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.back;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.lock.RedisBatchLock;

public class CleaCacheFormPlugin
extends AbstractFormPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperationResult() == null || !e.getOperationResult().isSuccess()) {
            return;
        }
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        if ("query".equals(key)) {
            this.queryCache();
        } else if ("clear".equals(key)) {
            this.clearCache();
        }
    }

    private void queryCache() {
        String appId = (String)this.getModel().getValue("appid");
        Set<String> cacheKeys = this.getValues("cachekeys");
        IAppCache cache = AppCache.get((String)appId);
        StringBuilder sb = new StringBuilder();
        for (String item : cacheKeys) {
            Object cacheValue = cache.get(item, Object.class);
            if (cacheValue == null) continue;
            cacheValue = cacheValue.toString();
            sb.append(item);
            sb.append("--");
            sb.append(cacheValue);
            sb.append("\r\n");
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 2, sb.length());
        }
        this.getModel().setValue("cachevalue", (Object)sb.toString());
    }

    private void clearCache() {
        String appId = (String)this.getModel().getValue("appid");
        String clearType = (String)this.getModel().getValue("cleartype");
        IAppCache cache = AppCache.get((String)appId);
        Set<String> cacheKeys = this.getValues("cachekeys");
        Set<String> billNos = this.getValues("billnos");
        Set<String> redisLockKeys = this.getValues("redislockkeys");
        DynamicObjectCollection entityDycs = (DynamicObjectCollection)this.getModel().getValue("bizentityobjects");
        HashSet<String> entitys = new HashSet<String>(entityDycs.size());
        if (entityDycs.size() > 0) {
            for (DynamicObject entityObject : entityDycs) {
                entitys.add(entityObject.getDynamicObject("fbasedataid").getString("number"));
            }
        }
        if ("A".equals(clearType)) {
            if (cacheKeys.isEmpty() || entitys.isEmpty() && redisLockKeys.isEmpty()) {
                return;
            }
            String redisCacheKey = cacheKeys.toArray(new String[0])[0];
            if (billNos.size() > 0) {
                Set<String> billIds = this.getLockKeyByBillnos(billNos, entitys);
                new RedisBatchLock().unlock(billIds);
            } else if (redisLockKeys.size() > 0) {
                new RedisBatchLock().unlock(redisLockKeys);
            } else {
                cache.remove(redisCacheKey);
            }
        } else if ("B".equals(clearType)) {
            for (String item : cacheKeys) {
                cache.remove(item);
            }
        }
        this.queryCache();
    }

    private Set<String> getLockKeyByBillnos(Set<String> billNos, Set<String> entitys) {
        ArrayList<OrmInput> billOIs = new ArrayList<OrmInput>(16);
        HashSet<String> billIds = new HashSet<String>(16);
        for (String entity : entitys) {
            MainEntityType billEntityType = EntityMetadataCache.getDataEntityType((String)entity);
            String billNoField = ((BillEntityType)billEntityType).getBillNo();
            QFilter billNoF = new QFilter(billNoField, "in", billNos);
            OrmInput inOI = new OrmInput(((Object)((Object)this)).getClass().getName(), entity, "id", billNoF.toArray());
            billOIs.add(inOI);
        }
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        try (DataSet allBillDs = algo.createDataSet((Input[])billOIs.toArray(new OrmInput[billOIs.size()]));){
            for (Row row : allBillDs) {
                billIds.add(row.getString("id"));
            }
        }
        return billIds;
    }

    private Set<String> getValues(String key) {
        String valuesStr = (String)this.getModel().getValue(key);
        if (StringUtils.isEmpty((String)valuesStr)) {
            valuesStr = (String)this.getModel().getValue(key + "_tag");
        }
        HashSet<String> Values2 = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((String)valuesStr)) {
            Values2.addAll(Arrays.asList(valuesStr.split("\\s+|[\\r\\n]+")));
        }
        return Values2;
    }
}

