/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.balance;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDException;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;

public class CalCleaZeroCostElementTask
extends AbstractTask {
    private Boolean isDealInit = false;

    public void execute(RequestContext ctx, Map<String, Object> paramMap) throws KDException {
        this.isDealInit = paramMap.get("begindate") == null || "null".equals(paramMap.get("begindate"));
        QFilter detailQ = new QFilter("costaccount", "=", SerializationUtils.fromJsonString((String)((String)paramMap.get("accountid")), Long.class));
        detailQ.and("billstatus", "=", (Object)"C");
        if (!this.isDealInit.booleanValue()) {
            detailQ.and("bookdate", ">=", SerializationUtils.fromJsonString((String)((String)paramMap.get("begindate")), Date.class));
        }
        detailQ.and("bookdate", "<", SerializationUtils.fromJsonString((String)((String)paramMap.get("enddate")), Date.class));
        QFilter recordDetailQ = detailQ.copy();
        recordDetailQ.and("entry.subentrycostelement.sub_actualcost", "=", (Object)BigDecimal.ZERO);
        recordDetailQ.and("entry.subentrycostelement.sub_standardcost", "=", (Object)BigDecimal.ZERO);
        if (this.isDealInit.booleanValue()) {
            recordDetailQ.and("isinitbill", "=", (Object)Boolean.TRUE);
        }
        DataSet recordZeroCostDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord_subentity", (String)"entry.subentrycostelement.id as detailid", (QFilter[])recordDetailQ.toArray(), null);
        DBRoute route = new DBRoute("cal");
        this.doDeleteDetail(recordZeroCostDs, route, "t_cal_costrecord_detail");
        if (!this.isDealInit.booleanValue()) {
            QFilter adjustDetailQ = detailQ.copy();
            adjustDetailQ.and("entryentity.subentryentity.sub_adjustamt", "=", (Object)BigDecimal.ZERO);
            DataSet adjustZeroCostDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costadjust_subentity", (String)"entryentity.subentryentity.id as detailid", (QFilter[])adjustDetailQ.toArray(), null);
            this.doDeleteDetail(adjustZeroCostDs, route, "t_cal_costadjust_detail");
        }
    }

    private void doDeleteDetail(DataSet dataSet, DBRoute route, String tbName) {
        ArrayList<Long> detailIdList = new ArrayList<Long>(16);
        for (Row row : dataSet) {
            detailIdList.add(row.getLong("detailid"));
        }
        if (detailIdList.isEmpty()) {
            return;
        }
        Lists.partition(detailIdList, (int)5000).forEach(list -> {
            SqlBuilder balSql = new SqlBuilder();
            balSql.append("DELETE FROM ", new Object[0]);
            balSql.append(tbName, new Object[0]);
            balSql.append(" WHERE ", new Object[0]);
            balSql.appendIn("fdetailid", list.toArray());
            DB.execute((DBRoute)route, (SqlBuilder)balSql);
        });
    }
}

