/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.balance.recal;

import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.ID;
import kd.bos.id.IDRange;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.balance.recal.CalBalReCalByMatHandle;
import kd.fi.cal.business.balance.recal.CalBalReCalCache;
import kd.fi.cal.business.balance.recal.CalBalRecalHandle;

public class CalReCalBalEdit
extends AbstractFormPlugin
implements ProgresssListener {
    private static final ThreadPool POOL = ThreadPools.newFixedThreadPool((String)"cal_recal", (int)1);
    protected static final Log logger = LogFactory.getLog(CalReCalBalEdit.class);
    private static final String BT_PERIOD_CLEAR = "period_clear";
    private static final String BT_PERIOD_SET_0 = "period_set0";
    private static final String BT_PERIOD_RECAL = "period_recal";
    private static final String BT_PERIOD_CLEAR_SNAP = "period_clear_snap";
    private static final String BT_PERIOD_CHENGE_ENGINE = "period_chenge_engine";
    private static final String BT_PERIOD_CLEAR_BY_BAL_FS = "period_clear_bybalfs";
    private static final String BT_PERIOD_SET_0_BY_BAL_FS = "period_set0_bybalfs";
    private static final String BT_PERIOD_RECAL_BY_BAL_FS = "period_recal_bybalfs";
    private static final String F_PERIOD_BALS = "period_bals";
    private static final String F_PERIOD_IS_NEW = "period_isnew";
    private static final String F_COST_ACTS = "costaccounts";
    private static final String F_START_PERIOD = "startperiod";
    private static final String BT_RECAL_BYBILLFS = "recal_bybillfs";
    private static final String F_BILL = "bill";
    private static final String F_START_DATE = "startdate";
    private static final String F_END_DATE = "enddate";
    private static final String AP_BILL_FS = "bill_fs";
    private static final String F_BILL_IDS = "billids_tag";
    private static final String BT_RECAL_BYBILL_IDS = "recal_bybillids";
    private static final String PERIOD_RECAL_BMAT = "period_recal_bmat";
    private static final String F_MATERIAL = "material";
    private static final String BT_SHOW_RECAL_TASKS = "show_recal_tasks";
    private static final String BT_SAVE_RECAL_POINT = "save_recal_point";
    private static final String BT_SHOW_RECAL_POINT = "show_recal_point";
    private static final String F_START = "start";
    private static final String F_PHONE = "pwd";
    private static final String F_RESULT_INFO = "resultinfo";
    private static final String F_BATCH_COUNT = "batchcount";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.getProgressBar().addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{BT_PERIOD_CLEAR, BT_PERIOD_SET_0, BT_PERIOD_RECAL, BT_PERIOD_CLEAR_SNAP, BT_PERIOD_CHENGE_ENGINE, BT_PERIOD_CLEAR_BY_BAL_FS, BT_PERIOD_SET_0_BY_BAL_FS, BT_PERIOD_RECAL_BY_BAL_FS, BT_RECAL_BYBILLFS, BT_SHOW_RECAL_TASKS, BT_SAVE_RECAL_POINT, BT_SHOW_RECAL_POINT, BT_RECAL_BYBILL_IDS, PERIOD_RECAL_BMAT});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        boolean isCalByMat = PERIOD_RECAL_BMAT.equals(((Control)source).getKey());
        if (!isCalByMat && !new SimpleDateFormat("yyddMM").format(new Date()).equals(this.getModel().getValue(F_PHONE))) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8fd9\u662f\u4e13\u7528\u7684\u5347\u7ea7\u9762\u677f\uff0c\u8bf7\u52ff\u968f\u610f\u64cd\u4f5c\u4e0a\u9762\u6309\u94ae\uff0c\u907f\u514d\u6570\u636e\u9519\u4e71\u3002\u82e5\u8981\u64cd\u4f5c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458", (String)"CalReCalBalEdit_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        if (source instanceof Button) {
            String key;
            this.addBatchCount2Cache();
            switch (key = ((Button)source).getKey()) {
                case "period_clear": {
                    this.periodClear();
                    break;
                }
                case "period_set0": {
                    this.periodSet0();
                    break;
                }
                case "period_recal": {
                    this.periodReCal();
                    break;
                }
                case "period_clear_snap": {
                    this.periodClearSnap();
                    break;
                }
                case "period_chenge_engine": {
                    this.periodChangeEngine();
                    break;
                }
                case "period_clear_bybalfs": {
                    this.periodClearByBalFs();
                    break;
                }
                case "period_set0_bybalfs": {
                    this.periodSet0ByBalFs();
                    break;
                }
                case "period_recal_bybalfs": {
                    this.periodReCalByBalFs();
                    break;
                }
                case "recal_bybillfs": {
                    this.reCalByBillFs();
                    break;
                }
                case "period_recal_bmat": {
                    this.reCalByMat();
                    break;
                }
                case "show_recal_tasks": {
                    this.showReCalTask();
                    break;
                }
                case "save_recal_point": {
                    this.saveReCalPoint();
                    break;
                }
                case "show_recal_point": {
                    this.showReCalPoint();
                    break;
                }
                case "recal_bybillids": {
                    this.reCalByBillIds();
                    break;
                }
            }
        }
    }

    private void reCalByBillIds() {
        final String bill = this.getBill();
        if (bill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a", (String)"CalReCalBalEdit_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        final String[] balTBs = this.getPeriodBal(true);
        if (balTBs == null) {
            return;
        }
        final Set<Object> billIds = this.getBillIds();
        if (billIds.isEmpty()) {
            return;
        }
        POOL.execute(new Runnable(){

            @Override
            public void run() {
                CalBalRecalHandle.reCalByBillIds((String)bill, (String[])balTBs, (Set)billIds);
            }
        });
    }

    private Set<Object> getBillIds() {
        String ids = this.getModel().getDataEntity().getString(F_BILL_IDS);
        HashSet<Object> idSet = new HashSet<Object>(1024);
        try {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)ids)) {
                String[] idStrs;
                for (String idStr : idStrs = ids.split(",")) {
                    idSet.add(Long.valueOf(org.apache.commons.lang3.StringUtils.trim((String)idStr)));
                }
            }
        }
        catch (NumberFormatException e) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5355\u636eID\u8f93\u5165\u4e0d\u5408\u6cd5\uff1a%1$s", (String)"CalReCalBalEdit_2", (String)"fi-cal-formplugin", (Object[])new Object[0]), e.getMessage()));
            idSet.clear();
            return idSet;
        }
        if (idSet.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a", (String)"CalReCalBalEdit_3", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        return idSet;
    }

    private List<Long> getCostActs(boolean check) {
        ArrayList<Long> ids = new ArrayList<Long>(20);
        DynamicObjectCollection datas = this.getModel().getDataEntity().getDynamicObjectCollection(F_COST_ACTS);
        for (DynamicObject data : datas) {
            ids.add(data.getLong("fbasedataid_id"));
        }
        if (check && (ids.size() > 1000 || ids.isEmpty())) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u6570\u91cf\u81f3\u5c11\u9009\u62e91\u4e2a\uff0c\u6700\u591a\u9009\u62e91000\u4e2a\u3002", (String)"CalReCalBalEdit_4", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return null;
        }
        return ids;
    }

    private void periodSet0ByBalFs() {
        final String[] balTBs = this.getPeriodBal(true);
        if (balTBs == null) {
            return;
        }
        final List<Long> costAccountIds = this.getCostActs(true);
        if (costAccountIds == null) {
            return;
        }
        POOL.execute(new Runnable(){

            @Override
            public void run() {
                CalBalRecalHandle.periodSet0ByBalFs((String[])balTBs, (List)costAccountIds);
            }
        });
    }

    private void periodClearByBalFs() {
        final String[] balTBs = this.getPeriodBal(true);
        if (balTBs == null) {
            return;
        }
        DynamicObject data = this.getModel().getDataEntity();
        final List<Long> costAccountIds = this.getCostActs(true);
        if (costAccountIds == null) {
            return;
        }
        final int period = data.getInt(F_START_PERIOD);
        POOL.execute(new Runnable(){

            @Override
            public void run() {
                CalBalRecalHandle.periodClearByBalFs((String[])balTBs, (List)costAccountIds, (int)period);
            }
        });
    }

    private void addBatchCount2Cache() {
        int batch = this.getModel().getDataEntity().getInt(F_BATCH_COUNT);
        CalBalReCalCache.setBatchCount((int)batch);
    }

    private void periodChangeEngine() {
        boolean isNew = this.getModel().getDataEntity().getBoolean(F_PERIOD_IS_NEW);
        CalBalRecalHandle.periodChangeEngine((!isNew ? 1 : 0) != 0);
        this.loadBalanceFlag();
    }

    private void periodClearSnap() {
        final String[] balTBs = this.getPeriodBal(true);
        if (balTBs == null) {
            return;
        }
        POOL.execute(new Runnable(){

            @Override
            public void run() {
                CalBalRecalHandle.clearSnapData((String[])balTBs);
            }
        });
    }

    private void showReCalPoint() {
        ListShowParameter fsp = new ListShowParameter();
        fsp.setBillFormId("cal_recal_point");
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)fsp);
        this.test();
    }

    private void test() {
        Calendar cal = Calendar.getInstance();
        cal.set(2021, 0, 1);
        long form = 0L;
        long to = 0L;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < 40; ++i) {
            Date date = cal.getTime();
            IDRange idRange = ID.getIDRangeOfDay((Date)date);
            form = to = idRange.getMaxId();
            cal.add(5, 5);
        }
    }

    private void saveReCalPoint() {
        Date start = this.getModel().getDataEntity().getDate(F_START);
        if (start == null) {
            return;
        }
        QFilter fs = new QFilter(F_START, "=", (Object)start);
        fs.and("status", "!=", (Object)"A");
        boolean exists = QueryServiceHelper.exists((String)"cal_recal_msg", (QFilter[])fs.toArray());
        if (exists) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u672c\u6b21\u91cd\u7b97\u8fd8\u6709\u672a\u6210\u529f\u7684\u6d88\u606f\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff0c\u5904\u7406\u5b8c\u540e\u518d\u64cd\u4f5c", (String)"CalReCalBalEdit_5", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        Calendar instance = Calendar.getInstance();
        instance.setTimeInMillis(start.getTime());
        instance.add(13, 1);
        Date end = instance.getTime();
        fs = new QFilter("createtime", ">=", (Object)start).and("createtime", "<", (Object)end).and("status", "=", (Object)"B");
        CharSequence[] cols = new String[]{"id", "status"};
        DynamicObject[] ponits = BusinessDataServiceHelper.load((String)"cal_recal_point", (String)String.join((CharSequence)",", cols), (QFilter[])fs.toArray());
        if (ponits.length > 0) {
            for (DynamicObject ponit : ponits) {
                ponit.set("status", (Object)"A");
            }
            SaveServiceHelper.save((DynamicObject[])ponits);
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff0c\u5171%1$s\u6761", (String)"CalReCalBalEdit_6", (String)"fi-cal-formplugin", (Object[])new Object[0]), ponits.length));
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u8282\u70b9\u4fe1\u606f\u53ef\u4fdd\u5b58\u6216\u5df2\u4fdd\u5b58\u8fc7", (String)"CalReCalBalEdit_7", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }

    private void showReCalTask() {
        ListShowParameter fsp = new ListShowParameter();
        fsp.setBillFormId("cal_recal_msg");
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)fsp);
    }

    private void periodReCalByBalFs() {
        final String[] balTBs = this.getPeriodBal(true);
        if (balTBs == null) {
            return;
        }
        DynamicObject data = this.getModel().getDataEntity();
        final List<Long> costAccountIds = this.getCostActs(true);
        if (costAccountIds == null) {
            return;
        }
        final int period = data.getInt(F_START_PERIOD);
        if (period < 201801 || period > 209912) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5408\u6cd5\u7684\u671f\u95f4", (String)"CalReCalBalEdit_8", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        final Date start = this.getStart(true);
        if (start == null) {
            return;
        }
        POOL.execute(new Runnable(){

            @Override
            public void run() {
                CalBalRecalHandle.periodReCalByBalFs((Date)start, (String[])balTBs, (List)costAccountIds, (int)period);
            }
        });
    }

    private void periodReCal() {
        final String[] balTBs = this.getPeriodBal(true);
        if (balTBs == null) {
            return;
        }
        final Date start = this.getStart(true);
        if (start == null) {
            return;
        }
        POOL.execute(new Runnable(){

            @Override
            public void run() {
                CalBalRecalHandle.periodReCal((Date)start, (String[])balTBs);
            }
        });
    }

    private void periodSet0() {
        final String[] balTBs = this.getPeriodBal(true);
        if (balTBs == null) {
            return;
        }
        POOL.execute(new Runnable(){

            @Override
            public void run() {
                CalBalRecalHandle.set0((String[])balTBs);
            }
        });
    }

    private void periodClear() {
        final String[] balTBs = this.getPeriodBal(true);
        if (balTBs == null) {
            return;
        }
        POOL.execute(new Runnable(){

            @Override
            public void run() {
                CalBalRecalHandle.clearBals((String[])balTBs);
            }
        });
    }

    private QFilter getBillIdFs() {
        IDRange idRange;
        DynamicObject data = this.getModel().getDataEntity();
        Date startDate = data.getDate(F_START_DATE);
        Date endDate = data.getDate(F_END_DATE);
        QFilter fs = null;
        if (startDate != null) {
            idRange = ID.getIDRangeOfDay((Date)startDate);
            fs = new QFilter("id", ">=", (Object)idRange.getMinId());
        }
        if (endDate != null) {
            idRange = ID.getIDRangeOfDay((Date)startDate);
            if (fs == null) {
                fs = new QFilter("id", "<=", (Object)idRange.getMinId());
            } else {
                fs.and("id", ">=", (Object)idRange.getMinId());
            }
        }
        return fs;
    }

    private void reCalByBillFs() {
        String[] balTBs = this.getPeriodBal(true);
        if (balTBs == null) {
            return;
        }
        QFilter fs = this.getBillIdFs();
        final String bill = this.getBill();
        if (bill != null) {
            QFilter billFs = this.getBillFs(bill);
            if (fs == null) {
                fs = billFs;
            } else if (billFs != null) {
                fs = fs.and(billFs);
            }
        }
        final Date finalStart = this.getStart(true);
        final QFilter finalFs = fs;
        final String[] finalBalTBs = balTBs;
        if (finalStart == null) {
            return;
        }
        POOL.execute(new Runnable(){

            @Override
            public void run() {
                CalBalRecalHandle.reCalByBillFs((Date)finalStart, (String[])finalBalTBs, (QFilter)finalFs, (String)bill);
            }
        });
    }

    private QFilter getBillFs(String bill) {
        if (bill == null) {
            return null;
        }
        FilterGrid grid = (FilterGrid)this.getControl(AP_BILL_FS);
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        FilterBuilder fb = new FilterBuilder(MetadataServiceHelper.getDataEntityType((String)bill), condition);
        fb.buildFilter();
        QFilter fs = fb.getQFilter();
        return fs;
    }

    private Date getStart(boolean checkAndSet) {
        Date start = this.getModel().getDataEntity().getDate(F_START);
        if (start != null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u6e05\u7a7a\u5f00\u59cb\u65f6\u95f4\uff0c\u6216\u8005\u6839\u636e\u5f00\u59cb\u65f6\u95f4\u67e5\u8be2\u5df2\u5f00\u59cb\u7684\u4efb\u52a1", (String)"CalReCalBalEdit_9", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return null;
        }
        Calendar cd = Calendar.getInstance();
        cd.set(14, 0);
        start = cd.getTime();
        this.getModel().setValue(F_START, (Object)start);
        return start;
    }

    private String[] getPeriodBal(boolean check) {
        return this.getBal(check, F_PERIOD_BALS, ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u671f\u95f4\u4f59\u989d\u8868", (String)"CalReCalBalEdit_10", (String)"fi-cal-formplugin", (Object[])new Object[0]));
    }

    private String[] getBal(boolean check, String balCol, String msg) {
        String bals = this.getModel().getDataEntity().getString(balCol);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bals)) {
            String[] tempBals;
            ArrayList<String> tbs = new ArrayList<String>(2);
            for (String tb : tempBals = bals.split(",")) {
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)tb)) continue;
                tbs.add(tb);
            }
            if (!tbs.isEmpty()) {
                return tbs.toArray(new String[0]);
            }
        }
        if (check) {
            this.getView().showMessage(msg);
        }
        return null;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.loadBalanceFlag();
    }

    private void loadBalanceFlag() {
        boolean isnew = CalBalRecalHandle.reLoadPeriodBalFlag();
        this.getModel().setValue(F_PERIOD_IS_NEW, (Object)isnew);
    }

    public void onProgress(ProgressEvent e) {
        JSONObject data = CalBalReCalCache.getReCalPercent();
        int percent = data.getIntValue("percent");
        if (percent >= 100) {
            percent = 99;
        }
        e.setProgress(percent);
        e.setText("");
        this.getModel().setValue(F_RESULT_INFO, (Object)data.getString("text"));
    }

    private ProgressBar getProgressBar() {
        return (ProgressBar)this.getView().getControl("progressap");
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getProgressBar().stop();
    }

    public void afterCreateNewData(EventObject e) {
        this.getProgressBar().start();
        CalBalReCalCache.setReCalPercent((int)0, (String)ResManager.loadKDString((String)"\u6682\u65e0\u64cd\u4f5c\u6267\u884c\u3002\u3002\u3002", (String)"CalReCalBalEdit_11", (String)"fi-cal-formplugin", (Object[])new Object[0]));
    }

    private String getBill() {
        DynamicObject bill = this.getModel().getDataEntity().getDynamicObject(F_BILL);
        if (bill != null) {
            return bill.getString("id");
        }
        return null;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "bill": {
                this.billChanged(e);
                break;
            }
            case "batchcount": {
                this.batchCountChanged(e);
                break;
            }
        }
    }

    private void batchCountChanged(PropertyChangedArgs e) {
        int batch = this.getModel().getDataEntity().getInt(F_BATCH_COUNT);
        if (batch > 0 && batch <= 20000) {
            CalBalReCalCache.setBatchCount((int)batch);
        }
    }

    private void billChanged(PropertyChangedArgs e) {
        String billName = this.getBill();
        this.setCols4FilterGrid(billName, AP_BILL_FS, new Predicate<Map<String, Object>>(){

            @Override
            public boolean test(Map<String, Object> info) {
                return true;
            }
        });
    }

    private void setCols4FilterGrid(String entityName, String grid, Predicate<Map<String, Object>> predicate) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(grid);
        filterGrid.SetValue(new FilterCondition());
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)entityName)) {
            filterGrid.setFilterColumns(new ArrayList());
        } else {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityName);
            EntityTypeUtil helper = new EntityTypeUtil();
            List cols = helper.getFilterColumns((IDataEntityType)entityType).stream().filter(predicate).collect(Collectors.toList());
            filterGrid.setEntityNumber(entityType.getName());
            filterGrid.setFilterColumns(cols);
        }
        this.getView().updateView(grid);
    }

    private Set<Long> getMatIds() {
        HashSet<Long> ids = new HashSet<Long>(20);
        DynamicObjectCollection datas = this.getModel().getDataEntity().getDynamicObjectCollection(F_MATERIAL);
        for (DynamicObject data : datas) {
            ids.add(data.getLong("fbasedataid_id"));
        }
        ids = ids.isEmpty() ? null : ids;
        return ids;
    }

    private void reCalByMat() {
        String[] balTBs = this.getPeriodBal(true);
        int period = this.getModel().getDataEntity(true).getInt(F_START_PERIOD);
        if (balTBs == null) {
            return;
        }
        Set<Long> matIds = this.getMatIds();
        if (matIds == null || matIds.isEmpty()) {
            CalBalReCalCache.setReCalPercent((int)100, (String)"0%\uff1ano material");
            return;
        }
        List<Long> costAccountIds = this.getCostActs(true);
        if (costAccountIds == null) {
            return;
        }
        Date finalStart = this.getStart(true);
        if (finalStart == null) {
            return;
        }
        Set<String> lotNums = this.getLotNums();
        CalBalReCalByMatHandle calBalReCalByMatHandle = new CalBalReCalByMatHandle(balTBs, costAccountIds, period, matIds);
        calBalReCalByMatHandle.setLotNums(lotNums);
        int batch = this.getModel().getDataEntity().getInt(F_BATCH_COUNT);
        calBalReCalByMatHandle.setBatch(batch);
        calBalReCalByMatHandle.handle();
    }

    private Set<String> getLotNums() {
        String lotNumStr = (String)this.getModel().getValue("lot");
        if (StringUtils.isEmpty((String)lotNumStr)) {
            lotNumStr = (String)this.getModel().getValue("lot_tag");
        }
        HashSet<String> lotNums = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((String)lotNumStr)) {
            lotNums.addAll(Arrays.asList(lotNumStr.split("\\s+|[\\r\\n]+")));
        }
        return lotNums;
    }
}

