/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.base;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.ReportF7Helper;

public class AccountTypePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
EntryGridBindDataListener {
    private static final String ACCOUNT_COSTTYPE = "accountcosttype";
    private static final String ACCOUNT_COST_TYPEVALUE = "B";

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("calrange".equals(key)) {
            this.calRangeChanged();
        }
        if ("material".equals(key)) {
            this.materialChanged(e.getChangeSet()[0].getRowIndex());
        }
        if ("materialgroup".equals(key)) {
            this.materialGroupChanged(e.getChangeSet()[0].getRowIndex());
        }
        if ("accounttype".equals(key)) {
            this.accountTypeChanged(e);
        }
    }

    private void accountTypeChanged(PropertyChangedArgs e) {
        if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            return;
        }
        String oldAccountType = (String)e.getChangeSet()[0].getOldValue();
        String rowIndex = String.valueOf(e.getChangeSet()[0].getRowIndex());
        if (StringUtils.isEmpty((CharSequence)oldAccountType)) {
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u8ba1\u4ef7\u65b9\u6cd5\u8bbe\u7f6e\u540e\uff0c\u8bf7\u52ff\u968f\u610f\u4fee\u6539\uff0c\u5982\u9700\u4fee\u6539\uff0c\u8bf7\u5220\u9664\u76f8\u5173\u4e1a\u52a1\u5355\u636e\uff1b\u5982\u9700\u8981\u5728\u5df2\u6709\u4e1a\u52a1\u7684\u60c5\u51b5\u4e0b\u4fee\u6539\u8ba1\u4ef7\u65b9\u6cd5\uff0c\u5efa\u8bae\u8054\u7cfb\u60a8\u7684\u670d\u52a1\u5de5\u7a0b\u5e08\u8fdb\u884c\u5904\u7406\uff0c\u5426\u5219\u6709\u53ef\u80fd\u4f1a\u9020\u6210\u6838\u7b97\u6570\u636e\u4e0d\u51c6\u786e\u3002\u786e\u8ba4\u4fee\u6539\u8ba1\u4ef7\u65b9\u6cd5\uff1f", (String)"CalRangePlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, null, new ConfirmCallBackListener("accountType", (IFormPlugin)this), null, rowIndex + "," + oldAccountType);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if (e.getResult().equals((Object)MessageBoxResult.No)) {
            String[] params = e.getCustomVaule().split(",");
            this.getModel().beginInit();
            this.getModel().setValue("accounttype", (Object)params[1], Integer.parseInt(params[0]));
            this.getModel().endInit();
            this.getView().updateView("accounttype", Integer.parseInt(params[0]));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        for (RowDataEntity row : e.getRows()) {
            int rowIndex = row.getRowIndex();
            DynamicObject materialGroup = (DynamicObject)this.getModel().getValue("materialgroup", rowIndex);
            DynamicObject material = (DynamicObject)this.getModel().getValue("material", rowIndex);
            if (material != null) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"materialgroup"});
            }
            if (materialGroup == null) continue;
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"material"});
        }
    }

    public void materialGroupChanged(int row) {
        DynamicObject materialGroup = (DynamicObject)this.getModel().getValue("materialgroup", row);
        if (materialGroup == null) {
            this.getView().setEnable(Boolean.TRUE, row, new String[]{"material"});
        } else {
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"material"});
        }
    }

    public void materialChanged(int row) {
        this.getModel().setValue(this.getKey(), null, row);
        DynamicObject material = (DynamicObject)this.getModel().getValue("material", row);
        if (material == null) {
            this.getView().setEnable(Boolean.TRUE, row, new String[]{"materialgroup"});
        } else {
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"materialgroup"});
        }
    }

    public void calRangeChanged() {
        DynamicObject calRange = this.getModel().getDataEntity().getDynamicObject("calrange");
        if (calRange == null) {
            this.getModel().setValue("calorg", null);
            this.getModel().setValue("calsystem", null);
            return;
        }
        DynamicObject costaccount = calRange.getDynamicObject("costaccount");
        costaccount = BusinessDataServiceHelper.loadSingle((Object)costaccount.getPkValue(), (String)"cal_bd_costaccount");
        DynamicObject calOrg = costaccount.getDynamicObject("calorg");
        DynamicObject calSystem = costaccount.getDynamicObject("calsystem");
        this.getModel().setValue("calorg", calOrg.get("id"));
        this.getModel().setValue("calsystem", calSystem.get("id"));
        ComboEdit accounttypeEdit = (ComboEdit)this.getControl("accounttype");
        if (accounttypeEdit != null) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
            DynamicObject[] selectedRowIndexs = entryGrid.getEntryData().getDataEntitys();
            if (selectedRowIndexs != null && selectedRowIndexs.length > 0) {
                for (int i = 0; i < selectedRowIndexs.length; ++i) {
                    this.getModel().setValue("accounttype", null, i);
                }
            }
            boolean companyAccountFlag = this.checkCompanyAccountBookType(costaccount);
            this.setAccounttypeValue(companyAccountFlag, accounttypeEdit);
        }
    }

    private void setAccounttypeValue(boolean companyAccountFlag, ComboEdit accounttypeEdit) {
        HashSet<String> accountTypeSet = new HashSet<String>(16);
        if (companyAccountFlag) {
            accountTypeSet.add(AccountTypeEnum.ADD_AVERAGE.getValue());
            accountTypeSet.add(AccountTypeEnum.STANDARDCOST.getValue());
        } else {
            accountTypeSet.add(AccountTypeEnum.ADD_AVERAGE.getValue());
            accountTypeSet.add(AccountTypeEnum.SPECIAL_ACCT.getValue());
            accountTypeSet.add(AccountTypeEnum.MOVE_ADD_AVERAGE.getValue());
            accountTypeSet.add(AccountTypeEnum.STANDARDCOST.getValue());
            accountTypeSet.add(AccountTypeEnum.FIN_FOUT.getValue());
            accountTypeSet.add(AccountTypeEnum.FIN_FOUT_PERIOD.getValue());
        }
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(16);
        if (accountTypeSet.size() > 0) {
            for (AccountTypeEnum accountTypeEnum : AccountTypeEnum.values()) {
                if (!accountTypeSet.contains(accountTypeEnum.getValue())) continue;
                ComboItem comboItem = new ComboItem();
                comboItem.setValue(accountTypeEnum.getValue());
                comboItem.setCaption(new LocaleString(accountTypeEnum.getDesEveryTime()));
                comboItem.setItemVisible(true);
                propertyItems.add(comboItem);
            }
        }
        accounttypeEdit.setComboItems(propertyItems);
    }

    private boolean checkCompanyAccountBookType(DynamicObject costAccount) {
        String accountcosttype;
        boolean companyAccountFlag = false;
        if (costAccount != null && !StringUtils.isEmpty((CharSequence)(accountcosttype = costAccount.getString(ACCOUNT_COSTTYPE))) && ACCOUNT_COST_TYPEVALUE.equals(accountcosttype)) {
            companyAccountFlag = true;
        }
        return companyAccountFlag;
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("calorg", null);
    }

    public String getKey() {
        return "accounttype";
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, "calrange");
        this.addF7Listener(this, "material");
        this.addF7Listener(this, "materialgroup");
        EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("calrange".equals(key)) {
            this.beforeF7Select4CalRange(e);
        } else if ("material".equals(key)) {
            ReportF7Helper.beforeF7Select4Material((BeforeF7SelectEvent)e);
        } else if ("materialgroup".equals(key)) {
            ReportF7Helper.beforeF7Select4StandardMatGroup((BeforeF7SelectEvent)e);
        }
    }

    private void beforeF7Select4CalRange(BeforeF7SelectEvent e) {
        List<Long> orgList = this.getAllPermOrgs();
        if (orgList != null) {
            QFilter q = new QFilter("headcalorg", "in", orgList);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public List<Long> getAllPermOrgs() {
        String appInnerId;
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)(appInnerId = AppMetadataCache.getAppInfo((String)"cal").getId()), (String)this.getMainEntityName(), (String)"47156aff000000ac");
        if (!rs.hasAllOrgPerm()) {
            return rs.getHasPermOrgs();
        }
        return null;
    }

    public String getMainEntityName() {
        return "cal_bd_accounttype";
    }

    public void initImportData(InitImportDataEventArgs e) {
        HashSet<String> numberSet = new HashSet<String>(16);
        List sourceDataList = e.getSourceDataList();
        for (Map sourceData : sourceDataList) {
            JSONObject calrange = (JSONObject)sourceData.get("calrange");
            String number = (String)calrange.get((Object)"number");
            numberSet.add(number);
        }
        HashMap<String, Long> calorgNumberIdMap = new HashMap<String, Long>(16);
        HashMap<String, Long> calsystemNumberIdMap = new HashMap<String, Long>(16);
        QFilter filter = new QFilter("number", "in", numberSet);
        DynamicObjectCollection calrangeColl = QueryServiceHelper.query((String)"cal_bd_calrange", (String)"number,costaccount.calorg,costaccount.calsystem", (QFilter[])filter.toArray());
        for (DynamicObject calrange : calrangeColl) {
            String number = calrange.getString("number");
            Long calorgid = calrange.getLong("costaccount.calorg");
            calorgNumberIdMap.put(number, calorgid);
            Long calsystemid = calrange.getLong("costaccount.calsystem");
            calsystemNumberIdMap.put(number, calsystemid);
        }
        for (Map sourceData : sourceDataList) {
            Long calsystemId;
            JSONObject calrange = (JSONObject)sourceData.get("calrange");
            String number = (String)calrange.get((Object)"number");
            Long calorgId = (Long)calorgNumberIdMap.get(number);
            if (calorgId != null) {
                sourceData.put("calorg_id", calorgId);
            }
            if ((calsystemId = (Long)calsystemNumberIdMap.get(number)) == null) continue;
            sourceData.put("calsystem_id", calsystemId);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        DynamicObject costaccount;
        DynamicObject calRange;
        ComboEdit accounttypeEdit = (ComboEdit)this.getControl("accounttype");
        if (accounttypeEdit != null && (calRange = this.getModel().getDataEntity().getDynamicObject("calrange")) != null && (costaccount = calRange.getDynamicObject("costaccount")) != null) {
            costaccount = BusinessDataServiceHelper.loadSingle((Object)costaccount.getPkValue(), (String)"cal_bd_costaccount");
            boolean companyAccountFlag = this.checkCompanyAccountBookType(costaccount);
            this.setAccounttypeValue(companyAccountFlag, accounttypeEdit);
        }
    }
}

