/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.base;

import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.events.SetFilterContainerFlatEvent;
import kd.bos.form.events.FilterColumnSetFilterEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.ListColumnCompareTypesSetEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.cal.common.constant.CalPeriodCustomCompareConst;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.util.FilterContainerUtil;

public class CalOrgAcctLinkListPlugin
extends AbstractListPlugin {
    private boolean orgClick = false;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().put("cal_isinit", "true");
    }

    public void filterContainerSetFlat(SetFilterContainerFlatEvent args) {
        args.setNewFilter(false);
        super.filterContainerSetFlat(args);
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        if (this.getCostAcctFilterName().equals(args.getFieldName())) {
            args.addCustomQFilter(this.getCostaccountFilter(args));
            args.setOrderBy("ismainaccount desc,enable desc");
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        if (this.orgClick) {
            FilterContainerUtil.deleteCustomFilter((FilterContainerSearchClickArgs)args, (String)"costaccount.id");
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        boolean isInit = "true".equals(this.getPageCache().get("cal_isinit"));
        ControlFilters filters = this.getControlFilters();
        if (filters != null) {
            List orgValues = filters.getFilter("calorg.id");
            List orgIdValues = filters.getFilter("org.id");
            if (orgIdValues != null && !orgIdValues.isEmpty()) {
                orgValues = orgIdValues;
            }
            boolean orgNotNull = orgValues != null && orgValues.size() > 0;
            String oldOrgId = this.getPageCache().get("cal_orgid");
            String orgId = "";
            if (orgNotNull) {
                orgId = orgValues.get(0);
            }
            if (!orgId.toString().equals(oldOrgId)) {
                this.orgClick = true;
            }
            Boolean isAllOrg = orgValues != null && orgValues.size() > 1 || StringUtils.isEmpty((CharSequence)orgId.toString());
            boolean oldIsAllOrg = Boolean.parseBoolean(this.getPageCache().get("cal_allOrg"));
            if (isAllOrg.booleanValue() && oldIsAllOrg) {
                this.orgClick = false;
            }
            this.getPageCache().put("cal_orgid", orgId.toString());
            this.getPageCache().put("cal_allOrg", isAllOrg.toString());
        }
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumns) {
            List listComItem;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!this.getCostAcctFilterName().equals(fieldName) || !isInit && !this.orgClick || (listComItem = commonFilterColumn.getComboItems()) == null || listComItem.size() <= 0) continue;
            commonFilterColumn.setDefaultValue(((ComboItem)listComItem.get(0)).getValue());
        }
        this.getPageCache().put("cal_isinit", "false");
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        if ("costaccount.name".equals(e.getFieldName()) || "costaccount.number".equals(e.getFieldName()) || "costaccount.id".equals(e.getFieldName())) {
            e.addCustomQFilter(this.getCostAccountFilter());
        } else if ("calorg.name".equals(e.getFieldName()) || "calorg.number".equals(e.getFieldName()) || "calorg.id".equals(e.getFieldName())) {
            e.addCustomQFilter(this.getCalOrgFilter());
        }
    }

    public String getCostAcctFilterName() {
        return "costaccount.number";
    }

    public String getOrgFilterName() {
        String mainOrg = EntityMetadataCache.getDataEntityType((String)((ListView)this.getView()).getBillFormId()).getMainOrg();
        return mainOrg + ".number";
    }

    public void listColumnCompareTypesSet(ListColumnCompareTypesSetEvent args) {
        super.listColumnCompareTypesSet(args);
        if ("bookdate".equals(args.getListFieldKey())) {
            args.getListColumnCompareTypes().removeIf(type -> CalPeriodCustomCompareConst.isCustomCompare((String)type.getId()));
        }
    }

    private QFilter getCostaccountFilter(SetFilterEvent e) {
        FilterColumnSetFilterEvent orgArgs = (FilterColumnSetFilterEvent)e;
        List calorgFilterValue = orgArgs.getCommonFilterValue(this.getOrgFilterName());
        String calorg = null;
        if (calorgFilterValue != null && calorgFilterValue.size() > 0) {
            calorg = String.valueOf(calorgFilterValue.get(0));
        }
        QFilter filter = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        if (StringUtils.isNotEmpty(calorg)) {
            filter.and("calorg", "=", (Object)Long.valueOf(calorg));
        } else {
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)((ListView)this.getView()).getBillFormId(), (String)"47150e89000000ac");
            if (list != null && list.size() > 0) {
                filter = new QFilter("calorg", "in", (Object)list);
            }
        }
        return filter;
    }

    private QFilter getCostAccountFilter() {
        List<Long> list = this.getAllPermOrgs();
        QFilter q = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        if (list != null) {
            q = new QFilter("calorg", "in", list);
        }
        return q;
    }

    private QFilter getCalOrgFilter() {
        List<Long> list = this.getAllPermOrgs();
        QFilter q = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        if (list != null) {
            q = new QFilter("id", "in", list);
        }
        return q;
    }

    private List<Long> getAllPermOrgs() {
        String appInnerId;
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)(appInnerId = AppMetadataCache.getAppInfo((String)"cal").getId()), (String)"cal_costadjust_subentity", (String)"47150e89000000ac");
        if (!rs.hasAllOrgPerm()) {
            return rs.getHasPermOrgs();
        }
        return null;
    }

    public void afterBindData(EventObject e) {
        List orgValues = this.getSelectedMainOrgIds();
        boolean orgNotNull = orgValues != null && orgValues.size() > 0;
        String orgId = "";
        if (orgNotNull) {
            orgId = orgValues.get(0);
        }
        Boolean isAllOrg = orgValues != null && orgValues.size() > 1 || StringUtils.isEmpty((CharSequence)orgId.toString());
        this.getPageCache().put("cal_orgid", orgId.toString());
        this.getPageCache().put("cal_allOrg", isAllOrg.toString());
        super.afterBindData(e);
    }
}

