/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.base;

import java.util.HashSet;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class CalRangeListPlugin
extends AbstractListPlugin {
    private static final String OP_SAVEADDENTRY = "saveaddentry";

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        FormOperate formOperate = (FormOperate)e.getSource();
        String key = formOperate.getOperateKey();
        if (OP_SAVEADDENTRY.equals(key) && e.getOperationResult() != null && e.getOperationResult().isSuccess()) {
            this.openAddBill();
        }
    }

    private void openAddBill() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] ids = selectedRows.getPrimaryKeyValues();
        if (ids == null || ids.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CostRecordListPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        if (ids.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u53ea\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"CostAdjustListPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter q = new QFilter("id", "=", ids[0]);
        q.and("status", "=", (Object)Character.valueOf('C'));
        q.and("enable", "=", (Object)Character.valueOf('1'));
        DynamicObject info = QueryServiceHelper.queryOne((String)"cal_bd_calrange", (String)"id,entry.id", (QFilter[])q.toArray());
        if (info == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5ba1\u6838\u4e14\u542f\u7528\u72b6\u6001\u4e0b\u624d\u53ef\u8ffd\u52a0\u5206\u5f55\u3002", (String)"CalRangeListPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        Long entryId = info.getLong("entry.id");
        if (entryId == null || entryId.equals(0L)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7a7a\u5206\u5f55\u7684\u6838\u7b97\u8303\u56f4\u4e0d\u5141\u8bb8\u8ffd\u52a0\u5206\u5f55\u3002", (String)"CalRangeListPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        Object billId = ids[0];
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setPkId(billId);
        showParameter.setFormId("cal_bd_calrange");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OP_SAVEADDENTRY));
        showParameter.setCustomParam("isaddentry", (Object)"1");
        showParameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumns) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            Long headcalorgid = (Long)this.getView().getFormShowParameter().getCustomParam("headcalorgid");
            String fieldName = commonFilterColumn.getFieldName();
            if (headcalorgid == null || !"headcalorg.name".equals(fieldName)) continue;
            commonFilterColumn.setDefaultValue(String.valueOf(headcalorgid));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String calrange_ids = (String)this.getView().getFormShowParameter().getCustomParam("calrange_ids");
        if (StringUtils.isEmpty((String)calrange_ids)) {
            return;
        }
        String[] idArray = calrange_ids.split(",");
        HashSet<Long> rangIdSet = new HashSet<Long>(idArray.length);
        for (String id : idArray) {
            if (StringUtils.isEmpty((String)id)) continue;
            rangIdSet.add(Long.parseLong(id));
        }
        QFilter q = new QFilter("id", "in", rangIdSet);
        q.and("status", "<>", (Object)"C");
        if (QueryServiceHelper.exists((String)"cal_bd_calrange", (QFilter[])q.toArray())) {
            e.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u52a8\u4f5c\u6d89\u53ca\u51fa\u5e93\u6838\u7b97\u6570\u636e\u7684\u51c6\u786e\u5904\u7406\uff0c\u8bf7\u786e\u8ba4\u5bf9\u5e94\u6838\u7b97\u8303\u56f4\u5168\u90e8\u4fee\u6539\u5b8c\u6bd5\u4e14\u5ba1\u6838\u540e\u518d\u9000\u51fa\u3002", (String)"CostAccountPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }
}

