/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.base;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.SCMHelper;
import kd.fi.cal.common.util.CommonUtils;

public class CalRangePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String BAR_SAVEADDNEW = "bar_saveaddnew";
    private static final String BAR_NEW = "bar_new";
    private static final String BAR_AUDIT = "bar_audit";
    private static final String BAR_DISABLE = "bar_disable";
    private static final String OP_ADDROW = "addrow";
    private static final String OP_DELETEROW = "deleterow";
    private static final String OP_BATCHFILLENTRY = "batchfillentry";
    private static final String ACCOUNT_COSTTYPE = "accountcosttype";
    private static final String ACCOUNT_COST_TYPEVALUE = "B";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, "owner", "storageorgunit", "warehouse", "location", "costaccount", "calorg", "dividebasis");
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("dividebasis".equals(key)) {
            this.divideBasisChanged(true);
        } else if ("costaccount".equals(key)) {
            this.costAccountChanged();
        } else if ("storageorgunit".equals(key)) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            this.storageOrgUnitChanged(rowIndex);
        } else if ("warehouse".equals(key)) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            this.warehouseChanged(rowIndex);
        } else if ("accounttype".equals(key)) {
            this.accountTypeChanged(e);
        }
    }

    private void accountTypeChanged(PropertyChangedArgs e) {
        if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            return;
        }
        String oldAccountType = (String)e.getChangeSet()[0].getOldValue();
        if (StringUtils.isEmpty((CharSequence)oldAccountType)) {
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u8ba1\u4ef7\u65b9\u6cd5\u8bbe\u7f6e\u540e\uff0c\u8bf7\u52ff\u968f\u610f\u4fee\u6539\uff0c\u5982\u9700\u4fee\u6539\uff0c\u8bf7\u5220\u9664\u76f8\u5173\u4e1a\u52a1\u5355\u636e\uff1b\u5982\u9700\u8981\u5728\u5df2\u6709\u4e1a\u52a1\u7684\u60c5\u51b5\u4e0b\u4fee\u6539\u8ba1\u4ef7\u65b9\u6cd5\uff0c\u5efa\u8bae\u8054\u7cfb\u60a8\u7684\u670d\u52a1\u5de5\u7a0b\u5e08\u8fdb\u884c\u5904\u7406\uff0c\u5426\u5219\u6709\u53ef\u80fd\u4f1a\u9020\u6210\u6838\u7b97\u6570\u636e\u4e0d\u51c6\u786e\u3002\u786e\u8ba4\u4fee\u6539\u8ba1\u4ef7\u65b9\u6cd5\uff1f", (String)"CalRangePlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, null, new ConfirmCallBackListener("accountType", (IFormPlugin)this), null, oldAccountType);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if (e.getResult().equals((Object)MessageBoxResult.No)) {
            this.getModel().beginInit();
            this.getModel().setValue("accounttype", (Object)e.getCustomVaule());
            this.getModel().endInit();
            this.getView().updateView("accounttype");
        }
    }

    private void warehouseChanged(int rowIndex) {
        this.getModel().setValue("location", null, rowIndex);
        if (rowIndex > 0 && this.getModel().getValue("storageorgunit", rowIndex) == null && this.getModel().getValue("warehouse", rowIndex) != null) {
            DynamicObject sou = (DynamicObject)this.getModel().getValue("storageorgunit", rowIndex - 1);
            this.getModel().beginInit();
            this.getModel().setValue("storageorgunit", (Object)sou, rowIndex);
            this.getModel().endInit();
            this.getView().updateView("storageorgunit", rowIndex);
        }
    }

    private void storageOrgUnitChanged(int rowIndex) {
        this.getModel().setValue("warehouse", null, rowIndex);
    }

    private void costAccountChanged() {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        this.getModel().setValue("dividebasis", null);
        this.getModel().setValue("headcalorg", null);
        this.getModel().deleteEntryData("entry");
        this.getModel().createNewEntryRow("entry");
        if (costAccount == null) {
            return;
        }
        DynamicObject calOrg = costAccount.getDynamicObject("calorg");
        DynamicObject divideBasis = costAccount.getDynamicObject("dividebasis");
        this.getModel().setValue("headcalorg", calOrg.get("id"));
        this.getModel().setValue("dividebasis", divideBasis.get("id"));
        boolean companyAccountFlag = this.checkCompanyAccountBookType(costAccount);
        this.setAccounttypeValue(companyAccountFlag);
    }

    private void setAccounttypeValue(boolean companyAccountFlag) {
        HashSet<String> accountTypeSet = new HashSet<String>(16);
        if (companyAccountFlag) {
            accountTypeSet.add(AccountTypeEnum.ADD_AVERAGE.getValue());
            accountTypeSet.add(AccountTypeEnum.STANDARDCOST.getValue());
        } else {
            accountTypeSet.add(AccountTypeEnum.ADD_AVERAGE.getValue());
            accountTypeSet.add(AccountTypeEnum.SPECIAL_ACCT.getValue());
            accountTypeSet.add(AccountTypeEnum.MOVE_ADD_AVERAGE.getValue());
            accountTypeSet.add(AccountTypeEnum.STANDARDCOST.getValue());
            accountTypeSet.add(AccountTypeEnum.FIN_FOUT.getValue());
            accountTypeSet.add(AccountTypeEnum.FIN_FOUT_PERIOD.getValue());
        }
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(16);
        if (accountTypeSet.size() > 0) {
            for (AccountTypeEnum accountTypeEnum : AccountTypeEnum.values()) {
                if (!accountTypeSet.contains(accountTypeEnum.getValue())) continue;
                ComboItem comboItem = new ComboItem();
                comboItem.setValue(accountTypeEnum.getValue());
                comboItem.setCaption(new LocaleString(accountTypeEnum.getDesEveryTime()));
                comboItem.setItemVisible(true);
                propertyItems.add(comboItem);
            }
        }
        ComboEdit accounttypeEdit = (ComboEdit)this.getControl("accounttype");
        accounttypeEdit.setComboItems(propertyItems);
    }

    private boolean checkCompanyAccountBookType(DynamicObject costAccount) {
        String accountcosttype;
        boolean companyAccountFlag = false;
        if (costAccount != null && !StringUtils.isEmpty((CharSequence)(accountcosttype = costAccount.getString(ACCOUNT_COSTTYPE))) && ACCOUNT_COST_TYPEVALUE.equals(accountcosttype)) {
            companyAccountFlag = true;
        }
        return companyAccountFlag;
    }

    private void divideBasisChanged(boolean isClearEntry) {
        DynamicObject divideBasis = this.getModel().getDataEntity().getDynamicObject("dividebasis");
        if (isClearEntry) {
            this.getModel().deleteEntryData("entry");
            this.getModel().createNewEntryRow("entry");
        }
        this.hideAllCols();
        if (divideBasis == null) {
            return;
        }
        String divideBasisStr = divideBasis.getString("dividebasis");
        if ("calorg".equals(divideBasisStr = CommonUtils.trimComma((String)divideBasisStr))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"entry", OP_ADDROW, OP_DELETEROW});
            this.getModel().deleteEntryData("entry");
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"entry", OP_ADDROW, OP_DELETEROW});
        }
        DynamicObjectCollection calRangeEntrys = this.getModel().getDataEntity().getDynamicObjectCollection("entry");
        DataEntityPropertyCollection calRangeEntryCols = calRangeEntrys.getDynamicObjectType().getProperties();
        for (String showColName : divideBasisStr.split(",")) {
            if (!calRangeEntryCols.containsKey((Object)showColName)) continue;
            this.getView().setVisible(Boolean.TRUE, new String[]{showColName});
            if ("warehouse".equals(showColName)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"storageorgunit"});
            }
            if (!"location".equals(showColName)) continue;
            this.getView().setVisible(Boolean.TRUE, new String[]{"storageorgunit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"warehouse"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.divideBasisChanged(false);
        this.handle4AddNewEntry();
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        boolean companyAccountFlag = this.checkCompanyAccountBookType(costAccount);
        this.setAccounttypeValue(companyAccountFlag);
    }

    private void hideAllCols() {
        DynamicObjectCollection calRangeEntrys = this.getModel().getDataEntity().getDynamicObjectCollection("entry");
        DataEntityPropertyCollection calRangeEntryCols = calRangeEntrys.getDynamicObjectType().getProperties();
        for (IDataEntityProperty dataEntity : calRangeEntryCols) {
            this.getView().setVisible(Boolean.FALSE, new String[]{dataEntity.getName()});
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("headcalorg", null);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null && !"costaccount".equals(key)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u6210\u672c\u8d26\u7c3f\u3002", (String)"CalRangePlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        int rowIndex = e.getRow();
        if ("owner".equals(key)) {
            this.beforeF7Select4Owner(e, rowIndex);
        } else if ("storageorgunit".equals(key)) {
            this.beforeF7Select4StorageOrgUnit(e, rowIndex);
        } else if ("warehouse".equals(key)) {
            this.beforeF7Select4Warehouse(e, rowIndex);
        } else if ("costaccount".equals(key)) {
            this.beforeF7Select4CostAccount(e);
        } else if ("location".equals(key)) {
            this.beforeF7Select4Location(e, rowIndex);
        } else if ("calorg".equals(key)) {
            this.beforeF7Select4CalOrg(e, rowIndex);
        } else if ("dividebasis".equals(key)) {
            this.beforeF7Select4DivideBasis(e);
        }
    }

    private void beforeF7Select4DivideBasis(BeforeF7SelectEvent e) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (costAccount != null) {
            long divideBasis = costAccount.getLong("dividebasis.id");
            q = new QFilter("id", "=", (Object)divideBasis);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4CalOrg(BeforeF7SelectEvent e, int rowIndex) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (costAccount != null) {
            q = new QFilter("id", "in", (Object)AccountingSysHelper.getOwners((Long)costAccount.getLong("id")));
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Location(BeforeF7SelectEvent e, int rowIndex) {
        DynamicObject warehouse = (DynamicObject)this.getModel().getValue("warehouse", rowIndex);
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (warehouse != null) {
            q = new QFilter("id", "in", (Object)SCMHelper.getAllLocationIDs((Object[])new Object[]{warehouse.getPkValue()}));
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4CostAccount(BeforeF7SelectEvent e) {
        List<Long> list = this.getAllPermOrgs();
        QFilter q = new QFilter("enable", "=", (Object)"1");
        if (list != null) {
            if (list.size() > 0) {
                q.and("calorg", "in", list);
            } else {
                q.and("calorg", "=", (Object)-1L);
            }
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Warehouse(BeforeF7SelectEvent e, int rowIndex) {
        DynamicObject sou = (DynamicObject)this.getModel().getValue("storageorgunit", rowIndex);
        if (sou == null) {
            String errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c{0}\u884c\u5e93\u5b58\u7ec4\u7ec7\u672a\u5f55\u5165\u3002", (String)"InitCalBillEditPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]), rowIndex + 1);
            throw new KDBizException(errorMsg);
        }
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (sou != null) {
            Long[] warehouseIds = SCMHelper.getAllInUseWarehouseIDs((String)sou.getString("number"));
            q = new QFilter("id", "in", (Object)warehouseIds);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4StorageOrgUnit(BeforeF7SelectEvent e, int rowIndex) {
        QFilter q = this.getToOrgsFilter("05");
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Owner(BeforeF7SelectEvent e, int rowIndex) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (costAccount != null) {
            q = new QFilter("id", "in", (Object)AccountingSysHelper.getOwners((Long)costAccount.getLong("id")));
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private List<Long> getAllPermOrgs() {
        String appInnerId;
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)(appInnerId = AppMetadataCache.getAppInfo((String)"cal").getId()), (String)"cal_bd_calrange", (String)"47156aff000000ac");
        if (!rs.hasAllOrgPerm()) {
            return rs.getHasPermOrgs();
        }
        return null;
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    private QFilter getToOrgsFilter(String orgType) {
        DynamicObject headcalorg = (DynamicObject)this.getModel().getValue("headcalorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        List orgList = OrgHelper.getStorageOrgUnitByCalOrg((Long)headcalorg.getLong("id"));
        if (orgList != null && !orgList.isEmpty()) {
            q = new QFilter("id", "in", (Object)orgList);
        }
        return q;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate formOperate = (FormOperate)e.getSource();
        String key = formOperate.getOperateKey();
        if ("saveaddnew".equals(key)) {
            this.getView().getModel().clearNoDataRow();
        }
        this.clearNoDataRow(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        FormOperate formOperate = (FormOperate)e.getSource();
        String key = formOperate.getOperateKey();
        if ("audit".equals(key)) {
            this.handleEnable(Boolean.FALSE);
        }
        if ("unaudit".equals(key)) {
            this.handleEnable(Boolean.TRUE);
            DynamicObject divideBasis = this.getModel().getDataEntity().getDynamicObject("dividebasis");
            if (divideBasis != null) {
                String divideBasisStr = divideBasis.getString("dividebasis");
                if ("calorg".equals(divideBasisStr = CommonUtils.trimComma((String)divideBasisStr))) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{OP_ADDROW, OP_DELETEROW});
                }
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        Object costaccount;
        String operationKey = e.getOperationKey();
        if ("newentry".equals(operationKey) && (costaccount = this.getModel().getValue("costaccount")) == null) {
            e.setCancel(true);
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CalRangePlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }

    private void handle4AddNewEntry() {
        this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SAVEADDNEW});
        if ("C".equals((String)this.getModel().getValue("status"))) {
            this.handleEnable(Boolean.FALSE);
            DynamicObjectCollection calRangeEntrys = this.getModel().getDataEntity().getDynamicObjectCollection("entry");
            if (this.getView().getFormShowParameter().getCustomParam("isaddentry") != null && !calRangeEntrys.isEmpty()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{BAR_NEW, BAR_AUDIT, BAR_DISABLE});
                this.getView().setVisible(Boolean.TRUE, new String[]{BAR_SAVEADDNEW});
                this.getView().setEnable(Boolean.TRUE, new String[]{OP_ADDROW, OP_DELETEROW});
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        int[] delIndexs;
        if (this.getView().getFormShowParameter().getCustomParam("isaddentry") == null) {
            return;
        }
        for (int index : delIndexs = e.getRowIndexs()) {
            if (((DynamicObject)this.getModel().getEntryEntity("entry").get(index)).getLong("id") == 0L) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u539f\u6709\u5206\u5f55\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"CalRangePlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
    }

    private void handleEnable(Boolean enable) {
        this.getView().setEnable(enable, new String[]{OP_ADDROW, OP_DELETEROW, OP_BATCHFILLENTRY});
        DynamicObjectCollection calRangeEntrys = this.getModel().getDataEntity().getDynamicObjectCollection("entry");
        DataEntityPropertyCollection calRangeEntryCols = calRangeEntrys.getDynamicObjectType().getProperties();
        HashSet<String> colSet = new HashSet<String>(calRangeEntryCols.size());
        for (IDataEntityProperty dataEntity : calRangeEntryCols) {
            colSet.add(dataEntity.getName());
        }
        for (int i = 0; i < calRangeEntrys.getRowCount(); ++i) {
            this.getView().setEnable(enable, i, colSet.toArray(new String[0]));
        }
    }

    private void clearNoDataRow(BeforeDoOperationEventArgs e) {
        Object op = e.getSource();
        if (op instanceof Save || op instanceof Submit) {
            DynamicObjectCollection entryDyc = this.getModel().getEntryEntity("entry");
            DynamicObject divDyc = (DynamicObject)this.getModel().getValue("dividebasis");
            String divStrs = "";
            if (divDyc != null) {
                divStrs = divDyc.getString("dividebasis");
            }
            EntityType entryEntityType = (EntityType)this.getModel().getDataEntityType().getAllEntities().get("entry");
            DataEntityPropertyCollection properties = entryEntityType.getProperties();
            for (int i = entryDyc.size() - 1; i >= 0; --i) {
                boolean isEmptyRow = true;
                for (String col : divStrs.split(",")) {
                    boolean isNotEmptyStr;
                    if (!properties.containsKey((Object)col)) continue;
                    Object divValue = this.getModel().getValue(col, i);
                    boolean isStringDiv = divValue instanceof String;
                    boolean bl = isNotEmptyStr = isStringDiv && StringUtils.isNotBlank((Object)divValue);
                    if (divValue == null && !isNotEmptyStr) continue;
                    isEmptyRow = false;
                    break;
                }
                if (!isEmptyRow) continue;
                this.getModel().deleteEntryRow("entry", i);
            }
        }
    }
}

