/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.base;

import java.util.EventObject;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeQuickAddNewEvent;
import kd.bos.form.field.events.BeforeQuickAddNewListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.OrgHelper;

public class CostAccountPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
BeforeQuickAddNewListener {
    public static final String COSTTYPE_KEY = "costtype";
    public static final String CALPOLICY_KEY = "calpolicy";
    private static final String BOOK_TYPE = "booktype";
    private static final String DIVIDE_BASIS = "dividebasis";
    private static final String ACCOUNT_COSTTYPE = "accountcosttype";
    private static final String ACCOUNT_COST_TYPEVALUE = "B";

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("calorg".equals(key)) {
            this.calOrgChanged();
        } else if (CALPOLICY_KEY.equals(key)) {
            this.calEnableCalPolicyChanged();
        } else if (BOOK_TYPE.equals(key)) {
            this.bookTypeChanged();
        } else if ("calsystem".equals(key)) {
            this.getModel().beginInit();
            this.getModel().setValue(BOOK_TYPE, null);
            this.getView().updateView(BOOK_TYPE);
            this.getModel().endInit();
            this.reSetGroupType();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setBookTypeByCalOrgId();
        Object groupType = this.getModel().getValue(ACCOUNT_COSTTYPE);
        if (groupType == null || StringUtils.isEmpty((String)((String)groupType))) {
            this.reSetGroupType();
        }
    }

    private void reSetGroupType() {
        this.getModel().setValue(ACCOUNT_COSTTYPE, (Object)"");
        Object bookTypeObj = this.getModel().getValue(BOOK_TYPE);
        if (bookTypeObj == null) {
            return;
        }
        String groupType = ((DynamicObject)bookTypeObj).getString("groupcosttype");
        if (ACCOUNT_COST_TYPEVALUE.equals(groupType)) {
            Object calOrgObj = this.getModel().getValue("calorg");
            Object calSystemObj = this.getModel().getValue("calsystem");
            if (calOrgObj == null || calSystemObj == null) {
                return;
            }
            Boolean isLeaf = OrgHelper.isOrgLeafNode((Long)((DynamicObject)calOrgObj).getLong("id"), (Long)((DynamicObject)calSystemObj).getLong("id"));
            if (isLeaf.booleanValue()) {
                groupType = "D";
            }
        }
        this.getModel().setValue(ACCOUNT_COSTTYPE, (Object)groupType);
    }

    private void bookTypeChanged() {
        String accountcosttype;
        if (this.getModel().getValue("calsystem") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u4f53\u7cfb\u3002", (String)"CostAccountPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        this.reSetGroupType();
        Object accountcosttypeObj = this.getModel().getValue(ACCOUNT_COSTTYPE);
        if (accountcosttypeObj != null && !StringUtils.isEmpty((String)(accountcosttype = String.valueOf(accountcosttypeObj))) && ACCOUNT_COST_TYPEVALUE.equals(accountcosttype)) {
            this.getModel().setValue(DIVIDE_BASIS, (Object)5);
        }
    }

    private void calOrgChanged() {
        this.getModel().setValue("calsystem", null);
        this.setBookTypeByCalOrgId();
        this.reSetGroupType();
    }

    private void setBookTypeByCalOrgId() {
        Boolean isLeaf;
        Object calOrgObj = this.getModel().getValue("calorg");
        Object calSystemObj = this.getModel().getValue("calsystem");
        if (calOrgObj != null && calSystemObj != null && !(isLeaf = OrgHelper.isOrgLeafNode((Long)((DynamicObject)calOrgObj).getLong("id"), (Long)((DynamicObject)calSystemObj).getLong("id"))).booleanValue()) {
            this.getModel().setValue(BOOK_TYPE, (Object)1976906326638655488L);
        }
    }

    private void calEnableCalPolicyChanged() {
        this.getModel().setValue(COSTTYPE_KEY, null);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, "calorg", "calsystem", COSTTYPE_KEY, CALPOLICY_KEY, DIVIDE_BASIS, BOOK_TYPE);
        BasedataEdit edit = (BasedataEdit)this.getControl(BOOK_TYPE);
        edit.addBeforeQuickAddNewListener((BeforeQuickAddNewListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("calsystem".equals(key)) {
            this.beforeF7Select4CalSystem(e);
        } else if (COSTTYPE_KEY.equals(key)) {
            this.beforeF7Select4CostType(e);
        } else if (DIVIDE_BASIS.equals(key)) {
            this.beforeF7SelectDividebasis(e);
        } else if (BOOK_TYPE.equals(key)) {
            Boolean isLeaf;
            Object calOrgObj = this.getModel().getValue("calorg");
            Object calSystemObj = this.getModel().getValue("calsystem");
            if (calOrgObj != null && calSystemObj != null && !(isLeaf = OrgHelper.isOrgLeafNode((Long)((DynamicObject)calOrgObj).getLong("id"), (Long)((DynamicObject)calSystemObj).getLong("id"))).booleanValue()) {
                QFilter q = new QFilter("groupcosttype", "=", (Object)ACCOUNT_COST_TYPEVALUE);
                ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
            }
        }
    }

    private void beforeF7SelectDividebasis(BeforeF7SelectEvent e) {
        String accountcosttype;
        Object accountcosttypeObj = this.getModel().getValue(ACCOUNT_COSTTYPE);
        if (accountcosttypeObj != null && !StringUtils.isEmpty((String)(accountcosttype = String.valueOf(accountcosttypeObj))) && ACCOUNT_COST_TYPEVALUE.equals(accountcosttype)) {
            QFilter q = new QFilter("id", "=", (Object)5);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    private void beforeF7Select4CalSystem(BeforeF7SelectEvent e) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrg != null) {
            q = new QFilter("bizorgentry.bizacctorg", "=", calOrg.get("id"));
            q.and("enable", "=", (Object)"1");
            q.and("status", "=", (Object)"C");
            DynamicObjectCollection accountSyses = QueryServiceHelper.query((String)"bd_accountingsys", (String)"id", (QFilter[])q.toArray());
            HashSet<Long> ids = new HashSet<Long>(16);
            for (DynamicObject accountSys : accountSyses) {
                ids.add(accountSys.getLong("id"));
            }
            q = new QFilter("id", "in", ids);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4CostType(BeforeF7SelectEvent e) {
        DynamicObject calPolicy = (DynamicObject)this.getModel().getValue(CALPOLICY_KEY);
        QFilter q = new QFilter("type", "=", (Object)"0");
        if (calPolicy != null) {
            q.and(new QFilter("currency.id", "=", calPolicy.getDynamicObject("currency").get("id")));
        }
        q.and("id", "<>", (Object)957770985921275904L);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public String getMainEntityName() {
        return "cal_bd_costaccount";
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String op = e.getOperateKey();
        if ("save".equals(op) && e.getOperationResult().isSuccess()) {
            String randomid = ((FormOperate)e.getSource()).getOption().getVariableValue("randomid");
            String calRangeIds = (String)AppCache.get((String)"cal").get(randomid, String.class);
            if (!StringUtils.isEmpty((String)calRangeIds)) {
                this.getPageCache().put("calrangeids", calRangeIds);
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId("cal_bd_calrange");
                String[] idArray = calRangeIds.split(",");
                HashSet<Long> rangIdSet = new HashSet<Long>(idArray.length);
                for (String id : idArray) {
                    if (StringUtils.isEmpty((String)id)) continue;
                    rangIdSet.add(Long.parseLong(id));
                }
                DynamicObject calOrgObj = (DynamicObject)this.getModel().getValue("calorg");
                if (calOrgObj != null) {
                    showParameter.getShowParameter().setCustomParam("headcalorgid", calOrgObj.getPkValue());
                }
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", rangIdSet));
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "save_calrange"));
                showParameter.getShowParameter().setShowTitle(false);
                showParameter.getShowParameter().setCustomParam("calrange_ids", (Object)calRangeIds);
                showParameter.getShowParameter().setCaption(ResManager.loadKDString((String)"\u6838\u7b97\u8303\u56f4\uff08\u8bf7\u9010\u4e2a\u91cd\u65b0\u7ef4\u62a4\u5212\u5206\u4f9d\u636e\u540e\u5ba1\u6838\uff09", (String)"CostAccountPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                this.getView().showForm((FormShowParameter)showParameter);
            }
            AppCache.get((String)"cal").remove(randomid);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opName = ((FormOperate)args.getSource()).getOperateKey();
        if ("save".equals(opName)) {
            String randomid = String.valueOf(DB.genLongId((String)"t_cal_costaccount"));
            ((FormOperate)args.getSource()).getOption().setVariableValue("randomid", randomid);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String calRangeIds;
        super.closedCallBack(e);
        if ("save_calrange".equals(e.getActionId()) && !StringUtils.isEmpty((String)(calRangeIds = this.getPageCache().get("calrangeids")))) {
            String[] idArray = calRangeIds.split(",");
            HashSet<Long> rangIdSet = new HashSet<Long>(idArray.length);
            for (String id : idArray) {
                if (StringUtils.isEmpty((String)id)) continue;
                rangIdSet.add(Long.parseLong(id));
            }
            QFilter q = new QFilter("id", "in", rangIdSet);
            q.and("status", "<>", (Object)"C");
            if (QueryServiceHelper.exists((String)"cal_bd_calrange", (QFilter[])q.toArray())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u52a8\u4f5c\u6d89\u53ca\u51fa\u5e93\u6838\u7b97\u6570\u636e\u7684\u51c6\u786e\u5904\u7406\uff0c\u8bf7\u786e\u8ba4\u5bf9\u5e94\u6838\u7b97\u8303\u56f4\u5168\u90e8\u4fee\u6539\u5b8c\u6bd5\u4e14\u5ba1\u6838\u540e\u518d\u9000\u51fa\u3002", (String)"CostAccountPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeQuickAddNew(BeforeQuickAddNewEvent arg0) {
        Control c = (Control)arg0.getSource();
        if (BOOK_TYPE.equals(c.getKey())) {
            arg0.getShowParameter().getOpenStyle().setShowType(ShowType.Modal);
        }
    }
}

