/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.base;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;

public class SelectFieldList
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeCheckListener,
SearchEnterListener {
    public static final String FormId_SelectField = "cal_bd_selectfield";
    public static final String CustParamKey_TreeNodes = "treenodes";
    public static final String CustParamKey_IsMulti = "ismulti";
    public static final String CustParamKey_SelectedNodeIds = "nodeids";
    public static final String CustParamKey_NotReturnNodes = "notreturnnodes";
    private static final String CacheKey_SelectedNodeIds = "nodeids";
    public static final String Key_btnOK = "btnok";
    public static final String Key_btnCancel = "btncancel";
    public static final String Key_TreeView = "tv_fields";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{Key_btnOK, Key_btnCancel});
        TreeView tv = (TreeView)this.getView().getControl(Key_TreeView);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        tv.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        Search searchap = (Search)this.getView().getControl("searchap");
        searchap.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String json = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_TreeNodes);
        if (StringUtils.isNotBlank((CharSequence)json)) {
            this.fillTreeNodes(json);
        } else {
            this.addTreeRootNode();
        }
        if (this.isMultiSelected()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"searchap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"searchap"});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (Key_btnOK.equalsIgnoreCase(ctlSource.getKey())) {
            String currNodeId = this.getPageCache().get("nodeids");
            if (StringUtils.isNotBlank((CharSequence)currNodeId)) {
                this.getView().returnDataToParent((Object)currNodeId);
            } else {
                this.getView().returnDataToParent((Object)"");
            }
            this.getView().close();
        } else if (Key_btnCancel.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        if (this.isMultiSelected()) {
            return;
        }
        String currNodeId = (String)e.getNodeId();
        if ("0".equals(currNodeId)) {
            currNodeId = "";
        }
        this.getPageCache().put("nodeids", currNodeId);
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
        if (this.isMultiSelected()) {
            return;
        }
        String currNodeId = (String)e.getNodeId();
        if ("0".equals(currNodeId)) {
            currNodeId = "";
        }
        if (StringUtils.isBlank((CharSequence)currNodeId)) {
            return;
        }
        this.getView().returnDataToParent((Object)currNodeId);
        this.getView().close();
    }

    public void treeNodeCheck(TreeNodeCheckEvent e) {
        String cacheNodeIds = "";
        TreeView treeView = (TreeView)e.getSource();
        List checkedNodeIds = treeView.getTreeState().getCheckedNodeIds();
        if (checkedNodeIds != null) {
            List notReturnNodes = (List)this.getView().getFormShowParameter().getCustomParam(CustParamKey_NotReturnNodes);
            checkedNodeIds.remove("0");
            checkedNodeIds.removeAll(notReturnNodes);
            cacheNodeIds = StringUtils.join((Object[])checkedNodeIds.toArray(), (String)",");
        }
        this.getPageCache().put("nodeids", cacheNodeIds);
    }

    private void fillTreeNodes(String strJson) {
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)strJson, TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
        tree.addNode(rootNode);
        if (this.isMultiSelected()) {
            tree.setMulti(true);
            String cacheNodeIds = (String)this.getView().getFormShowParameter().getCustomParam("nodeids");
            if (StringUtils.isNotBlank((CharSequence)cacheNodeIds)) {
                this.getPageCache().put("nodeids", cacheNodeIds);
                String[] arr = StringUtils.split((String)cacheNodeIds, (String)",");
                ArrayList<TreeNode> selectedNodes = new ArrayList<TreeNode>();
                for (String nodeId : arr) {
                    TreeNode node = rootNode.getTreeNode(nodeId, 5);
                    if (node == null) continue;
                    selectedNodes.add(node);
                }
                if (selectedNodes.size() > 0) {
                    tree.checkNodes(selectedNodes);
                }
            }
        }
    }

    private void addTreeRootNode() {
        TreeNode root = new TreeNode("", "0", ResManager.loadKDString((String)"\u5355\u636e\u5b57\u6bb5\u5217\u8868", (String)"SelectFieldList_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
        tree.addNode(root);
    }

    private boolean isMultiSelected() {
        String isMulti = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_IsMulti);
        if (StringUtils.isBlank((CharSequence)isMulti)) {
            return false;
        }
        return isMulti.equalsIgnoreCase("true") || isMulti.equalsIgnoreCase("1");
    }

    public void search(SearchEnterEvent paramSearchEnterEvent) {
        List treeNodes;
        String searchText = paramSearchEnterEvent.getText();
        String json = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_TreeNodes);
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        if (oldSearchText != null && !oldSearchText.equals(searchText) || StringUtils.isBlank((CharSequence)matchNodesCache)) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, 16);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        } else {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            treeNodes = StringUtils.isBlank((CharSequence)searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
        }
        if (treeNodes.isEmpty()) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, 16);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"SelectFieldList_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        } else {
            TreeView treeView = (TreeView)this.getView().getControl(Key_TreeView);
            if (StringUtils.isNotEmpty((CharSequence)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache < treeNodes.size()) {
                    treeView.treeNodeClick(((TreeNode)treeNodes.get(indexCache)).getParentid(), ((TreeNode)treeNodes.get(indexCache)).getId());
                    treeView.showNode(((TreeNode)treeNodes.get(indexCache)).getParentid());
                    treeView.focusNode((TreeNode)treeNodes.get(indexCache));
                    pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22", (String)"SelectFieldList_2", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                    pageCache.put(searchIndexCacheKey, String.valueOf(0));
                }
            } else {
                treeView.treeNodeClick(((TreeNode)treeNodes.get(0)).getParentid(), ((TreeNode)treeNodes.get(0)).getId());
                treeView.showNode(((TreeNode)treeNodes.get(0)).getParentid());
                treeView.focusNode((TreeNode)treeNodes.get(0));
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
        }
    }
}

