/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.bill;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;

public class CostAdjustBillUpgradePlugin
extends AbstractFormPlugin
implements ProgresssListener {
    public static final String DLOCK_KEY = "CostadjustBillUpgrade";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnupgrade", "btncancle"});
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Button) {
            if ("btncancel".equals(((Button)evt.getSource()).getKey())) {
                this.getView().close();
            } else if ("btnupgrade".equals(((Button)evt.getSource()).getKey())) {
                this.start();
                int taskCount = this.excute();
                if (taskCount == 0) {
                    String message = ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u9700\u8981\u5347\u7ea7\u7684\u6570\u636e\uff0c\u5904\u7406\u5b8c\u6bd5\u3002", (String)"CostAdjustBillUpgradePlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]);
                    this.getView().showSuccessNotification(message);
                } else {
                    this.getPageCache().put("taskCount", String.valueOf(taskCount));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int excute() {
        String upgradempdel = (String)this.getModel().getValue("upgradmodel");
        int taskCount = 0;
        try (DLock lock = null;){
            lock = DLock.create((String)(DLOCK_KEY + CacheKeyUtil.getAcctId()));
            if (!lock.tryLock()) {
                String msg = ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u540e\u53f0\u5347\u7ea7\u4efb\u52a1\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"CostAdjustBillUpgradePlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]);
                throw new KDBizException(msg);
            }
            this.checkRunningTask();
            if ("all".equalsIgnoreCase(upgradempdel)) {
                this.cleanData();
                DataSet costAdjustBillIds = QueryServiceHelper.queryDataSet((String)"", (String)"cal_costadjustbill", (String)"id,difftype", null, null);
                taskCount = this.createTasks(costAdjustBillIds);
            } else {
                DataSet costAdjustBillIds = DB.queryDataSet((String)"kd.fi.cal.formplugin.bill.CostAdjustBillUpgradePlugin_excute", (DBRoute)new DBRoute("cal"), (String)"select b.fid as id,fdifftype as difftype from t_cal_costadjustbill b where not exists (select 1 from T_CAL_SUCCESSBILL b1 where b.fid = b1.fdataid); ");
                taskCount = this.createTasks(costAdjustBillIds);
            }
        }
        return taskCount;
    }

    private int createTasks(DataSet costAdjustBillIds) {
        int batchSize = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.QUERY_IN_SPRITSIZE);
        HashSet<Long> billIds = new HashSet<Long>(16);
        int taskCount = 0;
        Long taskGroupNo = System.currentTimeMillis();
        this.getPageCache().put("taskGroupNo", taskGroupNo.toString());
        for (Row row : costAdjustBillIds) {
            String difftype = row.getString("difftype");
            if ("B".equalsIgnoreCase(difftype)) continue;
            billIds.add(row.getLong("id"));
            if (billIds.size() < batchSize) continue;
            this.createTask(billIds, taskGroupNo);
            ++taskCount;
            billIds.clear();
        }
        if (billIds.size() > 0) {
            this.createTask(billIds, taskGroupNo);
            ++taskCount;
            billIds.clear();
        }
        return taskCount;
    }

    private void createTask(Set<Long> ids, Long taskGroupNo) {
        DynamicObject taskParam = BusinessDataServiceHelper.newDynamicObject((String)"cal_taskparam");
        long paramId = DBServiceHelper.genLongIds((String)"cal_taskparam", (int)1)[0];
        taskParam.set("param_tag", (Object)SerializationUtils.toJsonString(ids));
        taskParam.set("functionnum", (Object)"CostAdjustBillUpgrade");
        taskParam.set("task", (Object)("taskId:" + paramId));
        taskParam.set("taskgroupno", (Object)taskGroupNo.toString());
        taskParam.set("status", (Object)"A");
        taskParam.set("id", (Object)paramId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskParam});
        HashMap<String, Long> jobParams = new HashMap<String, Long>(16);
        jobParams.put("paramid", paramId);
        JobInfo job = new JobInfo();
        String OpName = String.format(ResManager.loadKDString((String)"\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u5347\u7ea7\u4efb\u52a1\uff1a%1$s", (String)"CostAdjustBillUpgradePlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]), paramId);
        job.setName(OpName);
        job.setTaskDefineId("2TEFWWEURC0=");
        job.setJobType(JobType.BIZ);
        job.setParams(jobParams);
        job.setAppId("cal");
        job.setRunByLang(Lang.get());
        job.setTaskClassname("kd.fi.cal.business.task.StdCostDiffUpdateTask");
        job.setRunByUserId(RequestContext.get().getCurrUserId());
        String taskid = JobClient.dispatch((JobInfo)job);
    }

    private void cleanData() {
        int batchSize = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.QUERY_IN_SPRITSIZE);
        DataSet successBillIds = DB.queryDataSet((String)"kd.fi.cal.formplugin.bill.CostAdjustBillUpgradePlugin_cleanData", (DBRoute)new DBRoute("cal"), (String)"select fdataid from T_CAL_SUCCESSBILL");
        ArrayList<Object[]> delBillIds = new ArrayList<Object[]>(16);
        for (Row row : successBillIds) {
            delBillIds.add(new Object[]{row.getLong("fdataid")});
            if (delBillIds.size() < batchSize) continue;
            this.deleteData(delBillIds);
            delBillIds.clear();
        }
        if (delBillIds.size() > 0) {
            this.deleteData(delBillIds);
            delBillIds.clear();
        }
    }

    private void deleteData(List<Object[]> ids) {
        String delSuccessIdSql = "delete from T_CAL_SUCCESSBILL where fdataid in (?)";
        String delStdCostDiffBillSql = "delete from t_cal_stdcostdiff where fid in (?)";
        String delStdCostDiffBillEntrySql = "delete from T_CAL_stdcostdiffentry where fid in (?)";
        try (TXHandle h1 = TX.requiresNew();){
            try {
                DB.executeBatch((DBRoute)new DBRoute("cal"), (String)delStdCostDiffBillSql, new ArrayList<Object[]>(ids));
                DB.executeBatch((DBRoute)new DBRoute("cal"), (String)delStdCostDiffBillEntrySql, new ArrayList<Object[]>(ids));
                DB.executeBatch((DBRoute)new DBRoute("cal"), (String)delSuccessIdSql, new ArrayList<Object[]>(ids));
            }
            catch (Throwable e) {
                h1.markRollback();
                throw e;
            }
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        int taskCount = Integer.parseInt(this.getPageCache().get("taskCount"));
        String taskGroupNo = this.getPageCache().get("taskGroupNo");
        QFilter filter = new QFilter("taskgroupno", "=", (Object)taskGroupNo);
        DataSet taskData = QueryServiceHelper.queryDataSet((String)"", (String)"cal_taskparam", (String)"id,status", (QFilter[])filter.toArray(), null);
        int successCount = 0;
        int failCount = 0;
        for (Row row : taskData) {
            String status = row.getString("status");
            if ("B".equalsIgnoreCase(status)) {
                ++successCount;
            }
            if (!"C".equalsIgnoreCase(status)) continue;
            ++failCount;
        }
        String text = successCount + "/" + taskCount;
        ((Label)this.getView().getControl("labelap")).setText(text);
        if (successCount + failCount == taskCount) {
            progressEvent.setProgress(100);
            ProgressBar progressBar = (ProgressBar)this.getView().getControl("progressbarap");
            progressBar.stop();
            if (failCount > 0) {
                String OpName = ResManager.loadKDString((String)"\u5b58\u5728\u540e\u53f0\u5931\u8d25\u7684\u5347\u7ea7\u4efb\u52a1\uff0c\u8bf7\u5173\u6ce8\u3002", (String)"CostAdjustBillUpgradePlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(OpName);
            }
            this.getPageCache().remove("taskCount");
        } else {
            progressEvent.setProgress(successCount * 100 / taskCount);
        }
    }

    private void start() {
        ProgressBar progressBar = (ProgressBar)this.getView().getControl("progressbarap");
        String text = ResManager.loadKDString((String)"\u6b63\u5728\u521b\u5efa\u540e\u53f0\u4efb\u52a1\uff0c\u8bf7\u7b49\u5f85\u3002", (String)"CostAdjustBillUpgradePlugin_4", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        ((Label)this.getView().getControl("labelap")).setText(text);
        progressBar.setPercent(0);
        progressBar.start();
    }

    private void checkRunningTask() {
        String msg = ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u7ecf\u8fd0\u884c\u7684\u5347\u7ea7\u4efb\u52a1\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"CostAdjustBillUpgradePlugin_5", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        QFilter filter = new QFilter("status", "=", (Object)"A");
        Boolean isExists = QueryServiceHelper.exists((String)"cal_taskparam", (QFilter[])filter.toArray());
        if (isExists.booleanValue()) {
            throw new KDBizException(msg);
        }
    }
}

