/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.bill;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterColumnSetFilterEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.ListColumnCompareTypesSetEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.cal.business.calculate.out.calintime.CalInTimeRptLinkHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.CostAdjustBillDiffTypeEnum;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.helper.WriteOffServerHelper;
import kd.fi.cal.formplugin.base.CalOrgAcctLinkListPlugin;

public class CostAdjustListPlugin
extends CalOrgAcctLinkListPlugin {
    private boolean isFirstInitFilterByMainPage = false;
    private boolean isfirstSetFilterByMainPage = false;
    private String BTNVIEWSHARERECORD = "view_feesharerecord";
    private String VIEW_APVERIFYRECORD = "view_apverifyrecord";
    public static final String PURCHASE_SPREAD_PAGETYPE = "purchasespread";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_DEBUG_MODEL).booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_updatestocktype"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_updatestocktype"});
        }
    }

    @Override
    public String getCostAcctFilterName() {
        return "costaccount.name";
    }

    @Override
    public String getOrgFilterName() {
        String mainOrg = EntityMetadataCache.getDataEntityType((String)((ListView)this.getView()).getBillFormId()).getMainOrg();
        return mainOrg + ".name";
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        String key = e.getItemKey();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] ids = selectedRows.getPrimaryKeyValues();
        if (this.BTNVIEWSHARERECORD.equals(key)) {
            this.showFeeShareRecord(ids);
        } else if (this.VIEW_APVERIFYRECORD.equals(key)) {
            this.showApVerifyRecord(ids);
        } else if ("btntrackup".equals(key)) {
            if (ids == null || ids.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CostUpdateApplyBillListPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                return;
            }
            this.queryPrevBill(ids);
        } else {
            if ("btntrackdown".equals(key)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u4e0b\u6e38\u5355\u636e\u3002", (String)"CostAdjustListPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                return;
            }
            if ("view_costestimaterecord".equals(key)) {
                this.showCostEstimateRecords(ids);
            } else if ("view_chargeoffbill".equals(key)) {
                this.showChargeoffBill(ids, true);
            } else if ("view_chargeoffedbill".equals(key)) {
                this.showChargeoffBill(ids, false);
            }
        }
    }

    private void showChargeoffBill(Object[] ids, boolean isShowChargeOff) {
        if (ids == null || ids.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CostAdjustListPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        String chargeoffedField = "ischargeoffed";
        String chargeoffField = "ischargeoff";
        if (!isShowChargeOff) {
            chargeoffedField = "ischargeoff";
            chargeoffField = "ischargeoffed";
        }
        HashSet<Long> recordEntryIds = new HashSet<Long>(16);
        QFilter q = new QFilter("id", "in", (Object)ids);
        q.and(chargeoffedField, "=", (Object)Boolean.TRUE);
        DynamicObjectCollection costAdjustColl = QueryServiceHelper.query((String)"cal_costadjustbill", (String)"entryentity.invbillentryid", (QFilter[])q.toArray());
        for (DynamicObject dynamic : costAdjustColl) {
            recordEntryIds.add(dynamic.getLong("entryentity.invbillentryid"));
        }
        if (recordEntryIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u8bb0\u5f55\u3002", (String)"CostRecordEditPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> costAdjustIds = new HashSet<Long>();
        q = new QFilter("entryentity.invbillentryid", "in", recordEntryIds);
        q.and(chargeoffField, "=", (Object)Boolean.TRUE);
        DynamicObjectCollection chargeoffCostAdjustColl = QueryServiceHelper.query((String)"cal_costadjustbill", (String)"id", (QFilter[])q.toArray());
        for (DynamicObject dynamic : chargeoffCostAdjustColl) {
            costAdjustIds.add(dynamic.getLong("id"));
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("cal_costadjust_subentity");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("id", "in", costAdjustIds));
        showParameter.getListFilterParameter().setQFilters(qFilters);
        Iterator iterator = costAdjustIds.iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            showParameter.addLinkQueryPkId((Object)id);
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    @Override
    public void listColumnCompareTypesSet(ListColumnCompareTypesSetEvent args) {
        ArrayList comboItems;
        if ("difftype".equals(args.getListFieldKey()) && (comboItems = args.getComboItems()).size() != 0) {
            int index = -1;
            for (int i = 0; i < comboItems.size(); ++i) {
                if (!CostAdjustBillDiffTypeEnum.ACT_COST.getValue().equals(((ValueMapItem)comboItems.get(i)).getValue())) continue;
                index = i;
                break;
            }
            String pageType = (String)this.getView().getFormShowParameter().getCustomParams().get("pageType");
            if (index != -1) {
                if (PURCHASE_SPREAD_PAGETYPE.equals(pageType)) {
                    comboItems.remove(index);
                } else {
                    ArrayList container = new ArrayList(16);
                    container.add(comboItems.get(index));
                    comboItems = container;
                }
            }
            args.setComboItems((List)comboItems);
        }
        super.listColumnCompareTypesSet(args);
    }

    private void showCostEstimateRecords(Object[] ids) {
        if (ids == null || ids.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CostAdjustListPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter costAdjustBillFilter = new QFilter("id", "in", (Object)ids);
        HashSet<Long> costEstimateBillEntryIds = new HashSet<Long>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costadjust_subentity", (String)"id,entryentity.srcbillentryid,entryentity.srcbizentityobject", (QFilter[])costAdjustBillFilter.toArray(), null);){
            for (Row row : ds) {
                Long costEstimateBillEntryId = row.getLong("entryentity.srcbillentryid");
                String srcbizentityobject = row.getString("entryentity.srcbizentityobject");
                if (costEstimateBillEntryId == null || costEstimateBillEntryId == 0L || !"cal_costestimatebill".equals(srcbizentityobject)) continue;
                costEstimateBillEntryIds.add(costEstimateBillEntryId);
            }
        }
        if (costEstimateBillEntryIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u8bb0\u5f55\u3002", (String)"CostRecordEditPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter param = new ListShowParameter();
        param.setFormId("bos_list");
        param.setBillFormId("cal_costestimaterecord");
        param.getListFilterParameter().setFilter(new QFilter("id", "in", costEstimateBillEntryIds));
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)param);
    }

    private void showBatchModify(Object[] ids, String key) {
        DynamicObject billInfo = BusinessDataServiceHelper.loadSingle((Object)ids[0], (String)"cal_costadjustbill", (String)"billstatus");
        String billStatus = billInfo.getString("billstatus");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cal_batchmodify");
        showParameter.getCustomParams().put("billstatus", billStatus);
        showParameter.getCustomParams().put("ids", ids);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.getView().invokeOperation("refresh");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        String key = op.getOperateKey();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] ids = selectedRows.getPrimaryKeyValues();
        if ("new".equals(key)) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String pageType = (String)formShowParameter.getCustomParams().get("pageType");
            if (PURCHASE_SPREAD_PAGETYPE.equals(pageType)) {
                this.getView().getPageCache().put("difftype", "A");
            } else {
                this.getView().getPageCache().put("difftype", "B");
            }
        } else if ("audit".equals(key) || "unaudit".equals(key) || "submit".equals(key)) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String pageType = (String)formShowParameter.getCustomParams().get("pageType");
            if (PURCHASE_SPREAD_PAGETYPE.equals(pageType)) {
                op.getOption().setVariableValue("insertsubentry", "false");
            } else {
                op.getOption().setVariableValue("insertsubentry", "true");
            }
        } else if ("batchmodify".equals(key)) {
            if (ids == null || ids.length == 0) {
                return;
            }
            DynamicObject[] billInfos = BusinessDataServiceHelper.load((String)"cal_costadjustbill", (String)"id", (QFilter[])new QFilter("id", "in", (Object)ids).toArray());
            if (billInfos == null || billInfos.length < 1) {
                return;
            }
            if (!this.isSameAccount(ids)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5bf9\u8c61\u7684\u6210\u672c\u8d26\u7c3f\u5fc5\u987b\u4e00\u81f4\u3002", (String)"CostAdjustListPlugin_4", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!this.isSameBillStatus(ids)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5bf9\u8c61\u7684\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e00\u81f4\u3002", (String)"CostAdjustListPlugin_5", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!this.checkSelectPeriod(ids)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5bf9\u8c61\u7684\u671f\u95f4\u5fc5\u987b\u5728\u6210\u672c\u8d26\u7c3f\u7684\u5f53\u524d\u671f\u95f4\u53ca\u4ee5\u540e\u3002", (String)"CostAdjustListPlugin_6", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                return;
            }
            this.showBatchModify(ids, key);
        }
        if ("unaudit".equals(key)) {
            op.getOption().setVariableValue("isdeletebill", "false");
        }
    }

    public void setFilter(SetFilterEvent e) {
        String pageType;
        QFilter filter;
        super.setFilter(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        if (this.isMatchCondition(paramMap) && this.isfirstSetFilterByMainPage) {
            String filterStr = (String)paramMap.get("filter");
            if (StringUtils.isNotBlank((CharSequence)filterStr)) {
                filter = QFilter.fromSerializedString((String)filterStr);
                e.getQFilters().clear();
                e.getQFilters().add(filter);
            }
            this.isfirstSetFilterByMainPage = false;
        }
        if ((pageType = (String)formShowParameter.getCustomParams().get("pageType")) != null) {
            filter = PURCHASE_SPREAD_PAGETYPE.equals(pageType) ? new QFilter("difftype", "<>", (Object)CostAdjustBillDiffTypeEnum.ACT_COST.getValue()) : new QFilter("difftype", "=", (Object)CostAdjustBillDiffTypeEnum.ACT_COST.getValue());
            e.getQFilters().add(filter);
        }
    }

    private boolean isMatchCondition(Map<String, Object> paramMap) {
        boolean flag = false;
        String key = (String)paramMap.get("source");
        if ("CalHandleExpBillPlugin".equals(key)) {
            flag = true;
        }
        return flag;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.isFirstInitFilterByMainPage = true;
        this.isfirstSetFilterByMainPage = true;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String pageType = (String)formShowParameter.getCustomParams().get("pageType");
        if (PURCHASE_SPREAD_PAGETYPE.equals(pageType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"importdata", "importdetails", "exportdata_expt", "exportdata"});
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        String costAccount;
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        if (this.isMatchCondition(paramMap) && this.isFirstInitFilterByMainPage) {
            this.mainPageFilterInit(filterColumns, paramMap);
            this.isFirstInitFilterByMainPage = false;
        }
        List schemeFilterColumns = args.getFilterContainerInitEvent().getSchemeFilterColumns();
        for (FilterColumn column : schemeFilterColumns) {
            List comboItems;
            SchemeFilterColumn filterColumn = (SchemeFilterColumn)column;
            String fieldName = filterColumn.getFieldName();
            if (!"difftype".equals(fieldName) || (comboItems = filterColumn.getComboItems()).size() <= 0) continue;
            int index = -1;
            for (int i = 0; i < comboItems.size(); ++i) {
                if (!CostAdjustBillDiffTypeEnum.ACT_COST.getValue().equals(((ComboItem)comboItems.get(i)).getValue())) continue;
                index = i;
                break;
            }
            String pageType = (String)this.getView().getFormShowParameter().getCustomParams().get("pageType");
            if (index == -1) continue;
            if (PURCHASE_SPREAD_PAGETYPE.equals(pageType)) {
                comboItems.remove(index);
                continue;
            }
            ArrayList container = new ArrayList(16);
            for (int i = 0; i < comboItems.size(); ++i) {
                if (i == index) continue;
                container.add(comboItems.get(i));
            }
            comboItems.removeAll(container);
        }
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        IPageCache pageCache = parentView == null ? null : parentView.getPageCache();
        String calOrg = pageCache == null ? null : pageCache.get("adj_calorg");
        String string = costAccount = pageCache == null ? null : pageCache.get("adj_costaccount");
        if (calOrg != null && costAccount != null) {
            List columns = args.getFilterContainerInitEvent().getCommonFilterColumns();
            for (FilterColumn filterColumn : columns) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilterColumn.getFieldName();
                if (this.getOrgFilterName().equals(fieldName)) {
                    filterColumn.setDefaultValue(calOrg);
                    this.getPageCache().put("orgid", calOrg);
                    continue;
                }
                if (!this.getCostAcctFilterName().equals(fieldName)) continue;
                List costAccounts = (List)SerializationUtils.fromJsonString((String)costAccount, List.class);
                filterColumn.setDefaultValues(costAccounts);
            }
            pageCache.remove("adj_calorg");
            pageCache.remove("adj_costaccount");
        } else {
            super.filterContainerInit(args);
        }
    }

    private void mainPageFilterInit(List<FilterColumn> filterColumns, Map<String, Object> paramMap) {
        for (int i = filterColumns.size() - 1; i >= 0; --i) {
            FilterColumn filterColumn = filterColumns.get(i);
            CommonFilterColumn schemeFilterColumn = (CommonFilterColumn)filterColumn;
            String schemeFilterColumnName = schemeFilterColumn.getFieldName();
            if ("costaccount.name".equals(schemeFilterColumnName)) {
                schemeFilterColumn.setDefaultValue(paramMap.get("costaccount").toString());
                continue;
            }
            if ("calorg.name".equals(schemeFilterColumnName)) {
                schemeFilterColumn.setDefaultValue(paramMap.get("calorg").toString());
                continue;
            }
            if ("billstatus".equals(schemeFilterColumnName)) {
                schemeFilterColumn.setDefaultValue(paramMap.get("billstatus").toString());
                continue;
            }
            schemeFilterColumn.setDefaultValue(null);
        }
    }

    private void showFeeShareRecord(Object[] ids) {
        if (ids == null || ids.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CostAdjustListPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        if (ids.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u53ea\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"CostAdjustListPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] costAdjustBills = BusinessDataServiceHelper.load((String)"cal_costadjustbill", (String)"feeshareflag", (QFilter[])new QFilter("id", "in", (Object)ids).toArray());
        HashSet<Long> feeShareRecordIdSet = new HashSet<Long>(costAdjustBills.length);
        for (DynamicObject dynamic : costAdjustBills) {
            long feeshareflag = dynamic.getLong("feeshareflag");
            if (feeshareflag == 0L) continue;
            feeShareRecordIdSet.add(feeshareflag);
        }
        if (feeShareRecordIdSet == null || feeShareRecordIdSet.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u8bb0\u5f55\u3002", (String)"CostRecordEditPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("cal_feeshare_newrecord");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("id", "in", feeShareRecordIdSet));
        showParameter.getListFilterParameter().setQFilters(qFilters);
        for (Long id : feeShareRecordIdSet) {
            showParameter.addLinkQueryPkId((Object)id);
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showApVerifyRecord(Object[] ids) {
        if (ids == null || ids.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CostAdjustListPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        if (ids.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u53ea\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"CostAdjustListPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> invBillEntryIds = new HashSet<Long>();
        DynamicObjectCollection writeOffDynamics = QueryServiceHelper.query((String)"cal_costadjustbill", (String)"calorg,entryentity.invbillentryid", (QFilter[])new QFilter("id", "=", ids[0]).toArray());
        for (DynamicObject dynamic : writeOffDynamics) {
            invBillEntryIds.add(dynamic.getLong("entryentity.invbillentryid"));
        }
        DynamicObjectCollection costRecordDynamics = QueryServiceHelper.query((String)"cal_costrecord", (String)"entry.writeoffid", (QFilter[])new QFilter("entry.id", "in", invBillEntryIds).toArray());
        HashSet<Long> writeOffIds = new HashSet<Long>();
        for (DynamicObject dynamic : costRecordDynamics) {
            if (dynamic.getLong("entry.writeoffid") == 0L) continue;
            writeOffIds.add(dynamic.getLong("entry.writeoffid"));
        }
        if (writeOffIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u8bb0\u5f55\u3002", (String)"CostRecordEditPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        String entityNum = "ap_verifyrecord";
        Long orgId = ((DynamicObject)writeOffDynamics.get(0)).getLong("calorg");
        entityNum = WriteOffServerHelper.getNewRecordEntityNum((Long)orgId, (String)entityNum);
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(entityNum);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("id", "in", writeOffIds));
        showParameter.getListFilterParameter().setQFilters(qFilters);
        Iterator iterator = writeOffIds.iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            showParameter.addLinkQueryPkId((Object)id);
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getFieldName();
        if (fieldName.equals("billno")) {
            return;
        }
        if ("ecalstatus".equals(fieldName) || "calstatus".equals(fieldName)) {
            CalInTimeRptLinkHelper calInTimeRptLinkHelper = new CalInTimeRptLinkHelper(this.getView());
            calInTimeRptLinkHelper.link("cal_costadjustbill", args);
            return;
        }
        if ("invbillnum".equals(fieldName) || "srcbillnum".equals(fieldName)) {
            ListSelectedRowCollection allRowCollection;
            Object selectEntryPkId;
            DynamicObject selectRowEntry;
            BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
            Object pkId = billList.getFocusRowPkId();
            args.setCancel(true);
            int selectRowIndex = args.getRowIndex();
            BillList list = (BillList)this.getControl("billlistap");
            int pageRows = list.getEntryState().getPageRows();
            int pageIndex = list.getEntryState().getCurrentPageIndex();
            if (pageIndex > 1) {
                selectRowIndex -= pageRows * (pageIndex - 1);
            }
            if ((selectRowEntry = QueryServiceHelper.queryOne((String)"cal_costadjustbill", (String)"entryentity.invbillid,entryentity.invbizentityobject,entryentity.srcbillid,entryentity.srcbizentityobject", (QFilter[])new QFilter("entryentity.id", "=", selectEntryPkId = (allRowCollection = list.getCurrentListAllRowCollection()).get(selectRowIndex).getEntryPrimaryKeyValue()).toArray())) == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u53ef\u80fd\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"CostAdjustListPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
            String formId = "";
            BillShowParameter showParameter = new BillShowParameter();
            if ("invbillnum".equals(fieldName)) {
                formId = selectRowEntry.getString("entryentity.invbizentityobject");
                pkId = selectRowEntry.getLong("entryentity.invbillid");
            } else {
                formId = selectRowEntry.getString("entryentity.srcbizentityobject");
                pkId = selectRowEntry.getLong("entryentity.srcbillid");
            }
            if ("cal_costrecord".equals(formId)) {
                formId = "cal_costrecord_subentity";
            }
            showParameter.setFormId(formId);
            showParameter.setPkId(pkId);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            if (!"cal_costestimatebill".equals(formId)) {
                showParameter.setStatus(OperationStatus.VIEW);
            }
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    @Override
    public void filterColumnSetFilter(SetFilterEvent e) {
        String key = e.getFieldName();
        if ("calorg.name".equals(key)) {
            e.addCustomQFilter(this.getCalOrgFilter());
        } else if ("costaccount.name".equals(key)) {
            e.addCustomQFilter(this.getCostaccountFilter(e));
        }
        super.filterColumnSetFilter(e);
    }

    private QFilter getCostaccountFilter(SetFilterEvent e) {
        FilterColumnSetFilterEvent orgArgs = (FilterColumnSetFilterEvent)e;
        List calorgFilterValue = orgArgs.getCommonFilterValue("calorg.name");
        String calorg = null;
        if (calorgFilterValue != null && calorgFilterValue.size() > 0) {
            calorg = String.valueOf(calorgFilterValue.get(0));
        }
        QFilter q = new QFilter("id", "=", (Object)0);
        if (StringUtils.isNotEmpty((CharSequence)calorg)) {
            q = new QFilter("calorg", "=", (Object)Long.valueOf(calorg));
        } else {
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_costadjust_subentity", (String)"47150e89000000ac");
            if (list == null) {
                q = null;
            } else if (list.size() > 0) {
                q = new QFilter("calorg", "in", (Object)list);
            }
        }
        return q;
    }

    private QFilter getCalOrgFilter() {
        List<Long> list = this.getAllPermOrgs();
        QFilter q = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        if (list != null) {
            q = new QFilter("id", "in", list);
        }
        return q;
    }

    private List<Long> getAllPermOrgs() {
        String appInnerId;
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)(appInnerId = AppMetadataCache.getAppInfo((String)"cal").getId()), (String)"cal_costadjust_subentity", (String)"47150e89000000ac");
        if (!rs.hasAllOrgPerm()) {
            return rs.getHasPermOrgs();
        }
        return null;
    }

    private void showBill4ApplyBill(String billentity, Object id) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setPkId(id);
        showParameter.setFormId(billentity);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void queryPrevBill(Object[] ids) {
        DynamicObject costadjustbill = BusinessDataServiceHelper.loadSingle((Object)ids[0], (String)"cal_costadjust_subentity", (String)"id,invbizentityobject,invbillid");
        if (costadjustbill != null) {
            DynamicObjectCollection entry = costadjustbill.getDynamicObjectCollection("entryentity");
            if (entry == null) {
                return;
            }
            DynamicObject entryRow = (DynamicObject)entry.get(0);
            String srcbillentity = entryRow.getString("invbizentityobject");
            Long srcbillid = entryRow.getLong("invbillid");
            if (StringUtils.isNotEmpty((CharSequence)srcbillentity) && "cal_costupdateapplybill".equals(srcbillentity) && srcbillid != null && srcbillid != 0L) {
                this.showBill4ApplyBill(srcbillentity, srcbillid);
                return;
            }
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u6765\u6e90\u5355\u636e\u3002", (String)"CostUpdateApplyBillPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]));
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        if ("costaccount.name".equals(e.getFieldName()) || "costaccount.number".equals(e.getFieldName()) || "costaccount.id".equals(e.getFieldName())) {
            e.addCustomQFilter(this.getCostAccountFilter());
        } else if ("calorg.name".equals(e.getFieldName()) || "calorg.number".equals(e.getFieldName()) || "calorg.id".equals(e.getFieldName())) {
            e.addCustomQFilter(this.getCalOrgFilter());
        }
    }

    private boolean isSameBillStatus(Object[] ids) {
        DynamicObject[] billInfos;
        boolean isSameBillStatus = true;
        String billStatus = null;
        for (DynamicObject billInfo : billInfos = BusinessDataServiceHelper.load((String)"cal_costadjustbill", (String)"billstatus", (QFilter[])new QFilter("id", "in", (Object)ids).toArray())) {
            String nowBillStatus = billInfo.getString("billstatus");
            if ("B".equals(nowBillStatus)) {
                nowBillStatus = "C";
            }
            if (billStatus == null) {
                billStatus = nowBillStatus;
                continue;
            }
            if (billStatus.equals(nowBillStatus)) continue;
            isSameBillStatus = false;
            break;
        }
        return isSameBillStatus;
    }

    private boolean checkSelectPeriod(Object[] ids) {
        boolean isLegalPeriod = true;
        DynamicObject[] billInfos = BusinessDataServiceHelper.load((String)"cal_costadjustbill", (String)"bizdate,costaccount", (QFilter[])new QFilter("id", "in", (Object)ids).toArray());
        long costAccountId = (Long)billInfos[0].getDynamicObject("costaccount").getPkValue();
        DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountId);
        if (currentPeriod == null) {
            return false;
        }
        int currentPeriodInt = currentPeriod.getInt("periodyear") * 100 + currentPeriod.getInt("periodnumber");
        for (DynamicObject billInfo : billInfos) {
            Date billDate = billInfo.getDate("bizdate");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(billDate);
            int year = calendar.get(1);
            int month = calendar.get(2) + 1;
            int billPeriod = year * 100 + month;
            if (billPeriod >= currentPeriodInt) continue;
            isLegalPeriod = false;
            break;
        }
        return isLegalPeriod;
    }

    private boolean isSameAccount(Object[] ids) {
        DynamicObject[] billInfos;
        boolean isSameAccount = true;
        Long accountId = null;
        for (DynamicObject billInfo : billInfos = BusinessDataServiceHelper.load((String)"cal_costadjustbill", (String)"costaccount", (QFilter[])new QFilter("id", "in", (Object)ids).toArray())) {
            Long nowAccountId = (Long)billInfo.getDynamicObject("costaccount").getPkValue();
            if (accountId == null) {
                accountId = nowAccountId;
                continue;
            }
            if (accountId.equals(nowAccountId)) continue;
            isSameAccount = false;
            break;
        }
        return isSameAccount;
    }

    private QFilter getCostAccountFilter() {
        List<Long> list = this.getAllPermOrgs();
        QFilter q = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        if (list != null) {
            q = new QFilter("calorg", "in", list);
        }
        return q;
    }
}

