/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.bill;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.FeeShareHelper;

public class CostDetailListPlugin
extends AbstractListPlugin {
    private static final String BILLTYPEFILTER = "parent.billtype.number";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setFlexMargin();
        this.setFilterFlexMargin();
        this.setCaption();
    }

    public void filterContainerInit(FilterContainerInitArgs e) {
        super.filterContainerInit(e);
        this.setCommonFilter(e);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qlist = e.getQFilters();
        for (QFilter filter : qlist) {
            if ("parent.billtype.id".equals(filter.getProperty()) && !(filter.getValue() instanceof List)) continue;
        }
        e.addCustomQFilter(new QFilter("parent.issplitcreate", "=", (Object)Character.valueOf('0')));
        e.addCustomQFilter(new QFilter("parent.calbilltype", "=", (Object)"IN"));
        e.addCustomQFilter(new QFilter("parent.costaccount.ismainaccount", "=", (Object)Character.valueOf('1')));
        e.addCustomQFilter(new QFilter("parent.costaccount.enable", "=", (Object)"1"));
        e.addCustomQFilter(new QFilter("ownertype", "=", (Object)"bos_org"));
        e.addCustomQFilter(new QFilter("ispresent", "=", (Object)Boolean.FALSE));
        QFilter billStatusf = new QFilter("parent.billstatus", "=", (Object)"C");
        e.addCustomQFilter(billStatusf);
        IFormView parentview = this.getView().getParentView();
        if (parentview != null && "cal_costestimatebill".equals(parentview.getEntityId())) {
            DynamicObject parentcalorg = (DynamicObject)parentview.getModel().getValue("calorg");
            e.addCustomQFilter(new QFilter("parent.calorg.id", "=", parentcalorg == null ? null : parentcalorg.getPkValue()));
            e.addCustomQFilter(new QFilter("parent.ischargeoffed", "!=", (Object)Character.valueOf('1')));
            e.addCustomQFilter(new QFilter("parent.ischargeoff", "!=", (Object)Character.valueOf('1')));
        }
        e.setOrderBy("calentryid");
    }

    protected void setCommonFilter(FilterContainerInitArgs e) {
        List columns = e.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn column : columns) {
            String name = column.getFieldName();
            if (!BILLTYPEFILTER.equals(name)) continue;
            CommonFilterColumn col = (CommonFilterColumn)column;
            DynamicObject[] billtypes = CommonSettingHelper.getExpenseBillType();
            if (billtypes == null || billtypes.length == 0) {
                col.getComboItems().clear();
                return;
            }
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
            for (DynamicObject billtype : billtypes) {
                ComboItem item = new ComboItem();
                item.setId(String.valueOf(billtype.getPkValue()));
                item.setValue(String.valueOf(billtype.getPkValue()));
                item.setCaption(new LocaleString(billtype.getString("name")));
                comboItems.add(item);
            }
            col.setComboItems(comboItems);
            col.setDefaultValue(((ComboItem)comboItems.get(0)).getValue());
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        super.filterContainerBeforeF7Select(e);
        this.setSchemaFilter(e);
    }

    protected void setSchemaFilter(BeforeFilterF7SelectEvent e) {
        String key = e.getFieldName();
        if (BILLTYPEFILTER.equals(key)) {
            e.getCustomQFilters().add(new QFilter("id", "in", (Object)CommonSettingHelper.getExpenseBillTypeIDs()));
        }
    }

    protected void setFlexMargin() {
        HashMap meta = new HashMap();
        HashMap s = new HashMap();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("b", "0px");
        m.put("l", "0px");
        m.put("r", "0px");
        s.put("m", m);
        meta.put("s", s);
        this.getView().updateControlMetadata("flexpanelap1", meta);
    }

    protected void setCaption() {
        HashMap<String, String> meta = new HashMap<String, String>();
        meta.put("bc", "#FFFFFF");
        this.getView().updateControlMetadata("bos_list", meta);
    }

    protected void setFilterFlexMargin() {
        HashMap meta = new HashMap();
        HashMap s = new HashMap();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("l", "0px");
        m.put("r", "0px");
        s.put("m", m);
        meta.put("s", s);
        this.getView().updateControlMetadata("filtercontainerap", meta);
    }

    @Deprecated
    private static class CostDetailDataProvider
    extends ListDataProvider {
        private CostDetailDataProvider() {
        }

        public DynamicObjectCollection getData(int arg0, int arg1) {
            DynamicObjectCollection col = super.getData(arg0, arg1);
            this.filterDetail(col);
            this.getQueryResult().setDataCount(col.size());
            return col;
        }

        private void filterDetail(DynamicObjectCollection col) {
            Iterator it = col.iterator();
            DynamicObject detail = null;
            HashMap<Long, Date> datecache = new HashMap<Long, Date>();
            DynamicObject parent = null;
            while (it.hasNext()) {
                detail = (DynamicObject)it.next();
                if (FeeShareHelper.isEntryIdShare((Long)detail.getLong("id"))) {
                    it.remove();
                    continue;
                }
                parent = detail.getDynamicObject("parent");
                detail.set("currency", parent.get("currency"));
                detail.set("currency_id", parent.get("currency_id"));
                Date bizdate = parent.getDate("bizdate");
                Long calorgid = (Long)parent.getDynamicObject("calorg").getPkValue();
                Date maxdate = datecache.computeIfAbsent(calorgid, k -> AccountingSysHelper.getCurrentPeriodMaxDateByOrg((long)k));
                if (maxdate != null && maxdate.compareTo(bizdate) <= 0) continue;
                it.remove();
            }
        }

        @Deprecated
        private void removeDuplicateDetail(DynamicObjectCollection col) {
            List list = col.getInsertRows();
            col.clear();
            Long nextid = null;
            int size = list.size();
            boolean handled = false;
            for (int i = 0; i < size; ++i) {
                Long beforeid;
                Long currentid = ((DynamicObject)list.get(i)).getLong("calentryid");
                nextid = i == size - 1 ? null : Long.valueOf(((DynamicObject)list.get(i + 1)).getLong("calentryid"));
                Long l = beforeid = i == 0 ? null : Long.valueOf(((DynamicObject)list.get(i - 1)).getLong("calentryid"));
                if (!currentid.equals(beforeid)) {
                    handled = false;
                }
                if (handled) continue;
                if (this.isCalOrgEqualsOwner((DynamicObject)list.get(i))) {
                    col.add(list.get(i));
                    handled = true;
                    continue;
                }
                if (currentid.equals(nextid)) continue;
                col.add(list.get(i));
                handled = true;
            }
        }

        @Deprecated
        private boolean isCalOrgEqualsOwner(DynamicObject detail) {
            Object ownerid = detail.getDynamicObject("owner").getPkValue();
            Object calorgid = detail.getDynamicObject("parent").getDynamicObject("calorg").getPkValue();
            return ownerid.equals(calorgid);
        }
    }
}

