/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.bill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.fi.cal.business.matchrule.MatchResult;
import kd.fi.cal.business.matchrule.MatchRuleAlgorithm;
import kd.fi.cal.business.sharemodel.AmtShareModel;
import kd.fi.cal.business.sharemodel.AmtShareParams;
import kd.fi.cal.business.sharemodel.IStandardAmtExchange;
import kd.fi.cal.business.sharemodel.StandardAmtExchange;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.PermissionHelper;

public class CostEstimateBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String COSTRECORDDETAIL_PAGEID = "COSTRECORDDETAIL_PAGEID";
    private static final String COSTDETALAP = "costdetailap";
    private static final String BAR_DIVIDE = "bar_divide";
    private static final String OP_ESTIMATE = "estimate";
    private static final String BAR_SETTING = "bar_setting";
    private static final String SHARETYPE = "sharetype";
    private static final String MATCHRULE = "matchrule";
    private static final String ESTIMATEDATE = "estimatedate";
    private static final String SHAREAMT = "shareamt";
    private static final String SHAREAMOUNT = "shareamount";
    private static final String SHARETAXAMT = "sharetaxamt";
    private static final String SHARETAXAMOUNT = "sharetaxamount";
    private static final String STANDARDCURRENCY = "standardcurrency";
    private static final String EXRATETABLE = "exratetable";
    private static final String CONVERTMODE = "convertmode";
    private static final String CALORG = "calorg";
    private static final String CALORGIDKEY = "calorgidkey";
    private static final String EXPENSEENTITY = "expenseentity";
    private static final String ESTIMATESTANDARD = "estimatestandard";
    private static final String AMOUNT = "amount";
    private static final String TAXAMOUNT = "taxamount";
    private static final String EXPENSECURRENCY = "expensecurrency";
    private static final String LOCALCURRENCY = "localcurrency";
    private static final String EXPENSEITEM = "expenseitem";
    private static final String RATE = "rate";
    private static final String EXRATEDATE = "exratedate";
    private static final String INTERCOSTAMT = "intercostamt";
    private static final String ESTIMATEAMOUNT = "estimateamount";
    private static final String ESTIMATETAXAMOUNT = "estimatetaxamount";
    private static final String ASSTACTYPE = "asstacttype";
    private static final String ASSTACT = "asstact";
    private static final String ENTRYBARAP = "entrybarap";
    private static final String RESULTENTITY = "resultentity";
    private static final String PREFIX_EXITEMGROUP = "exitemgroup";
    private static final String PREFIX_SHAREAMT = "preshareamt";
    private static final String PREFIX_SHARETAXAMT = "presharetaxamt";
    private static final String PREFIX_SHAREAMOUNT = "preshareamount";
    private static final String PREFIX_SHARETAXAMOUNT = "presharetaxamount";
    private static final String CURRENCY = "currency";
    private static final String COSTDETAIL = "costdetail";
    private static final String CALENTRYID = "calentryid";
    private static final String ISDIRECT = "isdirect";
    private static final String SUBRESULTENTITY = "subresultentity";
    private static final String EXITEMSEQ = "exitemseq";
    private static final String SHAREDETAILAMT = "sharedetailamt";
    private static final String SHAREDETAILTAXAMT = "sharedetailtaxamt";
    private static final String SHAREDETAILAMOUNT = "sharedetailamount";
    private static final String SHAREDETAILTAXAMOUNT = "sharedetailtaxamount";
    private static final String SHAREDETAILEXITEM = "sharedetailexitem";
    private static final String SHAREDETAILATYPE = "sharedetailatype";
    private static final String SHAREDETAILASSTAT = "sharedetailasstact";

    public void afterBindData(EventObject e) {
        IFormView parentView;
        super.afterBindData(e);
        this.initExpenseStandard();
        String status = (String)this.getModel().getValue("billstatus");
        this.showCostDetailView();
        if ("A".equals(status)) {
            this.hideResultExItem(1);
        }
        if (null != (parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId())) && "botp_lookuptracker".equals(parentView.getEntityId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_DIVIDE});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (BAR_SETTING.equals(key)) {
            DynamicObject calOrg = (DynamicObject)this.getModel().getValue(CALORG);
            if (calOrg == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a", (String)"FeeShareParent_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            if (!PermissionHelper.orgPermVerify((Long)userId, (String)"cal_costestimatebill", (String)"0EMSP8HW1NIH", (Long)calOrg.getLong("id"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6682\u4f30\u7684\u6743\u9650\u3002", (String)"CostEstimateBillPlugin_18", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
            this.showEstimateSettingView();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if (OP_ESTIMATE.equals(key) && e.getOperationResult().isSuccess()) {
            this.estimateCost();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List<Long> calorgids = this.getCurrentUserCalOrgIds();
        Long defaultorgid = calorgids == null || calorgids.size() == 0 ? null : calorgids.get(0);
        IDataModel model = this.getModel();
        model.setValue(CALORG, (Object)defaultorgid);
        if (defaultorgid != null) {
            this.changeStandardByCalOrg((DynamicObject)model.getValue(CALORG));
        }
    }

    protected void changeStandardByCalOrg(DynamicObject calOrg) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountingsys_base", (QFilter[])new QFilter("baseacctorg.id", "=", calOrg.getPkValue()).toArray());
        IDataModel model = this.getModel();
        if (obj == null) {
            model.setValue(STANDARDCURRENCY, null);
            model.setValue(EXRATETABLE, null);
            return;
        }
        model.setValue(STANDARDCURRENCY, obj.getDynamicObject("basecurrrency").getPkValue());
        model.setValue(EXRATETABLE, obj.getDynamicObject(EXRATETABLE).getPkValue());
    }

    protected List<Long> getCurrentUserCalOrgIds() {
        IPageCache cache = this.getPageCache();
        String idstr = cache.get(CALORGIDKEY);
        if (idstr != null) {
            return (List)SerializationUtils.fromJsonString((String)idstr, List.class);
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List idlist = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_costestimatebill", (String)"47150e89000000ac");
        if (idlist == null) {
            idlist = OrgUnitServiceHelper.getAllOrg((String)OrgViewTypeEnum.IS_ACCOUNTING.getViewType());
        }
        if (idlist.size() == 0) {
            cache.put(CALORGIDKEY, SerializationUtils.toJsonString((Object)idlist));
            return idlist;
        }
        QFilter filter = new QFilter("id", "in", (Object)idlist);
        filter.and(new QFilter("orgpattern.patterntype", "in", (Object)new String[]{"1", "2"}));
        DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bos_org", (String)"id", (QFilter[])filter.toArray());
        idlist.clear();
        for (DynamicObject org : orgs) {
            idlist.add(org.getLong("id"));
        }
        cache.put(CALORGIDKEY, SerializationUtils.toJsonString((Object)idlist));
        return idlist;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData data = e.getChangeSet()[0];
        int rowIndex = data.getRowIndex();
        Object oldvalue = data.getOldValue();
        Object newvalue = data.getNewValue();
        IDataModel model = this.getModel();
        if (SHARETYPE.equals(key)) {
            ListView listview = this.getChildDetailList();
            listview.clearSelection();
            this.getModel().setValue(MATCHRULE, null);
            this.getView().sendFormAction((IFormView)listview);
        } else if (CALORG.equals(key)) {
            if (newvalue == null) {
                this.getModel().setValue(CALORG, ((DynamicObject)oldvalue).getPkValue());
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostEstimateBillPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                return;
            }
            this.changeStandardByCalOrg((DynamicObject)newvalue);
            model.deleteEntryData(EXPENSEENTITY);
            model.createNewEntryRow(EXPENSEENTITY);
            model.deleteEntryData(RESULTENTITY);
            model.deleteEntryData(SUBRESULTENTITY);
            this.hideResultExItem(1);
            this.refreshChildList();
        } else if (EXPENSECURRENCY.equals(key)) {
            DynamicObject exchangeTable = (DynamicObject)model.getValue(EXRATETABLE);
            DynamicObject standardCurrency = (DynamicObject)model.getValue(STANDARDCURRENCY);
            DynamicObject expenseCurrency = (DynamicObject)model.getValue(EXPENSECURRENCY, rowIndex);
            BigDecimal amount = (BigDecimal)model.getValue(AMOUNT, rowIndex);
            Date estimatedate = (Date)model.getValue(ESTIMATEDATE);
            BigDecimal exRate = null;
            exRate = standardCurrency.getPkValue().equals(expenseCurrency.getPkValue()) ? BigDecimal.ONE : BaseDataServiceHelper.getExchangeRate((Long)exchangeTable.getLong("id"), (Long)expenseCurrency.getLong("id"), (Long)standardCurrency.getLong("id"), (Date)estimatedate);
            exRate = exRate == null ? BigDecimal.ZERO : exRate;
            BigDecimal estimateamount = amount.multiply(exRate).setScale(standardCurrency.getInt("amtprecision"), RoundingMode.HALF_UP);
            model.setValue(RATE, (Object)exRate, rowIndex);
            model.setValue(ESTIMATEAMOUNT, (Object)estimateamount, rowIndex);
        } else if (AMOUNT.equals(key)) {
            DynamicObject standardCurrency = (DynamicObject)model.getValue(STANDARDCURRENCY);
            BigDecimal amount = (BigDecimal)model.getValue(AMOUNT, rowIndex);
            BigDecimal exRate = (BigDecimal)model.getValue(RATE, rowIndex);
            BigDecimal estimateamount = amount.multiply(exRate).setScale(standardCurrency.getInt("amtprecision"), RoundingMode.HALF_UP);
            model.setValue(ESTIMATEAMOUNT, (Object)estimateamount, rowIndex);
        } else if (key.startsWith(PREFIX_SHAREAMOUNT)) {
            this.shareAmountChange(key, e.getChangeSet()[0]);
        } else if (key.startsWith(PREFIX_SHARETAXAMOUNT)) {
            this.shareTaxAmountChange(key, e.getChangeSet()[0]);
        }
    }

    protected void refreshChildList() {
        ListView childview = this.getChildDetailList();
        childview.refresh();
        this.getView().sendFormAction((IFormView)childview);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        IDataModel model;
        Object standardcurrency;
        String key = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if (SHARETYPE.equals(key)) {
            this.addSharetypeFilter(showParameter);
        } else if (MATCHRULE.equals(key)) {
            this.addMatchRuleFilter(showParameter);
        } else if (CALORG.equals(key)) {
            this.addCalOrgFilter(showParameter);
        } else if (EXPENSECURRENCY.equals(key) && (standardcurrency = (model = this.getModel()).getValue(STANDARDCURRENCY)) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5206\u644a\u5e01\u79cd\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u5b58\u5728\u6838\u7b97\u7ec4\u7ec7\u672c\u4f4d\u5e01\u8bbe\u7f6e\u7684\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostEstimateBillPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        BillView view = (BillView)e.getSource();
        EntryGrid entrygrid = (EntryGrid)view.getControl(RESULTENTITY);
        IDataModel model = view.getModel();
        this.initResultEntry(model, entrygrid);
        model.setDataChanged(false);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (!OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getModel().setDataChanged(false);
        }
    }

    protected void initResultEntry(IDataModel model, EntryGrid entrygrid) {
        DynamicObjectCollection resultcol = model.getDataEntity(true).getDynamicObjectCollection(RESULTENTITY);
        DynamicObjectCollection expensecol = model.getDataEntity(true).getDynamicObjectCollection(EXPENSEENTITY);
        Iterator it = resultcol.iterator();
        this.hideResultExItem(expensecol.size() + 1);
        for (DynamicObject expense : expensecol) {
            entrygrid.setColumnProperty(PREFIX_EXITEMGROUP + expense.getInt("seq"), "header", expense.getDynamicObject(EXPENSEITEM).get("fullname"));
        }
        DynamicObject resultentry = null;
        Object costrecordid = this.getCostRecordID();
        while (it.hasNext()) {
            resultentry = (DynamicObject)it.next();
            if (costrecordid == null) {
                if (!resultentry.getBoolean(ISDIRECT)) {
                    it.remove();
                    continue;
                }
            } else if (!costrecordid.equals(resultentry.getDynamicObject(COSTDETAIL).getDynamicObject("parent").getPkValue())) {
                it.remove();
                continue;
            }
            for (DynamicObject entrydetail : resultentry.getDynamicObjectCollection(SUBRESULTENTITY)) {
                int exitemseq = entrydetail.getInt(EXITEMSEQ);
                resultentry.set(PREFIX_SHAREAMT + exitemseq, (Object)entrydetail.getBigDecimal(SHAREDETAILAMT));
                resultentry.set(PREFIX_SHAREAMOUNT + exitemseq, (Object)entrydetail.getBigDecimal(SHAREDETAILAMOUNT));
                resultentry.set(PREFIX_SHARETAXAMT + exitemseq, (Object)entrydetail.getBigDecimal(SHAREDETAILTAXAMT));
                resultentry.set(PREFIX_SHARETAXAMOUNT + exitemseq, (Object)entrydetail.getBigDecimal(SHAREDETAILTAXAMOUNT));
            }
        }
    }

    protected Object getCostRecordID() {
        return this.getView().getFormShowParameter().getCustomParam("costrecordid");
    }

    protected void shareAmountChange(String key, ChangeData changeData) {
        int index = changeData.getRowIndex();
        IDataModel model = this.getModel();
        BigDecimal standardamt = (BigDecimal)model.getValue(key);
        Date bizdate = (Date)model.getValue(ESTIMATEDATE);
        int expenseseq = Integer.parseInt(key.replaceAll(PREFIX_SHAREAMOUNT, ""));
        DynamicObject currency = (DynamicObject)model.getValue(STANDARDCURRENCY);
        Long exratetableid = ((DynamicObject)model.getValue(EXRATETABLE)).getLong("id");
        StandardAmtExchange exchange = new StandardAmtExchange(currency, exratetableid);
        BigDecimal sourceamt = exchange.exchangeToSourceAmt(standardamt, (DynamicObject)model.getValue(CURRENCY, index), bizdate);
        BigDecimal sourceamtNew = sourceamt.subtract((BigDecimal)model.getValue(PREFIX_SHAREAMOUNT + expenseseq, index)).add((BigDecimal)model.getValue(SHAREAMT));
        model.setValue(PREFIX_SHAREAMT + expenseseq, (Object)sourceamt, index);
        model.setValue(SHAREAMT, (Object)sourceamtNew, index);
        model.setEntryCurrentRowIndex(RESULTENTITY, index);
        int size = model.getEntryRowCount(SUBRESULTENTITY);
        for (int i = 0; i < size; ++i) {
            Integer currentexitemseq = (Integer)model.getValue(EXITEMSEQ, i);
            if (expenseseq != currentexitemseq) continue;
            model.setValue(SHAREDETAILAMT, (Object)sourceamt, i);
            model.setValue(SHAREDETAILAMOUNT, (Object)standardamt, i);
            break;
        }
        BigDecimal standardamtNew = ((BigDecimal)changeData.getNewValue()).subtract((BigDecimal)changeData.getOldValue()).add((BigDecimal)model.getValue(SHAREAMOUNT));
        model.setValue(SHAREAMOUNT, (Object)standardamtNew, index);
    }

    protected void shareTaxAmountChange(String key, ChangeData changeData) {
        int index = changeData.getRowIndex();
        IDataModel model = this.getModel();
        BigDecimal standardtaxamt = (BigDecimal)model.getValue(key);
        Date bizdate = (Date)model.getValue(ESTIMATEDATE);
        int expenseseq = Integer.parseInt(key.replaceAll(PREFIX_SHARETAXAMOUNT, ""));
        DynamicObject currency = (DynamicObject)model.getValue(STANDARDCURRENCY);
        Long exratetableid = ((DynamicObject)model.getValue(EXRATETABLE)).getLong("id");
        StandardAmtExchange exchange = new StandardAmtExchange(currency, exratetableid);
        BigDecimal sourcetaxamt = exchange.exchangeToSourceAmt(standardtaxamt, (DynamicObject)model.getValue(CURRENCY, index), bizdate);
        BigDecimal sourcetaxamtNew = sourcetaxamt.subtract((BigDecimal)model.getValue(PREFIX_SHARETAXAMOUNT + expenseseq, index)).add((BigDecimal)model.getValue(SHARETAXAMT));
        model.setValue(PREFIX_SHARETAXAMT + expenseseq, (Object)sourcetaxamt, index);
        model.setValue(SHARETAXAMT, (Object)sourcetaxamtNew, index);
        model.setEntryCurrentRowIndex(RESULTENTITY, index);
        int size = model.getEntryRowCount(SUBRESULTENTITY);
        for (int i = 0; i < size; ++i) {
            Integer currentexitemseq = (Integer)model.getValue(EXITEMSEQ, i);
            if (expenseseq != currentexitemseq) continue;
            model.setValue(SHAREDETAILTAXAMT, (Object)sourcetaxamt, i);
            model.setValue(SHAREDETAILTAXAMOUNT, (Object)standardtaxamt, i);
            break;
        }
        BigDecimal standardtaxamtNew = ((BigDecimal)changeData.getNewValue()).subtract((BigDecimal)changeData.getOldValue()).add((BigDecimal)model.getValue(SHARETAXAMOUNT));
        model.setValue(SHARETAXAMOUNT, (Object)standardtaxamtNew, index);
    }

    protected void checkEsDate(Date date) {
        IDataModel model = this.getModel();
        if (date == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6682\u4f30\u65e5\u671f\u3002", (String)"CostEstimateBillPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        DynamicObject calOrg = (DynamicObject)model.getValue(CALORG);
        Date maxDate = AccountingSysHelper.getCurrentPeriodMaxDateByOrg((long)calOrg.getLong("id"));
        if (maxDate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e0b\u6ca1\u6709\u542f\u7528\u4e2d\u7684\u6210\u672c\u8d26\u7c3f\uff0c\u6216\u6210\u672c\u8d26\u7c3f\u672a\u521d\u59cb\u5316\u3002", (String)"CostEstimateBillPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        if (maxDate.compareTo(date) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6682\u4f30\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e0b\u6210\u672c\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u6700\u5927\u4e00\u671f\u7684\u5f00\u59cb\u65f6\u95f4\u3002", (String)"CostEstimateBillPlugin_4", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }

    protected void estimateCost() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        model.beginInit();
        this.reLoadInterCost();
        this.checkAndReturnBill();
        IStandardAmtExchange exchange = this.getIExchange();
        Object[] detailids = this.getDetailIDs();
        Map<DynamicObject, List<DynamicObject>> relationmap = this.getExpenseToCostdetailsRelations(detailids);
        this.clearResultData();
        this.hideResultExItem(relationmap.size() + 1);
        this.shareExpense(relationmap, exchange);
        this.calTotalSharedAmt();
        model.endInit();
        view.updateView(EXPENSEENTITY);
        view.updateView(RESULTENTITY);
        view.updateView(SUBRESULTENTITY);
    }

    protected void calTotalSharedAmt() {
        IDataModel model = this.getModel();
        int resultsize = model.getEntryRowCount(RESULTENTITY);
        for (int i = 0; i < resultsize; ++i) {
            model.setEntryCurrentRowIndex(RESULTENTITY, i);
            int resultentrysize = model.getEntryRowCount(SUBRESULTENTITY);
            BigDecimal totalsharedAmt = BigDecimal.ZERO;
            BigDecimal totalsharedstandardamt = BigDecimal.ZERO;
            BigDecimal totalsharedTaxAmt = BigDecimal.ZERO;
            BigDecimal totalsharedstandardtaxamt = BigDecimal.ZERO;
            for (int j = 0; j < resultentrysize; ++j) {
                totalsharedAmt = totalsharedAmt.add((BigDecimal)model.getValue(SHAREDETAILAMT, j));
                totalsharedstandardamt = totalsharedstandardamt.add((BigDecimal)model.getValue(SHAREDETAILAMOUNT, j));
                totalsharedTaxAmt = totalsharedTaxAmt.add((BigDecimal)model.getValue(SHAREDETAILTAXAMT, j));
                totalsharedstandardtaxamt = totalsharedstandardtaxamt.add((BigDecimal)model.getValue(SHAREDETAILTAXAMOUNT, j));
            }
            model.setValue(SHAREAMT, (Object)totalsharedAmt, i);
            model.setValue(SHAREAMOUNT, (Object)totalsharedstandardamt, i);
            model.setValue(SHARETAXAMT, (Object)totalsharedTaxAmt, i);
            model.setValue(SHARETAXAMOUNT, (Object)totalsharedstandardtaxamt, i);
        }
        model.setEntryCurrentRowIndex(RESULTENTITY, -1);
    }

    protected IStandardAmtExchange getIExchange() {
        IDataModel model = this.getModel();
        DynamicObject standardcurrency = (DynamicObject)model.getValue(STANDARDCURRENCY);
        DynamicObject extable = (DynamicObject)model.getValue(EXRATETABLE);
        return new StandardAmtExchange(standardcurrency, Long.valueOf(extable.getLong("id")), "1");
    }

    protected void shareExpense(Map<DynamicObject, List<DynamicObject>> relationmap, IStandardAmtExchange exchange) {
        List<DynamicObject> costdetails = null;
        IDataModel model = this.getModel();
        DynamicObject bill = model.getDataEntity(true);
        Date bizdate = bill.getDate(ESTIMATEDATE);
        EntryGrid entrygrid = (EntryGrid)this.getView().getControl(RESULTENTITY);
        for (Map.Entry<DynamicObject, List<DynamicObject>> entry : relationmap.entrySet()) {
            DynamicObject expense = entry.getKey();
            costdetails = entry.getValue();
            String dividestandard = expense.getString(ESTIMATESTANDARD);
            BigDecimal interCostAmt = expense.getBigDecimal(INTERCOSTAMT);
            BigDecimal expenseamount = expense.getBigDecimal(ESTIMATEAMOUNT);
            BigDecimal expensetax = expense.getBigDecimal(ESTIMATETAXAMOUNT);
            DynamicObject expensecurrency = expense.getDynamicObject(EXPENSECURRENCY);
            DynamicObject expenseitem = expense.getDynamicObject(EXPENSEITEM);
            String asstActype = expense.getString(ASSTACTYPE);
            DynamicObject asstact = expense.getDynamicObject(ASSTACT);
            AmtShareParams param = new AmtShareParams();
            if (interCostAmt != null && interCostAmt.compareTo(BigDecimal.ZERO) != 0) {
                param.setIsInterCostAmt(Boolean.TRUE);
                param.setBizdate(expense.getDate(EXRATEDATE));
                param.setSourcecurrency(expense.getDynamicObject(LOCALCURRENCY));
                param.setTotalsourceamt(interCostAmt);
                param.setTotalsourcetaxamt(interCostAmt);
            } else {
                param.setIsInterCostAmt(Boolean.FALSE);
                param.setBizdate(bizdate);
                param.setSourcecurrency(expensecurrency);
                param.setTotalstandardamt(expenseamount);
                param.setTotalstandardtaxamt(expensetax);
            }
            param.setDividestandard(dividestandard);
            param.setExchange(exchange);
            param.setSharebills(costdetails);
            AmtShareModel sharemodel = new AmtShareModel(param);
            int seq = expense.getInt("seq");
            entrygrid.setColumnProperty(PREFIX_EXITEMGROUP + seq, "header", expenseitem.get("fullname"));
            entrygrid.setColumnProperty(PREFIX_EXITEMGROUP + seq, "vi", (Object)63);
            for (DynamicObject costdetail : costdetails) {
                int resultindex = this.findResultEntryIndex(costdetail.getPkValue());
                model.setValue(COSTDETAIL, costdetail.getPkValue(), resultindex);
                model.setValue(CURRENCY, costdetail.getDynamicObject(CURRENCY).getPkValue(), resultindex);
                model.setValue(CALENTRYID, (Object)costdetail.getLong(CALENTRYID), resultindex);
                model.setEntryCurrentRowIndex(RESULTENTITY, resultindex);
                int resultentryindex = model.createNewEntryRow(SUBRESULTENTITY);
                model.setValue(SHAREDETAILEXITEM, expenseitem.getPkValue(), resultentryindex);
                BigDecimal sharedetailamt = sharemodel.getSharedBillAmt(costdetail.getPkValue(), costdetail.getDynamicObject(CURRENCY));
                BigDecimal sharedetailamount = sharemodel.getSharedStandardAmt(costdetail.getPkValue());
                BigDecimal sharedetailtax = sharemodel.getSharedBillTaxAmt(costdetail.getPkValue(), costdetail.getDynamicObject(CURRENCY));
                BigDecimal sharedetailtaxamt = sharemodel.getSharedStandardTaxAmt(costdetail.getPkValue());
                model.setValue(SHAREDETAILAMT, (Object)sharedetailamt, resultentryindex);
                model.setValue(SHAREDETAILTAXAMT, (Object)sharedetailtax, resultentryindex);
                model.setValue(SHAREDETAILAMOUNT, (Object)sharedetailamount, resultentryindex);
                model.setValue(SHAREDETAILTAXAMOUNT, (Object)sharedetailtaxamt, resultentryindex);
                model.setValue(EXITEMSEQ, (Object)seq, resultentryindex);
                model.setValue(SHAREDETAILATYPE, (Object)asstActype, resultentryindex);
                model.setValue(SHAREDETAILASSTAT, (Object)asstact, resultentryindex);
                model.setValue(PREFIX_SHAREAMT + seq, (Object)sharedetailamt, resultindex);
                model.setValue(PREFIX_SHARETAXAMT + seq, (Object)sharedetailtax, resultindex);
                model.setValue(PREFIX_SHAREAMOUNT + seq, (Object)sharedetailamount, resultindex);
                model.setValue(PREFIX_SHARETAXAMOUNT + seq, (Object)sharedetailtaxamt, resultindex);
            }
        }
    }

    protected void hideResultExItem(int count) {
        EntryGrid entrygrid = (EntryGrid)this.getView().getControl(RESULTENTITY);
        while (count <= 10) {
            entrygrid.setColumnProperty(PREFIX_EXITEMGROUP + count, "vi", (Object)0);
            ++count;
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit sharetype = (BasedataEdit)this.getControl(SHARETYPE);
        sharetype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit matchrule = (BasedataEdit)this.getControl(MATCHRULE);
        matchrule.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit calorg = (BasedataEdit)this.getControl(CALORG);
        calorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit expensecurrency = (BasedataEdit)this.getControl(EXPENSECURRENCY);
        expensecurrency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{ENTRYBARAP});
    }

    protected int findResultEntryIndex(Object costdetailid) {
        IDataModel model = this.getModel();
        int size = model.getEntryRowCount(RESULTENTITY);
        if (size == 0) {
            return model.createNewEntryRow(RESULTENTITY);
        }
        for (int i = 0; i < size; ++i) {
            DynamicObject costdetail = (DynamicObject)model.getValue(COSTDETAIL, i);
            if (!costdetailid.equals(costdetail.getPkValue())) continue;
            return i;
        }
        return model.createNewEntryRow(RESULTENTITY);
    }

    protected void clearResultData() {
        IDataModel entryOperate = this.getModel();
        int size = entryOperate.getEntryRowCount(RESULTENTITY);
        for (int i = 0; i < size; ++i) {
            entryOperate.setEntryCurrentRowIndex(RESULTENTITY, i);
            entryOperate.deleteEntryData(SUBRESULTENTITY);
        }
        entryOperate.setEntryCurrentRowIndex(RESULTENTITY, -1);
        entryOperate.deleteEntryData(RESULTENTITY);
    }

    protected Object[] getDetailIDs() {
        Object[] detailids = null;
        DynamicObject sharetype = (DynamicObject)this.getModel().getValue(SHARETYPE);
        DynamicObject matchrule = (DynamicObject)this.getModel().getValue(MATCHRULE);
        if (sharetype == null || matchrule != null && matchrule.getBoolean("nonematch")) {
            detailids = this.getSelectedDetailIDs();
            if (detailids == null || detailids.length == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u4e2d\u4e00\u6761\u6210\u672c\u8bb0\u5f55\u660e\u7ec6\u7528\u4e8e\u5206\u644a\u9884\u89c8\u3002", (String)"CostEstimateBillPlugin_5", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
        } else {
            detailids = this.getAllDetailIDs();
            if (detailids == null || detailids.length == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u8fc7\u6ee4\u51fa\u4e00\u6761\u4e0e\u6210\u672c\u8bb0\u5f55\u660e\u7ec6\u7528\u4e8e\u5206\u644a\u9884\u89c8\u3002", (String)"CostEstimateBillPlugin_6", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
        }
        return detailids;
    }

    protected void reLoadInterCost() {
        Set apIds;
        IDataModel model = this.getModel();
        int size = model.getEntryRowCount(EXPENSEENTITY);
        if (size == 0) {
            return;
        }
        if (model.getValue(LOCALCURRENCY, 0) != null) {
            return;
        }
        Long apBillId = null;
        Map apBillIdMap = BFTrackerServiceHelper.findSourceBills((String)"cal_costestimatebill", (Long[])new Long[]{(Long)model.getValue("id")});
        if (apBillIdMap != null && !apBillIdMap.isEmpty() && (apIds = (Set)apBillIdMap.get("ap_busbill")) != null && !apIds.isEmpty()) {
            apBillId = (Long)new ArrayList(apIds).get(0);
        }
        if (apBillId == null || apBillId.equals(0L)) {
            return;
        }
        DynamicObject apBusBill = BusinessDataServiceHelper.loadSingle((Object)apBillId, (String)"ap_busbill");
        DynamicObjectCollection apBusBillEntry = apBusBill.getDynamicObjectCollection("entry");
        for (int i = 0; i < size; ++i) {
            model.setValue(LOCALCURRENCY, (Object)apBusBill.getDynamicObject("basecurrency").getLong("id"), i);
            model.setValue(EXRATEDATE, (Object)apBusBill.getDate(EXRATEDATE), i);
            BigDecimal apInterCost = ((DynamicObject)apBusBillEntry.get(i)).getBigDecimal(INTERCOSTAMT);
            if (apInterCost == null || apInterCost.compareTo(BigDecimal.ZERO) == 0) continue;
            model.setValue(INTERCOSTAMT, (Object)apInterCost, i);
            model.setValue(ESTIMATEAMOUNT, (Object)apInterCost, i);
            model.setValue(ESTIMATETAXAMOUNT, (Object)apInterCost, i);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{model.getDataEntity()});
    }

    protected void checkAndReturnBill() {
        IDataModel model = this.getModel();
        int size = model.getEntryRowCount(EXPENSEENTITY);
        if (size == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u7ef4\u62a4\u4e00\u6761\u6709\u6548\u7684\u8d39\u7528\u4fe1\u606f\u5206\u5f55\uff0c\u8d39\u7528\u9879\u76ee\uff0c\u8d39\u7528\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u91d1\u989d\u5927\u4e8e0\u3002", (String)"CostEstimateBillPlugin_7", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        if (model.getValue(CALORG) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostEstimateBillPlugin_8", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        this.checkEsDate((Date)model.getValue(ESTIMATEDATE));
        for (int i = 0; i < size; ++i) {
            String content;
            if (model.getValue(EXPENSEITEM, i) == null) {
                content = String.format(ResManager.loadKDString((String)"\u8d39\u7528\u4fe1\u606f\u7b2c%1$s\u884c\u8d39\u7528\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CostEstimateBillPlugin_19", (String)"fi-cal-formplugin", (Object[])new Object[0]), i + 1);
                throw new KDBizException(content);
            }
            if (model.getValue(EXPENSECURRENCY, i) == null) {
                content = String.format(ResManager.loadKDString((String)"\u8d39\u7528\u4fe1\u606f\u7b2c%1$s\u884c\u8d39\u7528\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CostEstimateBillPlugin_20", (String)"fi-cal-formplugin", (Object[])new Object[0]), i + 1);
                throw new KDBizException(content);
            }
            String estimateStandard = (String)model.getValue(ESTIMATESTANDARD, i);
            if (estimateStandard != null && !estimateStandard.trim().isEmpty()) continue;
            String content2 = String.format(ResManager.loadKDString((String)"\u8d39\u7528\u4fe1\u606f\u7b2c%1$s\u884c\u5206\u644a\u6807\u51c6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CostEstimateBillPlugin_21", (String)"fi-cal-formplugin", (Object[])new Object[0]), i + 1);
            throw new KDBizException(content2);
        }
    }

    protected Map<DynamicObject, List<DynamicObject>> getExpenseToCostdetailsRelations(Object[] detailids) {
        Map<Object, List<Object>> map = null;
        DynamicObject bill = this.getModel().getDataEntity(true);
        DynamicObject sharetype = (DynamicObject)this.getModel().getValue(SHARETYPE);
        DynamicObject matchrule = (DynamicObject)this.getModel().getValue(MATCHRULE);
        if (sharetype == null || matchrule != null && matchrule.getBoolean("nonematch")) {
            map = new HashMap<DynamicObject, List<DynamicObject>>();
            Collection<DynamicObject> details = this.getCostDetailCollection(new QFilter("id", "in", (Object)detailids).toArray());
            if (details.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u53ef\u80fd\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"FeeShareRecordPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
            for (DynamicObject expense : bill.getDynamicObjectCollection(EXPENSEENTITY)) {
                map.put(expense, new ArrayList<DynamicObject>(details));
            }
        } else {
            if (matchrule == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5339\u914d\u89c4\u5219\u3002", (String)"CostEstimateBillPlugin_14", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
            MatchRuleAlgorithm algorithm = new MatchRuleAlgorithm(matchrule.getPkValue());
            MatchResult result = algorithm.matchRules(bill, this.getCostDetailCollection(new QFilter("id", "in", (Object)detailids).toArray()));
            if (!result.getAssttype().getName().equals("cal_costdetail") || result.getMastertype().getAlias().equals("t_cal_costestimatebill")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5339\u914d\u6761\u4ef6\u4e0d\u5408\u6cd5\uff0c\u8bf7\u914d\u7f6e\u8d39\u7528\u6682\u4f30\u5355\u5206\u5f55\u5b57\u6bb5\u4e0e\u6210\u672c\u8bb0\u5f55\u660e\u7ec6\u7684\u6620\u5c04\u5173\u7cfb\u3002", (String)"CostEstimateBillPlugin_15", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
            map = result.getResultmap();
        }
        return map;
    }

    protected Collection<DynamicObject> getCostDetailCollection(QFilter[] filters) {
        Map detailmap = BusinessDataServiceHelper.loadFromCache((String)"cal_costdetail", (QFilter[])filters);
        if (detailmap == null || detailmap.isEmpty()) {
            return Collections.emptyList();
        }
        Collection<DynamicObject> col = detailmap.values();
        for (DynamicObject detail : col) {
            if (detail == null || detail.getDynamicObject("parent") == null) continue;
            detail.set(CURRENCY, (Object)detail.getDynamicObject("parent").getDynamicObject(LOCALCURRENCY));
        }
        return col;
    }

    protected Object[] getSelectedDetailIDs() {
        ListView view = this.getChildDetailList();
        return view.getSelectedRows().getPrimaryKeyValues();
    }

    protected Object[] getAllDetailIDs() {
        ListView view = this.getChildDetailList();
        return view.getCurrentListAllRowCollection().getPrimaryKeyValues();
    }

    protected ListView getChildDetailList() {
        ListView view = (ListView)this.getView().getView(this.getPageCache().get(COSTRECORDDETAIL_PAGEID));
        return view;
    }

    protected void showCostDetailView() {
        ListShowParameter param = new ListShowParameter();
        param.setFormId("bos_list");
        param.setBillFormId("cal_costdetail");
        param.setMultiSelect(true);
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey(COSTDETALAP);
        this.getView().showForm((FormShowParameter)param);
        this.getPageCache().put(COSTRECORDDETAIL_PAGEID, param.getPageId());
    }

    protected void showEstimateSettingView() {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("cal_costestimate_setting");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "setting_close"));
        this.getView().showForm(param);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object obj;
        super.closedCallBack(e);
        String actionid = e.getActionId();
        if ("setting_close".equals(actionid) && (obj = e.getReturnData()) instanceof Boolean && ((Boolean)obj).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fee\u6539\u6682\u4f30\u914d\u7f6e\u540e\u8bf7\u91cd\u65b0\u6253\u5f00\u8d39\u7528\u6682\u4f30\u5355\u4ee5\u9002\u914d\u65b0\u7684\u6682\u4f30\u914d\u7f6e\u3002", (String)"CostEstimateBillPlugin_16", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }

    protected void initExpenseStandard() {
        MainEntityType entitytype = EntityMetadataCache.getDataEntityType((String)"cal_costdetail");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        List<String> standards = Arrays.asList(CommonSettingHelper.getEstimatestandards());
        for (IDataEntityProperty pro : entitytype.getProperties()) {
            if (!standards.contains(pro.getName())) continue;
            ComboItem item = new ComboItem(pro.getDisplayName(), pro.getName());
            items.add(item);
        }
        if (items.isEmpty()) {
            return;
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl(EXPENSEENTITY);
        List list = grid.getControls();
        for (Control c : list) {
            if (!ESTIMATESTANDARD.equals(c.getKey())) continue;
            ComboEdit co = (ComboEdit)c;
            co.setComboItems(items);
            return;
        }
    }

    protected void addSharetypeFilter(ListShowParameter showParameter) {
        QFilter filter = new QFilter("asstbill.number", "=", (Object)"cal_costdetail");
        filter.and(new QFilter("masterbill.number", "=", (Object)"cal_costestimatebill"));
        showParameter.getListFilterParameter().setFilter(filter);
    }

    protected void addMatchRuleFilter(ListShowParameter showParameter) {
        DynamicObject sharetype = (DynamicObject)this.getModel().getValue(SHARETYPE);
        if (sharetype == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u644a\u7c7b\u578b\u3002", (String)"CostEstimateBillPlugin_17", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        showParameter.getListFilterParameter().setFilter(new QFilter("writeofftype", "=", sharetype.getPkValue()));
    }

    private void addCalOrgFilter(ListShowParameter showParameter) {
        showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", this.getCurrentUserCalOrgIds()));
    }
}

