/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.WriteOffServerHelper;

public class CostRecordEditPlugin
extends AbstractFormPlugin {
    private static final String QUERY_COSTESTIMATERECORD = "tbl_querycostestimaterecord";
    private static final String QUERY_QUERYFEESHARERECORD = "tbl_queryfeesharerecord";
    private static final String QUERY_QUERYFEESHARERECORDDETAIL = "tbl_queryfeesharerecorddetail";

    public void afterBindData(EventObject e) {
        String showSubElement = CalDbParamServiceHelper.getString((String)CalDbParamConstant.BILL_SHOW_SUBELEMENTENTRY, null);
        if ("1".equals(showSubElement)) {
            return;
        }
        boolean calByCostelement = false;
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount != null) {
            DynamicObject costAccountDy = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.calbycostelement", (QFilter[])new QFilter("id", "=", costAccount.getPkValue()).toArray());
            calByCostelement = costAccountDy.getBoolean("calpolicy.calbycostelement");
        }
        this.getView().setVisible(Boolean.valueOf(calByCostelement), new String[]{"subentrycostelement"});
        if (calByCostelement) {
            DynamicObjectCollection coll = this.getModel().getEntryEntity("entry");
            for (DynamicObject entry : coll) {
                DynamicObjectCollection subColl = entry.getDynamicObjectCollection("subentrycostelement");
                Iterator it = subColl.iterator();
                while (it.hasNext()) {
                    DynamicObject subEntry = (DynamicObject)it.next();
                    BigDecimal sub_unitstandardcost = subEntry.getBigDecimal("sub_unitstandardcost");
                    BigDecimal sub_unitactualcost = subEntry.getBigDecimal("sub_unitactualcost");
                    if (sub_unitstandardcost.compareTo(BigDecimal.ZERO) != 0 || sub_unitactualcost.compareTo(BigDecimal.ZERO) != 0) continue;
                    it.remove();
                }
            }
            this.getModel().setDataChanged(false);
        }
        this.getView().updateView("subentrycostelement");
        super.afterBindData(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        long bizBillId = (Long)this.getModel().getValue("bizbillid");
        DynamicObject bizEntityObject = (DynamicObject)this.getModel().getValue("bizentityobject");
        if ("tbl_viewbizbill".equals(key)) {
            if (bizBillId == 0L || bizEntityObject == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5173\u8054\u7684\u4e1a\u52a1\u5355\u636e\u3002", (String)"CostRecordEditPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                return;
            }
            this.showBizBill(bizBillId, bizEntityObject.getString("number"));
        } else if ("tbl_queryinwriteoffrecord".equals(key) || "tbl_queryoutwriteoffrecord".equals(key)) {
            String calBillType = (String)this.getModel().getValue("calbilltype");
            if ("IN".equals(calBillType) && "tbl_queryoutwriteoffrecord".equals(key) || "OUT".equals(calBillType) && "tbl_queryinwriteoffrecord".equals(key)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u8bb0\u5f55\u3002", (String)"CostRecordEditPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                return;
            }
            HashSet<Long> writeOffIds = new HashSet<Long>();
            boolean isSplitCreate = (Boolean)this.getModel().getValue("issplitcreate");
            if (!isSplitCreate) {
                QFilter q = new QFilter("entry.ancestorbillid", "=", this.getModel().getValue("id"));
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"entry.writeoffid", (QFilter[])new QFilter[]{q}, null);){
                    for (Row row : dataSet) {
                        long writeOffId = row.getLong("entry.writeoffid");
                        if (writeOffId == 0L) continue;
                        writeOffIds.add(writeOffId);
                    }
                }
            } else {
                int entryRowCount = this.getModel().getEntryRowCount("entry");
                for (int i = 0; i < entryRowCount; ++i) {
                    long writeoffId = (Long)this.getModel().getValue("writeoffid", i);
                    if (writeoffId == 0L) continue;
                    writeOffIds.add(writeoffId);
                }
            }
            String entityNum = "tbl_queryinwriteoffrecord".equals(key) ? "ap_verifyrecord" : "ar_verifyrecord";
            Long calorgId = ((DynamicObject)this.getModel().getValue("calorg")).getLong("id");
            entityNum = WriteOffServerHelper.getNewRecordEntityNum((Long)calorgId, (String)entityNum);
            this.showWriteOffRecord(writeOffIds, entityNum);
        } else if (QUERY_COSTESTIMATERECORD.equals(key)) {
            this.showCostEstimateRecord(this.getModel().getDataEntity().getPkValue());
        } else if (QUERY_QUERYFEESHARERECORD.equals(key)) {
            this.showFeeShareRecord(this.getModel().getDataEntity().getPkValue());
        } else if (QUERY_QUERYFEESHARERECORDDETAIL.equals(key)) {
            this.showFeeShareRecordDetail(this.getModel().getDataEntity().getPkValue());
        } else if ("tbl_querychargeoffbill".equals(key)) {
            this.showChargeOffBill((Long)this.getModel().getDataEntity().getPkValue(), true);
        } else if ("tbl_querychargeoffedbill".equals(key)) {
            this.showChargeOffBill((Long)this.getModel().getDataEntity().getPkValue(), false);
        } else if ("tbl_querycostadjust".equals(key)) {
            this.showCostAdjustBill((Long)this.getModel().getDataEntity().getPkValue());
        }
    }

    private void showCostAdjustBill(Long id) {
        IPageCache pageCache;
        ListShowParameter param;
        BillShowParameter bill;
        QFilter filter = new QFilter("entryentity.invbillid", "=", (Object)id);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cal_costadjust_subentity", (String)"id,costaccount", (QFilter[])new QFilter[]{filter});
        DynamicObjectCollection stdCostObjs = QueryServiceHelper.query((String)"cal_stdcostdiffbill", (String)"id,costaccount", (QFilter[])new QFilter[]{filter});
        if (dynamicObjects.isEmpty() && stdCostObjs.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5173\u8054\u7684\u4e1a\u52a1\u5355\u636e\u3002", (String)"CostRecordListPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        String calOrg = this.getModel().getDataEntity().getString("calorg.id");
        HashSet<String> costAccountList = new HashSet<String>(16);
        costAccountList.add(this.getModel().getDataEntity().getString("costaccount.id"));
        ArrayList<Long> costAdjustIds = new ArrayList<Long>(16);
        ArrayList<Long> stdCostIds = new ArrayList<Long>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            costAdjustIds.add(dynamicObject.getLong("id"));
        }
        for (DynamicObject stdCostObj : stdCostObjs) {
            stdCostIds.add(stdCostObj.getLong("id"));
        }
        if (!costAdjustIds.isEmpty()) {
            if (costAdjustIds.size() == 1) {
                bill = new BillShowParameter();
                bill.setFormId("cal_costadjust_subentity");
                bill.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                bill.setPkId(costAdjustIds.get(0));
                bill.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)bill);
            } else {
                param = new ListShowParameter();
                param.setFormId("bos_list");
                param.setBillFormId("cal_costadjust_subentity");
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                param.getListFilterParameter().setFilter(new QFilter("id", "in", costAdjustIds));
                pageCache = this.getView().getPageCache();
                pageCache.put("adj_calorg", calOrg);
                pageCache.put("adj_costaccount", SerializationUtils.toJsonString(costAccountList));
                this.getView().showForm((FormShowParameter)param);
            }
        }
        if (!stdCostIds.isEmpty()) {
            if (stdCostIds.size() == 1) {
                bill = new BillShowParameter();
                bill.setFormId("cal_stdcostdiffbill");
                bill.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                bill.setPkId(stdCostIds.get(0));
                bill.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)bill);
            } else {
                param = new ListShowParameter();
                param.setFormId("bos_list");
                param.setBillFormId("cal_stdcostdiffbill");
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                param.getListFilterParameter().setFilter(new QFilter("id", "in", stdCostIds));
                pageCache = this.getView().getPageCache();
                pageCache.put("adj_calorg", calOrg);
                pageCache.put("adj_costaccount", SerializationUtils.toJsonString(costAccountList));
                this.getView().showForm((FormShowParameter)param);
            }
        }
    }

    private void showChargeOffBill(Long id, boolean isShowChargeOff) {
        String fitlerField = "id";
        String selectField = "entry.srcbillid";
        if (isShowChargeOff) {
            fitlerField = "entry.srcbillid";
            selectField = "id";
        }
        QFilter q = new QFilter(fitlerField, "=", (Object)id);
        q.and("ischargeoff", "=", (Object)Boolean.TRUE);
        HashSet<Long> chargeOffRecordSet = new HashSet<Long>(16);
        DynamicObjectCollection chargeOffRecordColl = QueryServiceHelper.query((String)"cal_costrecord", (String)selectField, (QFilter[])q.toArray());
        for (DynamicObject info : chargeOffRecordColl) {
            chargeOffRecordSet.add(info.getLong(selectField));
        }
        if (chargeOffRecordSet.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u8bb0\u5f55\u3002", (String)"CostRecordEditPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("cal_costrecord_subentity");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("id", "in", chargeOffRecordSet));
        showParameter.getListFilterParameter().setQFilters(qFilters);
        Iterator iterator = chargeOffRecordSet.iterator();
        while (iterator.hasNext()) {
            long billId = (Long)iterator.next();
            showParameter.addLinkQueryPkId((Object)billId);
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    protected void showCostEstimateRecord(Object pkValue) {
        DynamicObjectCollection records = QueryServiceHelper.query((String)"cal_costestimaterecord", (String)"id", (QFilter[])new QFilter("costdetail.parent.id", "=", pkValue).toArray());
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (DynamicObject info : records) {
            idSet.add(info.getLong("id"));
        }
        if (idSet.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u8bb0\u5f55\u3002", (String)"CostRecordEditPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter param = new ListShowParameter();
        param.setFormId("bos_list");
        param.setBillFormId("cal_costestimaterecord");
        param.getListFilterParameter().setFilter(new QFilter("id", "in", idSet));
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setCustomParam("costrecordid", pkValue);
        this.getView().showForm((FormShowParameter)param);
    }

    private void showFeeShareRecord(Object pkvalue) {
        HashSet<Long> calEntryIds = new HashSet<Long>(16);
        try (DataSet costRecordDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"entry.calentryid", (QFilter[])new QFilter("id", "=", pkvalue).toArray(), null).groupBy(new String[]{"entry.calentryid"}).finish();){
            for (Object row : costRecordDS) {
                calEntryIds.add(row.getLong("entry.calentryid"));
            }
        }
        HashSet<Long> recordIds = new HashSet<Long>(16);
        DataSet recordDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_feeshare_newrecord", (String)"id", (QFilter[])new QFilter("entry.calentryid", "in", calEntryIds).toArray(), null).groupBy(new String[]{"id"}).finish();
        Object object = null;
        try {
            for (Row row : recordDs) {
                recordIds.add(row.getLong("id"));
            }
        }
        catch (Throwable row) {
            object = row;
            throw row;
        }
        finally {
            if (recordDs != null) {
                if (object != null) {
                    try {
                        recordDs.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)object).addSuppressed(row);
                    }
                } else {
                    recordDs.close();
                }
            }
        }
        if (recordIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u8bb0\u5f55\u3002", (String)"CostRecordEditPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter param = new ListShowParameter();
        param.setFormId("bos_list");
        param.setBillFormId("cal_feeshare_newrecord");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        QFilter qFilter = new QFilter("id", "in", recordIds);
        qFilters.add(qFilter);
        param.getListFilterParameter().setQFilters(qFilters);
        for (Long id : recordIds) {
            param.addLinkQueryPkId((Object)id);
        }
        this.getView().showForm((FormShowParameter)param);
    }

    private void showFeeShareRecordDetail(Object pkvalue) {
        DynamicObjectCollection records = QueryServiceHelper.query((String)"cal_fee_sharedetail", (String)"id", (QFilter[])new QFilter("costrecordid", "=", pkvalue).toArray());
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (DynamicObject info : records) {
            idSet.add(info.getLong("id"));
        }
        if (idSet.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u8bb0\u5f55\u3002", (String)"CostRecordEditPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter param = new ListShowParameter();
        param.setFormId("bos_list");
        param.setBillFormId("cal_fee_sharedetail");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.getListFilterParameter().setFilter(new QFilter("id", "in", idSet));
        this.getView().showForm((FormShowParameter)param);
    }

    private void showBizBill(long bizBillId, String bizEntityObject) {
        BillShowParameter showParameter = new BillShowParameter();
        if (bizEntityObject == null || !QueryServiceHelper.exists((String)bizEntityObject, (Object)bizBillId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5173\u8054\u7684\u4e1a\u52a1\u5355\u636e\u3002", (String)"CostRecordEditPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        showParameter.setPkId((Object)bizBillId);
        showParameter.setFormId(bizEntityObject);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showWriteOffRecord(Set<Long> writeOffIds, String entityNum) {
        if (writeOffIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u8bb0\u5f55\u3002", (String)"CostRecordEditPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(entityNum);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("id", "in", writeOffIds));
        showParameter.getListFilterParameter().setQFilters(qFilters);
        for (long id : writeOffIds) {
            showParameter.addLinkQueryPkId((Object)id);
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

