/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.bill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterColumnSetFilterEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.calculate.out.calintime.CalInTimeRptLinkHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.MulSelectBasisHelper;
import kd.fi.cal.common.helper.ShowBizBillHelper;
import kd.fi.cal.common.helper.WriteOffServerHelper;
import kd.fi.cal.formplugin.base.CalOrgAcctLinkListPlugin;
import kd.fi.cal.formplugin.bill.costrecord.CostRecordPageFactory;
import kd.fi.cal.formplugin.bill.costrecord.ICostRecordPageHelper;

public class CostRecordListPlugin
extends CalOrgAcctLinkListPlugin
implements BeforeFilterF7SelectListener {
    private static final Log logger = LogFactory.getLog(CostRecordListPlugin.class);
    public ICostRecordPageHelper helper = null;
    private boolean isFirstInitFilterByMainPage = false;
    private boolean isfirstSetFilterByMainPage = false;
    private static final String QUERY_COSTESTIMATERECORD = "tbl_querycostestimaterecord";
    private static final String QUERY_QUERYFEESHARERECORD = "tbl_queryfeesharerecord";
    private static final String QUERY_QUERYFEESHARERECORDDETAIL = "tbl_queryfeesharerecorddetail";
    private static final String CREATE_VOUCHER = "1";
    private static final String DELETE_VOUCHER = "2";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_DEBUG_MODEL).booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_updatestocktype"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_updatestocktype"});
        }
    }

    public void initialize() {
        super.initialize();
        String pageType = (String)this.getView().getFormShowParameter().getCustomParam("pagetype");
        this.helper = CostRecordPageFactory.getPageHelper(pageType);
        if (this.helper.getCaption() != null) {
            this.getView().getFormShowParameter().setCaption(this.helper.getCaption());
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer filterContainer = (FilterContainer)this.getView().getControl("filtercontainerap");
        filterContainer.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
        this.addClickListeners(new String[]{"tblfixvoucher"});
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        super.beforeItemClick(e);
        String key = e.getItemKey();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] ids = selectedRows.getPrimaryKeyValues();
        if ("tbl_viewbizbill".equals(key)) {
            this.showBizBill(ids);
        } else if ("tbl_queryinwriteoffrecord".equals(key)) {
            String entityNum = "ap_verifyrecord";
            entityNum = WriteOffServerHelper.getNewRecordEntityNum((Long)0L, (String)entityNum);
            this.showWriteOffRecord(ids, entityNum);
        } else if ("tbl_queryoutwriteoffrecord".equals(key)) {
            String entityNum = "ar_verifyrecord";
            entityNum = WriteOffServerHelper.getNewRecordEntityNum((Long)0L, (String)entityNum);
            this.showWriteOffRecord(ids, entityNum);
        } else if (QUERY_COSTESTIMATERECORD.equals(key)) {
            this.showCostEstimateRecord(ids);
        } else if (QUERY_QUERYFEESHARERECORD.equals(key)) {
            this.showFeeShareRecord(ids);
        } else if (QUERY_QUERYFEESHARERECORDDETAIL.equals(key)) {
            this.showFeeShareRecordDetail(ids);
        } else if ("tblrefresh".equals(key)) {
            this.getPageCache().put("currentFilterOrgId", "");
        } else if ("tbl_querychargeoffbill".equals(key)) {
            this.showChargeOffBill(ids, true);
        } else if ("tbl_querychargeoffedbill".equals(key)) {
            this.showChargeOffBill(ids, false);
        } else if ("tbl_querycostadjust".equals(key)) {
            this.showCostAdjustBill(ids);
        }
    }

    private void showCostAdjustBill(Object[] ids) {
        IPageCache pageCache;
        ListShowParameter param;
        BillShowParameter bill;
        if (ids == null || ids.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CostRecordListPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter filter = new QFilter("entryentity.invbillid", "in", (Object)ids);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cal_costadjust_subentity", (String)"id,costaccount", (QFilter[])new QFilter[]{filter});
        DynamicObjectCollection stdCostObjs = QueryServiceHelper.query((String)"cal_stdcostdiffbill", (String)"id,costaccount", (QFilter[])new QFilter[]{filter});
        if (dynamicObjects.isEmpty() && stdCostObjs.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5173\u8054\u7684\u4e1a\u52a1\u5355\u636e\u3002", (String)"CostRecordListPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)"cal_costrecord", (String)"calorg", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
        Set calOrgs = query.stream().map(r -> r.getLong("calorg")).collect(Collectors.toSet());
        if (calOrgs.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8054\u67e5\u6210\u672c\u8c03\u6574\u5355\u65f6\u4ec5\u652f\u6301\u9009\u62e9\u540c\u4e00\u7ec4\u7ec7\u7684\u6570\u636e\u3002", (String)"CostRecordListPlugin_12", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        String calOrg = ((DynamicObject)query.get(0)).getString("calorg");
        HashSet<String> costAccountList = new HashSet<String>(16);
        ArrayList<Long> costAdjustIds = new ArrayList<Long>(16);
        HashSet<String> stdCostAccountList = new HashSet<String>(16);
        ArrayList<Long> stdCostIds = new ArrayList<Long>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            costAdjustIds.add(dynamicObject.getLong("id"));
            costAccountList.add(dynamicObject.getString("costaccount"));
        }
        for (DynamicObject stdCostObj : stdCostObjs) {
            stdCostIds.add(stdCostObj.getLong("id"));
            stdCostAccountList.add(stdCostObj.getString("costaccount"));
        }
        if (!costAdjustIds.isEmpty()) {
            if (costAdjustIds.size() == 1) {
                bill = new BillShowParameter();
                bill.setFormId("cal_costadjust_subentity");
                bill.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                bill.setPkId(costAdjustIds.get(0));
                bill.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)bill);
            } else {
                param = new ListShowParameter();
                param.setFormId("bos_list");
                param.setBillFormId("cal_costadjust_subentity");
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                param.getListFilterParameter().setFilter(new QFilter("id", "in", costAdjustIds));
                pageCache = this.getView().getPageCache();
                pageCache.put("adj_calorg", calOrg);
                pageCache.put("adj_costaccount", SerializationUtils.toJsonString(costAccountList));
                this.getView().showForm((FormShowParameter)param);
            }
        }
        if (!stdCostIds.isEmpty()) {
            if (stdCostIds.size() == 1) {
                bill = new BillShowParameter();
                bill.setFormId("cal_stdcostdiffbill");
                bill.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                bill.setPkId(stdCostIds.get(0));
                bill.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)bill);
            } else {
                param = new ListShowParameter();
                param.setFormId("bos_list");
                param.setBillFormId("cal_stdcostdiffbill");
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                param.getListFilterParameter().setFilter(new QFilter("id", "in", stdCostIds));
                pageCache = this.getView().getPageCache();
                pageCache.put("adj_calorg", calOrg);
                pageCache.put("adj_costaccount", SerializationUtils.toJsonString(stdCostAccountList));
                this.getView().showForm((FormShowParameter)param);
            }
        }
    }

    private void showChargeOffBill(Object[] ids, boolean isShowChargeOff) {
        Object info4;
        DynamicObject info2;
        Object chargeOffRecordColl;
        if (ids == null || ids.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CostRecordListPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> chargeOffRecordSet = new HashSet<Long>(16);
        QFilter q = new QFilter("id", "in", (Object)ids);
        q.and("issplitcreate", "=", (Object)Boolean.TRUE);
        HashSet<Long> childIds = new HashSet<Long>(16);
        DynamicObjectCollection billColl = QueryServiceHelper.query((String)"cal_costrecord", (String)"id", (QFilter[])q.toArray());
        for (DynamicObject info3 : billColl) {
            childIds.add(info3.getLong("id"));
        }
        if (!childIds.isEmpty()) {
            String fitlerField = "id";
            String selectField = "entry.srcbillid";
            if (isShowChargeOff) {
                fitlerField = "entry.srcbillid";
                selectField = "id";
            }
            q = new QFilter(fitlerField, "in", childIds);
            q.and("ischargeoff", "=", (Object)Boolean.TRUE);
            q.and("issplitcreate", "=", (Object)Boolean.TRUE);
            chargeOffRecordColl = QueryServiceHelper.query((String)"cal_costrecord", (String)selectField, (QFilter[])q.toArray());
            Iterator iterator = chargeOffRecordColl.iterator();
            while (iterator.hasNext()) {
                info2 = (DynamicObject)iterator.next();
                chargeOffRecordSet.add(info2.getLong(selectField));
            }
        }
        HashSet<Long> bizBillIds = new HashSet<Long>(ids.length);
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        if (isShowChargeOff) {
            q = new QFilter("id", "in", (Object)ids);
            q.and("issplitcreate", "=", (Object)Boolean.FALSE);
            billColl = QueryServiceHelper.query((String)"cal_costrecord", (String)"id,bizbillid,costaccount", (QFilter[])q.toArray());
            for (Object info4 : billColl) {
                bizBillIds.add(info4.getLong("bizbillid"));
                costAccountIds.add(info4.getLong("costaccount"));
            }
            if (!bizBillIds.isEmpty()) {
                q = new QFilter("entry.srcbillid", "in", bizBillIds);
                q.and("costaccount", "in", costAccountIds);
                q.and("ischargeoff", "=", (Object)Boolean.TRUE);
                q.and("issplitcreate", "=", (Object)Boolean.FALSE);
                chargeOffRecordColl = QueryServiceHelper.query((String)"cal_costrecord", (String)"id", (QFilter[])q.toArray());
                info4 = chargeOffRecordColl.iterator();
                while (info4.hasNext()) {
                    info2 = (DynamicObject)info4.next();
                    chargeOffRecordSet.add(info2.getLong("id"));
                }
            }
        } else {
            q = new QFilter("id", "in", (Object)ids);
            q.and("issplitcreate", "=", (Object)Boolean.FALSE);
            billColl = QueryServiceHelper.query((String)"cal_costrecord", (String)"id,entry.srcbillid,costaccount", (QFilter[])q.toArray());
            for (Object info4 : billColl) {
                bizBillIds.add(info4.getLong("entry.srcbillid"));
                costAccountIds.add(info4.getLong("costaccount"));
            }
            if (!bizBillIds.isEmpty()) {
                q = new QFilter("bizbillid", "in", bizBillIds);
                q.and("costaccount", "in", costAccountIds);
                q.and("ischargeoffed", "=", (Object)Boolean.TRUE);
                q.and("issplitcreate", "=", (Object)Boolean.FALSE);
                chargeOffRecordColl = QueryServiceHelper.query((String)"cal_costrecord", (String)"id", (QFilter[])q.toArray());
                info4 = chargeOffRecordColl.iterator();
                while (info4.hasNext()) {
                    info2 = (DynamicObject)info4.next();
                    chargeOffRecordSet.add(info2.getLong("id"));
                }
            }
        }
        if (chargeOffRecordSet.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u8bb0\u5f55\u3002", (String)"CostRecordEditPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("cal_costrecord_subentity");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("id", "in", chargeOffRecordSet));
        showParameter.getListFilterParameter().setQFilters(qFilters);
        Iterator iterator = chargeOffRecordSet.iterator();
        while (iterator.hasNext()) {
            long billId = (Long)iterator.next();
            showParameter.addLinkQueryPkId((Object)billId);
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void fixvoucher(AfterDoOperationEventArgs e) {
        boolean success = e.getOperationResult().isSuccess();
        if (!success) {
            return;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] ids = selectedRows.getPrimaryKeyValues();
        if (ids == null || ids.length == 0) {
            return;
        }
        HashMap<Long, HashSet<Long>> voucher2Record = new HashMap<Long, HashSet<Long>>(ids.length);
        HashSet<Long> hasVoucherRecord = new HashSet<Long>(ids.length);
        HashSet<Long> hasCalVoucherRecord = new HashSet<Long>(ids.length);
        DataSet dapDataSet = QueryServiceHelper.queryDataSet((String)CostRecordListPlugin.class.getName(), (String)"ai_daptracker", (String)"sourcebillid,voucherid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", (Object)ids)}, null);
        DataSet calvoucherDataSet = QueryServiceHelper.queryDataSet((String)CostRecordListPlugin.class.getName(), (String)"cal_voucher", (String)"costrecordid,voucherid", (QFilter[])new QFilter[]{new QFilter("costrecordid", "in", (Object)ids)}, null);
        for (Row row : calvoucherDataSet) {
            hasCalVoucherRecord.add(row.getLong("costrecordid"));
        }
        for (Row row : dapDataSet) {
            long sourcebillid = row.getLong("sourcebillid");
            hasVoucherRecord.add(sourcebillid);
            if (hasCalVoucherRecord.contains(sourcebillid)) continue;
            long voucherid = row.getLong("voucherid");
            HashSet<Long> recordIdSet = (HashSet<Long>)voucher2Record.get(voucherid);
            if (recordIdSet == null) {
                recordIdSet = new HashSet<Long>(16);
            }
            recordIdSet.add(sourcebillid);
            voucher2Record.put(voucherid, recordIdSet);
        }
        HashMap<Long, String> voucherMap = new HashMap<Long, String>(ids.length);
        DataSet voucherDataSet = QueryServiceHelper.queryDataSet((String)CostRecordListPlugin.class.getName(), (String)"gl_voucher", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", voucher2Record.keySet())}, null);
        for (Row row : voucherDataSet) {
            voucherMap.put(row.getLong("id"), row.getString("billno"));
        }
        logger.info("\u51ed\u8bc1id\uff1a" + voucher2Record.keySet() + "\u5f00\u59cb\u8c03\u7528\u5fae\u670d\u52a1VoucherWriteBackService.costRecordWriteBack,\u4fee\u590d\u751f\u6210\u51ed\u8bc1\u7684\u53cd\u5199");
        for (Map.Entry entry : voucher2Record.entrySet()) {
            Long voucherId = (Long)entry.getKey();
            try {
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"VoucherWriteBackService", (String)"costRecordWriteBack", (Object[])new Object[]{CREATE_VOUCHER, entry.getValue(), voucherId, voucherMap.get(voucherId)});
            }
            catch (Throwable ex) {
                logger.error("\u51ed\u8bc1id\uff1a" + voucherId + "\u8c03\u7528\u5fae\u670d\u52a1VoucherWriteBackService.costRecordWriteBack\u5f02\u5e38", ex);
            }
        }
        HashSet<Object> notHasVoucher = new HashSet<Object>(32);
        for (Object id : ids) {
            if (hasVoucherRecord.contains(id)) continue;
            notHasVoucher.add(id);
        }
        if (notHasVoucher.isEmpty()) {
            ((IListView)this.getView()).refresh();
            return;
        }
        HashMap<Long, HashSet<Long>> hashMap = new HashMap<Long, HashSet<Long>>(ids.length);
        DataSet recordDataSet = QueryServiceHelper.queryDataSet((String)CostRecordListPlugin.class.getName(), (String)"cal_costrecord_subentity", (String)"id,fivoucherid", (QFilter[])new QFilter[]{new QFilter("id", "in", notHasVoucher)}, null);
        for (Row row : recordDataSet) {
            long fivoucherid = row.getLong("fivoucherid");
            if (fivoucherid == 0L) continue;
            HashSet<Long> recordIdSet = (HashSet<Long>)hashMap.get(fivoucherid);
            if (recordIdSet == null) {
                recordIdSet = new HashSet<Long>(16);
            }
            recordIdSet.add(row.getLong("id"));
            hashMap.put(fivoucherid, recordIdSet);
        }
        logger.info("\u51ed\u8bc1id\uff1a" + hashMap.keySet() + "\u5f00\u59cb\u8c03\u7528\u5fae\u670d\u52a1VoucherWriteBackService.costRecordWriteBack,\u4fee\u590d\u5220\u9664\u51ed\u8bc1\u7684\u53cd\u5199");
        for (Map.Entry entry : hashMap.entrySet()) {
            Long voucherId = (Long)entry.getKey();
            try {
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"VoucherWriteBackService", (String)"costRecordWriteBack", (Object[])new Object[]{DELETE_VOUCHER, entry.getValue(), voucherId, " "});
            }
            catch (Throwable ex) {
                logger.error("\u51ed\u8bc1id\uff1a" + voucherId + "\u8c03\u7528\u5fae\u670d\u52a1VoucherWriteBackService.costRecordWriteBack\u5f02\u5e38", ex);
            }
        }
        ((IListView)this.getView()).refresh();
    }

    private void showBizBill(Object[] ids) {
        if (ids == null || ids.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CostRecordListPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"id,billnumber,bizbillid,billtype.billformid", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)}, null);){
            HashMap<String, Set> entity2idMap = new HashMap<String, Set>(16);
            HashMap<String, String> entityId2BillnoMap = new HashMap<String, String>(16);
            for (Row row : dataSet) {
                Object bizbillid = row.get("bizbillid");
                String entity = row.getString("billtype.billformid");
                String billnumber = row.getString("billnumber");
                Set bizbillids = entity2idMap.computeIfAbsent(entity, k -> new HashSet(16));
                bizbillids.add(bizbillid);
                entityId2BillnoMap.put(entity + "#" + bizbillid, billnumber);
            }
            ShowBizBillHelper.showForms(entity2idMap, (IFormView)this.getView(), entityId2BillnoMap);
        }
    }

    private void showWriteOffRecord(Object[] ids, String billName) {
        if (ids == null || ids.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CostRecordListPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> writeOffIds = new HashSet<Long>();
        QFilter filter = new QFilter("id", "in", (Object)ids);
        if ("ap_verifyrecord".equals(billName) || "cal_purwfrecord".equals(billName)) {
            filter.and("calbilltype", "=", (Object)"IN");
        } else if ("ar_verifyrecord".equals(billName) || "cal_salwfrecord".equals(billName)) {
            filter.and("calbilltype", "=", (Object)"OUT");
        }
        DynamicObjectCollection costRecordColl = QueryServiceHelper.query((String)"cal_costrecord", (String)"id,billno,issplitcreate,entry.writeoffid", (QFilter[])filter.toArray());
        if (costRecordColl.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u8bb0\u5f55\u3002", (String)"CostRecordEditPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> ancestorBillIdSet = new HashSet<Long>(costRecordColl.size());
        for (DynamicObject costRecordInfo : costRecordColl) {
            boolean isSplitCreate = costRecordInfo.getBoolean("issplitcreate");
            if (!isSplitCreate) {
                ancestorBillIdSet.add(costRecordInfo.getLong("id"));
                continue;
            }
            long writeoffId = costRecordInfo.getLong("entry.writeoffid");
            if (writeoffId == 0L) continue;
            writeOffIds.add(writeoffId);
        }
        if (!ancestorBillIdSet.isEmpty()) {
            QFilter q = new QFilter("entry.ancestorbillid", "in", ancestorBillIdSet);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"entry.writeoffid", (QFilter[])new QFilter[]{q}, null);){
                for (Row row : dataSet) {
                    long writeOffId = row.getLong("entry.writeoffid");
                    if (writeOffId == 0L) continue;
                    writeOffIds.add(writeOffId);
                }
            }
        }
        if (writeOffIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u8bb0\u5f55\u3002", (String)"CostRecordEditPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(billName);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("id", "in", writeOffIds));
        showParameter.getListFilterParameter().setQFilters(qFilters);
        Iterator iterator = writeOffIds.iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            showParameter.addLinkQueryPkId((Object)id);
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    @Override
    public void filterColumnSetFilter(SetFilterEvent e) {
        if ("calorg.name".equals(e.getFieldName())) {
            e.addCustomQFilter(this.getCalOrgFilter());
        }
        if ("costaccount.name".equals(e.getFieldName())) {
            String calorgId;
            e.addCustomQFilter(this.getCostAccountFilter());
            FilterColumnSetFilterEvent orgArgs = (FilterColumnSetFilterEvent)e;
            List calorgFilterValue = orgArgs.getCommonFilterValue("calorg.name");
            if (calorgFilterValue != null && calorgFilterValue.size() > 0 && StringUtils.isNotBlank((CharSequence)(calorgId = String.valueOf(calorgFilterValue.get(0))))) {
                e.addCustomQFilter(new QFilter("calorg", "=", (Object)Long.valueOf(calorgId)));
            }
        }
        super.filterColumnSetFilter(e);
    }

    @Override
    public String getCostAcctFilterName() {
        return "costaccount.name";
    }

    @Override
    public String getOrgFilterName() {
        String mainOrg = EntityMetadataCache.getDataEntityType((String)((ListView)this.getView()).getBillFormId()).getMainOrg();
        return mainOrg + ".name";
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        if ("costaccount.name".equals(e.getFieldName()) || "costaccount.number".equals(e.getFieldName()) || "costaccount.id".equals(e.getFieldName())) {
            e.addCustomQFilter(this.getCostAccountFilter());
        }
        if ("calorg.name".equals(e.getFieldName()) || "calorg.number".equals(e.getFieldName()) || "calorg.id".equals(e.getFieldName())) {
            e.addCustomQFilter(this.getCalOrgFilter());
        }
        if ("material.number".equals(e.getFieldName()) || "material.name".equals(e.getFieldName())) {
            this.getModel().getDataEntityType().setMainOrg("calorg");
            e.addCustomQFilter(MulSelectBasisHelper.auditFilter());
        }
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map map = args.getSearchClickEvent().getCurrentCommonFilter();
        if (map == null) {
            return;
        }
        List names = (List)map.get("FieldName");
        if ("costaccount.id".equals(String.valueOf(names.get(0)))) {
            List vals = (List)map.get("Value");
            logger.info("filterContainerSearchClick\u2014>vals:" + vals);
            if (vals == null || vals.size() < 1) {
                return;
            }
            this.getPageCache().put("costAccountId", SerializationUtils.toJsonString((Object)vals));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs e) {
        super.billListHyperLinkClick(e);
        String fieldName = e.getFieldName();
        if ("ecalstatus".equals(fieldName) || "calstatus".equals(fieldName)) {
            CalInTimeRptLinkHelper calInTimeRptLinkHelper = new CalInTimeRptLinkHelper(this.getView());
            calInTimeRptLinkHelper.link("cal_costrecord", e);
            return;
        }
    }

    private QFilter getCostAccountFilter() {
        List<Long> list = this.helper.getAllPermOrgs();
        QFilter q = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        if (list != null) {
            q = new QFilter("calorg", "in", list);
        }
        return q;
    }

    private QFilter getCalOrgFilter() {
        List<Long> list = this.helper.getAllPermOrgs();
        QFilter q = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        if (list != null) {
            q = new QFilter("id", "in", list);
        }
        return q;
    }

    public void setFilter(SetFilterEvent e) {
        FormShowParameter formShowParameter;
        Map paramMap;
        String orderModel = CalDbParamServiceHelper.getString((String)CalDbParamConstant.COSTRECORDLIST_ORDER_MODEL, null);
        if ("A".equals(orderModel)) {
            e.setOrderBy("id desc");
        }
        if ((paramMap = (formShowParameter = this.getView().getFormShowParameter()).getCustomParams()).get("voucherFilter") != null && this.isfirstSetFilterByMainPage) {
            e.getQFilters().clear();
            e.getQFilters().add(QFilter.of((String)((String)paramMap.get("voucherFilter")), (Object[])new Object[0]));
            return;
        }
        if (this.isMatchCondition(paramMap) && this.isfirstSetFilterByMainPage) {
            String filterStr = (String)paramMap.get("filter");
            if (StringUtils.isNotBlank((CharSequence)filterStr)) {
                QFilter filter = QFilter.fromSerializedString((String)filterStr);
                e.getQFilters().clear();
                e.getQFilters().add(filter);
            }
            this.isfirstSetFilterByMainPage = false;
            return;
        }
        if (this.helper.getClass().getName().equals("kd.fi.cal.formplugin.bill.costrecord.CommonCostRecordPageHelper")) {
            return;
        }
        ArrayList<Long> costAccountlist = new ArrayList<Long>();
        List list = e.getQFilters();
        for (Object q : list) {
            if (q.getProperty().equals("costaccount.id")) {
                if (q.getValue() instanceof Long) {
                    costAccountlist.add((Long)q.getValue());
                    continue;
                }
                if (!(q.getValue() instanceof List)) continue;
                costAccountlist.addAll((List)q.getValue());
                continue;
            }
            if (!q.getProperty().equals("costaccount.name") && !q.getProperty().equals("costaccount.number")) continue;
            String colName = "name";
            if (q.getProperty().equals("costaccount.number")) {
                colName = "number";
            }
            DynamicObjectCollection coll = null;
            if (q.getValue() instanceof String) {
                coll = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id", (QFilter[])new QFilter[]{new QFilter(colName, "=", q.getValue())});
            } else if (q.getValue() instanceof List) {
                coll = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id", (QFilter[])new QFilter[]{new QFilter(colName, "in", q.getValue())});
            }
            if (coll == null) continue;
            for (DynamicObject info : coll) {
                if (costAccountlist.contains(info.getLong("id"))) continue;
                costAccountlist.add(info.getLong("id"));
            }
        }
        if (costAccountlist.isEmpty()) {
            Map costAccountMap = BusinessDataServiceHelper.loadFromCache((String)"cal_bd_costaccount", (String)"id", (QFilter[])this.getCostAccountFilter().toArray());
            for (DynamicObject costAccount : costAccountMap.values()) {
                costAccountlist.add(costAccount.getLong("id"));
            }
        }
        QFilter defaultListFilter = this.helper.getDefaultListFilter(costAccountlist);
        String pageType = (String)this.getView().getFormShowParameter().getCustomParam("pagetype");
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        if (StringUtils.isNotEmpty((CharSequence)pageType)) {
            defaultListFilter.and(billStatusf);
        }
        e.addCustomQFilter(defaultListFilter);
    }

    private boolean isMatchCondition(Map<String, Object> paramMap) {
        boolean flag = false;
        String key = (String)paramMap.get("source");
        if ("CalHandleExpCostPlugin".equals(key) || "CalHandleCertificatePlugin".equals(key) || "QueryVoucherItemTask".equals(key)) {
            flag = true;
        }
        return flag;
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, this.helper.getHideButtonNames());
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs e) {
        List list = e.getListColumns();
        String[] hideCols = this.helper.getHideColNames();
        ArrayList<String> hideColList = new ArrayList<String>(Arrays.asList(hideCols));
        for (int i = list.size() - 1; i >= 0; --i) {
            IListColumn col = (IListColumn)list.get(i);
            if (!hideColList.contains(col.getListFieldKey())) continue;
            col.setVisible(0);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.isFirstInitFilterByMainPage = true;
        this.isfirstSetFilterByMainPage = true;
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        if (this.isMatchCondition(paramMap) && this.isFirstInitFilterByMainPage) {
            this.mainPageFilterInit(filterColumns, paramMap);
            this.isFirstInitFilterByMainPage = false;
        } else {
            for (int i = filterColumns.size() - 1; i >= 0; --i) {
                FilterColumn filterColumn = (FilterColumn)filterColumns.get(i);
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                if (!commonFilterColumn.getFieldName().equals("billstatus") || this.helper.getClass().getName().equals("kd.fi.cal.formplugin.bill.costrecord.CommonCostRecordPageHelper")) continue;
                filterColumns.remove(i);
            }
        }
    }

    private void mainPageFilterInit(List<FilterColumn> filterColumns, Map<String, Object> paramMap) {
        for (int i = filterColumns.size() - 1; i >= 0; --i) {
            FilterColumn filterColumn = filterColumns.get(i);
            CommonFilterColumn schemeFilterColumn = (CommonFilterColumn)filterColumn;
            String schemeFilterColumnName = schemeFilterColumn.getFieldName();
            if ("costaccount.name".equals(schemeFilterColumnName)) {
                schemeFilterColumn.setDefaultValue(paramMap.get("costaccount").toString());
                continue;
            }
            if ("calorg.name".equals(schemeFilterColumnName)) {
                schemeFilterColumn.setDefaultValue(paramMap.get("calorg").toString());
                continue;
            }
            schemeFilterColumn.setDefaultValue(null);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key = e.getOperateKey();
        if ("deletefivoucher".equals(key) || "deletetempvoucher".equals(key) || "deletedischargevoucher".equals(key) || "delcarryovervoucher".equals(key) || "delfeevoucher".equals(key)) {
            ((IListView)this.getView()).refresh();
        } else if ("fixisvoucher".equals(key)) {
            this.fixvoucher(e);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs e) {
        e.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public boolean isOnlyPK4SelectedAllRows() {
                return true;
            }
        });
    }

    protected void showCostEstimateRecord(Object[] ids) {
        if (ids == null || ids.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CostRecordListPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        if (ids.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u53ea\u9009\u62e9\u4e00\u6761\u6210\u672c\u8bb0\u5f55\u67e5\u770b\u6682\u4f30\u660e\u7ec6\u3002", (String)"CostRecordListPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection records = QueryServiceHelper.query((String)"cal_costestimaterecord", (String)"id", (QFilter[])new QFilter("costdetail.parent.id", "=", ids[0]).toArray());
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (DynamicObject info : records) {
            idSet.add(info.getLong("id"));
        }
        if (idSet.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u8bb0\u5f55\u3002", (String)"CostRecordEditPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter param = new ListShowParameter();
        param.setFormId("bos_list");
        param.setBillFormId("cal_costestimaterecord");
        param.getListFilterParameter().setFilter(new QFilter("id", "in", idSet));
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setCustomParam("costrecordid", ids[0]);
        this.getView().showForm((FormShowParameter)param);
    }

    private void showFeeShareRecord(Object[] ids) {
        if (ids == null || ids.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CostRecordListPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        if (ids.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u53ea\u9009\u62e9\u4e00\u6761\u6210\u672c\u8bb0\u5f55\u67e5\u770b\u8d39\u7528\u5206\u644a\u8bb0\u5f55\u3002", (String)"CostRecordListPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> calEntryIds = new HashSet<Long>(16);
        try (DataSet costRecordDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"entry.calentryid", (QFilter[])new QFilter("id", "in", (Object)ids).toArray(), null).groupBy(new String[]{"entry.calentryid"}).finish();){
            for (Object row : costRecordDS) {
                calEntryIds.add(row.getLong("entry.calentryid"));
            }
        }
        HashSet<Long> recordIds = new HashSet<Long>(16);
        DataSet recordDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_feeshare_newrecord", (String)"id", (QFilter[])new QFilter("entry.calentryid", "in", calEntryIds).toArray(), null).groupBy(new String[]{"id"}).finish();
        Object object = null;
        try {
            for (Row row : recordDs) {
                recordIds.add(row.getLong("id"));
            }
        }
        catch (Throwable row) {
            object = row;
            throw row;
        }
        finally {
            if (recordDs != null) {
                if (object != null) {
                    try {
                        recordDs.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)object).addSuppressed(row);
                    }
                } else {
                    recordDs.close();
                }
            }
        }
        if (recordIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u8bb0\u5f55\u3002", (String)"CostRecordEditPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter param = new ListShowParameter();
        param.setFormId("bos_list");
        param.setBillFormId("cal_feeshare_newrecord");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        QFilter qFilter = new QFilter("id", "in", recordIds);
        qFilters.add(qFilter);
        param.getListFilterParameter().setQFilters(qFilters);
        for (Long id : recordIds) {
            param.addLinkQueryPkId((Object)id);
        }
        this.getView().showForm((FormShowParameter)param);
    }

    private void showFeeShareRecordDetail(Object[] ids) {
        if (ids == null || ids.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CostRecordListPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        if (ids.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u53ea\u9009\u62e9\u4e00\u6761\u6210\u672c\u8bb0\u5f55\u67e5\u770b\u8d39\u7528\u5206\u644a\u8bb0\u5f55\u3002", (String)"CostRecordListPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection records = QueryServiceHelper.query((String)"cal_fee_sharedetail", (String)"id", (QFilter[])new QFilter("costrecordid", "=", ids[0]).toArray());
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (DynamicObject info : records) {
            idSet.add(info.getLong("id"));
        }
        if (idSet.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u8bb0\u5f55\u3002", (String)"CostRecordEditPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter param = new ListShowParameter();
        param.setFormId("bos_list");
        param.setBillFormId("cal_fee_sharedetail");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.getListFilterParameter().setFilter(new QFilter("id", "in", idSet));
        this.getView().showForm((FormShowParameter)param);
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent arg0) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        if ("generatevoucher".equals(key) || "generatetempvoucher".equals(key) || "generatedischargevoucher".equals(key) || "generatecarryovervoucher".equals(key) || "generatefeevoucher".equals(key)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.isEmpty()) {
                return;
            }
            Object[] ids = selectedRows.getPrimaryKeyValues();
            HashSet<Long> costAccountIdSet = new HashSet<Long>(16);
            this.doValidate(ids, costAccountIdSet);
        }
    }

    private void doValidate(Object[] ids, Set<Long> costAccountIdSet) {
        String selectedFields = "id,costaccount,issplitcreate,isinitbill,bizbillid,calbillid";
        DynamicObjectCollection costRecords = QueryServiceHelper.query((String)"cal_costrecord", (String)selectedFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
        HashSet<Long> bizBillIdSet = new HashSet<Long>(costRecords.size());
        HashSet<Long> calBillIdSet = new HashSet<Long>(costRecords.size());
        HashSet<Long> recordIdSet = new HashSet<Long>(costRecords.size());
        for (DynamicObject costRecord : costRecords) {
            costAccountIdSet.add(costRecord.getLong("costaccount"));
            if (costRecord.getBoolean("issplitcreate")) continue;
            bizBillIdSet.add(costRecord.getLong("bizbillid"));
            calBillIdSet.add(costRecord.getLong("calbillid"));
            recordIdSet.add(costRecord.getLong("id"));
        }
        StringBuilder errSb = new StringBuilder();
        if (!bizBillIdSet.isEmpty()) {
            QFilter q1 = new QFilter("id", "in", recordIdSet);
            QFilter q = new QFilter("bizbillid", "in", bizBillIdSet);
            q.and("costaccount", "in", costAccountIdSet);
            q.and("calbillid", "not in", calBillIdSet);
            q.and("issplitcreate", "=", (Object)Boolean.FALSE);
            try (DataSet costRecordDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"id,bizbillid,costaccount", (QFilter[])q1.toArray(), null);
                 DataSet groupDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"id,bizbillid,billno,costaccount", (QFilter[])q.toArray(), null);
                 DataSet dataSet = costRecordDataSet.join(groupDataSet).on("bizbillid", "bizbillid").on("costaccount", "costaccount").select(new String[]{"id"}, new String[]{"billno"}).finish();){
                String comma = "\uff0c";
                for (Row row : dataSet) {
                    errSb.append(row.getString("billno")).append(comma);
                }
            }
        }
        if (errSb.length() > 0) {
            String content = String.format(ResManager.loadKDString((String)"\u5982\u4e0b\u7684\u5355\u53f7\u5b58\u5728\u6210\u7ec4\u7684\u5355\u636e\u672a\u52fe\u9009\uff1a%1$s", (String)"CostRecordListPlugin_11", (String)"fi-cal-formplugin", (Object[])new Object[0]), errSb.substring(0, errSb.length() - 1));
            throw new KDBizException(content);
        }
    }
}

