/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.bill;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.formplugin.base.CalOrgAcctLinkListPlugin;

public class CostUpdateApplyBillListPlugin
extends CalOrgAcctLinkListPlugin
implements BeforeFilterF7SelectListener {
    private static final Log logger = LogFactory.getLog(CostUpdateApplyBillListPlugin.class);

    public void beforeF7Select(BeforeFilterF7SelectEvent paramBeforeFilterF7SelectEvent) {
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"_toolbar_"});
        FilterContainer filterContainer = (FilterContainer)this.getView().getControl("filtercontainerap");
        filterContainer.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
        super.registerListener(e);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] ids = selectedRows.getPrimaryKeyValues();
        if ("bar_prevquery".equals(key)) {
            if (ids == null || ids.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CostUpdateApplyBillListPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                return;
            }
            this.queryPrevBill(ids);
        } else if ("bar_followquery".equals(key)) {
            if (ids == null || ids.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CostUpdateApplyBillListPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                return;
            }
            this.queryFollowBill(ids);
        }
    }

    @Override
    public String getOrgFilterName() {
        return "calorg.name";
    }

    @Override
    public String getCostAcctFilterName() {
        return "costaccount.name";
    }

    private void queryFollowBill(Object[] ids) {
        QFilter q = new QFilter("entryentity.invbizentityobject", "=", (Object)"cal_costupdateapplybill");
        q.and("entryentity.invbillid", "=", ids[0]);
        String dataEntityTypeName = "cal_costadjust_subentity";
        DynamicObject billInfo = QueryServiceHelper.queryOne((String)"cal_costadjust_subentity", (String)"id", (QFilter[])q.toArray());
        if (null == billInfo) {
            billInfo = QueryServiceHelper.queryOne((String)"cal_stdcostdiffbill", (String)"id", (QFilter[])q.toArray());
            dataEntityTypeName = "cal_stdcostdiffbill";
        }
        if (billInfo == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u6210\u672c\u8c03\u6574\u5355\u6216\u8005\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u3002", (String)"CostUpdateApplyBillListPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        } else {
            Object id = billInfo.get("id");
            this.showBill4CostAdjustBill(dataEntityTypeName, id);
        }
    }

    private void showBill4CostAdjustBill(String billentity, Object id) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setPkId(id);
        showParameter.setFormId(billentity);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void queryPrevBill(Object[] ids) {
        DynamicObject applyBillInfo = BusinessDataServiceHelper.loadSingle((Object)ids[0], (String)"cal_costupdateapplybill", (String)"id,calorg,costaccount,bookdate,srcbillentity,srcbillid");
        if (applyBillInfo != null) {
            String srcbillentity = applyBillInfo.getString("srcbillentity");
            Long srcbillid = applyBillInfo.getLong("srcbillid");
            if (StringUtils.isNotEmpty((String)srcbillentity) && srcbillid != 0L && srcbillid != null) {
                Long calorgid = applyBillInfo.getLong("calorg.id");
                Long costaccountid = applyBillInfo.getLong("costaccount.id");
                Date bookdate = applyBillInfo.getDate("bookdate");
                DynamicObject period = PeriodHelper.getPeriodByDate((Date)bookdate, (Long)costaccountid);
                Long periodid = period.getLong("id");
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                map.put("org", calorgid);
                map.put("costaccount", costaccountid);
                map.put("startperiod", periodid);
                map.put("endperiod", periodid);
                map.put("mulupdatebillno", srcbillid.toString());
                logger.info("\u8054\u67e5\u6210\u672c\u62a5\u8868\u53c2\u6570" + map);
                ReportShowParameter showParameter = new ReportShowParameter();
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setFormId("cad_storageinforpt");
                showParameter.setCustomParam("parammap", map);
                showParameter.setCustomParam("source", (Object)"HyperLink");
                showParameter.setHasRight(true);
                this.getView().showForm((FormShowParameter)showParameter);
                return;
            }
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u6765\u6e90\u5355\u636e\u3002", (String)"CostUpdateApplyBillPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]));
    }
}

