/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.bill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.balance.BalanceUncompressHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PermissionHelper;

public class CostUpdateApplyBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(CostUpdateApplyBillPlugin.class);
    private static final String BTN_QUERYBALANCE = "querybalance";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private boolean isNewBalance = CalBalanceModelHelper.isNewBalance();

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        String bizEntityObject = (String)this.getModel().getValue("srcbillentity");
        Long srcbillid = (Long)this.getModel().getValue("srcbillid");
        Long id = (Long)this.getModel().getValue("id");
        if ("batchdelrow".equals(key)) {
            this.autoDeleteRow();
        } else if (BTN_QUERYBALANCE.equals(key)) {
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(KEY_ENTRYENTITY);
            int[] selectRowIndex = grid.getEntryState().getSelectedRows();
            this.queryBalance(selectRowIndex);
        } else {
            if ("bar_prevquery".equals(key)) {
                DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
                DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
                Date bookdate = (Date)this.getModel().getValue("bookdate");
                if (StringUtils.isNotEmpty((String)bizEntityObject) && srcbillid != 0L && srcbillid != null && calOrg != null && costAccount != null && bookdate != null) {
                    Long calorgid = calOrg.getLong("id");
                    Long costaccountid = costAccount.getLong("id");
                    DynamicObject period = PeriodHelper.getPeriodByDate((Date)bookdate, (Long)costaccountid);
                    Long periodid = period.getLong("id");
                    HashMap<String, Object> map = new HashMap<String, Object>(16);
                    map.put("org", calorgid);
                    map.put("costaccount", costaccountid);
                    map.put("startperiod", periodid);
                    map.put("endperiod", periodid);
                    map.put("mulupdatebillno", srcbillid.toString());
                    logger.info("\u8054\u67e5\u6210\u672c\u62a5\u8868\u53c2\u6570" + map);
                    ReportShowParameter showParameter = new ReportShowParameter();
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    showParameter.setFormId("cad_storageinforpt");
                    showParameter.setCustomParam("parammap", map);
                    showParameter.setCustomParam("source", (Object)"HyperLink");
                    showParameter.setHasRight(true);
                    this.getView().showForm((FormShowParameter)showParameter);
                    return;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u6765\u6e90\u5355\u636e\u3002", (String)"CostUpdateApplyBillPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                return;
            }
            if ("bar_followquery".equals(key)) {
                if (id == null || id == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u6210\u672c\u8c03\u6574\u5355\u6216\u8005\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u3002", (String)"CostUpdateApplyBillListPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.queryFollowBill(id);
            }
        }
        super.itemClick(evt);
    }

    private void queryFollowBill(Object id) {
        QFilter q = new QFilter("entryentity.invbizentityobject", "=", (Object)"cal_costupdateapplybill");
        q.and("entryentity.invbillid", "=", id);
        String dataEntityTypeName = "cal_costadjust_subentity";
        DynamicObject billInfo = QueryServiceHelper.queryOne((String)"cal_costadjust_subentity", (String)"id", (QFilter[])q.toArray());
        if (null == billInfo) {
            billInfo = QueryServiceHelper.queryOne((String)"cal_stdcostdiffbill", (String)"id", (QFilter[])q.toArray());
            dataEntityTypeName = "cal_stdcostdiffbill";
        }
        if (billInfo == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u6210\u672c\u8c03\u6574\u5355\u6216\u8005\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u3002", (String)"CostUpdateApplyBillListPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        } else {
            Object billid = billInfo.get("id");
            this.showBill4ApplyBill(dataEntityTypeName, billid);
        }
    }

    private void showBill4ApplyBill(String billentity, Object id) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setPkId(id);
        showParameter.setFormId(billentity);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void queryBalance(int[] selectRowIndex) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (calOrg == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostUpdateApplyBillPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        if (costAccount == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostUpdateApplyBillPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        HashSet<String> materialIds = new HashSet<String>(16);
        for (int i : selectRowIndex) {
            DynamicObject material = (DynamicObject)this.getModel().getValue("material", i);
            if (material == null) continue;
            materialIds.add(material.getString("id"));
        }
        String materialIdsStr = materialIds.isEmpty() ? "" : String.join((CharSequence)",", materialIds);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cal_querybalance");
        showParameter.getCustomParams().put("calorg", calOrg.getPkValue());
        showParameter.getCustomParams().put("costaccount", costAccount.getPkValue());
        showParameter.getCustomParams().put("material", materialIdsStr);
        showParameter.getCustomParams().put("rowindex", rowIndex);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, BTN_QUERYBALANCE);
        showParameter.setCloseCallBack(callBack);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String sourceFldKey = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null && BTN_QUERYBALANCE.equals(sourceFldKey)) {
            Map resultMap = (Map)returnData;
            try (AlgoContext context = Algo.newContext();){
                this.insertRows2Entry(resultMap);
            }
        }
    }

    private void insertRows2Entry(Map<String, Set<Long>> resultMap) {
        Set<Long> balanceIds = resultMap.get("balanceid");
        Set<Long> balDetailIds = resultMap.get("baldetailid");
        Set<Long> currentBalDetailIds = this.getIncrementRows();
        if (!currentBalDetailIds.isEmpty()) {
            if (this.isNewBalance) {
                balDetailIds.removeAll(currentBalDetailIds);
            } else {
                balanceIds.removeAll(currentBalDetailIds);
            }
        }
        Set dimField = CalBalanceModelHelper.getDimField();
        DataSet balDetailDataSet = this.getBalDetailDataSet(balanceIds, balDetailIds, dimField);
        this.batchInsertRows(balDetailDataSet, dimField);
    }

    private void batchInsertRows(DataSet balDetailDataSet, Set<String> dim) {
        HashSet<String> dimField = new HashSet<String>();
        dimField.addAll(dim);
        dimField.add("baldetailid");
        dimField.add("costelement");
        dimField.add("costsubelement");
        dimField.add("baseunit");
        dimField.add("baseqty");
        dimField.add("unitcost");
        dimField.add("cost");
        dimField.add("costdiff");
        String[] dimFields = dimField.toArray(new String[0]);
        int size = dimFields.length;
        int amtPrecision = 10;
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (currency != null) {
            amtPrecision = currency.getInt("amtprecision");
        }
        DynamicObjectCollection entry = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        int entrySize = entry.size();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (String string : dimFields) {
            vs.addField(string, new Object[0]);
        }
        boolean hasNullRow = true;
        for (Row row : balDetailDataSet) {
            boolean needAdd = true;
            if (hasNullRow) {
                hasNullRow = false;
                for (int i = 0; i < entrySize; ++i) {
                    Long balDetailid = (Long)model.getValue("baldetailid", i);
                    if (balDetailid != null && balDetailid != 0L) continue;
                    hasNullRow = true;
                    DynamicObject material = (DynamicObject)model.getValue("material", i);
                    if (material != null && !material.getPkValue().toString().equals(row.getString("material"))) continue;
                    needAdd = false;
                    model.setValue("ownertype", row.get("ownertype"), i);
                    for (String dimName : dimField) {
                        if ("cost".equals(dimName) || "costdiff".equals(dimName)) {
                            BigDecimal amt = row.getBigDecimal(dimName).setScale(amtPrecision, RoundingMode.HALF_UP);
                            model.setValue(dimName, (Object)amt, i);
                            continue;
                        }
                        model.setValue(dimName, row.get(dimName), i);
                    }
                    break;
                }
            }
            if (!needAdd) continue;
            Object[] values = new Object[size];
            for (int i = 0; i < size; ++i) {
                if ("cost".equals(dimFields[i]) || "costdiff".equals(dimFields[i])) {
                    BigDecimal amt = row.getBigDecimal(dimFields[i]).setScale(amtPrecision, RoundingMode.HALF_UP);
                    values[i] = amt;
                    continue;
                }
                values[i] = row.get(dimFields[i]);
            }
            vs.addRow(values);
        }
        int rowCount = vs.getCount();
        if (rowCount != 0) {
            model.batchCreateNewEntryRow(KEY_ENTRYENTITY, vs);
        }
        model.endInit();
        this.getView().updateView(KEY_ENTRYENTITY);
    }

    private DataSet getBalDetailDataSet(Set<Long> balanceIds, Set<Long> balDetailIds, Set<String> dim) {
        HashSet<String> dimField = new HashSet<String>();
        dimField.addAll(dim);
        DataSet balanceDataSet = null;
        if (this.isNewBalance) {
            QFilter qBal = new QFilter("id", "in", balanceIds);
            boolean balCompress = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
            if (!balCompress) {
                balanceDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_bal", (String)("id as baldetailid,baseqty_bal as baseqty,baseunit,costelement,costsubelement,actualcost_bal as cost,actualcost_bal/baseqty_bal as unitcost, actualcost_bal as costdiff," + String.join((CharSequence)",", dimField)), (QFilter[])qBal.toArray(), null);
            } else {
                String selectFields = "id as baldetailid,baseqty_bal as baseqty,baseunit,costelement,costsubelement,actualcost_bal as cost,actualcost_bal/baseqty_bal as unitcost, actualcost_bal as costdiff," + String.join((CharSequence)",", dimField);
                ArrayList<QFilter> ql = new ArrayList<QFilter>();
                ql.add(qBal);
                balanceDataSet = BalanceUncompressHelper.getBalancDataSetDetail((boolean)false, (boolean)false, null, ql).select(selectFields);
            }
        } else {
            QFilter qBal = new QFilter("id", "in", balanceIds);
            balanceDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_balance", (String)("id as balanceid,periodendqty as baseqty,baseunit," + String.join((CharSequence)",", dimField)), (QFilter[])qBal.toArray(), null);
            QFilter qd = new QFilter("id", "in", balDetailIds);
            DataSet detailDataset = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_balance_detail", (String)"id as baldetailid,balid,costelement,costsubelement,case when periodendactualcost == null then 0 else periodendactualcost end as cost", (QFilter[])qd.toArray(), null);
            dimField.add("baseqty");
            dimField.add("baseunit");
            balanceDataSet = balanceDataSet.join(detailDataset, JoinType.INNER).on("balanceid", "balid").select(dimField.toArray(new String[dimField.size()]), "baldetailid,costelement,costsubelement,cost".split(",")).finish().select(String.join((CharSequence)",", dimField) + ",baldetailid,costelement,costsubelement,cost,cost/baseqty as unitcost,cost as costdiff");
        }
        return balanceDataSet;
    }

    private Set<Long> getIncrementRows() {
        DynamicObjectCollection entry = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        HashSet<Long> currBalDetailIds = new HashSet<Long>(entry.size());
        for (DynamicObject dynamicObject : entry) {
            Long baldetailid = dynamicObject.getLong("baldetailid");
            if (baldetailid == null || baldetailid == 0L) continue;
            currBalDetailIds.add(baldetailid);
        }
        return currBalDetailIds;
    }

    private void autoDeleteRow() {
        int rows = this.getModel().getEntryRowCount(KEY_ENTRYENTITY);
        HashSet<Integer> delRows = new HashSet<Integer>();
        for (int i = 0; i < rows; ++i) {
            BigDecimal newcost = (BigDecimal)this.getModel().getValue("newcost", i);
            if (newcost != null && newcost.compareTo(BigDecimal.ZERO) != 0) continue;
            delRows.add(i);
        }
        if (!delRows.isEmpty()) {
            int size = delRows.size();
            int[] temp = new int[size];
            int i = 0;
            Iterator iterator = delRows.iterator();
            while (iterator.hasNext()) {
                int rowIndex = (Integer)iterator.next();
                temp[i++] = rowIndex;
            }
            this.getModel().deleteEntryRows(KEY_ENTRYENTITY, temp);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("calorg".equals(key)) {
            this.beforeF7Select4Calorg(e);
        } else if ("costaccount".equals(key)) {
            this.beforeF7Select4Costaccount(e);
        } else if ("material".equals(key)) {
            this.beforeF7Select4Material(e);
        } else if ("configuredcode".equals(key)) {
            this.beforF7SelectConfigureCode(e);
        }
    }

    private void beforF7SelectConfigureCode(BeforeF7SelectEvent e) {
        DynamicObject material = (DynamicObject)this.getModel().getValue("material", e.getRow());
        if (material == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u3002", (String)"CostAdjustBillPlugin_5", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        Long materialId = material.getLong("id");
        QFilter matFilter = new QFilter("material", "=", (Object)materialId);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(matFilter);
    }

    private void beforeF7Select4Material(BeforeF7SelectEvent e) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostUpdateApplyBillPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }

    private void beforeF7Select4Costaccount(BeforeF7SelectEvent e) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrg == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostUpdateApplyBillPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        q = new QFilter("calorg", "=", calOrg.getPkValue());
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Calorg(BeforeF7SelectEvent e) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_costupdateapplybill", (String)"47156aff000000ac");
        if (list != null) {
            QFilter q = new QFilter("id", "in", (Object)list);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Date sysDate = new Date();
        this.getModel().setValue("bizdate", (Object)sysDate);
        this.getModel().setValue("bookdate", (Object)sysDate);
        this.getModel().setValue("srcsys", (Object)"A");
        this.getModel().setValue("sumtype", (Object)"A");
        this.calorgChanged();
        this.costaccountChanged();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("calorg".equals(key)) {
            this.calorgChanged();
        } else if ("costaccount".equals(key)) {
            this.costaccountChanged();
        } else if ("material".equals(key)) {
            this.materialChanged(e);
        } else if ("newunitcost".equals(key)) {
            this.newunitcostChanged(e);
        } else if ("newcost".equals(key)) {
            this.newcostChanged(e);
        }
        super.propertyChanged(e);
    }

    private void newcostChanged(PropertyChangedArgs e) {
        int rowindex = e.getChangeSet()[0].getRowIndex();
        BigDecimal newcost = (BigDecimal)this.getModel().getValue("newcost", rowindex);
        newcost = newcost == null ? BigDecimal.ZERO : newcost;
        BigDecimal baseqty = (BigDecimal)this.getModel().getValue("baseqty", rowindex);
        if (baseqty == null || baseqty.compareTo(BigDecimal.ZERO) == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u67e5\u8be2\u4f59\u989d\u3002", (String)"CostUpdateApplyBillPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        BigDecimal cost = (BigDecimal)this.getModel().getValue("cost", rowindex);
        cost = cost == null ? BigDecimal.ZERO : cost;
        BigDecimal newunitcost = newcost.divide(baseqty, 10, RoundingMode.HALF_UP);
        BigDecimal costdiff = newcost.subtract(cost);
        this.getModel().beginInit();
        this.getModel().setValue("newunitcost", (Object)newunitcost, rowindex);
        this.getModel().setValue("costdiff", (Object)costdiff, rowindex);
        this.getView().updateView("newunitcost", rowindex);
        this.getView().updateView("costdiff", rowindex);
        this.getModel().endInit();
    }

    private void newunitcostChanged(PropertyChangedArgs e) {
        BigDecimal newunitcost;
        int rowindex = e.getChangeSet()[0].getRowIndex();
        int amtPrecision = 10;
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (currency != null) {
            amtPrecision = currency.getInt("amtprecision");
        }
        newunitcost = (newunitcost = (BigDecimal)this.getModel().getValue("newunitcost", rowindex)) == null ? BigDecimal.ZERO : newunitcost;
        BigDecimal baseqty = (BigDecimal)this.getModel().getValue("baseqty", rowindex);
        if (baseqty == null || baseqty.compareTo(BigDecimal.ZERO) == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u67e5\u8be2\u4f59\u989d\u3002", (String)"CostUpdateApplyBillPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        BigDecimal cost = (BigDecimal)this.getModel().getValue("cost", rowindex);
        cost = cost == null ? BigDecimal.ZERO : cost;
        BigDecimal newcost = newunitcost.multiply(baseqty).setScale(amtPrecision, RoundingMode.HALF_UP);
        BigDecimal costdiff = newcost.subtract(cost);
        this.getModel().beginInit();
        this.getModel().setValue("newcost", (Object)newcost, rowindex);
        this.getModel().setValue("costdiff", (Object)costdiff, rowindex);
        this.getView().updateView("newcost", rowindex);
        this.getView().updateView("costdiff", rowindex);
        this.getModel().endInit();
    }

    private void materialChanged(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        Object baldetailId = this.getModel().getValue("baldetailid", rowIndex);
        this.clearCurrentRow(rowIndex);
        if (baldetailId != null) {
            this.clearCurrentRow(rowIndex);
        }
        this.getModel().setValue("configuredcode", null, rowIndex);
    }

    private void clearCurrentRow(int rowIndex) {
        HashSet<String> dimField = new HashSet<String>();
        dimField.addAll(CalBalanceModelHelper.getDimField());
        dimField.remove("material");
        dimField.add("baldetailid");
        dimField.add("costelement");
        dimField.add("costsubelement");
        dimField.add("baseunit");
        dimField.add("baseqty");
        dimField.add("unitcost");
        dimField.add("cost");
        dimField.add("newunitcost");
        dimField.add("newcost");
        dimField.add("costdiff");
        this.getModel().beginInit();
        for (String string : dimField) {
            this.getModel().setValue(string, null, rowIndex);
            this.getView().updateView(string, rowIndex);
        }
        this.getModel().endInit();
    }

    private void costaccountChanged() {
        this.getModel().deleteEntryData(KEY_ENTRYENTITY);
        this.getModel().createNewEntryRow(KEY_ENTRYENTITY);
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"id,currency", (QFilter[])new QFilter("id", "=", costAccount.getDynamicObject("calpolicy").getPkValue()).toArray());
        this.getModel().setValue("currency", ((DynamicObject)coll.get(0)).get("currency"));
    }

    private void calorgChanged() {
        DynamicObject costaccout;
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        if (calOrg != null && (costaccout = OrgHelper.getCostAccountByCalOrg((Long)calOrg.getLong("id"))) != null) {
            this.getModel().setValue("costaccount", costaccout.get("id"));
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit calorg = (BasedataEdit)this.getControl("calorg");
        calorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costaccount = (BasedataEdit)this.getControl("costaccount");
        costaccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit material = (BasedataEdit)this.getControl("material");
        material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        BasedataEdit configuredCodeEdit = (BasedataEdit)this.getControl("configuredcode");
        configuredCodeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        super.registerListener(e);
    }
}

