/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.bill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.AccountType4CostAdjustHelper;
import kd.fi.cal.common.helper.AccountType4InitCalBillHelper;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.BatchFillEntryHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.CostTypeHelper;
import kd.fi.cal.common.helper.DecimalHelper;
import kd.fi.cal.common.helper.IDGenerator;
import kd.fi.cal.common.helper.InitCalBillHelper;
import kd.fi.cal.common.helper.MaterialHelper;
import kd.fi.cal.common.helper.MaterialNoUpdateFieldHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.SCMHelper;
import kd.fi.cal.common.helper.ScmFetchHelper;
import kd.fi.cal.common.helper.StandardCostHelper;
import kd.fi.cal.common.model.CalRangeInfo;
import kd.fi.cal.common.model.MaterialCostInfo;
import kd.fi.cal.common.model.ScmFetchParam;
import kd.fi.cal.common.model.SynBillErrInfo;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.DateUtils;

public class InitCalBillEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
EntryGridBindDataListener,
HyperLinkClickListener,
RowClickEventListener {
    private static final Log logger = LogFactory.getLog(InitCalBillEditPlugin.class);
    private String COSTACCOUNT = "costaccount";
    private String LOCALCURRENCY = "localcurrency";
    private String STORAGEORGUNIT = "storageorgunit";
    private String WAREHOUSE = "warehouse";
    private String LOCATION = "location";
    private String INVTYPE = "invtype";
    private String INVSTATUS = "invstatus";
    private String OWNER = "owner";
    private String MATERIAL = "material";
    private String MVERSION = "mversion";
    private String BIZDATE = "bizdate";
    private String LOT = "lot";
    private String ASSIST = "assist";
    private String PROJECT = "project";
    private String ENTRY = "entryentity";
    private String CALORG = "calorg";
    private String ACCOUNTTYPE = "accounttype";
    private String BASEUNIT = "baseunit";
    private String ISPRESENT = "ispresent";
    private String PRICE = "price";
    private String BASEQTY = "baseqty";
    private String AMOUNT = "amount";
    private String COSTDIFF = "costdiff";
    private String CREATETYPE = "createtype";
    private String CALDIMENSION = "caldimension";
    private String CALRANGE = "calrange";
    private String YEARINQTY = "yearinqty";
    private String YEARINCOST = "yearincost";
    private String YEARINCOSTDIFF = "yearincostdiff";
    private String YEARISSUEQTY = "yearissueqty";
    private String YEARISSUECOST = "yearissuecost";
    private String YEARISSUECOSTDIFF = "yearissuecostdiff";
    private String SUBENTRY = "subentryentity";
    private String SUBQTY = "sub_baseqty";
    private String SUBPRICE = "sub_price";
    private String SUBAMOUNT = "sub_amount";
    private String SUBCOSTDIFF = "sub_costdiff";
    private String SUBYEARINCOSTDIFF = "sub_yearincostdiff";
    private String SUBYEARISSUECOSTDIFF = "sub_yearissuecostdiff";
    private String SUBYEARINCOST = "sub_yearincost";
    private String SUBYEARISSUECOST = "sub_yearissuecost";
    private String TRACKNUMBER = "tracknumber";
    private String CONFIGUREDCODE = "configuredcode";
    private static String[] calDimFields = new String[]{"storageorgunit", "warehouse", "location", "owner", "ownertype", "invtype", "invstatus", "assist", "project", "lot", "material", "baseqty", "yearinqty", "yearissueqty", "baseunit", "configuredcode", "tracknumber"};
    private static String[] invDimFields = new String[]{"estorageorg", "ewarehs", "elocation", "eowner", "eownertype", "einvtype", "einvstatus", "eauxpty", "eproject", "elot", "ematerial", "invbgnqty", "inbaseqty", "outbaseqty", "ebaseunit", "econfiguredcode", "tracknumber"};
    private static long initCalBillType = 900050262545291264L;

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getControl(this.ENTRY);
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addF7Listener(this, this.CALORG, this.COSTACCOUNT, this.STORAGEORGUNIT, this.WAREHOUSE, this.LOCATION, this.OWNER, this.MATERIAL, this.INVTYPE, this.MVERSION);
        BasedataEdit configuredCodeEdit = (BasedataEdit)this.getControl("configuredcode");
        configuredCodeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Long calOrgId;
        super.afterCreateNewData(e);
        if (((IBillModel)this.getView().getModel()).isFromImport()) {
            return;
        }
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue(this.CALORG);
        if (calOrg != null) {
            calOrgId = calOrg.getLong("id");
        } else {
            Long userId = RequestContext.get().getCurrUserId();
            Long userOrgId = RequestContext.get().getOrgId();
            calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_initbill");
            this.getModel().setValue(this.CALORG, (Object)calOrgId);
        }
        DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrgId);
        DynamicObject defaultCalRange = null;
        if (costAccount != null) {
            long costAccountId = costAccount.getLong("id");
            this.getModel().setValue(this.COSTACCOUNT, (Object)costAccountId);
            this.setLocalCurrency("calpolicy", costAccount);
            defaultCalRange = AccountType4InitCalBillHelper.getDefaultCalRange((long)costAccountId);
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(this.ENTRY);
        for (int i = 0; i < entrys.size(); ++i) {
            this.getModel().setValue(this.OWNER, (Object)calOrgId, i);
            if (defaultCalRange == null) continue;
            String accountType = defaultCalRange.getString("accounttype");
            this.getModel().setValue(this.CALRANGE, (Object)defaultCalRange, i);
            this.getModel().setValue(this.ACCOUNTTYPE, (Object)accountType, i);
            this.getModel().setValue(this.CALDIMENSION, (Object)defaultCalRange.getDynamicObject("caldimension"), i);
        }
        this.getModel().setValue(this.BIZDATE, (Object)DateUtils.getDayStartTime((Date)new Date()));
        this.bizDateChanged();
    }

    private void setLocalCurrency(String policyIdSelName, DynamicObject costAccount) {
        long policyId = costAccount.getLong(policyIdSelName);
        if (policyId == 0L) {
            String errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c{0}\u201d\u7684\u6838\u7b97\u653f\u7b56\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u83b7\u53d6\u5931\u8d25\u3002", (String)"InitCalBillEditPlugin_18", (String)"fi-cal-formplugin", (Object[])new Object[0]), costAccount.getString("name"));
            throw new KDBizException(errorMsg);
        }
        DynamicObject policyObj = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)policyId)});
        this.getModel().setValue("localcurrency", (Object)policyObj.getLong("currency"));
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] entity;
        String entryName = e.getEntryProp().getName();
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue(this.COSTACCOUNT);
        if (costAccount == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InitCalBillEditPlugin_11", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        if (!this.ENTRY.equals(entryName)) {
            return;
        }
        for (RowDataEntity obj : entity = e.getRowDataEntities()) {
            boolean calByCostElement;
            int currentRowIndex = obj.getRowIndex();
            this.getModel().setValue("owner", ((DynamicObject)this.getModel().getValue(this.CALORG)).get("id"), currentRowIndex);
            if (currentRowIndex == 0) continue;
            DynamicObject storageUnit = (DynamicObject)this.getModel().getValue(this.STORAGEORGUNIT, currentRowIndex - 1);
            long storageId = (Long)this.getModel().getValue(this.STORAGEORGUNIT + "_id", currentRowIndex - 1);
            if (storageUnit != null) {
                this.getModel().setValue(this.STORAGEORGUNIT, (Object)storageId, currentRowIndex);
            }
            if (calByCostElement = ParamsHelper.getCostElementByCostAccount((long)costAccount.getLong("id"))) {
                this.getView().setEnable(Boolean.FALSE, currentRowIndex, new String[]{this.PRICE, this.AMOUNT, this.COSTDIFF, this.YEARINCOST, this.YEARISSUECOST});
                continue;
            }
            this.getView().setEnable(Boolean.FALSE, currentRowIndex, new String[]{this.COSTDIFF});
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        DynamicObject costaccount = (DynamicObject)this.getModel().getValue(this.COSTACCOUNT);
        String billStaus = (String)this.getModel().getValue("billstatus");
        if (costaccount == null || "B".equals(billStaus) || "C".equals(billStaus)) {
            return;
        }
        int rowIdx = evt.getRow();
        if (rowIdx < 0) {
            this.getView().setEnable(Boolean.FALSE, new String[]{this.SUBENTRY});
            return;
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{this.SUBENTRY});
        this.setEnable4SubEntryPriceAmt(rowIdx);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl(this.ENTRY);
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue(this.COSTACCOUNT);
        if (costAccount == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{this.SUBENTRY});
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InitCalBillEditPlugin_11", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean calByCostElement = ParamsHelper.getCostElementByCostAccount((long)costAccount.getLong("id"));
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(this.ENTRY);
        if (entrys.size() == 0) {
            return;
        }
        boolean isStd = InitCalBillHelper.isStd((DynamicObject)costAccount, (String)((DynamicObject)entrys.get(0)).getString(this.ACCOUNTTYPE));
        boolean ispresent = ((DynamicObject)entrys.get(0)).getBoolean(this.ISPRESENT);
        int subEntrySize = this.getModel().getEntryEntity(this.SUBENTRY).size();
        for (int i = 0; i < subEntrySize; ++i) {
            if (isStd || !ispresent) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{this.SUBPRICE, this.SUBAMOUNT});
        }
        this.setEnableEntry(this.getModel().getEntryEntity(this.ENTRY).size(), calByCostElement);
        this.setEnable4SubEntry(subEntrySize, isStd, calByCostElement);
        this.lockBill4EntryStatus();
    }

    private void lockBill4EntryStatus() {
        String billStatus = (String)this.getModel().getValue("billstatus");
        boolean lockBill = false;
        if ("A".equals(billStatus)) {
            DynamicObjectCollection coll = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject entry : coll) {
                String entryStatus = entry.getString("entrystatus");
                if (!"D".equals(entryStatus) && !"E".equals(entryStatus)) continue;
                lockBill = true;
                break;
            }
        }
        if (lockBill) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"contentpanel"});
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue(this.COSTACCOUNT);
        if (costAccount == null) {
            return;
        }
        boolean ennableStd = costAccount.getBoolean("enablestandardcost");
        boolean calByCostElement = ParamsHelper.getCostElementByCostAccount((long)costAccount.getLong("id"));
        for (RowDataEntity row : e.getRows()) {
            DynamicObject materialInvInfo;
            int rowIdx = row.getRowIndex();
            DynamicObject dataEntity = row.getDataEntity();
            this.setEnable4SingleEntry(calByCostElement, ennableStd, rowIdx, dataEntity);
            if (dataEntity.getLong("srcbilltype_id") == initCalBillType) {
                this.getView().setEnable(Boolean.FALSE, rowIdx, new String[]{this.STORAGEORGUNIT, this.MATERIAL, this.ASSIST, this.LOT, this.WAREHOUSE, this.LOCATION, this.OWNER, this.INVTYPE, this.INVSTATUS, this.PROJECT, this.BASEQTY, this.YEARINQTY, this.YEARISSUEQTY});
                continue;
            }
            DynamicObject materialInfo = dataEntity.getDynamicObject(this.MATERIAL);
            DynamicObject storageorgunit = dataEntity.getDynamicObject(this.STORAGEORGUNIT);
            if (materialInfo == null || storageorgunit == null) {
                this.getView().setEnable(Boolean.FALSE, rowIdx, new String[]{this.ASSIST, this.LOT});
                continue;
            }
            boolean isuseauxpty = materialInfo.getBoolean("isuseauxpty");
            this.getView().setEnable(Boolean.valueOf(isuseauxpty), rowIdx, new String[]{this.ASSIST});
            DynamicObject warehouse = dataEntity.getDynamicObject(this.WAREHOUSE);
            if (warehouse == null || !warehouse.getBoolean("isopenlocation")) {
                this.getView().setEnable(Boolean.FALSE, rowIdx, new String[]{this.LOCATION});
            }
            if ((materialInvInfo = MaterialHelper.getMaterialInvInf4Org((DynamicObject)materialInfo, (String)"createorg,enablelot", (long)storageorgunit.getLong("id"))) == null) {
                this.getView().setEnable(Boolean.FALSE, rowIdx, new String[]{this.ASSIST, this.LOT});
                continue;
            }
            boolean enablelot = materialInvInfo.getBoolean("enablelot");
            this.getView().setEnable(Boolean.valueOf(enablelot), rowIdx, new String[]{this.LOT});
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().setValue("bizbillid", (Object)0L);
        this.getModel().setValue("bizentityobject", (Object)"");
        this.getModel().setValue(this.BIZDATE, (Object)DateUtils.getDayStartTime((Date)new Date()));
        this.bizDateChanged();
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryColl.size(); ++i) {
            this.getModel().setValue("bizbillentryid", (Object)0L, i);
            this.getModel().setValue("srcbilltype", null, i);
            this.getModel().setValue("srcbizentityobject", (Object)"", i);
            this.getModel().setValue("srcbillid", (Object)0L, i);
            this.getModel().setValue("srcbillentryid", (Object)0L, i);
            this.getModel().setValue("srcbillnum", (Object)"", i);
            this.getModel().setValue("srcentryseq", (Object)0L, i);
        }
        this.dealChange();
    }

    private void dealChange() {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue(this.COSTACCOUNT);
        AccountType4CostAdjustHelper helper = new AccountType4CostAdjustHelper(new DynamicObject[]{this.getModel().getDataEntity(true)});
        helper.handleCalRangeAccType4InitBill();
        this.handleSubEntry(costAccount);
    }

    private void setEnable4Entry(DynamicObject costAccount, boolean calByCostEle, int rowIdx) {
        boolean enableStd = costAccount.getBoolean("enablestandardcost");
        if (rowIdx >= 0) {
            this.setEnable4SingleEntry(calByCostEle, enableStd, rowIdx, (DynamicObject)this.getModel().getEntryEntity(this.ENTRY).get(rowIdx));
        } else {
            DynamicObjectCollection entrys = this.getModel().getEntryEntity(this.ENTRY);
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                this.setEnable4SingleEntry(calByCostEle, enableStd, i, entry);
            }
        }
    }

    private void setEnable4SingleEntry(boolean calByCostEle, boolean enableStd, int i, DynamicObject entry) {
        String accountType = entry.getString(this.ACCOUNTTYPE);
        if (calByCostEle) {
            this.getView().setEnable(Boolean.FALSE, i, new String[]{this.PRICE, this.AMOUNT, this.COSTDIFF, this.YEARINCOST, this.YEARISSUECOST, this.YEARINCOSTDIFF, this.YEARISSUECOSTDIFF});
        } else if (!entry.getBoolean(this.ISPRESENT)) {
            if (InitCalBillHelper.isStd((boolean)enableStd, (String)accountType)) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{this.PRICE, this.AMOUNT});
                this.getView().setEnable(Boolean.TRUE, i, new String[]{this.COSTDIFF, this.YEARINCOST, this.YEARINCOSTDIFF, this.YEARISSUECOST, this.YEARISSUECOSTDIFF});
            } else {
                this.getView().setEnable(Boolean.TRUE, i, new String[]{this.PRICE, this.AMOUNT, this.YEARINCOST, this.YEARISSUECOST});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{this.COSTDIFF, this.YEARINCOSTDIFF, this.YEARISSUECOSTDIFF, this.CREATETYPE});
            }
        } else if (InitCalBillHelper.isStd((boolean)enableStd, (String)accountType)) {
            this.getView().setEnable(Boolean.FALSE, i, new String[]{this.COSTDIFF, this.YEARINCOST, this.YEARINCOSTDIFF, this.YEARISSUECOST, this.YEARISSUECOSTDIFF});
        } else {
            this.getView().setEnable(Boolean.FALSE, i, new String[]{this.PRICE, this.AMOUNT, this.YEARINCOST, this.YEARISSUECOST});
        }
        if (entry.getBigDecimal(this.COSTDIFF).compareTo(BigDecimal.ZERO) == 0) {
            this.getView().setEnable(Boolean.FALSE, i, new String[]{this.CREATETYPE});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("bar_getinvbegindata".equals(itemKey)) {
            this.getInvBeginData();
        } else if ("bar_unsubmit".equals(itemKey) || "bar_unaudit".equals(itemKey)) {
            DynamicObject costaccount = (DynamicObject)this.getModel().getValue(this.COSTACCOUNT);
            boolean isStd = InitCalBillHelper.isStd((DynamicObject)costaccount, (String)((String)this.getModel().getValue(this.ACCOUNTTYPE, 0)));
            boolean calByCostElement = ParamsHelper.getCostElementByCostAccount((long)costaccount.getLong("id"));
            this.setEnableEntry(this.getModel().getEntryEntity(this.ENTRY).size(), calByCostElement);
            this.setEnable4SubEntry(this.getModel().getEntryEntity(this.SUBENTRY).size(), isStd, calByCostElement);
        } else if ("batchfill".equals(itemKey)) {
            new BatchFillEntryHelper().batchFill(this.getView(), "entryentity");
        }
    }

    private void getInvBeginData() {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (calOrg == null && costAccount == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u6838\u7b97\u7ec4\u7ec7\u3001\u6210\u672c\u8d26\u7c3f\u540e\u518d\u83b7\u53d6\u5e93\u5b58\u671f\u521d\u6570\u636e\u3002", (String)"InitCalBillEditPlugin_4", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        if (calOrg == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u6838\u7b97\u7ec4\u7ec7\u540e\u518d\u83b7\u53d6\u5e93\u5b58\u671f\u521d\u6570\u636e\u3002", (String)"InitCalBillEditPlugin_5", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        if (costAccount == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u6210\u672c\u8d26\u7c3f\u540e\u518d\u83b7\u53d6\u5e93\u5b58\u671f\u521d\u6570\u636e\u3002", (String)"InitCalBillEditPlugin_6", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        long costAccountId = costAccount.getLong("id");
        String costAccName = costAccount.getString("name");
        DynamicObject startPeriod = PeriodHelper.getStartPeriod((Long)costAccountId);
        if (startPeriod == null) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u7684\u542f\u7528\u671f\u95f4\u540e\u518d\u83b7\u53d6\u5e93\u5b58\u671f\u521d\u6570\u636e\u3002", (String)"InitCalBillEditPlugin_7", (String)"fi-cal-formplugin", (Object[])new Object[0]), costAccName);
            throw new KDBizException(errorMsg);
        }
        QFilter initBillFilter = new QFilter("costAccount", "=", (Object)costAccount.getLong("id"));
        DynamicObjectCollection initBills = QueryServiceHelper.query((String)"cal_initbill", (String)"id", (QFilter[])new QFilter[]{initBillFilter});
        if (PeriodHelper.isEndInit((Long)costAccountId)) {
            String errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c{0}\u201d\u5df2\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u521d\u59cb\u6838\u7b97\u5355\u3002", (String)"InitCalBillEditPlugin_8", (String)"fi-cal-formplugin", (Object[])new Object[0]), costAccName);
            throw new KDBizException(errorMsg);
        }
        if (initBills.size() > 0) {
            String errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c{0}\u201d\u5df2\u5b58\u5728\u521d\u59cb\u6838\u7b97\u5355\uff0c\u4e0d\u5141\u8bb8\u4ece\u5e93\u5b58\u6279\u91cf\u83b7\u53d6\u671f\u521d\u6570\u636e\u3002", (String)"InitCalBillEditPlugin_9", (String)"fi-cal-formplugin", (Object[])new Object[0]), costAccName);
            throw new KDBizException(errorMsg);
        }
        Long[] owners = AccountingSysHelper.getOwners((Long)costAccountId);
        if (owners.length == 0) {
            String errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c{0}\u201d\u7684\u6838\u7b97\u4f53\u7cfb\u4e2d\u672a\u8bbe\u7f6e\u8bb0\u8d26\u8303\u56f4\u3002", (String)"InitCalBillEditPlugin_10", (String)"fi-cal-formplugin", (Object[])new Object[0]), costAccName);
            throw new KDBizException(errorMsg);
        }
        ScmFetchParam params = new ScmFetchParam();
        Date accBeginDate = startPeriod.getDate("begindate");
        params.setEnddate(accBeginDate);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(accBeginDate);
        params.setStorageOrgIds(OrgHelper.getStorageOrgUnitByCalOrg((Long)calOrg.getLong("id")));
        params.setOwners(owners);
        ScmFetchHelper scmFetchHelper = new ScmFetchHelper(params);
        DataSet ScmDs = scmFetchHelper.fetchScmData();
        if (ScmDs.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e93\u5b58\u671f\u521d\u6570\u636e\u4e3a\u7a7a\u3002", (String)"InitCalBillEditPlugin_12", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        TableValueSetter tableSetter = new TableValueSetter(new String[0]);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        for (String string : calDimFields) {
            tableSetter.addField(string, new Object[0]);
        }
        tableSetter.addField("srcbilltype", new Object[0]);
        int size = calDimFields.length;
        Object[] values = new Object[size + 1];
        model.beginInit();
        for (Row row : ScmDs) {
            for (int i = 0; i < size; ++i) {
                values[i] = row.get(invDimFields[i]);
            }
            values[size] = initCalBillType;
            tableSetter.addRow(values);
        }
        int rowCount = tableSetter.getCount();
        this.getModel().deleteEntryData(this.ENTRY);
        long beginCreateTime = System.currentTimeMillis();
        model.batchCreateNewEntryRow(this.ENTRY, tableSetter);
        Date bookdate = model.getDataEntity().getDate("bookdate");
        DynamicObjectCollection entrys = model.getEntityEntity(this.ENTRY);
        IDGenerator eIdGenerator = new IDGenerator("t_cal_initbillentry");
        for (DynamicObject entry : entrys) {
            entry.set("stockindate", (Object)bookdate);
            long entryId = entry.getLong("id");
            if (entryId != 0L) continue;
            entry.set("id", (Object)eIdGenerator.getId());
        }
        logger.info("\u83b7\u53d6\u5e93\u5b58\u671f\u521d\u6570\u636e\uff1a" + rowCount + "\u6761\uff0c\u751f\u6210\u5206\u5f55\u8017\u65f6\uff1a" + (System.currentTimeMillis() - beginCreateTime) + "ms");
        model.endInit();
        long handleStartTime = System.currentTimeMillis();
        AccountType4CostAdjustHelper helper = new AccountType4CostAdjustHelper(new DynamicObject[]{this.getModel().getDataEntity(true)});
        helper.handleCalRangeAccType4InitBill();
        this.handleSubEntry(costAccount);
        logger.info("\u5904\u7406\u8ba1\u4ef7\u65b9\u6cd5\u8017\u65f6\uff1a" + (System.currentTimeMillis() - handleStartTime) + "ms");
        this.getView().updateView(this.ENTRY);
    }

    private void handleSubEntry(DynamicObject costAccount) {
        IDataModel model = this.getModel();
        DynamicObject localCurrency = (DynamicObject)model.getValue(this.LOCALCURRENCY);
        if (localCurrency == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u4f4d\u5e01\u4e3a\u7a7a", (String)"InitCalBillEditPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection entrys = model.getEntryEntity(this.ENTRY);
        int entrySize = entrys.size();
        HashSet<Long> materialSet = new HashSet<Long>(1);
        boolean enableStd = costAccount.getBoolean("enablestandardcost");
        HashSet<Long> stdMaterialSet = enableStd ? new HashSet<Long>(entrySize) : new HashSet(512);
        HashSet<Long> calDimensionIdSet = new HashSet<Long>(16);
        for (DynamicObject entry : entrys) {
            long materialId = entry.getLong("material_id");
            if (materialSet.isEmpty() && materialId != 0L) {
                materialSet.add(materialId);
            }
            if (!enableStd && !AccountTypeEnum.STANDARDCOST.getValue().equals(entry.getString(this.ACCOUNTTYPE))) continue;
            stdMaterialSet.add(materialId);
            calDimensionIdSet.add(entry.getLong("caldimension_id"));
        }
        if (materialSet.isEmpty()) {
            return;
        }
        DynamicObject[] bills = new DynamicObject[]{this.getModel().getDataEntity()};
        Map costInfoMap = InitCalBillHelper.queryCostInfo((DynamicObject[])bills);
        Set assistEffectPriceMatIds = InitCalBillHelper.cacheAssistAffectPriceMatIds(stdMaterialSet);
        Set hasMatVerCalDimIds = InitCalBillHelper.cacheCalDimSetHasMatVer(calDimensionIdSet);
        StringBuilder errMaterialSb = new StringBuilder();
        StringBuilder errMaterialSb4Mversion = new StringBuilder();
        int amtprecision = localCurrency.getInt("amtprecision");
        boolean calByCostElement = ParamsHelper.getCostElementByCostAccount((long)costAccount.getLong("id"));
        List allElement = CostElementHelper.getAllCostEle4InitBill();
        for (int rowIndex = 0; rowIndex < entrySize; ++rowIndex) {
            this.getModel().setEntryCurrentRowIndex(this.ENTRY, rowIndex);
            DynamicObject entry = (DynamicObject)entrys.get(rowIndex);
            entry.getDynamicObjectCollection(this.SUBENTRY).clear();
            BigDecimal entryQty = entry.getBigDecimal(this.BASEQTY);
            if (calByCostElement) {
                if (InitCalBillHelper.isStd((boolean)enableStd, (String)entry.getString(this.ACCOUNTTYPE))) {
                    int i;
                    DynamicObjectCollection subEntryColl;
                    this.buildSubEntry4Std(model, costInfoMap, assistEffectPriceMatIds, hasMatVerCalDimIds, errMaterialSb, amtprecision, 0L, allElement, entry, entryQty, true, costAccount, errMaterialSb4Mversion);
                    if (enableStd) {
                        subEntryColl = entry.getDynamicObjectCollection("subentryentity");
                        for (i = 0; i < subEntryColl.getRowCount(); ++i) {
                            this.getView().setEnable(Boolean.FALSE, i, new String[]{this.SUBPRICE});
                        }
                    }
                    subEntryColl = entry.getDynamicObjectCollection("subentryentity");
                    for (i = 0; i < subEntryColl.getRowCount(); ++i) {
                        this.getView().setEnable(Boolean.FALSE, i, new String[]{this.SUBAMOUNT});
                    }
                    continue;
                }
                this.getModel().setValue(this.PRICE, null, rowIndex);
                this.getModel().setValue(this.AMOUNT, null, rowIndex);
                InitCalBillHelper.buildSubEntry4CalbyEle((DynamicObject)entry, (IDataModel)this.getModel(), (List)allElement);
                continue;
            }
            if (InitCalBillHelper.isStd((boolean)enableStd, (String)entry.getString(this.ACCOUNTTYPE))) {
                this.buildSubEntry4Std(model, costInfoMap, assistEffectPriceMatIds, hasMatVerCalDimIds, errMaterialSb, amtprecision, 0L, allElement, entry, entryQty, false, costAccount, errMaterialSb4Mversion);
                continue;
            }
            InitCalBillHelper.buildSubEntry4NotStdNotbyEle((DynamicObject)entry, (IDataModel)this.getModel(), (DynamicObject)costAccount);
        }
        if (errMaterialSb.length() > 0) {
            String content;
            HashMap errMap = new HashMap(16);
            Set costTypeIdSet = CostTypeHelper.getCostTypeByOrgAndBookDate((DynamicObject[])bills, (String[])new String[]{"auditdate", "costaccount", "calorg", "storageorgunit", "accounttype", "bookdate"}, errMap, (int)1);
            if (errMap.size() > 0) {
                this.getView().showTipNotification(((SynBillErrInfo)errMap.get(bills[0].getLong("bizbillid"))).getErrorMsg());
                return;
            }
            long costtypeId = 0L;
            if (costTypeIdSet != null && costTypeIdSet.size() > 0) {
                costtypeId = (Long)costTypeIdSet.iterator().next();
            }
            DynamicObject costtype = BusinessDataServiceHelper.loadSingle((Object)costtypeId, (String)"cad_costtype", (String)"name");
            String costtypeName = null;
            if (costtype != null) {
                costtypeName = costtype.getString("name");
            }
            String errMsg = errMaterialSb.toString();
            errMsg = content = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u6ca1\u6709\u7ef4\u62a4\u6210\u672c\u7c7b\u578b\u4e3a\u201c%2$s\u201d\u7684\u7269\u6599\u6210\u672c\u4fe1\u606f\u3002", (String)"InitCalBillEditPlugin_23", (String)"fi-cal-formplugin", (Object[])new Object[0]), errMsg, costtypeName);
            if (errMaterialSb4Mversion.length() > 0) {
                String msg;
                String errMsg4Mversion = errMaterialSb4Mversion.toString();
                errMsg = msg = String.format(ResManager.loadKDString((String)"%1$s\u3002\u7269\u6599%2$s\uff0c\u5df2\u542f\u7528\u7248\u672c\u7ba1\u7406\uff0c\u76ee\u524d\u83b7\u53d6\u5e93\u5b58\u671f\u521d\u4e0d\u652f\u6301\u83b7\u53d6\u7269\u6599\u7248\u672c\uff0c\u8bf7\u786e\u8ba4\u6570\u91cf\u548c\u7269\u6599\u6210\u672c\u4fe1\u606f\u662f\u5426\u6b63\u786e\u3002", (String)"InitCalBillEditPlugin_24", (String)"fi-cal-formplugin", (Object[])new Object[0]), errMsg, errMsg4Mversion);
            }
            this.getView().showErrorNotification(errMsg);
        }
    }

    private void buildSubEntry4Std(IDataModel model, Map<String, List<MaterialCostInfo>> costInfoMap, Set<Long> assistEffectPriceMatIds, Set<Long> hasMatVerCalDimIds, StringBuilder errMaterialSb, int amtprecision, long costtypeId, List<Long[]> allElement, DynamicObject entry, BigDecimal entryQty, boolean calByEle, DynamicObject costAccount, StringBuilder errMaterialSb4Mversion) {
        List costInfoColl = InitCalBillHelper.getStdCostInfFromMap(costInfoMap, (DynamicObject)entry);
        if (costInfoColl == null || costInfoColl.isEmpty()) {
            entry.set(this.PRICE, (Object)BigDecimal.ZERO);
            entry.set(this.AMOUNT, (Object)BigDecimal.ZERO);
            DynamicObject material = entry.getDynamicObject(this.MATERIAL);
            boolean enablematerialversion = material.getBoolean("isenablematerialversion");
            if (enablematerialversion) {
                errMaterialSb4Mversion.append("\u3010").append(material.getString("name")).append("\u3011");
            } else {
                errMaterialSb.append("\u3010").append(material.getString("name")).append("\u3011");
            }
            return;
        }
        BigDecimal price = calByEle ? InitCalBillHelper.buildSubEntry4StdCalbyEle((DynamicObject)entry, (IDataModel)model, (List)costInfoColl, allElement) : InitCalBillHelper.buildSubEntry4StdNotCalbyEle((DynamicObject)entry, (IDataModel)model, (List)costInfoColl, (DynamicObject)costAccount);
        entry.set(this.PRICE, (Object)price);
        if (entryQty.compareTo(BigDecimal.ZERO) != 0) {
            entry.set(this.AMOUNT, (Object)price.multiply(entryQty).setScale(amtprecision, RoundingMode.HALF_UP));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if (this.COSTACCOUNT.equals(key)) {
            this.costAccountChanged(e);
        } else if (this.BIZDATE.equals(key)) {
            this.bizDateChanged();
        } else if (this.MATERIAL.equals(key)) {
            this.materialChanged(rowIndex);
        } else if (this.STORAGEORGUNIT.equals(key)) {
            this.storageorgunitChanged(rowIndex);
        } else if (this.WAREHOUSE.equals(key)) {
            this.warehouseChanged(rowIndex);
        } else if (this.LOCATION.equals(key)) {
            this.locationChanged(rowIndex);
        } else if (this.PRICE.equals(key)) {
            this.priceOrQtyChanged(rowIndex);
        } else if (this.BASEQTY.equals(key)) {
            this.baseQtyChanged(rowIndex);
        } else if (this.AMOUNT.equals(key)) {
            this.amountChanged(rowIndex);
        } else if (this.ACCOUNTTYPE.equals(key)) {
            this.acctypeChanged(rowIndex, e);
        } else if (this.OWNER.equals(key)) {
            this.ownerChanged(rowIndex);
        } else if (this.YEARINQTY.equals(key) || this.YEARISSUEQTY.equals(key)) {
            this.yearQtyChanged(rowIndex, key);
        } else if (this.SUBCOSTDIFF.equals(key)) {
            this.subCostOrDiffChanged(rowIndex, e, this.COSTDIFF);
        } else if (this.SUBYEARINCOSTDIFF.equals(key)) {
            this.subCostOrDiffChanged(rowIndex, e, this.YEARINCOSTDIFF);
        } else if (this.SUBYEARISSUECOSTDIFF.equals(key)) {
            this.subCostOrDiffChanged(rowIndex, e, this.YEARISSUECOSTDIFF);
        } else if (this.SUBYEARINCOST.equals(key)) {
            this.subCostOrDiffChanged(rowIndex, e, this.YEARINCOST);
        } else if (this.SUBYEARISSUECOST.equals(key)) {
            this.subCostOrDiffChanged(rowIndex, e, this.YEARISSUECOST);
        } else if (this.SUBPRICE.equals(key)) {
            this.subPriceChanged(rowIndex);
        } else if (this.SUBAMOUNT.equals(key)) {
            this.subAmountChanged(rowIndex);
        } else if (this.COSTDIFF.equals(key)) {
            this.costdiffChanged(rowIndex);
        } else if (this.ASSIST.equals(key)) {
            this.assistChanged(rowIndex, e);
        } else if (this.MVERSION.equals(key)) {
            this.mversionChanged(rowIndex, e);
        } else if (this.ISPRESENT.equals(key)) {
            this.ispresentChanged(rowIndex);
        } else if (this.TRACKNUMBER.equals(key)) {
            this.tracknumberChanged(rowIndex, e);
        } else if (this.CONFIGUREDCODE.equals(key)) {
            this.configuredcodeChanged(rowIndex, e);
        }
    }

    private void mversionChanged(int rowIndex, PropertyChangedArgs e) {
        DynamicObject caldimension = (DynamicObject)this.getModel().getValue(this.CALDIMENSION, rowIndex);
        if (caldimension == null) {
            return;
        }
        long caldimensionId = caldimension.getLong("id");
        DynamicObject materialInfo = (DynamicObject)this.getModel().getValue(this.MATERIAL, rowIndex);
        if (!InitCalBillHelper.calDimSetHasMatVer((long)caldimensionId) || materialInfo == null) {
            return;
        }
        this.affectCostFieldChanged(rowIndex, materialInfo);
    }

    private void assistChanged(int rowIndex, PropertyChangedArgs e) {
        DynamicObject materialInfo = (DynamicObject)this.getModel().getValue(this.MATERIAL, rowIndex);
        if (materialInfo == null) {
            return;
        }
        ChangeData assistData = e.getChangeSet()[0];
        DynamicObject oldAssist = (DynamicObject)assistData.getOldValue();
        DynamicObject newAssist = (DynamicObject)assistData.getNewValue();
        if (oldAssist != null && newAssist != null && oldAssist.getLong("id") == newAssist.getLong("id")) {
            return;
        }
        this.affectCostFieldChanged(rowIndex, materialInfo);
    }

    private void tracknumberChanged(int rowIndex, PropertyChangedArgs e) {
        DynamicObject materialInfo = (DynamicObject)this.getModel().getValue(this.MATERIAL, rowIndex);
        if (materialInfo == null) {
            return;
        }
        ChangeData tracknumberData = e.getChangeSet()[0];
        DynamicObject oldtracknumber = (DynamicObject)tracknumberData.getOldValue();
        DynamicObject newtracknumber = (DynamicObject)tracknumberData.getNewValue();
        if (oldtracknumber != null && newtracknumber != null && oldtracknumber.getLong("id") == newtracknumber.getLong("id")) {
            return;
        }
        this.affectCostFieldChanged(rowIndex, materialInfo);
    }

    private void configuredcodeChanged(int rowIndex, PropertyChangedArgs e) {
        DynamicObject materialInfo = (DynamicObject)this.getModel().getValue(this.MATERIAL, rowIndex);
        if (materialInfo == null) {
            return;
        }
        ChangeData configuredcodeData = e.getChangeSet()[0];
        DynamicObject oldconfiguredcode = (DynamicObject)configuredcodeData.getOldValue();
        DynamicObject newconfiguredcode = (DynamicObject)configuredcodeData.getNewValue();
        if (oldconfiguredcode != null && newconfiguredcode != null && oldconfiguredcode.getLong("id") == newconfiguredcode.getLong("id")) {
            return;
        }
        this.affectCostFieldChanged(rowIndex, materialInfo);
    }

    private void affectCostFieldChanged(int rowIndex, DynamicObject materialInfo) {
        DynamicObject costAcc = (DynamicObject)this.getModel().getValue(this.COSTACCOUNT);
        if (costAcc == null) {
            return;
        }
        String accType = (String)this.getModel().getValue(this.ACCOUNTTYPE, rowIndex);
        if (costAcc == null) {
            return;
        }
        boolean enableStd = costAcc.getBoolean("enablestandardcost");
        boolean isStd = InitCalBillHelper.isStd((boolean)enableStd, (String)accType);
        if (!isStd) {
            return;
        }
        this.clearFieldAndSetPrice(rowIndex, false);
        boolean calByCostElement = ParamsHelper.getCostElementByCostAccount((long)costAcc.getLong("id"));
        BigDecimal price = this.buildSubEntry(rowIndex, materialInfo, accType, calByCostElement, true);
        this.getModel().setValue(this.PRICE, (Object)price, rowIndex);
        this.getView().updateView(this.PRICE, rowIndex);
        this.getView().updateView(this.AMOUNT, rowIndex);
        this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{this.CREATETYPE});
        this.setEnable4SubEntry(this.getModel().getEntryRowCount(this.SUBENTRY), true, calByCostElement);
        this.getView().updateView(this.SUBENTRY);
    }

    private void costdiffChanged(int rowIndex) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue(this.COSTACCOUNT);
        boolean calByCostElement = ParamsHelper.getCostElementByCostAccount((long)costAccount.getLong("id"));
        if (calByCostElement) {
            return;
        }
        DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity(this.ENTRY).get(rowIndex);
        BigDecimal costDiff = entry.getBigDecimal(this.COSTDIFF);
        if (costDiff.compareTo(BigDecimal.ZERO) == 0) {
            this.getModel().setValue(this.CREATETYPE, null, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{this.CREATETYPE});
            return;
        }
        this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{this.CREATETYPE});
        DynamicObjectCollection subEntry = entry.getDynamicObjectCollection(this.SUBENTRY);
        this.getModel().beginInit();
        for (DynamicObject sub : subEntry) {
            sub.set(this.SUBCOSTDIFF, (Object)costDiff);
        }
        this.getModel().endInit();
    }

    private void subPriceChanged(int rowIndex) {
        int entryIdx = this.getModel().getEntryCurrentRowIndex(this.ENTRY);
        DynamicObject subEntry = (DynamicObject)this.getModel().getEntryEntity(this.SUBENTRY).get(rowIndex);
        BigDecimal subQty = subEntry.getBigDecimal(this.SUBQTY);
        if (subQty.compareTo(BigDecimal.ZERO) == 0) {
            BigDecimal price = BigDecimal.ZERO;
            for (DynamicObject entry : this.getModel().getEntryEntity(this.SUBENTRY)) {
                price = price.add(entry.getBigDecimal(this.SUBPRICE));
            }
            this.getModel().beginInit();
            DynamicObject entry = (DynamicObject)subEntry.getParent();
            entry.set(this.PRICE, (Object)price);
            this.getModel().endInit();
            this.getView().updateView(this.PRICE, entryIdx);
            return;
        }
        BigDecimal subPrice = (BigDecimal)this.getModel().getValue(this.SUBPRICE, rowIndex);
        BigDecimal oldSubAmount = subEntry.getBigDecimal(this.SUBAMOUNT);
        DynamicObject localCurrency = (DynamicObject)this.getModel().getValue(this.LOCALCURRENCY);
        int amtPrecision = localCurrency.getInt("amtprecision");
        BigDecimal newSubAmount = subPrice.multiply(subQty).setScale(amtPrecision, RoundingMode.HALF_UP);
        subEntry.set(this.SUBAMOUNT, (Object)newSubAmount);
        BigDecimal subAmountDiff = newSubAmount.subtract(oldSubAmount);
        DynamicObject entry = (DynamicObject)subEntry.getParent();
        BigDecimal newEntryAmount = entry.getBigDecimal(this.AMOUNT).add(subAmountDiff);
        entry.set(this.AMOUNT, (Object)newEntryAmount);
        entry.set(this.PRICE, (Object)newEntryAmount.divide(subQty, 10, RoundingMode.HALF_UP));
        this.getView().updateView(this.SUBAMOUNT, rowIndex);
        this.getView().updateView(this.PRICE, entryIdx);
        this.getView().updateView(this.AMOUNT, entryIdx);
    }

    private void subAmountChanged(int rowIndex) {
        int entryIdx = this.getModel().getEntryCurrentRowIndex(this.ENTRY);
        DynamicObject subEntry = (DynamicObject)this.getModel().getEntryEntity(this.SUBENTRY).get(rowIndex);
        BigDecimal subQty = subEntry.getBigDecimal(this.SUBQTY);
        BigDecimal subAmount = (BigDecimal)this.getModel().getValue(this.SUBAMOUNT, rowIndex);
        BigDecimal subPrice = BigDecimal.ZERO.compareTo(subQty) == 0 ? BigDecimal.ZERO : subAmount.divide(subQty, 10, 4);
        BigDecimal oldPrice = subEntry.getBigDecimal(this.SUBPRICE);
        this.getModel().beginInit();
        subEntry.set(this.SUBPRICE, (Object)subPrice);
        this.getModel().endInit();
        this.getView().updateView(this.SUBPRICE, rowIndex);
        if (subQty.compareTo(BigDecimal.ZERO) == 0) {
            Object entry2;
            BigDecimal price = BigDecimal.ZERO;
            for (Object entry2 : this.getModel().getEntryEntity(this.SUBENTRY)) {
                price = price.add(entry2.getBigDecimal(this.SUBPRICE));
            }
            BigDecimal amount = BigDecimal.ZERO;
            for (DynamicObject entry3 : this.getModel().getEntryEntity(this.SUBENTRY)) {
                amount = amount.add(entry3.getBigDecimal(this.SUBAMOUNT));
            }
            this.getModel().beginInit();
            entry2 = (DynamicObject)subEntry.getParent();
            entry2.set(this.PRICE, (Object)price);
            entry2.set(this.AMOUNT, (Object)amount);
            this.getModel().endInit();
            this.getView().updateView(this.PRICE, entryIdx);
            this.getView().updateView(this.AMOUNT, entryIdx);
            return;
        }
        BigDecimal curSubAmount = (BigDecimal)this.getModel().getValue(this.SUBAMOUNT, rowIndex);
        DynamicObject localCurrency = (DynamicObject)this.getModel().getValue(this.LOCALCURRENCY);
        int amtPrecision = localCurrency.getInt("amtprecision");
        BigDecimal oldSubAmount = oldPrice.multiply(subQty).setScale(amtPrecision, RoundingMode.HALF_UP);
        BigDecimal subAmountDiff = curSubAmount.subtract(oldSubAmount);
        DynamicObject entry = (DynamicObject)subEntry.getParent();
        BigDecimal newEntryAmount = entry.getBigDecimal(this.AMOUNT).add(subAmountDiff);
        entry.set(this.AMOUNT, (Object)newEntryAmount);
        entry.set(this.PRICE, (Object)newEntryAmount.divide(subQty, 10, RoundingMode.HALF_UP));
        this.getView().updateView(this.PRICE, entryIdx);
        this.getView().updateView(this.AMOUNT, entryIdx);
    }

    private void subCostOrDiffChanged(int rowIndex, PropertyChangedArgs e, String key) {
        DynamicObject subEntry = (DynamicObject)this.getModel().getEntryEntity(this.SUBENTRY).get(rowIndex);
        ChangeData[] valueSet = e.getChangeSet();
        BigDecimal newValue = DecimalHelper.getNotNullDecimal((BigDecimal)((BigDecimal)valueSet[0].getNewValue()));
        BigDecimal oldValue = DecimalHelper.getNotNullDecimal((BigDecimal)((BigDecimal)valueSet[0].getOldValue()));
        BigDecimal diff = newValue.subtract(oldValue);
        DynamicObject entry = (DynamicObject)subEntry.getParent();
        BigDecimal entryValue = entry.getBigDecimal(key);
        entry.set(key, (Object)entryValue.add(diff));
        int entryIdx = entry.getInt("seq") - 1;
        this.getView().updateView(key, entryIdx);
        DynamicObjectCollection subEntrys = this.getModel().getEntryEntity(this.SUBENTRY);
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue(this.COSTACCOUNT);
        boolean calByCostElement = ParamsHelper.getCostElementByCostAccount((long)costAccount.getLong("id"));
        boolean isStd = InitCalBillHelper.isStd((DynamicObject)costAccount, (String)entry.getString(this.ACCOUNTTYPE));
        if (this.SUBCOSTDIFF.equals(key) || this.COSTDIFF.equals(key)) {
            boolean createTypeEnable = false;
            for (DynamicObject subEnt : subEntrys) {
                BigDecimal subcostDiff = subEnt.getBigDecimal(this.SUBCOSTDIFF);
                if (subcostDiff.compareTo(BigDecimal.ZERO) == 0) continue;
                createTypeEnable = true;
                break;
            }
            if (createTypeEnable) {
                this.getView().setEnable(Boolean.TRUE, entryIdx, new String[]{this.CREATETYPE});
            } else {
                this.getModel().setValue(this.CREATETYPE, null, entryIdx);
                this.getView().setEnable(Boolean.FALSE, entryIdx, new String[]{this.CREATETYPE});
            }
        }
        this.setEnable4SubEntry(subEntrys.size(), isStd, calByCostElement);
    }

    private void yearQtyChanged(int rowIndex, String key) {
        DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity(this.ENTRY).get(rowIndex);
        DynamicObjectCollection subEntryColl = entry.getDynamicObjectCollection(this.SUBENTRY);
        if (subEntryColl == null || subEntryColl.isEmpty()) {
            return;
        }
        BigDecimal yearFieldValue = entry.getBigDecimal(key);
        for (DynamicObject subEntry : subEntryColl) {
            subEntry.set("sub_" + key, (Object)yearFieldValue);
        }
        this.getView().updateView(this.SUBENTRY);
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue(this.COSTACCOUNT);
        boolean calByCostElement = ParamsHelper.getCostElementByCostAccount((long)costAccount.getLong("id"));
        boolean isStd = InitCalBillHelper.isStd((DynamicObject)costAccount, (String)entry.getString(this.ACCOUNTTYPE));
        this.setEnable4SubEntry(subEntryColl.size(), isStd, calByCostElement);
    }

    private void ownerChanged(int rowIndex) {
        this.setAccountType(rowIndex);
    }

    private void acctypeChanged(int rowIndex, PropertyChangedArgs e) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue(this.COSTACCOUNT);
        DynamicObject material = (DynamicObject)this.getModel().getValue(this.MATERIAL, rowIndex);
        if (costAccount == null || material == null) {
            return;
        }
        boolean enableStd = costAccount.getBoolean("enablestandardcost");
        if (enableStd) {
            return;
        }
        ChangeData[] changeSet = e.getChangeSet();
        boolean calByCostElement = ParamsHelper.getCostElementByCostAccount((long)costAccount.getLong("id"));
        if (!AccountTypeEnum.STANDARDCOST.getValue().equals(changeSet[0].getOldValue()) && !AccountTypeEnum.STANDARDCOST.getValue().equals(changeSet[0].getNewValue())) {
            this.setEnable4Entry(costAccount, calByCostElement, rowIndex);
            return;
        }
        String accType = (String)this.getModel().getValue(this.ACCOUNTTYPE, rowIndex);
        BigDecimal price = this.buildSubEntry(rowIndex, material, accType, calByCostElement, false);
        DynamicObjectCollection subEntrys = ((DynamicObject)this.getModel().getEntryEntity(this.ENTRY).get(rowIndex)).getDynamicObjectCollection(this.SUBENTRY);
        if (!AccountTypeEnum.STANDARDCOST.getValue().equals(accType)) {
            this.getModel().setValue(this.PRICE, null, rowIndex);
            this.getModel().setValue(this.AMOUNT, null, rowIndex);
            this.getModel().setValue(this.COSTDIFF, null, rowIndex);
            this.getModel().setValue(this.YEARINCOSTDIFF, null, rowIndex);
            this.getModel().setValue(this.YEARISSUECOSTDIFF, null, rowIndex);
        } else {
            this.getModel().setValue(this.PRICE, (Object)price, rowIndex);
            this.getView().updateView(this.PRICE, rowIndex);
        }
        this.getView().updateView(this.SUBENTRY);
        this.setEnable4Entry(costAccount, calByCostElement, rowIndex);
        this.setEnable4SubEntry(subEntrys.size(), InitCalBillHelper.isStd((boolean)enableStd, (String)accType), calByCostElement);
    }

    private void baseQtyChanged(int rowIndex) {
        this.priceOrQtyChanged(rowIndex);
        BigDecimal baseQty = (BigDecimal)this.getModel().getValue(this.BASEQTY, rowIndex);
        DynamicObjectCollection subEntryColl = ((DynamicObject)this.getModel().getEntryEntity(this.ENTRY).get(rowIndex)).getDynamicObjectCollection(this.SUBENTRY);
        if (subEntryColl == null || subEntryColl.isEmpty()) {
            return;
        }
        DynamicObject localCurrency = (DynamicObject)this.getModel().getValue(this.LOCALCURRENCY);
        for (DynamicObject subEntry : subEntryColl) {
            subEntry.set("sub_baseqty", (Object)baseQty);
            BigDecimal subEntryPrice = subEntry.getBigDecimal("sub_price");
            if (BigDecimal.ZERO.compareTo(subEntryPrice) == 0) {
                BigDecimal sub_amount = subEntry.getBigDecimal("sub_amount");
                if (BigDecimal.ZERO.compareTo(sub_amount) == 0) continue;
                subEntry.set("sub_price", (Object)sub_amount.divide(baseQty, 10, 4));
                continue;
            }
            subEntry.set("sub_amount", (Object)subEntryPrice.multiply(baseQty).setScale(localCurrency.getInt("amtprecision"), RoundingMode.HALF_UP));
        }
        this.getView().updateView(this.SUBENTRY);
        DynamicObject costaccount = (DynamicObject)this.getModel().getValue(this.COSTACCOUNT);
        boolean isStd = InitCalBillHelper.isStd((DynamicObject)costaccount, (String)((String)this.getModel().getValue(this.ACCOUNTTYPE, rowIndex)));
        boolean calByCostElement = ParamsHelper.getCostElementByCostAccount((long)costaccount.getLong("id"));
        if (calByCostElement) {
            BigDecimal amount = BigDecimal.ZERO;
            for (DynamicObject subEntry : subEntryColl) {
                amount = amount.add(subEntry.getBigDecimal("sub_amount"));
            }
            amount = amount.setScale(localCurrency.getInt("amtprecision"), RoundingMode.HALF_UP);
            this.getModel().beginInit();
            this.getModel().setValue(this.AMOUNT, (Object)amount, rowIndex);
            this.getModel().endInit();
            this.getView().updateView(this.AMOUNT, rowIndex);
        }
        this.setEnable4SubEntry(subEntryColl.size(), isStd, calByCostElement);
    }

    private void priceOrQtyChanged(int rowIndex) {
        BigDecimal pagePrice = (BigDecimal)this.getModel().getValue(this.PRICE, rowIndex);
        BigDecimal baseQty = (BigDecimal)this.getModel().getValue(this.BASEQTY, rowIndex);
        DynamicObject localCurrency = (DynamicObject)this.getModel().getValue(this.LOCALCURRENCY);
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue(this.COSTACCOUNT);
        if (localCurrency == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u4f4d\u5e01\u4e3a\u7a7a", (String)"InitCalBillEditPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        BigDecimal amount = pagePrice.multiply(baseQty).setScale(localCurrency.getInt("amtprecision"), RoundingMode.HALF_UP);
        this.getModel().beginInit();
        this.getModel().setValue(this.AMOUNT, (Object)amount, rowIndex);
        this.getView().updateView(this.AMOUNT, rowIndex);
        this.getModel().endInit();
        boolean calByCostElement = ParamsHelper.getCostElementByCostAccount((long)costAccount.getLong("id"));
        if (calByCostElement) {
            DynamicObjectCollection subEntryColl = ((DynamicObject)this.getModel().getEntryEntity(this.ENTRY).get(rowIndex)).getDynamicObjectCollection(this.SUBENTRY);
            amount = BigDecimal.ZERO;
            for (DynamicObject subEntry : subEntryColl) {
                amount = amount.add(subEntry.getBigDecimal("sub_amount"));
            }
            amount = amount.setScale(localCurrency.getInt("amtprecision"), RoundingMode.HALF_UP);
            this.getModel().beginInit();
            this.getModel().setValue(this.AMOUNT, (Object)amount, rowIndex);
            this.getModel().endInit();
            this.getView().updateView(this.AMOUNT, rowIndex);
        }
    }

    private void amountChanged(int rowIndex) {
        BigDecimal amount = (BigDecimal)this.getModel().getValue(this.AMOUNT, rowIndex);
        BigDecimal baseQty = (BigDecimal)this.getModel().getValue(this.BASEQTY, rowIndex);
        if (amount.compareTo(BigDecimal.ZERO) != 0 && baseQty.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal price = amount.divide(baseQty, 10, RoundingMode.HALF_UP);
            this.getModel().beginInit();
            this.getModel().setValue(this.PRICE, (Object)price, rowIndex);
            this.getView().updateView(this.PRICE, rowIndex);
            this.getModel().endInit();
        } else if (amount.compareTo(BigDecimal.ZERO) == 0) {
            this.getModel().beginInit();
            this.getModel().setValue(this.PRICE, null, rowIndex);
            this.getView().updateView(this.PRICE, rowIndex);
            this.getModel().endInit();
        }
    }

    private void locationChanged(int rowIndex) {
        this.setAccountType(rowIndex);
    }

    private void storageorgunitChanged(int rowIndex) {
        this.getModel().setValue(this.MATERIAL, null, rowIndex);
        this.getModel().setValue(this.WAREHOUSE, null, rowIndex);
        this.getModel().setValue(this.LOCATION, null, rowIndex);
    }

    private void warehouseChanged(int rowIndex) {
        this.getModel().setValue(this.LOCATION, null, rowIndex);
        this.setAccountType(rowIndex);
        this.setLocation(rowIndex);
    }

    private void setLocation(int rowIndex) {
        DynamicObject warehouse = (DynamicObject)this.getModel().getValue(this.WAREHOUSE, rowIndex);
        if (warehouse == null) {
            return;
        }
        List ids = SCMHelper.getAllLocationIDs((DynamicObject)warehouse);
        if (ids.isEmpty()) {
            if (warehouse.getBoolean("isopenlocation")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)MessageFormat.format("\u5206\u5f55\u7b2c\u3010{0}\u3011\u884c\u4ed3\u5e93\u5df2\u542f\u7528\u4ed3\u4f4d\u7ba1\u7406\uff0c\u4f46\u672a\u627e\u5230\u4ed3\u4f4d\uff0c\u8bf7\u5148\u914d\u7f6e\u4ed3\u4f4d\u3002", rowIndex + 1), (String)"InitCalBillEditPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{this.LOCATION});
            }
        } else {
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{this.LOCATION});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        int rowIndex = e.getRow();
        if (this.STORAGEORGUNIT.equals(key)) {
            this.beforeF7Select4Storageorg(e);
        } else if (this.COSTACCOUNT.equals(key)) {
            this.beforeF7Select4CostAccount(e);
        } else if (this.OWNER.equals(key)) {
            this.beforeF7Select4Owner(e);
        } else if (this.WAREHOUSE.equals(key)) {
            this.beforeF7Select4Warehouse(e, rowIndex);
        } else if (this.LOCATION.equals(key)) {
            this.beforeF7Select4Location(e, rowIndex);
        } else if (this.MATERIAL.equals(key)) {
            this.beforeF7Select4Material(rowIndex);
        } else if (this.INVTYPE.equals(key)) {
            this.beforeF7Select4Invtype(e);
        } else if (this.MVERSION.equals(key)) {
            this.beforeF7Select4Mversion(e, rowIndex);
        } else if ("configuredcode".equals(key)) {
            this.beforF7SelectConfigureCode(e);
        }
    }

    private void beforF7SelectConfigureCode(BeforeF7SelectEvent e) {
        DynamicObject material = (DynamicObject)this.getModel().getValue("material", e.getRow());
        if (material == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u3002", (String)"CostAdjustBillPlugin_5", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        Long materialId = material.getLong("id");
        QFilter matFilter = new QFilter("material", "=", (Object)materialId);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(matFilter);
    }

    private void beforeF7Select4Mversion(BeforeF7SelectEvent e, int rowIndex) {
        DynamicObject material = (DynamicObject)this.getModel().getValue(this.MATERIAL, rowIndex);
        if (material == null) {
            String errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c{0}\u884c\u7269\u6599\u672a\u5f55\u5165\u3002", (String)"InitCalBillEditPlugin_21", (String)"fi-cal-formplugin", (Object[])new Object[0]), rowIndex + 1);
            throw new KDBizException(errorMsg);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(new QFilter("material", "=", (Object)material.getLong("id")));
    }

    private void beforeF7Select4Invtype(BeforeF7SelectEvent e) {
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(new QFilter("isforwardamount", "=", (Object)Boolean.TRUE));
    }

    private void beforeF7Select4Material(int rowIndex) {
        DynamicObject storageorgunit = (DynamicObject)this.getModel().getValue(this.STORAGEORGUNIT, rowIndex);
        if (storageorgunit == null) {
            this.getModel().setValue(this.MATERIAL, null, rowIndex);
            String errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c{0}\u884c\u5e93\u5b58\u7ec4\u7ec7\u672a\u5f55\u5165\u3002", (String)"InitCalBillEditPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]), rowIndex + 1);
            throw new KDBizException(errorMsg);
        }
    }

    private void beforeF7Select4Location(BeforeF7SelectEvent e, int rowIndex) {
        DynamicObject warehouse = (DynamicObject)this.getModel().getValue(this.WAREHOUSE, rowIndex);
        List ids = SCMHelper.getAllLocationIDs((DynamicObject)warehouse);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(new QFilter("id", "in", (Object)ids));
    }

    private void beforeF7Select4Warehouse(BeforeF7SelectEvent e, int rowIndex) {
        HashSet<Long> warehouseIdSet = new HashSet<Long>();
        DynamicObject storageOrg = (DynamicObject)this.getModel().getValue(this.STORAGEORGUNIT, rowIndex);
        if (storageOrg == null) {
            String errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c{0}\u884c\u5e93\u5b58\u7ec4\u7ec7\u672a\u5f55\u5165\u3002", (String)"InitCalBillEditPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]), rowIndex + 1);
            throw new KDBizException(errorMsg);
        }
        QFilter orgfilter = new QFilter("org", "=", (Object)storageOrg.getLong("id"));
        orgfilter.and("startstatus", "=", (Object)"B");
        DynamicObjectCollection warehouseColl = QueryServiceHelper.query((String)"im_warehousesetup", (String)"warehouse.id", (QFilter[])new QFilter[]{orgfilter});
        for (DynamicObject warehouse : warehouseColl) {
            warehouseIdSet.add(warehouse.getLong("warehouse.id"));
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(new QFilter("id", "in", warehouseIdSet));
    }

    private void materialChanged(int rowIndex) {
        DynamicObject costAcc = (DynamicObject)this.getModel().getValue(this.COSTACCOUNT);
        if (costAcc == null) {
            this.getModel().setValue(this.MATERIAL, null, rowIndex);
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InitCalBillEditPlugin_11", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        this.getModel().setValue("stocktype", null, rowIndex);
        DynamicObject storageorgunit = (DynamicObject)this.getModel().getValue(this.STORAGEORGUNIT, rowIndex);
        DynamicObject storageorgunitUp = (DynamicObject)this.getModel().getValue(this.STORAGEORGUNIT, rowIndex - 1);
        if (storageorgunit == null && storageorgunitUp != null) {
            storageorgunit = storageorgunitUp;
            this.getModel().beginInit();
            this.getModel().setValue(this.STORAGEORGUNIT, (Object)storageorgunitUp, rowIndex);
            this.getView().updateView(this.STORAGEORGUNIT, rowIndex);
            this.getView().updateView("storageorgunitname", rowIndex);
            this.getModel().endInit();
        }
        if (storageorgunit == null) {
            this.getModel().setValue(this.MATERIAL, null, rowIndex);
            String errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c{0}\u884c\u5e93\u5b58\u7ec4\u7ec7\u672a\u5f55\u5165\u3002", (String)"InitCalBillEditPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]), rowIndex + 1);
            throw new KDBizException(errorMsg);
        }
        DynamicObject materialInfo = (DynamicObject)this.getModel().getValue(this.MATERIAL, rowIndex);
        this.getModel().setValue("configuredcode", null, rowIndex);
        if (materialInfo == null) {
            this.getModel().setValue(this.BASEUNIT, null, rowIndex);
        }
        if (materialInfo != null) {
            long baseunitId = materialInfo.getLong("baseunit_id");
            this.getModel().setValue(this.BASEUNIT, (Object)baseunitId, rowIndex);
            this.getModel().beginInit();
            this.setAccountType(rowIndex);
            this.getModel().endInit();
            this.getView().updateView(this.CALRANGE, rowIndex);
            this.getView().updateView(this.CALDIMENSION, rowIndex);
            this.getView().updateView(this.ACCOUNTTYPE, rowIndex);
            String accType = (String)this.getModel().getValue(this.ACCOUNTTYPE, rowIndex);
            boolean calByCostElement = ParamsHelper.getCostElementByCostAccount((long)costAcc.getLong("id"));
            this.dealMaterialInf(materialInfo, storageorgunit, rowIndex);
            this.clearFieldAndSetPrice(rowIndex, true);
            this.getModel().beginInit();
            this.getModel().setValue(this.BASEQTY, null, rowIndex);
            this.getView().updateView(this.BASEQTY, rowIndex);
            this.getModel().endInit();
            BigDecimal price = this.buildSubEntry(rowIndex, materialInfo, accType, calByCostElement, false);
            this.getModel().setValue(this.PRICE, (Object)price, rowIndex);
            this.getView().updateView(this.PRICE, rowIndex);
            boolean enableStd = costAcc.getBoolean("enablestandardcost");
            boolean isStd = InitCalBillHelper.isStd((boolean)enableStd, (String)accType);
            this.setEnable4SingleEntry(calByCostElement, enableStd, rowIndex, (DynamicObject)this.getModel().getEntryEntity(this.ENTRY).get(rowIndex));
            this.getView().updateView(this.BASEUNIT, rowIndex);
            this.getModel().setValue(this.CREATETYPE, null, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{this.CREATETYPE});
            this.setEnable4SubEntry(this.getModel().getEntryRowCount(this.SUBENTRY), isStd, calByCostElement);
            this.getView().updateView(this.SUBENTRY);
        }
    }

    private BigDecimal buildSubEntry(int rowIndex, DynamicObject materialInfo, String accType, boolean calByCostElement, boolean saveOldDiff) {
        if (materialInfo == null) {
            return null;
        }
        IDataModel model = this.getModel();
        model.setEntryCurrentRowIndex(this.ENTRY, rowIndex);
        BigDecimal price = null;
        DynamicObject costAcc = (DynamicObject)model.getValue(this.COSTACCOUNT);
        long materialId = materialInfo.getLong("id");
        DynamicObject entry = (DynamicObject)model.getEntryEntity(this.ENTRY).get(rowIndex);
        DynamicObject curEntry = (DynamicObject)model.getEntryEntity(this.ENTRY).get(rowIndex);
        DynamicObjectCollection subEntryColl = curEntry.getDynamicObjectCollection(this.SUBENTRY);
        HashMap<Long, DynamicObject> subEleIdOldDycMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject subDyc : subEntryColl) {
            subEleIdOldDycMap.put(CommonUtils.getBaseId((DynamicObject)subDyc, (String)"costsubelement"), subDyc);
        }
        subEntryColl.clear();
        if (calByCostElement) {
            List allElement = CostElementHelper.getAllCostEle4InitBill();
            if (InitCalBillHelper.isStd((DynamicObject)costAcc, (String)accType)) {
                List<MaterialCostInfo> costInfoColl = this.maintainCostInfo(materialInfo, costAcc, materialId, curEntry);
                price = InitCalBillHelper.buildSubEntry4StdCalbyEle((DynamicObject)entry, (IDataModel)model, costInfoColl, (List)allElement);
                this.sumSubAmt2EntryAmt(model, entry, subEntryColl);
                if (saveOldDiff) {
                    this.backOldDiff(entry, subEleIdOldDycMap);
                }
                if (costInfoColl == null || costInfoColl.isEmpty()) {
                    return null;
                }
            } else {
                InitCalBillHelper.buildSubEntry4CalbyEle((DynamicObject)entry, (IDataModel)model, (List)allElement);
            }
        } else if (InitCalBillHelper.isStd((DynamicObject)costAcc, (String)accType)) {
            List<MaterialCostInfo> costInfoColl = this.maintainCostInfo(materialInfo, costAcc, materialId, curEntry);
            price = InitCalBillHelper.buildSubEntry4StdNotCalbyEle((DynamicObject)entry, (IDataModel)model, costInfoColl, (DynamicObject)costAcc);
            if (costInfoColl == null || costInfoColl.isEmpty()) {
                return null;
            }
        } else {
            InitCalBillHelper.buildSubEntry4NotStdNotbyEle((DynamicObject)entry, (IDataModel)model, (DynamicObject)costAcc);
        }
        return price;
    }

    private List<MaterialCostInfo> maintainCostInfo(DynamicObject materialInfo, DynamicObject costAcc, long materialId, DynamicObject curEntry) {
        Set calOrgCostTypeSet;
        ArrayList params;
        HashMap paramsMap = new HashMap(16);
        Set calDimensionSet = StandardCostHelper.getCalDimensionSet((String)CommonSettingHelper.getCalDimensionStr());
        DynamicObject costtype = costAcc.getDynamicObject("costtype");
        boolean assistAffect = InitCalBillHelper.assistAffectMatPrice((long)materialId);
        boolean calDimHasMatVer = InitCalBillHelper.calDimSetHasMatVer((long)curEntry.getLong("caldimension_id"));
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        DynamicObject initBillInfo = this.getModel().getDataEntity();
        Long calorgId = initBillInfo.getLong("calorg.id");
        Long costAccountId = initBillInfo.getLong("costaccount.id");
        String paramKey = calorgId + "_" + costAccountId;
        Long storageOrgId = curEntry.getLong("storageorgunit.id");
        Date bookdate = initBillInfo.getDate("bookdate");
        bookdate = DateUtils.getDayEndTime((Date)bookdate);
        Long curEntryId = curEntry.getLong("id");
        if (null == curEntryId || curEntryId == 0L) {
            param.put("uniqueID", ID.genLongId());
        } else {
            param.put("uniqueID", curEntry.getLong("id"));
        }
        param.put("uniqueID", curEntry.getLong("id"));
        param.put("invorg", storageOrgId);
        param.put("date", bookdate);
        param.put("material", materialId);
        String noupdatecalfields = MaterialNoUpdateFieldHelper.getNoupdateCalfieldBymateStoraId((long)materialId, (Long)storageOrgId);
        logger.info("InitCalBillEditPlugin maintainCostInfo noupdatecalfields=" + noupdatecalfields);
        if (calDimensionSet != null && calDimensionSet.size() > 0) {
            for (String calDimension : calDimensionSet) {
                if (StringUtils.isNotEmpty((String)noupdatecalfields) && noupdatecalfields.contains(calDimension)) continue;
                Object value = curEntry.get(calDimension);
                if (value != null) {
                    if (value instanceof DynamicObject) {
                        param.put(calDimension, ((DynamicObject)value).getPkValue());
                        continue;
                    }
                    param.put(calDimension, value);
                    continue;
                }
                param.put(calDimension, 0L);
            }
        }
        if (null == (params = (ArrayList)paramsMap.get(paramKey)) || params.size() == 0) {
            params = new ArrayList(16);
            params.add(param);
            paramsMap.put(paramKey, params);
        } else {
            params.add(param);
        }
        HashSet<Long> orgIds = new HashSet<Long>(2);
        orgIds.add(calorgId);
        orgIds.add(storageOrgId);
        Map orgCostTypeMap = ParamsHelper.getCostTypeByOrg(orgIds);
        String storageOrgKey = costAcc.getString("id") + "@" + storageOrgId;
        String calOrgKey = costAcc.getString("id") + "@" + calorgId;
        Object costTypeInfo = null;
        Set storageOrgCostTypeSet = (Set)orgCostTypeMap.get(storageOrgKey);
        if (storageOrgCostTypeSet != null && !storageOrgCostTypeSet.isEmpty()) {
            for (Object storageOrgCostType : storageOrgCostTypeSet) {
                if (!storageOrgCostType.getDate("effectdate").before(bookdate) || !storageOrgCostType.getDate("invaliddate").after(bookdate)) continue;
                costTypeInfo = storageOrgCostType;
                break;
            }
        }
        if (costTypeInfo == null && (calOrgCostTypeSet = (Set)orgCostTypeMap.get(calOrgKey)) != null && !calOrgCostTypeSet.isEmpty()) {
            for (DynamicObject calOrgCostType : calOrgCostTypeSet) {
                if (!calOrgCostType.getDate("effectdate").before(bookdate) || !calOrgCostType.getDate("invaliddate").after(bookdate)) continue;
                costTypeInfo = calOrgCostType;
                break;
            }
        }
        if (costTypeInfo == null) {
            return null;
        }
        DataSet standardCostDataSet = new StandardCostHelper().getStandardCost(paramsMap, false);
        if (standardCostDataSet.isEmpty()) {
            if (assistAffect && curEntry.get("assist") == null || calDimHasMatVer && curEntry.get(this.MVERSION) == null) {
                return null;
            }
            costtype = BusinessDataServiceHelper.loadSingle((Object)costTypeInfo.getLong("costtype.id"), (String)"cad_costtype", (String)"name");
            String errMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u6ca1\u6709\u7ef4\u62a4\u6210\u672c\u7c7b\u578b\u4e3a\u201c%2$s\u201d\u7684\u7269\u6599\u6210\u672c\u4fe1\u606f\u3002", (String)"InitCalBillEditPlugin_25", (String)"fi-cal-formplugin", (Object[])new Object[0]), materialInfo.getString("name"), costtype.getString("name"));
            this.getView().showErrorNotification(errMsg);
            return null;
        }
        ArrayList<MaterialCostInfo> materialCostInfos = new ArrayList<MaterialCostInfo>(8);
        for (Row costInfo : standardCostDataSet) {
            materialCostInfos.add(new MaterialCostInfo(costInfo.getLong("element").longValue(), costInfo.getLong("subelement").longValue(), costInfo.getBigDecimal("standardprice")));
        }
        return materialCostInfos;
    }

    private void dealMaterialInf(DynamicObject materialInfo, DynamicObject storageorg, int rowIndex) {
        DynamicObject materialInvInfo = MaterialHelper.getMaterialInvInf4Org((DynamicObject)materialInfo, (String)"createorg,enablelot", (long)storageorg.getLong("id"));
        boolean enablelot = false;
        if (materialInvInfo != null) {
            enablelot = materialInvInfo.getBoolean("enablelot");
        }
        boolean isuseauxpty = materialInfo.getBoolean("isuseauxpty");
        this.getView().setEnable(Boolean.valueOf(isuseauxpty), rowIndex, new String[]{this.ASSIST});
        this.getView().setEnable(Boolean.valueOf(enablelot), rowIndex, new String[]{this.LOT});
        if (!isuseauxpty) {
            this.getModel().setValue(this.ASSIST, null, rowIndex);
        }
        if (!enablelot) {
            this.getModel().setValue(this.LOT, null, rowIndex);
        }
        this.getModel().setValue(this.MVERSION, null, rowIndex);
    }

    private void clearFieldAndSetPrice(int rowIndex, boolean needClearDiff) {
        this.getModel().beginInit();
        this.getModel().setValue(this.AMOUNT, null, rowIndex);
        this.getView().updateView(this.AMOUNT, rowIndex);
        if (needClearDiff) {
            this.getModel().setValue(this.COSTDIFF, null, rowIndex);
            this.getView().updateView(this.COSTDIFF, rowIndex);
        }
        this.getModel().endInit();
    }

    private void setEnable4SubEntry(int subEntryCounts, boolean isStd, boolean calByCostElement) {
        if (!calByCostElement) {
            this.getView().setVisible(Boolean.FALSE, new String[]{this.SUBENTRY});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{this.SUBENTRY});
        DynamicObjectCollection subEntry = this.getModel().getEntryEntity(this.SUBENTRY);
        for (int i = 0; i < subEntryCounts; ++i) {
            if (isStd) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{this.SUBPRICE});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{this.SUBAMOUNT});
                if (((DynamicObject)subEntry.get(i)).getBigDecimal(this.SUBPRICE).compareTo(BigDecimal.ZERO) != 0) continue;
                this.getView().setEnable(Boolean.FALSE, i, new String[]{this.SUBCOSTDIFF, this.SUBYEARINCOST, this.SUBYEARINCOSTDIFF, this.SUBYEARISSUECOST, this.SUBYEARISSUECOSTDIFF});
                continue;
            }
            this.getView().setEnable(Boolean.FALSE, i, new String[]{this.SUBCOSTDIFF, this.SUBYEARINCOSTDIFF, this.SUBYEARISSUECOSTDIFF});
        }
        this.setSubAmtEnable(subEntryCounts, isStd, calByCostElement);
    }

    private void setEnable4SubEntryPriceAmt(int rowIdx) {
        DynamicObject costaccount = (DynamicObject)this.getModel().getValue(this.COSTACCOUNT);
        boolean isStd = InitCalBillHelper.isStd((DynamicObject)costaccount, (String)((DynamicObject)this.getModel().getEntryEntity(this.ENTRY).get(rowIdx)).getString(this.ACCOUNTTYPE));
        boolean calByCostElement = ParamsHelper.getCostElementByCostAccount((long)costaccount.getLong("id"));
        Boolean ispresent = (Boolean)this.getModel().getValue(this.ISPRESENT, rowIdx);
        this.setEnable4SubEntry(this.getModel().getEntryRowCount(this.SUBENTRY), isStd, calByCostElement);
        if (!isStd && ispresent.booleanValue()) {
            if (!calByCostElement) {
                this.getView().setVisible(Boolean.FALSE, new String[]{this.SUBENTRY});
                return;
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{this.SUBENTRY});
            for (int i = 0; i < this.getModel().getEntryRowCount(this.SUBENTRY); ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{this.SUBPRICE, this.SUBAMOUNT});
            }
        }
    }

    private void setAccountType(int rowIndex) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costAccount");
        DynamicObject material = (DynamicObject)this.getModel().getValue(this.MATERIAL, rowIndex);
        if (costAccount == null || material == null) {
            return;
        }
        Long divideBasisId = costAccount.getLong("dividebasis.id");
        DynamicObject divideBasis = QueryServiceHelper.queryOne((String)"cal_bd_dividebasis", (String)"dividebasis", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)divideBasisId)});
        String divideBasisStr = divideBasis.getString("dividebasis");
        HashSet<String> divideBasisSet = new HashSet<String>(Arrays.asList(divideBasisStr.split(",")));
        MainEntityType initCalEntityType = EntityMetadataCache.getDataEntityType((String)"cal_initbill");
        HashMap<String, Object> divBasisMap = new HashMap<String, Object>(8);
        for (String divideField : divideBasisSet) {
            if (initCalEntityType.findProperty(divideField).getParent() instanceof EntryType) {
                divBasisMap.put(divideField, this.getModel().getValue(divideField, rowIndex));
                continue;
            }
            divBasisMap.put(divideField, this.getModel().getValue(divideField));
        }
        if (divideBasisSet.contains(this.LOCATION) && this.getModel().getValue(this.LOCATION, rowIndex) == null) {
            divBasisMap.put(this.LOCATION, 0);
        }
        divBasisMap.put("dividebasisStr", divideBasisStr);
        CalRangeInfo resultInfo = AccountType4InitCalBillHelper.getCalRangeInfo((DynamicObject)costAccount, divBasisMap, (DynamicObject)((DynamicObject)this.getModel().getValue(this.MATERIAL, rowIndex)));
        this.getModel().setValue(this.CALRANGE, (Object)resultInfo.getCalRange(), rowIndex);
        this.getModel().setValue(this.CALDIMENSION, (Object)resultInfo.getCalDimension(), rowIndex);
        this.getModel().setValue(this.ACCOUNTTYPE, (Object)resultInfo.getAccountType(), rowIndex);
    }

    private void bizDateChanged() {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        bizDate = DateUtils.getDayStartTime((Date)bizDate);
        this.getModel().setValue("bookdate", (Object)bizDate);
        if (costAccount == null || bizDate == null) {
            return;
        }
        DynamicObject period = PeriodHelper.getStartPeriod((Long)costAccount.getLong("id"));
        if (period == null) {
            String errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c{0}\u201d\u672a\u8bbe\u7f6e\u542f\u7528\u671f\u95f4\uff0c\u8bf7\u5728\u6838\u7b97\u671f\u95f4\u8bbe\u7f6e\u4e2d\u8fdb\u884c\u8bbe\u7f6e\u3002", (String)"InitCalBillEditPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]), costAccount.get("name"));
            this.getView().showErrorNotification(errorMsg);
        } else {
            this.getModel().setValue("period", (Object)period.getLong("id"));
        }
        boolean enableStd = costAccount.getBoolean("enablestandardcost");
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(this.ENTRY);
        if (enableStd || AccountTypeEnum.STANDARDCOST.getValue().equals(((DynamicObject)entrys.get(0)).getString(this.ACCOUNTTYPE))) {
            this.handleSubEntry(costAccount);
            this.getView().updateView(this.ENTRY);
        }
    }

    private void costAccountChanged(PropertyChangedArgs e) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            this.getModel().getEntryEntity(this.SUBENTRY).clear();
            this.getView().setVisible(Boolean.FALSE, new String[]{this.SUBENTRY});
            this.getView().updateView(this.SUBENTRY);
            return;
        }
        this.setLocalCurrency("calpolicy_id", costAccount);
        AccountType4CostAdjustHelper helper = new AccountType4CostAdjustHelper(new DynamicObject[]{this.getModel().getDataEntity(true)});
        helper.handleCalRangeAccType4InitBill();
        boolean enableStd = costAccount.getBoolean("enablestandardcost");
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(this.ENTRY);
        ChangeData changeData = e.getChangeSet()[0];
        DynamicObject newAcc = (DynamicObject)changeData.getNewValue();
        DynamicObject oldAcc = (DynamicObject)changeData.getOldValue();
        boolean calByCostElement = ParamsHelper.getCostElementByCostAccount((long)costAccount.getLong("id"));
        if (oldAcc != null && oldAcc.getBoolean("enablestandardcost") && !newAcc.getBoolean("enablestandardcost") || calByCostElement) {
            for (int i = 0; i < entrys.size(); ++i) {
                this.clearPriceAndDiff(enableStd, i, (DynamicObject)entrys.get(i));
            }
        }
        this.handleSubEntry(costAccount);
        this.getView().updateView(this.ENTRY);
        if (calByCostElement) {
            this.getView().setVisible(Boolean.TRUE, new String[]{this.SUBENTRY});
            if (entrys.size() > 0) {
                this.setEnable4SubEntryPriceAmt(0);
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{this.SUBENTRY});
        }
    }

    private void clearPriceAndDiff(boolean accEnableStd, int i, DynamicObject entry) {
        if (!InitCalBillHelper.isStd((boolean)accEnableStd, (String)entry.getString(this.ACCOUNTTYPE))) {
            this.getModel().setValue(this.PRICE, null, i);
            this.getModel().setValue(this.AMOUNT, null, i);
            this.getModel().setValue(this.COSTDIFF, null, i);
            this.getModel().setValue(this.CREATETYPE, null, i);
            this.getModel().setValue(this.YEARINCOSTDIFF, null, i);
            this.getModel().setValue(this.YEARISSUECOSTDIFF, null, i);
        }
    }

    private void beforeF7Select4Owner(BeforeF7SelectEvent e) {
        DynamicObject costAccountDyc = (DynamicObject)this.getModel().getValue("costaccount");
        Long[] owners = costAccountDyc == null ? new Long[]{} : AccountingSysHelper.getOwners((Long)((Long)costAccountDyc.getPkValue()));
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(new QFilter("id", "in", (Object)owners));
    }

    private void beforeF7Select4CostAccount(BeforeF7SelectEvent e) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        if (calOrg != null) {
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(new QFilter("calorg", "=", (Object)calOrg.getLong("id")));
        }
    }

    private void beforeF7Select4Storageorg(BeforeF7SelectEvent e) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        List storageOrgIdList = new ArrayList();
        if (calOrg != null) {
            storageOrgIdList = OrgHelper.getStorageOrgUnitByCalOrg((Long)calOrg.getLong("id"));
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(new QFilter("id", "in", storageOrgIdList));
    }

    public void initImportData(InitImportDataEventArgs e) {
        List sourceDataList = e.getSourceDataList();
        for (Map sourceData : sourceDataList) {
            sourceData.put("billstatus", "A");
            sourceData.put("billcretype", "import");
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String key = evt.getFieldName();
        if (!"srcbillnum".equals(key)) {
            return;
        }
        EntryGrid entry = (EntryGrid)evt.getSource();
        Object entryId = entry.getEntryData().getDataEntitys()[0].getPkValue();
        DynamicObject calInitBillInfo = BusinessDataServiceHelper.loadSingle((String)"cal_initbill", (String)"id,bizbillid,bizentityobject", (QFilter[])new QFilter[]{new QFilter("entryentity.id", "=", entryId)});
        if (calInitBillInfo.getDynamicObject("bizentityobject") == null || !QueryServiceHelper.exists((String)calInitBillInfo.getDynamicObject("bizentityobject").getString("number"), (Object)calInitBillInfo.get("bizbillid"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5173\u8054\u7684\u4e1a\u52a1\u5355\u636e\u3002", (String)"CostRecordListPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setPkId(calInitBillInfo.get("bizbillid"));
        showParameter.setFormId(calInitBillInfo.getDynamicObject("bizentityobject").getString("number"));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        for (String str : f7Name) {
            BasedataEdit f7Control = (BasedataEdit)this.getView().getControl(str);
            if (null == f7Control) continue;
            f7Control.addBeforeF7SelectListener(form);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperateKey().equals("audit") && e.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void setEnableEntry(int entryCounts, boolean calByCostElement) {
        for (int i = 0; i < entryCounts; ++i) {
            String accountType = (String)this.getModel().getValue(this.ACCOUNTTYPE, i);
            if (AccountTypeEnum.STANDARDCOST.getValue().equals(accountType)) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{this.PRICE, this.AMOUNT, this.COSTDIFF});
            } else if (calByCostElement) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{this.PRICE, this.AMOUNT, this.COSTDIFF});
            } else {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{this.COSTDIFF});
            }
            String srcbizentityobject = (String)this.getModel().getValue("srcbizentityobject", i);
            Boolean ispresent = (Boolean)this.getModel().getValue(this.ISPRESENT, i);
            if (!"im_initbill".equals(srcbizentityobject)) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{this.ISPRESENT});
            if (!ispresent.booleanValue()) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{this.PRICE, this.AMOUNT, this.COSTDIFF});
        }
    }

    private void ispresentChanged(int rowIndex) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue(this.COSTACCOUNT);
        boolean calByCostElement = ParamsHelper.getCostElementByCostAccount((long)costAccount.getLong("id"));
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(this.ENTRY);
        this.getModel().setEntryCurrentRowIndex(this.ENTRY, rowIndex);
        DynamicObject entry = (DynamicObject)entrys.get(rowIndex);
        DynamicObjectCollection subEntryColl = entry.getDynamicObjectCollection("subentryentity");
        Boolean ispresent = (Boolean)this.getModel().getValue(this.ISPRESENT, rowIndex);
        if (ispresent.booleanValue()) {
            String accounttype = (String)this.getModel().getValue(this.ACCOUNTTYPE, rowIndex);
            if (AccountTypeEnum.STANDARDCOST.getValue().equals(accounttype)) {
                for (int i = 0; i < subEntryColl.getRowCount(); ++i) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{this.SUBAMOUNT});
                }
                this.handleSubEntry((DynamicObject)this.getModel().getValue(this.COSTACCOUNT));
            } else {
                if (calByCostElement) {
                    for (int i = 0; i < subEntryColl.getRowCount(); ++i) {
                        this.getView().setEnable(Boolean.FALSE, i, new String[]{this.SUBPRICE});
                        this.getView().setEnable(Boolean.FALSE, i, new String[]{this.SUBAMOUNT});
                        this.getModel().setValue(this.SUBPRICE, (Object)BigDecimal.ZERO, i);
                    }
                }
                this.getModel().setValue(this.PRICE, (Object)0, rowIndex);
                this.getModel().setValue(this.AMOUNT, (Object)0, rowIndex);
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{this.AMOUNT, this.PRICE});
            }
        } else if (calByCostElement) {
            for (int i = 0; i < subEntryColl.getRowCount(); ++i) {
                this.getView().setEnable(Boolean.TRUE, i, new String[]{this.SUBPRICE});
                this.getView().setEnable(Boolean.TRUE, i, new String[]{this.SUBAMOUNT});
            }
        } else {
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{this.AMOUNT, this.PRICE});
        }
    }

    private void setSubAmtEnable(int subEntryCounts, boolean isStd, boolean calByCostElement) {
        if (!calByCostElement || isStd) {
            return;
        }
        Set disableSubElement = CostElementHelper.getDisableSubElement();
        DynamicObjectCollection subEntry = this.getModel().getEntryEntity(this.SUBENTRY);
        for (int i = 0; i < subEntryCounts; ++i) {
            Long subElementId = ((DynamicObject)subEntry.get(i)).getDynamicObject("costsubelement").getLong("id");
            this.getModel().beginInit();
            if (disableSubElement.contains(subElementId)) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{this.SUBAMOUNT, this.SUBPRICE, this.SUBYEARINCOST, this.SUBYEARISSUECOST});
            } else {
                this.getView().setEnable(Boolean.TRUE, i, new String[]{this.SUBAMOUNT, this.SUBPRICE, this.SUBYEARINCOST, this.SUBYEARISSUECOST});
            }
            this.getModel().endInit();
        }
    }

    private void sumSubAmt2EntryAmt(IDataModel model, DynamicObject entry, DynamicObjectCollection subEntryColl) {
        BigDecimal entryAmt = BigDecimal.ZERO;
        for (DynamicObject subEntry : subEntryColl) {
            entryAmt = entryAmt.add(subEntry.getBigDecimal("sub_amount"));
        }
        DynamicObject localCurrency = (DynamicObject)model.getValue("localcurrency");
        entryAmt = entryAmt.setScale(localCurrency.getInt("amtprecision"), RoundingMode.HALF_UP);
        entry.set("amount", (Object)entryAmt);
    }

    private void backOldDiff(DynamicObject entry, Map<Long, DynamicObject> subEleIdOldDycMap) {
        DynamicObjectCollection newSubDycs = entry.getDynamicObjectCollection(this.SUBENTRY);
        for (DynamicObject newSubDyc : newSubDycs) {
            DynamicObject oldSubDyc = subEleIdOldDycMap.get(CommonUtils.getBaseId((DynamicObject)newSubDyc, (String)"costsubelement"));
            if (oldSubDyc == null) continue;
            newSubDyc.set(this.SUBCOSTDIFF, (Object)oldSubDyc.getBigDecimal(this.SUBCOSTDIFF));
        }
    }
}

