/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.bill;

import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.calculate.out.calintime.CalInTimeRptLinkHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.formplugin.base.CalOrgAcctLinkListPlugin;

public class InitCalBillListPlugin
extends CalOrgAcctLinkListPlugin {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_DEBUG_MODEL).booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_updatestocktype"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_updatestocktype"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"_toolbar_"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] ids = selectedRows.getPrimaryKeyValues();
        if ("tbl_viewbizbill".equals(key)) {
            this.showBizBill(ids);
        }
    }

    private void showBizBill(Object[] ids) {
        if (ids == null || ids.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CostRecordListPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        if (ids.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u652f\u6301\u52fe\u9009\u4e00\u6761\u6570\u636e\u8054\u67e5\u4e1a\u52a1\u5355\u636e\u3002", (String)"InitCalBillListPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        DynamicObject calInitBillInfo = BusinessDataServiceHelper.loadSingle((Object)ids[0], (String)"cal_initbill", (String)"id,bizbillid,bizentityobject");
        if (calInitBillInfo.getDynamicObject("bizentityobject") == null || !QueryServiceHelper.exists((String)calInitBillInfo.getDynamicObject("bizentityobject").getString("number"), (Object)calInitBillInfo.get("bizbillid"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5173\u8054\u7684\u4e1a\u52a1\u5355\u636e\u3002", (String)"CostRecordListPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        this.linkBizBill(showParameter, calInitBillInfo);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getFieldName();
        if ("ecalstatus".equals(fieldName) || "calstatus".equals(fieldName)) {
            CalInTimeRptLinkHelper calInTimeRptLinkHelper = new CalInTimeRptLinkHelper(this.getView());
            calInTimeRptLinkHelper.link("cal_initbill", args);
            return;
        }
        if (!"srcbillnum".equals(args.getFieldName())) {
            return;
        }
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        Object pkId = billList.getFocusRowPkId();
        args.setCancel(true);
        DynamicObject calInitBillInfo = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"cal_initbill", (String)"id,bizbillid,bizentityobject");
        if (calInitBillInfo.getDynamicObject("bizentityobject") == null || !QueryServiceHelper.exists((String)calInitBillInfo.getDynamicObject("bizentityobject").getString("number"), (Object)calInitBillInfo.get("bizbillid"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5173\u8054\u7684\u4e1a\u52a1\u5355\u636e\u3002", (String)"CostRecordListPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        this.linkBizBill(showParameter, calInitBillInfo);
    }

    private void linkBizBill(BillShowParameter showParameter, DynamicObject calInitBillInfo) {
        showParameter.setPkId(calInitBillInfo.get("bizbillid"));
        showParameter.setFormId(calInitBillInfo.getDynamicObject("bizentityobject").getString("number"));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

