/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.bill;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.fi.cal.common.helper.CostElementHelper;

public class RepairBillCostDetailPlugin
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        super.beforeItemClick(e);
        String key = e.getItemKey();
        if ("repairdetail".equals(key)) {
            String formId = this.getModel().getDataEntityType().getName();
            if ("cal_costrecord_subentity".equals(formId)) {
                this.repairCostDetail4CostRecord();
            } else if ("cal_costadjust_subentity".equals(formId)) {
                this.repairCostDetail4CostAdjust();
            }
        }
    }

    private void repairCostDetail4CostAdjust() {
        List elements = CostElementHelper.getAllCostEle4InitBill();
        IDataModel model = this.getModel();
        Object currencyId = ((DynamicObject)model.getValue("currency")).getPkValue();
        DynamicObjectCollection entry = model.getEntryEntity("entryentity");
        for (int i = 0; i < entry.size(); ++i) {
            DynamicObject entryRow = (DynamicObject)entry.get(i);
            DynamicObjectCollection subentry = entryRow.getDynamicObjectCollection("subentryentity");
            HashSet<Long> exitSubElements = new HashSet<Long>(16);
            for (DynamicObject subEntryRow : subentry) {
                exitSubElements.add(subEntryRow.getLong("costsubelement.id"));
            }
            if (exitSubElements.size() == elements.size()) continue;
            Long materialId = entryRow.getLong("material.id");
            this.getModel().beginInit();
            model.setEntryCurrentRowIndex("entryentity", i);
            for (Long[] element : elements) {
                if (exitSubElements.contains(element[0])) continue;
                int subRowIndex = model.createNewEntryRow("subentryentity");
                model.setValue("costelement", (Object)element[1], subRowIndex);
                model.setValue("costsubelement", (Object)element[0], subRowIndex);
                model.setValue("sub_material", (Object)materialId, subRowIndex);
                model.setValue("sub_currency", currencyId, subRowIndex);
            }
            this.getModel().endInit();
            this.getView().updateView("subentryentity");
        }
    }

    private void repairCostDetail4CostRecord() {
        List elements = CostElementHelper.getAllCostEle4InitBill();
        IDataModel model = this.getModel();
        Object currencyId = ((DynamicObject)model.getValue("localcurrency")).getPkValue();
        DynamicObjectCollection entry = model.getEntryEntity("entry");
        for (int i = 0; i < entry.size(); ++i) {
            DynamicObject entryRow = (DynamicObject)entry.get(i);
            DynamicObjectCollection subentry = entryRow.getDynamicObjectCollection("subentrycostelement");
            HashSet<Long> exitSubElements = new HashSet<Long>(16);
            for (DynamicObject subEntryRow : subentry) {
                exitSubElements.add(subEntryRow.getLong("costsubelement.id"));
            }
            if (exitSubElements.size() == elements.size()) continue;
            Long materialId = entryRow.getLong("material.id");
            Long baseunit = entryRow.getLong("baseunit.id");
            BigDecimal baseqty = entryRow.getBigDecimal("baseqty");
            this.getModel().beginInit();
            model.setEntryCurrentRowIndex("entry", i);
            for (Long[] element : elements) {
                if (exitSubElements.contains(element[0])) continue;
                int subRowIndex = model.createNewEntryRow("subentrycostelement");
                model.setValue("costelement", (Object)element[1], subRowIndex);
                model.setValue("costsubelement", (Object)element[0], subRowIndex);
                model.setValue("sub_material", (Object)materialId, subRowIndex);
                model.setValue("sub_currency", currencyId, subRowIndex);
                model.setValue("sub_baseunit", (Object)baseunit, subRowIndex);
                model.setValue("sub_baseqty", (Object)baseqty, subRowIndex);
            }
            this.getModel().endInit();
            this.getView().updateView("subentrycostelement");
        }
    }
}

