/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.bill.costrecord;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.AppMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.formplugin.bill.costrecord.ICostRecordPageHelper;

public class CommonCostRecordPageHelper
implements ICostRecordPageHelper {
    @Override
    public List<Long> getAllPermOrgs() {
        String appInnerId;
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)(appInnerId = AppMetadataCache.getAppInfo((String)"cal").getId()), (String)"cal_costrecord_subentity", (String)this.getPerm());
        if (!rs.hasAllOrgPerm()) {
            return rs.getHasPermOrgs();
        }
        return null;
    }

    @Override
    public QFilter getDefaultListFilter(List<Long> orgIdlist) {
        return null;
    }

    @Override
    public String[] getHideColNames() {
        return new String[]{"billnumber", "period.number", "period.name", "isdischargevoucher", "dischargevouchernum", "iscostcarryover", "carryovervouchernum", "isfeevoucher", "feevouchernum", "writeofftype", "writeoffstatus", "writeoffdate", "issplit", "adjustamount", "localtax"};
    }

    @Override
    public String[] getHideButtonNames() {
        return new String[]{"tbl_fivoucher", "tbl_tempvoucher", "tbl_dischargevoucher", "tbl_carryovervoucher", "tbl_delvoucher", "tbl_deltempvoucher", "tbl_deldischargevoucher", "tbl_delcarryovervoucher", "tbl_feevoucher", "tbl_delfeevoucher", "bar_previewvoucher"};
    }

    public String getPerm() {
        return "47150e89000000ac";
    }

    public Map<DynamicObject, List<Long>> getPeriodMap(List<Long> costAccountList) {
        HashMap<DynamicObject, List<Long>> map = new HashMap<DynamicObject, List<Long>>(16);
        if (costAccountList != null) {
            for (long id : costAccountList) {
                DynamicObject period = PeriodHelper.getCurrentPeriod((Long)id);
                List costAccountIds = (List)map.get(period);
                if (costAccountIds != null) {
                    costAccountIds.add(id);
                    continue;
                }
                ArrayList<Long> list = new ArrayList<Long>();
                list.add(id);
                map.put(period, list);
            }
        }
        return map;
    }

    @Override
    public String getCaption() {
        return null;
    }

    public QFilter getPeriodFilter(Map<DynamicObject, List<Long>> map, String dateName, String periodCompareType) {
        QFilter q = QFilter.of((String)"1 <> 1", (Object[])new Object[0]);
        for (Map.Entry<DynamicObject, List<Long>> entry : map.entrySet()) {
            DynamicObject period = entry.getKey();
            QFilter q1 = new QFilter("costaccount", "in", entry.getValue());
            if (period != null) {
                if ("0".equals(periodCompareType)) {
                    q1.and(dateName, ">=", (Object)period.getDate("begindate"));
                } else if ("1".equals(periodCompareType)) {
                    q1.and(dateName, "<=", (Object)period.getDate("enddate"));
                } else if ("2".equals(periodCompareType)) {
                    q1.and(dateName, ">=", (Object)period.getDate("begindate"));
                    q1.and(dateName, "<=", (Object)period.getDate("enddate"));
                }
            } else {
                q1.and(QFilter.of((String)"1 <> 1", (Object[])new Object[0]));
            }
            q = q.or(q1);
        }
        return q;
    }

    public QFilter getPeriodFieldFilter(Map<DynamicObject, List<Long>> map, String periodName, String periodCompareType) {
        QFilter q = QFilter.of((String)"1 <> 1", (Object[])new Object[0]);
        for (Map.Entry<DynamicObject, List<Long>> entry : map.entrySet()) {
            DynamicObject period = entry.getKey();
            QFilter q1 = new QFilter("costaccount", "in", entry.getValue());
            if (period != null) {
                q1.and(periodName, periodCompareType, (Object)period.getLong("id"));
            } else {
                q1.and(QFilter.of((String)"1 <> 1", (Object[])new Object[0]));
            }
            q = q.or(q1);
        }
        return q;
    }

    public Map<Long, DynamicObject> getCostAccMap(List<Long> costAccountList) {
        HashMap<Long, DynamicObject> costAccMap = new HashMap<Long, DynamicObject>(costAccountList.size());
        for (Long costAccId : costAccountList) {
            DynamicObject period;
            if (costAccMap.get(costAccId) != null || (period = PeriodHelper.getCurrentPeriod((Long)costAccId)) == null) continue;
            costAccMap.put(costAccId, period);
        }
        return costAccMap;
    }
}

