/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.bill.costrecord;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.cal.common.enums.DischargeTypeEnum;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.WriteLogHelper;
import kd.fi.cal.formplugin.bill.costrecord.CommonCostRecordPageHelper;

public class PurTempCostRecordPageHelper
extends CommonCostRecordPageHelper {
    private static Log logger = LogFactory.getLog(PurTempCostRecordPageHelper.class);

    @Override
    public String getPerm() {
        return "/LRTO/JV2TYZ";
    }

    @Override
    public QFilter getDefaultListFilter(List<Long> costAccountList) {
        Map<DynamicObject, List<Long>> map = this.getPeriodMap(costAccountList);
        Long calOrgID = 0L;
        if (costAccountList != null && costAccountList.size() > 0) {
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_costaccount", (String)"calorg", (QFilter[])new QFilter("id", "=", (Object)costAccountList.get(0)).toArray(), null);
            for (Row row : dataSet) {
                calOrgID = row.getLong("calorg");
            }
        }
        String dischargeType = (String)SystemParamServiceHelper.getAppParameter((String)"/KIUHEXROK3D", (String)"10", (Long)calOrgID, (Long)0L, (String)"dischargetype");
        QFilter qfilter = null;
        if (DischargeTypeEnum.UNCLEAR.getValue().equals(dischargeType)) {
            return QFilter.of((String)"1 <> 1", (Object[])new Object[0]);
        }
        if (DischargeTypeEnum.BILLCOMECLEAR.getValue().equals(dischargeType)) {
            qfilter = new QFilter("dischargetype", "in", (Object)new String[]{DischargeTypeEnum.BILLCOMECLEAR.getValue()});
            qfilter.and("writeoffstatus", "in", (Object)new String[]{"B"});
            qfilter.and("isinitbill", "=", (Object)Boolean.FALSE);
            qfilter.and(this.getPeriodFilter(map, "bookdate", "2"));
        } else {
            qfilter = new QFilter("dischargetype", "in", (Object)new String[]{DischargeTypeEnum.BEGINPERIODCLEAR.getValue()});
            qfilter.and("writeoffstatus", "in", (Object)new String[]{"B", " "});
        }
        Set purBills = CommonSettingHelper.getBizEntityNumbers((String)"purbiztype");
        purBills.addAll(CommonSettingHelper.getBizEntityNumbers((String)"ominbiztype"));
        QFilter q = new QFilter("bizentityobject", "in", (Object)purBills);
        Map<Long, DynamicObject> costAccMap = this.getCostAccMap(costAccountList);
        DataSet costrecordDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,period,dischargetype,costaccount,bookdate,writeoffperiod,writeoffperiod.begindate as wbegindate,writeoffperiod.enddate as wenddate,writeoffendperiod,writeoffendperiod.begindate as wendbegindate,writeoffendperiod.enddate as wendenddate,writeoffstatus,issplit,issplitcreate", (QFilter[])new QFilter[]{q.and(qfilter)}, null);
        ArrayList<Long> idList = new ArrayList<Long>(4096);
        ArrayList<Long> verifyIdList = new ArrayList<Long>(2048);
        for (Row row : costrecordDs) {
            Long curPeriodId;
            String dischargetype = row.getString("dischargetype");
            Long costAccId = row.getLong("costaccount");
            DynamicObject period = costAccMap.get(costAccId);
            if (period == null) continue;
            if (DischargeTypeEnum.BEGINPERIODCLEAR.getValue().equals(dischargetype)) {
                Date bookdate = row.getDate("bookdate");
                Date curPeriodBegindate = period.getDate("begindate");
                Date curPeriodEnddate = period.getDate("enddate");
                Date wbegindate = row.getDate("wbegindate");
                boolean writeoff = true;
                if (wbegindate == null) {
                    writeoff = false;
                }
                long writeoffendperiod = row.getLong("writeoffendperiod");
                Date webegindate = row.getDate("wendbegindate");
                try {
                    if (!bookdate.before(curPeriodEnddate) && bookdate != curPeriodBegindate || writeoffendperiod != 0L && (!bookdate.before(webegindate) || !webegindate.after(curPeriodEnddate)) || writeoff && !wbegindate.before(curPeriodEnddate) && wbegindate != curPeriodEnddate) continue;
                    if (!row.getBoolean("issplit").booleanValue() && !row.getBoolean("issplitcreate").booleanValue()) {
                        idList.add(row.getLong("id"));
                        continue;
                    }
                    verifyIdList.add(row.getLong("id"));
                }
                catch (Exception e) {
                    WriteLogHelper.writeErrorLog((Log)logger, (String)"PurTempCostRecordPageHelper-getDefaultListFilter", (Throwable)e);
                }
                continue;
            }
            if (!DischargeTypeEnum.BILLCOMECLEAR.getValue().equals(dischargetype) || !(curPeriodId = Long.valueOf(period.getLong("id"))).equals(row.getLong("writeoffperiod"))) continue;
            idList.add(row.getLong("id"));
        }
        if (!verifyIdList.isEmpty()) {
            QFilter verifyQ = new QFilter("id", "in", verifyIdList);
            verifyQ.and(new QFilter("writeoffstatus", "in", (Object)new String[]{"B"}));
            DataSet costrecordMaxPeriodDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,writeoffperiod,billnumber", (QFilter[])new QFilter[]{verifyQ}, null).groupBy(new String[]{"billnumber"}).maxP("writeoffperiod", "id").finish();
            for (Row row : costrecordMaxPeriodDs) {
                idList.add(row.getLong("id"));
            }
        }
        return new QFilter("id", "in", idList);
    }

    @Override
    public String[] getHideColNames() {
        return new String[]{"billnumber", "period.number", "period.name", "storageorgunit.name", "iscostcarryover", "carryovervouchernum", "isfeevoucher", "feevouchernum", "ownertype", "owner.name", "assist", "lot", "project.number", "ispresent", "invtype.name", "invstatus.name", "warehouse.name", "location.name", "adjustamount", "localtax"};
    }

    @Override
    public String[] getHideButtonNames() {
        return new String[]{"tbl_fivoucher", "tbl_dischargevoucher", "tbl_carryovervoucher", "tbl_delvoucher", "tbl_deldischargevoucher", "tbl_delcarryovervoucher", "tbl_queryoutwriteoffrecord", "tbl_feevoucher", "tbl_delfeevoucher"};
    }

    @Override
    public String getCaption() {
        return ResManager.loadKDString((String)"\u91c7\u8d2d\u6682\u4f30\u51ed\u8bc1\u5904\u7406", (String)"PurTempCostRecordPageHelper_0", (String)"fi-cal-formplugin", (Object[])new Object[0]);
    }
}

