/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.calculate.feesharenew;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.util.DateUtils;
import kd.mpscmm.mscommon.writeoff.form.manual.IWfManualExtService;

public class CalFeeShareManualPlugin
extends AbstractFormPlugin
implements IWfManualExtService,
HyperLinkClickListener,
BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid mentryGrid = (EntryGrid)this.getView().getControl("entry_a");
        mentryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid sentryGrid = (EntryGrid)this.getView().getControl("entry_b");
        sentryGrid.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit wfscheme = (BasedataEdit)this.getControl("wfscheme");
        wfscheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit writeofftype = (BasedataEdit)this.getControl("writeofftype");
        writeofftype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setCalOrg();
        this.setCurrencyByOrg();
        this.bindShareCurrencyAndTable();
        this.setDateRange();
    }

    private void setDateRange() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar startDate = Calendar.getInstance();
        Calendar endDate = Calendar.getInstance();
        startDate.set(5, 1);
        endDate.set(5, endDate.getActualMaximum(5));
        this.getModel().setValue("startdate", (Object)sdf.format(startDate.getTime()));
        this.getModel().setValue("enddate", (Object)sdf.format(endDate.getTime()));
    }

    protected void bindShareCurrencyAndTable() {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        if (calOrg == null) {
            return;
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"bd_accountingsys_base", (String)"basecurrrency,exratetable", (QFilter[])new QFilter("baseacctorg.id", "=", calOrg.getPkValue()).toArray());
        if (obj == null) {
            this.getModel().setValue("sharecurrency", null);
            this.getModel().setValue("exratetable", null);
        } else {
            this.getModel().setValue("sharecurrency", (Object)obj.getDynamicObject("basecurrrency").getLong("id"));
            this.getModel().setValue("exratetable", (Object)obj.getDynamicObject("exratetable").getLong("id"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        String operateKey;
        super.beforeDoOperation(event);
        FormOperate formOperate = (FormOperate)event.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "wfmanual": {
                DynamicObject calorg = (DynamicObject)this.getModel().getValue("calorg");
                if (calorg == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CalSystemCtrlEditUIPlugin_47", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                }
                formOperate.getOption().setVariableValue("org", calorg.getString("id"));
                this.checkSelectRows();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (("wfauto".equals(operateKey) || "wfmanual".equals(operateKey)) && args.getOperationResult().isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u644a\u6210\u529f\uff0c\u8bf7\u67e5\u770b\u5206\u644a\u8bb0\u5f55\u3002", (String)"CalWfManualPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("calorg".equals(name)) {
            this.setCurrencyByOrg();
            this.bindShareCurrencyAndTable();
        } else if ("writeofftype".equals(name)) {
            this.writeOffTypeChanged();
        }
    }

    private void writeOffTypeChanged() {
        this.getModel().deleteEntryData("entry_a");
        this.getModel().deleteEntryData("entry_b");
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String newvalue;
        super.beforeFieldPostBack(e);
        Object source = e.getSource();
        if (source instanceof AmountEdit && "e_unallocatedamt_cur_a".equals(((AmountEdit)source).getKey()) && (StringUtils.isEmpty((String)(newvalue = (String)e.getValue())) || new BigDecimal(newvalue).compareTo(BigDecimal.ZERO) == 0)) {
            e.setCancel(true);
            this.getView().updateView("e_unallocatedamt_cur_a", this.getModel().getEntryCurrentRowIndex("entry_a"));
            String msg = ResManager.loadKDString((String)"\u672c\u6b21\u5206\u644a\u91d1\u989d\u4e0d\u80fd\u4e3a\u96f6\u3002", (String)"CalWfManualPlugin_4", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
        }
    }

    private void checkSelectRows() {
        EntryGrid entryGridA = (EntryGrid)this.getControl("entry_a");
        EntryGrid entryGridB = (EntryGrid)this.getControl("entry_b");
        if (entryGridA.getSelectRows().length <= 0 || entryGridB.getSelectRows().length <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u6709\u53c2\u4e0e\u65b9\u5355\u636e\u81f3\u5c11\u5404\u9009\u62e9\u4e00\u6761\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u5355\u636e\u3002", (String)"CalWfManualPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }

    private void setCalOrg() {
        Long userOrgId;
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)(userOrgId = Long.valueOf(RequestContext.get().getOrgId())), (String)"cal_fee_share");
        if (calOrgId != null && calOrgId != 0L) {
            this.getModel().setValue("calorg", (Object)calOrgId);
        }
    }

    private void setCurrencyByOrg() {
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("calorg");
        if (org == null) {
            model.setValue("sharecurrency", null);
            return;
        }
        Long orgId = org.getLong("id");
        DynamicObjectCollection orgAndCurrencyObj = QueryServiceHelper.query((String)"bd_accountingsys_base", (String)"basecurrrency", (QFilter[])new QFilter("baseacctorg", "=", (Object)orgId).toArray());
        if (orgAndCurrencyObj.isEmpty()) {
            return;
        }
        Long currencyId = ((DynamicObject)orgAndCurrencyObj.get(0)).getLong("basecurrrency");
        model.setValue("sharecurrency", (Object)currencyId);
    }

    public void addBillFilter(String curEntryKey, String entityNumber, List<QFilter> billFilters, Map<String, Object> pageDataMap) {
        IDataModel model = (IDataModel)pageDataMap.get("model");
        IFormView view = (IFormView)pageDataMap.get("view");
        Long orgid = ((DynamicObject)model.getValue("calorg")).getLong("id");
        DynamicObject currency = (DynamicObject)model.getValue("sharecurrency");
        if (currency == null) {
            DynamicObject calOrg = (DynamicObject)model.getValue("calorg");
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c{0}\u201d\u4e0d\u5b58\u5728\u672c\u4f4d\u5e01\u65e0\u6cd5\u5206\u644a\uff0c\u8bf7\u7ef4\u62a4\u6838\u7b97\u7ec4\u7ec7\u672c\u4f4d\u5e01\u57fa\u7840\u8d44\u6599\u3002", (String)"FeeShareParent_3", (String)"fi-cal-formplugin", (Object[])new Object[0]), calOrg.getString("name")));
        }
        Date startDate = (Date)model.getValue("startdate");
        Date endDate = (Date)model.getValue("enddate");
        boolean notSalFeeShare = !"FYFTFZ-2211-00000003".equals(view.getFormShowParameter().getCustomParams().get("wfGroupNum"));
        QFilter filter = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        if ("ap_finapbill".equals(entityNumber) || "ap_busbill".equals(entityNumber)) {
            Set ownerIds = AccountingSysHelper.getOwnerIdsByCalOrg((Long)orgid);
            filter = new QFilter("org", "in", (Object)ownerIds);
            if (notSalFeeShare) {
                String expenseItemField;
                HashSet<Long> expenseIdSet = new HashSet<Long>();
                if ("ap_finapbill".equals(entityNumber)) {
                    expenseItemField = "detailentry.expenseitem";
                    expenseIdSet.add(0L);
                } else {
                    expenseItemField = "entry.e_expenseitem";
                }
                DynamicObjectCollection itemcol = QueryServiceHelper.query((String)"er_expenseitembill", (String)"expenseitem", (QFilter[])new QFilter("billtype.number", "=", (Object)"cal_costrecord_subentity").toArray());
                for (DynamicObject item : itemcol) {
                    expenseIdSet.add(item.getLong("expenseitem"));
                }
                filter.and(expenseItemField, "in", expenseIdSet);
            }
        } else if ("cal_costrecord_subentity".equals(entityNumber)) {
            QFilter costaccountFilter = new QFilter("calorg", "=", (Object)orgid);
            costaccountFilter.and("enable", "=", (Object)true);
            DynamicObjectCollection costaccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id", (QFilter[])costaccountFilter.toArray(), null);
            HashSet<Long> costaccountids = new HashSet<Long>(16);
            for (DynamicObject costaccount : costaccounts) {
                costaccountids.add(costaccount.getLong("id"));
            }
            filter = new QFilter("costaccount", "in", costaccountids);
            filter.and("calorg", "=", (Object)orgid);
        } else if ("im_saloutbill".equals(entityNumber)) {
            filter.and("billentry.entrysettleorg", "=", (Object)orgid);
        }
        QFilter billQ = new QFilter("billstatus", "=", (Object)"C");
        billQ.and("bookdate", ">=", (Object)startDate);
        billQ.and("bookdate", "<=", (Object)DateUtils.getDayEndTime((Date)endDate));
        billFilters.add(billQ);
        billFilters.add(filter);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        DynamicObject wfType = (DynamicObject)this.getModel().getValue("writeofftype");
        Long wfTypeId = wfType.getLong("id");
        wfType = BusinessDataServiceHelper.loadSingle((Object)wfTypeId, (String)"msmod_writeofftype");
        DynamicObjectCollection wfTypeEntrys = wfType.getDynamicObjectCollection("writeoffbillentry");
        String mainBillEntity = ((DynamicObject)wfTypeEntrys.get(0)).getDynamicObject("writeoffbilltype").getString("number");
        String assistBillEntity = ((DynamicObject)wfTypeEntrys.get(1)).getDynamicObject("writeoffbilltype").getString("number");
        String fieldName = hyperLinkClickEvent.getFieldName();
        int index = hyperLinkClickEvent.getRowIndex();
        Long billid = 0L;
        BillShowParameter showParameter = new BillShowParameter();
        String formId = null;
        DynamicObject entity = null;
        if ("billno_a".equals(fieldName)) {
            billid = (Long)this.getModel().getValue("billid_a", index);
            formId = mainBillEntity;
        } else if ("e_corebillno_a".equals(fieldName)) {
            billid = (Long)this.getModel().getValue("corebillid_a", index);
            entity = (DynamicObject)this.getModel().getValue("e_corebilltype_a", index);
        } else if ("corebillno_a".equals(fieldName)) {
            billid = (Long)this.getModel().getValue("corebillid_a", index);
            entity = (DynamicObject)this.getModel().getValue("corebilltype_a", index);
        } else if ("sourcebillno_a".equals(fieldName) && "ap_busbill".equals(mainBillEntity)) {
            billid = (Long)this.getModel().getValue("e_srcbillid_a", index);
            entity = (DynamicObject)this.getModel().getValue("sourcebilltype_a", index);
        } else if ("sourcebillno_a".equals(fieldName) && "ap_finapbill".equals(mainBillEntity)) {
            billid = (Long)this.getModel().getValue("e_sourcebillid_a", index);
            entity = (DynamicObject)this.getModel().getValue("sourcebilltype_a", index);
        } else if ("billno_b".equals(fieldName)) {
            billid = (Long)this.getModel().getValue("billid_b", index);
            formId = assistBillEntity;
        } else if ("billnumber_b".equals(fieldName)) {
            billid = (Long)this.getModel().getValue("bizbillid_b", index);
            entity = (DynamicObject)this.getModel().getValue("bizentityobject_b", index);
        } else if ("mainbillnumber_b".equals(fieldName)) {
            billid = (Long)this.getModel().getValue("mainbillid_b", index);
            entity = (DynamicObject)this.getModel().getValue("mainbillentity_b", index);
        } else if ("srcbillnumber_b".equals(fieldName)) {
            billid = (Long)this.getModel().getValue("srcbillid_b", index);
            entity = (DynamicObject)this.getModel().getValue("srcbillentity_b", index);
        }
        if (entity != null) {
            formId = entity.getString("id");
        }
        if (formId == null) {
            return;
        }
        if (billid == null) {
            return;
        }
        showParameter.setFormId(formId);
        showParameter.setPkId((Object)billid);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if ("wfscheme".equals(key)) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u5206\u644a\u65b9\u6848", (String)"CalFeeShareManualPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        } else if ("writeofftype".equals(key)) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u5206\u644a\u7c7b\u522b", (String)"CalFeeShareManualPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }
}

