/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.calculate.in;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.cal.common.helper.BalanceReCalParams;
import kd.fi.cal.common.helper.WriteLogHelper;

public class BalanceReCalPartitionTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(BalanceReCalPartitionTask.class);
    private static final String KEY_MATERIALIDS = "materialids";
    private static final String KEY_STARTMATNUMBER = "startmatnumber";
    private static final String KEY_ENDMATNUMBER = "endmatnumber";
    private int concurrency = 5;
    private String timestampStr = null;

    public void execute(RequestContext ctx, Map<String, Object> paramMap) throws KDException {
        MessageInfo msgInfo = new MessageInfo();
        ArrayList<Long> userList = new ArrayList<Long>();
        userList.add(Long.valueOf(ctx.getUserId()));
        msgInfo.setUserIds(userList);
        msgInfo.setNotifyType(MessageChannels.MC.getNumber());
        msgInfo.setTitle(ResManager.loadKDString((String)"\u4f59\u989d\u91cd\u7b97", (String)"BalanceReCalPartitionTask_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        msgInfo.setContent(ResManager.loadKDString((String)"\u4f59\u989d\u91cd\u7b97\u8ba1\u7b97\u6210\u529f\u3002", (String)"BalanceReCalPartitionTask_4", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        try {
            BalanceReCalParams reCalParams = (BalanceReCalParams)SerializationUtils.fromJsonString((String)((String)paramMap.get("params")), BalanceReCalParams.class);
            this.concurrency = reCalParams.getConcurrency();
            int batchmatsize = reCalParams.getBatchmatsize();
            Long timestamp = (Long)paramMap.get("timestamp");
            this.timestampStr = timestamp.toString();
            List<BalanceReCalParams> paramsList = this.analyseAndPartitionParams(reCalParams, batchmatsize);
            if (paramsList.isEmpty()) {
                return;
            }
            int size = paramsList.size();
            int curBatch = 0;
            int runningTaskSize = 0;
            HashSet<String> taskIds = new HashSet<String>(size);
            for (BalanceReCalParams param : paramsList) {
                ++runningTaskSize;
                String sysTaskId = this.calBalRecalAsync(param, ++curBatch, size);
                taskIds.add(sysTaskId);
                while (runningTaskSize >= this.concurrency && curBatch <= size) {
                    String sql = " select fid from  t_im_invdbparam where forgid = " + this.timestampStr;
                    DataSet rs = DB.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "runningTask"), (DBRoute)new DBRoute("im"), (String)sql);
                    if (!rs.isEmpty()) {
                        String content = String.format(ResManager.loadKDString((String)"%1$s:\u4eba\u5de5\u5f3a\u884c\u505c\u6b62", (String)"BalanceReCalPartitionTask_5", (String)"fi-cal-formplugin", (Object[])new Object[0]), this.timestampStr);
                        throw new KDBizException(content);
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        WriteLogHelper.writeErrorLog((Log)logger, (String)"BalanceReCalPartitionTask execute", (Throwable)e);
                    }
                    Calendar calendar = Calendar.getInstance();
                    calendar.set(11, calendar.get(11) - 1);
                    QFilter taskFilter = new QFilter("id", "in", taskIds);
                    taskFilter.and("status", "=", (Object)"BEGIN");
                    taskFilter.and("runtime", ">=", (Object)calendar.getTime());
                    DynamicObjectCollection runningTasks = QueryServiceHelper.query((String)"sch_task", (String)"id", (QFilter[])taskFilter.toArray());
                    runningTaskSize = runningTasks.size();
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    WriteLogHelper.writeErrorLog((Log)logger, (String)"BalanceReCalPartitionTask execute", (Throwable)e);
                }
            }
        }
        catch (Throwable e) {
            String error = e.getLocalizedMessage();
            if (error != null && error.length() > 2000) {
                msgInfo.setContent(error.substring(1, 2000));
            } else {
                msgInfo.setContent(error);
            }
            logger.error("\u4f59\u989d\u91cd\u7b97\u540e\u53f0\u5927\u4efb\u52a1\u51fa\u73b0\u5f02\u5e38", (Object)error);
            throw new KDBizException(error);
        }
        finally {
            MessageCenterServiceHelper.sendMessage((MessageInfo)msgInfo);
        }
    }

    private List<BalanceReCalParams> analyseAndPartitionParams(BalanceReCalParams param, int batchmatsize) {
        ArrayList<BalanceReCalParams> paramList = new ArrayList<BalanceReCalParams>(16);
        Set costAccColl = param.getCostAccColl();
        Set owner = param.getOwner();
        Set storageOrg = param.getStorageOrg();
        Set warehouse = param.getWarehouse();
        Set materialFrom = param.getMaterialFrom();
        Long materialTo = param.getMaterialTo();
        Long period = param.getPeriod();
        int accountnum = param.getAccountnum();
        Set<Object> matIds = this.analyseMaterialSet(materialFrom, materialTo);
        if (matIds == null || matIds.isEmpty()) {
            return paramList;
        }
        List<Map<String, Object>> partition = this.analyseAndPartitonMaterialSet(matIds, batchmatsize);
        for (Map<String, Object> map : partition) {
            Set curmatIds = (Set)map.get(KEY_MATERIALIDS);
            String startMatNumber = (String)map.get(KEY_STARTMATNUMBER);
            String endMatNumber = (String)map.get(KEY_ENDMATNUMBER);
            BalanceReCalParams curParam = new BalanceReCalParams();
            curParam.setCostAccColl(costAccColl);
            curParam.setOwner(owner);
            curParam.setPeriod(period);
            curParam.setStorageOrg(storageOrg);
            curParam.setWarehouse(warehouse);
            curParam.setMaterialFrom(materialFrom);
            curParam.setMaterialTo(materialTo);
            curParam.setStartMatNum(startMatNumber);
            curParam.setEndMatNum(endMatNumber);
            curParam.setMaterialIdSet(curmatIds);
            curParam.setAccountnum(accountnum);
            paramList.add(curParam);
        }
        return paramList;
    }

    private List<Map<String, Object>> analyseAndPartitonMaterialSet(Set<Object> matIds, int batchmatsize) {
        QFilter matFilte = new QFilter("enable", "=", (Object)Boolean.TRUE);
        matFilte.and("status", "=", (Object)"C");
        if (matIds != null && !matIds.isEmpty()) {
            matFilte.and("id", "in", matIds);
        }
        return this.partitionMaterial("bd_material", matFilte, "id,number", batchmatsize);
    }

    private List<Map<String, Object>> partitionMaterial(String entity, QFilter filter, String select, int batchMatSize) {
        ArrayList<Map<String, Object>> partitions = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> part = null;
        HashSet<Object> materialIds = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entity, (String)select, (QFilter[])filter.toArray(), null);){
            DataSet ds = dataSet.groupBy(new String[]{"id", "number"}).finish().orderBy(new String[]{"number"});
            for (Row row : ds) {
                Object materialId = row.get("id");
                String materialNum = row.getString("number");
                if (part == null) {
                    part = new HashMap<String, Object>(4);
                    partitions.add(part);
                    materialIds = new HashSet<Object>(batchMatSize);
                    part.put(KEY_MATERIALIDS, materialIds);
                    part.put(KEY_STARTMATNUMBER, materialNum);
                } else if (materialIds != null && materialIds.size() >= batchMatSize) {
                    part = new HashMap(4);
                    partitions.add(part);
                    materialIds = new HashSet(batchMatSize);
                    part.put(KEY_MATERIALIDS, materialIds);
                    part.put(KEY_STARTMATNUMBER, materialNum);
                }
                if (materialIds != null) {
                    materialIds.add(materialId);
                }
                part.put(KEY_ENDMATNUMBER, materialNum);
            }
        }
        return partitions;
    }

    private Set<Object> analyseMaterialSet(Set<Long> materialFrom, Long materialTo) {
        Set<Object> materialSet;
        block9: {
            QFilter materialFilter;
            block8: {
                materialSet = new HashSet<Object>(16);
                materialFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
                materialFilter.and("status", "=", (Object)"C");
                if (materialTo != null || materialFrom != null && !materialFrom.isEmpty()) break block8;
                DataSet matDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_material", (String)"id", (QFilter[])materialFilter.toArray(), null);
                if (matDataSet.isEmpty()) break block9;
                for (Row mat : matDataSet) {
                    materialSet.add(mat.getLong("id"));
                }
                break block9;
            }
            if (materialTo != null && materialFrom != null && !materialFrom.isEmpty()) {
                DynamicObject materialFromOne = BusinessDataServiceHelper.loadSingle((Object)new ArrayList<Long>(materialFrom).get(0), (String)"bd_material", (String)"id,number");
                DynamicObject materialToOne = BusinessDataServiceHelper.loadSingle((Object)materialTo, (String)"bd_material", (String)"id,number");
                String fromMaterialNo = materialFromOne.getString("number");
                String toMaterialNo = materialToOne.getString("number");
                QFilter matFilterCopy = materialFilter.copy();
                matFilterCopy.and("number", ">=", (Object)fromMaterialNo);
                matFilterCopy.and("number", "<=", (Object)toMaterialNo);
                materialSet = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (QFilter[])matFilterCopy.toArray()).keySet();
            } else if (materialFrom != null && materialFrom.size() > 1) {
                materialSet = new HashSet<Long>(materialFrom);
            } else if (materialTo == null && materialFrom != null && materialFrom.size() == 1) {
                DynamicObject materialFromOne = BusinessDataServiceHelper.loadSingle((Object)new ArrayList<Long>(materialFrom).get(0), (String)"bd_material", (String)"id,number");
                String fromMaterialNo = materialFromOne.getString("number");
                QFilter matFilterCopy = materialFilter.copy();
                matFilterCopy.and("number", ">=", (Object)fromMaterialNo);
                DataSet matDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_material", (String)"id", (QFilter[])matFilterCopy.toArray(), null);
                if (!matDataSet.isEmpty()) {
                    for (Row mat : matDataSet) {
                        materialSet.add(mat.getLong("id"));
                    }
                }
            }
        }
        return materialSet;
    }

    private String calBalRecalAsync(BalanceReCalParams param, int batch, int size) {
        HashMap<String, String> jobParams = new HashMap<String, String>();
        jobParams.put("param", SerializationUtils.toJsonString((Object)param));
        jobParams.put("taskid", this.taskId);
        JobInfo job = new JobInfo();
        String OpName = String.format(ResManager.loadKDString((String)"\u4f59\u989d\u91cd\u7b97\u3010%1$s\u3011\u7b2c\u3010%2$s\u3011\u6279\uff0c\u5f00\u59cb\u7269\u6599\u7f16\u7801\u3010%3$s\u3011\u7ed3\u675f\u7269\u6599\u7f16\u7801\u3010%4$s\u3011\u64cd\u4f5c\u4eba:%5$s", (String)"BalanceReCalPartitionTask_6", (String)"fi-cal-formplugin", (Object[])new Object[0]), RequestContext.get().getTraceId() + "/" + this.timestampStr, batch + "/" + size, param.getStartMatNum(), param.getEndMatNum(), RequestContext.get().getUserName());
        job.setTaskDefineId("2TEDDALLDB2J");
        job.setName(OpName);
        job.setJobType(JobType.BIZ);
        job.setParams(jobParams);
        job.setAppId("cal");
        job.setRunByLang(Lang.get());
        job.setTaskClassname("kd.fi.cal.formplugin.calculate.in.BalanceReCalTask");
        job.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        return JobClient.dispatch((JobInfo)job);
    }
}

