/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.calculate.in;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.MulComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.SCMHelper;
import kd.fi.cal.common.log.CalLogInfo;
import kd.fi.cal.common.log.CalLogUtils;

public class BalanceReCalPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private String PERIOD = "period";
    private String COSTACCOUNT = "costaccount";
    private String STORAGEORG = "storageorgunit";
    private String WAREHOUSE = "warehouse";
    private String OWNER = "owner";
    private String MATERIALFROM = "materialfrom";
    private String MATERIALTO = "materialto";
    private String CALTYPE = "caltype";
    private String TYPE_OWNER = "A";
    private String TYPE_STORAGEORG = "B";
    private String TYPE_WAREHOUSE = "C";
    private String TYPE_MATERIAL = "D";

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (this.OWNER.equals(key)) {
            this.beforeF7Select4Owner(e);
        } else if (this.STORAGEORG.equals(key)) {
            this.beforeF7Select4Storageorg(e);
        } else if (this.WAREHOUSE.equals(key)) {
            this.beforeF7Select4Warehouse(e);
        } else if (this.MATERIALFROM.equals(key)) {
            this.beforeF7Select4Mulmaterial(e);
        } else if (this.MATERIALTO.equals(key)) {
            this.beforeF7Select4Mulmaterial(e);
        } else if (this.PERIOD.equals(key)) {
            this.beforeF7Select4Period(e);
        } else if (this.COSTACCOUNT.equals(key)) {
            this.beforeF7Select4Costacc(e);
        }
    }

    private void beforeF7Select4Costacc(BeforeF7SelectEvent e) {
        List<Long> orgs = this.getAllPermOrgs();
        DynamicObjectCollection sysEntitys = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"entry.costaccount", (QFilter[])new QFilter[]{new QFilter("entry.isenabled", "=", (Object)true)});
        HashSet<Long> costaccSet = new HashSet<Long>(32);
        for (DynamicObject sysEntity : sysEntitys) {
            costaccSet.add(sysEntity.getLong("entry.costaccount"));
        }
        QFilter accFilter = new QFilter("id", "in", costaccSet);
        if (orgs != null) {
            accFilter.and("calorg", "in", orgs);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(accFilter);
    }

    private List<Long> getAllPermOrgs() {
        String appInnerId;
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)(appInnerId = AppMetadataCache.getAppInfo((String)"cal").getId()), (String)"cal_balance_recal", (String)"4730fc9f000025ae");
        if (!rs.hasAllOrgPerm()) {
            return rs.getHasPermOrgs();
        }
        return null;
    }

    private void beforeF7Select4Period(BeforeF7SelectEvent e) {
        DynamicObjectCollection costAccs = (DynamicObjectCollection)this.getModel().getValue(this.COSTACCOUNT);
        if (costAccs != null && costAccs.size() == 1) {
            DynamicObject costAcc = ((DynamicObject)costAccs.get(0)).getDynamicObject("fbasedataid");
            QFilter q = PeriodHelper.getCostAccountNextPeriodQf((DynamicObject)costAcc);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    private void beforeF7Select4Warehouse(BeforeF7SelectEvent e) {
        boolean costAccMul = this.isCostAccMul();
        if (!costAccMul) {
            DynamicObjectCollection sous = (DynamicObjectCollection)this.getModel().getValue("storageorgunit");
            QFilter q = new QFilter("id", "=", (Object)-1L);
            if (sous != null && sous.size() > 0) {
                HashSet<Long> set = new HashSet<Long>();
                for (DynamicObject info : sous) {
                    Long[] warehouseIds;
                    Long[] longArray = warehouseIds = SCMHelper.getAllWarehouseIDs((String)info.getDynamicObject("fbasedataid").getString("number"));
                    int n = longArray.length;
                    for (int i = 0; i < n; ++i) {
                        long id = longArray[i];
                        set.add(id);
                    }
                }
                q = new QFilter("id", "in", set);
            }
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    private void beforeF7Select4Storageorg(BeforeF7SelectEvent e) {
        DynamicObjectCollection costAccs = (DynamicObjectCollection)this.getModel().getValue(this.COSTACCOUNT);
        if (costAccs == null || costAccs.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CalRangePlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        if (costAccs.size() == 1) {
            DynamicObject costAcc = ((DynamicObject)costAccs.get(0)).getDynamicObject("fbasedataid");
            List list = OrgHelper.getStorageOrgUnitByCalOrg((Long)costAcc.getLong("calorg.id"));
            QFilter q = new QFilter("id", "in", (Object)list);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    private void beforeF7Select4Owner(BeforeF7SelectEvent e) {
        DynamicObjectCollection costAccs = (DynamicObjectCollection)this.getModel().getValue(this.COSTACCOUNT);
        if (costAccs == null || costAccs.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CalRangePlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        if (costAccs.size() == 1) {
            DynamicObject costAccount = ((DynamicObject)costAccs.get(0)).getDynamicObject("fbasedataid");
            QFilter q = new QFilter("id", "=", (Object)-1L);
            if (costAccount != null) {
                q = new QFilter("id", "in", (Object)AccountingSysHelper.getOwners((Long)costAccount.getLong("id")));
            }
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    private void beforeF7Select4Mulmaterial(BeforeF7SelectEvent e) {
        QFilter q = new QFilter("status", "=", (Object)"C");
        q.and("enable", "=", (Object)Boolean.TRUE);
        q.and("ctrlstrategy", "!=", (Object)Character.valueOf('7'));
        Long userOrgId = RequestContext.get().getOrgId();
        QFilter orgFilter = new QFilter("createorg", "=", (Object)userOrgId);
        orgFilter.and("ctrlstrategy", "=", (Object)Character.valueOf('7'));
        q.or(orgFilter);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("costaccount".equals(key)) {
            this.costAccountChanged();
        } else if ("materialfrom".equals(key)) {
            this.materialChanged();
        } else if ("calorg".equals(key)) {
            this.calOrgChanged();
        } else if ("storageorgunit".equals(key)) {
            this.storageOrgChanged();
        } else if ("caltype".equals(key)) {
            this.calTypeChanged();
        }
    }

    private void calTypeChanged() {
        DynamicObjectCollection costAccs = (DynamicObjectCollection)this.getModel().getValue(this.COSTACCOUNT);
        if (costAccs == null || costAccs.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CalRangePlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        String calType = (String)this.getModel().getValue(this.CALTYPE);
        this.getView().setVisible(Boolean.FALSE, new String[]{"owner", "storageorgunit", "warehouse", "materialfrom", "materialto", "isconcurrency", "concurrency", "batchmatsize"});
        if (StringUtils.isEmpty((String)calType)) {
            return;
        }
        if (calType.contains(this.TYPE_OWNER)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"owner"});
        } else {
            this.getModel().setValue("owner", null);
        }
        if (calType.contains(this.TYPE_STORAGEORG)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"storageorgunit"});
        } else if (!calType.contains(this.TYPE_WAREHOUSE)) {
            this.getModel().setValue("storageorgunit", null);
        }
        if (calType.contains(this.TYPE_WAREHOUSE)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"warehouse", "storageorgunit"});
        } else {
            if (!calType.contains(this.TYPE_STORAGEORG)) {
                this.getModel().setValue("storageorgunit", null);
            }
            this.getModel().setValue("warehouse", null);
        }
        if (calType.contains(this.TYPE_MATERIAL)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"materialfrom", "materialto", "isconcurrency", "concurrency", "batchmatsize"});
            if (costAccs.size() > 1) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"isconcurrency", "concurrency", "batchmatsize"});
            }
        } else {
            this.getModel().setValue("materialfrom", null);
            this.getModel().setValue("materialto", null);
            this.getModel().setValue("isconcurrency", (Object)false);
            this.getModel().setValue("concurrency", (Object)2);
            this.getModel().setValue("batchmatsize", (Object)10);
        }
    }

    private boolean isCostAccMul() {
        DynamicObjectCollection costacc = (DynamicObjectCollection)this.getModel().getValue(this.COSTACCOUNT);
        boolean costAccMul = false;
        if (costacc != null && costacc.size() > 1) {
            costAccMul = true;
        }
        return costAccMul;
    }

    private void storageOrgChanged() {
        this.getModel().setValue("warehouse", null);
    }

    private void calOrgChanged() {
        this.getModel().setValue("storageorgunit", null);
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        if (calOrg == null) {
            this.getModel().setValue("costaccount", null);
        } else {
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrg.getLong("id"));
            if (costAccount != null) {
                this.getModel().setValue("costaccount", (Object)costAccount.getLong("id"));
            } else {
                this.getModel().setValue("costaccount", null);
            }
        }
    }

    private void materialChanged() {
        DynamicObjectCollection coll = (DynamicObjectCollection)this.getModel().getValue("materialfrom");
        if (coll != null && coll.size() <= 1) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"materialto"});
        } else {
            this.getModel().setValue("materialto", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"materialto"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, "costaccount", "calorg", "owner", "storageorgunit", "warehouse", "materialfrom", this.PERIOD);
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    private void costAccountChanged() {
        DynamicObjectCollection costAccounts = (DynamicObjectCollection)this.getModel().getValue("costaccount");
        MainEntityType entitytype = EntityMetadataCache.getDataEntityType((String)"cal_balance_recal");
        MulComboProp caltypeCombo = (MulComboProp)entitytype.getProperties().get((Object)"caltype");
        List itemList = caltypeCombo.getComboItems();
        ArrayList<ComboItem> itemlist = new ArrayList<ComboItem>(16);
        for (ValueMapItem item : itemList) {
            itemlist.add(new ComboItem(item.getName(), item.getValue()));
        }
        ComboEdit co = (ComboEdit)this.getView().getControl("caltype");
        co.setComboItems(itemlist);
        String caltype = (String)this.getModel().getValue("caltype");
        if (caltype != null && caltype.contains("D")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"isconcurrency", "concurrency", "batchmatsize"});
        }
        if (costAccounts == null || costAccounts.isEmpty()) {
            this.getModel().setValue(this.PERIOD, null);
            this.getModel().setValue("owner", null);
            this.getModel().setValue("storageorgunit", null);
            this.getModel().setValue("warehouse", null);
        } else if (costAccounts.size() == 1) {
            this.getView().setVisible(Boolean.TRUE, new String[]{this.PERIOD});
            this.getModel().setValue(this.PERIOD, (Object)PeriodHelper.getCurrentPeriod((Long)((DynamicObject)costAccounts.get(0)).getDynamicObject("fbasedataid").getLong("id")));
            this.calTypeChanged();
        } else {
            this.getModel().setValue(this.PERIOD, null);
            this.getModel().setValue("owner", null);
            this.getModel().setValue("storageorgunit", null);
            this.getModel().setValue("warehouse", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{this.PERIOD});
            if (caltype != null) {
                caltype = caltype.replace(",A", "");
                caltype = caltype.replace(",B", "");
                if (",".equals(caltype = caltype.replace(",C", ""))) {
                    this.getModel().setValue("caltype", null);
                } else {
                    this.getModel().setValue("caltype", (Object)caltype);
                }
            }
            LocaleString materialName = null;
            for (ValueMapItem item : itemList) {
                if (!"D".equals(item.getValue())) continue;
                materialName = item.getName();
            }
            ArrayList<ComboItem> iteMulAccountlist = new ArrayList<ComboItem>(16);
            iteMulAccountlist.add(new ComboItem(materialName, "D"));
            co.setComboItems(iteMulAccountlist);
            this.getModel().setValue("isconcurrency", (Object)false);
            this.getModel().setValue("concurrency", (Object)2);
            this.getModel().setValue("batchmatsize", (Object)10);
            this.getView().setVisible(Boolean.FALSE, new String[]{"isconcurrency", "concurrency", "batchmatsize"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("caltype", (Object)"D");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"owner", "storageorgunit", "warehouse"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if ("recal".equals(key) && e.getOperationResult().isSuccess()) {
            DynamicObjectCollection costaccs = (DynamicObjectCollection)this.getModel().getValue(this.COSTACCOUNT);
            StringBuilder description = new StringBuilder();
            this.buildLogDescription(description, costaccs);
            description.append(ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u540e\u53f0\u6267\u884c\u91cd\u7b97\uff0c\u8bf7\u7a0d\u540e\u91cd\u65b0\u67e5\u8be2\u6838\u7b97\u62a5\u8868\u3002", (String)"BalanceReCalPlugin_13", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            CalLogUtils.addLog((CalLogInfo)CalLogUtils.buildCalAppLog((String)"cal_balance_recal", (String)ResManager.loadKDString((String)"\u4f59\u989d\u91cd\u7b97", (String)"BalanceReCalPlugin_8", (String)"fi-cal-formplugin", (Object[])new Object[0]), (String)description.toString(), (long)((DynamicObject)costaccs.get(0)).getDynamicObject("fbasedataid").getLong("calorg.id")));
        }
    }

    private StringBuilder buildLogDescription(StringBuilder description, DynamicObjectCollection costaccs) {
        String calType;
        int maxSize = 10;
        int costaccsSize = costaccs.size();
        String costaccStr = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f", (String)"BalanceReCalPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        if (costaccsSize > 10) {
            description.append(costaccStr);
            for (int i = 0; i < 9; ++i) {
                description.append('\u3010').append(((DynamicObject)costaccs.get(i)).getDynamicObject("fbasedataid").getString("name")).append('\u3011');
            }
            description.append("...").append(((DynamicObject)costaccs.get(costaccsSize - 1)).getDynamicObject("fbasedataid").getString("name")).append('\u3011');
        } else {
            description.append(costaccStr);
            for (DynamicObject costacc : costaccs) {
                description.append('\u3010').append(costacc.getDynamicObject("fbasedataid").getString("name")).append('\u3011');
            }
        }
        if (costaccs.size() == 1) {
            DynamicObject period = (DynamicObject)this.getModel().getValue("period");
            description.append(ResManager.loadKDString((String)"\u4f1a\u8ba1\u671f\u95f4", (String)"HomePlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0])).append('\u3010').append(period.getString("name")).append('\u3011');
        }
        if ((calType = (String)this.getModel().getValue("caltype")).contains("A") && ((DynamicObjectCollection)this.getModel().getValue("owner")).size() > 0) {
            description.append(ResManager.loadKDString((String)"\u8d27\u4e3b", (String)"BalanceReCalPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0])).append('\u3010').append(this.getNames("owner", "name", maxSize)).append('\u3011');
        }
        if (calType.contains("B") && ((DynamicObjectCollection)this.getModel().getValue("storageorgunit")).size() > 0) {
            description.append(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7", (String)"BalanceReCalPlugin_4", (String)"fi-cal-formplugin", (Object[])new Object[0])).append('\u3010').append(this.getNames("storageorgunit", "name", maxSize)).append('\u3011');
        }
        if (calType.contains("C") && ((DynamicObjectCollection)this.getModel().getValue("warehouse")).size() > 0) {
            if (!calType.contains("B") && ((DynamicObjectCollection)this.getModel().getValue("storageorgunit")).size() > 0) {
                description.append(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7", (String)"BalanceReCalPlugin_4", (String)"fi-cal-formplugin", (Object[])new Object[0])).append('\u3010').append(this.getNames("storageorgunit", "name", maxSize)).append('\u3011');
            }
            description.append(ResManager.loadKDString((String)"\u4ed3\u5e93", (String)"BalanceReCalPlugin_5", (String)"fi-cal-formplugin", (Object[])new Object[0])).append('\u3010').append(this.getNames("warehouse", "name", maxSize)).append('\u3011');
        }
        if (calType.contains("D")) {
            DynamicObjectCollection materialFroms = (DynamicObjectCollection)this.getModel().getValue("materialfrom");
            if (materialFroms.size() > 1) {
                description.append(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"BalanceReCalPlugin_6", (String)"fi-cal-formplugin", (Object[])new Object[0])).append('\u3010').append(this.getNames("materialfrom", "number", maxSize)).append('\u3011');
                description.append(ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"BalanceReCalPlugin_7", (String)"fi-cal-formplugin", (Object[])new Object[0])).append('\u3010').append(this.getNames("materialfrom", "name", maxSize)).append('\u3011');
            } else {
                DynamicObject materialTo;
                boolean hasMaterial = false;
                QFilter q = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
                if (materialFroms.size() == 1) {
                    q.and(new QFilter("number", ">=", (Object)((DynamicObject)materialFroms.get(0)).getDynamicObject("fbasedataid").getString("number")));
                    hasMaterial = true;
                }
                if ((materialTo = (DynamicObject)this.getModel().getValue("materialto")) != null) {
                    q.and("number", "<=", (Object)materialTo.getString("number"));
                    hasMaterial = true;
                }
                if (hasMaterial) {
                    try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_material", (String)"id,number,name", (QFilter[])q.toArray(), null);){
                        String names = "";
                        StringBuilder nameBuilder = new StringBuilder(32);
                        String numbers = "";
                        StringBuilder numbersBuilder = new StringBuilder(32);
                        int i = 0;
                        for (Row row : dataSet) {
                            if (i >= maxSize) break;
                            nameBuilder.append(row.getString("name"));
                            nameBuilder.append(',');
                            numbersBuilder.append(row.getString("number"));
                            numbersBuilder.append(',');
                            ++i;
                        }
                        if (nameBuilder.length() > 0) {
                            names = nameBuilder.substring(0, nameBuilder.length() - 1);
                        }
                        if (numbersBuilder.length() > 0) {
                            numbers = numbersBuilder.substring(0, numbersBuilder.length() - 1);
                        }
                        if (i >= maxSize) {
                            names = names + "\u3002\u3002\u3002";
                            numbers = numbers + "\u3002\u3002\u3002";
                        }
                        description.append(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"BalanceReCalPlugin_6", (String)"fi-cal-formplugin", (Object[])new Object[0])).append('\u3010').append(numbers).append('\u3011');
                        description.append(ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"BalanceReCalPlugin_7", (String)"fi-cal-formplugin", (Object[])new Object[0])).append('\u3010').append(names).append('\u3011');
                    }
                }
            }
        }
        return description;
    }

    private String getNames(String col, String field, int maxSize) {
        DynamicObjectCollection colls = (DynamicObjectCollection)this.getModel().getValue(col);
        String names = "";
        StringBuilder nameBuilder = new StringBuilder(32);
        int i = 0;
        for (DynamicObject info : colls) {
            if (i >= maxSize) break;
            nameBuilder.append(info.getDynamicObject("fbasedataid").getString(field));
            nameBuilder.append(',');
            ++i;
        }
        names = nameBuilder.substring(0, nameBuilder.length() - 1);
        if (i >= maxSize) {
            names = names + "\u3002\u3002\u3002";
        }
        return names;
    }
}

