/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.calculate.in;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.business.balance.BalanceCalculator;
import kd.fi.cal.common.helper.BalanceReCalParams;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.util.CommonUtils;

public class BalanceReCalTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(BalanceReCalTask.class);
    private static final String ALGOKEY = "kd.fi.cal.opplugin.balance.BalanceReCalOp";
    private Set<Long> materialIdSet;
    private Set<Long> filter_owner;
    private Set<Long> filter_storageOrg;
    private Set<Long> filter_warehouse;
    private Map<Long, DynamicObject> periodMap = new HashMap<Long, DynamicObject>(16);

    public void execute(RequestContext ctx, Map<String, Object> paramMap) throws KDException {
        try (AlgoContext context = Algo.newContext();){
            BalanceReCalParams param = (BalanceReCalParams)SerializationUtils.fromJsonString((String)((String)paramMap.get("param")), BalanceReCalParams.class);
            Set costAccCollIdSet = param.getCostAccColl();
            Long costAccCollId = (Long)new ArrayList(costAccCollIdSet).get(0);
            DynamicObject costAccount = BusinessDataServiceHelper.loadSingle((Object)costAccCollId, (String)"cal_bd_costaccount");
            this.init(param);
            BalanceCalculator cal = new BalanceCalculator();
            this.doRecal(param, costAccount, false, cal);
        }
        catch (Throwable e) {
            String error = e.getLocalizedMessage();
            logger.error("\u4f59\u989d\u91cd\u7b97\u540e\u53f0\u5206\u4efb\u52a1\u51fa\u73b0\u5f02\u5e38", (Object)error);
            throw new KDBizException(error);
        }
    }

    private void doRecal(BalanceReCalParams param, DynamicObject costAccount, boolean costAccMul, BalanceCalculator cal) {
        DynamicObject filter_period = costAccMul ? this.periodMap.get(costAccount.getLong("id")) : BusinessDataServiceHelper.loadSingle((Object)param.getPeriod(), (String)"bd_period");
        int filter_periodNumber = filter_period.getInt("periodyear") * 100 + filter_period.getInt("periodnumber");
        HashSet<Long> costRecordEntrySet = new HashSet<Long>(4096);
        HashSet<Long> costRecordIdSet = new HashSet<Long>(4096);
        DataSet costRecordDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_costrecord", (String)"id,entry.id,period", (QFilter[])this.getCostRecordFilter(filter_period, costAccount).toArray(), null);
        for (Row row : costRecordDataSet.copy()) {
            costRecordEntrySet.add(row.getLong("entry.id"));
            costRecordIdSet.add(row.getLong("id"));
        }
        HashSet<Long> detailIdSet = new HashSet<Long>(4096);
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.in_range, costRecordIdSet)});){
            ctx.set();
            DataSet costRecordElementDetail = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_costrecord_detail", (String)"id", (QFilter[])new QFilter("entryid", "in", costRecordEntrySet).toArray(), null);
            while (costRecordElementDetail.hasNext()) {
                detailIdSet.add(costRecordElementDetail.next().getLong("id"));
            }
        }
        detailIdSet.remove(null);
        DeleteServiceHelper.delete((String)"cal_balance_snapshoot", (QFilter[])new QFilter("mainid", "in", detailIdSet).toArray());
        HashSet<Long> balSet = new HashSet<Long>(4096);
        DataSet balDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_balance", (String)"id", (QFilter[])this.getBalFilter(false, filter_periodNumber, costAccount).toArray(), null);
        for (Row row : balDataSet) {
            balSet.add(row.getLong("id"));
        }
        DeleteServiceHelper.delete((String)"cal_balance", (QFilter[])new QFilter("id", "in", balSet).toArray());
        DeleteServiceHelper.delete((String)"cal_balance_detail", (QFilter[])new QFilter("balid", "in", balSet).toArray());
        ArrayList<Object[]> endPeriodUpdateObjList = new ArrayList<Object[]>(4096);
        DataSet previousBalDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_balance", (String)"id", (QFilter[])this.getBalFilter(true, filter_periodNumber, costAccount).toArray(), null);
        for (Object row : previousBalDataSet) {
            endPeriodUpdateObjList.add(new Object[]{row.getLong("id")});
        }
        if (!endPeriodUpdateObjList.isEmpty()) {
            String endPeriodUpdateSql = "update t_cal_balance set fendperiod = 999999 where fid = ?";
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)endPeriodUpdateSql, endPeriodUpdateObjList);
        }
        DataSet copyCostRecordDataSet = costRecordDataSet.copy().groupBy(new String[]{"period"}).finish().orderBy(new String[]{"period asc"});
        for (Row row : copyCostRecordDataSet) {
            long periodid = row.getLong("period");
            DataSet recordDataSet = costRecordDataSet.copy().filter("period = " + periodid);
            ArrayList list = new ArrayList(32);
            ArrayList idlist = new ArrayList(32);
            int i = 0;
            int max = 50000;
            HashSet<Long> set = new HashSet<Long>(1024);
            HashSet<Long> idset = new HashSet<Long>(1024);
            list.add(set);
            idlist.add(idset);
            for (Row row1 : recordDataSet) {
                if (i >= max) {
                    i = 0;
                    set = new HashSet(1024);
                    idset = new HashSet(1024);
                    list.add(set);
                    idlist.add(idset);
                }
                set.add(row1.getLong("entry.id"));
                idset.add(row1.getLong("id"));
                ++i;
            }
            if (list.isEmpty()) continue;
            for (int j = 0; j < list.size(); ++j) {
                cal.updateBalance4CostRecordReCal((Set)list.get(j), (Set)idlist.get(j));
            }
        }
        DataSet costAdjustDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_costadjustbill", (String)"entryentity.id,period", (QFilter[])this.getCostAdjustFilter(filter_period, costAccount).toArray(), null);
        DataSet copyCostAdjustDataSet = costAdjustDataSet.copy().groupBy(new String[]{"period"}).finish().orderBy(new String[]{"period asc"});
        HashSet<Long> set = new HashSet<Long>(1024);
        for (Row row : copyCostAdjustDataSet) {
            long periodid = row.getLong("period");
            DataSet adjustDataSet = costAdjustDataSet.copy().filter("period = " + periodid);
            for (Row row1 : adjustDataSet) {
                set.add(row1.getLong("entryentity.id"));
            }
            cal.updateBalance4CostAdjustReCal(set.toArray());
            set.clear();
        }
    }

    private void init(BalanceReCalParams param) {
        this.filter_owner = param.getOwner();
        this.filter_storageOrg = param.getStorageOrg();
        this.filter_warehouse = param.getWarehouse();
        this.materialIdSet = param.getMaterialIdSet();
    }

    private QFilter getCostRecordFilter(DynamicObject filter_period, DynamicObject costAccount) {
        QFilter q = new QFilter("costaccount", "=", costAccount.getPkValue());
        q.and("period", ">=", filter_period.getPkValue());
        q.and("issplitcreate", "=", (Object)Character.valueOf('0'));
        q.and("isinitbill", "=", (Object)Character.valueOf('0'));
        if (this.materialIdSet != null && !this.materialIdSet.isEmpty()) {
            q.and("entry.material.id", "in", this.materialIdSet);
        }
        if (this.filter_owner != null && !this.filter_owner.isEmpty()) {
            q.and("entry.owner", "in", this.filter_owner);
        }
        if (this.filter_storageOrg != null && !this.filter_storageOrg.isEmpty()) {
            q.and("storageorgunit", "in", this.filter_storageOrg);
        }
        if (this.filter_warehouse != null && !this.filter_warehouse.isEmpty()) {
            q.and("entry.warehouse", "in", this.filter_warehouse);
        }
        q.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        q.and(billStatusf);
        return q;
    }

    private QFilter getCostAdjustFilter(DynamicObject filter_period, DynamicObject costAccount) {
        QFilter q = new QFilter("costaccount", "=", costAccount.getPkValue());
        q.and("period", ">=", filter_period.getPkValue());
        q.and("billstatus", "=", (Object)"C");
        if (this.materialIdSet != null && !this.materialIdSet.isEmpty()) {
            q.and("entryentity.material.id", "in", this.materialIdSet);
        }
        if (this.filter_owner != null && !this.filter_owner.isEmpty()) {
            q.and("entryentity.owner", "in", this.filter_owner);
        }
        if (this.filter_storageOrg != null && !this.filter_storageOrg.isEmpty()) {
            q.and("entryentity.storageorgunit", "in", this.filter_storageOrg);
        }
        if (this.filter_warehouse != null && !this.filter_warehouse.isEmpty()) {
            q.and("entryentity.warehouse", "in", this.filter_warehouse);
        }
        return q;
    }

    private QFilter getBalFilter(boolean filterEndPeriod, int filter_periodNumber, DynamicObject costAccount) {
        QFilter q = new QFilter("costaccount", "=", costAccount.getPkValue());
        if (filterEndPeriod) {
            q.and("endperiod", ">=", (Object)filter_periodNumber);
        } else {
            q.and("period", ">=", (Object)filter_periodNumber);
        }
        if (this.materialIdSet != null && !this.materialIdSet.isEmpty()) {
            q.and("material.id", "in", this.materialIdSet);
        }
        if (this.filter_owner != null && !this.filter_owner.isEmpty()) {
            q.and("owner", "in", this.filter_owner);
        }
        if (this.filter_storageOrg != null && !this.filter_storageOrg.isEmpty()) {
            q.and("storageorgunit", "in", this.filter_storageOrg);
        }
        if (this.filter_warehouse != null && !this.filter_warehouse.isEmpty()) {
            q.and("warehouse", "in", this.filter_warehouse);
        }
        return q;
    }
}

