/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.calculate.in;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Input;
import kd.bos.algo.MapFunction;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.algo.input.OrmInput;
import kd.bos.cache.CacheFactory;
import kd.bos.config.client.util.JSONUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.lang.Lang;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.bos.threads.ThreadPools;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.ExceptionUtils;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.bos.web.actions.export.ExportWriterFormat;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.business.costprice.CostPrice4Others;
import kd.fi.cal.business.fallprice.DealCalRangeFunction;
import kd.fi.cal.business.process.impl.EstimateAdjustInPurValidator;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.CostRecordQFilterHelper;
import kd.fi.cal.common.helper.DynamicFieldCreateHelper;
import kd.fi.cal.common.helper.FelxHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.helper.ReportF7Helper;
import kd.fi.cal.common.helper.SCMHelper;
import kd.fi.cal.common.helper.WriteLogHelper;
import kd.fi.cal.common.metadata.Element;
import kd.fi.cal.common.metadata.EntryElement;
import kd.fi.cal.common.model.CalculateInParams;
import kd.fi.cal.common.model.CostSubElementInfo;
import kd.fi.cal.common.util.ArrayUtils;
import kd.fi.cal.formplugin.calculate.in.CalImportSheetHandler;
import kd.fi.cal.formplugin.calculate.in.ExportUtil;
import kd.fi.cal.formplugin.calculate.in.MatFromToFilter;
import kd.fi.cal.formplugin.calculate.in.SubElementRowToColFunction;
import kd.fi.cal.formplugin.calculate.in.SubEntityUtil;
import kd.fi.cal.formplugin.queryscheme.SchemeSettingPlugin;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class CalculateInCostPlugin
extends SchemeSettingPlugin
implements UploadListener,
BeforeF7SelectListener,
ProgresssListener {
    private static final String PROGRESS_KEY = "progress";
    private String GATHERKEY = "gatherid";
    private String GATHERDATAMAP = "gatherDataMap";
    private String QFILTER = "qfilter";
    private String sumType = null;
    private String UNITACTUALCOST = "unitactualcost";
    private String ACTUALCOST = "actualcost";
    private String BASEQTY = "baseqty";
    private String UNITMATERIALCOST = "unitmaterialcost";
    private String MATERIALCOST = "materialcost";
    private String UNITFEE = "unitfee";
    private String FEE = "fee";
    private String UNITPROCESSCOST = "unitprocesscost";
    private String PROCESSCOST = "processcost";
    private String ISOMINBILLTYPE = "isominbilltype";
    private String AMT_PRECISION = "amtPrecision";
    private Map<String, String> ownerIdMap = new HashMap<String, String>();
    private String CALORG = "calorgfilter";
    private String COSTACCOUNT = "costaccountfilter";
    private String LOCATUINFILTER = "locationfilter";
    private String WAREHOUSE = "warehousefilter";
    private String MATERIALFROM = "materialfrom";
    private String BIZTYPE = "biztypefilter";
    private String YEAR = "year";
    private String PERIOD_NUM = "periodnum";
    private String STORAGEORGUNITFILTER = "storageorgunitfilter";
    private String OWNERFILTER = "ownerfilter";
    private String BILLTYPE = "billtypefilter";
    private String BDBIZTYPE = "bdbiztypefilter";
    private String INVSCHEME = "invschemefilter";
    private String COSTSUBELEMENT = "costsubelementfilter";
    private static final String DYNAMIC_GRID = "dynamicfiltergrid";
    private static final String GROUP_COL = "mulsumtype";
    private String[] FIX_COL = new String[]{"material", "baseunit"};
    private String[] OWNER_RELATION = new String[]{"owner", "ownertype"};
    private String[] ENTRY_COST_FIELDS = new String[]{"materialcost", "fee", "processcost"};
    private String[] STORAGE_ORG_RELATION = new String[]{"storageorgunit"};
    private String[] WAREHOUSE_RELATION = new String[]{"storageorgunit", "warehouse"};
    private String[] LOCATION_RELATION = new String[]{"storageorgunit", "warehouse", "location"};
    private String[] STORAGE_ORG_REMOVE = new String[]{"storageorgunit", "warehouse", "location"};
    private String[] WAREHOUSE_REMOVE = new String[]{"warehouse", "location"};
    private String[] LOCATION_REMOVE = new String[]{"location"};
    private static String REAL_COLS = "realCols";
    private static String CALRANGE = "calrange";
    private static String GROUP_COL_ALL = "group_key_all";
    private static String CACHE_DIFF_COL = "cache_diff_col";
    private List<String> extendFields = new ArrayList<String>(16);
    private static final Log logger = LogFactory.getLog(CalculateInCostPlugin.class);
    private String exPreStr = "Exception@@";
    private final String TASKIDS_CACHE = "taskIds";
    private static final int BATCH_SIZE = 100000;
    private static final long FX_TEMPLATEID = 1890644319325539328L;
    private static final long FFX_TEMPLATEID = 1890643843850849280L;
    private static final String MAX_QUERY = "cal_calculate_maxquery";
    private static final String UNIQUE_QUERY = "cal_calculate_query";
    private static final String CALCULATE_PRICE = "CALCULATE_PRICE@@";
    private static final String SQL = "SELECT FDATA FROM T_BAS_BILLTYPEPARAMETER WHERE FBILLTYPEID=";

    public void initialize() {
        this.getView().addCustomControls(new String[]{"entryentity"});
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, this.COSTACCOUNT, this.LOCATUINFILTER, this.WAREHOUSE, this.STORAGEORGUNITFILTER, this.CALORG, this.OWNERFILTER, this.BILLTYPE, this.BDBIZTYPE, this.INVSCHEME, this.MATERIALFROM, "materialto");
        this.addClickListeners(new String[]{"btndownload", "btnupload", "btnrefresh", "btnimportdata", "btnexportexcel"});
        Button btnUpLoad = (Button)this.getControl("btnupload");
        btnUpLoad.addUploadListener((UploadListener)this);
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        for (String str : f7Name) {
            BasedataEdit f7Control = (BasedataEdit)this.getView().getControl(str);
            if (null == f7Control) continue;
            f7Control.addBeforeF7SelectListener(form);
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.stop();
        this.clearPageIdCacheValue();
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        super.beforeDoOperation(event);
        this.saveDynamicFilter();
        this.getPageCache().put("removeEntities", "entryentity,");
    }

    @Override
    protected void afterSelScheme() {
        super.afterSelScheme();
        this.initDynamicFilter("cal_costrecord_subentity", DYNAMIC_GRID);
        this.releaseDynamicFilter();
    }

    private void initDynamicFilter(String entityNumber, String frontViewName) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        EntityTypeUtil helper = new EntityTypeUtil();
        List<Map<String, Object>> cols = helper.getFilterColumns((IDataEntityType)mainEntityType, false);
        cols = this.filterCols(cols);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(DYNAMIC_GRID);
        filterGrid.setEntityNumber(mainEntityType.getName());
        filterGrid.setFilterColumns(cols);
        this.getView().updateView(frontViewName);
    }

    private List<Map<String, Object>> filterCols(List<Map<String, Object>> cols) {
        ArrayList<Map<String, Object>> filtedList = new ArrayList<Map<String, Object>>(16);
        for (Map<String, Object> colInfos : cols) {
            String entryEntity = colInfos.get("entryEntity").toString();
            if (!"cal_costrecord".equals(entryEntity) && !"entry".equals(entryEntity)) continue;
            filtedList.add(colInfos);
        }
        return filtedList;
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.releaseDynamicFilter();
    }

    private void releaseDynamicFilter() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(DYNAMIC_GRID);
        filterGrid.SetValue(new FilterCondition());
        String filter = (String)this.getModel().getValue("filter_tag");
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
            filterGrid.SetValue(filterCondition);
        }
    }

    private void initGroupCol() {
        this.getModel().beginInit();
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(16);
        ArrayList<String> comboItemNames = new ArrayList<String>(16);
        ArrayList<String> initChooseColsValues = new ArrayList<String>(16);
        LocaleString calString = new LocaleString(ResManager.loadKDString((String)"\u5b58\u8d27", (String)"CalculateInCostTask_17", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        ComboItem materialInfo = new ComboItem(calString, "cal_material");
        propertyItems.add(materialInfo);
        LocaleString groupString = new LocaleString(ResManager.loadKDString((String)"\u5212\u5206\u4f9d\u636e+\u6838\u7b97\u7ef4\u5ea6", (String)"CalculateInCostTask_18", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        ComboItem groupInfo = new ComboItem(groupString, "cal_group");
        propertyItems.add(groupInfo);
        String[] settingGroupCols = CommonSettingHelper.getGroupCol();
        if (settingGroupCols == null || settingGroupCols.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6c47\u603b\u4f9d\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5728\u201c\u5b58\u8d27\u6838\u7b97>\u6838\u7b97\u914d\u7f6e>\u53c2\u6570\u914d\u7f6e>\u516c\u5171\u914d\u7f6e\u201d\u4e2d\u8bbe\u7f6e\u6c47\u603b\u4f9d\u636e\u6765\u6e90.", (String)"CalculateInCostPlugin_46", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        ArrayList<String> allCols = new ArrayList<String>(Arrays.asList(settingGroupCols));
        MainEntityType entitytype = EntityMetadataCache.getDataEntityType((String)"cal_costrecord");
        for (Object pro : entitytype.getProperties()) {
            String proName;
            if (!(pro instanceof BasedataProp) && !(pro instanceof TextProp) || !allCols.contains(proName = pro.getName())) continue;
            LocaleString displayName = pro.getDisplayName();
            ComboItem item = new ComboItem(displayName, proName);
            propertyItems.add(item);
            comboItemNames.add(proName);
        }
        EntityType entryentity = (EntityType)entitytype.getAllEntities().get("entry");
        for (IDataEntityProperty pro : entryentity.getProperties()) {
            String proName;
            if (!(pro instanceof BasedataProp) && !(pro instanceof TextProp) && !(pro instanceof ComboProp) || !allCols.contains(proName = pro.getName())) continue;
            LocaleString displayName = pro.getDisplayName();
            ComboItem item = new ComboItem(displayName, proName);
            propertyItems.add(item);
            comboItemNames.add(proName);
        }
        if (propertyItems.size() != 0) {
            ComboEdit ruleEdit = (ComboEdit)this.getControl(GROUP_COL);
            ruleEdit.setComboItems(propertyItems);
        }
        initChooseColsValues.add("cal_material");
        String groupColJson = this.getGroupColJson(initChooseColsValues);
        this.getModel().setValue(GROUP_COL, (Object)groupColJson);
        this.checkAndRefreshGroupCol(initChooseColsValues, comboItemNames);
        this.getPageCache().put(GROUP_COL, groupColJson);
        this.getModel().endInit();
        this.getView().updateView(GROUP_COL);
    }

    private void removeUnnecessary(Collection<String> allCols) {
        if (allCols.isEmpty()) {
            return;
        }
        allCols.remove("calrange");
        allCols.remove("caldimension");
    }

    private String[] getDivAndDimensionCols(Long costAccountId) {
        DynamicObject accountDyc = BusinessDataServiceHelper.loadSingleFromCache((Object)costAccountId, (String)"cal_bd_costaccount");
        String divStr = accountDyc.getString("dividebasis.dividebasis");
        if (divStr.indexOf("owner") != -1 && divStr.indexOf("ownertype") == -1) {
            divStr = divStr + ",ownertype";
        }
        String calDimensionStr = CommonSettingHelper.getCalDimensionStr();
        return (String[])ArrayUtils.concatAll((Object[])this.getDivRangeDims(divStr, calDimensionStr), (Object[][])new String[][]{{"material"}});
    }

    @Override
    protected void afterAddScheme() {
        super.afterAddScheme();
        this.initUIData();
        this.initCalorgAndCostAccount();
        this.initGroupCol();
        ((Container)this.getControl("filterpanel")).setCollapse(Boolean.FALSE.booleanValue());
    }

    private void saveDynamicFilter() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(DYNAMIC_GRID);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        String filterString = SerializationUtils.toJsonString((Object)filterGridState.getFilterCondition());
        this.getModel().setValue("filter_tag", (Object)filterString);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (!StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btnupload")) {
            if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btndownload")) {
                this.checkRequireIsNull();
                try {
                    this.downExcel();
                }
                catch (Exception e) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u9884\u7f6e\u6a21\u7248\u7f3a\u5931\u6216\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CalculateInCostPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                }
            } else if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btnrefresh")) {
                this.checkRequireIsNull();
                this.refreshPage();
            } else if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btnimportdata")) {
                this.checkRequireIsNull();
                this.clickImportData();
            } else if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btnexportexcel")) {
                this.checkRequireIsNull();
                this.exportExcel();
            }
        }
    }

    private void clickImportData() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cal_importcostpriceset");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        QFilter q = new QFilter("priceobject", "=", (Object)"A");
        q.and("entityobject", "=", (Object)"cal_in_calculate");
        showParameter.getCustomParams().put("costpricefilter", q.toString());
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "btnimportdata");
        showParameter.setCloseCallBack(callBack);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String sourceFldKey = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null && "btnimportdata".equals(sourceFldKey)) {
            Map param = (Map)returnData;
            String costPriceNumber = param.get("costprice") == null ? "" : (String)param.get("costprice");
            DynamicObject costAccount = (DynamicObject)this.getModel().getValue(this.COSTACCOUNT);
            boolean isCostRecordDetail = ParamsHelper.getCostElementByCostAccount((long)costAccount.getLong("id"));
            Long[] defaultElementIds = CostElementHelper.getDefaultMaterialElements();
            Long defaultMaterialElement = defaultElementIds[0];
            boolean async = param.get("async") == null ? false : (Boolean)param.get("async");
            try {
                if ("".equals(costPriceNumber)) {
                    if (async) {
                        this.doImportDataAsync(null, isCostRecordDetail, defaultMaterialElement);
                    } else {
                        this.doImportData(null, isCostRecordDetail, defaultMaterialElement);
                    }
                } else if (async) {
                    this.doImportDataAsync(costPriceNumber, isCostRecordDetail, defaultMaterialElement);
                } else {
                    this.doImportData(costPriceNumber, isCostRecordDetail, defaultMaterialElement);
                }
            }
            catch (KDBizException e) {
                this.getView().showErrorNotification(e.getMessage());
            }
        }
    }

    private void doImportDataAsync(String costPriceNumber, boolean isCostRecordDetail, Long defaultMaterialElement) {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.setPercent(0);
        this.getPageCache().put(PROGRESS_KEY, "15");
        bar.start();
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        String lastQueryVersion = this.getPageIdCacheValue(UNIQUE_QUERY);
        String maxQueryVersion = this.getPageIdCacheValue(MAX_QUERY);
        if (entryentity.size() == 0 || maxQueryVersion == null) {
            String errorMsg = ResManager.loadKDString((String)"\u65e0\u7b26\u5408\u6761\u4ef6\u7684\u6c47\u603b\u6570\u636e\uff0c\u65e0\u9700\u5bfc\u5165\u4ef7\u683c\u3002", (String)"CalculateInCostPlugin_45", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            bar.setPercent(100);
            bar.stop();
            this.getPageCache().remove("cacheId");
            throw new KDBizException(errorMsg);
        }
        if (lastQueryVersion == null || Integer.parseInt(lastQueryVersion) < Integer.parseInt(maxQueryVersion)) {
            String errorMsg = ResManager.loadKDString((String)"\u9875\u9762\u6570\u636e\u53d8\u52a8\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u540e\u518d\u64cd\u4f5c\u3002", (String)"CalculateInCostPlugin_44", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            bar.setPercent(100);
            bar.stop();
            this.getPageCache().remove("cacheId");
            throw new KDBizException(errorMsg);
        }
        ThreadPools.executeOnceIncludeRequestContext((String)(((Object)((Object)this)).getClass().getName() + "getprice-backend"), () -> {
            long jobStartTime = System.currentTimeMillis();
            logger.info("calculateInCost-getprice-start : {}", (Object)jobStartTime);
            try {
                DynamicObjectCollection entryRows = this.getModel().getEntryEntity("entryentity");
                int[] indexs = this.getSelectIndexs("entryentity");
                List<Map<String, Object>> parms = null;
                parms = indexs == null || indexs.length == 0 ? this.getMapFromDyObCo(entryRows) : this.getMapSelectFromDyObCo(entryRows);
                QFilter q = new QFilter("priceobject", "=", (Object)"A");
                q.and("entityobject", "=", (Object)"cal_in_calculate");
                Map maps = new CostPrice4Others().getPriceFromEntryParmsMap(parms, q, costPriceNumber);
                DynamicObjectCollection costSubElements = this.getModel().getDataEntity().getDynamicObjectCollection(this.COSTSUBELEMENT);
                ArrayList<Field> fieldList = new ArrayList<Field>(10);
                fieldList.add(new Field("index", (DataType)DateType.IntegerType));
                fieldList.add(new Field(String.valueOf(defaultMaterialElement), (DataType)DateType.BigDecimalType));
                for (Object costSubElement : costSubElements) {
                    long l = costSubElement.getDynamicObject("fbasedataid").getLong("id");
                    if (defaultMaterialElement == l) continue;
                    Field field = new Field(String.valueOf(l), (DataType)DataType.BigDecimalType);
                    fieldList.add(field);
                }
                DataSetBuilder priceDataSetBuilder = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(new RowMeta(fieldList.toArray(new Field[0])));
                if (maps == null || maps.isEmpty()) {
                    logger.info("calculateInCost-getprice : {}", (Object)"\u65e0\u7b26\u5408\u6761\u4ef6\u7684\u53d6\u4ef7\u89c4\u5219");
                    return;
                }
                for (Map.Entry entry : maps.entrySet()) {
                    Integer index = (Integer)entry.getKey();
                    Map subEleUnitCostMap = (Map)entry.getValue();
                    ArrayList<Number> valueList = new ArrayList<Number>(16);
                    valueList.add(index);
                    BigDecimal matEleUnitCost = (BigDecimal)subEleUnitCostMap.get(defaultMaterialElement);
                    valueList.add(matEleUnitCost);
                    for (DynamicObject costSubElement : costSubElements) {
                        long subEleId = costSubElement.getDynamicObject("fbasedataid").getLong("id");
                        if (defaultMaterialElement == subEleId) continue;
                        BigDecimal subEleUnitCost = (BigDecimal)subEleUnitCostMap.get(subEleId);
                        valueList.add(subEleUnitCost);
                    }
                    priceDataSetBuilder.append(valueList.toArray());
                }
                DataSet priceDataSet = priceDataSetBuilder.build();
                long l = System.currentTimeMillis();
                logger.info("calculateInCost-getprice-timecost : {}", (Object)(l - jobStartTime));
                CacheHint cacheHint = new CacheHint();
                cacheHint.setTimeout(3600L, TimeUnit.SECONDS);
                CachedDataSet cache = priceDataSet.cache(cacheHint);
                String cacheId = cache.getCacheId();
                cacheId = CALCULATE_PRICE + cacheId;
                this.getPageCache().put("cacheId", cacheId);
                this.putPageIdCacheValue(cacheId, lastQueryVersion);
                bar.setPercent(70);
                String first = ResManager.loadKDString((String)"\u5f02\u6b65\u53d6\u4ef7\u5f00\u59cb", (String)"CalculateInCostPlugin_43", (String)"fi-cal-formplugin", (Object[])new Object[0]);
                this.getView().showSuccessNotification(first);
            }
            catch (Exception e) {
                this.getPageCache().put("cacheId", this.exPreStr + ExceptionUtils.getExceptionStackTraceMessage((Exception)new Exception(e)));
                logger.error("\u5165\u5e93\u6c47\u603b\u6838\u7b97\u53d6\u4ef7\u5931\u8d25", (Throwable)e);
            }
        });
    }

    private void doImportData(String costPriceNumber, boolean isCostRecordDetail, Long defaultMaterialElement) {
        DynamicObjectCollection entryRows = this.getModel().getEntryEntity("entryentity");
        int[] indexs = this.getSelectIndexs("entryentity");
        List<Map<String, Object>> parms = null;
        parms = indexs == null || indexs.length == 0 ? this.getMapFromDyObCo(entryRows) : this.getMapSelectFromDyObCo(entryRows);
        QFilter q = new QFilter("priceobject", "=", (Object)"A");
        q.and("entityobject", "=", (Object)"cal_in_calculate");
        Map maps = new CostPrice4Others().getPriceFromEntryParmsMap(parms, q, costPriceNumber);
        DynamicObjectCollection costSubElements = this.getModel().getDataEntity().getDynamicObjectCollection(this.COSTSUBELEMENT);
        if (maps != null && !maps.isEmpty()) {
            int precision = Integer.parseInt(this.getPageCache().get(this.AMT_PRECISION));
            this.getModel().beginInit();
            for (Map.Entry map : maps.entrySet()) {
                int rowIndex = (Integer)map.getKey();
                Map subEleUnitCostMap = (Map)map.getValue();
                BigDecimal qty = new BigDecimal(this.getModel().getValue(this.BASEQTY, rowIndex).toString());
                BigDecimal actualCost = (BigDecimal)this.getModel().getValue(this.ACTUALCOST, rowIndex);
                BigDecimal newUnitActualCost = BigDecimal.ZERO;
                if (!isCostRecordDetail) {
                    newUnitActualCost = (BigDecimal)subEleUnitCostMap.get(defaultMaterialElement);
                    newUnitActualCost = newUnitActualCost == null ? BigDecimal.ZERO : newUnitActualCost;
                    BigDecimal newActualCost = newUnitActualCost.multiply(qty).setScale(precision, RoundingMode.HALF_UP);
                    BigDecimal diffcost = newActualCost.subtract(actualCost);
                    BigDecimal oldMaterialCost = (BigDecimal)this.getModel().getValue(this.MATERIALCOST, rowIndex);
                    BigDecimal newMaterialCost = oldMaterialCost.add(diffcost);
                    this.getModel().setValue(this.UNITMATERIALCOST, (Object)this.calUnitCostByAct(qty, newMaterialCost), rowIndex);
                    this.getModel().setValue(this.MATERIALCOST, (Object)newMaterialCost, rowIndex);
                    this.getView().updateView(this.UNITMATERIALCOST, rowIndex);
                    this.getView().updateView(this.MATERIALCOST, rowIndex);
                    actualCost = newActualCost;
                }
                for (DynamicObject costSubElement : costSubElements) {
                    DynamicObject info = costSubElement.getDynamicObject("fbasedataid");
                    long subEleId = info.getLong("id");
                    String subEleNum = info.getString("number");
                    BigDecimal subEleUnitCost = (BigDecimal)subEleUnitCostMap.get(subEleId);
                    if (subEleUnitCost == null) {
                        subEleUnitCost = BigDecimal.ZERO;
                    }
                    BigDecimal subEleCost = subEleUnitCost.multiply(qty).setScale(precision, RoundingMode.HALF_UP);
                    BigDecimal oldSubEleCost = (BigDecimal)this.getModel().getValue(subEleNum + "_cost", rowIndex);
                    actualCost = actualCost.subtract(oldSubEleCost).add(subEleCost);
                    this.getModel().setValue(subEleNum + "_unitcost", (Object)subEleUnitCost, rowIndex);
                    this.getModel().setValue(subEleNum + "_cost", (Object)subEleCost, rowIndex);
                    this.getView().updateView(subEleNum + "_unitcost", rowIndex);
                    this.getView().updateView(subEleNum + "_cost", rowIndex);
                }
                this.getModel().setValue(this.ACTUALCOST, (Object)actualCost, rowIndex);
                if (newUnitActualCost != null && newUnitActualCost.signum() != 0) {
                    this.getModel().setValue(this.UNITACTUALCOST, (Object)newUnitActualCost, rowIndex);
                } else {
                    this.getModel().setValue(this.UNITACTUALCOST, (Object)this.calUnitCostByAct(qty, actualCost), rowIndex);
                }
                this.getView().updateView(this.ACTUALCOST, rowIndex);
                this.getView().updateView(this.UNITACTUALCOST, rowIndex);
            }
            this.getModel().endInit();
        }
    }

    private List<Map<String, Object>> getMapFromDyObCo(DynamicObjectCollection entryRows) {
        ArrayList<Map<String, Object>> parms = new ArrayList<Map<String, Object>>(16);
        String serialVal = this.getPageCache().get(GROUP_COL_ALL);
        HashSet<Object> allGroupKeysSet = new HashSet();
        if (!StringUtils.isEmpty((CharSequence)serialVal)) {
            String[] allGroupKeys = (String[])SerializationUtils.fromJsonString((String)serialVal, String[].class);
            allGroupKeysSet = new HashSet<String>(Arrays.asList(allGroupKeys));
        }
        HashMap<String, HashSet<Object>> diffCols = new HashMap<String, HashSet<Object>>();
        Set exFieldSet = CommonSettingHelper.getExFieldSet();
        int i = 0;
        for (DynamicObject dynamicObject : entryRows) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("rowIndex", i++);
            map.put("calorg", ((DynamicObject)this.getModel().getValue(this.CALORG)).getPkValue());
            map.put("costaccount", ((DynamicObject)this.getModel().getValue(this.COSTACCOUNT)).getPkValue());
            map.put("material", ((DynamicObject)dynamicObject.get("material")).getPkValue());
            map.put("materialGroup", dynamicObject.get("material.group") == null ? Long.valueOf(0L) : ((DynamicObject)dynamicObject.get("material.group")).getPkValue());
            map.put("owner", dynamicObject.get("owner") == null ? Long.valueOf(0L) : ((DynamicObject)dynamicObject.get("owner")).getPkValue());
            map.put("storageorgunit", dynamicObject.get("storageorgunit") == null ? Long.valueOf(0L) : ((DynamicObject)dynamicObject.get("storageorgunit")).getPkValue());
            map.put("warehouse", dynamicObject.get("warehouse") == null ? Long.valueOf(0L) : ((DynamicObject)dynamicObject.get("warehouse")).getPkValue());
            map.put("location", dynamicObject.get("location") == null ? Long.valueOf(0L) : ((DynamicObject)dynamicObject.get("location")).getPkValue());
            map.put("assist", dynamicObject.get("assist") == null ? Long.valueOf(0L) : ((DynamicObject)dynamicObject.get("assist")).getPkValue());
            map.put("lot", dynamicObject.get("lot"));
            map.put("project", dynamicObject.get("project") == null ? Long.valueOf(0L) : ((DynamicObject)dynamicObject.get("project")).getPkValue());
            if (!diffCols.containsKey(CACHE_DIFF_COL)) {
                HashSet fixCols = new HashSet(map.keySet());
                allGroupKeysSet.removeAll(fixCols);
                diffCols.put(CACHE_DIFF_COL, allGroupKeysSet);
            }
            exFieldSet.addAll((Collection)diffCols.get(CACHE_DIFF_COL));
            if (!exFieldSet.isEmpty()) {
                for (String exField : exFieldSet) {
                    Object exFieldValue = null;
                    exFieldValue = dynamicObject.get(exField) instanceof DynamicObject ? dynamicObject.getDynamicObject(exField).getPkValue() : dynamicObject.get(exField);
                    map.put(exField, exFieldValue);
                }
            }
            parms.add(map);
        }
        return parms;
    }

    private List<Map<String, Object>> getMapSelectFromDyObCo(DynamicObjectCollection entryRows) {
        ArrayList<Map<String, Object>> parms = new ArrayList<Map<String, Object>>(16);
        int[] indexs = this.getSelectIndexs("entryentity");
        DynamicObjectCollection entityColl = this.getModel().getEntryEntity("entryentity");
        String serialVal = this.getPageCache().get(GROUP_COL_ALL);
        HashSet<Object> allGroupKeysSet = new HashSet();
        if (!StringUtils.isEmpty((CharSequence)serialVal)) {
            String[] allGroupKeys = (String[])SerializationUtils.fromJsonString((String)serialVal, String[].class);
            allGroupKeysSet = new HashSet<String>(Arrays.asList(allGroupKeys));
        }
        HashMap<String, HashSet<Object>> diffCols = new HashMap<String, HashSet<Object>>();
        Set exFieldSet = CommonSettingHelper.getExFieldSet();
        for (int index : indexs) {
            DynamicObject dynamicObject = (DynamicObject)entityColl.get(index);
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("rowIndex", index);
            map.put("calorg", ((DynamicObject)this.getModel().getValue(this.CALORG)).getPkValue());
            map.put("costaccount", ((DynamicObject)this.getModel().getValue(this.COSTACCOUNT)).getPkValue());
            map.put("material", ((DynamicObject)dynamicObject.get("material")).getPkValue());
            map.put("materialGroup", dynamicObject.get("material.group") == null ? Long.valueOf(0L) : ((DynamicObject)dynamicObject.get("material.group")).getPkValue());
            map.put("owner", dynamicObject.get("owner") == null ? Long.valueOf(0L) : ((DynamicObject)dynamicObject.get("owner")).getPkValue());
            map.put("storageorgunit", dynamicObject.get("storageorgunit") == null ? Long.valueOf(0L) : ((DynamicObject)dynamicObject.get("storageorgunit")).getPkValue());
            map.put("warehouse", dynamicObject.get("warehouse") == null ? Long.valueOf(0L) : ((DynamicObject)dynamicObject.get("warehouse")).getPkValue());
            map.put("location", dynamicObject.get("location") == null ? Long.valueOf(0L) : ((DynamicObject)dynamicObject.get("location")).getPkValue());
            map.put("assist", dynamicObject.get("assist") == null ? Long.valueOf(0L) : ((DynamicObject)dynamicObject.get("assist")).getPkValue());
            map.put("lot", dynamicObject.get("lot"));
            map.put("project", dynamicObject.get("project") == null ? Long.valueOf(0L) : ((DynamicObject)dynamicObject.get("project")).getPkValue());
            if (!diffCols.containsKey(CACHE_DIFF_COL)) {
                HashSet fixCols = new HashSet(map.keySet());
                allGroupKeysSet.removeAll(fixCols);
                diffCols.put(CACHE_DIFF_COL, allGroupKeysSet);
            }
            exFieldSet.addAll((Collection)diffCols.get(CACHE_DIFF_COL));
            if (!exFieldSet.isEmpty()) {
                for (String exField : exFieldSet) {
                    Object exFieldValue = null;
                    exFieldValue = dynamicObject.get(exField) instanceof DynamicObject ? dynamicObject.getDynamicObject(exField).getPkValue() : dynamicObject.get(exField);
                    map.put(exField, exFieldValue);
                }
            }
            parms.add(map);
        }
        return parms;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String propertyName = property.getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        DynamicObjectCollection costSubElements = (DynamicObjectCollection)this.getModel().getValue(this.COSTSUBELEMENT);
        Set<String> costSubEleNumberSet = SubEntityUtil.getSubEleFieldNumSet(costSubElements);
        this.getModel().beginInit();
        if (this.MATERIALCOST.equals(propertyName) || this.PROCESSCOST.equals(propertyName)) {
            BigDecimal qty = new BigDecimal(this.getModel().getValue(this.BASEQTY, rowIndex).toString());
            BigDecimal newCost = (BigDecimal)changeData.getNewValue();
            String unitFileName = this.MATERIALCOST.equals(propertyName) ? this.UNITMATERIALCOST : this.UNITPROCESSCOST;
            this.getModel().setValue(unitFileName, (Object)this.calUnitCostByAct(qty, newCost), rowIndex);
            BigDecimal actualCost = (BigDecimal)this.getModel().getValue(this.ACTUALCOST, rowIndex);
            BigDecimal newActCost = actualCost.subtract((BigDecimal)changeData.getOldValue()).add(newCost);
            this.getModel().setValue(this.ACTUALCOST, (Object)newActCost, rowIndex);
            this.getModel().setValue(this.UNITACTUALCOST, (Object)this.calUnitCostByAct(qty, newActCost), rowIndex);
            this.getModel().endInit();
            this.getView().updateView(propertyName, rowIndex);
            this.getView().updateView(unitFileName, rowIndex);
            this.getView().updateView(this.ACTUALCOST, rowIndex);
            this.getView().updateView(this.UNITACTUALCOST, rowIndex);
        } else if (this.UNITMATERIALCOST.equals(propertyName) || this.UNITPROCESSCOST.equals(propertyName)) {
            BigDecimal qty = new BigDecimal(this.getModel().getValue(this.BASEQTY, rowIndex).toString());
            BigDecimal newUnitCost = (BigDecimal)changeData.getNewValue();
            int precision = Integer.parseInt(this.getPageCache().get(this.AMT_PRECISION));
            String costFileName = this.UNITMATERIALCOST.equals(propertyName) ? this.MATERIALCOST : this.PROCESSCOST;
            BigDecimal oldCost = (BigDecimal)this.getModel().getValue(costFileName, rowIndex);
            BigDecimal newCost = newUnitCost.multiply(qty).setScale(precision, RoundingMode.HALF_UP);
            BigDecimal actualCost = (BigDecimal)this.getModel().getValue(this.ACTUALCOST, rowIndex);
            BigDecimal newActCost = actualCost.subtract(oldCost).add(newCost);
            this.getModel().setValue(this.ACTUALCOST, (Object)newActCost, rowIndex);
            this.getModel().setValue(this.UNITACTUALCOST, (Object)this.calUnitCostByAct(qty, newActCost), rowIndex);
            this.getModel().setValue(costFileName, (Object)newCost, rowIndex);
            this.getModel().endInit();
            this.getView().updateView(propertyName, rowIndex);
            this.getView().updateView(costFileName, rowIndex);
            this.getView().updateView(this.ACTUALCOST, rowIndex);
            this.getView().updateView(this.UNITACTUALCOST, rowIndex);
        } else if (this.ACTUALCOST.equals(propertyName)) {
            BigDecimal qty = (BigDecimal)this.getModel().getValue(this.BASEQTY, rowIndex);
            BigDecimal fee = (BigDecimal)this.getModel().getValue(this.FEE, rowIndex);
            BigDecimal processCost = (BigDecimal)this.getModel().getValue(this.PROCESSCOST, rowIndex);
            BigDecimal newCost = (BigDecimal)changeData.getNewValue();
            BigDecimal newMatCost = newCost.subtract(fee).subtract(processCost);
            this.getModel().setValue(this.MATERIALCOST, (Object)newMatCost, rowIndex);
            this.getModel().setValue(this.UNITMATERIALCOST, (Object)this.calUnitCostByAct(qty, newMatCost), rowIndex);
            this.getModel().setValue(this.UNITACTUALCOST, (Object)this.calUnitCostByAct(qty, newCost), rowIndex);
            this.getModel().endInit();
            this.getView().updateView(propertyName, rowIndex);
            this.getView().updateView(this.UNITACTUALCOST, rowIndex);
            this.getView().updateView(this.MATERIALCOST, rowIndex);
            this.getView().updateView(this.UNITMATERIALCOST, rowIndex);
        } else if (this.UNITACTUALCOST.equals(propertyName)) {
            BigDecimal qty = (BigDecimal)this.getModel().getValue(this.BASEQTY, rowIndex);
            int precision = Integer.parseInt(this.getPageCache().get(this.AMT_PRECISION));
            BigDecimal newUnitCost = (BigDecimal)changeData.getNewValue();
            BigDecimal newCost = newUnitCost.multiply(qty).setScale(precision, RoundingMode.HALF_UP);
            this.getModel().setValue(this.ACTUALCOST, (Object)newCost, rowIndex);
            BigDecimal fee = (BigDecimal)this.getModel().getValue(this.FEE, rowIndex);
            BigDecimal processCost = (BigDecimal)this.getModel().getValue(this.PROCESSCOST, rowIndex);
            BigDecimal newMatCost = newCost.subtract(fee).subtract(processCost);
            this.getModel().setValue(this.MATERIALCOST, (Object)newMatCost, rowIndex);
            this.getModel().setValue(this.UNITMATERIALCOST, (Object)this.calUnitCostByAct(qty, newMatCost), rowIndex);
            this.getModel().endInit();
            this.getView().updateView(propertyName, rowIndex);
            this.getView().updateView(this.ACTUALCOST, rowIndex);
            this.getView().updateView(this.MATERIALCOST, rowIndex);
            this.getView().updateView(this.UNITMATERIALCOST, rowIndex);
        } else if (costSubEleNumberSet.contains(propertyName)) {
            int precision = Integer.parseInt(this.getPageCache().get(this.AMT_PRECISION));
            SubEntityUtil.subEleCostChange(propertyName, changeData, this.getModel(), precision, this.getView());
            this.getModel().endInit();
        } else {
            if (this.COSTACCOUNT.equals(propertyName)) {
                this.costAccountChange();
            } else if (this.BIZTYPE.equals(propertyName)) {
                this.bizTypeChange();
            } else if (this.YEAR.equals(propertyName) || this.PERIOD_NUM.equals(propertyName)) {
                this.periodChange();
            } else if (this.MATERIALFROM.equals(propertyName)) {
                this.materialFromChange();
            } else if (this.CALORG.equals(propertyName)) {
                this.calorgChange();
            } else if (this.WAREHOUSE.equals(propertyName)) {
                this.getModel().setValue(this.LOCATUINFILTER, null);
            } else if (this.BILLTYPE.equals(propertyName)) {
                this.getModel().setValue(this.BDBIZTYPE, null);
                this.getModel().setValue(this.INVSCHEME, null);
            } else if (this.BDBIZTYPE.equals(propertyName)) {
                this.getModel().setValue(this.INVSCHEME, null);
            } else if (this.STORAGEORGUNITFILTER.equals(propertyName)) {
                this.getModel().setValue(this.WAREHOUSE, null);
            } else if (this.COSTSUBELEMENT.equals(propertyName)) {
                this.costSubElementChange();
            }
            this.getModel().endInit();
            if (GROUP_COL.equals(propertyName)) {
                this.changeGroupCol(e);
            }
        }
    }

    private void costSubElementChange() {
        DynamicObjectCollection costSubElements = (DynamicObjectCollection)this.getModel().getValue(this.COSTSUBELEMENT);
        int costSubElementMaxSize = CalDbParamServiceHelper.getInteger((String)"costsubelement_filter_max_size");
        if (costSubElements != null && costSubElements.size() > costSubElementMaxSize) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b50\u8981\u7d20\u6570\u91cf\u5927\u4e8e%s\uff0c\u8bf7\u52fe\u9009\u9700\u8981\u624b\u5de5\u7ef4\u62a4\u6210\u672c\u7684\u5b50\u8981\u7d20\u3002", (String)"CalculateInCostPlugin_47", (String)"fi-cal-formplugin", (Object[])new Object[0]), costSubElementMaxSize));
        }
    }

    private void changeGroupCol(PropertyChangedArgs e) {
        String[] split;
        String groupColValue;
        Object groupCol = this.getModel().getValue(GROUP_COL);
        String string = groupColValue = groupCol == null ? "" : String.valueOf(groupCol);
        if (StringUtils.isEmpty((CharSequence)groupColValue)) {
            ArrayList<String> groupChooseValueList = new ArrayList<String>();
            groupChooseValueList.add("cal_material");
            String chosenGroupCol = this.getGroupColJson(groupChooseValueList);
            this.getModel().setValue(GROUP_COL, (Object)chosenGroupCol);
            return;
        }
        HashSet<String> groupChooseValueList = new HashSet<String>(16);
        for (String s : split = groupColValue.split(",")) {
            if (StringUtils.isEmpty((CharSequence)s)) continue;
            groupChooseValueList.add(s);
        }
        ArrayList<String> comboItemCols = new ArrayList<String>();
        String[] settingGroupCols = CommonSettingHelper.getGroupCol();
        ArrayList<String> allCols = new ArrayList<String>(Arrays.asList(settingGroupCols));
        MainEntityType entitytype = EntityMetadataCache.getDataEntityType((String)"cal_costrecord");
        for (Object pro : entitytype.getProperties()) {
            String proName;
            if (!(pro instanceof BasedataProp) && !(pro instanceof TextProp) || !allCols.contains(proName = pro.getName())) continue;
            comboItemCols.add(proName);
        }
        EntityType entryentity = (EntityType)entitytype.getAllEntities().get("entry");
        for (IDataEntityProperty pro : entryentity.getProperties()) {
            String proName;
            if (!(pro instanceof BasedataProp) && !(pro instanceof TextProp) && !(pro instanceof ComboProp) || !allCols.contains(proName = pro.getName())) continue;
            comboItemCols.add(proName);
        }
        this.checkAndRefreshGroupCol(groupChooseValueList, comboItemCols);
        groupChooseValueList.removeAll(new ArrayList<String>(Arrays.asList(this.FIX_COL)));
        List<String> currentRemove = this.removeInfo(e);
        this.addStorageInfo(groupChooseValueList);
        if (!currentRemove.isEmpty()) {
            this.removeStorageInfo(currentRemove, groupChooseValueList);
        }
        this.addOwnerInfo(groupChooseValueList);
        if (!currentRemove.isEmpty()) {
            this.removeOwnerInfo(currentRemove, groupChooseValueList);
        }
        groupChooseValueList.add("cal_material");
        String chosenGroupCol = this.getGroupColJson(groupChooseValueList);
        this.getModel().setValue(GROUP_COL, (Object)chosenGroupCol);
        this.getPageCache().put(GROUP_COL, chosenGroupCol);
    }

    private void checkAndRefreshGroupCol(Collection<String> chosenGroupCols, Collection<String> comboItemCols) {
        HashSet<String> tmp = new HashSet<String>(chosenGroupCols);
        tmp.remove("cal_material");
        tmp.remove("cal_group");
        tmp.removeAll(comboItemCols);
        if (!tmp.isEmpty()) {
            chosenGroupCols.removeAll(tmp);
            String chosenGroupCol = this.getGroupColJson(chosenGroupCols);
            this.getModel().setValue(GROUP_COL, (Object)chosenGroupCol);
        }
    }

    private String getGroupColJson(Collection<String> groupChooseValueList) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> groupChooseTmp = new ArrayList<String>(groupChooseValueList);
        for (int i = 0; i < groupChooseTmp.size(); ++i) {
            if (i == groupChooseTmp.size() - 1) {
                sb.append((String)groupChooseTmp.get(i));
                continue;
            }
            sb.append((String)groupChooseTmp.get(i)).append(",");
        }
        return sb.toString();
    }

    private List<String> removeInfo(PropertyChangedArgs e) {
        ChangeData data = e.getChangeSet()[0];
        String oldvalue = (String)data.getOldValue();
        String newvalue = (String)data.getNewValue();
        if (oldvalue == null || newvalue == null) {
            return new ArrayList<String>(1);
        }
        String[] oldValue = oldvalue.split(",");
        String[] newValue = newvalue.split(",");
        ArrayList<String> oldList = new ArrayList<String>(Arrays.asList(oldValue));
        ArrayList<String> newList = new ArrayList<String>(Arrays.asList(newValue));
        newList.retainAll(oldList);
        oldList.removeAll(newList);
        return oldList;
    }

    private void removeStorageInfo(List<String> currentRemove, Set<String> groupChooseValueList) {
        if (currentRemove.contains("storageorgunit") && !groupChooseValueList.contains("warehouse") && !groupChooseValueList.contains("location")) {
            List<String> storage = Stream.of(this.STORAGE_ORG_REMOVE).collect(Collectors.toList());
            this.removeChoose(groupChooseValueList, storage);
        }
        if (currentRemove.contains("warehouse") && !groupChooseValueList.contains("location")) {
            List<String> warehouse = Stream.of(this.WAREHOUSE_REMOVE).collect(Collectors.toList());
            this.removeChoose(groupChooseValueList, warehouse);
        }
        if (currentRemove.contains("location")) {
            List<String> location = Stream.of(this.LOCATION_REMOVE).collect(Collectors.toList());
            this.removeChoose(groupChooseValueList, location);
        }
    }

    private void addStorageInfo(Set<String> groupChooseValueList) {
        if (groupChooseValueList == null || groupChooseValueList.isEmpty()) {
            return;
        }
        if (groupChooseValueList.contains("storageorgunit")) {
            List<String> storage = Stream.of(this.STORAGE_ORG_RELATION).collect(Collectors.toList());
            this.addChoose(groupChooseValueList, storage);
        }
        if (groupChooseValueList.contains("warehouse")) {
            List<String> warehouse = Stream.of(this.WAREHOUSE_RELATION).collect(Collectors.toList());
            this.addChoose(groupChooseValueList, warehouse);
        }
        if (groupChooseValueList.contains("location")) {
            List<String> location = Stream.of(this.LOCATION_RELATION).collect(Collectors.toList());
            this.addChoose(groupChooseValueList, location);
        }
    }

    private void addOwnerInfo(Set<String> groupChooseValueList) {
        if (groupChooseValueList == null || groupChooseValueList.isEmpty()) {
            return;
        }
        if (groupChooseValueList.contains("owner") || groupChooseValueList.contains("ownertype")) {
            List<String> owner = Stream.of(this.OWNER_RELATION).collect(Collectors.toList());
            this.addChoose(groupChooseValueList, owner);
        }
    }

    private void removeOwnerInfo(List<String> currentRemove, Set<String> groupChooseValueList) {
        if (groupChooseValueList == null || groupChooseValueList.isEmpty()) {
            return;
        }
        if (currentRemove.contains("owner") || currentRemove.contains("ownertype")) {
            List<String> owner = Stream.of(this.OWNER_RELATION).collect(Collectors.toList());
            this.removeChoose(groupChooseValueList, owner);
        }
    }

    private void addChoose(Set<String> groupChooseValueList, List<String> waitAddColList) {
        if (waitAddColList == null || waitAddColList.isEmpty()) {
            return;
        }
        groupChooseValueList.addAll(waitAddColList);
    }

    private void removeChoose(Set<String> groupChooseValueList, List<String> waitDeleteColList) {
        if (waitDeleteColList.isEmpty()) {
            return;
        }
        groupChooseValueList.removeAll(waitDeleteColList);
    }

    private void calorgChange() {
        DynamicObject calorgObj = (DynamicObject)this.getModel().getValue(this.CALORG);
        this.getModel().setValue("mainorgfilter", (Object)calorgObj);
        if (calorgObj == null) {
            this.getModel().setValue(this.COSTACCOUNT, null);
            this.getModel().setValue(this.YEAR, null);
            this.getModel().setValue(this.PERIOD_NUM, null);
            return;
        }
        Long costAccountid = PeriodHelper.getCostAccountByCalOrgAndSysctrlentity((Long)calorgObj.getLong("id"));
        if (costAccountid != null) {
            this.getModel().setValue(this.COSTACCOUNT, (Object)costAccountid);
        } else {
            this.getModel().setValue(this.COSTACCOUNT, null);
        }
        this.getModel().setValue(this.STORAGEORGUNITFILTER, null);
        this.getModel().setValue(this.OWNERFILTER, null);
        this.getModel().setValue(this.WAREHOUSE, null);
        this.getModel().setValue(this.LOCATUINFILTER, null);
        this.getView().updateView(this.COSTACCOUNT);
        this.getView().updateView(this.STORAGEORGUNITFILTER);
        this.getView().updateView(this.OWNERFILTER);
        this.getView().updateView(this.WAREHOUSE);
        this.getView().updateView(this.LOCATUINFILTER);
        this.costAccountChange();
    }

    private BigDecimal calUnitCostByAct(BigDecimal qty, BigDecimal cost) {
        int precision = 10;
        BigDecimal unitCost = BigDecimal.ZERO;
        if (qty.compareTo(BigDecimal.ZERO) != 0) {
            unitCost = cost.divide(qty, precision, RoundingMode.HALF_UP);
        }
        return unitCost;
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        String opKey = event.getOperateKey();
        if ("incal".equals(opKey)) {
            this.checkRequireIsNull();
            this.doJob();
        } else if ("incalall".equals(opKey)) {
            this.checkRequireIsNull();
            this.doJobAll();
        }
        if ("ok2filte".equals(opKey)) {
            boolean original = this.getView().getModel().getDataChanged();
            this.checkRequireIsNull();
            this.beforeOKcheck();
            HashMap<String, Object> retValue = new HashMap<String, Object>();
            DynamicObject entity = this.getModel().getDataEntity();
            String policyID = entity.getDynamicObject(this.COSTACCOUNT).getString("calpolicy.id");
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)policyID, (String)"cal_bd_calpolicy");
            DynamicObject currency = obj.getDynamicObject("currency");
            this.loadHeadData(currency);
            this.getPageCache().put(this.AMT_PRECISION, String.valueOf(currency.getInt("amtprecision")));
            retValue.put(GROUP_COL, this.getModel().getValue(GROUP_COL));
            retValue.put("filter", this.buildFilter());
            this.queryDataByFilter(retValue);
            ((Container)this.getControl("filterpanel")).setCollapse(Boolean.TRUE.booleanValue());
            this.getPageCache().put("wetherchange", String.valueOf(original));
            DynamicObjectCollection costSubElements = entity.getDynamicObjectCollection(this.COSTSUBELEMENT);
            DynamicFieldCreateHelper.dynAddElementCostFields((DynamicObjectCollection)costSubElements, (IFormView)this.getView(), (String)"cal_in_calculate", (DynamicObject)currency);
            if (!costSubElements.isEmpty()) {
                int entryRowCount = this.getModel().getEntryRowCount("entryentity");
                for (int i = 0; i < entryRowCount; ++i) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{this.UNITACTUALCOST, this.ACTUALCOST});
                }
                return;
            }
            String ominTypeStr = this.getPageCache().get(this.ISOMINBILLTYPE);
            boolean isOminBillType = Boolean.parseBoolean(ominTypeStr);
            int entryRowCount = this.getModel().getEntryRowCount("entryentity");
            for (int i = 0; i < entryRowCount; ++i) {
                this.getView().setEnable(Boolean.valueOf(isOminBillType), i, new String[]{this.UNITPROCESSCOST, this.PROCESSCOST});
            }
        } else if ("viewlog".equals(opKey)) {
            this.checkRequireIsNull();
            this.viewLog();
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        EntryElement entryElement = DynamicFieldCreateHelper.getEntryElement((IPageCache)this.getPageCache(), (String)"cal_in_calculate");
        ArrayList<EntryElement> items = new ArrayList<EntryElement>(entryElement.getItems());
        items.add(entryElement);
        Optional<Element> first = items.stream().filter(x -> x.getName().equalsIgnoreCase(key)).findFirst();
        if (first.isPresent()) {
            Element element = first.get();
            Control control = element.getControl(this.getView());
            e.setControl(control);
        }
    }

    private void loadHeadData(DynamicObject currency) {
        this.getModel().beginInit();
        this.getModel().setValue("currency", (Object)currency);
        this.getModel().endInit();
        this.getView().updateView("currency");
    }

    private void queryDataByFilter(Map retValue) {
        if (retValue == null) {
            return;
        }
        this.sumType = retValue.get(GROUP_COL).toString();
        this.getPageCache().put("mulsumType", this.sumType);
        QFilter filter = (QFilter)retValue.get("filter");
        this.getPageCache().put(this.QFILTER, filter.toSerializedString());
        boolean isOminBillType = this.checkOminBillType();
        this.getPageCache().put(this.ISOMINBILLTYPE, String.valueOf(isOminBillType));
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])this.getShardingHint());){
            ctx.set();
            this.loadDataByFilter(filter);
        }
    }

    private ShardingHintContext.ShardingHintCondition[] getShardingHint() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costAccountInfo = dataEntity.getDynamicObject(this.COSTACCOUNT);
        Date starttime = dataEntity.getDate("starttime");
        Date endtime = dataEntity.getDate("endtime");
        return new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fcostaccountid", FilterType.eq, (Object)costAccountInfo.getLong("id")), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.ge, (Object)starttime), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.le, (Object)endtime)};
    }

    private void downExcel() throws Exception {
        String billFormId = "cal_costrecord";
        String extendData = null;
        String t = "604970005607568384";
        LocalDate now = LocalDate.now();
        DynamicObject templateData = null;
        String ctxPath = RequestContext.get().getClientFullContextPath();
        templateData = BusinessDataServiceHelper.loadSingle((Object)t, (String)"bos_importtemplate");
        String fileName = String.format(ResManager.loadKDString((String)"\u9884\u7f6e_%1$s", (String)"CalculateInCostPlugin_32", (String)"fi-cal-formplugin", (Object[])new Object[0]), templateData.get("name"));
        String url = ctxPath + (ctxPath.endsWith("/") ? "" : "/") + "form/export.do?templateid=" + t + "&formid=" + billFormId + "&plugin=&filename=" + URLEncoder.encode(fileName + "_" + String.format("%02d", now.getMonthValue()) + String.format("%02d", now.getDayOfMonth()) + ".xlsx", "UTF-8") + "&extenddata=" + extendData + "&routeappid=" + this.getView().getFormShowParameter().getServiceAppId() + "&a=t";
        this.getView().download(url);
        this.getView().sendFormAction(this.getView());
    }

    private void refreshPage() {
        String str = this.getPageCache().get(this.QFILTER);
        if (null != str) {
            QFilter filter = QFilter.fromSerializedString((String)str);
            try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])this.getShardingHint());){
                ctx.set();
                this.loadDataByFilter(filter);
            }
        }
    }

    private List<String> buildCalInStrParamsBatch(int pageStart, int pageEnd, DynamicObjectCollection entryDycs, DynamicObjectCollection costSubElements) {
        ArrayList<String> retValue = new ArrayList<String>(32);
        IDataModel model = this.getModel();
        for (int index = pageStart; index <= pageEnd; ++index) {
            DynamicObject entity = (DynamicObject)entryDycs.get(index);
            CalculateInParams param = new CalculateInParams();
            param.setGatherID(entity.getString("gatherid"));
            param.setUnitActualCost(entity.getBigDecimal("unitactualcost"));
            param.setActualCost(entity.getBigDecimal("actualcost"));
            param.setBaseqty(entity.getBigDecimal("baseqty"));
            param.setUnitMaterialCost(entity.getBigDecimal("unitmaterialcost"));
            param.setMaterialCost(entity.getBigDecimal("materialcost"));
            param.setUnitProcessCost(entity.getBigDecimal("unitprocesscost"));
            param.setProcessCost(entity.getBigDecimal("processcost"));
            if (!costSubElements.isEmpty()) {
                ArrayList<CostSubElementInfo> subElementInfoList = new ArrayList<CostSubElementInfo>(costSubElements.size());
                for (DynamicObject costSubElement : costSubElements) {
                    DynamicObject info = costSubElement.getDynamicObject("fbasedataid");
                    long id = info.getLong("id");
                    String subEleNum = info.getString("number");
                    String type = info.getString("type");
                    BigDecimal subEleUnitCost = entity.getBigDecimal(subEleNum + "_unitcost");
                    BigDecimal subEleCost = entity.getBigDecimal(subEleNum + "_cost");
                    CostSubElementInfo subElementInfo = new CostSubElementInfo(id, subEleNum, subEleUnitCost, subEleCost, type);
                    subElementInfoList.add(subElementInfo);
                }
                param.setSubElementInfoList(subElementInfoList);
            }
            try {
                retValue.add(JSONUtils.toString((Object)param));
                continue;
            }
            catch (IOException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", ""), new Object[0]);
            }
        }
        return retValue;
    }

    public DBRoute getCalDBRouteKey() {
        return new DBRoute("cal");
    }

    private void loadDataByFilter(QFilter filters) {
        EstimateAdjustInPurValidator validator = new EstimateAdjustInPurValidator();
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.setPercent(0);
        this.getPageCache().put(PROGRESS_KEY, "15");
        bar.start();
        String maxVersionStr = this.getPageIdCacheValue(MAX_QUERY);
        int maxVersion = 1;
        if (maxVersionStr != null) {
            maxVersion = Integer.parseInt(maxVersionStr) + 1;
        }
        String newMaxVersionStr = String.valueOf(maxVersion);
        this.putPageIdCacheValue(MAX_QUERY, newMaxVersionStr);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costAccountInfo = dataEntity.getDynamicObject(this.COSTACCOUNT);
        Date starttime = dataEntity.getDate("starttime");
        Date endtime = dataEntity.getDate("endtime");
        ThreadPools.executeOnceIncludeRequestContext((String)(((Object)((Object)this)).getClass().getName() + "loadDataByFilter"), () -> {
            DataSet detailDataset = null;
            DataSet gatherDataset = null;
            try (AlgoContext context = Algo.newContext();){
                int period;
                long costAccountId = costAccountInfo.getLong("id");
                boolean isCostRecordDetail = ParamsHelper.getCostElementByCostAccount((long)costAccountId);
                detailDataset = this.buildDetailDataNew(filters, costAccountId, starttime, endtime, isCostRecordDetail);
                DealCalRangeFunction function = null;
                Object groupColVal = this.getModel().getValue(GROUP_COL);
                String groupCol = groupColVal == null ? "" : (String)groupColVal;
                String[] split = groupCol.split(",");
                HashSet<String> specialChosen = new HashSet<String>();
                boolean isGroup = this.gatherSpColAndGroupMark(split, specialChosen);
                if (isGroup) {
                    function = this.getDealCalRangeFunction(detailDataset, specialChosen);
                    detailDataset = detailDataset.map((MapFunction)function);
                }
                TreeSet<String> orderExt = new TreeSet<String>(this.extendFields);
                this.extendFields = new ArrayList<String>(orderExt);
                this.getPageCache().put("extendFields", SerializationUtils.toJsonString(this.extendFields));
                String concatStr = this.getConcatStr();
                detailDataset = detailDataset.addField("concat(" + concatStr + ")", this.GATHERKEY);
                int year = this.getModel().getValue("year") == null ? 0 : (Integer)this.getModel().getValue("year");
                int n = period = this.getModel().getValue("periodnum") == null ? 0 : (Integer)this.getModel().getValue("periodnum");
                if (year > 0 && period > 0) {
                    detailDataset = validator.filterQueryData(detailDataset, year * 100 + period);
                }
                gatherDataset = this.buildGatherDataNew(detailDataset, isCostRecordDetail);
                CacheHint cacheHint = new CacheHint();
                Integer timeoutMin = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.INCAL_DATASET_TIMEOUT);
                cacheHint.setTimeout((long)timeoutMin.intValue(), TimeUnit.MINUTES);
                CachedDataSet cache = gatherDataset.cache(cacheHint);
                String cacheId = cache.getCacheId();
                this.getPageCache().put("cacheId", cacheId);
                this.putPageIdCacheValue(cacheId, newMaxVersionStr);
                if (isGroup && function != null) {
                    Set keyCols = function.getRealGroupCols();
                    keyCols.addAll(specialChosen);
                    keyCols.add(CALRANGE);
                    this.getPageCache().put(REAL_COLS, SerializationUtils.toJsonString((Object)keyCols));
                }
            }
            catch (Throwable e) {
                this.getPageCache().put("cacheId", this.exPreStr + ExceptionUtils.getExceptionStackTraceMessage((Exception)new Exception(e)));
                logger.error("\u5165\u5e93\u6c47\u603b\u6838\u7b97\u67e5\u8be2\u5931\u8d25", e);
            }
            finally {
                if (detailDataset != null) {
                    detailDataset.close();
                }
                if (gatherDataset != null) {
                    gatherDataset.close();
                }
            }
        });
    }

    private Set<String> getElementNumSet(DynamicObjectCollection costSubElement) {
        HashSet<String> elementNumSet = new HashSet<String>(16);
        for (DynamicObject info : costSubElement) {
            String number = info.getDynamicObject("fbasedataid").getString("number");
            elementNumSet.add(number);
        }
        return elementNumSet;
    }

    private boolean gatherSpColAndGroupMark(String[] split, Set<String> specialChosen) {
        boolean isGroup = false;
        for (String s : split) {
            if (StringUtils.isEmpty((CharSequence)s)) continue;
            if ("cal_group".equals(s)) {
                isGroup = true;
                continue;
            }
            if ("cal_material".equals(s)) continue;
            specialChosen.add(s);
        }
        if (!isGroup) {
            specialChosen.clear();
        }
        return isGroup;
    }

    private DealCalRangeFunction getDealCalRangeFunction(DataSet detailDataset, Set<String> specialChosen) {
        DynamicObject accountDyc = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getCostAccountId(), (String)"cal_bd_costaccount");
        String divStr = accountDyc.getString("dividebasis.dividebasis");
        String calDimensionStr = CommonSettingHelper.getCalDimensionStr();
        Set<Long> emptyEntryRangeIds = this.getEmptyEntryRangeIds(this.getCostAccountId());
        DealCalRangeFunction function = new DealCalRangeFunction(emptyEntryRangeIds, divStr, calDimensionStr, detailDataset.getRowMeta());
        function.setBakDivDimField(false);
        function.setCalDimensionStrKey("caldimension");
        function.setExclusion(specialChosen);
        return function;
    }

    private DataSet buildDetailDataNew(QFilter filters, long costaccountid, Date starttime, Date endtime, boolean isCostRecordDetail) {
        String[] split;
        Set<Long> entryIdSet = this.getEntryidSet(filters, costaccountid, starttime, endtime);
        boolean isGroup = false;
        HashSet<String> totalGroupSet = new HashSet<String>();
        Object groupColVal = this.getModel().getValue(GROUP_COL);
        String groupCol = groupColVal == null ? "" : (String)groupColVal;
        for (String s : split = groupCol.split(",")) {
            if (StringUtils.isEmpty((CharSequence)s)) continue;
            if ("cal_group".equals(s)) {
                String[] divAndDimensionCols = this.getDivAndDimensionCols(this.getCostAccountId());
                totalGroupSet.addAll(new ArrayList<String>(Arrays.asList(divAndDimensionCols)));
                isGroup = true;
            }
            if ("cal_material".equals(s)) {
                totalGroupSet.addAll(new ArrayList<String>(Arrays.asList(this.FIX_COL)));
            }
            totalGroupSet.add(s);
        }
        if (!totalGroupSet.isEmpty()) {
            this.removeUnnecessary(totalGroupSet);
            if (isGroup) {
                totalGroupSet.add(CALRANGE);
            }
            totalGroupSet.remove("cal_group");
            totalGroupSet.remove("cal_material");
        }
        StringBuilder fields = new StringBuilder();
        fields.append("id,billno,calbillid,bizbillid,");
        fields.append("calbilltype,");
        fields.append("bizentityobject,");
        fields.append("entry.id,entry.calentryid,entry.bizbillentryid,");
        fields.append("costaccount,costaccount.id,costaccount.name,costaccount.calsystem.id,costaccount.calsystem.name,costaccount.calpolicy.id,costaccount.calpolicy.name,");
        fields.append("adminorg,costcenterorg,calorg,calorg.id,calorg.name,storageorgunit,storageorgunit.id,storageorgunit.name,storageorgunit.number as storageorgunitnumber,");
        fields.append("entry.ownertype as ownertype,entry.owner as owner,entry.owner.id as ownerid,entry.warehouse as warehouse,entry.warehouse.id,entry.warehouse.name,entry.warehouse.number as warehousenumber,entry.location as location,entry.location.id,entry.location.name,entry.location.number as locationnumber,");
        fields.append("entry.material as material,entry.material.id,entry.material.name,entry.material.number as materialnumber,entry.material.modelnum as model,");
        fields.append("entry.lot as lot,entry.project as project,entry.project.number as projectnumber,entry.baseunit as baseunit,entry.baseunit.id,entry.baseunit.name,entry.baseunit.number as baseunitnumber,entry.baseqty,entry.unitactualcost,entry.actualcost,");
        fields.append("entry.materialcost,entry.fee,entry.processcost,entry.manufacturecost,entry.resource,entry.assist as assist,entry.tracknumber as tracknumber,entry.calrange as calrange");
        fields.append(",costaccount.dividebasis as dividebasisid,costaccount.dividebasis.dividebasis as dividebasis,entry.caldimension as caldimensionid,entry.caldimension.caldimension as caldimension,entry.configuredcode as configuredcode,entry.ecostcenter as ecostcenter");
        if (isCostRecordDetail) {
            fields.append(",entry.subentrycostelement.costsubelement.number as costsubelement,entry.subentrycostelement.sub_actualcost as sub_actualcost");
        }
        MainEntityType costRecordEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costrecord");
        for (String allField : totalGroupSet) {
            if (fields.indexOf(allField) != -1) continue;
            IDataEntityProperty property = costRecordEntityType.findProperty(allField);
            if (!(property.getParent() instanceof EntryType)) {
                fields.append(",").append(allField).append(" as ").append(allField);
            } else {
                fields.append(",entry.").append(allField).append(" as ").append(allField);
            }
            this.extendFields.add(allField);
        }
        this.getPageCache().put("setVisibleFields", SerializationUtils.toJsonString(this.extendFields));
        List<Set<Long>> batchList = this.getBatchIdList(entryIdSet);
        ArrayList<OrmInput> billIOs = new ArrayList<OrmInput>(16);
        QFilter filter = new QFilter("costaccount", "=", (Object)costaccountid);
        filter.and("bookdate", ">=", (Object)starttime);
        filter.and("bookdate", "<=", (Object)endtime);
        if (batchList != null && batchList.size() > 0) {
            for (Set<Long> entryIdSetSplit : batchList) {
                QFilter entryIdf = new QFilter("entry.id", "in", entryIdSetSplit);
                OrmInput billIO = new OrmInput(((Object)((Object)this)).getClass() + "loadDataByFilter", "cal_costrecord_subentity", fields.toString(), new QFilter[]{entryIdf, filter});
                billIOs.add(billIO);
            }
        } else {
            QFilter entryIdf = QFilter.of((String)"1 <> 1", (Object[])new Object[0]);
            OrmInput billIO = new OrmInput(((Object)((Object)this)).getClass() + "loadDataByFilter", "cal_costrecord_subentity", fields.toString(), new QFilter[]{entryIdf, filter});
            billIOs.add(billIO);
        }
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSet rs = algo.createDataSet((Input[])billIOs.toArray(new OrmInput[billIOs.size()]));
        String[] omBitype = CostRecordQFilterHelper.getBiztype((String)"ominbiztype");
        StringBuilder ominFilterStr = new StringBuilder("bizentityobject not in ('");
        for (int i = 0; i < omBitype.length; ++i) {
            ominFilterStr.append(omBitype[i]);
            if (i == omBitype.length - 1) {
                ominFilterStr.append("')");
                break;
            }
            ominFilterStr.append("','");
        }
        rs = rs.filter(ominFilterStr.toString());
        return rs;
    }

    private Set<Long> getEntryidSet(QFilter filters, long costaccountid, Date starttime, Date endtime) {
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        filters.and(billStatusf);
        HashSet<Long> entryidSet1 = new HashSet<Long>(16);
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        HashSet<Long> bizBillEids = new HashSet<Long>(16);
        DataSet idSet1DataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "loadDataByFilter"), (String)"cal_costrecord", (String)"id,entry.id,bizbillid,entry.bizbillentryid as bizbillentryid", (QFilter[])new QFilter[]{filters}, (String)"");
        for (Row row : idSet1DataSet.copy()) {
            Long bizBillId = row.getLong("bizbillid");
            bizBillIds.add(bizBillId);
            bizBillEids.add(row.getLong("bizbillentryid"));
        }
        if (!bizBillEids.isEmpty() && !bizBillIds.isEmpty()) {
            String wfRecordSels = "entry.billentryid wfbizbillentryid";
            QFilter bizBillIdsF = new QFilter("entry.billid", "in", bizBillIds);
            QFilter bizBillEidsF = new QFilter("entry.billentryid", "in", bizBillEids);
            String[] omBitype = CostRecordQFilterHelper.getBiztype((String)"ominbiztype");
            QFilter billTypeF = new QFilter("entry.billtype", "in", (Object)omBitype);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_mdc_omwrfrecord", (String)wfRecordSels, (QFilter[])new QFilter[]{bizBillIdsF, bizBillEidsF, billTypeF}, null);
            DataSet inOsDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_oswfrecord", (String)wfRecordSels, (QFilter[])new QFilter[]{bizBillIdsF, bizBillEidsF, billTypeF}, null);
            DataSet wfRecordDs = dataSet.union(inOsDataSet).groupBy(new String[]{"wfbizbillentryid"}).finish();
            idSet1DataSet = idSet1DataSet.leftJoin(wfRecordDs).on("bizbillentryid", "wfbizbillentryid").select(idSet1DataSet.getRowMeta().getFieldNames(), wfRecordDs.getRowMeta().getFieldNames()).finish().filter("wfbizbillentryid is null");
        }
        for (Row row : idSet1DataSet) {
            Long entryid = row.getLong("entry.id");
            entryidSet1.add(entryid);
        }
        if (!entryidSet1.isEmpty()) {
            ArrayList<OrmInput> inputs = new ArrayList<OrmInput>(16);
            ArrayList<Long> entryIds = new ArrayList<Long>(entryidSet1);
            List partition = Lists.partition(entryIds, (int)100000);
            for (List batchIds : partition) {
                QFilter q = new QFilter("entry.ancestorentryid", "in", (Object)batchIds);
                q.and("issplitcreate", "=", (Object)Character.valueOf('1'));
                q.and("writeoffstatus", "=", (Object)Character.valueOf('A'));
                q.and("writeofftype", "=", (Object)Character.valueOf('B'));
                q.and("ischargeoffed", "=", (Object)false);
                q.and("ischargeoff", "=", (Object)false);
                String[] purBitype = CostRecordQFilterHelper.getBiztype((String)"purbiztype");
                q.and("bizentityobject", "in", (Object)purBitype);
                q.and("costaccount", "=", (Object)costaccountid);
                q.and("bookdate", ">=", (Object)starttime);
                q.and("bookdate", "<=", (Object)endtime);
                OrmInput billIO = new OrmInput(((Object)((Object)this)).getClass().getName(), "cal_costrecord", "id,entry.ancestorentryid", new QFilter[]{q});
                inputs.add(billIO);
            }
            Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
            DataSet idSet2DataSet = algo.createDataSet((Input[])inputs.toArray(new OrmInput[inputs.size()]));
            HashSet<Long> entryidSet2 = new HashSet<Long>(16);
            for (Row row : idSet2DataSet) {
                Long ancestorentryid = row.getLong("entry.ancestorentryid");
                entryidSet2.add(ancestorentryid);
            }
            if (!entryidSet2.isEmpty()) {
                entryidSet1.removeAll(entryidSet2);
            }
        }
        return entryidSet1;
    }

    private boolean hasField(String totalKey, String value) {
        return totalKey != null && totalKey.indexOf(value) >= 0;
    }

    private String loadRowData(Row row, int rowIndex, int pricePrecision, boolean isCostRecordDetail, DynamicObjectCollection costSubElements) {
        this.sumType = this.getPageCache().get("mulsumType");
        ArrayList<String> chosenGroupCol = new ArrayList<String>();
        boolean isGroup = false;
        if (!StringUtils.isEmpty((CharSequence)this.sumType)) {
            String[] split;
            for (String s : split = this.sumType.split(",")) {
                if (StringUtils.isEmpty((CharSequence)s)) continue;
                if ("cal_group".equals(s)) {
                    String[] divAndDimensionCols = this.getDivAndDimensionCols(this.getCostAccountId());
                    chosenGroupCol.addAll(new ArrayList<String>(Arrays.asList(divAndDimensionCols)));
                    isGroup = true;
                }
                if ("cal_material".equals(s)) {
                    chosenGroupCol.addAll(new ArrayList<String>(Arrays.asList(this.FIX_COL)));
                }
                chosenGroupCol.add(s);
            }
            if (!chosenGroupCol.isEmpty()) {
                this.removeUnnecessary(chosenGroupCol);
                if (isGroup) {
                    chosenGroupCol.add(CALRANGE);
                }
                chosenGroupCol.remove("cal_material");
                chosenGroupCol.remove("cal_group");
            }
        }
        if (!chosenGroupCol.isEmpty()) {
            String curField = null;
            Object curValue = null;
            try {
                Iterator iterator = chosenGroupCol.iterator();
                while (iterator.hasNext()) {
                    String s;
                    curField = s = (String)iterator.next();
                    curValue = row.get(s);
                    if ("owner".equals(s)) {
                        this.getModel().setValue("ownertype", row.get("ownertype"), rowIndex);
                    }
                    this.getModel().setValue(s, row.get(s), rowIndex);
                }
            }
            catch (Exception e) {
                String format = String.format(ResManager.loadKDString((String)"%1$s\u5b57\u6bb5\u9875\u9762\u672a\u914d\u7f6e\u3002", (String)"CalculateInCostPlugin_40", (String)"fi-cal-formplugin", (Object[])new Object[0]), curField);
                logger.info("field not found : " + curField + " : " + curValue + " : " + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                throw new KDBizException(format);
            }
        }
        BigDecimal baseQty = row.getBigDecimal("entry.baseqty");
        this.getModel().setValue(this.BASEQTY, (Object)baseQty, rowIndex);
        if (isCostRecordDetail) {
            this.setSubElementCost(row, rowIndex, costSubElements, baseQty, pricePrecision);
        } else {
            BigDecimal materialCost = row.getBigDecimal("entry.materialcost");
            BigDecimal fee = row.getBigDecimal("entry.fee");
            BigDecimal processCost = row.getBigDecimal("entry.processcost");
            this.getModel().setValue(this.MATERIALCOST, (Object)materialCost, rowIndex);
            this.getModel().setValue(this.FEE, (Object)fee, rowIndex);
            this.getModel().setValue(this.PROCESSCOST, (Object)processCost, rowIndex);
            BigDecimal manufactureCost = row.getBigDecimal("entry.manufacturecost");
            BigDecimal resource = row.getBigDecimal("entry.resource");
            BigDecimal actualCost = materialCost.add(fee).add(processCost).add(manufactureCost).add(resource);
            this.getModel().setValue(this.ACTUALCOST, (Object)actualCost, rowIndex);
            BigDecimal unitMaterialCost = BigDecimal.ZERO;
            BigDecimal unitFee = BigDecimal.ZERO;
            BigDecimal unitProcessCost = BigDecimal.ZERO;
            BigDecimal unitCost = BigDecimal.ZERO;
            if (baseQty.compareTo(BigDecimal.ZERO) != 0) {
                unitMaterialCost = materialCost.divide(baseQty, pricePrecision, RoundingMode.HALF_UP);
                unitFee = fee.divide(baseQty, pricePrecision, RoundingMode.HALF_UP);
                unitProcessCost = processCost.divide(baseQty, pricePrecision, RoundingMode.HALF_UP);
                unitCost = actualCost.divide(baseQty, pricePrecision, RoundingMode.HALF_UP);
            }
            this.getModel().setValue(this.UNITMATERIALCOST, (Object)unitMaterialCost, rowIndex);
            this.getModel().setValue(this.UNITFEE, (Object)unitFee, rowIndex);
            this.getModel().setValue(this.UNITPROCESSCOST, (Object)unitProcessCost, rowIndex);
            this.getModel().setValue(this.UNITACTUALCOST, (Object)unitCost, rowIndex);
        }
        this.getModel().setValue(this.GATHERKEY, row.get("gatherid"), rowIndex);
        return row.get("gatherid").toString();
    }

    private void setSubElementCost(Row row, int rowIndex, DynamicObjectCollection costSubElements, BigDecimal baseQty, int pricePrecision) {
        for (DynamicObject costSubElement : costSubElements) {
            DynamicObject info = costSubElement.getDynamicObject("fbasedataid");
            String subEleNum = info.getString("number");
            BigDecimal subEleCost = row.getBigDecimal(subEleNum);
            BigDecimal unitSubEleCost = BigDecimal.ZERO;
            if (baseQty.compareTo(BigDecimal.ZERO) != 0) {
                unitSubEleCost = subEleCost.divide(baseQty, pricePrecision, RoundingMode.HALF_UP);
            }
            this.getModel().setValue(subEleNum + "_cost", (Object)subEleCost, rowIndex);
            this.getModel().setValue(subEleNum + "_unitcost", (Object)unitSubEleCost, rowIndex);
        }
        BigDecimal actualCost = row.getBigDecimal("entry.actualcost");
        this.getModel().setValue(this.ACTUALCOST, (Object)actualCost, rowIndex);
        BigDecimal unitActualCost = BigDecimal.ZERO;
        if (baseQty.compareTo(BigDecimal.ZERO) != 0) {
            unitActualCost = actualCost.divide(baseQty, pricePrecision, RoundingMode.HALF_UP);
        }
        this.getModel().setValue(this.UNITACTUALCOST, (Object)unitActualCost, rowIndex);
    }

    private String getConcatStr() {
        StringBuilder retValue = new StringBuilder();
        List gatherFields = this.getGatherFieldsNew();
        for (int i = 0; i < gatherFields.size(); ++i) {
            if (i != 0) {
                retValue.append(",'#',");
            }
            retValue.append("Cast(").append((String)gatherFields.get(i)).append(" as String)");
        }
        return retValue.toString();
    }

    private List getGatherFieldsNew() {
        String groupCol = this.getPageCache().get(GROUP_COL);
        HashSet<String> gatherKeyList = new HashSet<String>();
        boolean isGroup = false;
        if (!StringUtils.isEmpty((CharSequence)groupCol)) {
            String[] split;
            for (String col : split = groupCol.split(",")) {
                if (StringUtils.isEmpty((CharSequence)col)) continue;
                if ("cal_group".equals(col)) {
                    String[] divAndDimensionCols = this.getDivAndDimensionCols(this.getCostAccountId());
                    gatherKeyList.addAll(new ArrayList<String>(Arrays.asList(divAndDimensionCols)));
                    isGroup = true;
                }
                if ("cal_material".equals(col)) {
                    gatherKeyList.addAll(new ArrayList<String>(Arrays.asList(this.FIX_COL)));
                }
                gatherKeyList.add(col);
            }
            if (!gatherKeyList.isEmpty()) {
                this.removeUnnecessary(gatherKeyList);
                if (isGroup) {
                    gatherKeyList.add(CALRANGE);
                }
                gatherKeyList.remove("cal_group");
                gatherKeyList.remove("cal_material");
                gatherKeyList.remove("ownertype");
            }
        }
        return new ArrayList(gatherKeyList);
    }

    private void setCloumnVisible(boolean isCostRecordDetail) {
        String[] split;
        boolean isGroup = false;
        MainEntityType metaInfo = EntityMetadataCache.getDataEntityType((String)"cal_in_calculate");
        EntityType entryInfo = (EntityType)metaInfo.getAllEntities().get("entryentity");
        ArrayList<String> visibleColList = new ArrayList<String>(16);
        Object groupCol = this.getModel().getValue(GROUP_COL);
        String chosenGroupCol = groupCol == null ? "" : String.valueOf(groupCol);
        for (String s : split = chosenGroupCol.split(",")) {
            if (StringUtils.isEmpty((CharSequence)s)) continue;
            if ("cal_group".equals(s)) {
                String[] divAndDimensionCols = this.getDivAndDimensionCols(this.getCostAccountId());
                visibleColList.addAll(new ArrayList<String>(Arrays.asList(divAndDimensionCols)));
                isGroup = true;
            }
            if ("cal_material".equals(s)) {
                visibleColList.addAll(new ArrayList<String>(Arrays.asList(this.FIX_COL)));
            }
            visibleColList.add(s);
        }
        if (isGroup) {
            visibleColList.clear();
            visibleColList.addAll(new ArrayList<String>(Arrays.asList(this.FIX_COL)));
            String realKeyCols = this.getPageCache().get(REAL_COLS);
            List realKeyColsList = SerializationUtils.fromJsonStringToList((String)realKeyCols, String.class);
            visibleColList.addAll(realKeyColsList);
        }
        ArrayList<String> curVisibleColList = new ArrayList<String>(visibleColList);
        for (String s : visibleColList) {
            if (entryInfo.findProperty(s) instanceof BasedataProp) {
                curVisibleColList.add(s.concat("name"));
                curVisibleColList.add(s.concat("number"));
            }
            if (!(entryInfo.findProperty(s) instanceof ItemClassProp)) continue;
            curVisibleColList.add(s.concat("type"));
        }
        curVisibleColList.add("unitactualcost");
        curVisibleColList.add(this.UNITMATERIALCOST);
        curVisibleColList.add(this.MATERIALCOST);
        curVisibleColList.add(this.UNITFEE);
        curVisibleColList.add(this.FEE);
        curVisibleColList.add(this.UNITPROCESSCOST);
        curVisibleColList.add(this.PROCESSCOST);
        String[] visibleCols = curVisibleColList.toArray(new String[0]);
        this.getView().setVisible(Boolean.TRUE, visibleCols);
        String extendField = this.getPageCache().get("setVisibleFields");
        List extendFields = new ArrayList(16);
        if (extendField != null) {
            extendFields = (List)SerializationUtils.fromJsonString((String)extendField, ArrayList.class);
        }
        if (!extendFields.isEmpty()) {
            String[] extendCloumn = new String[extendFields.size()];
            for (int i = 0; i < extendFields.size(); ++i) {
                extendCloumn[i] = (String)extendFields.get(i);
            }
            this.getView().setVisible(Boolean.TRUE, extendCloumn);
        }
        List<String> fields = this.getUnEnableColumnBySumTypeNew(visibleColList, isCostRecordDetail);
        String[] f = new String[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            f[i] = fields.get(i).toString();
        }
        this.getView().setVisible(Boolean.FALSE, f);
    }

    private List<String> getUnEnableColumnBySumTypeNew(List<String> chosenGroups, boolean isCostRecordDetail) {
        ArrayList<String> chosenGroupColList = new ArrayList<String>(chosenGroups);
        ArrayList<String> unMatchList = new ArrayList<String>();
        ArrayList<String> matchReferenceList = new ArrayList<String>();
        chosenGroupColList.add("baseqty");
        chosenGroupColList.add("unitactualcost");
        chosenGroupColList.add("actualcost");
        MainEntityType metaInfo = EntityMetadataCache.getDataEntityType((String)"cal_in_calculate");
        EntityType entryInfo = (EntityType)metaInfo.getAllEntities().get("entryentity");
        for (IDataEntityProperty property : entryInfo.getProperties()) {
            if (!chosenGroupColList.contains(property.getName()) && (entryInfo.findProperty(property.getName()) instanceof BasedataProp || entryInfo.findProperty(property.getName()) instanceof FlexProp || entryInfo.findProperty(property.getName()) instanceof TextProp || entryInfo.findProperty(property.getName()) instanceof ItemClassProp)) {
                unMatchList.add(property.getName());
                if (entryInfo.findProperty(property.getName()) instanceof BasedataProp) {
                    unMatchList.add(property.getName().concat("name"));
                    unMatchList.add(property.getName().concat("number"));
                }
                if (entryInfo.findProperty(property.getName()) instanceof ItemClassProp) {
                    unMatchList.add(property.getName().concat("type"));
                }
            }
            if (!chosenGroupColList.contains(property.getName()) || !(entryInfo.findProperty(property.getName()) instanceof BasedataProp)) continue;
            matchReferenceList.add(property.getName().concat("name"));
            matchReferenceList.add(property.getName().concat("number"));
        }
        if (!unMatchList.isEmpty() && !matchReferenceList.isEmpty()) {
            unMatchList.removeAll(matchReferenceList);
        }
        if (isCostRecordDetail) {
            unMatchList.add(this.UNITMATERIALCOST);
            unMatchList.add(this.MATERIALCOST);
            unMatchList.add(this.UNITFEE);
            unMatchList.add(this.FEE);
            unMatchList.add(this.UNITPROCESSCOST);
            unMatchList.add(this.PROCESSCOST);
            int entryRowCount = this.getModel().getEntryRowCount("entryentity");
            for (int i = 0; i < entryRowCount; ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{this.UNITACTUALCOST, this.ACTUALCOST});
            }
        } else {
            String ominTypeStr = this.getPageCache().get(this.ISOMINBILLTYPE);
            boolean isOminBillType = Boolean.parseBoolean(ominTypeStr);
            int entryRowCount = this.getModel().getEntryRowCount("entryentity");
            for (int i = 0; i < entryRowCount; ++i) {
                this.getView().setEnable(Boolean.valueOf(isOminBillType), i, new String[]{this.UNITPROCESSCOST, this.PROCESSCOST});
            }
        }
        return unMatchList;
    }

    private boolean checkOminBillType() {
        boolean isOminBillType = Boolean.TRUE;
        DynamicObject setting = CommonSettingHelper.getSettingObj();
        DynamicObjectCollection ominBizObjects = setting.getDynamicObjectCollection("ominbiztype");
        if (ominBizObjects == null || ominBizObjects.isEmpty()) {
            return Boolean.FALSE;
        }
        HashSet<String> ominBizObjectSet = new HashSet<String>(ominBizObjects.size());
        for (DynamicObject ominBizObject : ominBizObjects) {
            ominBizObjectSet.add((String)ominBizObject.getDynamicObject("fbasedataid").getPkValue());
        }
        DynamicObjectCollection billTypeDyo = this.getModel().getDataEntity().getDynamicObjectCollection(this.BILLTYPE);
        for (DynamicObject billType : billTypeDyo) {
            if (ominBizObjectSet.contains(billType.getDynamicObject("fbasedataid").getString("billformid.number"))) continue;
            isOminBillType = Boolean.FALSE;
        }
        return isOminBillType;
    }

    private DataSet buildGatherDataNew(DataSet detailDataSet, boolean isCostRecordDetail) {
        String groupKeyAll;
        GroupbyDataSet groupbyDataSet;
        String[] groupKey;
        Object groupColValue = this.getModel().getValue(GROUP_COL);
        String groupCol = groupColValue == null ? "" : (String)groupColValue;
        String[] split = groupCol.split(",");
        HashSet<String> groupKeyList = new HashSet<String>();
        boolean isGroup = false;
        for (String s : split) {
            if (StringUtils.isEmpty((CharSequence)s)) continue;
            groupKeyList.add(s);
            if (groupKeyList.contains("cal_group")) {
                String[] divAndDimensionCols = this.getDivAndDimensionCols(this.getCostAccountId());
                groupKeyList.addAll(new ArrayList<String>(Arrays.asList(divAndDimensionCols)));
                isGroup = true;
            }
            if (!groupKeyList.contains("cal_material")) continue;
            groupKeyList.addAll(new ArrayList<String>(Arrays.asList(this.FIX_COL)));
        }
        if (!groupKeyList.isEmpty()) {
            this.removeUnnecessary(groupKeyList);
            if (isGroup) {
                groupKeyList.add(CALRANGE);
            }
            groupKeyList.remove("cal_material");
            groupKeyList.remove("cal_group");
            groupKeyList.add(this.GATHERKEY);
        }
        HashSet<String> groupKeysForCostPrice = new HashSet<String>(groupKeyList);
        groupKeysForCostPrice.remove(this.GATHERKEY);
        if (isCostRecordDetail) {
            groupKeyList.add("costsubelement");
        }
        if ((groupKey = groupKeyList.toArray(new String[0])).length == 0) {
            String[] specialKey = (String[])ArrayUtils.concatAll((Object[])this.FIX_COL, (Object[][])new String[][]{{this.GATHERKEY}});
            logger.info("calculateInCostPlugin gather key field : {}", (Object)specialKey);
            groupbyDataSet = detailDataSet.groupBy(specialKey);
            groupKeyAll = SerializationUtils.toJsonString((Object)this.FIX_COL);
        } else {
            logger.info("calculateInCostPlugin gather key field : {}", (Object)groupKey);
            groupbyDataSet = detailDataSet.groupBy(groupKey);
            groupKeyAll = SerializationUtils.toJsonString(groupKeysForCostPrice);
        }
        GroupbyDataSet entrySum = groupbyDataSet.sum("entry.baseqty").sum("entry.actualcost").sum("entry.materialcost").sum("entry.fee").sum("entry.processcost").sum("entry.manufacturecost").sum("entry.resource");
        if (isCostRecordDetail) {
            DynamicObjectCollection costSubElement = this.getModel().getDataEntity().getDynamicObjectCollection(this.COSTSUBELEMENT);
            Set<String> elementNumSet = this.getElementNumSet(costSubElement);
            detailDataSet = entrySum.sum("sub_actualcost").finish();
            detailDataSet = detailDataSet.groupBy(new String[]{"gatherid"}).reduceGroup((ReduceGroupFunction)new SubElementRowToColFunction(detailDataSet.getRowMeta(), elementNumSet));
        } else {
            detailDataSet = entrySum.finish();
        }
        this.getPageCache().put(GROUP_COL_ALL, groupKeyAll);
        return detailDataSet;
    }

    private void getNoneEmpty(Set<String> keyCols, String dividebasis) {
        if (!StringUtils.isEmpty((CharSequence)dividebasis)) {
            String[] split;
            for (String s : split = dividebasis.split(",")) {
                if (StringUtils.isEmpty((CharSequence)s)) continue;
                keyCols.add(s);
            }
        }
    }

    private Long getCostAccountId() {
        Object costAccountValue = this.getModel().getValue(this.COSTACCOUNT);
        return costAccountValue == null ? 0L : ((DynamicObject)costAccountValue).getLong("id");
    }

    private String[] getDivRangeDims(String divStr, String calDimensionStr) {
        String[] divFields = divStr.split(",");
        Object[] bakDivFields = divStr.split(",");
        String[] calDims = calDimensionStr.split(",");
        String[] bakCalDims = calDimensionStr.split(",");
        System.arraycopy(divFields, 0, bakDivFields, 0, divFields.length);
        System.arraycopy(calDims, 0, bakCalDims, 0, calDims.length);
        String[] divRangeDims = (String[])ArrayUtils.concatAll((Object[])bakDivFields, (Object[][])new String[][]{{"calrange"}, bakCalDims});
        return divRangeDims;
    }

    private Set<Long> getEmptyEntryRangeIds(Long costAccount) {
        QFilter filter = new QFilter("costaccount", "=", (Object)costAccount);
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        HashSet<Long> emptyEntryRangeIds = new HashSet<Long>(16);
        Map calRangeMap = BusinessDataServiceHelper.loadFromCache((String)"cal_bd_calrange", (QFilter[])filter.toArray());
        for (DynamicObject rangDyc : calRangeMap.values()) {
            DynamicObjectCollection entryDycs = rangDyc.getDynamicObjectCollection("entry");
            if (!entryDycs.isEmpty()) continue;
            emptyEntryRangeIds.add(rangDyc.getLong("id"));
        }
        return emptyEntryRangeIds;
    }

    private void loadRowData(DataSet gatherDataset, boolean isCostRecordDetail) {
        this.getModel().deleteEntryData("entryentity");
        HashMap<String, Integer> gaterhMap = new HashMap<String, Integer>();
        int pricePrecision = 10;
        DynamicObjectCollection costSubElements = this.getModel().getDataEntity().getDynamicObjectCollection(this.COSTSUBELEMENT);
        for (Row row : gatherDataset) {
            int rowIndex = this.getModel().createNewEntryRow("entryentity");
            String gatherKey = this.loadRowData(row, rowIndex, pricePrecision, isCostRecordDetail, costSubElements);
            gaterhMap.put(gatherKey, rowIndex);
        }
        this.getPageCache().put(this.GATHERDATAMAP, SerializationUtils.toJsonString(gaterhMap));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new KDBizException(cloneNotSupportedException.getMessage());
        }
        EntryType entryType = (EntryType)newMainType.getAllEntities().get("entryentity");
        DynamicFieldCreateHelper.getEntryElement((IPageCache)this.getPageCache(), (String)"cal_in_calculate").registerEntryProp(entryType);
        e.setNewEntityType(newMainType);
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
    }

    public void afterUpload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls != null && urls.length > 0) {
            String fileUrl = urls[0].toString();
            try {
                Date curDate = new Date();
                logger.info("\u5165\u5e93\u6c47\u603b\u6838\u7b97\u5f15\u5165\u5916\u90e8\u6570\u636e-\u5f00\u59cb\uff1a" + curDate);
                this.loadXLSXFile(fileUrl);
                long time = System.currentTimeMillis() - curDate.getTime();
                logger.info("\u5165\u5e93\u6c47\u603b\u6838\u7b97\u5f15\u5165\u5916\u90e8\u6570\u636e-\u7ed3\u675f\u8017\u65f6\uff1a" + time);
            }
            catch (IOException e) {
                logger.error("\u4e0a\u4f20\u5916\u90e8\u6587\u4ef6\u66f4\u65b0\u5931\u8d25", (Throwable)e);
                throw new KDException("book close Error");
            }
        }
    }

    private BigDecimal getRowCostAmt(String field, Map cellIndex, List xssfRowValue, int rowIndex) {
        int index = (Integer)cellIndex.get(field);
        BigDecimal value = BigDecimal.ZERO;
        try {
            if (this.BASEQTY.equals(field)) {
                value = new BigDecimal(xssfRowValue.get(index).toString());
            } else {
                String cost = xssfRowValue.get(index).toString();
                if (!"".equals(cost)) {
                    value = new BigDecimal(xssfRowValue.get(index).toString());
                }
            }
        }
        catch (Exception e) {
            String content = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5b57\u6bb5\u6570\u636e\u503c\u683c\u5f0f\u9519\u8bef\uff0c\u5fc5\u987b\u662f\u6570\u5b57\u578b\u5185\u5bb9\u3002", (String)"CalculateInCostPlugin_33", (String)"fi-cal-formplugin", (Object[])new Object[0]), rowIndex);
            throw new KDBizException(content);
        }
        return value;
    }

    private String buildExcelFiledKey(Map cellIndex, List xssfRowValue, String[] traceFieldNameContainer) {
        int i;
        StringBuilder traceFieldBuilder = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        Set exFieldSet = CommonSettingHelper.getExFieldSet();
        List gatherFieldsNew = this.getGatherFieldsNew();
        gatherFieldsNew.addAll(exFieldSet);
        TreeSet orderExt = new TreeSet(gatherFieldsNew);
        this.extendFields = new ArrayList<String>(orderExt);
        List groupField = this.getGatherFieldsNew();
        MainEntityType calCulateEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_in_calculate");
        HashMap<String, List<String>> tableAndNameNumber = new HashMap<String, List<String>>(16);
        HashMap<String, Long> tableNameAndPk = new HashMap<String, Long>(16);
        for (i = 0; i < groupField.size(); ++i) {
            IDataEntityProperty property;
            if (!this.extendFields.contains(groupField.get(i)) || calCulateEntityType.findProperty((String)groupField.get(i)) == null || !((property = calCulateEntityType.findProperty((String)groupField.get(i))) instanceof BasedataProp)) continue;
            String baseEntityId = ((BasedataProp)property).getBaseEntityId();
            String name = ((BasedataProp)property).getName();
            this.getInfo(groupField, tableAndNameNumber, i, baseEntityId, name);
        }
        this.getExtPk(cellIndex, xssfRowValue, tableAndNameNumber, tableNameAndPk);
        for (i = 0; i < groupField.size(); ++i) {
            IDataEntityProperty property;
            String[] split;
            String commentValue;
            Integer commentIndex;
            Object comment;
            String field = (String)groupField.get(i);
            if (field.equals("ownerid")) {
                field = "ownernumber";
            }
            String traceFieldName = field;
            Object value = null;
            Object cellValue = cellIndex.get(field);
            Long assistId = 0L;
            Long calRangeId = 0L;
            if ("assist".equals(field) && (cellValue = cellIndex.get("commentzh_CN")) != null && (comment = xssfRowValue.get(commentIndex = Integer.valueOf(cellValue.toString()))) != null && !StringUtils.isEmpty((CharSequence)(commentValue = (String)comment)) && (split = commentValue.split("_")) != null && split.length != 0) {
                assistId = Long.parseLong(split[0]);
            }
            if (CALRANGE.equals(field) && (cellValue = cellIndex.get("commentzh_CN")) != null && (comment = xssfRowValue.get(commentIndex = Integer.valueOf(cellValue.toString()))) != null && !StringUtils.isEmpty((CharSequence)(commentValue = (String)comment)) && (split = commentValue.split("_")) != null && split.length != 0) {
                calRangeId = Long.parseLong(split[1]);
            }
            if (cellValue != null) {
                int index = Integer.parseInt(cellValue.toString());
                value = xssfRowValue.get(index);
                if ("projectnumber".equals(field) && " ".equals(value)) {
                    value = "";
                }
                if ("ownernumber".equals(field)) {
                    String key = value.toString();
                    String mapValue = this.ownerIdMap.get(key);
                    if (StringUtils.isNotBlank((CharSequence)mapValue)) {
                        value = mapValue;
                    } else if (kd.bos.util.StringUtils.isEmpty((String)key)) {
                        this.ownerIdMap.put(key, "0");
                        value = "0";
                    } else {
                        Object id = QueryServiceHelper.queryOne((String)"bos_org", (String)"id,number", (QFilter[])new QFilter("number", "=", value).toArray()).get("id");
                        this.ownerIdMap.put(key, id.toString());
                        value = id;
                    }
                }
            }
            if (this.extendFields.contains(groupField.get(i)) && calCulateEntityType.findProperty((String)groupField.get(i)) != null && (property = calCulateEntityType.findProperty((String)groupField.get(i))) instanceof BasedataProp) {
                String fieldName;
                String baseEntityId = ((BasedataProp)property).getBaseEntityId();
                traceFieldName = fieldName = ((BasedataProp)property).getName();
                value = "assist".equals(fieldName) ? (Number)assistId : (Number)(CALRANGE.equals(field) ? (Number)calRangeId : (Number)(tableNameAndPk.get(baseEntityId + "#" + fieldName) == null ? Integer.valueOf(0) : tableNameAndPk.get(baseEntityId + "#" + fieldName)));
            }
            sb.append(value).append('#');
            traceFieldBuilder.append(traceFieldName).append("#");
        }
        traceFieldNameContainer[0] = traceFieldBuilder.toString().substring(0, traceFieldBuilder.length() - 1);
        return sb.toString().substring(0, sb.length() - 1);
    }

    private void getInfo(List<String> groupField, Map<String, List<String>> tableAndNameNumber, int i, String baseEntityId, String name) {
        String markKey = baseEntityId + "#" + name;
        String nameField = groupField.get(i).concat("name");
        String numberField = groupField.get(i).concat("number");
        List<String> fields = tableAndNameNumber.get(markKey);
        if (fields == null) {
            fields = new ArrayList<String>();
            fields.add(nameField);
            fields.add(numberField);
            tableAndNameNumber.put(markKey, fields);
        } else {
            fields.add(nameField);
            fields.add(numberField);
        }
    }

    private void getExtPk(Map cellIndex, List xssfRowValue, Map<String, List<String>> tableNameAndCondition, Map<String, Long> tableNameAndPk) {
        ArrayList<OrmInput> orm = new ArrayList<OrmInput>(16);
        for (Map.Entry<String, List<String>> entry : tableNameAndCondition.entrySet()) {
            String markKey = entry.getKey();
            String tableName = null;
            String field = null;
            if (!StringUtils.isEmpty((CharSequence)markKey)) {
                String[] split = markKey.split("#");
                tableName = split[0];
                field = split[1];
            }
            List<String> values = entry.getValue();
            String nameField = values.get(0);
            String numberField = values.get(1);
            if ("assist".equals(field) || CALRANGE.equals(field)) continue;
            QFilter nameFilter = null;
            QFilter numberFilter = null;
            if (cellIndex.get(nameField) != null) {
                Object nameValue = xssfRowValue.get(Integer.parseInt(cellIndex.get(nameField).toString()));
                nameFilter = new QFilter("name", "=", nameValue);
            }
            if (cellIndex.get(numberField) != null) {
                Object numberValue = xssfRowValue.get(Integer.parseInt(cellIndex.get(numberField).toString()));
                numberFilter = new QFilter("number", "=", numberValue);
            }
            if (nameFilter == null && numberFilter == null || StringUtils.isEmpty((CharSequence)tableName) || StringUtils.isEmpty((CharSequence)field)) continue;
            orm.add(new OrmInput(((Object)((Object)this)).getClass().getName(), tableName, "id,".concat("'").concat(tableName).concat("'").concat(" as tableName ").concat(",").concat("'").concat(field).concat("'").concat(" as markField"), new QFilter[]{nameFilter, numberFilter}));
        }
        if (orm.size() != 0) {
            DataSet dataSet = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet((Input[])orm.toArray(new OrmInput[orm.size()]));
            DataSet tableAndIds = dataSet.groupBy(new String[]{"tableName", "markField"}).max("id").finish();
            for (Row tableAndId : tableAndIds) {
                String tableName = tableAndId.getString("tableName");
                String field = tableAndId.getString("markField");
                String markKey = tableName + "#" + field;
                Long id = tableAndId.getLong("id");
                tableNameAndPk.put(markKey, id);
            }
        }
        WriteLogHelper.writeInfoLog((Log)logger, (String)"calculateInCostPlugin-outPutExcel-TableNameAndPk: ", (Object[])new Object[]{tableNameAndPk});
    }

    private void loadXLSXFile(String fileUrl) throws IOException {
        HashMap<String, Integer> cellIndex = new HashMap<String, Integer>(16);
        try (InputStream inStream = null;){
            Date curDate = TimeServiceHelper.now();
            FileService service = FileServiceFactory.getAttachmentFileService();
            inStream = service.getInputStream(fileUrl);
            long time = System.currentTimeMillis() - curDate.getTime();
            logger.info("loadXLSXFile\u8bfb\u53d6\u6587\u4ef6-\u8017\u65f6\uff1a" + time);
            CalImportSheetHandler sheetHandler = new CalImportSheetHandler();
            try (TraceSpan span = Tracer.create((String)((Object)((Object)this)).getClass().getName(), (String)"loadXLSXFile");){
                ExcelReader reader = new ExcelReader();
                reader.read(inStream, (SheetHandler)sheetHandler);
            }
            curDate = new Date();
            time = System.currentTimeMillis() - curDate.getTime();
            logger.info("loadXLSXFile\u89e3\u6790-\u8017\u65f6\uff1a" + time);
            Map<Integer, Map<Integer, String>> rowsMap = sheetHandler.getRows();
            Map<Integer, String> colIndexFieldNameMap = rowsMap.get(2);
            if (colIndexFieldNameMap == null) {
                return;
            }
            for (Map.Entry entry : colIndexFieldNameMap.entrySet()) {
                cellIndex.put(((String)entry.getValue()).replace(".", ""), (Integer)entry.getKey());
            }
            int lastRowIndex = rowsMap.size() - 1;
            StringBuilder stringBuilder = new StringBuilder();
            int lastColIndex = colIndexFieldNameMap.size();
            HashMap gatherMap = (HashMap)SerializationUtils.fromJsonString((String)this.getPageCache().get(this.GATHERDATAMAP), HashMap.class);
            if (gatherMap == null) {
                return;
            }
            try (TraceSpan span = Tracer.create((String)((Object)((Object)this)).getClass().getName(), (String)"updateViewValue");){
                this.getModel().beginInit();
                String ominTypeStr = this.getPageCache().get(this.ISOMINBILLTYPE);
                boolean isOminBillType = Boolean.parseBoolean(ominTypeStr);
                int precision = Integer.parseInt(this.getPageCache().get(this.AMT_PRECISION));
                for (int k = 4; k <= lastRowIndex; ++k) {
                    ArrayList<String> valueList = new ArrayList<String>(16);
                    if (lastRowIndex <= 0) continue;
                    Map<Integer, String> curRow = rowsMap.get(k);
                    for (int i = 0; i < lastColIndex; ++i) {
                        String curRowColValue = curRow.get(i);
                        if (curRowColValue == null || curRowColValue.equals("")) {
                            valueList.add("");
                            continue;
                        }
                        valueList.add(curRowColValue);
                    }
                    String[] traceContainer = new String[1];
                    String gatherKey = this.buildExcelFiledKey(cellIndex, valueList, traceContainer);
                    if (gatherMap.get(gatherKey) != null) {
                        this.verificateAssign(gatherMap, gatherKey, k, cellIndex, valueList, isOminBillType, precision);
                        continue;
                    }
                    String content = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5bfc\u5165\u6570\u636e\u4e0d\u5339\u914d\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"CalculateInCostPlugin_34", (String)"fi-cal-formplugin", (Object[])new Object[0]), k + 1);
                    stringBuilder.append(content);
                    WriteLogHelper.writeInfoLog((Log)logger, (String)"CalculateInCostPlugin import match map : {}", (Object[])new Object[]{gatherMap.keySet()});
                    WriteLogHelper.writeInfoLog((Log)logger, (String)("CalculateInCostPlugin import match error : key : " + traceContainer[0] + " value : " + gatherKey), (Object[])new Object[0]);
                }
                this.getModel().endInit();
                if (stringBuilder.length() > 0) {
                    this.getView().showMessage(stringBuilder.toString());
                }
            }
        }
    }

    private void verificateAssign(HashMap gatherMap, String gatherKey, int k, Map<String, Integer> cellIndex, List valueList, boolean isOminBillType, int precision) {
        int rowIndex = (Integer)gatherMap.get(gatherKey);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        DynamicObject row = (DynamicObject)entryEntity.get(rowIndex);
        BigDecimal qty = row.getBigDecimal(this.BASEQTY);
        if (qty.compareTo(this.getRowCostAmt(this.BASEQTY, cellIndex, valueList, k)) != 0) {
            String content = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5bfc\u5165\u6570\u636e\u57fa\u672c\u6570\u91cf\u4e0d\u5339\u914d\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"CalculateInCostPlugin_35", (String)"fi-cal-formplugin", (Object[])new Object[0]), k + 1);
            throw new KDBizException(content);
        }
        DynamicObject info = this.getModel().getDataEntity().getDynamicObject(this.COSTACCOUNT);
        boolean isCostRecordDetail = ParamsHelper.getCostElementByCostAccount((long)info.getLong("id"));
        BigDecimal actualCost = (BigDecimal)this.getModel().getValue(this.ACTUALCOST, rowIndex);
        if (!isCostRecordDetail) {
            BigDecimal newActCost = this.importEntryCost(this.ACTUALCOST, cellIndex, valueList, k, qty, rowIndex, Boolean.FALSE, precision);
            BigDecimal fee = (BigDecimal)this.getModel().getValue(this.FEE, rowIndex);
            BigDecimal processCost = (BigDecimal)this.getModel().getValue(this.PROCESSCOST, rowIndex);
            BigDecimal newMatCost = newActCost.subtract(fee).subtract(processCost);
            this.getModel().setValue(this.UNITMATERIALCOST, (Object)this.calUnitCostByAct(qty, newMatCost), rowIndex);
            this.getModel().setValue(this.MATERIALCOST, (Object)newMatCost, rowIndex);
            this.getView().updateView(this.UNITMATERIALCOST, rowIndex);
            this.getView().updateView(this.MATERIALCOST, rowIndex);
        } else {
            DynamicObjectCollection costSubElements = this.getModel().getDataEntity().getDynamicObjectCollection(this.COSTSUBELEMENT);
            for (DynamicObject costSubElement : costSubElements) {
                DynamicObject costSubElementInfo = costSubElement.getDynamicObject("fbasedataid");
                String subEleNum = costSubElementInfo.getString("number").toLowerCase();
                if (!cellIndex.containsKey(subEleNum + "_cost") || !cellIndex.containsKey(subEleNum + "_unitcost")) continue;
                BigDecimal subEleCost = (BigDecimal)this.getModel().getValue(subEleNum + "_cost", rowIndex);
                actualCost = actualCost.subtract(subEleCost);
                BigDecimal newSubEleCost = this.importEntryCost(subEleNum, cellIndex, valueList, k, qty, rowIndex, Boolean.TRUE, precision);
                actualCost = actualCost.add(newSubEleCost);
            }
            this.getModel().setValue(this.UNITACTUALCOST, (Object)this.calUnitCostByAct(qty, actualCost), rowIndex);
            this.getModel().setValue(this.ACTUALCOST, (Object)actualCost, rowIndex);
            this.getView().updateView(this.UNITACTUALCOST, rowIndex);
            this.getView().updateView(this.ACTUALCOST, rowIndex);
        }
    }

    private BigDecimal importEntryCost(String fieldName, Map cellIndex, List xssfRowValue, int k, BigDecimal qty, int index, boolean isCostRecordDetail, int precision) {
        BigDecimal unitCost;
        String unitCostFieldName;
        String costFieldName = isCostRecordDetail ? fieldName + "_cost" : fieldName;
        BigDecimal cost = this.getRowCostAmt(costFieldName, cellIndex, xssfRowValue, k);
        if (cost.multiply(qty).compareTo(BigDecimal.ZERO) < 0) {
            String content = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u6570\u636e\u4e0d\u80fd\u5bfc\u5165\uff0c\u8bf7\u4fdd\u8bc1\u6570\u91cf\u4e0e\u5b9e\u9645\u6210\u672c\u6b63\u8d1f\u65b9\u5411\u4e00\u81f4\u3002", (String)"CalculateInCostPlugin_36", (String)"fi-cal-formplugin", (Object[])new Object[0]), k + 1);
            throw new KDBizException(content);
        }
        String string = unitCostFieldName = isCostRecordDetail ? fieldName + "_unitcost" : "unit" + fieldName;
        if (cost.compareTo(BigDecimal.ZERO) == 0) {
            unitCost = this.getRowCostAmt(unitCostFieldName, cellIndex, xssfRowValue, k);
            if (unitCost.compareTo(BigDecimal.ZERO) < 0) {
                String content = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u6570\u636e\u4e0d\u80fd\u5bfc\u5165\uff0c\u5355\u4f4d\u5b9e\u9645\u6210\u672c\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0\u3002", (String)"CalculateInCostPlugin_37", (String)"fi-cal-formplugin", (Object[])new Object[0]), k + 1);
                throw new KDBizException(content);
            }
            cost = unitCost.multiply(qty).setScale(precision, RoundingMode.HALF_UP);
        } else {
            unitCost = SubEntityUtil.calUnitCostByAct(qty, cost);
        }
        this.getModel().setValue(unitCostFieldName, (Object)unitCost, index);
        this.getModel().setValue(costFieldName, (Object)cost, index);
        this.getView().updateView(unitCostFieldName, index);
        this.getView().updateView(costFieldName, index);
        return cost;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initUIData();
        this.initCalorgAndCostAccount();
        this.initGroupCol();
        ((Container)this.getControl("filterpanel")).setCollapse(Boolean.FALSE.booleanValue());
    }

    private void materialFromChange() {
        DynamicObjectCollection materialFrom = this.getModel().getDataEntity().getDynamicObjectCollection("materialfrom");
        int size = materialFrom.size();
        this.getModel().beginInit();
        if (size > 1) {
            this.getModel().setValue("materialto", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"materialto"});
        } else {
            if (materialFrom.size() == 1) {
                this.getModel().setValue("materialto", ((DynamicObject)materialFrom.get(0)).getDynamicObject("fbasedataid").getPkValue());
            } else {
                this.getModel().setValue("materialto", null);
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{"materialto"});
        }
        this.getModel().endInit();
        this.getView().updateView("materialto");
    }

    private void periodChange() {
        DynamicObject entity = this.getModel().getDataEntity();
        DynamicObject info = entity.getDynamicObject(this.COSTACCOUNT);
        if (info == null) {
            return;
        }
        DynamicObject period = PeriodHelper.getCurrentPeriod((Long)info.getLong("id"));
        if (period != null) {
            int number;
            int year = period.getInt("periodyear");
            int periodNumBefore = year * 100 + (number = period.getInt("periodnumber"));
            int periodNumAfter = this.getAfterPeriod(periodNumBefore);
            if (periodNumAfter < periodNumBefore) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"btncal"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"btncalall"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"btncal"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"btncalall"});
            }
        }
        int yearNum = entity.getInt("year");
        int periodNum = entity.getInt("periodnum");
        String policyID = info.getString("calpolicy.id");
        DynamicObject policyInfo = BusinessDataServiceHelper.loadSingle((Object)policyID, (String)"cal_bd_calpolicy");
        DynamicObject value = PeriodHelper.getPeriodByNumber((int)yearNum, (int)periodNum, null, (long)policyInfo.getDynamicObject("periodtype").getLong("id"));
        this.getModel().beginInit();
        this.getModel().setValue("starttime", null);
        this.getModel().setValue("endtime", null);
        if (value != null) {
            this.getModel().setValue("starttime", (Object)value.getDate("beginDate"));
            this.getModel().setValue("endtime", (Object)value.getDate("enddate"));
        }
        this.getModel().endInit();
        this.getView().updateView("starttime");
        this.getView().updateView("endtime");
    }

    private void costAccountChange() {
        DynamicObject info = this.getModel().getDataEntity().getDynamicObject(this.COSTACCOUNT);
        this.getModel().setValue("currency", null);
        if (info == null) {
            this.costAcountChangePeroid();
            return;
        }
        boolean isCostRecordDetail = ParamsHelper.getCostElementByCostAccount((long)info.getLong("id"));
        if (!isCostRecordDetail) {
            this.getModel().setValue(this.COSTSUBELEMENT, null);
            this.getView().setVisible(Boolean.FALSE, new String[]{this.COSTSUBELEMENT});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{this.COSTSUBELEMENT});
            Set enableSubElement = CostElementHelper.getEnableSubElement();
            int costSubElementMaxSize = CalDbParamServiceHelper.getInteger((String)"costsubelement_filter_max_size");
            if (enableSubElement.size() <= costSubElementMaxSize) {
                this.getModel().setValue(this.COSTSUBELEMENT, (Object)enableSubElement.toArray());
            } else {
                this.getModel().setValue(this.COSTSUBELEMENT, null);
            }
            this.getView().updateView(this.COSTSUBELEMENT);
        }
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"id,currency", (QFilter[])new QFilter[]{new QFilter("id", "=", info.getDynamicObject("calpolicy").getPkValue())});
        this.getModel().setValue("currency", ((DynamicObject)coll.get(0)).get("currency"));
        DynamicObject period = PeriodHelper.getCurrentPeriod((Long)info.getLong("id"));
        if (period == null) {
            this.costAcountChangePeroid();
            return;
        }
        int year = period.getInt("periodyear");
        int number = period.getInt("periodnumber");
        Date startTime = period.getDate("begindate");
        Date endTime = period.getDate("enddate");
        this.getModel().beginInit();
        this.getModel().setValue("year", (Object)year);
        this.getModel().setValue("periodnum", (Object)number);
        this.getModel().setValue("starttime", (Object)startTime);
        this.getModel().setValue("endtime", (Object)endTime);
        this.getView().updateView("year");
        this.getView().updateView("periodnum");
        this.getView().updateView("starttime");
        this.getView().updateView("endtime");
        int periodNumBefore = year * 100 + number;
        int periodNumAfter = this.getAfterPeriod(periodNumBefore);
        if (periodNumAfter < periodNumBefore) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"btncal"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"btncalall"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"btncal"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"btncalall"});
        }
        this.getModel().endInit();
    }

    private void costAcountChangePeroid() {
        this.getModel().beginInit();
        this.getModel().setValue("year", null);
        this.getModel().setValue("periodnum", null);
        this.getModel().setValue("starttime", null);
        this.getModel().setValue("endtime", null);
        this.getView().updateView("year");
        this.getView().updateView("periodnum");
        this.getView().updateView("starttime");
        this.getView().updateView("endtime");
        this.getModel().endInit();
    }

    private void bizTypeChange() {
        Object value = this.getModel().getValue(this.BIZTYPE);
        if (value == null) {
            return;
        }
        String biztypeStr = value.toString();
        this.getModel().beginInit();
        if (biztypeStr.equals("OUT")) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"ispresent"});
            this.getModel().setValue("ispresent", (Object)Boolean.TRUE);
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"ispresent"});
            this.getModel().setValue("ispresent", (Object)Boolean.FALSE);
        }
        this.getView().updateView("ispresent");
        this.getModel().endInit();
    }

    private void initUIData() {
        this.getModel().setValue("ispresent", (Object)Boolean.FALSE);
        this.getView().setEnable(Boolean.FALSE, new String[]{"ispresent"});
    }

    private void initCalorgAndCostAccount() {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        long userOrgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_in_calculate");
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (params.get("cus_costaccount") != null && params.get("cus_orgid") != null) {
            this.getModel().setValue(this.CALORG, (Object)Long.valueOf(params.get("cus_orgid").toString()));
            this.getModel().setValue(this.COSTACCOUNT, (Object)Long.valueOf(params.get("cus_costaccount").toString()));
            this.costAccountChange();
            Object costAccountVal = this.getModel().getValue(this.COSTACCOUNT);
            if (costAccountVal != null) {
                DynamicObject costAccount = (DynamicObject)costAccountVal;
                String policyID = costAccount.getString("calpolicy.id");
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)policyID, (String)"cal_bd_calpolicy");
                DynamicObject currency = obj.getDynamicObject("currency");
                this.loadHeadData(currency);
                this.getPageCache().put(this.AMT_PRECISION, String.valueOf(currency.getInt("amtprecision")));
            }
        } else if (calOrgId != null && calOrgId != 0L) {
            Object costAccountVal;
            this.getModel().setValue(this.CALORG, (Object)calOrgId);
            this.getModel().setValue("mainorgfilter", (Object)calOrgId);
            Long costAccountid = PeriodHelper.getCostAccountByCalOrgAndSysctrlentity((Long)calOrgId);
            if (costAccountid != null) {
                this.getModel().setValue(this.COSTACCOUNT, (Object)costAccountid);
                this.costAccountChange();
            }
            if ((costAccountVal = this.getModel().getValue(this.COSTACCOUNT)) != null) {
                DynamicObject costAccount = (DynamicObject)costAccountVal;
                String policyID = costAccount.getString("calpolicy.id");
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)policyID, (String)"cal_bd_calpolicy");
                DynamicObject currency = obj.getDynamicObject("currency");
                this.loadHeadData(currency);
                this.getPageCache().put(this.AMT_PRECISION, String.valueOf(currency.getInt("amtprecision")));
            }
        }
    }

    private void beforeOKcheck() {
        Object calOrg = this.getModel().getValue(this.CALORG);
        Object costaccount = this.getModel().getValue(this.COSTACCOUNT);
        Object year = this.getModel().getValue("year");
        Object number = this.getModel().getValue("periodnum");
        Object starttime = this.getModel().getValue("starttime");
        Object endtime = this.getModel().getValue("endtime");
        Object biztype = this.getModel().getValue(this.BIZTYPE);
        Object batchqty = this.getModel().getValue("batchqty");
        if (calOrg == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CalculateInCostPlugin_21", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        if (costaccount == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6210\u672c\u8d26\u7c3f\u3002", (String)"CalculateInCostPlugin_22", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        if (year == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4f1a\u8ba1\u5e74\u5ea6\u3002", (String)"CalculateInCostPlugin_23", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        if (number == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4f1a\u8ba1\u671f\u95f4\u3002", (String)"CalculateInCostPlugin_24", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        if (biztype == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4e1a\u52a1\u65b9\u5411\u3002", (String)"CalculateInCostPlugin_27", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        if (batchqty == null || (Integer)batchqty == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u5206\u6279\u6570\u91cf\u201d \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExpBillCostPlugin_15", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }

    private QFilter buildFilter() {
        Set pkSet;
        String policyID;
        DynamicObject policyInfo;
        int periodNum;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject calOrg = dataEntity.getDynamicObject(this.CALORG);
        DynamicObject costAccountInfo = dataEntity.getDynamicObject(this.COSTACCOUNT);
        DynamicObjectCollection bdBizType = dataEntity.getDynamicObjectCollection(this.BDBIZTYPE);
        DynamicObjectCollection invScheme = dataEntity.getDynamicObjectCollection(this.INVSCHEME);
        DynamicObjectCollection invType = dataEntity.getDynamicObjectCollection("invtypefilter");
        DynamicObjectCollection billType = dataEntity.getDynamicObjectCollection(this.BILLTYPE);
        DynamicObjectCollection invstatus = dataEntity.getDynamicObjectCollection("invstatusfilter");
        DynamicObjectCollection ownerfilter = dataEntity.getDynamicObjectCollection("ownerfilter");
        DynamicObjectCollection storageorgunitfilter = dataEntity.getDynamicObjectCollection(this.STORAGEORGUNITFILTER);
        DynamicObjectCollection warehouse = dataEntity.getDynamicObjectCollection(this.WAREHOUSE);
        DynamicObjectCollection locationfilter = dataEntity.getDynamicObjectCollection("locationfilter");
        DynamicObjectCollection projectfilter = dataEntity.getDynamicObjectCollection("projectfilter");
        DynamicObjectCollection tracknumberfilter = dataEntity.getDynamicObjectCollection("tracknumberfilter");
        DynamicObjectCollection configuredcodefilter = dataEntity.getDynamicObjectCollection("configuredcodefilter");
        DynamicObjectCollection adminorgfilter = dataEntity.getDynamicObjectCollection("adminorgfilter");
        DynamicObjectCollection ecostcenterfilter = dataEntity.getDynamicObjectCollection("ecostcenterfilter");
        Date starttime = dataEntity.getDate("starttime");
        Date endtime = dataEntity.getDate("endtime");
        String biztype = dataEntity.getString(this.BIZTYPE);
        String lotfilter = dataEntity.getString("lotfilter");
        boolean isLessPrice = dataEntity.getBoolean("islessprice");
        boolean isPresent = dataEntity.getBoolean("ispresent");
        QFilter filter = this.getBaseFilter(calOrg.getLong("id"), costAccountInfo.getLong("id"), starttime, endtime);
        int yearNum = dataEntity.getInt(this.YEAR);
        DynamicObject period = PeriodHelper.getPeriodByNumber((int)yearNum, (int)(periodNum = dataEntity.getInt(this.PERIOD_NUM)), null, (long)(policyInfo = BusinessDataServiceHelper.loadSingle((Object)(policyID = costAccountInfo.getString("calpolicy.id")), (String)"cal_bd_calpolicy")).getDynamicObject("periodtype").getLong("id"));
        if (period == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u6b64\u671f\u95f4\uff0c\u8bf7\u68c0\u67e5\u671f\u95f4\u8bbe\u503c\u662f\u5426\u5408\u7406\u3002", (String)"ExpBillCostPlugin_35", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        filter.and("period", "=", period.get("id"));
        filter.and("isinitbill", "=", (Object)Character.valueOf('0'));
        if (!bdBizType.isEmpty()) {
            filter.and("biztype", "in", (Object)this.getMulDataPK(bdBizType));
        }
        if (!invScheme.isEmpty()) {
            filter.and("invscheme", "in", (Object)this.getMulDataPK(invScheme));
        }
        if (StringUtils.isNotBlank((CharSequence)lotfilter)) {
            filter.and(new QFilter("entry.lot", "in", (Object)lotfilter.split(",")));
        }
        if (storageorgunitfilter.size() > 0) {
            pkSet = this.getMulDataPK(storageorgunitfilter);
            filter.and(new QFilter("storageorgunit", "in", (Object)pkSet));
        }
        if (invType.size() > 0) {
            pkSet = this.getMulDataPK(invType);
            filter.and(new QFilter("entry.invtype", "in", (Object)pkSet));
        }
        if (invstatus.size() > 0) {
            pkSet = this.getMulDataPK(invstatus);
            filter.and(new QFilter("entry.invstatus", "in", (Object)pkSet));
        }
        if (ownerfilter.size() > 0) {
            pkSet = this.getMulDataPK(ownerfilter);
            filter.and(new QFilter("entry.owner", "in", (Object)pkSet));
        }
        if (warehouse.size() > 0) {
            pkSet = this.getMulDataPK(warehouse);
            filter.and(new QFilter("entry.warehouse", "in", (Object)pkSet));
        }
        if (projectfilter.size() > 0) {
            Set projectSet = this.getMulDataPK(projectfilter);
            filter.and(new QFilter("entry.project", "in", (Object)projectSet));
        }
        if (tracknumberfilter.size() > 0) {
            Set tracknumberSet = this.getMulDataPK(tracknumberfilter);
            filter.and(new QFilter("entry.tracknumber", "in", (Object)tracknumberSet));
        }
        if (configuredcodefilter.size() > 0) {
            Set configuredcodeSet = this.getMulDataPK(configuredcodefilter);
            filter.and(new QFilter("entry.configuredcode", "in", (Object)configuredcodeSet));
        }
        if (adminorgfilter.size() > 0) {
            Set adminorgSet = this.getMulDataPK(adminorgfilter);
            filter.and(new QFilter("adminorg", "in", (Object)adminorgSet));
        }
        if (ecostcenterfilter.size() > 0) {
            Set ecostcenterSet = this.getMulDataPK(ecostcenterfilter);
            filter.and(new QFilter("entry.ecostcenter", "in", (Object)ecostcenterSet));
        }
        if (locationfilter.size() > 0) {
            pkSet = this.getMulDataPK(locationfilter);
            filter.and(new QFilter("entry.location", "in", (Object)pkSet));
        }
        if (isLessPrice) {
            filter.and(new QFilter("entry.unitactualcost", "<=", (Object)0));
        }
        if (!isPresent) {
            filter.and(new QFilter("entry.ispresent", "=", (Object)Character.valueOf('0')));
        }
        if (!"NULL".equals(biztype)) {
            filter.and(new QFilter("calbilltype", "=", (Object)biztype));
        }
        DynamicObjectCollection materialFrom = this.getModel().getDataEntity().getDynamicObjectCollection("materialfrom");
        DynamicObject materialTo = this.getModel().getDataEntity().getDynamicObject("materialto");
        String matProp = "entry.material";
        QFilter matFilter = new MatFromToFilter().getMatFilter(materialFrom, materialTo, matProp);
        filter.and(matFilter);
        if (billType.size() > 0) {
            Set pkSet2 = this.getMulDataPK(billType);
            filter.and(new QFilter("billtype", "in", (Object)pkSet2));
        }
        Object[] purBitype = CostRecordQFilterHelper.getBiztype((String)"purbiztype");
        QFilter purInQ = new QFilter("bizentityobject", "in", (Object)purBitype);
        purInQ.and("issplitcreate", "=", (Object)Character.valueOf('0'));
        Object[] outSpliteBiztype = CostRecordQFilterHelper.getBiztype((String)"outsplitebiztype");
        QFilter saleOutQ = new QFilter("bizentityobject", "in", (Object)CostRecordQFilterHelper.getBiztype((String)"outsplitebiztype"));
        saleOutQ.and("issplitcreate", "=", (Object)Character.valueOf('0'));
        Object[] omBitype = CostRecordQFilterHelper.getBiztype((String)"ominbiztype");
        QFilter omInQ = new QFilter("bizentityobject", "in", (Object)omBitype);
        omInQ.and("issplitcreate", "=", (Object)Character.valueOf('0'));
        Object[] allBizType = org.apache.commons.lang.ArrayUtils.addAll((Object[])purBitype, (Object[])outSpliteBiztype);
        allBizType = org.apache.commons.lang.ArrayUtils.addAll((Object[])allBizType, (Object[])omBitype);
        QFilter otherQ = new QFilter("bizentityobject", "not in", (Object)allBizType);
        filter.and(purInQ.or(saleOutQ).or(otherQ).or(omInQ));
        filter.and("isvoucher", "=", (Object)Character.valueOf('0'));
        filter.and(CostRecordQFilterHelper.getBizEntityTypeQFilter());
        filter.and("entry.accounttype", "<>", (Object)AccountTypeEnum.MOVE_ADD_AVERAGE.getValue());
        filter.and("entry.accounttype", "<>", (Object)AccountTypeEnum.FIN_FOUT.getValue());
        filter.and("entry.accounttype", "<>", (Object)AccountTypeEnum.STANDARDCOST.getValue());
        filter.and("costaccount.enablestandardcost", "=", (Object)false);
        filter.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        filter.and("entry.invtype.isforwardamount", "=", (Object)true);
        filter.and("invscheme.isforwardamount", "=", (Object)true);
        filter.and("ischargeoffed", "=", (Object)false);
        filter.and("ischargeoff", "=", (Object)false);
        filter.and("invscheme.zerocost", "=", (Object)false);
        QFilter dynamicFilter = this.getFilter("cal_costrecord", DYNAMIC_GRID);
        if (dynamicFilter != null) {
            filter.and(dynamicFilter);
        }
        return filter;
    }

    protected QFilter getFilter(String billType, String filterGirdName) {
        if (billType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"FeeShareQueryPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(filterGirdName);
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        MainEntityType bizEntityType = MetadataServiceHelper.getDataEntityType((String)billType);
        FilterBuilder filterBuilder = new FilterBuilder(bizEntityType, filterCondition);
        UserService userService = new UserService();
        filterBuilder.setUserService((IUserService)userService);
        filterBuilder.buildFilter();
        return filterBuilder.getQFilter();
    }

    private QFilter getBaseFilter(long orgID, long costAccountID, Date starttime, Date endtime) {
        QFilter filter = new QFilter("calorg", "=", (Object)orgID);
        filter.and(new QFilter("costaccount", "=", (Object)costAccountID));
        filter.and(new QFilter("bookdate", ">=", (Object)starttime));
        filter.and(new QFilter("bookdate", "<=", (Object)endtime));
        return filter;
    }

    private Set getMulDataPK(DynamicObjectCollection mulColls) {
        HashSet<Object> pkSet = new HashSet<Object>(16);
        int size = mulColls.size();
        for (int i = 0; i < size; ++i) {
            Object pk = ((DynamicObject)mulColls.get(i)).getDynamicObject("fbasedataid").getPkValue();
            pkSet.add(pk);
        }
        return pkSet;
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String sourceID = event.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        if (this.COSTACCOUNT.equals(sourceID)) {
            DynamicObject calOrg = this.getModel().getDataEntity().getDynamicObject(this.CALORG);
            if (calOrg == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CalculateInCostPlugin_28", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
            Set endInitCostAccountIds = PeriodHelper.getEndInitCostAccountByCalOrg((Long)calOrg.getLong("id"));
            QFilter qf = new QFilter("id", "=", (Object)-1L);
            if (endInitCostAccountIds != null && !endInitCostAccountIds.isEmpty()) {
                qf = new QFilter("id", "in", (Object)endInitCostAccountIds);
                qf.and("enable", "=", (Object)"1");
            }
            showParameter.getListFilterParameter().setFilter(qf);
        } else if (this.LOCATUINFILTER.equals(sourceID)) {
            DynamicObjectCollection warehouses = this.getModel().getDataEntity().getDynamicObjectCollection(this.WAREHOUSE);
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(688888L);
            if (warehouses != null && warehouses.size() > 0) {
                for (DynamicObject warehs : warehouses) {
                    DynamicObjectCollection locationCol = warehs.getDynamicObject("fbasedataid").getDynamicObjectCollection("entryentity");
                    List<Long> tid = this.getLoactionIds(locationCol);
                    ids.addAll(tid);
                }
            }
            Iterator qf = new QFilter("id", "in", ids);
            showParameter.getListFilterParameter().setFilter((QFilter)qf);
        } else if (this.WAREHOUSE.equals(sourceID)) {
            DynamicObjectCollection storageOrgs = this.getModel().getDataEntity().getDynamicObjectCollection(this.STORAGEORGUNITFILTER);
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(688888L);
            if (storageOrgs != null && storageOrgs.size() > 0) {
                for (DynamicObject org : storageOrgs) {
                    String orgNumber = org.getDynamicObject("fbasedataid").getString("number");
                    Long[] tid = SCMHelper.getAllWarehouseIDs((String)orgNumber);
                    if (tid == null || tid.length <= 0) continue;
                    for (Long id : tid) {
                        ids.add(id);
                    }
                }
            }
            Iterator qf = new QFilter("id", "in", ids);
            showParameter.setUseOrgId(0L);
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            qFilters.clear();
            qFilters.add(qf);
        } else if (this.STORAGEORGUNITFILTER.equals(sourceID)) {
            DynamicObject calOrg = this.getModel().getDataEntity().getDynamicObject(this.CALORG);
            List storageOrgIdList = new ArrayList();
            if (null != calOrg) {
                storageOrgIdList = OrgHelper.getStorageOrgUnitByCalOrg((Long)calOrg.getLong("id"));
            }
            QFilter qf = new QFilter("id", "in", storageOrgIdList);
            showParameter.getListFilterParameter().setFilter(qf);
        } else if (this.CALORG.equals(sourceID)) {
            long userId = Long.parseLong(RequestContext.get().getUserId());
            List calorgList = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_in_calculate", (String)"47150e89000000ac");
            if (calorgList != null) {
                QFilter qf = new QFilter("id", "in", (Object)calorgList);
                showParameter.getListFilterParameter().setFilter(qf);
            }
        } else if (this.OWNERFILTER.equals(sourceID)) {
            DynamicObject costAccount = (DynamicObject)this.getModel().getValue(this.COSTACCOUNT);
            QFilter q = new QFilter("id", "=", (Object)-1L);
            if (costAccount != null) {
                q = new QFilter("id", "in", (Object)AccountingSysHelper.getOwners((Long)costAccount.getLong("id")));
            }
            ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().setFilter(q);
        } else if (this.BILLTYPE.equals(sourceID)) {
            List numList = CostRecordQFilterHelper.getMatchBilltype((String)"billtypematch");
            QFilter qf = new QFilter("id", "in", (Object)numList);
            showParameter.getListFilterParameter().setFilter(qf);
        } else if (this.BDBIZTYPE.equals(sourceID)) {
            DynamicObjectCollection billType = this.getModel().getDataEntity().getDynamicObjectCollection(this.BILLTYPE);
            Set pkSet = this.getMulDataPK(billType);
            HashSet bizTypeIds = new HashSet();
            for (Object o : pkSet) {
                Map<Long, JSONObject> bizTypeMap = this.getBizTypeByBillTypeparameterId(Long.valueOf(o.toString()));
                for (JSONObject value : bizTypeMap.values()) {
                    Map map = (Map)value.toJavaObject(Map.class);
                    Set biztypeids = map.get("biztypeids") == null ? new HashSet() : (Set)map.get("biztypeids");
                    long defaultbiztypeid = map.get("defaultbiztypeid") == null ? 0L : Long.parseLong((String)map.get("defaultbiztypeid"));
                    bizTypeIds.addAll(biztypeids);
                    bizTypeIds.add(defaultbiztypeid);
                }
            }
            QFilter qFilter = new QFilter("id", "in", bizTypeIds);
            showParameter.getListFilterParameter().setFilter(qFilter);
        } else if (this.INVSCHEME.equals(sourceID)) {
            Set bizTypIdSet;
            DynamicObjectCollection billType = this.getModel().getDataEntity().getDynamicObjectCollection(this.BILLTYPE);
            Set pkSet = this.getMulDataPK(billType);
            Set<String> bizTypeNumber = this.getBizTypeBybillType(pkSet);
            DynamicObjectCollection bizType = this.getModel().getDataEntity().getDynamicObjectCollection(this.BDBIZTYPE);
            QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            if (!bizTypeNumber.isEmpty()) {
                qFilter.and("billform", "in", bizTypeNumber);
            }
            if (!(bizTypIdSet = this.getMulDataPK(bizType)).isEmpty()) {
                qFilter.and("bitypeentry.biztype", "in", (Object)bizTypIdSet);
            }
            showParameter.getListFilterParameter().setFilter(qFilter);
        } else if (this.MATERIALFROM.equals(sourceID) || "materialto".equals(sourceID)) {
            ReportF7Helper.beforeF7Select4Material((BeforeF7SelectEvent)event);
        }
    }

    private Set<String> getBizTypeBybillType(Set<Object> pkSet) {
        DynamicObjectCollection biztypeCollect = QueryServiceHelper.query((String)"bos_billtype", (String)"billformid.number", (QFilter[])new QFilter("id", "in", pkSet).toArray());
        HashSet<String> bizTypeNumber = new HashSet<String>();
        for (DynamicObject dynamic : biztypeCollect) {
            String number = dynamic.getString("billformid.number");
            bizTypeNumber.add(number);
        }
        return bizTypeNumber;
    }

    public Map<Long, JSONObject> getBizTypeByBillTypeparameterId(Long billTypeId) {
        StringBuilder sql = new StringBuilder();
        sql.append(SQL);
        sql.append(billTypeId);
        HashMap<Long, JSONObject> result = new HashMap<Long, JSONObject>();
        DataSet ds = DB.queryDataSet((String)"getBizTypeByBillTypeparameterId", (DBRoute)DBRoute.basedata, (String)sql.toString());
        for (Row row : ds) {
            String fdata = row.getString("FDATA");
            if (StringUtils.isEmpty((CharSequence)fdata)) continue;
            Map map = (Map)JSON.parseObject((String)fdata, Map.class);
            if (map.get("entryentity") == null) {
                result.put(billTypeId, new JSONObject());
                return result;
            }
            JSONArray arrays = JSON.parseArray((String)map.get("entryentity").toString());
            if (map == null || arrays == null || arrays.size() <= 0) continue;
            JSONObject rs = new JSONObject();
            JSONArray bizTypes = new JSONArray();
            for (Object obj : arrays) {
                JSONObject data = JSONObject.parseObject((String)obj.toString());
                if ("true".equals(data.getString("isdefault"))) {
                    rs.put("defaultbiztypeid", (Object)data.getString("biztypenumber_id"));
                }
                if (data.getLong("biztypenumber_id") == null || data.getLong("biztypenumber_id") == 0L) continue;
                bizTypes.add((Object)data.getLong("biztypenumber_id"));
            }
            if (bizTypes.size() > 0) {
                Map bts = BusinessDataServiceHelper.loadFromCache((String)"bd_biztype", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)Character.valueOf('1')), new QFilter("id", "in", (Object)bizTypes)});
                if (bts != null && bts.size() > 0) {
                    HashSet<Long> ids = new HashSet<Long>(bts.size());
                    for (Map.Entry m : bts.entrySet()) {
                        ids.add(Long.parseLong(m.getKey().toString()));
                    }
                    rs.put("biztypeids", ids);
                    if (!StringUtils.isEmpty((CharSequence)rs.getString("defaultbiztypeid")) && !ids.contains(Long.parseLong(rs.getString("defaultbiztypeid")))) {
                        rs.remove((Object)"defaultbiztypeid");
                    }
                } else {
                    rs.remove((Object)"defaultbiztypeid");
                }
            }
            result.put(billTypeId, rs);
        }
        return result;
    }

    private List<Long> getLoactionIds(DynamicObjectCollection locationCol) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (locationCol == null || locationCol.size() == 0) {
            return ids;
        }
        for (DynamicObject locDym : locationCol) {
            ids.add(locDym.getLong("location.id"));
        }
        return ids;
    }

    private void exportExcel() {
        DynamicObject info = this.getModel().getDataEntity().getDynamicObject(this.COSTACCOUNT);
        boolean isCostRecordDetail = ParamsHelper.getCostElementByCostAccount((long)info.getLong("id"));
        String billFormId = "cal_costprocessinfo";
        long templateId = isCostRecordDetail ? 1890644319325539328L : 1890643843850849280L;
        try {
            FormView formView = (FormView)this.getView();
            String routeAppId = formView.getFormShowParameter().getServiceAppId();
            String url = this.export(routeAppId, billFormId, templateId, isCostRecordDetail);
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                this.getView().download(url);
                this.getView().sendFormAction(this.getView());
            }
        }
        catch (IOException e) {
            throw new KDBizException(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    public String export(String routeAppId, String formId, Long template, boolean isCostRecordDetail) throws IOException {
        SXSSFWorkbook wb = new SXSSFWorkbook(50000);
        wb.setCompressTempFiles(Boolean.TRUE.booleanValue());
        SXSSFSheet sheet = wb.createSheet("sheet1");
        ExportSheetStyle styles = new ExportSheetStyle(wb);
        ExportWriterFormat format = ExportUtil.getExportWriterFormatAndWriteHead(wb, sheet, styles, routeAppId, formId, template, null);
        if (format == null) {
            return null;
        }
        int rowIndex = 4;
        Object groupColVal = this.getModel().getValue(GROUP_COL);
        String groupCol = groupColVal == null ? "" : (String)groupColVal;
        HashSet<String> chosenColList = new HashSet<String>();
        boolean isGroup = false;
        if (!StringUtils.isEmpty((CharSequence)groupCol)) {
            String[] split;
            for (String s : split = groupCol.split(",")) {
                if (StringUtils.isEmpty((CharSequence)s)) continue;
                if ("cal_group".equals(s)) {
                    String[] divAndDimensionCols = this.getDivAndDimensionCols(this.getCostAccountId());
                    chosenColList.addAll(new ArrayList<String>(Arrays.asList(divAndDimensionCols)));
                    isGroup = true;
                }
                if ("cal_material".equals(s)) {
                    chosenColList.addAll(new ArrayList<String>(Arrays.asList(this.FIX_COL)));
                }
                chosenColList.add(s);
            }
            if (!chosenColList.isEmpty()) {
                this.removeUnnecessary(chosenColList);
                if (isGroup) {
                    chosenColList.add(CALRANGE);
                }
                chosenColList.remove("cal_group");
                chosenColList.remove("cal_material");
            }
        }
        DynamicObjectCollection pageDataList = this.getModel().getEntryEntity("entryentity");
        ArrayList<DynamicObject> exportList = new ArrayList<DynamicObject>(pageDataList.size());
        MainEntityType costRecordEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costprocessinfo");
        int index = 0;
        for (DynamicObject rowData : pageDataList) {
            String extendFields;
            String commentMark = null;
            TreeMap<String, Long> specialKeyColMap = new TreeMap<String, Long>();
            DynamicObject exportRow = BusinessDataServiceHelper.newDynamicObject((String)"cal_costprocessinfo");
            DynamicObject entry = exportRow.getDynamicObjectCollection("entry").addNew();
            entry.set("id", (Object)index++);
            String curField = null;
            Object curValue = null;
            try {
                Iterator iterator = chosenColList.iterator();
                while (iterator.hasNext()) {
                    String string;
                    curField = string = (String)iterator.next();
                    curValue = rowData.get(string);
                    IDataEntityProperty property = costRecordEntityType.findProperty(string);
                    if (property == null) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u6216\u6210\u672c\u5904\u7406\u4fe1\u606f\u672a\u6269\u5c55\u5b57\u6bb5%1$s\uff0c\u5f15\u51fa\u5931\u8d25", (String)"CalculateInCostPlugin_54", (String)"fi-cal-formplugin", (Object[])new Object[0]), string));
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u6216\u6210\u672c\u5904\u7406\u4fe1\u606f\u672a\u6269\u5c55\u5b57\u6bb5%1$s\uff0c\u5f15\u51fa\u5931\u8d25", (String)"CalculateInCostPlugin_54", (String)"fi-cal-formplugin", (Object[])new Object[0]), string));
                    }
                    if (!(property.getParent() instanceof EntryType)) {
                        if (property instanceof FlexProp) {
                            exportRow.set(string, rowData.get(string));
                            continue;
                        }
                        if (property instanceof BasedataProp) {
                            DynamicObject dynamicObject = rowData.getDynamicObject(string);
                            exportRow.set(string, (Object)dynamicObject);
                            continue;
                        }
                        exportRow.set(string, rowData.get(string));
                        continue;
                    }
                    if (property instanceof FlexProp) {
                        entry.set(string, rowData.get(string));
                        if (!"assist".equals(string)) continue;
                        long l = rowData.get(string) == null ? 0L : ((DynamicObject)rowData.get(string)).getLong("id");
                        specialKeyColMap.put("assist", l);
                        continue;
                    }
                    if (property instanceof BasedataProp) {
                        if (CALRANGE.equals(string)) {
                            long l = rowData.getDynamicObject(string) == null ? 0L : ((DynamicObject)rowData.get(string)).getLong("id");
                            specialKeyColMap.put(CALRANGE, l);
                        }
                        DynamicObject dynamicObject = rowData.getDynamicObject(string);
                        entry.set(string, (Object)dynamicObject);
                        continue;
                    }
                    entry.set(string, rowData.get(string));
                }
            }
            catch (Exception e) {
                throw new KDBizException("field not found : " + curField + " : " + curValue + " : " + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
            entry.set("baseqty", rowData.get("baseqty"));
            entry.set("unitactualcost", (Object)rowData.getBigDecimal("unitactualcost"));
            entry.set("actualcost", (Object)rowData.getBigDecimal("actualcost"));
            if (isCostRecordDetail) {
                DynamicObjectCollection costSubElements = this.getModel().getDataEntity().getDynamicObjectCollection(this.COSTSUBELEMENT);
                for (DynamicObject costSubElement : costSubElements) {
                    DynamicObject dynamicObject = costSubElement.getDynamicObject("fbasedataid");
                    String subEleNum = dynamicObject.getString("number");
                    if (!entry.containsProperty(subEleNum + "_cost") || !entry.containsProperty(subEleNum + "_unitcost")) continue;
                    entry.set(subEleNum + "_unitcost", (Object)rowData.getBigDecimal(subEleNum + "_unitcost"));
                    entry.set(subEleNum + "_cost", (Object)rowData.getBigDecimal(subEleNum + "_cost"));
                }
            }
            if ((extendFields = this.getPageCache().get("extendFields")) != null) {
                List list = (List)SerializationUtils.fromJsonString((String)extendFields, ArrayList.class);
                for (String string : list) {
                    DynamicObject baseDynamic;
                    DynamicObject dynamicObject;
                    String baseEntityId;
                    BasedataProp prop;
                    IDataEntityProperty property = costRecordEntityType.findProperty(string);
                    if (property == null) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u6216\u6210\u672c\u5904\u7406\u4fe1\u606f\u672a\u6269\u5c55\u5b57\u6bb5%1$s\uff0c\u5f15\u51fa\u5931\u8d25", (String)"CalculateInCostPlugin_54", (String)"fi-cal-formplugin", (Object[])new Object[0]), string));
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u6216\u6210\u672c\u5904\u7406\u4fe1\u606f\u672a\u6269\u5c55\u5b57\u6bb5%1$s\uff0c\u5f15\u51fa\u5931\u8d25", (String)"CalculateInCostPlugin_54", (String)"fi-cal-formplugin", (Object[])new Object[0]), string));
                    }
                    if (!(property.getParent() instanceof EntryType)) {
                        if (property instanceof BasedataProp) {
                            prop = (BasedataProp)property;
                            baseEntityId = prop.getBaseEntityId();
                            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)baseEntityId);
                            baseDynamic = rowData.getDynamicObject(string);
                            dynamicObject.set("number", baseDynamic != null ? baseDynamic.getString("number") : null);
                            dynamicObject.set("name", baseDynamic != null ? baseDynamic.getString("name") : null);
                            exportRow.set(string, (Object)dynamicObject);
                            continue;
                        }
                        exportRow.set(string, rowData.get(string));
                        continue;
                    }
                    if (property instanceof BasedataProp) {
                        prop = (BasedataProp)property;
                        baseEntityId = prop.getBaseEntityId();
                        dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)baseEntityId);
                        baseDynamic = rowData.getDynamicObject(string);
                        dynamicObject.set("number", baseDynamic != null ? baseDynamic.getString("number") : null);
                        dynamicObject.set("name", baseDynamic != null ? baseDynamic.getString("name") : null);
                        entry.set(string, (Object)dynamicObject);
                        continue;
                    }
                    entry.set(string, rowData.get(string));
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry entry2 : specialKeyColMap.entrySet()) {
                stringBuilder.append(entry2.getValue()).append("_");
            }
            commentMark = stringBuilder.toString();
            exportRow.set("comment", (Object)commentMark);
            exportList.add(exportRow);
        }
        String json = SerializationUtils.toJsonString(exportList);
        JSONArray billArr = JSONArray.parseArray((String)json);
        LocalDate now = LocalDate.now();
        DynamicObject templateData = BusinessDataServiceHelper.loadSingle((Object)template, (String)"bos_importtemplate");
        String content = String.format(ResManager.loadKDString((String)"\u9884\u7f6e_%1$s", (String)"CalculateInCostPlugin_38", (String)"fi-cal-formplugin", (Object[])new Object[0]), templateData.get("name"));
        String fileName = content + "_" + now.getMonthValue() + now.getDayOfMonth() + ".xlsx";
        FelxHelper.changeFlexDatas((JSONArray)billArr, (String)"assist", (SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (ExportWriterFormat)format, (String)fileName);
        return this.writeFile(wb, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeFile(SXSSFWorkbook wb, String fileName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        String url = "";
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 10000);
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
        return url;
    }

    private void doJob() {
        int[] indexs;
        if (!this.doCheck()) {
            return;
        }
        DynamicObjectCollection entityColl = this.getModel().getEntryEntity("entryentity");
        DynamicObjectCollection selectEntryDycs = new DynamicObjectCollection();
        for (int index : indexs = this.getSelectIndexs("entryentity")) {
            selectEntryDycs.add(entityColl.get(index));
        }
        if (selectEntryDycs.size() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u7b5b\u9009\u8ba1\u7b97\u6570\u636e\u3002", (String)"CalculateInCostPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        this.dispatchByBatch(selectEntryDycs);
        this.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u81f3\u540e\u53f0\u4efb\u52a1\uff0c\u8bf7\u7559\u610f\u7cfb\u7edf\u63d0\u793a\u3002", (String)"CalculateInCostPlugin_29", (String)"fi-cal-formplugin", (Object[])new Object[0]));
    }

    private void doJobAll() {
        if (!this.doCheck()) {
            return;
        }
        DynamicObjectCollection entityColl = this.getModel().getEntryEntity("entryentity");
        if (entityColl.size() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u7b5b\u9009\u8ba1\u7b97\u6570\u636e\u3002", (String)"CalculateInCostPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        this.dispatchByBatch(entityColl);
        this.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u81f3\u540e\u53f0\u4efb\u52a1\uff0c\u8bf7\u7559\u610f\u7cfb\u7edf\u63d0\u793a\u3002", (String)"CalculateInCostPlugin_29", (String)"fi-cal-formplugin", (Object[])new Object[0]));
    }

    private boolean doCheck() {
        int number;
        DynamicObject info = this.getModel().getDataEntity().getDynamicObject(this.COSTACCOUNT);
        DynamicObject period = PeriodHelper.getCurrentPeriod((Long)info.getLong("id"));
        if (period == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u6210\u672c\u8d26\u7c3f\u672a\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"CalculateInCostPlugin_31", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return false;
        }
        int year = period.getInt("periodyear");
        int periodNumBefore = year * 100 + (number = period.getInt("periodnumber"));
        int periodNumAfter = this.getAfterPeriod(periodNumBefore);
        if (periodNumAfter < periodNumBefore) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4fee\u6539\u5f80\u671f\u6570\u636e\u7684\u6210\u672c\u3002", (String)"CalculateInCostPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private Map<String, Object> buildTaskParam(List<String> paramList) {
        HashMap<String, Object> jobParams = new HashMap<String, Object>(16);
        jobParams.put("PARAMLIST", SerializationUtils.toJsonString(paramList));
        jobParams.put("QFILTER", this.getPageCache().get(this.QFILTER));
        jobParams.put("ISOMINBILLTYPE", this.getPageCache().get(this.ISOMINBILLTYPE));
        jobParams.put("AMT_PRECISION", this.getPageCache().get(this.AMT_PRECISION));
        jobParams.put("SUMTYPE", this.getPageCache().get("mulsumType"));
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue(this.COSTACCOUNT);
        jobParams.put("COSTACCOUNT", costAccount.getLong("id"));
        jobParams.put("STARTTIME", ((Date)this.getModel().getValue("starttime")).getTime());
        jobParams.put("ENDTIME", ((Date)this.getModel().getValue("endtime")).getTime());
        int year = this.getModel().getValue("year") == null ? 0 : (Integer)this.getModel().getValue("year");
        int period = this.getModel().getValue("periodnum") == null ? 0 : (Integer)this.getModel().getValue("periodnum");
        jobParams.put("PAGE_YEARMONTH", year * 100 + period);
        return jobParams;
    }

    private void dispatchByBatch(DynamicObjectCollection entityColl) {
        Integer batch = (Integer)this.getModel().getValue("batchqty");
        if (batch <= 0) {
            batch = entityColl.size();
        }
        int pages = entityColl.size() / batch;
        if (entityColl.size() % batch != 0) {
            ++pages;
        }
        HashSet<Integer> curOpPages = new HashSet<Integer>(pages);
        for (int i = 0; i < pages; ++i) {
            curOpPages.add(i + 1);
        }
        String curOpPageIdTimeKey = this.getView().getPageId();
        curOpPageIdTimeKey = curOpPageIdTimeKey + System.currentTimeMillis();
        IAppCache appCache = AppCache.get((String)"cal");
        appCache.put(curOpPageIdTimeKey, curOpPages);
        ArrayList<String> taskIds = new ArrayList<String>(16);
        DynamicObjectCollection costSubElements = this.getModel().getDataEntity().getDynamicObjectCollection(this.COSTSUBELEMENT);
        for (int pageIndex = 1; pageIndex <= pages; ++pageIndex) {
            int pageStart = (pageIndex - 1) * batch;
            int pageEnd = pageIndex * batch - 1;
            if (pageEnd >= entityColl.size() - 1) {
                pageEnd = entityColl.size() - 1;
            }
            List<String> paramList = this.buildCalInStrParamsBatch(pageStart, pageEnd, entityColl, costSubElements);
            ArrayList<Object> matIds = new ArrayList<Object>(16);
            for (int index = pageStart; index <= pageEnd; ++index) {
                DynamicObject entity = (DynamicObject)entityColl.get(index);
                matIds.add(entity.getDynamicObject("material").getPkValue());
            }
            Map<String, Object> jobParams = this.buildTaskParam(paramList);
            jobParams.put("MATIDS", matIds);
            jobParams.put("CUROPPAGEIDTIMEKEY", curOpPageIdTimeKey);
            jobParams.put("PAGEINDEX", pageIndex);
            String batchStr = String.format("%s-[%s/%s]", batch, pageIndex, pages);
            jobParams.put("BATCHSTR", batchStr);
            String taskId = this.dispatchTask(batchStr, jobParams, curOpPageIdTimeKey);
            taskIds.add(taskId);
        }
        this.getPageCache().put("taskIds", JSONObject.toJSONString(taskIds));
    }

    private Map<String, Object> getMatNumIdMap(DynamicObjectCollection entityColl) {
        HashSet<Object> matNums = new HashSet<Object>(16);
        for (int i = 0; i < entityColl.size(); ++i) {
            DynamicObject entity = (DynamicObject)entityColl.get(i);
            matNums.add(entity.getDynamicObject("material").getPkValue());
        }
        QFilter q = new QFilter("id", "in", matNums);
        HashMap<String, Object> matNumIdMap = new HashMap<String, Object>(16);
        try (DataSet matDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_material", (String)"id,number", (QFilter[])q.toArray(), null);){
            for (Row row : matDs) {
                matNumIdMap.put(row.getString("number"), row.get("id"));
            }
        }
        return matNumIdMap;
    }

    private String dispatchTask(String batchStr, Map<String, Object> jobParams, String curOpPageIdTimeKey) {
        String content;
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue(this.COSTACCOUNT);
        JobInfo job = new JobInfo();
        String opName = content = String.format(ResManager.loadKDString((String)"\u5165\u5e93\u6c47\u603b\u6838\u7b97-\u6210\u672c\u8d26\u7c3f\u7f16\u7801:%1$s,\u6210\u672c\u8d26\u7c3f\u540d\u79f0:%2$s", (String)"CalculateInCostPlugin_39", (String)"fi-cal-formplugin", (Object[])new Object[0]), costAccount.getString("number"), costAccount.getString("name"));
        job.setName(opName + "-" + batchStr);
        job.setTaskDefineId("2TEE7NSZK++W");
        job.setJobType(JobType.BIZ);
        job.setParams(jobParams);
        job.setAppId("cal");
        job.setTaskClassname("kd.fi.cal.formplugin.calculate.in.CalculateInCostTask");
        job.setRunByLang(Lang.get());
        String taskid = JobClient.dispatch((JobInfo)job);
        return taskid;
    }

    private int getAfterPeriod(Integer periodNumBefore) {
        DynamicObject entity = this.getModel().getDataEntity();
        DynamicObject info = entity.getDynamicObject(this.COSTACCOUNT);
        if (info == null) {
            return periodNumBefore;
        }
        int yearNum = entity.getInt(this.YEAR);
        int periodNum = entity.getInt("periodnum");
        int periodNumAfter = yearNum * 100 + periodNum;
        return periodNumAfter;
    }

    protected int[] getSelectIndexs(String billType) {
        EntryGrid mainEntryGrid = (EntryGrid)this.getControl(billType);
        int[] indexs = mainEntryGrid.getSelectRows();
        return indexs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onProgress(ProgressEvent progressEvent) {
        String cacheId = this.getPageCache().get("cacheId");
        String progress = this.getPageCache().get(PROGRESS_KEY);
        progress = StringUtils.isEmpty((CharSequence)progress) ? "15" : progress;
        int progressPercent = Integer.parseInt(progress);
        progressEvent.setProgress(progressPercent);
        if (!StringUtils.isEmpty((CharSequence)cacheId)) {
            ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
            bar.stop();
            if (cacheId.contains(this.exPreStr)) {
                progressEvent.setProgress(100);
                this.getPageCache().put(PROGRESS_KEY, "100");
                this.getView().showErrorNotification(cacheId.replace(this.exPreStr, ""));
                this.getPageCache().remove("cacheId");
                return;
            }
            progressEvent.setProgress(70);
            this.getPageCache().put(PROGRESS_KEY, "70");
            try {
                if (StringUtils.isEmpty((CharSequence)cacheId)) {
                    return;
                }
                if (cacheId.contains(CALCULATE_PRICE)) {
                    String replace = cacheId.replace(CALCULATE_PRICE, "");
                    String priceVersion = this.getPageIdCacheValue(cacheId);
                    String maxQueryVersion = this.getPageIdCacheValue(MAX_QUERY);
                    if (!StringUtils.isEmpty((CharSequence)priceVersion) && !StringUtils.isEmpty((CharSequence)maxQueryVersion) && Integer.parseInt(priceVersion) >= Integer.parseInt(maxQueryVersion)) {
                        DataSet priceDataSet = Algo.getCacheDataSet((String)replace).toDataSet(Algo.create((String)((Object)((Object)this)).getClass().getName()), true);
                        int precision = Integer.parseInt(this.getPageCache().get(this.AMT_PRECISION));
                        this.getModel().beginInit();
                        DynamicObject costAccount = (DynamicObject)this.getModel().getValue(this.COSTACCOUNT);
                        boolean isCostRecordDetail = ParamsHelper.getCostElementByCostAccount((long)costAccount.getLong("id"));
                        Long[] defaultElementIds = CostElementHelper.getDefaultMaterialElements();
                        Long defaultMaterialElement = defaultElementIds[0];
                        DynamicObjectCollection costSubElements = this.getModel().getDataEntity().getDynamicObjectCollection(this.COSTSUBELEMENT);
                        for (Row row : priceDataSet) {
                            Integer rowIndex = row.getInteger("index");
                            BigDecimal actualCost = (BigDecimal)this.getModel().getValue(this.ACTUALCOST, rowIndex.intValue());
                            BigDecimal qty = new BigDecimal(this.getModel().getValue(this.BASEQTY, rowIndex.intValue()).toString());
                            BigDecimal newUnitActualCost = BigDecimal.ZERO;
                            if (!isCostRecordDetail) {
                                newUnitActualCost = row.getBigDecimal(String.valueOf(defaultMaterialElement));
                                newUnitActualCost = newUnitActualCost == null ? BigDecimal.ZERO : newUnitActualCost;
                                BigDecimal newActualCost = newUnitActualCost.multiply(qty).setScale(precision, RoundingMode.HALF_UP);
                                BigDecimal diffcost = newActualCost.subtract(actualCost);
                                BigDecimal oldMaterialCost = (BigDecimal)this.getModel().getValue(this.MATERIALCOST, rowIndex.intValue());
                                BigDecimal newMaterialCost = oldMaterialCost.add(diffcost);
                                this.getModel().setValue(this.UNITMATERIALCOST, (Object)this.calUnitCostByAct(qty, newMaterialCost), rowIndex.intValue());
                                this.getModel().setValue(this.MATERIALCOST, (Object)newMaterialCost, rowIndex.intValue());
                                this.getView().updateView(this.UNITMATERIALCOST, rowIndex.intValue());
                                this.getView().updateView(this.MATERIALCOST, rowIndex.intValue());
                                actualCost = newActualCost;
                            }
                            for (DynamicObject costSubElement : costSubElements) {
                                DynamicObject info = costSubElement.getDynamicObject("fbasedataid");
                                long subEleId = info.getLong("id");
                                String subEleNum = info.getString("number");
                                BigDecimal subEleUnitCost = row.getBigDecimal(String.valueOf(subEleId));
                                if (subEleUnitCost == null) {
                                    subEleUnitCost = BigDecimal.ZERO;
                                }
                                BigDecimal subEleCost = subEleUnitCost.multiply(qty).setScale(precision, RoundingMode.HALF_UP);
                                BigDecimal oldSubEleCost = (BigDecimal)this.getModel().getValue(subEleNum + "_cost", rowIndex.intValue());
                                actualCost = actualCost.subtract(oldSubEleCost).add(subEleCost);
                                this.getModel().setValue(subEleNum + "_unitcost", (Object)subEleUnitCost, rowIndex.intValue());
                                this.getModel().setValue(subEleNum + "_cost", (Object)subEleCost, rowIndex.intValue());
                                this.getView().updateView(subEleNum + "_unitcost", rowIndex.intValue());
                                this.getView().updateView(subEleNum + "_cost", rowIndex.intValue());
                            }
                            this.getModel().setValue(this.ACTUALCOST, (Object)actualCost, rowIndex.intValue());
                            if (newUnitActualCost != null && newUnitActualCost.signum() != 0) {
                                this.getModel().setValue(this.UNITACTUALCOST, (Object)newUnitActualCost, rowIndex.intValue());
                            } else {
                                this.getModel().setValue(this.UNITACTUALCOST, (Object)this.calUnitCostByAct(qty, actualCost), rowIndex.intValue());
                            }
                            this.getView().updateView(this.ACTUALCOST, rowIndex.intValue());
                            this.getView().updateView(this.UNITACTUALCOST, rowIndex.intValue());
                        }
                        this.getModel().endInit();
                        String s = ResManager.loadKDString((String)"\u53d6\u4ef7\u5b8c\u6210\uff0c\u8bf7\u786e\u8ba4\u53d6\u4ef7\u7ed3\u679c\u540e\u66f4\u65b0\u5355\u636e\u6210\u672c\u3002", (String)"CalculateInCostPlugin_41", (String)"fi-cal-formplugin", (Object[])new Object[0]);
                        this.getView().showSuccessNotification(s);
                    } else {
                        logger.info("\u5165\u5e93\u6c47\u603b\u6838\u7b97\u5f02\u6b65\u53d6\u4ef7 price job is abort : max query {}, cur price {} ", (Object)maxQueryVersion, (Object)priceVersion);
                    }
                } else {
                    String curVersionStr = this.getPageIdCacheValue(cacheId);
                    String maxQueryVersionStr = this.getPageIdCacheValue(MAX_QUERY);
                    if (!StringUtils.isEmpty((CharSequence)curVersionStr) && !StringUtils.isEmpty((CharSequence)maxQueryVersionStr) && Integer.parseInt(curVersionStr) >= Integer.parseInt(maxQueryVersionStr)) {
                        DataSet gatherDataset = Algo.getCacheDataSet((String)cacheId).toDataSet(Algo.create((String)((Object)((Object)this)).getClass().getName()), true);
                        DynamicObject costAccount = this.getModel().getDataEntity().getDynamicObject(this.COSTACCOUNT);
                        boolean isCostRecordDetail = ParamsHelper.getCostElementByCostAccount((long)costAccount.getLong("id"));
                        this.getModel().beginInit();
                        this.loadRowData(gatherDataset, isCostRecordDetail);
                        this.getModel().endInit();
                        this.setCloumnVisible(isCostRecordDetail);
                        this.getView().updateView("entryentity");
                        String wetherchange = this.getPageCache().get("wetherchange");
                        if (!StringUtils.isEmpty((CharSequence)wetherchange)) {
                            this.getView().getModel().setDataChanged(Boolean.parseBoolean(wetherchange));
                        }
                        this.putPageIdCacheValue(UNIQUE_QUERY, curVersionStr);
                    } else {
                        logger.info("\u5165\u5e93\u6c47\u603b\u6838\u7b97\u67e5\u8be2 curVersionStr {} , maxQueryVersionStr {}", (Object)curVersionStr, (Object)maxQueryVersionStr);
                    }
                }
            }
            catch (KDBizException e) {
                throw e;
            }
            catch (Throwable e) {
                this.getView().showErrorNotification(ExceptionUtils.getExceptionStackTraceMessage((Exception)new Exception(e)));
            }
            finally {
                this.getPageCache().remove("cacheId");
                progressEvent.setProgress(100);
                this.getPageCache().put(PROGRESS_KEY, "100");
            }
        }
    }

    private void setCloumnEnable(boolean isCostRecordDetail) {
        DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
        int row = entity.size();
        DynamicObjectCollection costSubElements = this.getModel().getDataEntity().getDynamicObjectCollection(this.COSTSUBELEMENT);
        for (int i = 0; i < row; ++i) {
            BigDecimal qty = ((DynamicObject)entity.get(i)).getBigDecimal(this.BASEQTY);
            if (qty.compareTo(BigDecimal.ZERO) == 0) continue;
            if (isCostRecordDetail) {
                HashSet<String> subEleNumSet = new HashSet<String>(costSubElements.size());
                for (DynamicObject costSubElement : costSubElements) {
                    DynamicObject info = costSubElement.getDynamicObject("fbasedataid");
                    String subEleNum = info.getString("number");
                    subEleNumSet.add(subEleNum + "_cost");
                }
                this.getView().setEnable(Boolean.FALSE, i, subEleNumSet.toArray(new String[0]));
                continue;
            }
            this.getView().setEnable(Boolean.FALSE, i, new String[]{this.PROCESSCOST, this.MATERIALCOST});
        }
    }

    private Map<String, String> getPageIdAppCache() {
        String pageId;
        IAppCache appCache = AppCache.get((String)"cal");
        Map keyValueMap = (Map)appCache.get(pageId = this.getView().getPageId(), Map.class);
        keyValueMap = keyValueMap == null ? new HashMap(16) : keyValueMap;
        return keyValueMap;
    }

    private String getPageIdCacheValue(String key) {
        Map<String, String> pageIdAppCache = this.getPageIdAppCache();
        String value = pageIdAppCache.get(key);
        return value;
    }

    private void putPageIdCacheValue(String key, String value) {
        String pageId = this.getView().getPageId();
        try (DLock dlock = DLock.create((String)pageId, (String)(((Object)((Object)this)).getClass().getName() + "CalInCost-lock-"));){
            dlock.lock();
            Map<String, String> keyValueMap = this.getPageIdAppCache();
            keyValueMap.put(key, value);
            IAppCache appCache = AppCache.get((String)"cal");
            appCache.put(pageId, keyValueMap);
        }
    }

    private void clearPageIdCacheValue() {
        String pageId = this.getView().getPageId();
        IAppCache appCache = AppCache.get((String)"cal");
        appCache.remove(pageId);
    }

    private void viewLog() {
        String taskIdsStr = this.getPageCache().get("taskIds");
        if (StringUtils.isNotEmpty((CharSequence)taskIdsStr)) {
            List taskIds = (List)SerializationUtils.fromJsonString((String)taskIdsStr, ArrayList.class);
            LinkQueryPkIdCollection linkQueryPkIdCollection = new LinkQueryPkIdCollection();
            for (String taskId : taskIds) {
                linkQueryPkIdCollection.addLinkQueryPkId((Object)taskId);
            }
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            showParameter.setBillFormId("sch_task");
            showParameter.setAppId("cal");
            showParameter.setLinkQueryPkIdCollection(linkQueryPkIdCollection);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6682\u65e0\u8fdb\u5ea6", (String)"ExpBillCostPlugin_38", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkRequireIsNull() {
        DynamicObject calorg = this.getModel().getDataEntity().getDynamicObject(this.CALORG);
        if (calorg == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CalculateInCostTask_23", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        DynamicObject info = this.getModel().getDataEntity().getDynamicObject(this.COSTACCOUNT);
        if (info == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CalculateInCostTask_14", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        String biztypes = this.getModel().getDataEntity().getString(this.BIZTYPE);
        if (StringUtils.isEmpty((CharSequence)biztypes)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u5355\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"CalculateInCostTask_15", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection mulbilltype = this.getModel().getDataEntity().getDynamicObjectCollection(this.BILLTYPE);
        if (mulbilltype.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"CalculateInCostTask_16", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        int year = this.getModel().getDataEntity().getInt(this.YEAR);
        if (year == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f1a\u8ba1\u5e74\u5ea6\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"CalculateInCostTask_19", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        int periodNum = this.getModel().getDataEntity().getInt(this.PERIOD_NUM);
        if (periodNum == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f1a\u8ba1\u671f\u95f4\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"CalculateInCostTask_20", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        boolean isCostRecordDetail = ParamsHelper.getCostElementByCostAccount((long)info.getLong("id"));
        DynamicObjectCollection costSubElements = this.getModel().getDataEntity().getDynamicObjectCollection(this.COSTSUBELEMENT);
        if (isCostRecordDetail && costSubElements.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4", (String)"CalculateInCostPlugin_52", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }

    private List<Set<Long>> getBatchIdList(Set<Long> ids) {
        ArrayList<Set<Long>> balIdsArray = new ArrayList<Set<Long>>(16);
        HashSet<Long> balIds = null;
        long index = 0L;
        for (Long id : ids) {
            if (index % 100000L == 0L) {
                balIds = new HashSet<Long>();
                balIdsArray.add(balIds);
            }
            if (balIds != null) {
                balIds.add(id);
            }
            ++index;
        }
        return balIdsArray;
    }
}

