/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.calculate.in;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.config.client.util.JSONUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.business.balance.BalanceCalculator;
import kd.fi.cal.business.balance.BalanceOpInvoker;
import kd.fi.cal.business.balance.BalanceSourceEnum;
import kd.fi.cal.business.fallprice.DealCalRangeFunction;
import kd.fi.cal.business.process.impl.EstimateAdjustInPurValidator;
import kd.fi.cal.common.enums.CostPriceSourceTypeEnum;
import kd.fi.cal.common.enums.SumTypeEnum;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalCustomEventCallHelper;
import kd.fi.cal.common.helper.CalDLockHelper;
import kd.fi.cal.common.helper.ChildBillCostUpdateHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.CostRecordQFilterHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.model.CalculateInParams;
import kd.fi.cal.common.model.CostSubElementInfo;
import kd.fi.cal.common.model.InputCalDetailRowInfo;
import kd.fi.cal.common.util.ArrayUtils;
import kd.fi.cal.common.util.CommonUtils;

public class CalculateInCostTask
extends AbstractTask {
    private long costAccountId;
    private DynamicObject costAccount;
    private String sumType;
    private Map<String, String> cacheMap = new HashMap<String, String>();
    private String DLOCK_KEY = "fi-cal-calculateincost";
    private String commonLockAccount = this.DLOCK_KEY + "_com_";
    private List<String> extendFields = new ArrayList<String>(16);
    private static final Log logger = LogFactory.getLog(CalculateInCostTask.class);
    private List<Object> matIds;
    private String curOpPageIdTimeKey;
    private Integer pageIndex;
    private String batchStr = "";
    private boolean isCostRecordDetail;
    private final String runningPageId_Key = "runningpageid";
    private static final int BATCH_SIZE = 100000;
    private static final String GATHERKEY = "GATHERKEY";
    private String[] FIX_COL = new String[]{"material", "baseunit"};
    private static String CALRANGE = "calrange";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(RequestContext paramRequestContext, Map<String, Object> paramMap) throws KDException {
        long starttime = TimeServiceHelper.now().getTime();
        this.costAccountId = (Long)paramMap.get("COSTACCOUNT");
        Date startBookDate = new Date((Long)paramMap.get("STARTTIME"));
        Date endBookDate = new Date((Long)paramMap.get("ENDTIME"));
        this.costAccount = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"id,calorg,costtype,name,number", (QFilter[])new QFilter("id", "=", (Object)this.costAccountId).toArray());
        this.sumType = (String)paramMap.get("SUMTYPE");
        this.matIds = (List)paramMap.get("MATIDS");
        this.curOpPageIdTimeKey = (String)paramMap.get("CUROPPAGEIDTIMEKEY");
        this.pageIndex = (Integer)paramMap.get("PAGEINDEX");
        this.batchStr = (String)paramMap.get("BATCHSTR");
        int curYearMonth = paramMap.get("PAGE_YEARMONTH") == null ? 0 : (Integer)paramMap.get("PAGE_YEARMONTH");
        this.isCostRecordDetail = ParamsHelper.getCostElementByCostAccount((long)this.costAccountId);
        this.commonLockAccount = this.DLOCK_KEY + this.costAccountId;
        this.getPageCache().put("AMT_PRECISION", (String)paramMap.get("AMT_PRECISION"));
        MessageInfo msgInfo = new MessageInfo();
        ArrayList<Long> userList = new ArrayList<Long>();
        userList.add(Long.valueOf(RequestContext.get().getUserId()));
        msgInfo.setUserIds(userList);
        msgInfo.setNotifyType(MessageChannels.MC.getNumber());
        String costAccountName = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u3010%1$s\u3011", (String)"CalculateInCostTask_11", (String)"fi-cal-formplugin", (Object[])new Object[0]), this.costAccount.getString("name"));
        String content = String.format(ResManager.loadKDString((String)"%1$s\u5165\u5e93\u6c47\u603b\u6838\u7b97\u8ba1\u7b97\u6210\u529f\u3002", (String)"CalculateInCostTask_12", (String)"fi-cal-formplugin", (Object[])new Object[0]), costAccountName);
        msgInfo.setContent(content);
        String bizTag = ResManager.loadKDString((String)"\u5165\u5e93\u6c47\u603b\u6838\u7b97", (String)"CalculateInCostTask_3", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        msgInfo.setTitle(bizTag + "-" + this.batchStr);
        msgInfo.setMessageTag((ILocaleString)new LocaleString(bizTag));
        IAppCache appCache = AppCache.get((String)"cal");
        String runningPageIdAccountKey = "runningpageid" + this.costAccountId;
        try (DLock lock = DLock.create((String)this.commonLockAccount, (String)"fi-cal-calculateincost-dlock");){
            Set otherOpPages;
            lock.lock();
            String otherRunningOpPageIdTimeKey = (String)appCache.get(runningPageIdAccountKey, String.class);
            if (StringUtils.isNotEmpty((CharSequence)otherRunningOpPageIdTimeKey) && !otherRunningOpPageIdTimeKey.equals(this.curOpPageIdTimeKey) && (otherOpPages = (Set)appCache.get(otherRunningOpPageIdTimeKey, Set.class)) != null) {
                for (Object otherPageIndex : otherOpPages) {
                    DLock pageIndexLock = DLock.create((String)(this.commonLockAccount + otherPageIndex), (String)"fi-cal-calculateincost-dlock-batch");
                    Throwable throwable = null;
                    try {
                        if (pageIndexLock.tryLock()) continue;
                        String msgStr = String.format(ResManager.loadKDString((String)"%1$s\u6b63\u5728\u5165\u5e93\u6c47\u603b\u6838\u7b97\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"CalculateInCostTask_13", (String)"fi-cal-formplugin", (Object[])new Object[0]), costAccountName);
                        msgInfo.setContent(msgStr);
                        MessageCenterServiceHelper.sendMessage((MessageInfo)msgInfo);
                        throw new KDBizException(msgStr);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (pageIndexLock == null) continue;
                        if (throwable != null) {
                            try {
                                pageIndexLock.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        pageIndexLock.close();
                    }
                }
            }
            appCache.put(runningPageIdAccountKey, (Object)this.curOpPageIdTimeKey);
            HashSet<Integer> curOpPages = (HashSet<Integer>)appCache.get(this.curOpPageIdTimeKey, Set.class);
            if (curOpPages == null || curOpPages.isEmpty()) {
                curOpPages = new HashSet<Integer>(16);
                curOpPages.add(this.pageIndex);
                appCache.put(this.curOpPageIdTimeKey, curOpPages);
            }
        }
        try {
            lock = DLock.create((String)(this.commonLockAccount + this.pageIndex), (String)"fi-cal-calculateincost-dlock-batch");
            var16_18 = null;
            try {
                boolean isLockSuccess = lock.tryLock();
                if (!isLockSuccess) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u6b63\u5728\u5165\u5e93\u6c47\u603b\u6838\u7b97\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"CalculateInCostTask_13", (String)"fi-cal-formplugin", (Object[])new Object[0]), costAccountName));
                }
                List paramStrList = (List)SerializationUtils.fromJsonString((String)((String)paramMap.get("PARAMLIST")), ArrayList.class);
                ArrayList<CalculateInParams> paramList = new ArrayList<CalculateInParams>(32);
                for (String param : paramStrList) {
                    paramList.add((CalculateInParams)JSONUtils.cast((String)param, CalculateInParams.class));
                }
                String str = (String)paramMap.get("QFILTER");
                if (null != str) {
                    QFilter filter = QFilter.fromSerializedString((String)str);
                    logger.info("buildDetailData\u5f00\u59cb\u524d\u8017\u65f6\uff1a" + (TimeServiceHelper.now().getTime() - starttime));
                    try (DataSet detailDataset = this.buildDetailDataNew(filter);){
                        DataSet cur = detailDataset;
                        if (curYearMonth > 0) {
                            EstimateAdjustInPurValidator validator = new EstimateAdjustInPurValidator();
                            cur = validator.filterQueryData(detailDataset, curYearMonth);
                        }
                        this.cacheDetailDataSet(cur, startBookDate, endBookDate);
                    }
                }
                String ominTypeStr = (String)paramMap.get("ISOMINBILLTYPE");
                boolean isOminBillType = Boolean.parseBoolean(ominTypeStr);
                this.calculate(paramList, startBookDate, endBookDate, isOminBillType);
                return;
            }
            catch (Throwable isLockSuccess) {
                var16_18 = isLockSuccess;
                throw isLockSuccess;
            }
            finally {
                if (lock != null) {
                    if (var16_18 != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable isLockSuccess) {
                            var16_18.addSuppressed(isLockSuccess);
                        }
                    } else {
                        lock.close();
                    }
                }
            }
        }
        catch (IOException e) {
            msgInfo.setContent(costAccountName + " : " + e.getMessage());
            throw new KDBizException(e.getMessage());
        }
        catch (KDBizException e) {
            msgInfo.setContent(costAccountName + " : " + CommonUtils.getLogMessage((Throwable)e));
            throw e;
        }
        catch (Exception e) {
            msgInfo.setContent(costAccountName + " : " + CommonUtils.getLogMessage((Throwable)e));
            throw e;
        }
        finally {
            block84: {
                try (DLock lock = DLock.create((String)this.commonLockAccount, (String)"fi-cal-calculateincost-dlock");){
                    lock.lock();
                    Set curOpPages = (Set)appCache.get(this.curOpPageIdTimeKey, Set.class);
                    if (curOpPages == null) break block84;
                    curOpPages.remove(this.pageIndex);
                    if (curOpPages.size() > 0) {
                        appCache.put(this.curOpPageIdTimeKey, (Object)curOpPages);
                    } else {
                        appCache.remove(this.curOpPageIdTimeKey);
                    }
                }
            }
            logger.info("\u5165\u5e93\u6c47\u603b\u6838\u7b97\u6700\u7ec8\u4fe1\u606f\uff1a" + msgInfo.getContent());
            MessageCenterServiceHelper.sendMessage((MessageInfo)msgInfo);
        }
    }

    /*
     * WARNING - void declaration
     */
    private DataSet buildDetailDataNew(QFilter filters) {
        void var12_20;
        Set<Long> entryIdSet = this.getEntryidSet(filters);
        boolean isGroup = false;
        HashSet<String> totalGroupSet = new HashSet<String>();
        this.sumType = StringUtils.isEmpty((CharSequence)this.sumType) ? "" : this.sumType;
        String[] split = this.sumType.split(",");
        HashSet<String> specialChosen = new HashSet<String>();
        for (String s : split) {
            if (StringUtils.isEmpty((CharSequence)s)) continue;
            if ("cal_group".equals(s)) {
                isGroup = true;
                continue;
            }
            if ("cal_material".equals(s)) continue;
            specialChosen.add(s);
        }
        if (!isGroup) {
            specialChosen.clear();
        }
        for (String s : split) {
            if (StringUtils.isEmpty((CharSequence)s)) continue;
            if ("cal_group".equals(s)) {
                String[] divAndDimensionCols = this.getDivAndDimensionCols(this.costAccountId);
                totalGroupSet.addAll(new ArrayList<String>(Arrays.asList(divAndDimensionCols)));
            }
            if ("cal_material".equals(s)) {
                totalGroupSet.addAll(new ArrayList<String>(Arrays.asList(this.FIX_COL)));
            }
            totalGroupSet.add(s);
        }
        if (!totalGroupSet.isEmpty()) {
            this.removeUnnecessary(totalGroupSet);
            if (isGroup) {
                totalGroupSet.add(CALRANGE);
            }
            totalGroupSet.remove("cal_group");
            totalGroupSet.remove("cal_material");
        }
        StringBuilder fields = new StringBuilder();
        fields.append("id,billno,calbillid,bizbillid,");
        fields.append("calbilltype,");
        fields.append("billtype.number,");
        fields.append("bizentityobject,");
        fields.append("entry.id,entry.calentryid,entry.bizbillentryid,");
        fields.append("costaccount,costaccount.id,costaccount.name,costaccount.calsystem.id,costaccount.calsystem.name,costaccount.calpolicy.id,costaccount.calpolicy.name,");
        fields.append("adminorg,costcenterorg,calorg,calorg.id,calorg.name,storageorgunit,storageorgunit.id,storageorgunit.name,storageorgunit.number as storageorgunitnumber,");
        fields.append("entry.ownertype as ownertype,entry.owner as owner,entry.owner.id as ownerid,entry.warehouse as warehouse,entry.warehouse.id,entry.warehouse.name,entry.warehouse.number as warehousenumber,entry.location as location,entry.location.id,entry.location.name,entry.location.number as locationnumber,");
        fields.append("entry.material as material,entry.material.id,entry.material.name,entry.material.number as materialnumber,entry.material.modelnum as model,");
        fields.append("entry.lot as lot,entry.project as project,entry.project.number as projectnumber,entry.baseunit as baseunit,entry.baseunit.id,entry.baseunit.name,entry.baseunit.number as baseunitnumber,entry.baseqty,entry.unitactualcost,entry.actualcost,");
        fields.append("entry.materialcost,entry.fee,entry.unitprocesscost,entry.processcost,entry.manufacturecost,entry.resource,entry.assist as assist,entry.tracknumber as tracknumber,entry.calrange as calrange");
        fields.append(",costaccount.dividebasis as dividebasisid,costaccount.dividebasis.dividebasis as dividebasis,entry.caldimension as caldimensionid,entry.caldimension.caldimension as caldimension,entry.configuredcode as configuredcode,entry.ecostcenter as ecostcenter");
        MainEntityType costRecordEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costrecord");
        for (String allField : totalGroupSet) {
            if (fields.indexOf(allField) != -1) continue;
            IDataEntityProperty property = costRecordEntityType.findProperty(allField);
            if (!(property.getParent() instanceof EntryType)) {
                fields.append(",").append(allField).append(" as ").append(allField);
            } else {
                fields.append(",entry.").append(allField).append(" as ").append(allField);
            }
            this.extendFields.add(allField);
        }
        this.getPageCache().put("setVisibleFields", SerializationUtils.toJsonString(this.extendFields));
        List<Set<Long>> batchList = this.getBatchIdList(entryIdSet);
        ArrayList<OrmInput> billIOs = new ArrayList<OrmInput>(16);
        if (batchList != null && batchList.size() > 0) {
            for (Set set : batchList) {
                QFilter entryIdf = new QFilter("entry.id", "in", (Object)set);
                OrmInput billIO = new OrmInput(((Object)((Object)this)).getClass() + "loadDataByFilter", "cal_costrecord", fields.toString(), new QFilter[]{entryIdf});
                billIOs.add(billIO);
            }
        } else {
            QFilter entryIdf = QFilter.of((String)"1 <> 1", (Object[])new Object[0]);
            OrmInput ormInput = new OrmInput(((Object)((Object)this)).getClass() + "loadDataByFilter", "cal_costrecord", fields.toString(), new QFilter[]{entryIdf});
            billIOs.add(ormInput);
        }
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSet dataSet = algo.createDataSet((Input[])billIOs.toArray(new OrmInput[billIOs.size()]));
        String[] omBitype = CostRecordQFilterHelper.getBiztype((String)"ominbiztype");
        StringBuilder ominFilterStr = new StringBuilder("bizentityobject not in ('");
        for (int i = 0; i < omBitype.length; ++i) {
            ominFilterStr.append(omBitype[i]);
            if (i == omBitype.length - 1) {
                ominFilterStr.append("')");
                break;
            }
            ominFilterStr.append("','");
        }
        DataSet dataSet2 = dataSet.filter(ominFilterStr.toString());
        if (isGroup) {
            DataSet dataSet3 = this.calGroupSolveEmptyRange(dataSet2, specialChosen);
        }
        TreeSet<String> orderExt = new TreeSet<String>(this.extendFields);
        this.extendFields = new ArrayList<String>(orderExt);
        this.getPageCache().put("extendFields", SerializationUtils.toJsonString(this.extendFields));
        String concatStr = this.getConcatStr();
        DataSet detalDataSet = var12_20.addField("concat(" + concatStr + ")", GATHERKEY);
        return detalDataSet;
    }

    private DataSet calGroupSolveEmptyRange(DataSet detailDataSet, Set<String> specialChosen) {
        DynamicObject accountDyc = BusinessDataServiceHelper.loadSingleFromCache((Object)this.costAccountId, (String)"cal_bd_costaccount");
        String divStr = accountDyc.getString("dividebasis.dividebasis");
        String calDimensionStr = CommonSettingHelper.getCalDimensionStr();
        Set<Long> emptyEntryRangeIds = this.getEmptyEntryRangeIds(this.costAccountId);
        DealCalRangeFunction function = new DealCalRangeFunction(emptyEntryRangeIds, divStr, calDimensionStr, detailDataSet.getRowMeta());
        function.setExclusion(specialChosen);
        function.setBakDivDimField(false);
        function.setCalDimensionStrKey("caldimension");
        detailDataSet = detailDataSet.map((MapFunction)function);
        return detailDataSet;
    }

    private Set<Long> getEmptyEntryRangeIds(Long costAccount) {
        QFilter filter = new QFilter("costaccount", "=", (Object)costAccount);
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        HashSet<Long> emptyEntryRangeIds = new HashSet<Long>(16);
        Map calRangeMap = BusinessDataServiceHelper.loadFromCache((String)"cal_bd_calrange", (QFilter[])filter.toArray());
        for (DynamicObject rangDyc : calRangeMap.values()) {
            DynamicObjectCollection entryDycs = rangDyc.getDynamicObjectCollection("entry");
            if (!entryDycs.isEmpty()) continue;
            emptyEntryRangeIds.add(rangDyc.getLong("id"));
        }
        return emptyEntryRangeIds;
    }

    private void removeUnnecessary(Collection<String> allCols) {
        if (allCols.isEmpty()) {
            return;
        }
        allCols.remove("calrange");
        allCols.remove("caldimension");
    }

    private String[] getDivAndDimensionCols(Long costAccountId) {
        DynamicObject accountDyc = BusinessDataServiceHelper.loadSingleFromCache((Object)costAccountId, (String)"cal_bd_costaccount");
        String divStr = accountDyc.getString("dividebasis.dividebasis");
        String calDimensionStr = CommonSettingHelper.getCalDimensionStr();
        return (String[])ArrayUtils.concatAll((Object[])this.getDivRangeDims(divStr, calDimensionStr), (Object[][])new String[][]{{"material"}});
    }

    private String[] getDivRangeDims(String divStr, String calDimensionStr) {
        String[] divFields = divStr.split(",");
        Object[] bakDivFields = divStr.split(",");
        String[] calDims = calDimensionStr.split(",");
        String[] bakCalDims = calDimensionStr.split(",");
        System.arraycopy(divFields, 0, bakDivFields, 0, divFields.length);
        System.arraycopy(calDims, 0, bakCalDims, 0, calDims.length);
        String[] divRangeDims = (String[])ArrayUtils.concatAll((Object[])bakDivFields, (Object[][])new String[][]{{"calrange"}, bakCalDims});
        return divRangeDims;
    }

    /*
     * WARNING - void declaration
     */
    private DataSet buildDetailData(QFilter filters) {
        void var14_18;
        Set<Long> entryIdSet = this.getEntryidSet(filters);
        long starttime = TimeServiceHelper.now().getTime();
        String[] allDivideBasis = CommonSettingHelper.getDivideBasis();
        String[] allCalDimension = CommonSettingHelper.getCalDimension();
        Set exFieldSet = CommonSettingHelper.getExFieldSet();
        HashSet<String> allFields = new HashSet<String>(16);
        allFields.addAll(Arrays.asList(allDivideBasis));
        allFields.addAll(Arrays.asList(allCalDimension));
        allFields.addAll(exFieldSet);
        StringBuilder fields = new StringBuilder();
        fields.append("id,billno,calbillid,bizbillid,");
        fields.append("calbilltype,");
        fields.append("bizentityobject,");
        fields.append("entry.id,entry.calentryid,entry.bizbillentryid,");
        fields.append("costaccount.id,costaccount.name,costaccount.calsystem.id,costaccount.calsystem.name,costaccount.calpolicy.id,costaccount.calpolicy.name,");
        fields.append("calorg.id,calorg.name,storageorgunit.id,storageorgunit.name,storageorgunit.number as storageorgunitnumber,");
        fields.append("entry.owner.id as ownerid,entry.warehouse.id,entry.warehouse.name,entry.warehouse.number as warehousenumber,entry.location.id,entry.location.name,entry.location.number as locationnumber,");
        fields.append("entry.material.id,entry.material.name,entry.material.number as materialnumber,entry.material.modelnum,");
        fields.append("entry.lot as lot,entry.project.number as projectnumber,entry.baseunit.id,entry.baseunit.name,entry.baseunit.number as baseunitnumber,entry.baseqty,entry.unitactualcost,entry.actualcost,");
        fields.append("entry.fee,entry.processcost,entry.manufacturecost,entry.resource");
        fields.append(",costaccount.dividebasis as dividebasisid,costaccount.dividebasis.dividebasis as dividebasis,entry.caldimension as caldimensionid,entry.caldimension.caldimension as caldimension");
        MainEntityType costRecordEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costrecord");
        for (String allField : allFields) {
            if (fields.indexOf(allField) != -1 || "assist".equals(allField)) continue;
            IDataEntityProperty property = costRecordEntityType.findProperty(allField);
            if (!(property.getParent() instanceof EntryType)) {
                fields.append(",").append(allField).append(" as ").append(allField);
            } else {
                fields.append(",entry.").append(allField).append(" as ").append(allField);
            }
            this.extendFields.add(allField);
        }
        List<Set<Long>> batchList = this.getBatchIdList(entryIdSet);
        ArrayList<OrmInput> billIOs = new ArrayList<OrmInput>(16);
        if (batchList != null && batchList.size() > 0) {
            for (Set set : batchList) {
                QFilter entryIdf = new QFilter("entry.id", "in", (Object)set);
                OrmInput billIO = new OrmInput(((Object)((Object)this)).getClass() + "loadDataByFilter", "cal_costrecord", fields.toString(), new QFilter[]{entryIdf});
                billIOs.add(billIO);
            }
        } else {
            QFilter entryIdf = QFilter.of((String)"1 <> 1", (Object[])new Object[0]);
            OrmInput ormInput = new OrmInput(((Object)((Object)this)).getClass() + "loadDataByFilter", "cal_costrecord", fields.toString(), new QFilter[]{entryIdf});
            billIOs.add(ormInput);
        }
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSet dataSet = algo.createDataSet((Input[])billIOs.toArray(new OrmInput[billIOs.size()]));
        if (SumTypeEnum.HUAFENYIJU.getValue().equals(this.sumType)) {
            DataSet rs1 = null;
            DataSet rsCopy = dataSet.copy().groupBy(new String[]{"dividebasisid", "dividebasis", "caldimensionid", "caldimension"}).finish();
            int i = 0;
            for (Row row : rsCopy) {
                DataSet rsCopy1 = dataSet.copy();
                String divideBasisId = row.getString("dividebasisid");
                String caldimensionId = row.getString("caldimensionid");
                String divideBasis = row.getString("dividebasis");
                String calDimension = row.getString("caldimension");
                DataSet filterCopy = rsCopy1.filter("dividebasisid = " + divideBasisId + " and caldimensionid = " + caldimensionId);
                String totalKey = CommonUtils.trimComma((String)divideBasis);
                if (!kd.bos.util.StringUtils.isEmpty((String)calDimension)) {
                    totalKey = totalKey + "," + CommonUtils.trimComma((String)calDimension);
                }
                fields.setLength(0);
                fields.append("id,billno,calbillid,bizbillid,");
                fields.append("entry.id,entry.calentryid,entry.bizbillentryid,");
                fields.append("costaccount.id,costaccount.name,costaccount.calsystem.id,costaccount.calsystem.name,costaccount.calpolicy.id,costaccount.calpolicy.name,");
                fields.append("calorg.id,calorg.name,");
                fields.append("calbilltype,");
                fields.append("bizentityobject,");
                ArrayList<String> defaultKey = new ArrayList<String>(16);
                defaultKey.add("calorg");
                defaultKey.add("storageorgunit");
                defaultKey.add("owner");
                defaultKey.add("warehouse");
                defaultKey.add("location");
                defaultKey.add("lot");
                defaultKey.add("projectnumber");
                if (this.hasField(totalKey, "storageorgunit")) {
                    fields.append("storageorgunit.id,storageorgunit.name,storageorgunitnumber,");
                } else {
                    fields.append("0L as storageorgunit.id,'' as storageorgunit.name,'' as storageorgunitnumber,");
                }
                if (this.hasField(totalKey, "owner")) {
                    fields.append("ownerid,");
                } else {
                    fields.append("0L as ownerid,");
                }
                if (this.hasField(totalKey, "warehouse")) {
                    fields.append("entry.warehouse.id,entry.warehouse.name,warehousenumber,");
                } else {
                    fields.append("0L as entry.warehouse.id,'' as entry.warehouse.name,'' as warehousenumber,");
                }
                if (this.hasField(totalKey, "location")) {
                    fields.append("entry.location.id,entry.location.name,locationnumber,");
                } else {
                    fields.append("0L as entry.location.id,'' as entry.location.name,'' as locationnumber,");
                }
                if (this.hasField(totalKey, "lot")) {
                    fields.append("lot,");
                } else {
                    fields.append("'' as lot,");
                }
                if (this.hasField(totalKey, "project")) {
                    fields.append("projectnumber,");
                } else {
                    fields.append("'' as projectnumber,");
                }
                if (null != totalKey && !"".equals(totalKey)) {
                    if (!this.extendFields.isEmpty()) {
                        this.extendFields.clear();
                    }
                    String[] split = totalKey.split(",");
                    MainEntityType calCulateEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_in_calculate");
                    for (String key : split) {
                        if (defaultKey.contains(key) || null == calCulateEntityType.findProperty(key)) continue;
                        fields.append(key).append(",");
                        this.extendFields.add(key);
                    }
                }
                fields.append("entry.material.id,entry.material.name,materialnumber,entry.material.modelnum,");
                fields.append("entry.baseunit.id,entry.baseunit.name,baseunitnumber,entry.baseqty,entry.unitactualcost,entry.actualcost,");
                fields.append("entry.fee,entry.processcost,entry.manufacturecost,entry.resource");
                filterCopy = filterCopy.select(fields.toString());
                rs1 = i == 0 ? filterCopy : (rs1 != null ? rs1.union(filterCopy) : filterCopy);
                ++i;
            }
            if (rs1 != null) {
                DataSet dataSet2 = rs1;
            }
        }
        String concatStr = this.getConcatStr();
        DataSet detalDataSet = var14_18.addField("concat(" + concatStr + ")", GATHERKEY);
        logger.info("buildDetailData\u8017\u65f6\uff1a" + (TimeServiceHelper.now().getTime() - starttime));
        return detalDataSet;
    }

    private Set<Long> getEntryidSet(QFilter filters) {
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        filters.and(billStatusf);
        HashSet<Long> entryidSet1 = new HashSet<Long>(16);
        DataSet idSet1DataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "loadDataByFilter"), (String)"cal_costrecord", (String)"id,entry.id", (QFilter[])new QFilter[]{filters}, (String)"");
        for (Row row : idSet1DataSet) {
            Long entryid = row.getLong("entry.id");
            entryidSet1.add(entryid);
        }
        if (!entryidSet1.isEmpty()) {
            QFilter q = new QFilter("entry.ancestorentryid", "in", entryidSet1);
            q.and("issplitcreate", "=", (Object)Character.valueOf('1'));
            q.and("writeoffstatus", "=", (Object)Character.valueOf('A'));
            q.and("writeofftype", "=", (Object)Character.valueOf('B'));
            q.and("ischargeoffed", "=", (Object)false);
            q.and("ischargeoff", "=", (Object)false);
            String[] purBitype = CostRecordQFilterHelper.getBiztype((String)"purbiztype");
            q.and("bizentityobject", "in", (Object)purBitype);
            DataSet idSet2DataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "loadDataByFilter"), (String)"cal_costrecord", (String)"id,entry.ancestorentryid", (QFilter[])new QFilter[]{q}, (String)"");
            HashSet<Long> entryidSet2 = new HashSet<Long>(16);
            for (Row row : idSet2DataSet) {
                Long ancestorentryid = row.getLong("entry.ancestorentryid");
                entryidSet2.add(ancestorentryid);
            }
            if (!entryidSet2.isEmpty()) {
                entryidSet1.removeAll(entryidSet2);
            }
        }
        return entryidSet1;
    }

    private String getConcatStr() {
        StringBuilder retValue = new StringBuilder();
        List gatherFields = this.getGatherFieldsNew();
        for (int i = 0; i < gatherFields.size(); ++i) {
            if (i != 0) {
                retValue.append(",'#',");
            }
            retValue.append("Cast(").append((String)gatherFields.get(i)).append(" as String)");
        }
        return retValue.toString();
    }

    private List getGatherFieldsNew() {
        this.sumType = StringUtils.isEmpty((CharSequence)this.sumType) ? "" : this.sumType;
        HashSet<String> gatherKeyList = new HashSet<String>();
        boolean isGroup = false;
        if (!StringUtils.isEmpty((CharSequence)this.sumType)) {
            String[] split;
            for (String col : split = this.sumType.split(",")) {
                if (StringUtils.isEmpty((CharSequence)col)) continue;
                if ("cal_group".equals(col)) {
                    String[] divAndDimensionCols = this.getDivAndDimensionCols(this.costAccountId);
                    gatherKeyList.addAll(new ArrayList<String>(Arrays.asList(divAndDimensionCols)));
                    isGroup = true;
                }
                if ("cal_material".equals(col)) {
                    gatherKeyList.addAll(new ArrayList<String>(Arrays.asList(this.FIX_COL)));
                }
                gatherKeyList.add(col);
            }
            if (!gatherKeyList.isEmpty()) {
                this.removeUnnecessary(gatherKeyList);
                if (isGroup) {
                    gatherKeyList.add(CALRANGE);
                }
                gatherKeyList.remove("cal_group");
                gatherKeyList.remove("cal_material");
                gatherKeyList.remove("ownertype");
            }
        }
        return new ArrayList(gatherKeyList);
    }

    private boolean hasField(String totalKey, String value) {
        return totalKey != null && totalKey.indexOf(value) >= 0;
    }

    private DataSet filterByChildVoucher(DataSet rs) {
        DataSet copyRs = rs.copy();
        HashSet<Long> entryIdSet = new HashSet<Long>();
        HashSet<Long> notinEntryIdSet = new HashSet<Long>();
        for (Row row : copyRs) {
            long entryId = row.getLong("entry.id");
            entryIdSet.add(entryId);
        }
        QFilter q = new QFilter("entry.id", "in", entryIdSet);
        q.and("bizentityobject", "=", (Object)"im_saloutbill");
        q.and("isvoucher", "=", (Object)Boolean.TRUE);
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        q.and(billStatusf);
        q.and(new QFilter("entry.material", "in", this.matIds));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"billno,entry.id", (QFilter[])new QFilter[]{q}, null);
        Object object = null;
        try {
            for (Row row : dataSet) {
                notinEntryIdSet.add(row.getLong("entry.id"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        if (notinEntryIdSet.isEmpty()) {
            return rs;
        }
        StringBuilder filter = new StringBuilder("entry.id not in (");
        object = notinEntryIdSet.iterator();
        while (object.hasNext()) {
            long entryId = (Long)object.next();
            filter.append(entryId).append(',');
        }
        return rs.filter(filter.substring(0, filter.length() - 1) + ')');
    }

    private void cacheDetailDataSet(DataSet detalDataSet, Date startBookDate, Date endBookDate) throws IOException {
        long starttime = TimeServiceHelper.now().getTime();
        HashMap<String, List> detailMap = new HashMap<String, List>();
        HashMap<String, String> blueMaxMap = new HashMap<String, String>();
        HashMap redMaxMap = new HashMap();
        InputCalDetailRowInfo info = null;
        HashSet<Long> bizBillEntryIdSet = new HashSet<Long>();
        HashSet<Long> materialIdSet = new HashSet<Long>();
        HashMap<Long, String> groupMap = new HashMap<Long, String>();
        DataSet detalDataSet1 = detalDataSet.copy();
        DataSet detalDataSet2 = detalDataSet.copy();
        HashSet<Long> bizEntryIdSet = new HashSet<Long>();
        for (Row row : detalDataSet1) {
            bizEntryIdSet.add(row.getLong("entry.bizbillentryid"));
        }
        QFilter q = new QFilter("costaccount", "=", (Object)this.costAccountId);
        q.and("bookdate", ">=", (Object)startBookDate);
        q.and("bookdate", "<=", (Object)endBookDate);
        q.and("issplitcreate", "=", (Object)Boolean.FALSE);
        q.and("entry.bizbillentryid", "in", bizEntryIdSet);
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        q.and(billStatusf);
        q.and(new QFilter("entry.material", "in", this.matIds));
        DataSet detalDataSet3 = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"billno,isvoucher,entry.id,entry.bizbillentryid,entry.material.id,entry.fee,entry.processcost,entry.actualcost,entry.baseqty,entry.manufacturecost,entry.resource,entry.unitprocesscost", (QFilter[])new QFilter[]{q}, null);
        DataSet dataSet = detalDataSet2.join(detalDataSet3).on("entry.bizbillentryid", "entry.bizbillentryid").select(new String[]{"entry.id as entryid"}, new String[]{"billno", "isvoucher", "entry.id as groupentryid", "entry.material.id", "entry.fee", "entry.processcost", "entry.actualcost", "entry.baseqty", "entry.manufacturecost", "entry.resource", "entry.unitprocesscost"}).finish();
        for (Row row : dataSet) {
            long entryId = row.getLong("entryid");
            long groupEntryId = row.getLong("groupentryid");
            if (groupEntryId == 0L || entryId == groupEntryId) continue;
            InputCalDetailRowInfo groupInfo = new InputCalDetailRowInfo();
            groupInfo.setMaterial(row.getLong("entry.material.id").longValue());
            groupInfo.setEntryID(String.valueOf(groupEntryId));
            groupInfo.setFee(row.getBigDecimal("entry.fee"));
            groupInfo.setUnitProcessCost(row.getBigDecimal("entry.unitprocesscost"));
            groupInfo.setProcessCost(row.getBigDecimal("entry.processcost"));
            groupInfo.setOldActualCost(row.getBigDecimal("entry.actualcost"));
            groupInfo.setManufactureCost(row.getBigDecimal("entry.manufacturecost"));
            groupInfo.setResource(row.getBigDecimal("entry.resource"));
            groupInfo.setBaseQty(row.getBigDecimal("entry.baseqty"));
            groupInfo.setVoucher(row.getBoolean("isvoucher").booleanValue());
            groupInfo.setBillNo(row.getString("billno"));
            groupMap.put(entryId, JSONUtils.toString((Object)groupInfo));
        }
        for (Row row : detalDataSet) {
            info = new InputCalDetailRowInfo();
            String gatherkey = row.getString(GATHERKEY);
            List list = this.getCalRecordList(detailMap, gatherkey);
            String entryID = row.getLong("entry.id").toString();
            BigDecimal rowBaseQty = row.getBigDecimal("entry.baseqty");
            info.setBaseQty(rowBaseQty);
            info.setEntryID(entryID);
            info.setBillNo(row.getString("billno"));
            info.setId(row.getLong("id").longValue());
            info.setFee(row.getBigDecimal("entry.fee"));
            info.setUnitProcessCost(row.getBigDecimal("entry.unitprocesscost"));
            info.setProcessCost(row.getBigDecimal("entry.processcost"));
            info.setResource(row.getBigDecimal("entry.resource"));
            info.setManufactureCost(row.getBigDecimal("entry.manufacturecost"));
            info.setOldActualCost(row.getBigDecimal("entry.actualcost"));
            info.setCostAccountId(row.getLong("costaccount.id").longValue());
            info.setBizEntryId(row.getLong("entry.bizbillentryid").longValue());
            info.setMaterial(row.getLong("entry.material.id").longValue());
            info.setBillTypeNum(row.getString("billtype.number"));
            bizBillEntryIdSet.add(row.getLong("entry.bizbillentryid"));
            materialIdSet.add(row.getLong("entry.material.id"));
            HashMap<String, String> tMap = blueMaxMap;
            if (rowBaseQty.compareTo(BigDecimal.ZERO) < 0) {
                tMap = redMaxMap;
            }
            String jsonStr = (String)tMap.get(gatherkey);
            InputCalDetailRowInfo maxInfo = null;
            maxInfo = jsonStr == null ? new InputCalDetailRowInfo() : (InputCalDetailRowInfo)JSONUtils.cast((String)jsonStr, InputCalDetailRowInfo.class);
            if (maxInfo.getBaseQty().abs().compareTo(rowBaseQty.abs()) < 0) {
                maxInfo.setBaseQty(rowBaseQty);
                maxInfo.setGatherID(gatherkey);
                maxInfo.setEntryID(entryID);
                maxInfo.setId(row.getLong("id").longValue());
                maxInfo.setFee(row.getBigDecimal("entry.fee"));
                maxInfo.setUnitProcessCost(row.getBigDecimal("entry.unitprocesscost"));
                maxInfo.setProcessCost(row.getBigDecimal("entry.processcost"));
                maxInfo.setResource(row.getBigDecimal("entry.resource"));
                maxInfo.setManufactureCost(row.getBigDecimal("entry.manufacturecost"));
                maxInfo.setOldActualCost(row.getBigDecimal("entry.actualcost"));
                maxInfo.setCostAccountId(row.getLong("costaccount.id").longValue());
                maxInfo.setBizEntryId(row.getLong("entry.bizbillentryid").longValue());
                maxInfo.setMaterial(row.getLong("entry.material.id").longValue());
            }
            tMap.put(gatherkey, JSONUtils.toString((Object)maxInfo));
            list.add(JSONUtils.toString((Object)info));
            detailMap.put(gatherkey, list);
        }
        this.getPageCache().put("DETAILDATAMAP", SerializationUtils.toJsonString(detailMap));
        this.getPageCache().put("BLUEMAXVALUEMAP", SerializationUtils.toJsonString(blueMaxMap));
        this.getPageCache().put("REDMAXVALUEMAP", SerializationUtils.toJsonString(redMaxMap));
        this.getPageCache().put("BIZBILLENTRYIDSET", SerializationUtils.toJsonString(bizBillEntryIdSet));
        this.getPageCache().put("MATERIALIDSET", SerializationUtils.toJsonString(materialIdSet));
        this.getPageCache().put("GROUPMAP", SerializationUtils.toJsonString(groupMap));
        logger.info("cacheDetailDataSet\u8017\u65f6\uff1a" + (TimeServiceHelper.now().getTime() - starttime));
    }

    private List getCalRecordList(Map<String, List> detailMap, String key) {
        ArrayList list = detailMap.get(key);
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private void calculate(List<CalculateInParams> paramsList, Date startBookDate, Date endBookDate, boolean isOminBillType) throws IOException {
        Serializable actualCost;
        Map detailMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("DETAILDATAMAP"), HashMap.class);
        Map groupMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("GROUPMAP"), HashMap.class);
        Long[] defaultElementIds = CostElementHelper.getDefaultMaterialElements();
        Long defaultMetriaElemnet = defaultElementIds[0];
        Map<String, Object> costDetaiLDataMap = this.buildCostDetailMap();
        Map cosTypeMaterialMap = (Map)costDetaiLDataMap.get("cosTypeMaterialMap");
        long costTypeId = this.getCostTypeId();
        int size = paramsList.size();
        StringBuilder msg = new StringBuilder();
        int amtPrecision = Integer.parseInt(this.getPageCache().get("AMT_PRECISION"));
        int pricePrecision = 10;
        ArrayList<Object[]> costDetailList = new ArrayList<Object[]>();
        HashSet<Long> entryIdSet = new HashSet<Long>();
        HashSet<Long> idSet = new HashSet<Long>();
        ArrayList<Object[]> recordParams = new ArrayList<Object[]>();
        HashMap<String, InputCalDetailRowInfo> groupEntryInfoMap = new HashMap<String, InputCalDetailRowInfo>();
        for (int i = 0; i < size; ++i) {
            void var33_55;
            void var33_53;
            List calRecordList;
            CalculateInParams param = paramsList.get(i);
            String gid = param.getGatherID();
            BigDecimal unitMatCost = param.getUnitMaterialCost();
            BigDecimal unitProCost = param.getUnitProcessCost();
            List subElementInfoList = param.getSubElementInfoList();
            BigDecimal calBaseQty = param.getBaseqty();
            actualCost = param.getActualCost();
            BigDecimal unitActualCost = param.getUnitActualCost();
            if (calBaseQty.compareTo(BigDecimal.ZERO) == 0 && unitActualCost.compareTo(BigDecimal.ZERO) == 0 && ((BigDecimal)actualCost).compareTo(BigDecimal.ZERO) != 0) continue;
            if (unitMatCost.compareTo(BigDecimal.ZERO) < 0 || unitProCost.compareTo(BigDecimal.ZERO) < 0) {
                String msgStr = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5355\u4f4d\u5b9e\u9645\u6210\u672c\u5fc5\u987b\u5927\u4e8e0\uff0c\u8bf7\u4fdd\u8bc1\u6570\u91cf\u4e0e\u5b9e\u9645\u6210\u672c\u6b63\u8d1f\u65b9\u5411\u4e00\u81f4\u3002", (String)"CalculateInCostTask_5", (String)"fi-cal-formplugin", (Object[])new Object[0]), i + 1);
                msg.append(msgStr);
                continue;
            }
            if (subElementInfoList != null) {
                boolean isNegSubEleUnitCost = Boolean.FALSE;
                for (CostSubElementInfo costSubElementInfo : subElementInfoList) {
                    BigDecimal subEleUnitCost = costSubElementInfo.getUnitActualCost();
                    if (subEleUnitCost.compareTo(BigDecimal.ZERO) >= 0) continue;
                    isNegSubEleUnitCost = Boolean.TRUE;
                }
                if (isNegSubEleUnitCost) {
                    String msgStr = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u5b58\u5728\u5c0f\u4e8e\u96f6\u7684\u5b50\u8981\u7d20\u5355\u4f4d\u6210\u672c\uff0c\u8bf7\u68c0\u67e5\u5b50\u8981\u7d20\u5355\u4f4d\u6210\u672c\u503c\u662f\u5426\u8f93\u5165\u6b63\u786e\u3002", (String)"CalculateInCostTask_21", (String)"fi-cal-formplugin", (Object[])new Object[0]), i + 1);
                    msg.append(msgStr);
                    continue;
                }
            }
            if (null == (calRecordList = (List)detailMap.get(gid))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5df2\u5220\u9664\u6216\u975e\u5ba1\u6838\u72b6\u6001\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u540e\u91cd\u65b0\u66f4\u65b0\u3002", (String)"ExpBillCostTask_10", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
            BigDecimal tatalBaseQty = new BigDecimal("0");
            boolean bl = false;
            while (var33_53 < calRecordList.size()) {
                String jsonStr = calRecordList.get((int)var33_53).toString();
                InputCalDetailRowInfo info = (InputCalDetailRowInfo)JSONUtils.cast((String)jsonStr, InputCalDetailRowInfo.class);
                BigDecimal baseQty = info.getBaseQty();
                tatalBaseQty = tatalBaseQty.add(baseQty);
                ++var33_53;
            }
            if (tatalBaseQty.compareTo(calBaseQty) != 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5df2\u5220\u9664\u6216\u975e\u5ba1\u6838\u72b6\u6001\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u540e\u91cd\u65b0\u66f4\u65b0\u3002", (String)"ExpBillCostTask_10", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
            Object rowTotalMatAmt = BigDecimal.ZERO;
            BigDecimal bigDecimal = BigDecimal.ZERO;
            HashMap<String, Object[]> updateRecordParamMap = new HashMap<String, Object[]>(160);
            HashMap<String, Object[]> cacheParamMap = new HashMap<String, Object[]>(160);
            for (Object calRecord : calRecordList) {
                BigDecimal processCost;
                String jsonStr = calRecord.toString();
                InputCalDetailRowInfo info = (InputCalDetailRowInfo)JSONUtils.cast((String)jsonStr, InputCalDetailRowInfo.class);
                BigDecimal baseQty = info.getBaseQty();
                String entryIdStr = info.getEntryID();
                long entryId = Long.parseLong(entryIdStr);
                BigDecimal rowMaterialCost = baseQty.multiply(unitMatCost).setScale(amtPrecision, RoundingMode.HALF_UP);
                if (isOminBillType) {
                    processCost = baseQty.multiply(unitProCost).setScale(amtPrecision, RoundingMode.HALF_UP);
                    BigDecimal bigDecimal2 = var33_55.add(processCost);
                } else {
                    processCost = info.getProcessCost();
                }
                if (subElementInfoList == null) {
                    BigDecimal feeInfo = info.getFee();
                    BigDecimal manufactureCostInfo = info.getManufactureCost();
                    BigDecimal resourceInfo = info.getResource();
                    BigDecimal rowActualCost = rowMaterialCost.add(feeInfo).add(processCost).add(manufactureCostInfo).add(resourceInfo);
                    BigDecimal rowUnitActualCost = rowActualCost.divide(baseQty, pricePrecision, 4);
                    if (feeInfo.compareTo(BigDecimal.ZERO) == 0 && manufactureCostInfo.compareTo(BigDecimal.ZERO) == 0 && resourceInfo.compareTo(BigDecimal.ZERO) == 0) {
                        if (processCost.compareTo(BigDecimal.ZERO) == 0) {
                            rowUnitActualCost = unitMatCost;
                        } else if (rowMaterialCost.compareTo(BigDecimal.ZERO) == 0) {
                            rowUnitActualCost = unitProCost;
                        }
                    }
                    rowTotalMatAmt = ((BigDecimal)rowTotalMatAmt).add(rowMaterialCost);
                    Object[] recordParam = new Object[]{rowUnitActualCost, rowActualCost, unitMatCost, rowMaterialCost, isOminBillType ? unitProCost : info.getUnitProcessCost(), processCost, entryId};
                    updateRecordParamMap.put(entryIdStr, recordParam);
                    recordParams.add(recordParam);
                    costDetailList.add(new Object[]{rowUnitActualCost, rowActualCost, entryId, defaultMetriaElemnet});
                } else {
                    for (CostSubElementInfo subElementInfo : subElementInfoList) {
                        long id = subElementInfo.getId();
                        BigDecimal subEleUnitCost = subElementInfo.getUnitActualCost();
                        BigDecimal subEleNewActCost = subEleUnitCost.multiply(baseQty).setScale(amtPrecision, RoundingMode.HALF_UP);
                        subElementInfo.setTotalActualCost(subElementInfo.getTotalActualCost().add(subEleNewActCost));
                        costDetailList.add(new Object[]{subEleUnitCost, subEleNewActCost, entryId, id});
                    }
                }
                Object[] cacheParam = new Object[]{rowMaterialCost, processCost, baseQty};
                cacheParamMap.put(entryIdStr, cacheParam);
                String groupValue = (String)groupMap.get(entryIdStr);
                if (StringUtils.isNotBlank((CharSequence)groupValue)) {
                    InputCalDetailRowInfo groupInfo = (InputCalDetailRowInfo)JSONUtils.cast((String)groupValue, InputCalDetailRowInfo.class);
                    groupEntryInfoMap.put(entryIdStr, groupInfo);
                    entryIdSet.add(Long.valueOf(groupInfo.getEntryID()));
                    idSet.add(groupInfo.getId());
                }
                entryIdSet.add(entryId);
                idSet.add(info.getId());
            }
            String errorMsg = subElementInfoList == null ? this.dealEntryCostDiff((BigDecimal)rowTotalMatAmt, (BigDecimal)var33_55, cacheParamMap, param, updateRecordParamMap, costDetailList, isOminBillType) : this.dealSubEleDiff(subElementInfoList, costDetailList, gid, cacheParamMap, param);
            msg.append(errorMsg);
            StringBuilder billNos = new StringBuilder();
            for (Map.Entry entry : groupEntryInfoMap.entrySet()) {
                String entryId = (String)entry.getKey();
                InputCalDetailRowInfo groupInfo = (InputCalDetailRowInfo)entry.getValue();
                boolean isVoucher = groupInfo.isVoucher();
                if (isVoucher) {
                    billNos.append(groupInfo.getBillNo()).append(',');
                    continue;
                }
                if (subElementInfoList == null) {
                    Object[] recordParam = (Object[])updateRecordParamMap.get(entryId);
                    Object[] groupRecordParam = new Object[7];
                    BigDecimal groupMaterialCost = (BigDecimal)recordParam[3];
                    BigDecimal groupProcessCost = (BigDecimal)recordParam[5];
                    BigDecimal groupActualCost = groupMaterialCost.add(groupInfo.getFee()).add(groupProcessCost).add(groupInfo.getManufactureCost()).add(groupInfo.getResource());
                    BigDecimal groupUnitActualCost = groupActualCost.divide(groupInfo.getBaseQty(), pricePrecision, 4);
                    groupRecordParam[0] = groupUnitActualCost;
                    groupRecordParam[1] = groupActualCost;
                    groupRecordParam[2] = recordParam[2];
                    groupRecordParam[3] = groupMaterialCost;
                    groupRecordParam[4] = recordParam[4];
                    groupRecordParam[5] = groupProcessCost;
                    groupRecordParam[6] = Long.parseLong(groupInfo.getEntryID());
                    recordParams.add(groupRecordParam);
                    costDetailList.add(new Object[]{unitMatCost, groupMaterialCost, Long.parseLong(groupInfo.getEntryID()), defaultMetriaElemnet});
                } else {
                    for (CostSubElementInfo subElementInfo : subElementInfoList) {
                        long id = subElementInfo.getId();
                        BigDecimal subEleUnitCost = subElementInfo.getUnitActualCost();
                        BigDecimal subEleNewActCost = subEleUnitCost.multiply(groupInfo.getBaseQty()).setScale(amtPrecision, RoundingMode.HALF_UP);
                        costDetailList.add(new Object[]{subEleUnitCost, subEleNewActCost, Long.parseLong(groupInfo.getEntryID()), id});
                    }
                }
                if (billNos.length() <= 0) continue;
                String msgStr = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5b58\u5728\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u6210\u7ec4\u6210\u672c\u8bb0\u5f55\u3002", (String)"CalculateInCostTask_7", (String)"fi-cal-formplugin", (Object[])new Object[0]), i + 1, billNos.substring(0, billNos.length() - 1));
                msg.append(msgStr);
            }
            groupEntryInfoMap.clear();
        }
        try (TXHandle tx = TX.required();){
            try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fcostaccountid", FilterType.eq, (Object)this.costAccountId), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.ge, (Object)startBookDate), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.le, (Object)endBookDate)});){
                ctx.set();
                if (msg.length() != 0) {
                    tx.markRollback();
                    throw new KDBizException(msg.toString());
                }
                if (!recordParams.isEmpty()) {
                    DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)this.getUpdateSql(), recordParams);
                }
                if (!costDetailList.isEmpty()) {
                    DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)this.getCostRecordDetailSql(), costDetailList);
                    if (recordParams.isEmpty()) {
                        CostElementHelper.calCostRecordAllCost((Long[])entryIdSet.toArray(new Long[0]));
                    }
                }
                if (!entryIdSet.isEmpty()) {
                    this.updateCostPriceSource(entryIdSet);
                }
                if (!entryIdSet.isEmpty()) {
                    boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
                    if (isNewBalance) {
                        DLock lock = DLock.createReentrant((String)(this.costAccountId + "calinbal"), (String)"fi-cal-calculateincost-dlock-bal");
                        CalDLockHelper.releaseLockAfterTxEnd(Collections.singletonList(lock));
                        TraceSpan span = Tracer.create((String)"CalculateInCostTask-newbal", (String)"CalculateInCostTask-newbal");
                        actualCost = null;
                        try {
                            lock.lock();
                            new BalanceOpInvoker().invokeCostRecordUpdateBalOp(idSet, BalanceSourceEnum.CAL_INCOST);
                        }
                        catch (Throwable unitActualCost) {
                            actualCost = unitActualCost;
                            throw unitActualCost;
                        }
                        finally {
                            if (span != null) {
                                if (actualCost != null) {
                                    try {
                                        span.close();
                                    }
                                    catch (Throwable unitActualCost) {
                                        ((Throwable)actualCost).addSuppressed(unitActualCost);
                                    }
                                } else {
                                    span.close();
                                }
                            }
                        }
                    } else {
                        BalanceCalculator calculator = new BalanceCalculator();
                        ArrayList list = new ArrayList(32);
                        int i = 0;
                        int max = 10000;
                        HashSet<Long> set = new HashSet<Long>(1024);
                        list.add(set);
                        for (Long l : entryIdSet) {
                            if (i >= max) {
                                i = 0;
                                set = new HashSet(1024);
                                list.add(set);
                            }
                            set.add(l);
                            ++i;
                        }
                        for (Set set2 : list) {
                            calculator.updateBalance4Others((Object[])set2.toArray(new Long[set2.size()]), BalanceSourceEnum.CAL_INCOST);
                        }
                    }
                }
                HashSet<Long> splitEntryIdSet = new HashSet<Long>();
                QFilter q = new QFilter("entry.id", "in", entryIdSet);
                q.and("issplit", "=", (Object)Boolean.TRUE);
                QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
                q.and(billStatusf);
                q.and(new QFilter("entry.material", "in", this.matIds));
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"entry.id", (QFilter[])q.toArray(), null);){
                    for (Row row : dataSet) {
                        splitEntryIdSet.add(row.getLong("entry.id"));
                    }
                }
                if (!splitEntryIdSet.isEmpty()) {
                    new ChildBillCostUpdateHelper(cosTypeMaterialMap, defaultElementIds, this.isCostRecordDetail).updateChildBillCost(splitEntryIdSet);
                }
                CalCustomEventCallHelper.calRecSumEventCall(paramsList, (Map)detailMap, (long)this.costAccount.getLong("id"));
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private String dealEntryCostDiff(BigDecimal rowTotalMatAmt, BigDecimal rowTotalProAmt, Map<String, Object[]> paramMap, CalculateInParams param, Map<String, Object[]> updateRecordParamMap, List<Object[]> costDetailList, boolean isOminBillType) throws IOException {
        BigDecimal totalDiffAmt;
        String gid = param.getGatherID();
        BigDecimal materialCost = param.getMaterialCost();
        BigDecimal processCost = param.getProcessCost();
        BigDecimal matDiffAmt = materialCost.subtract(rowTotalMatAmt);
        BigDecimal proDiffAmt = isOminBillType ? processCost.subtract(rowTotalProAmt) : BigDecimal.ZERO;
        BigDecimal bigDecimal = totalDiffAmt = isOminBillType ? matDiffAmt.add(proDiffAmt) : matDiffAmt;
        BigDecimal maxDiffAmt = totalDiffAmt.compareTo(BigDecimal.ZERO) == 0 ? (matDiffAmt.abs().compareTo(proDiffAmt.abs()) >= 0 ? matDiffAmt : proDiffAmt) : totalDiffAmt;
        if (maxDiffAmt.compareTo(BigDecimal.ZERO) == 0) {
            return "";
        }
        InputCalDetailRowInfo diffEntry = this.getDiffEntryId(maxDiffAmt, gid);
        if (diffEntry == null) {
            return ResManager.loadKDString((String)"\u5c3e\u5dee\u5904\u7406\u5931\u8d25\uff0c\u672a\u627e\u5230\u5408\u9002\u7684\u8bb0\u5f55\u3002", (String)"CalculateInCostTask_9", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        }
        String diffEntryId = diffEntry.getEntryID();
        Object[] cacheParam = paramMap.get(diffEntryId);
        BigDecimal rowMaterialCost = (BigDecimal)cacheParam[0];
        BigDecimal rowProcessCost = (BigDecimal)cacheParam[1];
        BigDecimal rowBaseQty = (BigDecimal)cacheParam[2];
        Object[] recordParam = updateRecordParamMap.get(diffEntryId);
        int pricePrecision = 10;
        BigDecimal actualCost = param.getActualCost();
        BigDecimal baseqty = param.getBaseqty();
        BigDecimal unitActualCost = param.getUnitActualCost();
        if (baseqty.compareTo(BigDecimal.ZERO) == 0 && unitActualCost.compareTo(BigDecimal.ZERO) == 0 && actualCost.compareTo(BigDecimal.ZERO) != 0) {
            matDiffAmt = matDiffAmt.multiply(new BigDecimal(-1));
            proDiffAmt = proDiffAmt.multiply(new BigDecimal(-1));
        }
        BigDecimal finalMatCost = rowMaterialCost.add(matDiffAmt);
        BigDecimal finalProCost = rowProcessCost.add(proDiffAmt);
        BigDecimal finalUnitMatCost = finalMatCost.divide(rowBaseQty, pricePrecision, 4);
        BigDecimal finalUnitProCost = finalProCost.divide(rowBaseQty, pricePrecision, 4);
        BigDecimal feeInfo = diffEntry.getFee();
        BigDecimal manufactureCostInfo = diffEntry.getManufactureCost();
        BigDecimal resourceInfo = diffEntry.getResource();
        BigDecimal finalActualCost = finalMatCost.add(feeInfo).add(finalProCost).add(manufactureCostInfo).add(resourceInfo);
        BigDecimal finalUnitActualCost = finalActualCost.divide(rowBaseQty, pricePrecision, 4);
        if (rowBaseQty.signum() * finalActualCost.signum() < 0) {
            paramMap.remove(diffEntryId);
            return ResManager.loadKDString((String)"\u7269\u6599\u8ba1\u7b97\u5904\u7406\u5c3e\u5dee\u65f6\u51fa\u73b0\u4e86\u8d1f\u5355\u4f4d\u5b9e\u9645\u6210\u672c\uff0c\u8ba1\u7b97\u5931\u8d25\u3002", (String)"CalculateInCostTask_10", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        }
        recordParam[0] = finalUnitActualCost;
        recordParam[1] = finalActualCost;
        recordParam[2] = finalUnitMatCost;
        recordParam[3] = finalMatCost;
        recordParam[4] = isOminBillType ? finalUnitProCost : diffEntry.getUnitProcessCost();
        recordParam[5] = finalProCost;
        for (Object[] costDetail : costDetailList) {
            long entryId = (Long)costDetail[2];
            if (entryId != Long.parseLong(diffEntryId)) continue;
            costDetail[0] = finalUnitMatCost;
            costDetail[1] = finalMatCost;
        }
        return "";
    }

    private String dealSubEleDiff(List<CostSubElementInfo> subElementInfoList, List<Object[]> costDetailList, String gid, Map<String, Object[]> paramMap, CalculateInParams param) throws IOException {
        BigDecimal maxDiffAmt = BigDecimal.ZERO;
        BigDecimal totalDiffAmt = BigDecimal.ZERO;
        for (CostSubElementInfo subElementInfo : subElementInfoList) {
            BigDecimal subEleOldTotalAmt = subElementInfo.getActualCost();
            BigDecimal subEleNewTotalAct = subElementInfo.getTotalActualCost();
            BigDecimal diffAmt = subEleOldTotalAmt.subtract(subEleNewTotalAct);
            totalDiffAmt = totalDiffAmt.add(diffAmt);
            subElementInfo.setDiffAmt(diffAmt);
        }
        if (totalDiffAmt.compareTo(BigDecimal.ZERO) == 0) {
            for (CostSubElementInfo subElementInfo : subElementInfoList) {
                BigDecimal diffAmt = subElementInfo.getDiffAmt();
                if (diffAmt.compareTo(BigDecimal.ZERO) == 0 || diffAmt.abs().compareTo(maxDiffAmt.abs()) <= 0) continue;
                maxDiffAmt = diffAmt;
            }
        } else {
            maxDiffAmt = totalDiffAmt;
        }
        if (maxDiffAmt.compareTo(BigDecimal.ZERO) == 0) {
            return "";
        }
        InputCalDetailRowInfo diffEntry = this.getDiffEntryId(maxDiffAmt, gid);
        if (diffEntry == null) {
            return ResManager.loadKDString((String)"\u5c3e\u5dee\u5904\u7406\u5931\u8d25\uff0c\u672a\u627e\u5230\u5408\u9002\u7684\u8bb0\u5f55\u3002", (String)"CalculateInCostTask_9", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        }
        String diffEntryId = diffEntry.getEntryID();
        Object[] cacheParam = paramMap.get(diffEntryId);
        BigDecimal rowBaseQty = (BigDecimal)cacheParam[2];
        BigDecimal actualCost = param.getActualCost();
        BigDecimal baseqty = param.getBaseqty();
        BigDecimal unitActualCost = param.getUnitActualCost();
        for (CostSubElementInfo subElementInfo : subElementInfoList) {
            BigDecimal subEleNewTotalAct;
            BigDecimal subEleOldTotalAmt = subElementInfo.getActualCost();
            BigDecimal diffAmt = subEleOldTotalAmt.subtract(subEleNewTotalAct = subElementInfo.getTotalActualCost());
            if (diffAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            if (baseqty.compareTo(BigDecimal.ZERO) == 0 && unitActualCost.compareTo(BigDecimal.ZERO) == 0 && actualCost.compareTo(BigDecimal.ZERO) != 0) {
                diffAmt = diffAmt.multiply(new BigDecimal(-1));
            }
            long id = subElementInfo.getId();
            for (Object[] costDetail : costDetailList) {
                long entryId = (Long)costDetail[2];
                long subId = (Long)costDetail[3];
                if (id != subId || entryId != Long.parseLong(diffEntryId)) continue;
                BigDecimal newActCost = ((BigDecimal)costDetail[1]).add(diffAmt);
                if (rowBaseQty.signum() * newActCost.signum() < 0) {
                    paramMap.remove(diffEntryId);
                    return ResManager.loadKDString((String)"\u7269\u6599\u8ba1\u7b97\u5904\u7406\u5c3e\u5dee\u65f6\u51fa\u73b0\u4e86\u8d1f\u5b50\u8981\u7d20\u5355\u4f4d\u5b9e\u9645\u6210\u672c\uff0c\u8ba1\u7b97\u5931\u8d25;", (String)"CalculateInCostTask_22", (String)"fi-cal-formplugin", (Object[])new Object[0]);
                }
                costDetail[1] = newActCost;
                costDetail[0] = newActCost.divide(rowBaseQty, 10, 4);
            }
        }
        return "";
    }

    private InputCalDetailRowInfo getDiffEntryId(BigDecimal diffAmt, String gatherId) throws IOException {
        InputCalDetailRowInfo rowInfo;
        Map bluedetailMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("BLUEMAXVALUEMAP"), HashMap.class);
        Map reddetailMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("REDMAXVALUEMAP"), HashMap.class);
        InputCalDetailRowInfo blueRowInfo = null;
        InputCalDetailRowInfo redRowInfo = null;
        if (bluedetailMap.get(gatherId) != null) {
            blueRowInfo = (InputCalDetailRowInfo)JSONUtils.cast((String)bluedetailMap.get(gatherId).toString(), InputCalDetailRowInfo.class);
        }
        if (reddetailMap.get(gatherId) != null) {
            redRowInfo = (InputCalDetailRowInfo)JSONUtils.cast((String)reddetailMap.get(gatherId).toString(), InputCalDetailRowInfo.class);
        }
        if (diffAmt.compareTo(BigDecimal.ZERO) < 0) {
            rowInfo = redRowInfo == null ? blueRowInfo : redRowInfo;
        } else {
            InputCalDetailRowInfo inputCalDetailRowInfo = rowInfo = blueRowInfo == null ? redRowInfo : blueRowInfo;
        }
        if (rowInfo == null || rowInfo.getEntryID() == null) {
            return null;
        }
        return rowInfo;
    }

    private void sumEntryCostBySubType(Map<String, BigDecimal> entryCostMap, String type, BigDecimal subEleNewActCost) {
        if (!entryCostMap.containsKey(type)) {
            entryCostMap.put(type, subEleNewActCost);
        } else {
            BigDecimal materialCost = entryCostMap.get(type).add(subEleNewActCost);
            entryCostMap.put(type, materialCost);
        }
    }

    private void updateCostPriceSource(Set<Long> entryIdSet) {
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(16);
        QFilter pricesourceqf = new QFilter("entry.id", "in", entryIdSet);
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        pricesourceqf.and(billStatusf);
        pricesourceqf.and(new QFilter("entry.material", "in", this.matIds));
        try (DataSet pricesourceds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"entry.id as entryid,entry.costpricesource as costpricesource", (QFilter[])pricesourceqf.toArray(), null);){
            for (Row pricesourced : pricesourceds) {
                Long entryid = pricesourced.getLong("entryid");
                String oldcostpricesource = pricesourced.getString("costpricesource");
                String newcostpricesource = CostPriceSourceTypeEnum.getCostPriceSourceValue((String)oldcostpricesource, (String)CostPriceSourceTypeEnum.CALCULATE_IN_SPECIFICATION.getValue());
                sqlParams.add(new Object[]{newcostpricesource, CostPriceSourceTypeEnum.CALCULATE_IN_SPECIFICATION.getDesignated(), entryid});
            }
            if (sqlParams.size() > 0) {
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)CostPriceSourceTypeEnum.getCostpriceSourceSql(), sqlParams);
            }
        }
    }

    private String doCostDiff(Map<String, Object[]> updateRecordParamMap, Map<String, Object[]> paramMap, BigDecimal diffAmt, String gatherid, Map<String, BigDecimal> diffMap) throws IOException {
        Map bluedetailMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("BLUEMAXVALUEMAP"), HashMap.class);
        Map reddetailMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("REDMAXVALUEMAP"), HashMap.class);
        InputCalDetailRowInfo blueRowInfo = null;
        InputCalDetailRowInfo redRowInfo = null;
        InputCalDetailRowInfo rowInfo = null;
        if (bluedetailMap.get(gatherid) != null) {
            blueRowInfo = (InputCalDetailRowInfo)JSONUtils.cast((String)bluedetailMap.get(gatherid).toString(), InputCalDetailRowInfo.class);
        }
        if (reddetailMap.get(gatherid) != null) {
            redRowInfo = (InputCalDetailRowInfo)JSONUtils.cast((String)reddetailMap.get(gatherid).toString(), InputCalDetailRowInfo.class);
        }
        if (diffAmt.compareTo(BigDecimal.ZERO) < 0) {
            rowInfo = redRowInfo == null ? blueRowInfo : redRowInfo;
        } else {
            InputCalDetailRowInfo inputCalDetailRowInfo = rowInfo = blueRowInfo == null ? redRowInfo : blueRowInfo;
        }
        if (rowInfo == null || rowInfo.getEntryID() == null) {
            return ResManager.loadKDString((String)"\u5c3e\u5dee\u5904\u7406\u5931\u8d25\uff0c\u672a\u627e\u5230\u5408\u9002\u7684\u8bb0\u5f55\u3002", (String)"CalculateInCostTask_9", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        }
        String entryID = rowInfo.getEntryID();
        Object[] cacheParam = paramMap.get(entryID);
        BigDecimal rowActualCost = (BigDecimal)cacheParam[0];
        BigDecimal rowBaseQty = (BigDecimal)cacheParam[1];
        Object[] recordParam = updateRecordParamMap.get(entryID);
        BigDecimal finalCost = rowActualCost.add(diffAmt);
        int pricePrecision = 10;
        BigDecimal fee = rowInfo.getFee();
        BigDecimal processCost = rowInfo.getProcessCost();
        BigDecimal resource = rowInfo.getResource();
        BigDecimal manufactureCost = rowInfo.getManufactureCost();
        BigDecimal materialCost = finalCost.subtract(fee).subtract(processCost).subtract(resource).subtract(manufactureCost);
        BigDecimal unitMaterialCost = materialCost.divide(rowInfo.getBaseQty(), pricePrecision, 4);
        if (rowBaseQty.signum() * finalCost.signum() < 0) {
            paramMap.remove(entryID);
            return ResManager.loadKDString((String)"\u7269\u6599\u8ba1\u7b97\u5904\u7406\u5c3e\u5dee\u65f6\u51fa\u73b0\u4e86\u8d1f\u5355\u4f4d\u5b9e\u9645\u6210\u672c\uff0c\u8ba1\u7b97\u5931\u8d25\u3002", (String)"CalculateInCostTask_10", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        }
        recordParam[1] = finalCost;
        recordParam[2] = unitMaterialCost;
        recordParam[3] = materialCost;
        diffMap.put(entryID, diffAmt);
        return "";
    }

    private Map<String, Object> buildCostDetailMap() {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        HashSet<Long> marerialIdSet = new HashSet<Long>(16);
        Set marerialIdObjSet = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get("MATERIALIDSET"), HashSet.class);
        for (Object matObj : marerialIdObjSet) {
            Long tmpMatId = matObj instanceof Integer ? Long.valueOf(((Integer)matObj).intValue()) : (Long)matObj;
            marerialIdSet.add(tmpMatId);
        }
        long costTypeId = this.getCostTypeId();
        long calOrgId = this.costAccount.getLong("calorg");
        Map cosTypeMaterialMap = CostElementHelper.getCostElementsByMaterial((long)calOrgId, (Long[])new Long[]{costTypeId}, (Long[])marerialIdSet.toArray(new Long[marerialIdSet.size()]));
        returnMap.put("cosTypeMaterialMap", cosTypeMaterialMap);
        return returnMap;
    }

    private Long getCostTypeId() {
        long costTypeId = this.costAccount.getLong("costtype");
        return costTypeId;
    }

    private String getUpdateSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cal_calcostrecordentry set ");
        sql.append(" funitactualcost = ? ,factualcost = ?, ");
        sql.append(" funitmaterialcost = ?,fmaterialcost = ?, ");
        sql.append(" funitprocesscost = ?,fprocesscost = ? ");
        sql.append(" where fentryid = ? ");
        return sql.toString();
    }

    private String getCostRecordDetailSql() {
        return " update t_cal_costrecord_detail set funitactualcost = ?, factualcost = ? where fentryid = ? and fcostsubelementid = ?";
    }

    private void caculateDetailUnitActual(Set<Long> entryIdSet) {
        String sql = " update t_cal_costrecord_detail set funitactualcost = factualcost/fbaseqty where fentryid = ? and fbaseqty <> 0";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(16);
        for (Long entryId : entryIdSet) {
            paramList.add(new Object[]{entryId});
        }
        if (!paramList.isEmpty()) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, paramList);
        }
    }

    private Map<String, String> getPageCache() {
        return this.cacheMap;
    }

    private List getGatherFields() {
        ArrayList<String> gatherKeyList = new ArrayList<String>(18);
        gatherKeyList.add("materialnumber");
        gatherKeyList.add("baseunitnumber");
        if (SumTypeEnum.OWNER.getValue().equals(this.sumType)) {
            gatherKeyList.add("ownerid");
        } else if (SumTypeEnum.STORAGEORG.getValue().equals(this.sumType)) {
            gatherKeyList.add("ownerid");
            gatherKeyList.add("storageorgunitnumber");
        } else if (SumTypeEnum.WAREHOUSE.getValue().equals(this.sumType)) {
            gatherKeyList.add("ownerid");
            gatherKeyList.add("storageorgunitnumber");
            gatherKeyList.add("warehousenumber");
        } else if (SumTypeEnum.LOCATION.getValue().equals(this.sumType)) {
            gatherKeyList.add("ownerid");
            gatherKeyList.add("storageorgunitnumber");
            gatherKeyList.add("warehousenumber");
            gatherKeyList.add("locationnumber");
        } else if (SumTypeEnum.HUAFENYIJU.getValue().equals(this.sumType)) {
            gatherKeyList.add("ownerid");
            gatherKeyList.add("storageorgunitnumber");
            gatherKeyList.add("warehousenumber");
            gatherKeyList.add("locationnumber");
            gatherKeyList.add("lot");
            gatherKeyList.add("projectnumber");
            gatherKeyList.addAll(this.extendFields);
        }
        return gatherKeyList;
    }

    private List<Set<Long>> getBatchIdList(Set<Long> ids) {
        ArrayList<Set<Long>> balIdsArray = new ArrayList<Set<Long>>(16);
        HashSet<Long> balIds = null;
        long index = 0L;
        for (Long id : ids) {
            if (index % 100000L == 0L) {
                balIds = new HashSet<Long>();
                balIdsArray.add(balIds);
            }
            if (balIds != null) {
                balIds.add(id);
            }
            ++index;
        }
        return balIdsArray;
    }
}

