/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.calculate.in;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.fallprice.DealCalRangeFunction;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.WriteLogHelper;

public class ExpBillCostMoveAvgWeightFilter {
    private static final Log logger = LogFactory.getLog(ExpBillCostMoveAvgWeightFilter.class);
    private static String BILLSTATUS = "billstatus";
    private static String COSTACCOUNT = "costaccount";
    private static String ACCOUNTTYPE = "accounttype";
    private IDataModel model;

    public ExpBillCostMoveAvgWeightFilter(IDataModel model) {
        this.model = model;
    }

    public DataSet inTimeCalFilter(DataSet dataSet) {
        DataSet finish;
        Map<String, Object> map = this.getBillStatusAndAccountType(this.model.getDataEntity());
        String billStatus = (String)map.get(BILLSTATUS);
        if (!"B".equals(billStatus)) {
            return dataSet;
        }
        DynamicObject dataEntity = this.model.getDataEntity();
        boolean isLessPrice = dataEntity.getBoolean("islessprice");
        if (!isLessPrice) {
            return dataSet;
        }
        HashSet<Long> materialIds = new HashSet<Long>();
        for (Row row : dataSet.copy()) {
            materialIds.add(row.getLong("entry.material.id"));
        }
        if (materialIds.isEmpty()) {
            return dataSet;
        }
        DynamicObject info = this.model.getDataEntity().getDynamicObject(COSTACCOUNT);
        DynamicObject accountDyc = BusinessDataServiceHelper.loadSingleFromCache((Object)info.getPkValue(), (String)"cal_bd_costaccount");
        String divStr = accountDyc.getString("dividebasis.dividebasis");
        String calDimensionStr = CommonSettingHelper.getCalDimensionStr();
        Set costRecordDim = Stream.of((divStr + "," + calDimensionStr).split(",")).filter(s -> !StringUtils.isEmpty((String)s)).collect(Collectors.toSet());
        costRecordDim.add("calrange");
        costRecordDim.add("material");
        DataSet intimeCal = this.getInTimeCalDataSet(materialIds, accountDyc.getPkValue());
        Set<Long> emptyEntryRangeIds = this.getEmptyEntryRangeIds(accountDyc.getLong("id"));
        DealCalRangeFunction dealCalRangeFunction = new DealCalRangeFunction(emptyEntryRangeIds, divStr, calDimensionStr, dataSet.getRowMeta());
        dealCalRangeFunction.setBakDivDimField(true);
        dataSet = dataSet.map((MapFunction)dealCalRangeFunction);
        try {
            WriteLogHelper.writeInfoLog((Log)logger, (String)("ExpMoveAvgWeight dims : " + costRecordDim.stream().collect(Collectors.joining(","))), (Object[])new Object[0]);
            JoinDataSet joinDataSet = dataSet.leftJoin(intimeCal);
            StringBuilder sb = new StringBuilder();
            for (String dim : costRecordDim) {
                if ("material".equals(dim) || "calrange".equals(dim)) continue;
                String cur = dim + "bak";
                joinDataSet.on(cur, dim);
                sb.append(cur).append(",");
            }
            joinDataSet.on("material", "material");
            joinDataSet.on("calrangedeal", "calrange");
            WriteLogHelper.writeInfoLog((Log)logger, (String)("ExpMoveAvgWeight dims : " + sb), (Object[])new Object[0]);
            finish = joinDataSet.select(dataSet.getRowMeta().getFieldNames(), new String[]{"recentcost", "recentqty"}).finish();
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        if (finish == null) {
            return dataSet;
        }
        finish = finish.filter("recentcost is null or (recentcost < 0 and recentqty > 0) or (recentcost > 0 and recentqty < 0) or (recentcost != 0 and recentqty = 0) or (recentcost = 0 and recentqty = 0)");
        return finish;
    }

    private DataSet getInTimeCalDataSet(Set<Long> materialIds, Object costAccountId) {
        Set<String> dimFields = this.getCalSystemDivDimension();
        StringBuilder inTimeBalSelectBuilder = new StringBuilder();
        dimFields.stream().forEach(dim -> {
            if (EntityMetadataCache.getDataEntityType((String)"cal_recentcost").findProperty(dim) != null) {
                inTimeBalSelectBuilder.append((String)dim).append(",");
            }
        });
        String cur = inTimeBalSelectBuilder.length() > 1 ? inTimeBalSelectBuilder.append("recentcost").append(",recentqty").toString() : inTimeBalSelectBuilder.toString();
        ArrayList inputs = new ArrayList(16);
        int patch = (materialIds.size() + 9) / 10;
        Lists.partition(new ArrayList<Long>(materialIds), (int)patch).forEach(list -> inputs.add(new OrmInput(this.getClass().getName(), "cal_recentcost", cur, new QFilter[]{new QFilter("material", "in", list), new QFilter("costaccount", "=", costAccountId)})));
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSet intimeCal = algo.createDataSet((Input[])inputs.toArray(new OrmInput[0])).groupBy(dimFields.toArray(new String[0])).sum("recentcost").sum("recentqty").finish();
        return intimeCal;
    }

    private Set<String> getCalSystemDivDimension() {
        String divideBasisStr = CommonSettingHelper.getDivideBasisStr();
        String calDimensionStr = CommonSettingHelper.getCalDimensionStr();
        String divide = Stream.of(divideBasisStr.split(",")).filter(s -> !StringUtils.isEmpty((String)s)).collect(Collectors.joining(","));
        String dimension = Stream.of(calDimensionStr.split(",")).filter(s -> !StringUtils.isEmpty((String)s)).collect(Collectors.joining(","));
        String allDims = divide + ",calrange,material," + dimension;
        return Stream.of(allDims.split(",")).filter(s -> !StringUtils.isEmpty((String)s)).collect(Collectors.toSet());
    }

    private Map<String, Object> getBillStatusAndAccountType(DynamicObject dataEntity) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        String billStatus = dataEntity.getString(BILLSTATUS);
        String accountTypeValue = dataEntity.getString(ACCOUNTTYPE);
        String[] accountType = null;
        if (accountTypeValue != null && accountTypeValue.length() != 0) {
            String[] str = accountTypeValue.split(",");
            ArrayList<String> container = new ArrayList<String>(16);
            for (String value : str) {
                if (value == null || value.length() == 0) continue;
                container.add(value);
            }
            accountType = container.toArray(new String[container.size()]);
        }
        map.put(BILLSTATUS, billStatus);
        map.put(ACCOUNTTYPE, accountType);
        return map;
    }

    private Set<Long> getEmptyEntryRangeIds(Long costAccount) {
        QFilter filter = new QFilter("costaccount", "=", (Object)costAccount);
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        HashSet<Long> emptyEntryRangeIds = new HashSet<Long>(16);
        Map calRangeMap = BusinessDataServiceHelper.loadFromCache((String)"cal_bd_calrange", (QFilter[])filter.toArray());
        for (DynamicObject rangDyc : calRangeMap.values()) {
            DynamicObjectCollection entryDycs = rangDyc.getDynamicObjectCollection("entry");
            if (!entryDycs.isEmpty()) continue;
            emptyEntryRangeIds.add(rangDyc.getLong("id"));
        }
        return emptyEntryRangeIds;
    }
}

