/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.calculate.in;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.Input;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.config.client.util.JSONUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.lang.Lang;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.ExceptionUtils;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.bos.web.actions.export.ExportWriterFormat;
import kd.fi.cal.business.calculate.bizbillgroup.BizGroupRecordBuilder;
import kd.fi.cal.business.costprice.CostPrice4Others;
import kd.fi.cal.business.process.impl.EstimateAdjustInPurValidator;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.enums.CalStatusEnum;
import kd.fi.cal.common.enums.CostSrcEnum;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.CostRecordQFilterHelper;
import kd.fi.cal.common.helper.DynamicFieldCreateHelper;
import kd.fi.cal.common.helper.FelxHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.helper.ReportF7Helper;
import kd.fi.cal.common.helper.SCMHelper;
import kd.fi.cal.common.metadata.Element;
import kd.fi.cal.common.metadata.EntryElement;
import kd.fi.cal.common.model.CostPriceResultInfo;
import kd.fi.cal.common.model.CostSubElementInfo;
import kd.fi.cal.formplugin.calculate.in.CalImportSheetHandler;
import kd.fi.cal.formplugin.calculate.in.ExpBillCostFilterFunction;
import kd.fi.cal.formplugin.calculate.in.ExpBillCostMoveAvgWeightFilter;
import kd.fi.cal.formplugin.calculate.in.ExpBillCostRowToColFunction;
import kd.fi.cal.formplugin.calculate.in.ExportUtil;
import kd.fi.cal.formplugin.calculate.in.MatFromToFilter;
import kd.fi.cal.formplugin.calculate.in.SubEntityUtil;
import org.apache.commons.lang.ArrayUtils;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExpBillCostPlugin
extends AbstractFormPlugin
implements UploadListener,
HyperLinkClickListener,
BeforeF7SelectListener,
ProgresssListener {
    private String BTNREVIEW = "btnreview";
    private String BTNREVIEWALL = "btnreviewall";
    private String BTNDOWNLOAD = "btndownload";
    private String BTNREFRESH = "btnrefresh";
    private String BTNIMPORTDATA = "btnimportdata";
    private String BTNUPLOAD = "btnupload";
    private String BTNEXPORTEXCEL = "btnexportexcel";
    private String BTNJUMP = "btnjump";
    private String QFILTER = "qfilter";
    private static final String PROGRESS_KEY = "progress";
    private String AMT_PRECISION = "amtPrecision";
    private String PRICE_PRECISION = "pricePrecision";
    private String UNITACTUALCOST = "unitactualcost";
    private String ACTUALCOST = "actualcost";
    private String BASEQTY = "baseqty";
    private static final String UNITMATERIALCOST = "unitmaterialcost";
    private static final String MATERIALCOST = "materialcost";
    private static final String UNITFEE = "unitfee";
    private static final String FEE = "fee";
    private static final String UNITPROCESSCOST = "unitprocesscost";
    private static final String PROCESSCOST = "processcost";
    private String ENTRYENTITY = "entryentity";
    private Map<String, DynamicObject> ownerMap = new HashMap<String, DynamicObject>();
    private String CALORG = "calorg";
    private String COSTACCOUNT = "costaccount";
    private String YEAR = "year";
    private String PERIODNUM = "periodnum";
    private volatile boolean isPeriodChange = false;
    private String STORAGEORGUNITFILTER = "storageorgunitfilter";
    private String WAREHOUSEFILTER = "warehousefilter";
    private String LOCATUINFILTER = "locationfilter";
    private String OWNERFILTER = "ownerfilter";
    private String MATERIALFROM = "materialfrom";
    private String MATERIALTO = "materialto";
    private String BILLTYPEFILTER = "billtypefilter";
    private String BDBIZTYPE = "bdbiztype";
    private String INVSCHEME = "invscheme";
    private String ONLYISINITBILL = "onlyisinitbill";
    private String BIZTYPEFILTER = "biztypefilter";
    private String BILLSTATUS = "billstatus";
    private String ACCOUNTTYPE = "accounttype";
    private String CACHEBIZID = "cacheBizId";
    private String COSTSUBELEMENT = "costsubelementfilter";
    private String GATHERDATAMAP = "gatherDataMap";
    private static final Log logger = LogFactory.getLog(ExpBillCostPlugin.class);
    private boolean falseValue = false;
    private boolean trueValue = true;
    private static final int BATCHSIZE = 1000;
    private static final String[] status = new String[]{"0", "3", "4", "5"};
    private static final long FX_TEMPLATEID = 1890529357873799168L;
    private static final long FFX_TEMPLATEID = 1889955247472892928L;
    private String[] ENTRY_COST_FIELDS = new String[]{"materialcost", "processcost"};
    private String exPreStr = "Exception@@";
    private final String TASKIDS_CACHE = "taskIds";
    private static final int BATCH_SIZE = 100000;
    private static final int PAGE_LIMIT = 100000;
    private static final String SQL = "SELECT FDATA FROM T_BAS_BILLTYPEPARAMETER WHERE FBILLTYPEID=";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{this.BTNREVIEW, this.BTNREVIEWALL, this.BTNDOWNLOAD, this.BTNREFRESH, this.BTNIMPORTDATA, this.BTNUPLOAD, this.BTNEXPORTEXCEL, this.BTNJUMP});
        Button btnUpLoad = (Button)this.getControl("btnupload");
        btnUpLoad.addUploadListener((UploadListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(this.ENTRYENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addF7Listener(this, this.COSTACCOUNT, this.STORAGEORGUNITFILTER, this.WAREHOUSEFILTER, this.LOCATUINFILTER, this.OWNERFILTER, this.CALORG, this.BILLTYPEFILTER, this.BDBIZTYPE, this.INVSCHEME, this.MATERIALFROM, "materialto");
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
    }

    public void initialize() {
        this.getView().addCustomControls(new String[]{"entryentity"});
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkEvent) {
        int index = hyperLinkEvent.getRowIndex();
        String costrecordId = this.getModel().getValue("costrecordid", index).toString();
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("cal_costrecord_subentity");
        showParameter.setPkId((Object)costrecordId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void click(EventObject evt) {
        super.click(evt);
        this.checkAcctIsNull();
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)this.BTNREFRESH)) {
            this.refreshPage();
        } else if (!StringUtils.equals((CharSequence)source.getKey(), (CharSequence)this.BTNDOWNLOAD)) {
            if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)this.BTNIMPORTDATA)) {
                this.clickImportData();
            } else if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)this.BTNEXPORTEXCEL)) {
                this.exportExcel();
            } else if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)this.BTNJUMP)) {
                this.linkPage();
            }
        }
    }

    private void linkPage() {
        QFilter filter;
        Long id;
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        String cacheIds = this.getPageCache().get(this.CACHEBIZID);
        if (cacheIds != null) {
            List preIds = SerializationUtils.fromJsonStringToList((String)cacheIds, Long.class);
            ArrayList<Long> legal = new ArrayList<Long>(16);
            for (Object preId : preIds) {
                id = preId == null ? 0L : Long.parseLong(String.valueOf(preId));
                if (id == 0L) continue;
                legal.add(id);
            }
            filter = new QFilter("bizbillid", "in", legal);
            filter.and("success", "in", (Object)status);
        } else {
            filter = QFilter.of((String)"1!=1", (Object[])new Object[0]);
        }
        filter.and(new QFilter("actionname", "=", (Object)ActionEnum.AUDIT.getValue()));
        DataSet rows = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_businesslog", (String)"id,bizbillid", (QFilter[])new QFilter[]{filter}, null);
        LinkQueryPkIdCollection linkQueryPkIdCollection = new LinkQueryPkIdCollection();
        for (Row row : rows) {
            id = row.getLong("id") != null ? row.getLong("id") : 0L;
            if (id == 0L) continue;
            linkQueryPkIdCollection.addLinkQueryPkId((Object)id);
        }
        showParameter.getListFilterParameter().setFilter(filter);
        showParameter.setBillFormId("cal_businesslog");
        showParameter.setAppId("cal");
        showParameter.setLinkQueryPkIdCollection(linkQueryPkIdCollection);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void exportExcel() {
        String billFormId = "cal_costprocessinfo";
        DynamicObject info = this.getModel().getDataEntity().getDynamicObject(this.COSTACCOUNT);
        boolean isCostRecordDetail = ParamsHelper.getCostElementByCostAccount((long)info.getLong("id"));
        long templateId = isCostRecordDetail ? 1890529357873799168L : 1889955247472892928L;
        try {
            FormView formView = (FormView)this.getView();
            String routeAppId = formView.getFormShowParameter().getServiceAppId();
            String url = this.export(routeAppId, billFormId, templateId);
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                this.getView().download(url);
                this.getView().sendFormAction(this.getView());
            }
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public String export(String routeAppId, String formId, Long template) throws IOException {
        SXSSFWorkbook wb = new SXSSFWorkbook(50000);
        wb.setCompressTempFiles(Boolean.TRUE.booleanValue());
        SXSSFSheet sheet = wb.createSheet("sheet1");
        ExportSheetStyle styles = new ExportSheetStyle(wb);
        ExportWriterFormat format = ExportUtil.getExportWriterFormatAndWriteHead(wb, sheet, styles, routeAppId, formId, template, null);
        if (format == null) {
            return null;
        }
        int rowIndex = 4;
        Object pageDataList = this.getModel().getEntryEntity("entryentity");
        EntryGrid entryGrid = (EntryGrid)this.getControl(this.ENTRYENTITY);
        int[] indexs = entryGrid.getSelectRows();
        if (indexs != null && indexs.length > 0) {
            ArrayList selectDataList = new ArrayList(indexs.length);
            for (int index : indexs) {
                selectDataList.add(pageDataList.get(index));
            }
            pageDataList = selectDataList;
        }
        ArrayList<DynamicObject> exportList = new ArrayList<DynamicObject>(pageDataList.size());
        MetadataService metaService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        String formatJson = metaService.getExportWriter("cal_costprocessinfo", template.longValue(), null, null);
        List formats1 = JSONObject.parseArray((String)formatJson, ExportWriterFormat.class);
        ExportWriterFormat format1 = (ExportWriterFormat)formats1.get(0);
        List impTplFields = format1.listFields(new ArrayList());
        MainEntityType costProInfoEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costprocessinfo");
        int index = 0;
        HashSet<String> subEleKeySet = new HashSet<String>(16);
        DynamicObjectCollection costSubElements = this.getModel().getDataEntity().getDynamicObjectCollection(this.COSTSUBELEMENT);
        for (DynamicObject costSubElement : costSubElements) {
            DynamicObject subEleInfo = costSubElement.getDynamicObject("fbasedataid");
            String subEleNum = subEleInfo.getString("number").toLowerCase();
            subEleKeySet.add(subEleNum + "_cost");
            subEleKeySet.add(subEleNum + "_unitcost");
        }
        Iterator iterator = pageDataList.iterator();
        while (iterator.hasNext()) {
            DynamicObject rowData = (DynamicObject)iterator.next();
            DynamicObject exportRow = BusinessDataServiceHelper.newDynamicObject((String)"cal_costprocessinfo");
            DynamicObject entry = exportRow.getDynamicObjectCollection("entry").addNew();
            entry.set("id", (Object)index++);
            for (String impTplField : impTplFields) {
                if (this.CALORG.equals(impTplField)) {
                    exportRow.set(impTplField, (Object)this.getModel().getDataEntity().getDynamicObject(this.CALORG));
                    continue;
                }
                IDataEntityProperty property = costProInfoEntityType.findProperty(impTplField);
                if (!(property.getParent() instanceof EntryType)) {
                    exportRow.set(impTplField, rowData.get(impTplField));
                    continue;
                }
                if ("material".equals(impTplField)) {
                    entry.set(impTplField, rowData.get("materialentry"));
                    continue;
                }
                if ("entry.id".equals(impTplField)) {
                    entry.set("id", rowData.get("entryid"));
                    continue;
                }
                if (!subEleKeySet.contains(impTplField) && (impTplField.endsWith("_cost") || impTplField.endsWith("_unitcost")) || !rowData.containsProperty(impTplField)) continue;
                entry.set(impTplField, rowData.get(impTplField));
            }
            exportList.add(exportRow);
        }
        String json = SerializationUtils.toJsonString(exportList);
        JSONArray billArr = JSONArray.parseArray((String)json);
        LocalDate now = LocalDate.now();
        DynamicObject templateData = BusinessDataServiceHelper.loadSingle((Object)template, (String)"bos_importtemplate");
        String content = String.format(ResManager.loadKDString((String)"\u9884\u7f6e_%1$s", (String)"ExpBillCostPlugin_40", (String)"fi-cal-formplugin", (Object[])new Object[0]), templateData.get("name"));
        String fileName = content + "_" + now.getMonthValue() + now.getDayOfMonth() + ".xlsx";
        FelxHelper.changeFlexDatas((JSONArray)billArr, (String)"assist", (SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (ExportWriterFormat)format, (String)fileName);
        return this.writeFile(wb, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeFile(SXSSFWorkbook wb, String fileName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        String url = "";
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 10000);
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
        return url;
    }

    private void setEntryDynamicObjValue(DynamicObject rowData, DynamicObject exportRow, String rowProp, String rowNameProp, String entityName, String setProp, Map<String, DynamicObject> cacheMap) {
        String rowPropValue = rowData.getString(rowProp);
        if (StringUtils.isEmpty((CharSequence)rowPropValue)) {
            DynamicObject entityObj = BusinessDataServiceHelper.newDynamicObject((String)entityName);
            if (rowNameProp != null) {
                String rowPropNameValue = rowData.getString(rowNameProp);
                entityObj.set("name", (Object)rowPropNameValue);
            }
            exportRow.set(setProp, (Object)entityObj);
            return;
        }
        DynamicObject cacheMapValue = cacheMap.get(rowPropValue);
        if (cacheMapValue != null) {
            exportRow.set(setProp, (Object)cacheMapValue);
        } else {
            DynamicObject entityObj = BusinessDataServiceHelper.newDynamicObject((String)entityName);
            entityObj.set("number", (Object)rowPropValue);
            if (rowNameProp != null) {
                String rowPropNameValue = rowData.getString(rowNameProp);
                entityObj.set("name", (Object)rowPropNameValue);
            }
            exportRow.set(setProp, (Object)entityObj);
            cacheMap.put(rowPropValue, entityObj);
        }
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
    }

    public void afterUpload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls != null && urls.length > 0) {
            String fileUrl = urls[0].toString();
            try {
                Date curDate = TimeServiceHelper.now();
                logger.info("\u5f02\u5e38\u6210\u672c\u5904\u7406\u5f15\u5165\u5916\u90e8\u6570\u636e-\u5f00\u59cb\uff1a" + curDate);
                this.loadXLSXFile(fileUrl);
                long time = System.currentTimeMillis() - curDate.getTime();
                logger.info("\u5f02\u5e38\u6210\u672c\u5904\u7406\u5f15\u5165\u5916\u90e8\u6570\u636e-\u7ed3\u675f\u8017\u65f6\uff1a" + time);
            }
            catch (IOException e) {
                logger.error("\u5f02\u5e38\u6210\u672c\u5904\u7406\u4e0a\u4f20\u5916\u90e8\u6587\u4ef6\u66f4\u65b0\u5931\u8d25", (Throwable)e);
                throw new KDException("book close Error");
            }
        }
    }

    private void loadXLSXFile(String fileUrl) throws IOException {
        InputStream inStream = null;
        HashMap<String, Integer> cellIndex = new HashMap<String, Integer>(16);
        boolean b = this.doCheckStandardCostAccount();
        if (b) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u5bfc\u5165\u6807\u51c6\u6210\u672c\u6cd5\u6570\u636e\uff0c\u8bf7\u5728\u201c\u7ba1\u7406\u4f1a\u8ba1\u4e91>\u6807\u51c6\u6210\u672c\u6838\u7b97>\u57fa\u7840\u6570\u636e\u201d\u4e2d\u7ef4\u62a4\u7269\u6599\u6807\u51c6\u6210\u672c\u540e\u91cd\u65b0\u6267\u884c\u66f4\u65b0\u64cd\u4f5c\u3002", (String)"ExpBillCostPlugin_39", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        try {
            Date curDate = new Date();
            FileService service = FileServiceFactory.getAttachmentFileService();
            inStream = service.getInputStream(fileUrl);
            long time = System.currentTimeMillis() - curDate.getTime();
            logger.info("loadXLSXFile\u8bfb\u53d6\u6587\u4ef6-\u8017\u65f6\uff1a" + time);
            CalImportSheetHandler sheetHandler = new CalImportSheetHandler();
            try (TraceSpan span = Tracer.create((String)((Object)((Object)this)).getClass().getName(), (String)"loadXLSXFile");){
                ExcelReader reader = new ExcelReader();
                reader.read(inStream, (SheetHandler)sheetHandler);
            }
            curDate = new Date();
            time = System.currentTimeMillis() - curDate.getTime();
            logger.info("loadXLSXFile\u89e3\u6790-\u8017\u65f6\uff1a" + time);
            Map<Integer, Map<Integer, String>> rowsMap = sheetHandler.getRows();
            Map<Integer, String> colIndexFieldNameMap = rowsMap.get(2);
            if (colIndexFieldNameMap == null) {
                return;
            }
            for (Map.Entry entry : colIndexFieldNameMap.entrySet()) {
                cellIndex.put(((String)entry.getValue()).replace(".", ""), (Integer)entry.getKey());
            }
            int lastRowIndex = rowsMap.size() - 1;
            StringBuilder stringBuilder = new StringBuilder();
            int lastColIndex = colIndexFieldNameMap.size();
            HashMap gatherMap = (HashMap)SerializationUtils.fromJsonString((String)this.getPageCache().get(this.GATHERDATAMAP), HashMap.class);
            if (gatherMap == null) {
                return;
            }
            try (TraceSpan span = Tracer.create((String)((Object)((Object)this)).getClass().getName(), (String)"updateViewValue");){
                this.getModel().beginInit();
                Set<String> ominBizObjectSet = SubEntityUtil.getOminBizObjectSet();
                int precision = Integer.parseInt(this.getPageCache().get(this.AMT_PRECISION));
                for (int k = 4; k <= lastRowIndex; ++k) {
                    ArrayList<String> valueList = new ArrayList<String>(16);
                    if (lastRowIndex <= 0) continue;
                    Map<Integer, String> curRow = rowsMap.get(k);
                    for (int i = 0; i < lastColIndex; ++i) {
                        String curRowColValue = curRow.get(i);
                        if (curRowColValue == null || curRowColValue.equals("")) {
                            valueList.add("");
                            continue;
                        }
                        valueList.add(curRowColValue);
                    }
                    int index = Integer.parseInt(((Integer)cellIndex.get("entry_id")).toString());
                    String gatherKey = valueList.get(index).toString();
                    if (gatherMap.get(gatherKey) != null) {
                        this.verificateAssign(gatherMap, gatherKey, k, cellIndex, valueList, ominBizObjectSet, precision);
                        continue;
                    }
                    stringBuilder.append(ResManager.loadKDString((String)"\u7b2c", (String)"ExpBillCostPlugin_22", (String)"fi-cal-formplugin", (Object[])new Object[0])).append(k + 1).append(ResManager.loadKDString((String)"\u884c\u5bfc\u5165\u6570\u636e\u4e0d\u5339\u914d\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"ExpBillCostPlugin_23", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                }
                this.getModel().endInit();
                if (stringBuilder.length() > 0) {
                    this.getView().showMessage(stringBuilder.toString());
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5916\u90e8\u6570\u636e\u5b8c\u6210\u3002", (String)"ExpBillCostPlugin_32", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                }
            }
        }
        catch (KDBizException e) {
            this.refreshPage();
            throw e;
        }
        catch (Exception e) {
            logger.error("\u5f02\u5e38\u6210\u672c\u5904\u7406\u5f15\u5165\u5916\u90e8\u6570\u636e\u62a5\u9519", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef", (String)"ExpBillCostPlugin_21", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }

    private void verificateAssign(HashMap gatherMap, String gatherKey, int k, Map<String, Integer> cellIndex, List valueList, Set<String> ominBizObjectSet, int precision) {
        int rowIndex = (Integer)gatherMap.get(gatherKey);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        DynamicObject row = (DynamicObject)entryEntity.get(rowIndex);
        BigDecimal qty = row.getBigDecimal(this.BASEQTY);
        DynamicObject info = this.getModel().getDataEntity().getDynamicObject(this.COSTACCOUNT);
        boolean isCostRecordDetail = ParamsHelper.getCostElementByCostAccount((long)info.getLong("id"));
        BigDecimal actualCost = (BigDecimal)this.getModel().getValue(this.ACTUALCOST, rowIndex);
        if (!isCostRecordDetail) {
            if (cellIndex.containsKey(MATERIALCOST) || cellIndex.containsKey(PROCESSCOST)) {
                if (cellIndex.containsKey(PROCESSCOST)) {
                    BigDecimal unitProcessCost;
                    BigDecimal processCost;
                    DynamicObject billType = row.getDynamicObject("billtype");
                    int isfpwf = row.getBoolean("isfpwf") ? 1 : 0;
                    if (ominBizObjectSet != null && !ominBizObjectSet.contains(billType.getString("billformid.number"))) {
                        processCost = row.getBigDecimal(PROCESSCOST);
                        unitProcessCost = row.getBigDecimal(UNITPROCESSCOST);
                        if (processCost.compareTo(this.getRowCostAmt(PROCESSCOST, cellIndex, valueList, k)) != 0) {
                            String content = String.format(ResManager.loadKDString((String)"\u975e\u59d4\u5916\u7c7b\u5355\u636e\u4e0d\u80fd\u5bfc\u5165\u52a0\u5de5\u8d39\uff0c\u7b2c%1$s\u884c\u5bfc\u5165\u6570\u636e\u52a0\u5de5\u8d39\u4e0d\u5339\u914d\uff0c\u4e0d\u80fd\u5f15\u5165", (String)"ExpBillCostPlugin_45", (String)"fi-cal-formplugin", (Object[])new Object[0]), k + 1);
                            throw new KDBizException(content);
                        }
                        if (unitProcessCost.compareTo(this.getRowCostAmt(UNITPROCESSCOST, cellIndex, valueList, k)) != 0) {
                            String content = String.format(ResManager.loadKDString((String)"\u975e\u59d4\u5916\u7c7b\u5355\u636e\u4e0d\u80fd\u5bfc\u5165\u5355\u4f4d\u52a0\u5de5\u8d39\uff0c\u7b2c%1$s\u884c\u5bfc\u5165\u6570\u636e\u5355\u4f4d\u52a0\u5de5\u8d39\u4e0d\u5339\u914d\uff0c\u4e0d\u80fd\u5f15\u5165", (String)"ExpBillCostPlugin_46", (String)"fi-cal-formplugin", (Object[])new Object[0]), k + 1);
                            throw new KDBizException(content);
                        }
                    } else if (isfpwf != 0) {
                        processCost = row.getBigDecimal(PROCESSCOST);
                        unitProcessCost = row.getBigDecimal(UNITPROCESSCOST);
                        if (processCost.compareTo(this.getRowCostAmt(PROCESSCOST, cellIndex, valueList, k)) != 0) {
                            String content = String.format(ResManager.loadKDString((String)"\u5df2\u53d1\u7968\u6838\u9500\u7684\u59d4\u5916\u5355\u636e\u4e0d\u80fd\u5bfc\u5165\u52a0\u5de5\u8d39\uff0c\u7b2c%1$s\u884c\u5bfc\u5165\u6570\u636e\u52a0\u5de5\u8d39\u4e0d\u5339\u914d\uff0c\u4e0d\u80fd\u5f15\u5165", (String)"ExpBillCostPlugin_47", (String)"fi-cal-formplugin", (Object[])new Object[0]), k + 1);
                            throw new KDBizException(content);
                        }
                        if (unitProcessCost.compareTo(this.getRowCostAmt(UNITPROCESSCOST, cellIndex, valueList, k)) != 0) {
                            String content = String.format(ResManager.loadKDString((String)"\u5df2\u53d1\u7968\u6838\u9500\u7684\u59d4\u5916\u5355\u636e\u4e0d\u80fd\u5bfc\u5165\u5355\u4f4d\u52a0\u5de5\u8d39\uff0c\u7b2c%1$s\u884c\u5bfc\u5165\u6570\u636e\u5355\u4f4d\u52a0\u5de5\u8d39\u4e0d\u5339\u914d\uff0c\u4e0d\u80fd\u5f15\u5165", (String)"ExpBillCostPlugin_48", (String)"fi-cal-formplugin", (Object[])new Object[0]), k + 1);
                            throw new KDBizException(content);
                        }
                    }
                }
                for (DynamicObject entryCostField : this.ENTRY_COST_FIELDS) {
                    if (!cellIndex.containsKey(entryCostField)) continue;
                    BigDecimal entryCost = (BigDecimal)this.getModel().getValue((String)entryCostField, rowIndex);
                    actualCost = actualCost.subtract(entryCost);
                    BigDecimal newEntryCost = this.importEntryCost((String)entryCostField, cellIndex, valueList, k, qty, rowIndex, Boolean.FALSE, precision);
                    actualCost = actualCost.add(newEntryCost);
                }
                this.getModel().setValue(this.UNITACTUALCOST, (Object)this.calUnitCostByAct(qty, actualCost), rowIndex);
                this.getModel().setValue(this.ACTUALCOST, (Object)actualCost, rowIndex);
                this.getView().updateView(this.UNITACTUALCOST, rowIndex);
                this.getView().updateView(this.ACTUALCOST, rowIndex);
            } else {
                BigDecimal newActCost = this.importEntryCost(this.ACTUALCOST, cellIndex, valueList, k, qty, rowIndex, Boolean.FALSE, precision);
                BigDecimal fee = (BigDecimal)this.getModel().getValue(FEE, rowIndex);
                BigDecimal processCost = (BigDecimal)this.getModel().getValue(PROCESSCOST, rowIndex);
                BigDecimal newMatCost = newActCost.subtract(fee).subtract(processCost);
                this.getModel().setValue(UNITMATERIALCOST, (Object)this.calUnitCostByAct(qty, newMatCost), rowIndex);
                this.getModel().setValue(MATERIALCOST, (Object)newMatCost, rowIndex);
                this.getView().updateView(UNITMATERIALCOST, rowIndex);
                this.getView().updateView(MATERIALCOST, rowIndex);
            }
        } else {
            DynamicObjectCollection costSubElements = this.getModel().getDataEntity().getDynamicObjectCollection(this.COSTSUBELEMENT);
            for (DynamicObject costSubElement : costSubElements) {
                DynamicObject costSubElementInfo = costSubElement.getDynamicObject("fbasedataid");
                String subEleNum = costSubElementInfo.getString("number").toLowerCase();
                DynamicObject subEleInfo = costSubElement.getDynamicObject("fbasedataid");
                String subType = subEleInfo.getString("type");
                boolean isfpwf = row.getBoolean("isfpwf");
                if (isfpwf && "005".equals(subType)) {
                    String costFieldName = subEleNum + "_cost";
                    String unitCostFieldName = subEleNum + "_unitcost";
                    BigDecimal processCost = row.getBigDecimal(costFieldName);
                    BigDecimal unitProcessCost = row.getBigDecimal(unitCostFieldName);
                    BigDecimal processCost_import = this.getRowCostAmt(costFieldName, cellIndex, valueList, k);
                    BigDecimal unitProcessCost_import = this.getRowCostAmt(unitCostFieldName, cellIndex, valueList, k);
                    if (processCost.compareTo(processCost_import) != 0) {
                        String content = String.format(ResManager.loadKDString((String)"\u5df2\u53d1\u7968\u6838\u9500\u7684\u59d4\u5916\u5355\u636e\u4e0d\u80fd\u5bfc\u5165\u52a0\u5de5\u8d39\uff0c\u7b2c%1$s\u884c\u5bfc\u5165\u6570\u636e\u52a0\u5de5\u8d39\u4e0d\u5339\u914d\uff0c\u4e0d\u80fd\u5f15\u5165", (String)"ExpBillCostPlugin_47", (String)"fi-cal-formplugin", (Object[])new Object[0]), k + 1);
                        throw new KDBizException(content);
                    }
                    if (unitProcessCost.compareTo(unitProcessCost_import) != 0) {
                        String content = String.format(ResManager.loadKDString((String)"\u5df2\u53d1\u7968\u6838\u9500\u7684\u59d4\u5916\u5355\u636e\u4e0d\u80fd\u5bfc\u5165\u5355\u4f4d\u52a0\u5de5\u8d39\uff0c\u7b2c%1$s\u884c\u5bfc\u5165\u6570\u636e\u5355\u4f4d\u52a0\u5de5\u8d39\u4e0d\u5339\u914d\uff0c\u4e0d\u80fd\u5f15\u5165", (String)"ExpBillCostPlugin_48", (String)"fi-cal-formplugin", (Object[])new Object[0]), k + 1);
                        throw new KDBizException(content);
                    }
                }
                if (!cellIndex.containsKey(subEleNum + "_cost") || !cellIndex.containsKey(subEleNum + "_unitcost")) continue;
                BigDecimal subEleCost = (BigDecimal)this.getModel().getValue(subEleNum + "_cost", rowIndex);
                actualCost = actualCost.subtract(subEleCost);
                BigDecimal newSubEleCost = this.importEntryCost(subEleNum, cellIndex, valueList, k, qty, rowIndex, Boolean.TRUE, precision);
                actualCost = actualCost.add(newSubEleCost);
            }
            this.getModel().setValue(this.UNITACTUALCOST, (Object)this.calUnitCostByAct(qty, actualCost), rowIndex);
            this.getModel().setValue(this.ACTUALCOST, (Object)actualCost, rowIndex);
            this.getView().updateView(this.UNITACTUALCOST, rowIndex);
            this.getView().updateView(this.ACTUALCOST, rowIndex);
        }
    }

    private BigDecimal importEntryCost(String fieldName, Map cellIndex, List xssfRowValue, int k, BigDecimal qty, int index, boolean isCostRecordDetail, int precision) {
        BigDecimal unitCost;
        String unitCostFieldName;
        String costFieldName = isCostRecordDetail ? fieldName + "_cost" : fieldName;
        BigDecimal cost = this.getRowCostAmt(costFieldName, cellIndex, xssfRowValue, k);
        if (cost.multiply(qty).compareTo(BigDecimal.ZERO) < 0) {
            String content = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u6570\u636e\u4e0d\u80fd\u5bfc\u5165\uff0c\u8bf7\u4fdd\u8bc1\u6570\u91cf\u4e0e\u5b9e\u9645\u6210\u672c\u6b63\u8d1f\u65b9\u5411\u4e00\u81f4\u3002", (String)"CalculateInCostPlugin_36", (String)"fi-cal-formplugin", (Object[])new Object[0]), k + 1);
            throw new KDBizException(content);
        }
        String string = unitCostFieldName = isCostRecordDetail ? fieldName + "_unitcost" : "unit" + fieldName;
        if (cost.compareTo(BigDecimal.ZERO) == 0) {
            unitCost = this.getRowCostAmt(unitCostFieldName, cellIndex, xssfRowValue, k);
            if (unitCost.compareTo(BigDecimal.ZERO) < 0) {
                String content = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u6570\u636e\u4e0d\u80fd\u5bfc\u5165\uff0c\u5355\u4f4d\u5b9e\u9645\u6210\u672c\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0\u3002", (String)"CalculateInCostPlugin_37", (String)"fi-cal-formplugin", (Object[])new Object[0]), k + 1);
                throw new KDBizException(content);
            }
            cost = unitCost.multiply(qty).setScale(precision, RoundingMode.HALF_UP);
        } else {
            unitCost = SubEntityUtil.calUnitCostByAct(qty, cost);
        }
        this.getModel().setValue(unitCostFieldName, (Object)unitCost, index);
        this.getModel().setValue(costFieldName, (Object)cost, index);
        this.getView().updateView(unitCostFieldName, index);
        this.getView().updateView(costFieldName, index);
        return cost;
    }

    private BigDecimal getRowCostAmt(String field, Map cellIndex, List xssfRowValue, int rowIndex) {
        int index = (Integer)cellIndex.get(field);
        BigDecimal value = BigDecimal.ZERO;
        try {
            String cost = xssfRowValue.get(index).toString();
            if (!"".equals(cost)) {
                value = new BigDecimal(xssfRowValue.get(index).toString());
            }
        }
        catch (Exception e) {
            String content = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u201c%2$s\u201d\u5b57\u6bb5\u6570\u636e\u503c\u683c\u5f0f\u9519\u8bef\uff0c\u5fc5\u987b\u662f\u6570\u5b57\u578b\u5185\u5bb9\u3002", (String)"ExpBillCostPlugin_221", (String)"fi-cal-formplugin", (Object[])new Object[0]), rowIndex);
            throw new KDBizException(content);
        }
        return value;
    }

    private BigDecimal calUnitCostByAct(BigDecimal qty, BigDecimal cost) {
        int precision = 10;
        BigDecimal unitCost = BigDecimal.ZERO;
        if (qty.compareTo(BigDecimal.ZERO) != 0) {
            unitCost = cost.divide(qty, precision, RoundingMode.HALF_UP);
        }
        return unitCost;
    }

    private void clickImportData() {
        boolean b = this.doCheckStandardCostAccount();
        if (b) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u5bfc\u5165\u6807\u51c6\u6210\u672c\u6cd5\u6570\u636e\uff0c\u8bf7\u5728\u201c\u7ba1\u7406\u4f1a\u8ba1\u4e91>\u6807\u51c6\u6210\u672c\u6838\u7b97>\u57fa\u7840\u6570\u636e\u201d\u4e2d\u7ef4\u62a4\u7269\u6599\u6807\u51c6\u6210\u672c\u540e\u91cd\u65b0\u6267\u884c\u66f4\u65b0\u64cd\u4f5c\u3002", (String)"ExpBillCostPlugin_39", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cal_importcostpriceset");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        QFilter q = new QFilter("priceobject", "=", (Object)"B");
        q.and("entityobject", "=", (Object)"cal_in_expbillcost");
        showParameter.getCustomParams().put("costpricefilter", q.toString());
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, this.BTNIMPORTDATA);
        showParameter.setCloseCallBack(callBack);
        this.getView().showForm(showParameter);
    }

    private boolean doCheckStandardCostAccount() {
        DynamicObjectCollection entity = this.getModel().getEntryEntity(this.ENTRYENTITY);
        boolean flag = false;
        if (entity != null) {
            for (DynamicObject row : entity) {
                String calaccounttype = row.getString("calaccounttype");
                if (calaccounttype == null || !AccountTypeEnum.STANDARDCOST.getValue().equals(calaccounttype)) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String sourceFldKey = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null && this.BTNIMPORTDATA.equals(sourceFldKey)) {
            Map param = (Map)returnData;
            String costPriceNumber = param.get("costprice") == null ? "" : (String)param.get("costprice");
            try {
                if ("".equals(costPriceNumber)) {
                    this.doImportData(null);
                } else {
                    this.doImportData(costPriceNumber);
                }
            }
            catch (KDBizException e) {
                this.getView().showErrorNotification(e.getMessage());
            }
        }
    }

    private void doImportData(String costPriceNumber) {
        DynamicObjectCollection entryRows = this.getModel().getEntryEntity(this.ENTRYENTITY);
        EntryGrid entryGrid = (EntryGrid)this.getControl(this.ENTRYENTITY);
        int[] indexs = entryGrid.getSelectRows();
        ArrayList<Long> entryIds = new ArrayList<Long>();
        ArrayList<Long> ids = new ArrayList<Long>();
        if (indexs == null || indexs.length == 0) {
            for (DynamicObject row : entryRows) {
                entryIds.add((Long)row.get("entryid"));
                ids.add(row.getLong("costrecordid"));
            }
            indexs = new int[entryRows.size()];
            for (int i = 0; i < indexs.length; ++i) {
                indexs[i] = i;
            }
        } else {
            for (int index : indexs) {
                entryIds.add((Long)this.getModel().getValue("entryid", index));
                ids.add((Long)this.getModel().getValue("costrecordid", index));
            }
        }
        if (entryIds.isEmpty() || ids.isEmpty()) {
            return;
        }
        QFilter priceSchemeFilter = new QFilter("priceobject", "=", (Object)"B");
        priceSchemeFilter.and("entityobject", "=", (Object)"cal_in_expbillcost");
        QFilter srcFilter = new QFilter("calorg", "=", ((DynamicObject)this.getModel().getValue("calorg")).getPkValue());
        srcFilter.and("costaccount", "=", ((DynamicObject)this.getModel().getValue("costaccount")).getPkValue());
        Map priceResultInfoMap = new CostPrice4Others().getPrice4MoveAddAverage(entryIds, priceSchemeFilter, ids.toArray(new Long[0]), costPriceNumber);
        if (priceResultInfoMap == null || priceResultInfoMap.isEmpty()) {
            return;
        }
        this.getModel().beginInit();
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue(this.COSTACCOUNT);
        boolean isCostRecordDetail = ParamsHelper.getCostElementByCostAccount((long)costAccount.getLong("id"));
        Long[] defaultElementIds = CostElementHelper.getDefaultMaterialElements();
        Long defaultMaterialElement = defaultElementIds[0];
        DynamicObjectCollection costSubElements = this.getModel().getDataEntity().getDynamicObjectCollection(this.COSTSUBELEMENT);
        int precision = Integer.parseInt(this.getPageCache().get(this.AMT_PRECISION));
        for (int i : indexs) {
            Long entryId = (Long)this.getModel().getValue("entryid", i);
            BigDecimal qty = (BigDecimal)this.getModel().getValue(this.BASEQTY, i);
            BigDecimal actualCost = (BigDecimal)this.getModel().getValue(this.ACTUALCOST, i);
            BigDecimal newUnitActualCost = BigDecimal.ZERO;
            CostPriceResultInfo priceResultInfo = (CostPriceResultInfo)priceResultInfoMap.get(entryId);
            if (priceResultInfo == null) continue;
            Map subEleUnitCostMap = priceResultInfo.getCostSubElementUnitcostMap();
            if (!isCostRecordDetail) {
                if (subEleUnitCostMap.isEmpty()) {
                    newUnitActualCost = (BigDecimal)priceResultInfo.getEntryUnitcostMap().get("unitactualcost");
                } else {
                    newUnitActualCost = BigDecimal.ZERO;
                    if (subEleUnitCostMap.containsKey(defaultMaterialElement)) {
                        newUnitActualCost = (BigDecimal)subEleUnitCostMap.get(defaultMaterialElement);
                    }
                }
                newUnitActualCost = newUnitActualCost == null ? BigDecimal.ZERO : newUnitActualCost;
                BigDecimal newActualCost = newUnitActualCost.multiply(qty).setScale(precision, RoundingMode.HALF_UP);
                BigDecimal diffcost = newActualCost.subtract(actualCost);
                BigDecimal oldMaterialCost = (BigDecimal)this.getModel().getValue(MATERIALCOST, i);
                BigDecimal newMaterialCost = oldMaterialCost.add(diffcost);
                this.getModel().setValue(UNITMATERIALCOST, (Object)this.calUnitCostByAct(qty, newMaterialCost), i);
                this.getModel().setValue(MATERIALCOST, (Object)newMaterialCost, i);
                this.getView().updateView(UNITMATERIALCOST, i);
                this.getView().updateView(MATERIALCOST, i);
                actualCost = newActualCost;
            }
            if (subEleUnitCostMap.isEmpty()) {
                BigDecimal unitCost = (BigDecimal)priceResultInfo.getEntryUnitcostMap().get("unitactualcost");
                unitCost = unitCost == null ? BigDecimal.ZERO : unitCost;
                subEleUnitCostMap.put(773175233367685120L, unitCost);
            }
            for (DynamicObject costSubElement : costSubElements) {
                DynamicObject info = costSubElement.getDynamicObject("fbasedataid");
                long subEleId = info.getLong("id");
                String subEleNum = info.getString("number");
                BigDecimal subEleUnitCost = BigDecimal.ZERO;
                if (subEleUnitCostMap.containsKey(subEleId)) {
                    subEleUnitCost = (BigDecimal)subEleUnitCostMap.get(subEleId);
                }
                BigDecimal subEleCost = subEleUnitCost.multiply(qty).setScale(precision, RoundingMode.HALF_UP);
                BigDecimal oldSubEleCost = (BigDecimal)this.getModel().getValue(subEleNum + "_cost", i);
                actualCost = actualCost.subtract(oldSubEleCost).add(subEleCost);
                this.getModel().setValue(subEleNum + "_unitcost", (Object)subEleUnitCost, i);
                this.getModel().setValue(subEleNum + "_cost", (Object)subEleCost, i);
                this.getView().updateView(subEleNum + "_unitcost", i);
                this.getView().updateView(subEleNum + "_cost", i);
            }
            this.getModel().setValue(this.ACTUALCOST, (Object)actualCost, i);
            if (newUnitActualCost != null && newUnitActualCost.signum() != 0) {
                this.getModel().setValue(this.UNITACTUALCOST, (Object)newUnitActualCost, i);
            } else {
                this.getModel().setValue(this.UNITACTUALCOST, (Object)this.calUnitCostByAct(qty, actualCost), i);
            }
            this.getView().updateView(this.ACTUALCOST, i);
            this.getView().updateView(this.UNITACTUALCOST, i);
        }
        this.getModel().endInit();
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        String opKey = event.getOperateKey();
        if ("expreview".equals(opKey)) {
            this.dojob();
        } else if ("expreviewall".equals(opKey)) {
            this.doJobAll();
        } else if ("ok".equals(opKey)) {
            this.beforeOKcheck();
            this.checkAcctIsNull();
            HashMap<String, Object> retValue = new HashMap<String, Object>();
            DynamicObject entity = this.getModel().getDataEntity();
            String policyID = entity.getDynamicObject("costaccount").getString("calpolicy.id");
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)policyID, (String)"cal_bd_calpolicy");
            DynamicObject currency = obj.getDynamicObject("currency");
            this.loadCurrency(currency);
            this.getPageCache().put(this.AMT_PRECISION, String.valueOf(currency.getInt("amtprecision")));
            this.getPageCache().put(this.PRICE_PRECISION, "10");
            retValue.put("filter", this.buildFilter());
            this.queryDataByFilter(retValue);
            ((Container)this.getControl("filterpanel")).setCollapse(true);
            DynamicObjectCollection costSubElements = entity.getDynamicObjectCollection(this.COSTSUBELEMENT);
            DynamicFieldCreateHelper.dynAddElementCostFields((DynamicObjectCollection)costSubElements, (IFormView)this.getView(), (String)"cal_in_expbillcost", (DynamicObject)currency);
            if (!costSubElements.isEmpty()) {
                int entryRowCount = this.getModel().getEntryRowCount("entryentity");
                for (int i = 0; i < entryRowCount; ++i) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{this.UNITACTUALCOST, this.ACTUALCOST});
                }
                return;
            }
            this.setEntityEnableAndVisible();
        } else if ("viewlog".equals(opKey)) {
            this.viewLog();
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new KDBizException(cloneNotSupportedException.getMessage());
        }
        EntryType entryType = (EntryType)newMainType.getAllEntities().get("entryentity");
        DynamicFieldCreateHelper.getEntryElement((IPageCache)this.getPageCache(), (String)"cal_in_expbillcost").registerEntryProp(entryType);
        e.setNewEntityType(newMainType);
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        EntryElement entryElement = DynamicFieldCreateHelper.getEntryElement((IPageCache)this.getPageCache(), (String)"cal_in_expbillcost");
        ArrayList<EntryElement> items = new ArrayList<EntryElement>(entryElement.getItems());
        items.add(entryElement);
        Optional<Element> first = items.stream().filter(x -> x.getName().equalsIgnoreCase(key)).findFirst();
        if (first.isPresent()) {
            Element element = first.get();
            Control control = element.getControl(this.getView());
            if (this.ENTRYENTITY.equals(key)) {
                EntryGrid entryGrid = (EntryGrid)control;
                entryGrid.addHyperClickListener((HyperLinkClickListener)this);
                e.setControl((Control)entryGrid);
                return;
            }
            e.setControl(control);
        }
    }

    private Map<String, Long[]> buildCostDetailMap(DynamicObjectCollection entityColl) {
        HashSet<Long> materialIdSet = new HashSet<Long>(32);
        long costTypeId = this.getCostTypeId();
        for (DynamicObject entryDyc : entityColl) {
            materialIdSet.add(entryDyc.getLong("materialid"));
        }
        DynamicObject calorgObj = (DynamicObject)this.getModel().getValue(this.CALORG);
        Map cosTypeMaterialMap = CostElementHelper.getCostElementsByMaterial((long)calorgObj.getLong("id"), (Long[])new Long[]{costTypeId}, (Long[])materialIdSet.toArray(new Long[materialIdSet.size()]));
        return cosTypeMaterialMap;
    }

    private Long getCostTypeId() {
        DynamicObject costTypeDynamic = (DynamicObject)this.getModel().getValue(this.COSTACCOUNT);
        return costTypeDynamic.getLong("costtype_id");
    }

    private StringBuilder check(List<Map<String, Object>> paramList) {
        int number;
        DynamicObject info;
        DynamicObject period;
        String billStatus;
        HashSet<Long> entryIdSet = new HashSet<Long>(50);
        HashSet<Long> bizBillIdSet = new HashSet<Long>(50);
        for (Map<String, Object> paramMap : paramList) {
            long entryId = (Long)paramMap.get("entryid");
            long bizBillId = (Long)paramMap.get("bizbillid");
            bizBillIdSet.add(bizBillId);
            entryIdSet.add(entryId);
        }
        QFilter q = new QFilter("entry.id", "in", entryIdSet);
        q.and("bizentityobject", "=", (Object)"im_saloutbill");
        q.and("isvoucher", "=", (Object)Character.valueOf('1'));
        q.and("bizbillid", "in", bizBillIdSet);
        StringBuilder errMsg = new StringBuilder(50);
        HashSet<Long> errEntryIdSet = new HashSet<Long>(16);
        String string = billStatus = paramList.get(0).get("billstatus") == null ? null : (String)paramList.get(0).get("billstatus");
        if (billStatus != null && "C".equals(billStatus)) {
            QFilter billStatusf = new QFilter("entry.entrystatus", "=", (Object)"C");
            q.and(billStatusf);
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"billno,entry.id", (QFilter[])new QFilter[]{q}, null);){
            for (Row row : dataSet) {
                String billNo = row.getString("billno");
                String msg = ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u4e3a\u9500\u552e\u51fa\u5e93\u5355\u7684\u6210\u672c\u8bb0\u5f55%1$s\uff0c\u5b58\u5728\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u5b50\u5355\u3002", (String)"ExpBillCostPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]);
                msg = String.format(msg, billNo);
                errMsg.append(msg);
                errEntryIdSet.add(row.getLong("entry.id"));
            }
        }
        if (!errEntryIdSet.isEmpty()) {
            for (int i = paramList.size() - 1; i >= 0; --i) {
                Map<String, Object> paramMap = paramList.get(i);
                long entryId = (Long)paramMap.get("entryid");
                if (!errEntryIdSet.contains(entryId)) continue;
                paramList.remove(i);
            }
        }
        if ((period = PeriodHelper.getCurrentPeriod((Long)(info = this.getModel().getDataEntity().getDynamicObject(this.COSTACCOUNT)).getLong("id"))) == null) {
            String content = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u672a\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"ExpBillCostPlugin_43", (String)"fi-cal-formplugin", (Object[])new Object[0]), info.getString("number"));
            throw new KDBizException(content);
        }
        int year = period.getInt("periodyear");
        int periodNumBefore = year * 100 + (number = period.getInt("periodnumber"));
        int periodNumAfter = this.getAfterPeriod(periodNumBefore);
        if (periodNumAfter < periodNumBefore) {
            for (int i = paramList.size() - 1; i >= 0; --i) {
                Map<String, Object> paramMap = paramList.get(i);
                String billNumber = (String)paramMap.get("billtype");
                Boolean isinitbill = (Boolean)paramMap.get("isinitbill");
                String billnum = (String)paramMap.get("billno");
                if ("im_SalOutBill_STD_BT_S".equals(billNumber) && isinitbill.booleanValue()) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u4e3a\u5f80\u671f\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"ExpBillCostPlugin_5", (String)"fi-cal-formplugin", (Object[])new Object[0]), billnum);
                errMsg.append(msg);
                paramList.remove(i);
            }
        }
        return errMsg;
    }

    private int getAfterPeriod(Integer periodNumBefore) {
        DynamicObject entity = this.getModel().getDataEntity();
        DynamicObject info = entity.getDynamicObject(this.COSTACCOUNT);
        if (info == null) {
            return periodNumBefore;
        }
        int yearNum = entity.getInt(this.YEAR);
        int periodNum = entity.getInt(this.PERIODNUM);
        int periodNumAfter = yearNum * 100 + periodNum;
        return periodNumAfter;
    }

    private void loadCurrency(DynamicObject currency) {
        this.getModel().beginInit();
        this.getModel().setValue("currency", (Object)currency);
        this.getModel().endInit();
        this.getView().updateView("currency");
    }

    private void queryDataByFilter(Map<String, Object> retValue) {
        if (retValue == null) {
            return;
        }
        QFilter filter = (QFilter)retValue.get("filter");
        this.getPageCache().put(this.QFILTER, filter.toSerializedString());
        this.loadDataByFilter(filter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        BigDecimal qty;
        IDataEntityProperty property = e.getProperty();
        String propertyName = property.getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        DynamicObjectCollection costSubElements = (DynamicObjectCollection)this.getModel().getValue(this.COSTSUBELEMENT);
        Set<String> costSubEleNumberSet = SubEntityUtil.getSubEleFieldNumSet(costSubElements);
        if (MATERIALCOST.equals(propertyName) || PROCESSCOST.equals(propertyName)) {
            this.getModel().beginInit();
            qty = new BigDecimal(this.getModel().getValue(this.BASEQTY, rowIndex).toString());
            BigDecimal newCost = (BigDecimal)changeData.getNewValue();
            String unitFileName = MATERIALCOST.equals(propertyName) ? UNITMATERIALCOST : UNITPROCESSCOST;
            this.getModel().setValue(unitFileName, (Object)this.calUnitCostByAct(qty, newCost), rowIndex);
            BigDecimal actualCost = (BigDecimal)this.getModel().getValue(this.ACTUALCOST, rowIndex);
            BigDecimal newActCost = actualCost.subtract((BigDecimal)changeData.getOldValue()).add(newCost);
            this.getModel().setValue(this.ACTUALCOST, (Object)newActCost, rowIndex);
            this.getModel().setValue(this.UNITACTUALCOST, (Object)this.calUnitCostByAct(qty, newActCost), rowIndex);
            this.getModel().endInit();
            this.getView().updateView(propertyName, rowIndex);
            this.getView().updateView(unitFileName, rowIndex);
            this.getView().updateView(this.ACTUALCOST, rowIndex);
            this.getView().updateView(this.UNITACTUALCOST, rowIndex);
        } else if (UNITMATERIALCOST.equals(propertyName) || UNITPROCESSCOST.equals(propertyName)) {
            this.getModel().beginInit();
            qty = new BigDecimal(this.getModel().getValue(this.BASEQTY, rowIndex).toString());
            BigDecimal newUnitCost = (BigDecimal)changeData.getNewValue();
            int precision = Integer.parseInt(this.getPageCache().get(this.AMT_PRECISION));
            String costFileName = UNITMATERIALCOST.equals(propertyName) ? MATERIALCOST : PROCESSCOST;
            BigDecimal oldCost = (BigDecimal)this.getModel().getValue(costFileName, rowIndex);
            BigDecimal newCost = newUnitCost.multiply(qty).setScale(precision, RoundingMode.HALF_UP);
            BigDecimal actualCost = (BigDecimal)this.getModel().getValue(this.ACTUALCOST, rowIndex);
            BigDecimal newActCost = actualCost.subtract(oldCost).add(newCost);
            this.getModel().setValue(this.ACTUALCOST, (Object)newActCost, rowIndex);
            this.getModel().setValue(this.UNITACTUALCOST, (Object)this.calUnitCostByAct(qty, newActCost), rowIndex);
            this.getModel().setValue(costFileName, (Object)newCost, rowIndex);
            this.getModel().endInit();
            this.getView().updateView(propertyName, rowIndex);
            this.getView().updateView(costFileName, rowIndex);
            this.getView().updateView(this.ACTUALCOST, rowIndex);
            this.getView().updateView(this.UNITACTUALCOST, rowIndex);
        } else if (this.ACTUALCOST.equals(propertyName)) {
            this.getModel().beginInit();
            qty = (BigDecimal)this.getModel().getValue(this.BASEQTY, rowIndex);
            BigDecimal fee = (BigDecimal)this.getModel().getValue(FEE, rowIndex);
            BigDecimal processCost = (BigDecimal)this.getModel().getValue(PROCESSCOST, rowIndex);
            BigDecimal newCost = (BigDecimal)changeData.getNewValue();
            BigDecimal newMatCost = newCost.subtract(fee).subtract(processCost);
            this.getModel().setValue(MATERIALCOST, (Object)newMatCost, rowIndex);
            this.getModel().setValue(UNITMATERIALCOST, (Object)this.calUnitCostByAct(qty, newMatCost), rowIndex);
            this.getModel().setValue(this.UNITACTUALCOST, (Object)this.calUnitCostByAct(qty, newCost), rowIndex);
            this.getModel().endInit();
            this.getView().updateView(propertyName, rowIndex);
            this.getView().updateView(this.UNITACTUALCOST, rowIndex);
            this.getView().updateView(MATERIALCOST, rowIndex);
            this.getView().updateView(UNITMATERIALCOST, rowIndex);
        } else if (this.UNITACTUALCOST.equals(propertyName)) {
            this.getModel().beginInit();
            qty = (BigDecimal)this.getModel().getValue(this.BASEQTY, rowIndex);
            int precision = Integer.parseInt(this.getPageCache().get(this.AMT_PRECISION));
            BigDecimal newUnitCost = (BigDecimal)changeData.getNewValue();
            BigDecimal newCost = newUnitCost.multiply(qty).setScale(precision, RoundingMode.HALF_UP);
            this.getModel().setValue(this.ACTUALCOST, (Object)newCost, rowIndex);
            BigDecimal fee = (BigDecimal)this.getModel().getValue(FEE, rowIndex);
            BigDecimal processCost = (BigDecimal)this.getModel().getValue(PROCESSCOST, rowIndex);
            BigDecimal newMatCost = newCost.subtract(fee).subtract(processCost);
            this.getModel().setValue(MATERIALCOST, (Object)newMatCost, rowIndex);
            this.getModel().setValue(UNITMATERIALCOST, (Object)this.calUnitCostByAct(qty, newMatCost), rowIndex);
            this.getModel().endInit();
            this.getView().updateView(propertyName, rowIndex);
            this.getView().updateView(this.ACTUALCOST, rowIndex);
            this.getView().updateView(MATERIALCOST, rowIndex);
            this.getView().updateView(UNITMATERIALCOST, rowIndex);
        } else if (this.COSTACCOUNT.equals(propertyName)) {
            this.costAccountChange();
        } else if ((this.YEAR.equals(propertyName) || this.PERIODNUM.equals(propertyName)) && !this.isPeriodChange) {
            DynamicObject entity = this.getModel().getDataEntity();
            DynamicObject info = entity.getDynamicObject(this.COSTACCOUNT);
            if (info == null) {
                return;
            }
            DynamicObject period = PeriodHelper.getCurrentPeriod((Long)info.getLong("id"));
            if (period != null) {
                int number;
                int year = period.getInt("periodyear");
                int periodNumBefore = year * 100 + (number = period.getInt("periodnumber"));
                int periodNumAfter = this.getAfterPeriod(periodNumBefore);
                if (periodNumAfter < periodNumBefore) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"btnreview"});
                    this.getView().setEnable(Boolean.FALSE, new String[]{"btnreviewall"});
                } else {
                    this.getView().setEnable(Boolean.TRUE, new String[]{"btnreview"});
                    this.getView().setEnable(Boolean.TRUE, new String[]{"btnreviewall"});
                }
            }
        } else if (this.MATERIALFROM.equals(propertyName)) {
            this.materialFromChange();
        }
        if (this.CALORG.equals(propertyName)) {
            this.calorgChange();
        } else if (this.BILLTYPEFILTER.equals(propertyName)) {
            this.getModel().beginInit();
            this.getModel().setValue(this.BDBIZTYPE, null);
            this.getModel().setValue(this.INVSCHEME, null);
            this.changeBillType();
            this.getModel().endInit();
            this.getView().updateView(this.BDBIZTYPE);
            this.getView().updateView(this.INVSCHEME);
        } else if (this.BDBIZTYPE.equals(propertyName)) {
            this.getModel().beginInit();
            this.getModel().setValue(this.INVSCHEME, null);
            this.getModel().endInit();
            this.getView().updateView(this.INVSCHEME);
        } else if (this.BIZTYPEFILTER.equals(propertyName)) {
            String accountTypes = (String)this.getModel().getValue(this.ACCOUNTTYPE);
            if (accountTypes != null && accountTypes.length() != 0) {
                String[] split;
                for (String accountTypeValue : split = accountTypes.split(",")) {
                    if (StringUtils.isEmpty((CharSequence)accountTypeValue) || AccountTypeEnum.STANDARDCOST.getValue().equals(accountTypeValue)) continue;
                    this.changeBizType();
                }
            } else {
                this.changeBizType();
            }
            this.changeBillType();
        } else if (this.BILLSTATUS.equals(propertyName)) {
            this.billStatusConnectAccountType(propertyName);
            String newBillStatus = (String)changeData.getNewValue();
            this.billStatusCostSubElement(newBillStatus);
        } else if (this.ACCOUNTTYPE.equals(propertyName)) {
            this.billStatusConnectAccountType(propertyName);
        } else if (this.STORAGEORGUNITFILTER.equals(propertyName)) {
            this.getModel().setValue(this.WAREHOUSEFILTER, null);
        } else if (this.WAREHOUSEFILTER.equals(propertyName)) {
            this.getModel().setValue(this.LOCATUINFILTER, null);
        } else if (this.COSTSUBELEMENT.equals(propertyName)) {
            this.costSubElementChange();
        } else if (costSubEleNumberSet.contains(propertyName)) {
            this.getModel().beginInit();
            int precision = Integer.parseInt(this.getPageCache().get(this.AMT_PRECISION));
            SubEntityUtil.subEleCostChange(propertyName, changeData, this.getModel(), precision, this.getView());
            this.getModel().endInit();
        }
    }

    private void billStatusCostSubElement(String newBillStatus) {
        if ("B".equals(newBillStatus)) {
            this.getModel().setValue(this.COSTSUBELEMENT, null);
            this.getView().setVisible(Boolean.FALSE, new String[]{this.COSTSUBELEMENT});
        } else if ("C".equals(newBillStatus)) {
            DynamicObject info = this.getModel().getDataEntity().getDynamicObject(this.COSTACCOUNT);
            if (info == null) {
                return;
            }
            boolean isCostRecordDetail = ParamsHelper.getCostElementByCostAccount((long)info.getLong("id"));
            if (isCostRecordDetail) {
                this.getView().setVisible(Boolean.TRUE, new String[]{this.COSTSUBELEMENT});
            }
        }
    }

    private void costSubElementChange() {
        DynamicObjectCollection costSubElements = (DynamicObjectCollection)this.getModel().getValue(this.COSTSUBELEMENT);
        int costSubElementMaxSize = CalDbParamServiceHelper.getInteger((String)"costsubelement_filter_max_size");
        if (costSubElements != null && costSubElements.size() > costSubElementMaxSize) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b50\u8981\u7d20\u6570\u91cf\u5927\u4e8e%s\uff0c\u8bf7\u52fe\u9009\u9700\u8981\u624b\u5de5\u7ef4\u62a4\u6210\u672c\u7684\u5b50\u8981\u7d20\u3002", (String)"CalculateInCostPlugin_47", (String)"fi-cal-formplugin", (Object[])new Object[0]), costSubElementMaxSize));
        }
    }

    private void changeBillType() {
        boolean flag = false;
        DynamicObjectCollection dynamicObjects = this.getModel().getDataEntity().getDynamicObjectCollection("billtypefilter");
        ArrayList<String> numberList = new ArrayList<String>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            numberList.add(dynamicObject.getDynamicObject("fbasedataid").getString("number"));
        }
        if (!numberList.isEmpty()) {
            QFilter filter = new QFilter("billformid", "in", SubEntityUtil.getOminBizObjectSet());
            filter.and("number", "in", numberList);
            DynamicObjectCollection collections = QueryServiceHelper.query((String)"bos_billtype", (String)"id", (QFilter[])new QFilter[]{filter});
            if (numberList.size() == collections.size()) {
                flag = true;
            }
        }
        String bizType = (String)this.getModel().getValue(this.BIZTYPEFILTER);
        if (flag || "OUT".equals(bizType)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"ispresentfilter"});
            if (!"OUT".equals(bizType)) {
                this.getModel().setValue("ispresentfilter", (Object)false);
            } else {
                this.getModel().setValue("ispresentfilter", (Object)true);
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"ispresentfilter"});
            this.getModel().setValue("ispresentfilter", (Object)false);
        }
        this.getView().updateView("ispresentfilter");
    }

    private void changeBizType() {
        String bizType = (String)this.getModel().getValue(this.BIZTYPEFILTER);
        if ("OUT".equals(bizType)) {
            this.getModel().setValue("ispresentfilter", (Object)this.trueValue);
            this.getView().setEnable(Boolean.valueOf(this.trueValue), new String[]{"ispresentfilter"});
        } else {
            this.getModel().setValue("ispresentfilter", (Object)this.falseValue);
            this.getView().setEnable(Boolean.valueOf(this.falseValue), new String[]{"ispresentfilter"});
        }
    }

    private void updateActually(BigDecimal cost, BigDecimal unitCost, int rowIndex) {
        this.getModel().beginInit();
        this.getModel().setValue(this.ACTUALCOST, (Object)cost, rowIndex);
        this.getModel().setValue(this.UNITACTUALCOST, (Object)unitCost, rowIndex);
        this.getModel().endInit();
        this.getView().updateView(this.ACTUALCOST, rowIndex);
        this.getView().updateView(this.UNITACTUALCOST, rowIndex);
    }

    private void calorgChange() {
        DynamicObject calorgObj = (DynamicObject)this.getModel().getValue(this.CALORG);
        this.getModel().setValue("mainorg", (Object)calorgObj);
        if (calorgObj == null) {
            this.getView().updateView("mainorg");
            return;
        }
        Long costAccountid = PeriodHelper.getCostAccountByCalOrgAndSysctrlentity((Long)calorgObj.getLong("id"));
        if (costAccountid != null) {
            this.getModel().setValue(this.COSTACCOUNT, (Object)costAccountid);
        } else {
            this.getModel().setValue(this.COSTACCOUNT, null);
        }
        this.getView().updateView("mainorg");
        this.getView().updateView(this.COSTACCOUNT);
        this.getModel().setValue(this.STORAGEORGUNITFILTER, null);
        this.getModel().setValue(this.OWNERFILTER, null);
        this.getModel().setValue(this.WAREHOUSEFILTER, null);
        this.getModel().setValue(this.LOCATUINFILTER, null);
        this.costAccountChange();
    }

    private void loadDataByFilter(QFilter filters) {
        QFilter costAccountFilter = this.getCostAccountBookdateFilter();
        EstimateAdjustInPurValidator validator = new EstimateAdjustInPurValidator();
        this.getView().setVisible(Boolean.TRUE, new String[]{"progressbarap"});
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.setPercent(0);
        this.getPageCache().put(PROGRESS_KEY, "15");
        bar.start();
        ThreadPools.executeOnceIncludeRequestContext((String)(((Object)((Object)this)).getClass().getName() + "loadDataByFilter"), () -> {
            try (DataSet detailDataset = null;){
                int period;
                DynamicObject dataEntity = this.getModel().getDataEntity();
                long costAccountId = dataEntity.getDynamicObject(this.COSTACCOUNT).getLong("id");
                boolean isCostRecordDetail = ParamsHelper.getCostElementByCostAccount((long)costAccountId);
                detailDataset = this.buildDetailData(filters, costAccountFilter, isCostRecordDetail);
                Map<String, Object> map = this.getBillStatusAndAccountType(this.getModel().getDataEntity());
                String billStatus = (String)map.get(this.BILLSTATUS);
                if (billStatus != null && billStatus.length() != 0) {
                    detailDataset = this.filterCal_BillAudit(detailDataset);
                }
                int year = this.getModel().getValue("year") == null ? 0 : (Integer)this.getModel().getValue("year");
                int n = period = this.getModel().getValue("periodnum") == null ? 0 : (Integer)this.getModel().getValue("periodnum");
                if (year > 0 && period > 0) {
                    detailDataset = validator.filterQueryData(detailDataset, year * 100 + period);
                }
                HashSet<Long> bizBillIds = new HashSet<Long>(16);
                HashSet<Long> bizBillEids = new HashSet<Long>(16);
                HashSet<Long> entryIdSet = new HashSet<Long>(16);
                for (Row row : detailDataset.copy()) {
                    Long bizBillId = row.getLong("bizbillid");
                    bizBillIds.add(bizBillId);
                    bizBillEids.add(row.getLong("entry.bizbillentryid"));
                    entryIdSet.add(row.getLong("entry.id"));
                }
                String wfRecordSels = "entry.billentryid wfbizbillentryid";
                QFilter bizBillIdsF = new QFilter("entry.billid", "in", bizBillIds);
                QFilter bizBillEidsF = new QFilter("entry.billentryid", "in", bizBillEids);
                String[] omBitype = CostRecordQFilterHelper.getBiztype((String)"ominbiztype");
                QFilter billTypeF = new QFilter("entry.billtype", "in", (Object)omBitype);
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_mdc_omwrfrecord", (String)wfRecordSels, (QFilter[])new QFilter[]{bizBillIdsF, bizBillEidsF, billTypeF}, null);
                DataSet inOsDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_oswfrecord", (String)wfRecordSels, (QFilter[])new QFilter[]{bizBillIdsF, bizBillEidsF, billTypeF}, null);
                DataSet wfRecordDs = dataSet.union(inOsDataSet).groupBy(new String[]{"wfbizbillentryid"}).finish();
                detailDataset = detailDataset.leftJoin(wfRecordDs).on("entry.bizbillentryid", "wfbizbillentryid").select(detailDataset.getRowMeta().getFieldNames(), wfRecordDs.getRowMeta().getFieldNames()).finish();
                long calOrgId = dataEntity.getDynamicObject(this.CALORG).getLong("id");
                Boolean estimateSetting = this.getEstimateSetting(calOrgId);
                this.getView().getPageCache().put("estimateSetting", estimateSetting.toString());
                if (estimateSetting.booleanValue()) {
                    detailDataset = detailDataset.filter("wfbizbillentryid is null");
                } else {
                    DataSet ominFPWFDs = this.queryOminFPWFEntryids(entryIdSet, costAccountFilter);
                    detailDataset = detailDataset.leftJoin(ominFPWFDs).on("entry.id", "entry.ancestorentryid").select(detailDataset.getRowMeta().getFieldNames(), ominFPWFDs.getRowMeta().getFieldNames()).finish();
                    detailDataset = detailDataset.filter((FilterFunction)new ExpBillCostFilterFunction());
                }
                if (isCostRecordDetail) {
                    DynamicObjectCollection costSubElement = this.getModel().getDataEntity().getDynamicObjectCollection(this.COSTSUBELEMENT);
                    Set<String> elementNumSet = this.getElementNumSet(costSubElement);
                    detailDataset = detailDataset.groupBy(new String[]{"entry.id"}).reduceGroup((ReduceGroupFunction)new ExpBillCostRowToColFunction(detailDataset.getRowMeta(), elementNumSet));
                }
                ExpBillCostMoveAvgWeightFilter filter = new ExpBillCostMoveAvgWeightFilter(this.getModel());
                detailDataset = filter.inTimeCalFilter(detailDataset);
                DataSet copy = detailDataset.copy();
                this.cacheQueryAndRefreshBizBillId(copy);
                CacheHint cacheHint = new CacheHint();
                Integer timeoutMin = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.EXPCOST_DATASET_TIMEOUT);
                cacheHint.setTimeout((long)timeoutMin.intValue(), TimeUnit.MINUTES);
                CachedDataSet cache = detailDataset.cache(cacheHint);
                String cacheId = cache.getCacheId();
                this.getPageCache().put("cacheId", cacheId);
            }
        });
    }

    private Boolean getEstimateSetting(Long calOrgId) {
        AppParam appParam = new AppParam("/KIUHEXROK3D", "10", calOrgId, Long.valueOf(0L));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"ap_estimation") == null ? Boolean.FALSE : (Boolean)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"ap_estimation");
    }

    private Set<String> getElementNumSet(DynamicObjectCollection costSubElement) {
        HashSet<String> elementNumSet = new HashSet<String>(16);
        for (DynamicObject info : costSubElement) {
            String number = info.getDynamicObject("fbasedataid").getString("number");
            elementNumSet.add(number);
        }
        return elementNumSet;
    }

    private DataSet filterCal_BillAudit(DataSet detailDataset) {
        Set<Long> ids;
        HashMap tableNameAndIds = new HashMap(16);
        for (Object row : detailDataset.copy()) {
            String string = row.getString("bizentityobject");
            Long preId = row.getLong("bizbillid");
            if (!tableNameAndIds.containsKey(string)) {
                ids = new HashSet(16);
                ids.add(preId);
                tableNameAndIds.put(string, ids);
                continue;
            }
            ids = (Set)tableNameAndIds.get(string);
            ids.add(preId);
        }
        ArrayList<OrmInput> orm = new ArrayList<OrmInput>(16);
        for (Map.Entry entry : tableNameAndIds.entrySet()) {
            String tableName = (String)entry.getKey();
            ids = (Set)entry.getValue();
            QFilter q = new QFilter("id", "in", ids);
            q.and(new QFilter("billstatus", "=", (Object)"C"));
            orm.add(new OrmInput(((Object)((Object)this)).getClass().getName(), tableName, "id,billstatus", new QFilter[]{q}));
        }
        HashSet<Long> legalPreIds = new HashSet<Long>(16);
        if (orm.size() != 0) {
            DataSet dataSet = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet((Input[])orm.toArray(new OrmInput[orm.size()]));
            for (Row row : dataSet) {
                Long preId = row.getLong("id");
                legalPreIds.add(preId);
            }
        }
        detailDataset = legalPreIds.size() > 0 ? detailDataset.filter(new QFilter("bizbillid", "in", legalPreIds).toString()) : detailDataset.filter(QFilter.of((String)"1!=1", (Object[])new Object[0]).toString());
        return detailDataset;
    }

    private DataSet buildDetailData(QFilter filters, QFilter costAccountFilter, boolean isCostRecordDetail) {
        QFilter billStatusf;
        Map<String, Object> map;
        String billStatus;
        StringBuilder fields = new StringBuilder();
        fields.append("id,calbillid,bizbillid,isinitbill,");
        fields.append("calorg.id,calorg.name,storageorgunit.id,storageorgunit.name,storageorgunit.number as storageorgunitnumber,");
        fields.append("costaccount.id,costaccount.name,costaccount.calsystem.id,costaccount.calsystem.name,costaccount.calpolicy.id,costaccount.calpolicy.name,");
        fields.append("billtype,billno,calbilltype,billstatus,bizdate,bookdate,localcurrency,localcurrency.priceprecision,localcurrency.amtprecision,writeofftype,");
        fields.append("entry.material.id,entry.material.name,entry.material.number as materialnumber,entry.material.modelnum,");
        fields.append("entry.assist,entry.lot as lot,entry.project,entry.project.number as projectnumber,entry.ispresent,");
        fields.append("entry.owner.id as ownerid,entry.owner.id,entry.ownertype,");
        fields.append("entry.warehouse.id,entry.warehouse.name,entry.warehouse.number as warehousenumber,");
        fields.append("entry.location.id,entry.location.name,entry.location.number as locationnumber,");
        fields.append("entry.baseunit.id,entry.baseunit.name,entry.baseunit.number as baseunitnumber,entry.baseqty,entry.unitactualcost,entry.actualcost,");
        fields.append("entry.manufacturecost,entry.resource,entry.id,entry.calentryid,entry.bizbillentryid,");
        fields.append("entry.materialcost,entry.fee,entry.processcost");
        fields.append(",calorg,costaccount.calsystem as calsystem,costaccount.calpolicy as calpolicy");
        fields.append(",entry.unitmaterialcost,entry.unitfee,entry.unitprocesscost");
        fields.append(",entry.calrange as calrange,entry.caldimension.caldimension as caldimensionstr");
        fields.append(",storageorgunit,entry.configuredcode as configuredcode,entry.assist as assist,entry.mversion as mversion");
        fields.append(",entry.tracknumber as tracknumber,entry.owner as owner,costaccount.id as costaccount,entry.material as material");
        fields.append(",entry.project as project,entry.location as location,entry.warehouse as warehouse");
        if (isCostRecordDetail) {
            fields.append(",entry.subentrycostelement.costsubelement.number as costsubelement,entry.subentrycostelement.sub_actualcost as sub_actualcost,entry.subentrycostelement.sub_unitactualcost as sub_unitactualcost");
        }
        if ("B".equals(billStatus = (String)(map = this.getBillStatusAndAccountType(this.getModel().getDataEntity())).get(this.BILLSTATUS))) {
            DynamicObject info = this.getModel().getDataEntity().getDynamicObject(this.COSTACCOUNT);
            DynamicObject accountDyc = BusinessDataServiceHelper.loadSingleFromCache((Object)info.getPkValue(), (String)"cal_bd_costaccount");
            String divStr = accountDyc.getString("dividebasis.dividebasis");
            String calDimensionStr = CommonSettingHelper.getCalDimensionStr();
            Set costRecordDim = Stream.of((divStr + "," + calDimensionStr).split(",")).filter(s -> !kd.bos.util.StringUtils.isEmpty((String)s)).collect(Collectors.toSet());
            costRecordDim.add("calrange");
            costRecordDim.add("material");
            MainEntityType costRecordEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costrecord");
            for (String allField : costRecordDim) {
                if (fields.indexOf(allField) != -1) continue;
                IDataEntityProperty iDataEntityProperty = costRecordEntityType.findProperty(allField);
                if (!(iDataEntityProperty.getParent() instanceof EntryType)) {
                    fields.append(",").append(allField).append(" as ").append(allField);
                    continue;
                }
                fields.append(",entry.").append(allField).append(" as ").append(allField);
            }
        }
        boolean trigger = false;
        String[] accountTypes = (String[])map.get(this.ACCOUNTTYPE);
        if (billStatus != null && billStatus.length() != 0) {
            trigger = true;
            fields.append(",bizentityobject,");
            fields.append("entry.standardcost as standardcost,");
            fields.append("entry.unitstandardcost as unitstandardcost,");
            fields.append("entry.accounttype as calaccounttype,");
            fields.append("billstatus as calbillstatus");
            if ("B".equals(billStatus)) {
                billStatusf = new QFilter("entry.entrystatus", "=", (Object)"B");
                if (CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.ENTRY_SPLIT_INTIME_CAL).booleanValue()) {
                    billStatusf.and(new QFilter("entry.ecalstatus", "=", (Object)CalStatusEnum.ERROR.getValue()));
                }
            } else {
                billStatusf = new QFilter("entry.entrystatus", "=", (Object)"C");
            }
            filters.and(billStatusf);
        } else {
            billStatusf = new QFilter("entry.entrystatus", "=", (Object)"C");
            filters.and(billStatusf);
        }
        if (accountTypes != null && accountTypes.length != 0) {
            if (!trigger) {
                fields.append(",bizentityobject,");
                fields.append("entry.standardcost as standardcost,");
                fields.append("entry.unitstandardcost as unitstandardcost,");
                fields.append("entry.accounttype as calaccounttype,");
                fields.append("billstatus as calbillstatus");
            }
            DynamicObject dataEntity = this.getModel().getDataEntity();
            boolean isLessPrice = dataEntity.getBoolean("islessprice");
            QFilter cur = QFilter.of((String)"1!=1", (Object[])new Object[0]);
            for (MainEntityType mainEntityType : accountTypes) {
                QFilter q = new QFilter("entry.accounttype", "in", (Object)mainEntityType);
                if (AccountTypeEnum.STANDARDCOST.getValue().equals(mainEntityType)) {
                    if (isLessPrice) {
                        q.and(new QFilter("entry.unitstandardcost", "<=", (Object)0));
                    }
                } else if (isLessPrice) {
                    q.and(new QFilter("entry.unitactualcost", "<=", (Object)0));
                }
                cur.or(q);
            }
            filters.and(cur);
        }
        Set<Long> entryIdSet = this.getEntryidSet(filters, costAccountFilter);
        List<Set<Long>> batchList = this.getBatchIdList(entryIdSet);
        ArrayList<OrmInput> billIOs = new ArrayList<OrmInput>(16);
        if (batchList != null && batchList.size() > 0) {
            for (Set set : batchList) {
                QFilter entryIdf = new QFilter("entry.id", "in", (Object)set);
                OrmInput ormInput = new OrmInput(((Object)((Object)this)).getClass() + "buildDetailData", "cal_costrecord_subentity", fields.toString(), new QFilter[]{entryIdf});
                billIOs.add(ormInput);
            }
        } else {
            QFilter entryIdf = QFilter.of((String)"1 <> 1", (Object[])new Object[0]);
            OrmInput ormInput = new OrmInput(((Object)((Object)this)).getClass() + "buildDetailData", "cal_costrecord_subentity", fields.toString(), new QFilter[]{entryIdf});
            billIOs.add(ormInput);
        }
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSet dataSet = algo.createDataSet((Input[])billIOs.toArray(new OrmInput[billIOs.size()]));
        return dataSet;
    }

    private Set<Long> getEntryidSet(QFilter filters, QFilter costAccountFilter) {
        HashSet<Long> entryidSet = new HashSet<Long>(16);
        DataSet idSet1DataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "loadDataByFilter"), (String)"cal_costrecord", (String)"id,entry.id", (QFilter[])new QFilter[]{filters}, (String)"");
        HashSet<Long> tempEntryidSet = new HashSet<Long>(16);
        for (Row row : idSet1DataSet) {
            Long entryid = row.getLong("entry.id");
            tempEntryidSet.add(entryid);
            if (tempEntryidSet.size() <= CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.QUERY_IN_SPRITSIZE)) continue;
            this.removeSpritedEntryids(tempEntryidSet, costAccountFilter);
            entryidSet.addAll(tempEntryidSet);
            tempEntryidSet = new HashSet(16);
        }
        if (tempEntryidSet.size() > 0) {
            this.removeSpritedEntryids(tempEntryidSet, costAccountFilter);
            entryidSet.addAll(tempEntryidSet);
        }
        return entryidSet;
    }

    private DataSet queryOminFPWFEntryids(Set<Long> entryidSet, QFilter costAccountFilter) {
        QFilter q = new QFilter("entry.ancestorentryid", "in", entryidSet);
        q.and("issplitcreate", "=", (Object)Character.valueOf('1'));
        q.and("writeoffstatus", "=", (Object)Character.valueOf('A'));
        q.and("writeofftype", "=", (Object)Character.valueOf('B'));
        q.and("ischargeoffed", "=", (Object)false);
        q.and("ischargeoff", "=", (Object)false);
        String[] ominBitype = CostRecordQFilterHelper.getBiztype((String)"ominbiztype");
        q.and("bizentityobject", "in", (Object)ominBitype);
        DataSet idSet2DataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "loadDataByFilter"), (String)"cal_costrecord", (String)"entry.ancestorentryid", (QFilter[])new QFilter[]{q, costAccountFilter}, (String)"");
        return idSet2DataSet;
    }

    private void removeSpritedEntryids(Set<Long> entryidSet, QFilter costAccountFilter) {
        if (!entryidSet.isEmpty()) {
            QFilter q = new QFilter("entry.ancestorentryid", "in", entryidSet);
            q.and("issplitcreate", "=", (Object)Character.valueOf('1'));
            q.and("writeoffstatus", "=", (Object)Character.valueOf('A'));
            q.and("writeofftype", "=", (Object)Character.valueOf('B'));
            q.and("ischargeoffed", "=", (Object)false);
            q.and("ischargeoff", "=", (Object)false);
            String[] purBitype = CostRecordQFilterHelper.getBiztype((String)"purbiztype");
            q.and("bizentityobject", "in", (Object)purBitype);
            DataSet idSet2DataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "loadDataByFilter"), (String)"cal_costrecord", (String)"id,entry.ancestorentryid", (QFilter[])new QFilter[]{q, costAccountFilter}, (String)"");
            HashSet<Long> entryidSet2 = new HashSet<Long>(16);
            for (Row row : idSet2DataSet) {
                Long ancestorentryid = row.getLong("entry.ancestorentryid");
                entryidSet2.add(ancestorentryid);
            }
            if (!entryidSet2.isEmpty()) {
                entryidSet.removeAll(entryidSet2);
            }
        }
    }

    private QFilter getCostAccountBookdateFilter() {
        String policyID;
        DynamicObject policyInfo;
        int periodNum;
        QFilter filter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject info = dataEntity.getDynamicObject(this.COSTACCOUNT);
        int yearNum = dataEntity.getInt(this.YEAR);
        DynamicObject period = PeriodHelper.getPeriodByNumber((int)yearNum, (int)(periodNum = dataEntity.getInt(this.PERIODNUM)), null, (long)(policyInfo = BusinessDataServiceHelper.loadSingle((Object)(policyID = info.getString("calpolicy.id")), (String)"cal_bd_calpolicy")).getDynamicObject("periodtype").getLong("id"));
        if (period == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u6b64\u671f\u95f4\uff0c\u8bf7\u68c0\u67e5\u671f\u95f4\u8bbe\u503c\u662f\u5426\u5408\u7406\u3002", (String)"ExpBillCostPlugin_35", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        boolean onlyIsInitBill = dataEntity.getBoolean(this.ONLYISINITBILL);
        if (onlyIsInitBill) {
            filter.and(new QFilter("isinitbill", "=", (Object)Character.valueOf('1')));
            filter.and("bookdate", "<=", (Object)period.getDate("enddate"));
            filter.and("period", "<=", period.get("id"));
        } else {
            filter.and("period", "=", period.get("id"));
            filter.and(new QFilter("isinitbill", "=", (Object)Character.valueOf('0')));
            filter.and("bookdate", ">=", (Object)period.getDate("beginDate"));
            filter.and("bookdate", "<=", (Object)period.getDate("enddate"));
        }
        return filter;
    }

    private void loadRowData(DataSet gatherDataset) {
        int rowCount;
        HashSet<String> accountTypeValues;
        IDataModel dataModel = this.getModel();
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        this.getModel().beginInit();
        model.deleteEntryData(this.ENTRYENTITY);
        TableValueSetter vs = this.getTableValueSetter();
        HashSet<Long> illegalBizBillIds = new HashSet<Long>(16);
        boolean isMoveOrFIFO = false;
        Map<String, Object> map = this.getBillStatusAndAccountType(this.getModel().getDataEntity());
        String[] accountTypes = (String[])map.get(this.ACCOUNTTYPE);
        String estimateSettingStr = this.getView().getPageCache().get("estimateSetting");
        Boolean estimateSetting = Boolean.valueOf(estimateSettingStr);
        if (accountTypes != null && ((accountTypeValues = new HashSet<String>(Arrays.asList(accountTypes))).contains(AccountTypeEnum.MOVE_ADD_AVERAGE.getValue()) || accountTypeValues.contains(AccountTypeEnum.FIN_FOUT.getValue()))) {
            isMoveOrFIFO = true;
            HashSet<Long> bizBillIds = new HashSet<Long>(16);
            HashMap<String, Set> form2BizbillIdMap = new HashMap<String, Set>(16);
            for (Row row : gatherDataset.copy()) {
                Long bizbillId = row.getLong("bizbillid") == null ? 0L : Long.parseLong(row.getLong("bizbillid").toString());
                String bizentityobject = row.getString("bizentityobject");
                bizBillIds.add(bizbillId);
                if (!StringUtils.isNotEmpty((CharSequence)bizentityobject)) continue;
                Set bizbillids = form2BizbillIdMap.computeIfAbsent(bizentityobject, k -> new HashSet(16));
                bizbillids.add(bizbillId);
            }
            boolean newGroupModel = AcctGroupModelHelper.isNewGroupModel();
            String selectField = newGroupModel ? "entryentity.calentryid" : "entryentity.billentryid";
            DataSet dataSet = null;
            if (AcctGroupModelHelper.isBizGroupModel()) {
                dataSet = new BizGroupRecordBuilder().getAllGroupRecordDataSetByBizBillIds(form2BizbillIdMap);
                dataSet = dataSet.filter("type = '1'").select("calentryid as entryentity.calentryid");
            } else {
                String tableName = newGroupModel ? "cal_account_grouprecord" : "cal_groupbillrecord";
                QFilter[] q = new QFilter[]{new QFilter("entryentity.bizbillid", "in", bizBillIds), new QFilter("entryentity.type", "=", (Object)"1")};
                dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)tableName, (String)selectField, (QFilter[])q, null);
            }
            for (Row row : dataSet) {
                illegalBizBillIds.add(row.getLong(selectField));
            }
        }
        HashMap<String, Integer> gaterhMap = new HashMap<String, Integer>(50);
        Row row = null;
        int rowIndex = 0;
        while (gatherDataset.hasNext()) {
            BigDecimal baseqty;
            row = gatherDataset.next();
            if (isMoveOrFIFO && illegalBizBillIds.contains(row.getLong("entry.calentryid"))) continue;
            this.loadRowData(row, vs, estimateSetting);
            rowCount = vs.getCount();
            if (rowCount >= 1000) {
                model.batchCreateNewEntryRow(this.ENTRYENTITY, vs);
                vs = this.getTableValueSetter();
            }
            if ((baseqty = row.getBigDecimal("entry.baseqty")).compareTo(BigDecimal.ZERO) == 0) continue;
            String gatherKey = row.getString("entry.id");
            gaterhMap.put(gatherKey, rowIndex);
            ++rowIndex;
        }
        rowCount = vs.getCount();
        if (rowCount > 0) {
            model.batchCreateNewEntryRow(this.ENTRYENTITY, vs);
        }
        this.getModel().endInit();
        this.getPageCache().put(this.GATHERDATAMAP, SerializationUtils.toJsonString(gaterhMap));
        this.getView().updateView(this.ENTRYENTITY);
    }

    private TableValueSetter getTableValueSetter() {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("billtype", new Object[0]);
        vs.addField("billno", new Object[0]);
        vs.addField("biztype", new Object[0]);
        vs.addField("bizdate", new Object[0]);
        vs.addField("bookdate", new Object[0]);
        vs.addField("isinitbill", new Object[0]);
        vs.addField("storageorgunit", new Object[0]);
        vs.addField("material", new Object[0]);
        vs.addField("materialentry", new Object[0]);
        vs.addField("materialid", new Object[0]);
        vs.addField("materialname", new Object[0]);
        vs.addField("ownertype", new Object[0]);
        vs.addField("owner", new Object[0]);
        vs.addField("auxproperty", new Object[0]);
        vs.addField("lot", new Object[0]);
        vs.addField("project", new Object[0]);
        vs.addField("ispresent", new Object[0]);
        vs.addField("warehouse", new Object[0]);
        vs.addField("location", new Object[0]);
        vs.addField("baseunit", new Object[0]);
        vs.addField(this.BASEQTY, new Object[0]);
        Map<String, Object> map = this.getBillStatusAndAccountType(this.getModel().getDataEntity());
        String billStatus = (String)map.get(this.BILLSTATUS);
        String[] accountType = (String[])map.get(this.ACCOUNTTYPE);
        vs.addField("actualcost", new Object[0]);
        if (this.getChosenAccountType(new ArrayList<String>(16)).contains(AccountTypeEnum.STANDARDCOST.getValue())) {
            vs.addField("unitstandardcost", new Object[0]);
            vs.addField("standardcost", new Object[0]);
        }
        if (billStatus != null || accountType != null && accountType.length != 0) {
            vs.addField("calaccounttype", new Object[0]);
        }
        vs.addField(this.UNITACTUALCOST, new Object[0]);
        vs.addField(UNITMATERIALCOST, new Object[0]);
        vs.addField(MATERIALCOST, new Object[0]);
        vs.addField(UNITFEE, new Object[0]);
        vs.addField(FEE, new Object[0]);
        vs.addField(UNITPROCESSCOST, new Object[0]);
        vs.addField(PROCESSCOST, new Object[0]);
        DynamicObjectCollection costSubElements = this.getModel().getDataEntity().getDynamicObjectCollection(this.COSTSUBELEMENT);
        for (DynamicObject costSubElement : costSubElements) {
            DynamicObject info = costSubElement.getDynamicObject("fbasedataid");
            String subEleNum = info.getString("number");
            vs.addField(subEleNum + "_unitcost", new Object[0]);
            vs.addField(subEleNum + "_cost", new Object[0]);
        }
        vs.addField("entryid", new Object[0]);
        vs.addField("costrecordid", new Object[0]);
        vs.addField("costaccountid", new Object[0]);
        vs.addField("bizentryid", new Object[0]);
        vs.addField("ownernumber", new Object[0]);
        vs.addField("warehousenumber", new Object[0]);
        vs.addField("locationnumber", new Object[0]);
        vs.addField("storageorgunitnumber", new Object[0]);
        vs.addField("calbillstatus", new Object[0]);
        vs.addField("bizentityobject", new Object[0]);
        vs.addField("bizbillid", new Object[0]);
        vs.addField("costrecordhead", new Object[0]);
        vs.addField("costrecordentry", new Object[0]);
        vs.addField("isclwf", new Object[0]);
        vs.addField("isfpwf", new Object[0]);
        return vs;
    }

    private List<String> getChosenAccountType(List<String> container) {
        Map<String, Object> map = this.getBillStatusAndAccountType(this.getModel().getDataEntity());
        String[] accountType = (String[])map.get(this.ACCOUNTTYPE);
        if (accountType != null) {
            container = new ArrayList<String>(Arrays.asList(accountType));
        }
        return container;
    }

    private void loadRowData(Row row, TableValueSetter vs, Boolean estimateSetting) {
        Object ancestorentryid;
        boolean isCostRecordDetail;
        String biztype = this.getBizType(row);
        List fields = vs.getFields();
        Object[] container = new Object[fields.size()];
        int index = 0;
        container[index++] = row.get("billtype");
        container[index++] = row.get("billno");
        container[index++] = biztype;
        container[index++] = row.get("bizdate");
        container[index++] = row.get("bookdate");
        container[index++] = row.get("isinitbill");
        container[index++] = row.get("storageorgunit.id");
        container[index++] = row.get("materialnumber");
        container[index++] = row.get("entry.material.id");
        container[index++] = row.get("entry.material.id");
        container[index++] = row.get("entry.material.name");
        container[index++] = row.get("entry.ownertype");
        container[index++] = this.getOwnerByCache(row.getLong("ownerid"), "name");
        container[index++] = row.get("entry.assist");
        container[index++] = row.get("lot");
        container[index++] = row.get("entry.project");
        container[index++] = row.get("entry.ispresent");
        container[index++] = row.get("entry.warehouse.id");
        container[index++] = row.get("entry.location.id");
        container[index++] = row.get("entry.baseunit.id");
        BigDecimal qty = row.getBigDecimal("entry.baseqty");
        container[index++] = qty;
        Map<String, Object> map = this.getBillStatusAndAccountType(this.getModel().getDataEntity());
        String billStatus = (String)map.get(this.BILLSTATUS);
        String[] accountType = (String[])map.get(this.ACCOUNTTYPE);
        container[index++] = row.getBigDecimal("entry.actualcost");
        if (this.getChosenAccountType(new ArrayList<String>(16)).contains(AccountTypeEnum.STANDARDCOST.getValue())) {
            container[index++] = row.getBigDecimal("unitstandardcost");
            container[index++] = row.getBigDecimal("standardcost");
        }
        if (billStatus != null || accountType != null && accountType.length != 0) {
            container[index++] = row.get("calaccounttype");
        }
        container[index++] = row.getBigDecimal("entry.unitactualcost");
        BigDecimal materialCost = row.getBigDecimal("entry.materialcost");
        BigDecimal fee = row.getBigDecimal("entry.fee");
        BigDecimal processCost = row.getBigDecimal("entry.processcost");
        BigDecimal unitMatCost = BigDecimal.ZERO;
        BigDecimal unitFee = BigDecimal.ZERO;
        BigDecimal unitProcessCost = BigDecimal.ZERO;
        if (qty.compareTo(BigDecimal.ZERO) != 0) {
            unitMatCost = materialCost.divide(qty, 10, RoundingMode.HALF_UP);
            unitFee = fee.divide(qty, 10, RoundingMode.HALF_UP);
            unitProcessCost = processCost.divide(qty, 10, RoundingMode.HALF_UP);
        }
        if (!(isCostRecordDetail = ParamsHelper.getCostElementByCostAccount((long)this.getModel().getDataEntity().getDynamicObject(this.COSTACCOUNT).getLong("id")))) {
            unitMatCost = row.getBigDecimal("entry.unitmaterialcost");
            unitFee = row.getBigDecimal("entry.unitfee");
            unitProcessCost = row.getBigDecimal("entry.unitprocesscost");
        }
        container[index++] = unitMatCost;
        container[index++] = materialCost;
        container[index++] = unitFee;
        container[index++] = fee;
        container[index++] = unitProcessCost;
        container[index++] = processCost;
        DynamicObjectCollection costSubElements = this.getModel().getDataEntity().getDynamicObjectCollection(this.COSTSUBELEMENT);
        for (DynamicObject costSubElement : costSubElements) {
            DynamicObject info = costSubElement.getDynamicObject("fbasedataid");
            String subEleNum = info.getString("number");
            BigDecimal subCost = row.getBigDecimal(subEleNum);
            BigDecimal unitSubCost = row.getBigDecimal(subEleNum + "_unitcost");
            container[index++] = unitSubCost;
            container[index++] = subCost;
        }
        container[index++] = row.get("entry.id");
        container[index++] = row.get("id");
        container[index++] = row.get("costaccount.id");
        container[index++] = row.get("entry.bizbillentryid");
        container[index++] = this.getOwnerByCache(row.getLong("ownerid"), "number");
        container[index++] = row.get("warehousenumber");
        container[index++] = row.get("locationnumber");
        container[index++] = row.get("storageorgunitnumber");
        container[index++] = row.get("calbillstatus");
        container[index++] = row.get("bizentityobject");
        container[index++] = row.get("bizbillid");
        container[index++] = row.get("id");
        container[index++] = row.get("entry.id");
        Object wfbizbillentryid = row.get("wfbizbillentryid");
        container[index++] = wfbizbillentryid != null ? Boolean.TRUE : Boolean.FALSE;
        container[index] = estimateSetting != false ? Boolean.FALSE : ((ancestorentryid = row.get("entry.ancestorentryid")) != null ? Boolean.TRUE : Boolean.FALSE);
        vs.addRow(container);
    }

    private String getBizType(Row row) {
        String biztype = row.get("calbilltype").toString();
        biztype = biztype.equals("IN") ? ResManager.loadKDString((String)"\u5165\u5e93", (String)"ExpBillCostPlugin_8", (String)"fi-cal-formplugin", (Object[])new Object[0]) : (biztype.equals("OUT") ? ResManager.loadKDString((String)"\u51fa\u5e93", (String)"ExpBillCostPlugin_9", (String)"fi-cal-formplugin", (Object[])new Object[0]) : biztype);
        return biztype;
    }

    private long getOwnerByCache(Long ownerid, String colName) {
        if (null == ownerid || ownerid == 0L) {
            return 0L;
        }
        String ownerkey = ownerid.toString();
        DynamicObject owner = this.ownerMap.get(ownerkey);
        if (null == owner) {
            owner = BusinessDataServiceHelper.loadSingle((Object)ownerid, (String)"bos_org", (String)"id,name,number");
            this.ownerMap.put(ownerkey, owner);
        }
        return owner.getLong("id");
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        for (String str : f7Name) {
            BasedataEdit f7Control = (BasedataEdit)this.getView().getControl(str);
            if (null == f7Control) continue;
            f7Control.addBeforeF7SelectListener(form);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initCalorgAndCostAccount();
        ((Container)this.getControl("filterpanel")).setCollapse(this.falseValue);
        this.getModel().setValue("islessprice", (Object)Character.valueOf('1'));
    }

    private void initCalorgAndCostAccount() {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        Long userOrgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_in_expbillcost");
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (params.get("cus_costaccount") != null && params.get("cus_orgid") != null) {
            this.getModel().setValue(this.CALORG, (Object)Long.valueOf(params.get("cus_orgid").toString()));
            this.getModel().setValue("mainorg", (Object)Long.valueOf(params.get("cus_orgid").toString()));
            this.getModel().setValue(this.COSTACCOUNT, (Object)Long.valueOf(params.get("cus_costaccount").toString()));
            this.costAccountChange();
        } else if (calOrgId != null && calOrgId != 0L) {
            this.getModel().setValue(this.CALORG, (Object)calOrgId);
            this.getModel().setValue("mainorg", (Object)calOrgId);
            Long costAccountid = PeriodHelper.getCostAccountByCalOrgAndSysctrlentity((Long)calOrgId);
            if (costAccountid != null) {
                this.getModel().setValue(this.COSTACCOUNT, (Object)costAccountid);
                this.costAccountChange();
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String sourceID = event.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        if (this.COSTACCOUNT.equals(sourceID)) {
            DynamicObject calOrg = this.getModel().getDataEntity().getDynamicObject(this.CALORG);
            if (calOrg == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ExpBillCostPlugin_10", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
            Set endInitCostAccountIds = PeriodHelper.getEndInitCostAccountByCalOrg((Long)calOrg.getLong("id"));
            QFilter qf = new QFilter("id", "=", (Object)-1L);
            if (endInitCostAccountIds != null && !endInitCostAccountIds.isEmpty()) {
                qf = new QFilter("id", "in", (Object)endInitCostAccountIds);
                qf.and("enable", "=", (Object)"1");
            }
            showParameter.getListFilterParameter().setFilter(qf);
        } else if (this.STORAGEORGUNITFILTER.equals(sourceID)) {
            DynamicObject calOrg = this.getModel().getDataEntity().getDynamicObject(this.CALORG);
            List storageOrgIdList = new ArrayList();
            if (null != calOrg) {
                storageOrgIdList = OrgHelper.getStorageOrgUnitByCalOrg((Long)calOrg.getLong("id"));
            }
            QFilter qf = new QFilter("id", "in", storageOrgIdList);
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            qFilters.clear();
            qFilters.add(qf);
        } else if (this.WAREHOUSEFILTER.equals(sourceID)) {
            DynamicObjectCollection storageOrgs = this.getModel().getDataEntity().getDynamicObjectCollection(this.STORAGEORGUNITFILTER);
            ArrayList<Long> ids = new ArrayList<Long>();
            if (storageOrgs != null && storageOrgs.size() > 0) {
                for (DynamicObject org : storageOrgs) {
                    String orgNumber = org.getDynamicObject("fbasedataid").getString("number");
                    Long[] tid = SCMHelper.getAllWarehouseIDs((String)orgNumber);
                    if (tid == null || tid.length <= 0) continue;
                    for (Long id : tid) {
                        ids.add(id);
                    }
                }
            }
            Iterator qf = new QFilter("id", "in", ids);
            showParameter.setUseOrgId(0L);
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            qFilters.clear();
            qFilters.add(qf);
        } else if (this.LOCATUINFILTER.equals(sourceID)) {
            DynamicObjectCollection warehouses = this.getModel().getDataEntity().getDynamicObjectCollection(this.WAREHOUSEFILTER);
            ArrayList<Long> ids = new ArrayList<Long>();
            if (warehouses != null && warehouses.size() > 0) {
                for (DynamicObject warehs : warehouses) {
                    DynamicObject warehousesCol = warehs.getDynamicObject("fbasedataid");
                    this.getLoactionIds(warehousesCol, ids);
                }
            }
            Iterator qf = new QFilter("id", "in", ids);
            showParameter.getListFilterParameter().setFilter((QFilter)qf);
        } else if (this.OWNERFILTER.equals(sourceID)) {
            DynamicObject costAccount = (DynamicObject)this.getModel().getValue(this.COSTACCOUNT);
            QFilter q = new QFilter("id", "=", (Object)-1L);
            if (costAccount != null) {
                q = new QFilter("id", "in", (Object)AccountingSysHelper.getOwners((Long)costAccount.getLong("id")));
            }
            ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().setFilter(q);
        } else if (this.CALORG.equals(sourceID)) {
            long userId = Long.parseLong(RequestContext.get().getUserId());
            List calorgList = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_in_expbillcost", (String)"47150e89000000ac");
            if (calorgList != null) {
                QFilter qf = new QFilter("id", "in", (Object)calorgList);
                showParameter.getListFilterParameter().setFilter(qf);
            }
        } else if (this.BILLTYPEFILTER.equals(sourceID)) {
            List numList = CostRecordQFilterHelper.getMatchBilltype((String)"billtypematch");
            QFilter qf = new QFilter("id", "in", (Object)numList);
            showParameter.getListFilterParameter().setFilter(qf);
        } else if (this.BDBIZTYPE.equals(sourceID)) {
            DynamicObjectCollection billType = this.getModel().getDataEntity().getDynamicObjectCollection(this.BILLTYPEFILTER);
            Set<Object> pkSet = this.getMulDataPK(billType);
            HashSet bizTypeIds = new HashSet();
            for (Object o : pkSet) {
                Map<Long, JSONObject> bizTypeMap = this.getBizTypeByBillTypeparameterId(Long.valueOf(o.toString()));
                for (JSONObject value : bizTypeMap.values()) {
                    Map map = (Map)value.toJavaObject(Map.class);
                    Set biztypeids = map.get("biztypeids") == null ? new HashSet() : (Set)map.get("biztypeids");
                    long defaultbiztypeid = map.get("defaultbiztypeid") == null ? 0L : Long.parseLong((String)map.get("defaultbiztypeid"));
                    bizTypeIds.addAll(biztypeids);
                    bizTypeIds.add(defaultbiztypeid);
                }
            }
            QFilter qFilter = new QFilter("id", "in", bizTypeIds);
            showParameter.getListFilterParameter().setFilter(qFilter);
        } else if (this.INVSCHEME.equals(sourceID)) {
            Set<Object> bizTypIdSet;
            DynamicObjectCollection billType = this.getModel().getDataEntity().getDynamicObjectCollection(this.BILLTYPEFILTER);
            Set<Object> pkSet = this.getMulDataPK(billType);
            Set<String> bizTypeNumber = this.getBizTypeBybillType(pkSet);
            DynamicObjectCollection bizType = (DynamicObjectCollection)this.getModel().getValue(this.BDBIZTYPE);
            QFilter qFilter = new QFilter("enable", "=", (Object)this.trueValue);
            if (!bizTypeNumber.isEmpty()) {
                qFilter.and("billform", "in", bizTypeNumber);
            }
            if (!(bizTypIdSet = this.getMulDataPK(bizType)).isEmpty()) {
                qFilter.and("bitypeentry.biztype", "in", bizTypIdSet);
            }
            showParameter.getListFilterParameter().setFilter(qFilter);
        } else if (this.MATERIALFROM.equals(sourceID) || "materialto".equals(sourceID)) {
            ReportF7Helper.beforeF7Select4Material((BeforeF7SelectEvent)event);
        }
    }

    public Map<Long, JSONObject> getBizTypeByBillTypeparameterId(Long billTypeId) {
        StringBuilder sql = new StringBuilder();
        sql.append(SQL);
        sql.append(billTypeId);
        HashMap<Long, JSONObject> result = new HashMap<Long, JSONObject>();
        DataSet ds = DB.queryDataSet((String)"getBizTypeByBillTypeparameterId", (DBRoute)DBRoute.basedata, (String)sql.toString());
        for (Row row : ds) {
            String fdata = row.getString("FDATA");
            if (StringUtils.isEmpty((CharSequence)fdata)) continue;
            Map map = (Map)JSON.parseObject((String)fdata, Map.class);
            if (map.get("entryentity") == null) {
                result.put(billTypeId, new JSONObject());
                return result;
            }
            JSONArray arrays = JSON.parseArray((String)map.get("entryentity").toString());
            if (map == null || arrays == null || arrays.size() <= 0) continue;
            JSONObject rs = new JSONObject();
            JSONArray bizTypes = new JSONArray();
            for (Object obj : arrays) {
                JSONObject data = JSONObject.parseObject((String)obj.toString());
                if ("true".equals(data.getString("isdefault"))) {
                    rs.put("defaultbiztypeid", (Object)data.getString("biztypenumber_id"));
                }
                if (data.getLong("biztypenumber_id") == null || data.getLong("biztypenumber_id") == 0L) continue;
                bizTypes.add((Object)data.getLong("biztypenumber_id"));
            }
            if (bizTypes.size() > 0) {
                Map bts = BusinessDataServiceHelper.loadFromCache((String)"bd_biztype", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)Character.valueOf('1')), new QFilter("id", "in", (Object)bizTypes)});
                if (bts != null && bts.size() > 0) {
                    HashSet<Long> ids = new HashSet<Long>(bts.size());
                    for (Map.Entry m : bts.entrySet()) {
                        ids.add(Long.parseLong(m.getKey().toString()));
                    }
                    rs.put("biztypeids", ids);
                    if (!StringUtils.isEmpty((CharSequence)rs.getString("defaultbiztypeid")) && !ids.contains(Long.parseLong(rs.getString("defaultbiztypeid")))) {
                        rs.remove((Object)"defaultbiztypeid");
                    }
                } else {
                    rs.remove((Object)"defaultbiztypeid");
                }
            }
            result.put(billTypeId, rs);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onProgress(ProgressEvent progressEvent) {
        block15: {
            String cacheId = this.getPageCache().get("cacheId");
            String progress = this.getPageCache().get(PROGRESS_KEY);
            progress = StringUtils.isEmpty((CharSequence)progress) ? "15" : progress;
            int progressPercent = Integer.parseInt(progress);
            progressEvent.setProgress(progressPercent);
            if (!StringUtils.isEmpty((CharSequence)cacheId)) {
                ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
                bar.stop();
                if (cacheId.contains(this.exPreStr)) {
                    progressEvent.setProgress(100);
                    this.getPageCache().put(PROGRESS_KEY, "100");
                    this.getView().showErrorNotification(cacheId.replace(this.exPreStr, ""));
                    this.getPageCache().remove("cacheId");
                    return;
                }
                progressEvent.setProgress(70);
                this.getPageCache().put(PROGRESS_KEY, "70");
                try {
                    DataSet gatherDataset = Algo.getCacheDataSet((String)cacheId).toDataSet(Algo.create((String)((Object)((Object)this)).getClass().getName()), true);
                    if (gatherDataset.copy().count("id", false) > 100000) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u8d85\u8fc7%1$s\u884c\uff0c\u4ec5\u663e\u793a%2$s\u884c\u6570\u636e", (String)"ExpBillCostPlugin_49", (String)"fi-cal-formplugin", (Object[])new Object[0]), 100000, 100000));
                        gatherDataset = gatherDataset.limit(0, 100000);
                    }
                    this.getModel().beginInit();
                    this.loadRowData(gatherDataset);
                    this.getModel().endInit();
                    this.setBillStatusAccountTypeVisable();
                    this.setEntityEnableAndVisible();
                    this.getView().updateView("entryentity");
                }
                catch (Throwable e) {
                    try {
                        this.getView().showErrMessage("", ExceptionUtils.getExceptionStackTraceMessage((Exception)new Exception(e)));
                    }
                    catch (Throwable throwable) {
                        this.getPageCache().remove("cacheId");
                        progressEvent.setProgress(100);
                        this.getPageCache().put(PROGRESS_KEY, "100");
                        if (progressEvent.getProgress() == 100) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e2) {
                                logger.error((Throwable)e2);
                            }
                            this.getView().setVisible(Boolean.FALSE, new String[]{"progressbarap"});
                        }
                        throw throwable;
                    }
                    this.getPageCache().remove("cacheId");
                    progressEvent.setProgress(100);
                    this.getPageCache().put(PROGRESS_KEY, "100");
                    if (progressEvent.getProgress() != 100) break block15;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e3) {
                        logger.error((Throwable)e3);
                    }
                    this.getView().setVisible(Boolean.FALSE, new String[]{"progressbarap"});
                }
                this.getPageCache().remove("cacheId");
                progressEvent.setProgress(100);
                this.getPageCache().put(PROGRESS_KEY, "100");
                if (progressEvent.getProgress() == 100) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        logger.error((Throwable)e);
                    }
                    this.getView().setVisible(Boolean.FALSE, new String[]{"progressbarap"});
                }
            }
        }
    }

    private void setEntityEnableAndVisible() {
        int entryRowCount;
        DynamicObject info = this.getModel().getDataEntity().getDynamicObject(this.COSTACCOUNT);
        DynamicObjectCollection costSubElements = this.getModel().getDataEntity().getDynamicObjectCollection(this.COSTSUBELEMENT);
        boolean isCostRecordDetail = ParamsHelper.getCostElementByCostAccount((long)info.getLong("id"));
        if (isCostRecordDetail) {
            this.getView().setVisible(Boolean.FALSE, new String[]{UNITMATERIALCOST, MATERIALCOST, UNITFEE, FEE, UNITPROCESSCOST, PROCESSCOST});
            entryRowCount = this.getModel().getEntryRowCount("entryentity");
            String billStatus = this.getModel().getDataEntity().getString(this.BILLSTATUS);
            for (int i = 0; i < entryRowCount; ++i) {
                if ("B".equals(billStatus)) {
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{this.UNITACTUALCOST, this.ACTUALCOST});
                } else {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{this.UNITACTUALCOST, this.ACTUALCOST});
                }
                if (!this.getChosenAccountType(new ArrayList<String>(16)).contains("D")) continue;
                HashSet<String> nEnableSub = new HashSet<String>(16);
                for (DynamicObject costSubElement : costSubElements) {
                    DynamicObject subEleInfo = costSubElement.getDynamicObject("fbasedataid");
                    String number = subEleInfo.getString("number").toLowerCase();
                    nEnableSub.add(number + "_cost");
                    nEnableSub.add(number + "_unitcost");
                }
                this.getView().setEnable(Boolean.FALSE, i, nEnableSub.toArray(new String[0]));
            }
        } else if (this.getChosenAccountType(new ArrayList<String>(16)).contains("D")) {
            entryRowCount = this.getModel().getEntryRowCount("entryentity");
            for (int i = 0; i < entryRowCount; ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{this.UNITACTUALCOST, this.ACTUALCOST, UNITMATERIALCOST, MATERIALCOST, UNITFEE, FEE, UNITPROCESSCOST, PROCESSCOST});
            }
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{UNITMATERIALCOST, MATERIALCOST, UNITFEE, FEE, UNITPROCESSCOST, PROCESSCOST});
        }
        DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
        int row = entity.size();
        Set<String> ominBizObjectSet = SubEntityUtil.getOminBizObjectSet();
        String estimateSettingStr = this.getView().getPageCache().get("estimateSetting");
        Boolean estimateSetting = Boolean.valueOf(estimateSettingStr);
        for (int i = 0; i < row; ++i) {
            boolean isPresent = this.getModel().getValue("ispresent", i) == null ? false : (Boolean)this.getModel().getValue("ispresent", i);
            DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype", i);
            if (ominBizObjectSet == null) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{UNITPROCESSCOST, PROCESSCOST});
                continue;
            }
            if (billType == null) continue;
            if (!ominBizObjectSet.contains(billType.getString("billformid.number"))) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{UNITPROCESSCOST, PROCESSCOST});
                continue;
            }
            if (estimateSetting.booleanValue()) {
                if (isCostRecordDetail) {
                    this.setSubEnableByType("005", costSubElements, i);
                } else {
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{UNITMATERIALCOST, MATERIALCOST});
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{UNITPROCESSCOST, PROCESSCOST});
                }
                if (!isPresent) continue;
                this.getView().setEnable(Boolean.FALSE, i, new String[]{UNITPROCESSCOST, PROCESSCOST});
                continue;
            }
            Boolean isclwf = (Boolean)this.getModel().getValue("isclwf", i);
            Boolean isfpwf = (Boolean)this.getModel().getValue("isfpwf", i);
            if (isCostRecordDetail) {
                if (isclwf.booleanValue() && !isfpwf.booleanValue()) {
                    this.setSubEnableByType("001", costSubElements, i);
                } else if (!isclwf.booleanValue() && isfpwf.booleanValue()) {
                    this.setSubEnableByType("005", costSubElements, i);
                }
                if (!isPresent) continue;
                this.setSubEnableByType("005", costSubElements, i);
                continue;
            }
            if (isclwf.booleanValue() && !isfpwf.booleanValue()) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{UNITMATERIALCOST, MATERIALCOST});
                this.getView().setEnable(Boolean.TRUE, i, new String[]{UNITPROCESSCOST, PROCESSCOST});
            } else if (!isclwf.booleanValue() && isfpwf.booleanValue()) {
                this.getView().setEnable(Boolean.TRUE, i, new String[]{UNITMATERIALCOST, MATERIALCOST});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{UNITPROCESSCOST, PROCESSCOST});
            }
            if (!isPresent) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{UNITPROCESSCOST, PROCESSCOST});
        }
    }

    private void setSubEnableByType(String type, DynamicObjectCollection costSubElements, int i) {
        HashSet<String> nEnableSub = new HashSet<String>(16);
        for (DynamicObject costSubElement : costSubElements) {
            DynamicObject subEleInfo = costSubElement.getDynamicObject("fbasedataid");
            String subType = subEleInfo.getString("type");
            if (!type.equals(subType)) continue;
            String number = subEleInfo.getString("number").toLowerCase();
            nEnableSub.add(number + "_cost");
            nEnableSub.add(number + "_unitcost");
        }
        this.getView().setEnable(Boolean.FALSE, i, nEnableSub.toArray(new String[0]));
    }

    private Set<String> getBizTypeBybillType(Set<Object> pkSet) {
        DynamicObjectCollection biztypeCollect = QueryServiceHelper.query((String)"bos_billtype", (String)"billformid.number", (QFilter[])new QFilter("id", "in", pkSet).toArray());
        HashSet<String> bizTypeNumber = new HashSet<String>();
        for (DynamicObject dynamic : biztypeCollect) {
            String number = dynamic.getString("billformid.number");
            bizTypeNumber.add(number);
        }
        return bizTypeNumber;
    }

    private void materialFromChange() {
        DynamicObjectCollection materialFrom = this.getModel().getDataEntity().getDynamicObjectCollection(this.MATERIALFROM);
        int size = materialFrom.size();
        this.getModel().beginInit();
        if (size > 1) {
            this.getModel().setValue(this.MATERIALTO, null);
            this.getView().setEnable(Boolean.valueOf(this.falseValue), new String[]{this.MATERIALTO});
        } else {
            if (materialFrom.size() == 1) {
                this.getModel().setValue("materialto", ((DynamicObject)materialFrom.get(0)).getDynamicObject("fbasedataid").getPkValue());
            } else {
                this.getModel().setValue("materialto", null);
            }
            this.getView().setEnable(Boolean.valueOf(this.trueValue), new String[]{this.MATERIALTO});
        }
        this.getModel().endInit();
        this.getView().updateView(this.MATERIALTO);
    }

    private void costAccountChange() {
        DynamicObject info = this.getModel().getDataEntity().getDynamicObject(this.COSTACCOUNT);
        this.getModel().setValue("currency", null);
        if (info == null) {
            this.costAcountChangePeroid();
            return;
        }
        boolean isCostRecordDetail = ParamsHelper.getCostElementByCostAccount((long)info.getLong("id"));
        String billStatus = this.getModel().getDataEntity().getString(this.BILLSTATUS);
        if (!isCostRecordDetail) {
            this.getModel().setValue(this.COSTSUBELEMENT, null);
            this.getView().setVisible(Boolean.FALSE, new String[]{this.COSTSUBELEMENT});
        } else if ("C".equals(billStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{this.COSTSUBELEMENT});
            Set enableSubElement = CostElementHelper.getEnableSubElement();
            int costSubElementMaxSize = CalDbParamServiceHelper.getInteger((String)"costsubelement_filter_max_size");
            if (enableSubElement.size() <= costSubElementMaxSize) {
                this.getModel().setValue(this.COSTSUBELEMENT, (Object)enableSubElement.toArray());
            } else {
                this.getModel().setValue(this.COSTSUBELEMENT, null);
            }
            this.getView().updateView(this.COSTSUBELEMENT);
        }
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"id,currency", (QFilter[])new QFilter[]{new QFilter("id", "=", info.getDynamicObject("calpolicy").getPkValue())});
        this.getModel().setValue("currency", ((DynamicObject)coll.get(0)).get("currency"));
        DynamicObject period = PeriodHelper.getCurrentPeriod((Long)info.getLong("id"));
        if (period == null) {
            this.costAcountChangePeroid();
            return;
        }
        int year = period.getInt("periodyear");
        int number = period.getInt("periodnumber");
        this.getModel().beginInit();
        this.getModel().setValue(this.YEAR, (Object)year);
        this.getModel().setValue(this.PERIODNUM, (Object)number);
        this.getView().updateView(this.YEAR);
        this.getView().updateView(this.PERIODNUM);
        int periodNumBefore = year * 100 + number;
        int periodNumAfter = this.getAfterPeriod(periodNumBefore);
        if (periodNumAfter < periodNumBefore) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"btnreview"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"btnreviewall"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"btnreview"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"btnreviewall"});
        }
        this.getModel().endInit();
    }

    private void costAcountChangePeroid() {
        this.getModel().beginInit();
        this.getModel().setValue(this.YEAR, null);
        this.getModel().setValue(this.PERIODNUM, null);
        this.getView().updateView(this.YEAR);
        this.getView().updateView(this.PERIODNUM);
        this.getModel().endInit();
    }

    private void beforeOKcheck() {
        Object calOrg = this.getModel().getValue(this.CALORG);
        Object costaccount = this.getModel().getValue(this.COSTACCOUNT);
        Object year = this.getModel().getValue(this.YEAR);
        Object number = this.getModel().getValue(this.PERIODNUM);
        Object batchqty = this.getModel().getValue("batchqty");
        if (calOrg == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ExpBillCostPlugin_11", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        if (costaccount == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6210\u672c\u8d26\u7c3f\u3002", (String)"ExpBillCostPlugin_12", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        if (year == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4f1a\u8ba1\u5e74\u5ea6\u3002", (String)"ExpBillCostPlugin_13", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        if (number == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4f1a\u8ba1\u671f\u95f4\u3002", (String)"ExpBillCostPlugin_14", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        if (batchqty == null || (Integer)this.getModel().getValue("batchqty") == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u5206\u6279\u6570\u91cf\u201d \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExpBillCostPlugin_15", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        if (year != null && (Integer)year == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4f1a\u8ba1\u5e74\u5ea6\u3002", (String)"ExpBillCostPlugin_13", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        if (number != null && (Integer)number == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4f1a\u8ba1\u671f\u95f4\u3002", (String)"ExpBillCostPlugin_14", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }

    private QFilter buildFilter() {
        Set<Object> pkSet;
        Set<Object> pkSet2;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject calOrg = dataEntity.getDynamicObject(this.CALORG);
        DynamicObject costAccountInfo = dataEntity.getDynamicObject(this.COSTACCOUNT);
        DynamicObjectCollection bdBizType = dataEntity.getDynamicObjectCollection(this.BDBIZTYPE);
        DynamicObjectCollection invScheme = dataEntity.getDynamicObjectCollection(this.INVSCHEME);
        DynamicObjectCollection ownerFilter = dataEntity.getDynamicObjectCollection(this.OWNERFILTER);
        DynamicObjectCollection storageorgunitFilter = dataEntity.getDynamicObjectCollection(this.STORAGEORGUNITFILTER);
        DynamicObjectCollection warehouse = dataEntity.getDynamicObjectCollection(this.WAREHOUSEFILTER);
        DynamicObjectCollection locationFilter = dataEntity.getDynamicObjectCollection(this.LOCATUINFILTER);
        DynamicObjectCollection billTypeFilter = dataEntity.getDynamicObjectCollection(this.BILLTYPEFILTER);
        String biztypeFilter = dataEntity.getString("biztypefilter");
        String billNoStr = dataEntity.getString("billnos");
        if (StringUtils.isEmpty((CharSequence)billNoStr)) {
            billNoStr = dataEntity.getString("billnos_tag");
        }
        HashSet<String> billNos = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((CharSequence)billNoStr)) {
            billNos.addAll(Arrays.asList(billNoStr.split("\\s+|[\\r\\n]+")));
        }
        DynamicObjectCollection materialFrom = dataEntity.getDynamicObjectCollection(this.MATERIALFROM);
        DynamicObject materialTo = dataEntity.getDynamicObject(this.MATERIALTO);
        String lotFilter = dataEntity.getString("lotfilter");
        DynamicObjectCollection projectFilter = dataEntity.getDynamicObjectCollection("projectfilter");
        DynamicObjectCollection invType = dataEntity.getDynamicObjectCollection("invtype");
        DynamicObjectCollection invstatus = dataEntity.getDynamicObjectCollection("invstatus");
        boolean ispresentFilter = dataEntity.getBoolean("ispresentfilter");
        boolean onlyIsInitBill = dataEntity.getBoolean(this.ONLYISINITBILL);
        this.validateAccountType();
        QFilter filter = new QFilter(this.CALORG, "=", calOrg.getPkValue());
        filter.and(new QFilter(this.COSTACCOUNT, "=", costAccountInfo.getPkValue()));
        DynamicObject info = dataEntity.getDynamicObject(this.COSTACCOUNT);
        int yearNum = dataEntity.getInt(this.YEAR);
        int periodNum = dataEntity.getInt(this.PERIODNUM);
        String policyID = info.getString("calpolicy.id");
        DynamicObject policyInfo = BusinessDataServiceHelper.loadSingle((Object)policyID, (String)"cal_bd_calpolicy");
        DynamicObject period = PeriodHelper.getPeriodByNumber((int)yearNum, (int)periodNum, null, (long)policyInfo.getDynamicObject("periodtype").getLong("id"));
        if (period == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u6b64\u671f\u95f4\uff0c\u8bf7\u68c0\u67e5\u671f\u95f4\u8bbe\u503c\u662f\u5426\u5408\u7406\u3002", (String)"ExpBillCostPlugin_35", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        if (onlyIsInitBill) {
            filter.and(new QFilter("isinitbill", "=", (Object)Character.valueOf('1')));
            filter.and("bookdate", "<=", (Object)period.getDate("enddate"));
            filter.and("period", "<=", period.get("id"));
        } else {
            filter.and("period", "=", period.get("id"));
            filter.and(new QFilter("isinitbill", "=", (Object)Character.valueOf('0')));
            filter.and("bookdate", ">=", (Object)period.getDate("beginDate"));
            filter.and("bookdate", "<=", (Object)period.getDate("enddate"));
        }
        if (!bdBizType.isEmpty()) {
            filter.and("biztype", "in", this.getMulDataPK(bdBizType));
        }
        if (!invScheme.isEmpty()) {
            filter.and("invscheme", "in", this.getMulDataPK(invScheme));
        }
        if (ownerFilter.size() > 0) {
            pkSet2 = this.getMulDataPK(ownerFilter);
            filter.and(new QFilter("entry.owner", "in", pkSet2));
        }
        if (storageorgunitFilter.size() > 0) {
            pkSet2 = this.getMulDataPK(storageorgunitFilter);
            filter.and(new QFilter("storageorgunit", "in", pkSet2));
        }
        if (warehouse.size() > 0) {
            pkSet2 = this.getMulDataPK(warehouse);
            filter.and(new QFilter("entry.warehouse", "in", pkSet2));
        }
        if (locationFilter.size() > 0) {
            pkSet2 = this.getMulDataPK(locationFilter);
            filter.and(new QFilter("entry.location", "in", pkSet2));
        }
        if (billTypeFilter.size() > 0) {
            pkSet2 = this.getMulDataPK(billTypeFilter);
            filter.and(new QFilter("billtype", "in", pkSet2));
        }
        if (!"ALL".equals(biztypeFilter)) {
            filter.and(new QFilter("calbilltype", "=", (Object)biztypeFilter));
        }
        if (!billNos.isEmpty()) {
            filter.and(new QFilter("billno", "in", billNos));
        }
        String matProp = "entry.material";
        QFilter matFilter = new MatFromToFilter().getMatFilter(materialFrom, materialTo, matProp);
        filter.and(matFilter);
        if (StringUtils.isNotBlank((CharSequence)lotFilter)) {
            if (lotFilter.contains(",")) {
                filter.and(new QFilter("entry.lot", "in", (Object)lotFilter.split(",")));
            } else {
                filter.and(new QFilter("entry.lot", "=", (Object)lotFilter));
            }
        }
        if (projectFilter.size() > 0) {
            Set<Object> projectSet = this.getMulDataPK(projectFilter);
            filter.and(new QFilter("entry.project", "in", projectSet));
        }
        if (invType.size() > 0) {
            pkSet = this.getMulDataPK(invType);
            filter.and(new QFilter("entry.invtype", "in", pkSet));
        }
        if (invstatus.size() > 0) {
            pkSet = this.getMulDataPK(invstatus);
            filter.and(new QFilter("entry.invstatus", "in", pkSet));
        }
        if (!ispresentFilter) {
            filter.and(new QFilter("entry.ispresent", "=", (Object)Character.valueOf('0')));
        }
        Object[] purBitype = CostRecordQFilterHelper.getBiztype((String)"purbiztype");
        QFilter purInQ = new QFilter("bizentityobject", "in", (Object)purBitype);
        purInQ.and("issplitcreate", "=", (Object)Character.valueOf('0'));
        Object[] outSpliteBiztype = CostRecordQFilterHelper.getBiztype((String)"outsplitebiztype");
        QFilter saleOutQ = new QFilter("bizentityobject", "in", (Object)outSpliteBiztype);
        saleOutQ.and("issplitcreate", "=", (Object)Character.valueOf('0'));
        Object[] omBitype = CostRecordQFilterHelper.getBiztype((String)"ominbiztype");
        QFilter omInQ = new QFilter("bizentityobject", "in", (Object)omBitype);
        omInQ.and("issplitcreate", "=", (Object)Character.valueOf('0'));
        Object[] allBizType = ArrayUtils.addAll((Object[])purBitype, (Object[])outSpliteBiztype);
        allBizType = ArrayUtils.addAll((Object[])allBizType, (Object[])omBitype);
        QFilter otherQ = new QFilter("bizentityobject", "not in", (Object)allBizType);
        filter.and(purInQ.or(saleOutQ).or(otherQ).or(omInQ));
        QFilter voucherQ = CostRecordQFilterHelper.getNoVoucherQFilterByIsVoucher();
        filter.and(voucherQ);
        filter.and(CostRecordQFilterHelper.getBizEntityTypeQFilter());
        filter.and("costaccount.enablestandardcost", "=", (Object)false);
        filter.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        filter.and("entry.invtype.isforwardamount", "=", (Object)true);
        filter.and("invscheme.isforwardamount", "=", (Object)true);
        String billStatus = dataEntity.getString(this.BILLSTATUS);
        if (!"B".equals(billStatus)) {
            filter.and("ischargeoffed", "=", (Object)false);
        }
        filter.and("ischargeoff", "=", (Object)false);
        filter.and("invscheme.zerocost", "=", (Object)false);
        return filter;
    }

    private void validateAccountType() {
        Map<String, Object> map = this.getBillStatusAndAccountType(this.getModel().getDataEntity());
        String[] accountType = (String[])map.get(this.ACCOUNTTYPE);
        if (accountType == null || accountType.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba1\u4ef7\u65b9\u6cd5\u8fdb\u884c\u67e5\u8be2\u3002", (String)"ExpBillCostPlugin_37", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }

    private Map<String, Object> getBillStatusAndAccountType(DynamicObject dataEntity) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        String billStatus = dataEntity.getString(this.BILLSTATUS);
        String accountTypeValue = dataEntity.getString(this.ACCOUNTTYPE);
        String[] accountType = null;
        if (accountTypeValue != null && accountTypeValue.length() != 0) {
            String[] str = accountTypeValue.split(",");
            ArrayList<String> container = new ArrayList<String>(16);
            for (String value : str) {
                if (value == null || value.length() == 0) continue;
                container.add(value);
            }
            accountType = container.toArray(new String[container.size()]);
        }
        map.put(this.BILLSTATUS, billStatus);
        map.put(this.ACCOUNTTYPE, accountType);
        return map;
    }

    private Set<Object> getMulDataPK(DynamicObjectCollection mulColls) {
        HashSet<Object> pkSet = new HashSet<Object>(10);
        int size = mulColls.size();
        for (int i = 0; i < size; ++i) {
            Object pk = ((DynamicObject)mulColls.get(i)).getDynamicObject("fbasedataid").getPkValue();
            pkSet.add(pk);
        }
        return pkSet;
    }

    private List<Long> getLoactionIds(DynamicObject warehousesCol, List<Long> ids) {
        if (warehousesCol == null) {
            return ids;
        }
        QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(warehousesCol.getString("masterid")));
        DynamicObjectCollection locationCol = QueryServiceHelper.query((String)"bd_warehouse", (String)"entryentity.location.id", (QFilter[])new QFilter[]{filter});
        for (DynamicObject object : locationCol) {
            ids.add(object.getLong("entryentity.location.id"));
        }
        return ids;
    }

    private void refreshPage() {
        String str = this.getPageCache().get(this.QFILTER);
        if (null != str) {
            QFilter filter = QFilter.fromSerializedString((String)str);
            this.validateAccountType();
            this.loadDataByFilter(filter);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.valueOf(this.falseValue), new String[]{"ispresentfilter"});
        this.getPageCache().remove(this.CACHEBIZID);
        this.billStatusConnectAccountType("FIRST");
    }

    public void billStatusConnectAccountType(String op) {
        String accountTypes;
        this.getModel().beginInit();
        Map<String, Object> map = this.getBillStatusAndAccountType(this.getModel().getDataEntity());
        String[] accountType = (String[])map.get(this.ACCOUNTTYPE);
        String billStatus = (String)map.get(this.BILLSTATUS);
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(16);
        ArrayList<String> accountTypeContainer = new ArrayList<String>(16);
        if (billStatus != null && "B".equals(billStatus)) {
            accountTypeContainer.add(AccountTypeEnum.MOVE_ADD_AVERAGE.getValue());
            accountTypeContainer.add(AccountTypeEnum.STANDARDCOST.getValue());
            accountTypeContainer.add(AccountTypeEnum.FIN_FOUT.getValue());
        } else if (billStatus != null && "C".equals(billStatus)) {
            accountTypeContainer.add(AccountTypeEnum.ADD_AVERAGE.getValue());
            accountTypeContainer.add(AccountTypeEnum.SPECIAL_ACCT.getValue());
            accountTypeContainer.add(AccountTypeEnum.FIN_FOUT_PERIOD.getValue());
        } else {
            accountTypeContainer.add(AccountTypeEnum.ADD_AVERAGE.getValue());
            accountTypeContainer.add(AccountTypeEnum.MOVE_WEIGHTED_AVERAGE.getValue());
            accountTypeContainer.add(AccountTypeEnum.MOVE_ADD_AVERAGE.getValue());
            accountTypeContainer.add(AccountTypeEnum.STANDARDCOST.getValue());
            accountTypeContainer.add(AccountTypeEnum.FIN_FOUT.getValue());
            accountTypeContainer.add(AccountTypeEnum.SPECIAL_ACCT.getValue());
            accountTypeContainer.add(AccountTypeEnum.FIN_FOUT_PERIOD.getValue());
        }
        if ("FIRST".equals(op) || this.BILLSTATUS.equals(op)) {
            this.getModel().setValue(this.ACCOUNTTYPE, null);
            if ("B".equals(billStatus)) {
                accountTypeContainer = new ArrayList(16);
                accountTypeContainer.add(AccountTypeEnum.MOVE_ADD_AVERAGE.getValue());
                accountTypeContainer.add(AccountTypeEnum.FIN_FOUT.getValue());
            }
        }
        if (this.ACCOUNTTYPE.equals(op) && "B".equals(billStatus)) {
            Object accountTypeList;
            if (accountType != null && (accountTypeList = new ArrayList<String>(Arrays.asList(accountType))).size() >= 1 && !accountTypeList.contains(AccountTypeEnum.STANDARDCOST.getValue())) {
                accountTypeContainer = new ArrayList(16);
                accountTypeContainer.add(AccountTypeEnum.MOVE_ADD_AVERAGE.getValue());
                accountTypeContainer.add(AccountTypeEnum.FIN_FOUT.getValue());
            }
            if (accountType != null && accountType.length != 0 && AccountTypeEnum.STANDARDCOST.getValue().equals(accountType[0])) {
                accountTypeContainer = new ArrayList(16);
                accountTypeContainer.add(AccountTypeEnum.STANDARDCOST.getValue());
            }
            if (accountType != null && accountType.length == 3) {
                this.getModel().setValue(this.ACCOUNTTYPE, (Object)(AccountTypeEnum.MOVE_ADD_AVERAGE.getValue() + "," + AccountTypeEnum.FIN_FOUT.getValue()));
                accountType = new String[]{this.ACCOUNTTYPE, AccountTypeEnum.MOVE_ADD_AVERAGE.getValue() + "," + AccountTypeEnum.FIN_FOUT.getValue()};
                accountTypeContainer = new ArrayList(16);
                accountTypeContainer.add(AccountTypeEnum.MOVE_ADD_AVERAGE.getValue());
                accountTypeContainer.add(AccountTypeEnum.FIN_FOUT.getValue());
            }
        }
        if (accountTypeContainer.size() > 0) {
            for (AccountTypeEnum accountTypeEnum : AccountTypeEnum.values()) {
                if (!accountTypeContainer.contains(accountTypeEnum.getValue())) continue;
                ComboItem comboItem = new ComboItem();
                comboItem.setValue(accountTypeEnum.getValue());
                comboItem.setCaption(new LocaleString(accountTypeEnum.getDesEveryTime()));
                comboItem.setItemVisible(true);
                propertyItems.add(comboItem);
            }
        }
        if (propertyItems.size() != 0) {
            ComboEdit ruleEdit = (ComboEdit)this.getControl(this.ACCOUNTTYPE);
            ruleEdit.setComboItems(propertyItems);
        }
        if ("FIRST".equals(op) || this.BILLSTATUS.equals(op)) {
            if (accountType == null || accountType.length == 0) {
                this.getModel().setValue(this.ACCOUNTTYPE, null);
            }
            if ("B".equals(billStatus)) {
                this.getModel().setValue(this.ACCOUNTTYPE, (Object)AccountTypeEnum.MOVE_ADD_AVERAGE.getValue());
            }
            if ("C".equals(billStatus)) {
                this.getModel().setValue(this.ACCOUNTTYPE, (Object)AccountTypeEnum.ADD_AVERAGE.getValue());
            }
        }
        if ((accountTypes = (String)this.getModel().getValue(this.ACCOUNTTYPE)) != null && accountTypes.length() != 0) {
            String[] split;
            for (String accountTypeValue : split = accountTypes.split(",")) {
                if (StringUtils.isEmpty((CharSequence)accountTypeValue) || !AccountTypeEnum.STANDARDCOST.getValue().equals(accountTypeValue)) continue;
                this.getView().setEnable(Boolean.valueOf(this.trueValue), new String[]{"ispresentfilter"});
            }
        }
        this.getModel().endInit();
        this.getView().updateView(this.ACCOUNTTYPE);
        this.getView().updateView("ispresentfilter");
        this.setLessPriceLock(billStatus);
    }

    private void setLessPriceLock(String billStatus) {
        if ("B".equals(billStatus)) {
            this.getModel().setValue("islessprice", (Object)true);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"islessprice"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"islessprice"});
        }
    }

    private void doJobAll() {
        DynamicObjectCollection entityColl = this.getModel().getEntryEntity("entryentity");
        if (entityColl.size() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u7b5b\u9009\u66f4\u65b0\u6570\u636e\u3002", (String)"ExpBillCostPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!this.doCheck(entityColl)) {
            return;
        }
        this.dispatchByBatch(entityColl);
        this.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u81f3\u540e\u53f0\u4efb\u52a1\uff0c\u8bf7\u7559\u610f\u7cfb\u7edf\u63d0\u793a\u3002", (String)"ExpBillCostPlugin_19", (String)"fi-cal-formplugin", (Object[])new Object[0]));
    }

    private void dojob() {
        int[] indexs;
        DynamicObjectCollection entityColl = this.getModel().getEntryEntity("entryentity");
        DynamicObjectCollection selectEntryDycs = new DynamicObjectCollection();
        EntryGrid entryGrid = (EntryGrid)this.getControl(this.ENTRYENTITY);
        for (int index : indexs = entryGrid.getSelectRows()) {
            selectEntryDycs.add(entityColl.get(index));
        }
        if (selectEntryDycs.size() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u7b5b\u9009\u66f4\u65b0\u6570\u636e\u3002", (String)"ExpBillCostPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!this.doCheck(selectEntryDycs)) {
            return;
        }
        this.dispatchByBatch(selectEntryDycs);
        this.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u81f3\u540e\u53f0\u4efb\u52a1\uff0c\u8bf7\u7559\u610f\u7cfb\u7edf\u63d0\u793a\u3002", (String)"ExpBillCostPlugin_19", (String)"fi-cal-formplugin", (Object[])new Object[0]));
    }

    private boolean doCheck(DynamicObjectCollection entityColl) {
        boolean result = true;
        HashSet<Long> entryIdsSet = new HashSet<Long>(16);
        HashSet<Long> allEntryIdsSet = new HashSet<Long>(16);
        for (DynamicObject entryDyc : entityColl) {
            entryIdsSet.add(entryDyc.getLong("entryid"));
        }
        QFilter filter = new QFilter("entry.id", "in", entryIdsSet);
        Map<String, Object> map = this.getBillStatusAndAccountType(this.getModel().getDataEntity());
        String billStatus = (String)map.get(this.BILLSTATUS);
        if (billStatus != null && "C".equals(billStatus)) {
            filter.and("billstatus", "=", (Object)"C");
        }
        DynamicObjectCollection costRecords = QueryServiceHelper.query((String)"cal_costrecord", (String)"entry.id", (QFilter[])filter.toArray());
        for (DynamicObject dynamicObject : costRecords) {
            Long entryId = dynamicObject.getLong("entry.id");
            allEntryIdsSet.add(entryId);
        }
        if (!allEntryIdsSet.containsAll(entryIdsSet)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5b58\u5728\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5df2\u5220\u9664\u6216\u975e\u5ba1\u6838\u72b6\u6001\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u540e\u91cd\u65b0\u66f4\u65b0\u3002", (String)"ExpBillCostTask_10", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            result = false;
        }
        this.cacheBizBillId(this.getModel().getEntryEntity("entryentity"));
        return result;
    }

    private void cacheQueryAndRefreshBizBillId(DataSet dataSet) {
        if (dataSet != null) {
            ArrayList<Long> preIds = new ArrayList<Long>(16);
            preIds.add(0L);
            for (Row row : dataSet) {
                preIds.add(row.getLong("bizbillid"));
                if (preIds.size() <= 100000) continue;
                break;
            }
            this.getPageCache().put(this.CACHEBIZID, SerializationUtils.toJsonString(preIds));
        }
    }

    private void cacheBizBillId(DynamicObjectCollection entityColl) {
        ArrayList<Long> preIds = new ArrayList<Long>(16);
        preIds.add(0L);
        for (DynamicObject entryDyc : entityColl) {
            preIds.add(entryDyc.getLong("bizbillid"));
        }
        this.getPageCache().put(this.CACHEBIZID, SerializationUtils.toJsonString(preIds));
    }

    private void dispatchByBatch(DynamicObjectCollection entityColl) {
        Integer batch = (Integer)this.getModel().getValue("batchqty");
        if (batch <= 0) {
            batch = entityColl.size();
        }
        int pages = entityColl.size() / batch;
        HashSet<Integer> curOpPages = new HashSet<Integer>(16);
        if (entityColl.size() % batch != 0) {
            ++pages;
        }
        for (int i = 0; i < pages; ++i) {
            curOpPages.add(i + 1);
        }
        String curOpPageIdTimeKey = this.getView().getPageId();
        curOpPageIdTimeKey = curOpPageIdTimeKey + System.currentTimeMillis();
        IAppCache appCache = AppCache.get((String)"cal");
        appCache.put(curOpPageIdTimeKey, curOpPages);
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue(this.COSTACCOUNT);
        boolean isCostRecordDetail = ParamsHelper.getCostElementByCostAccount((long)costAccount.getLong("id"));
        ArrayList<String> taskIds = new ArrayList<String>(16);
        for (int pageIndex = 1; pageIndex <= pages; ++pageIndex) {
            int pageStart = (pageIndex - 1) * batch;
            int pageEnd = pageIndex * batch - 1;
            if (pageEnd >= entityColl.size() - 1) {
                pageEnd = entityColl.size() - 1;
            }
            List<Map<String, Object>> paramList = this.buildCalInStrParamsBatch(pageStart, pageEnd, entityColl);
            Map<String, Long[]> cosTypeMaterialMap = this.buildCostDetailMap(entityColl);
            StringBuilder errMsg = this.check(paramList);
            Map<String, Object> jobParams = this.buildTaskParam(paramList, isCostRecordDetail, cosTypeMaterialMap, errMsg);
            jobParams.put("CUROPPAGEIDTIMEKEY", curOpPageIdTimeKey);
            jobParams.put("PAGEINDEX", pageIndex);
            String batchStr = String.format("%s-[%s/%s]", batch, pageIndex, pages);
            jobParams.put("BATCHSTR", batchStr);
            jobParams.put("BILLSTATUS", this.getModel().getValue("billstatus"));
            String taskId = this.dispatchTask(batchStr, jobParams, curOpPageIdTimeKey);
            taskIds.add(taskId);
        }
        this.getPageCache().put("taskIds", JSONObject.toJSONString(taskIds));
    }

    private String dispatchTask(String batchStr, Map<String, Object> jobParams, String curOpPageIdTimeKey) {
        String content;
        JobInfo job = new JobInfo();
        job.setRunByLang(Lang.get());
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue(this.COSTACCOUNT);
        String opName = content = String.format(ResManager.loadKDString((String)"\u5f02\u5e38\u6210\u672c\u5904\u7406-\u6210\u672c\u8d26\u7c3f\u7f16\u7801:%1$s,\u6210\u672c\u8d26\u7c3f\u540d\u79f0:%2$s", (String)"ExpBillCostPlugin_44", (String)"fi-cal-formplugin", (Object[])new Object[0]), costAccount.getString("number"), costAccount.getString("name"));
        job.setName(opName + "-" + batchStr);
        job.setTaskDefineId("2TEEAQXS80X3");
        job.setJobType(JobType.BIZ);
        job.setParams(jobParams);
        job.setAppId("cal");
        job.setRunByLang(Lang.get());
        job.setTaskClassname("kd.fi.cal.formplugin.calculate.in.ExpBillCostTask");
        String taskid = JobClient.dispatch((JobInfo)job);
        return taskid;
    }

    private Map<String, Object> buildTaskParam(List<Map<String, Object>> paramList, boolean isCostRecordDetail, Map<String, Long[]> cosTypeMaterialMap, StringBuilder errMsg) {
        HashMap<String, Object> jobParams = new HashMap<String, Object>(16);
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue(this.COSTACCOUNT);
        jobParams.put("PARAMLIST", SerializationUtils.toJsonString(paramList));
        jobParams.put("COSTYPEMATERIALMAP", SerializationUtils.toJsonString(cosTypeMaterialMap));
        jobParams.put("ISCOSTRECORDDETAIL", SerializationUtils.toJsonString((Object)isCostRecordDetail));
        jobParams.put("COSTTYPEID", SerializationUtils.toJsonString((Object)this.getCostTypeId()));
        jobParams.put("ERRMSG", errMsg.toString());
        jobParams.put("COSTACCOUNT", costAccount.getLong("id"));
        jobParams.put("COSTSRC", CostSrcEnum.EXPBILL.getValue());
        jobParams.put("YEAR", this.getModel().getValue("YEAR"));
        jobParams.put("PERIODNUM", this.getModel().getValue("PERIODNUM"));
        jobParams.put("USERID", Long.parseLong(RequestContext.get().getUserId()));
        return jobParams;
    }

    private List<Map<String, Object>> buildCalInStrParamsBatch(int pageStart, int pageEnd, DynamicObjectCollection entryDycs) {
        ArrayList<Map<String, Object>> retValue = new ArrayList<Map<String, Object>>(50);
        DynamicObjectCollection costSubElements = this.getModel().getDataEntity().getDynamicObjectCollection(this.COSTSUBELEMENT);
        for (int index = pageStart; index <= pageEnd; ++index) {
            DynamicObject entity = (DynamicObject)entryDycs.get(index);
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put(this.UNITACTUALCOST, entity.getBigDecimal(this.UNITACTUALCOST));
            map.put("actualcost", entity.getBigDecimal("actualcost"));
            map.put("resource", entity.getBigDecimal("resource"));
            map.put("manufacturecost", entity.getBigDecimal("manufacturecost"));
            map.put("material", entity.getLong("materialid"));
            map.put("entryid", entity.getLong("entryid"));
            map.put(MATERIALCOST, entity.getBigDecimal(MATERIALCOST));
            map.put(UNITMATERIALCOST, entity.getBigDecimal(UNITMATERIALCOST));
            map.put(FEE, entity.getBigDecimal(FEE));
            map.put(PROCESSCOST, entity.getBigDecimal(PROCESSCOST));
            map.put(UNITPROCESSCOST, entity.getBigDecimal(UNITPROCESSCOST));
            map.put("billtype", entity.getDynamicObject("billtype").getString("number"));
            map.put(this.BASEQTY, entity.getBigDecimal(this.BASEQTY));
            map.put("costaccountid", entity.getLong("costaccountid"));
            map.put("bizentryid", entity.getLong("bizentryid"));
            map.put("isinitbill", entity.getBoolean("isinitbill"));
            map.put("billno", entity.getString("billno"));
            map.put("costrecordid", entity.getLong("costrecordid"));
            map.put("billstatus", entity.getString("calbillstatus"));
            map.put("accounttype", entity.getString("calaccounttype"));
            map.put("bizentityobject", entity.getString("bizentityobject"));
            map.put("bizbillid", entity.getLong("bizbillid"));
            if (!costSubElements.isEmpty()) {
                ArrayList<String> subElementInfoList = new ArrayList<String>(costSubElements.size());
                for (DynamicObject costSubElement : costSubElements) {
                    DynamicObject info = costSubElement.getDynamicObject("fbasedataid");
                    long id = info.getLong("id");
                    String subEleNum = info.getString("number");
                    String type = info.getString("type");
                    BigDecimal subEleUnitCost = entity.getBigDecimal(subEleNum + "_unitcost");
                    BigDecimal subEleCost = entity.getBigDecimal(subEleNum + "_cost");
                    CostSubElementInfo subElementInfo = new CostSubElementInfo(id, subEleNum, subEleUnitCost, subEleCost, type);
                    try {
                        subElementInfoList.add(JSONUtils.toString((Object)subElementInfo));
                    }
                    catch (IOException e) {
                        throw new KDBizException((Throwable)e, new ErrorCode("", ""), new Object[0]);
                    }
                }
                map.put("subElementInfoList", subElementInfoList);
            }
            retValue.add(map);
        }
        return retValue;
    }

    private void viewLog() {
        String taskIdsStr = this.getPageCache().get("taskIds");
        if (StringUtils.isNotEmpty((CharSequence)taskIdsStr)) {
            List taskIds = (List)SerializationUtils.fromJsonString((String)taskIdsStr, ArrayList.class);
            LinkQueryPkIdCollection linkQueryPkIdCollection = new LinkQueryPkIdCollection();
            for (String taskId : taskIds) {
                linkQueryPkIdCollection.addLinkQueryPkId((Object)taskId);
            }
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            showParameter.setBillFormId("sch_task");
            showParameter.setAppId("cal");
            showParameter.setLinkQueryPkIdCollection(linkQueryPkIdCollection);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6682\u65e0\u8fdb\u5ea6", (String)"ExpBillCostPlugin_38", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }

    private void setBillStatusAccountTypeVisable() {
        Map<String, Object> map = this.getBillStatusAndAccountType(this.getModel().getDataEntity());
        String billStatus = (String)map.get(this.BILLSTATUS);
        String[] accountType = (String[])map.get(this.ACCOUNTTYPE);
        if (billStatus != null || accountType != null && accountType.length != 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"calaccounttype"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"calaccounttype"});
        }
        if (!this.getChosenAccountType(new ArrayList<String>(16)).contains("D")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"unitstandardcost"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"standardcost"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"unitstandardcost"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"standardcost"});
        }
    }

    private String getCostReorcdFields() {
        String costRecordEntity = "cal_costrecord";
        StringBuilder fields = new StringBuilder();
        MainEntityType calEntityType = EntityMetadataCache.getDataEntityType((String)costRecordEntity);
        Set selectorsSet = calEntityType.getAllFields().keySet();
        for (String o : selectorsSet) {
            fields.append(o).append(',');
        }
        fields.append("entry.seq");
        return fields.toString();
    }

    private void checkAcctIsNull() {
        DynamicObject info = this.getModel().getDataEntity().getDynamicObject(this.COSTACCOUNT);
        if (info == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InitCalBillEditPlugin_11", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        boolean isCostRecordDetail = ParamsHelper.getCostElementByCostAccount((long)info.getLong("id"));
        DynamicObjectCollection costSubElements = this.getModel().getDataEntity().getDynamicObjectCollection(this.COSTSUBELEMENT);
        String billStatus = this.getModel().getDataEntity().getString(this.BILLSTATUS);
        if (isCostRecordDetail && costSubElements.isEmpty() && "C".equals(billStatus)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4", (String)"CalculateInCostPlugin_52", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }

    private List<Set<Long>> getBatchIdList(Set<Long> ids) {
        ArrayList<Set<Long>> balIdsArray = new ArrayList<Set<Long>>(16);
        HashSet<Long> balIds = null;
        long index = 0L;
        for (Long id : ids) {
            if (index % 100000L == 0L) {
                balIds = new HashSet<Long>();
                balIdsArray.add(balIds);
            }
            if (balIds != null) {
                balIds.add(id);
            }
            ++index;
        }
        return balIdsArray;
    }
}

