/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.calculate.in;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.RowX;

public class ExpBillCostRowToColFunction
extends ReduceGroupFunction {
    private RowMeta srcMeta;
    private RowMeta resultMeta;
    private Set<String> elementNumSet;

    public ExpBillCostRowToColFunction(RowMeta srcMeta, Set<String> elementNumSet) {
        this.srcMeta = srcMeta;
        this.elementNumSet = elementNumSet;
        this.resultMeta = this.buildResultMeta();
    }

    private RowMeta buildResultMeta() {
        Field[] srcFields = this.srcMeta.getFields();
        ArrayList<Field> resultFieldList = new ArrayList<Field>(10);
        for (Field srcField : srcFields) {
            String srcFieldName = srcField.getName();
            if ("costsubelement".equals(srcFieldName) || "sub_actualcost".equals(srcFieldName) || "sub_unitactualcost".equals(srcFieldName)) continue;
            resultFieldList.add(srcField);
        }
        for (String elementKey : this.elementNumSet) {
            Field field = new Field(elementKey, (DataType)DataType.BigDecimalType);
            Field unitField = new Field(elementKey + "_unitcost", (DataType)DataType.BigDecimalType);
            resultFieldList.add(field);
            resultFieldList.add(unitField);
        }
        return new RowMeta(resultFieldList.toArray(new Field[0]));
    }

    public Iterator<Object[]> reduce(Iterator<Row> iterator) {
        ArrayList<Object[]> resultList = new ArrayList<Object[]>(16);
        RowX rowX = null;
        while (iterator.hasNext()) {
            Row row = iterator.next();
            if (rowX == null) {
                rowX = this.getRowX(row);
                continue;
            }
            String costSubElement = row.getString("costsubelement");
            BigDecimal subActualCost = row.getBigDecimal("sub_actualcost");
            BigDecimal subUnitActualCost = row.getBigDecimal("sub_unitactualcost");
            if (!this.elementNumSet.contains(costSubElement)) continue;
            this.setRowValue(rowX, this.resultMeta, costSubElement, subActualCost);
            this.setRowValue(rowX, this.resultMeta, costSubElement + "_unitcost", subUnitActualCost);
        }
        if (rowX != null) {
            resultList.add(rowX.values());
        }
        return resultList.iterator();
    }

    public RowMeta getResultRowMeta() {
        return this.resultMeta;
    }

    private RowX getRowX(Row row) {
        String[] resultFieldNames = this.resultMeta.getFieldNames();
        HashSet<String> srcFieldNames = new HashSet<String>(16);
        srcFieldNames.addAll(Arrays.asList(this.srcMeta.getFieldNames()));
        Object[] values = new Object[resultFieldNames.length];
        for (int i = 0; i < resultFieldNames.length; ++i) {
            String name = resultFieldNames[i];
            values[i] = !srcFieldNames.contains(name) ? BigDecimal.ZERO : row.get(name);
        }
        String costSubElement = row.getString("costsubelement");
        if (this.elementNumSet.contains(costSubElement)) {
            BigDecimal subActualCost = row.getBigDecimal("sub_actualcost");
            values[this.resultMeta.getFieldIndex((String)costSubElement)] = subActualCost;
            BigDecimal subUnitActualCost = row.getBigDecimal("sub_unitactualcost");
            values[this.resultMeta.getFieldIndex((String)new StringBuilder().append((String)costSubElement).append((String)"_unitcost").toString())] = subUnitActualCost;
        }
        return new RowX(values);
    }

    private void setRowValue(RowX row, RowMeta rowMeta, String field, Object value) {
        row.set(rowMeta.getFieldIndex(field), value);
    }
}

