/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.calculate.in;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.config.client.util.JSONUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.ExceptionUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.business.balance.BalanceCalculator;
import kd.fi.cal.business.balance.BalanceOpInvoker;
import kd.fi.cal.business.balance.BalanceSourceEnum;
import kd.fi.cal.business.calculate.out.calintime.CalInTimeBufferPoolManager;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.enums.CostPriceSourceTypeEnum;
import kd.fi.cal.common.enums.CostSrcEnum;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalCustomEventCallHelper;
import kd.fi.cal.common.helper.CalDLockHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.ChildBillCostUpdateHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.SyncSimpleDycHelper;
import kd.fi.cal.common.model.CostSubElementInfo;
import kd.fi.cal.common.util.CommonUtils;

public class ExpBillCostTask
extends AbstractTask {
    private static final String DLOCK_KEY_PRE = "fi-cal-ExpBillCostTask";
    private String curOpPageIdTimeKey;
    private Integer pageIndex;
    private String batchStr = "";
    private static final String runningPageId_Key = "runningpageid";
    private long costAccountId;
    private String commonLockAccount = "fi-cal-ExpBillCostTask_com_";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(RequestContext paramRequestContext, Map<String, Object> paramMap) throws KDException {
        String content;
        String errMsg = (String)paramMap.get("ERRMSG");
        this.costAccountId = (Long)paramMap.get("COSTACCOUNT");
        this.curOpPageIdTimeKey = (String)paramMap.get("CUROPPAGEIDTIMEKEY");
        this.pageIndex = (Integer)paramMap.get("PAGEINDEX");
        this.batchStr = (String)paramMap.get("BATCHSTR");
        DynamicObject currentperiod = PeriodHelper.getCurrentPeriod((Long)this.costAccountId);
        DynamicObject costAccount = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"id,calorg,costtype,name,number", (QFilter[])new QFilter("id", "=", (Object)this.costAccountId).toArray());
        String costAccountName = content = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u3010%1$s\u3011", (String)"ExpBillCostTask_11", (String)"fi-cal-formplugin", (Object[])new Object[0]), costAccount.getString("name"));
        MessageInfo msgInfo = this.getMessageInfo(costAccountName);
        this.commonLockAccount = DLOCK_KEY_PRE + this.costAccountId;
        IAppCache appCache = AppCache.get((String)"cal");
        String runningPageIdAccountKey = runningPageId_Key + this.costAccountId;
        try (DLock lock = DLock.create((String)this.commonLockAccount, (String)"fi-cal-ExpBillCostTask-dlock");){
            Set otherOpPages;
            lock.lock();
            String otherRunningOpPageIdTimeKey = (String)appCache.get(runningPageIdAccountKey, String.class);
            if (StringUtils.isNotEmpty((CharSequence)otherRunningOpPageIdTimeKey) && !otherRunningOpPageIdTimeKey.equals(this.curOpPageIdTimeKey) && (otherOpPages = (Set)appCache.get(otherRunningOpPageIdTimeKey, Set.class)) != null) {
                for (Integer otherPageIndex : otherOpPages) {
                    DLock pageIndexLock = DLock.create((String)(this.commonLockAccount + otherPageIndex), (String)"fi-cal-calculateincost-dlock-batch");
                    Throwable throwable = null;
                    try {
                        String msg;
                        if (pageIndexLock.tryLock()) continue;
                        String msgStr = msg = String.format(ResManager.loadKDString((String)"%1$s\u6b63\u5728\u66f4\u65b0\u5f02\u5e38\u6210\u672c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ExpBillCostTask_12", (String)"fi-cal-formplugin", (Object[])new Object[0]), costAccountName);
                        msgInfo.setContent(msgStr);
                        MessageCenterServiceHelper.sendMessage((MessageInfo)msgInfo);
                        throw new KDBizException(msgStr);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (pageIndexLock == null) continue;
                        if (throwable != null) {
                            try {
                                pageIndexLock.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        pageIndexLock.close();
                    }
                }
            }
            appCache.put(runningPageIdAccountKey, (Object)this.curOpPageIdTimeKey);
            HashSet<Integer> curOpPages = (HashSet<Integer>)appCache.get(this.curOpPageIdTimeKey, Set.class);
            if (curOpPages == null || curOpPages.isEmpty()) {
                curOpPages = new HashSet<Integer>(16);
                curOpPages.add(this.pageIndex);
                appCache.put(this.curOpPageIdTimeKey, curOpPages);
            }
        }
        try {
            lock = DLock.create((String)(this.commonLockAccount + this.pageIndex), (String)"fi-cal-ExpBillCostTask-dlock-batch");
            var12_15 = null;
            try {
                boolean isLockSuccess = lock.tryLock();
                if (!isLockSuccess) {
                    String msg = String.format(ResManager.loadKDString((String)"%1$s\u6b63\u5728\u66f4\u65b0\u5f02\u5e38\u6210\u672c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ExpBillCostTask_12", (String)"fi-cal-formplugin", (Object[])new Object[0]), costAccountName);
                    throw new KDBizException(msg);
                }
                ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fcostaccountid", FilterType.eq, (Object)this.costAccountId), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.ge, (Object)currentperiod.getDate("begindate")), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.le, (Object)currentperiod.getDate("enddate"))});
                Object object = null;
                try {
                    ctx.set();
                    errMsg = this.reviewBill(errMsg, paramMap);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (ctx != null) {
                        if (object != null) {
                            try {
                                ctx.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ctx.close();
                        }
                    }
                }
                CalCustomEventCallHelper.calExceptionCostEventCall(paramMap);
            }
            catch (Throwable isLockSuccess) {
                var12_15 = isLockSuccess;
                throw isLockSuccess;
            }
            finally {
                if (lock != null) {
                    if (var12_15 != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable isLockSuccess) {
                            var12_15.addSuppressed(isLockSuccess);
                        }
                    } else {
                        lock.close();
                    }
                }
            }
        }
        catch (IOException e) {
            msgInfo.setContent(costAccountName + " : " + e.getMessage());
            throw new KDBizException(e.getMessage());
        }
        catch (KDBizException e) {
            msgInfo.setMessageContent((ILocaleString)new LocaleString(e.getMessage()));
            throw e;
        }
        catch (Throwable e) {
            StringBuilder sBuilder = new StringBuilder(costAccountName);
            sBuilder.append(" : ");
            sBuilder.append(ExceptionUtils.getExceptionStackTraceMessage((Exception)((Exception)e)).substring(0, 255));
            msgInfo.setMessageContent((ILocaleString)new LocaleString(sBuilder.toString()));
            throw e;
        }
        finally {
            block83: {
                try (DLock lock = DLock.create((String)this.commonLockAccount, (String)"fi-cal-ExpBillCostTask-dlock");){
                    lock.lock();
                    Set curOpPages = (Set)appCache.get(this.curOpPageIdTimeKey, Set.class);
                    if (curOpPages == null) break block83;
                    curOpPages.remove(this.pageIndex);
                    if (curOpPages.size() > 0) {
                        appCache.put(this.curOpPageIdTimeKey, (Object)curOpPages);
                    } else {
                        appCache.remove(this.curOpPageIdTimeKey);
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)errMsg)) {
                StringBuilder sBuilder = new StringBuilder(ResManager.loadKDString((String)"\u90e8\u5206\u66f4\u65b0\u5931\u8d25", (String)"ExpBillCostTask_5", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                sBuilder.append('\n');
                sBuilder.append(errMsg);
                msgInfo.setMessageContent((ILocaleString)new LocaleString(sBuilder.toString()));
            }
            MessageCenterServiceHelper.sendMessage((MessageInfo)msgInfo);
        }
        this.calInTime(paramMap);
    }

    private void calInTime(Map<String, Object> paramMap) {
        if (!CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.ENTRY_SPLIT_INTIME_CAL).booleanValue()) {
            return;
        }
        HashSet<Long> matIds = new HashSet<Long>(16);
        List paramList = (List)SerializationUtils.fromJsonString((String)((String)paramMap.get("PARAMLIST")), ArrayList.class);
        for (Map item : paramList) {
            Object material = item.get("material");
            long materialId = material instanceof Integer ? Long.parseLong(material.toString()) : (Long)material;
            matIds.add(materialId);
        }
        new CalInTimeBufferPoolManager().dispatchTask(matIds);
    }

    private MessageInfo getMessageInfo(String costAccountName) {
        MessageInfo msgInfo = new MessageInfo();
        ArrayList<Long> userList = new ArrayList<Long>();
        userList.add(Long.valueOf(RequestContext.get().getUserId()));
        msgInfo.setNotifyType(MessageChannels.MC.getNumber());
        String title = ResManager.getLocaleString((String)"\u5f02\u5e38\u6210\u672c\u5904\u7406", (String)"ExpBillCostTask_3", (String)"fi-cal-formplugin").getLocaleValue() + "-" + this.batchStr;
        msgInfo.setMessageTitle((ILocaleString)new LocaleString(title));
        msgInfo.setMessageContent((ILocaleString)ResManager.getLocaleString((String)"\u5f02\u5e38\u6210\u672c\u5904\u7406\u5168\u90e8\u66f4\u65b0\u6210\u529f\u3002", (String)"ExpBillCostTask_2", (String)"fi-cal-formplugin"));
        msgInfo.setMessageTag((ILocaleString)ResManager.getLocaleString((String)"\u5f02\u5e38\u6210\u672c\u5904\u7406", (String)"ExpBillCostTask_3", (String)"fi-cal-formplugin"));
        msgInfo.setUserIds(userList);
        return msgInfo;
    }

    private String reviewBill(String errMsg, Map<String, Object> paramObjMap) throws IOException {
        long costTypeId = Long.parseLong((String)paramObjMap.get("COSTTYPEID"));
        Boolean isCostRecordDetail = Boolean.valueOf((String)paramObjMap.get("ISCOSTRECORDDETAIL"));
        List paramList = (List)SerializationUtils.fromJsonString((String)((String)paramObjMap.get("PARAMLIST")), ArrayList.class);
        if (paramList.isEmpty()) {
            return errMsg;
        }
        String costSrc = paramObjMap.get("COSTSRC") == null ? "" : (String)paramObjMap.get("COSTSRC");
        Map cosTypeMap = (Map)SerializationUtils.fromJsonString((String)((String)paramObjMap.get("COSTYPEMATERIALMAP")), Map.class);
        Map cosTypeMaterialMap = (Map)SerializationUtils.fromJsonString((String)((String)paramObjMap.get("COSTYPEMATERIALMAP")), Map.class);
        for (Map.Entry param : cosTypeMap.entrySet()) {
            if (param.getValue() == null || ((List)param.getValue()).isEmpty()) continue;
            cosTypeMaterialMap.put(param.getKey(), ((List)param.getValue()).toArray(new Long[((List)param.getValue()).size()]));
        }
        StringBuilder errBuffer = new StringBuilder(errMsg);
        ArrayList<Object[]> purchaseBill = new ArrayList<Object[]>(paramList.size());
        int pricePrecision = 10;
        Long[] defaultElementIds = CostElementHelper.getDefaultMaterialElements();
        Long defaultMetriaElemnet = defaultElementIds[0];
        ArrayList<Object[]> costDetailList = new ArrayList<Object[]>(paramList.size());
        HashSet<Long> entryIdSet = new HashSet<Long>(paramList.size());
        HashSet<Long> idSet = new HashSet<Long>(paramList.size());
        Map<String, Object> cacheMap = this.cacheActualCostMap(paramList);
        Map oldActualCostMap = (Map)cacheMap.get("oldActualCostMap");
        Map twinsCostRecordMap = (Map)cacheMap.get("twinsCostRecordMap");
        for (Map paramMap : paramList) {
            String billno = this.dealTwinsCostRecord(twinsCostRecordMap, paramMap, purchaseBill, isCostRecordDetail, cosTypeMaterialMap, costDetailList, entryIdSet, costTypeId, idSet);
            if (StringUtils.isNotBlank((CharSequence)billno)) {
                String billnum = (String)paramMap.get("billno");
                String errorMsg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u7684\u6210\u7ec4\u5355\u636e\u201c%2$s\u201d\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u66f4\u65b0\u6210\u672c\u3002", (String)"ExpBillCostTask_06", (String)"fi-cal-formplugin", (Object[])new Object[0]), billnum, billno);
                errBuffer.append(errorMsg);
                continue;
            }
            long entryId = (Long)paramMap.get("entryid");
            long costRecordId = (Long)paramMap.get("costrecordid");
            BigDecimal actualcost = new BigDecimal(paramMap.get("actualcost").toString());
            BigDecimal unitactualcost = new BigDecimal(paramMap.get("unitactualcost").toString());
            if (!isCostRecordDetail.booleanValue()) {
                BigDecimal bigDecimal = new BigDecimal(paramMap.get("materialcost").toString());
                BigDecimal unitMaterialCost = new BigDecimal(paramMap.get("unitmaterialcost").toString());
                BigDecimal processCost = new BigDecimal(paramMap.get("processcost").toString());
                BigDecimal unitProcessCost = new BigDecimal(paramMap.get("unitprocesscost").toString());
                BigDecimal bigDecimal2 = new BigDecimal(paramMap.get("fee").toString());
                BigDecimal resource = new BigDecimal(paramMap.get("resource").toString());
                BigDecimal manufactureCost = new BigDecimal(paramMap.get("manufacturecost").toString());
                if (bigDecimal2.compareTo(BigDecimal.ZERO) == 0 && manufactureCost.compareTo(BigDecimal.ZERO) == 0 && resource.compareTo(BigDecimal.ZERO) == 0) {
                    if (processCost.compareTo(BigDecimal.ZERO) == 0) {
                        unitactualcost = unitMaterialCost;
                    } else if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
                        unitactualcost = unitProcessCost;
                    }
                }
                if (unitMaterialCost.compareTo(BigDecimal.ZERO) < 0 || unitProcessCost.compareTo(BigDecimal.ZERO) < 0) {
                    String billnum = (String)paramMap.get("billno");
                    String errorMsg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u66f4\u65b0\u540e\u6750\u6599\u6210\u672c\u8ddf\u57fa\u672c\u6570\u91cf\u65b9\u5411\u76f8\u53cd\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"ExpBillCostTask_07", (String)"fi-cal-formplugin", (Object[])new Object[0]), billnum);
                    errBuffer.append(errorMsg);
                    continue;
                }
                Object[] purchaseParam = new Object[]{unitactualcost, actualcost, bigDecimal, unitMaterialCost, processCost, unitProcessCost, entryId};
                purchaseBill.add(purchaseParam);
                costDetailList.add(new Object[]{unitactualcost, actualcost, entryId, defaultMetriaElemnet});
            } else {
                List list = (List)paramMap.get("subElementInfoList");
                if (list == null) {
                    Object[] purchaseParam = new Object[]{unitactualcost, actualcost, actualcost, unitactualcost, BigDecimal.ZERO, BigDecimal.ZERO, entryId};
                    purchaseBill.add(purchaseParam);
                } else {
                    Object param22;
                    ArrayList<Object> subElementInfoList = new ArrayList<Object>(16);
                    for (Object param22 : list) {
                        subElementInfoList.add(JSONUtils.cast((String)param22, CostSubElementInfo.class));
                    }
                    boolean isNegSubEleUnitCost = Boolean.FALSE;
                    param22 = subElementInfoList.iterator();
                    while (param22.hasNext()) {
                        CostSubElementInfo costSubElementInfo = (CostSubElementInfo)param22.next();
                        BigDecimal subEleUnitCost = costSubElementInfo.getUnitActualCost();
                        if (subEleUnitCost.compareTo(BigDecimal.ZERO) >= 0) continue;
                        isNegSubEleUnitCost = Boolean.TRUE;
                        break;
                    }
                    if (isNegSubEleUnitCost) {
                        String billnum = (String)paramMap.get("billno");
                        String string = String.format(ResManager.loadKDString((String)"\r\n%1$s\u5355\u636e\u66f4\u65b0\u540e\u5b58\u5728\u5355\u4f4d\u6210\u672c\u5b50\u8981\u7d20\u5c0f\u4e8e0\u7684\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u66f4\u65b0", (String)"ExpBillCostTask_13", (String)"fi-cal-formplugin", (Object[])new Object[0]), billnum);
                        errBuffer.append(string);
                        continue;
                    }
                    for (CostSubElementInfo costSubElementInfo : subElementInfoList) {
                        long id = costSubElementInfo.getId();
                        BigDecimal subEleUnitCost = costSubElementInfo.getUnitActualCost();
                        BigDecimal subEleCost = costSubElementInfo.getActualCost();
                        costDetailList.add(new Object[]{subEleUnitCost, subEleCost, entryId, id});
                    }
                }
            }
            entryIdSet.add(entryId);
            idSet.add(costRecordId);
        }
        String billStatusValue = null;
        HashMap billStatusAndData = new HashMap(16);
        for (Map record : paramList) {
            List<Map> datas;
            Object billStatus = record.get("billstatus");
            String string = billStatusValue = billStatus == null ? null : (String)billStatus;
            if (!billStatusAndData.containsKey(billStatusValue)) {
                datas = new ArrayList(16);
                datas.add(record);
                billStatusAndData.put(billStatusValue, datas);
                continue;
            }
            datas = (List)billStatusAndData.get(billStatusValue);
            datas.add(record);
        }
        HashMap<String, Object> mark = new HashMap<String, Object>(16);
        for (Map.Entry entry : billStatusAndData.entrySet()) {
            String curStatus = (String)entry.getKey();
            List curData = (List)entry.getValue();
            if ("B".equals(curStatus)) {
                mark.put("isCommitStatus", "B".equals(billStatusValue));
                mark.put("costSrc", costSrc);
                this.dealUpdateSql(purchaseBill, costDetailList, entryIdSet, cacheMap, cosTypeMaterialMap, defaultElementIds, isCostRecordDetail, idSet, mark);
                HashMap tableAndId = new HashMap(16);
                for (Map map : curData) {
                    Set<Long> ids;
                    String tableName;
                    Long bizBillId = map.get("bizbillid") == null ? 0L : Long.parseLong(map.get("bizbillid").toString());
                    String string = tableName = map.get("bizentityobject") == null ? null : (String)map.get("bizentityobject");
                    if (!tableAndId.containsKey(tableName)) {
                        ids = new HashSet(16);
                        ids.add(bizBillId);
                        tableAndId.put(tableName, ids);
                        continue;
                    }
                    ids = (Set)tableAndId.get(tableName);
                    ids.add(bizBillId);
                }
                for (Map.Entry entry2 : tableAndId.entrySet()) {
                    Object row22;
                    String tableName = (String)entry2.getKey();
                    Set ids = (Set)entry2.getValue();
                    DynamicObject[] bizBillDycs = new SyncSimpleDycHelper().getSimpleBillDycs(tableName, (Collection)ids);
                    HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
                    hashMap.put("type", BalanceSourceEnum.DEAL_ABNORMAL_COST.getValue());
                    hashMap.put("billStatus", paramObjMap.get("BILLSTATUS"));
                    Map result = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBizService", (String)"doServiceSync", (Object[])new Object[]{ActionEnum.AUDIT.getValue(), hashMap, bizBillDycs});
                    if (result == null) continue;
                    Set preIds = result.keySet();
                    DataSet idAndBillNo = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)tableName, (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", preIds)}, null);
                    HashMap<Long, String> idAndBillNoMap = new HashMap<Long, String>(16);
                    for (Object row22 : idAndBillNo) {
                        Long id = row22.getLong("id");
                        String billNo = row22.getString("billno");
                        idAndBillNoMap.put(id, billNo);
                    }
                    if (idAndBillNoMap.isEmpty()) continue;
                    StringBuilder errIdAndMsg = new StringBuilder();
                    row22 = result.entrySet().iterator();
                    while (row22.hasNext()) {
                        Map.Entry info = (Map.Entry)row22.next();
                        Long preId = (Long)info.getKey();
                        String errReason = (String)info.getValue();
                        errIdAndMsg.append((String)idAndBillNoMap.get(preId)).append(" : ").append(errReason).append(" ");
                    }
                    String value = errIdAndMsg.toString();
                    if (StringUtils.isEmpty((CharSequence)value)) continue;
                    String errBillNos = value.length() > 2000 ? value.substring(0, 2000) : value;
                    String msg = ResManager.loadKDString((String)"\r\n\u5355\u636e\uff1a", (String)"ExpBillCostTask_6", (String)"fi-cal-formplugin", (Object[])new Object[0]);
                    errBuffer.append(msg).append(errBillNos);
                }
                continue;
            }
            mark.put("isCommitStatus", "B".equals(billStatusValue));
            mark.put("costSrc", costSrc);
            this.dealUpdateSql(purchaseBill, costDetailList, entryIdSet, cacheMap, cosTypeMaterialMap, defaultElementIds, isCostRecordDetail, idSet, mark);
        }
        return errBuffer.toString();
    }

    private String dealTwinsCostRecord(Map<Long, DynamicObject> twinsCostRecordMap, Map<String, Object> paramMap, List<Object[]> purchaseBill, Boolean isCostRecordDetail, Map<String, Long[]> cosTypeMaterialMap, List<Object[]> costDetailList, Set<Long> entryIdSet, long costTypeId, Set<Long> idSet) throws IOException {
        long bizEntryId = (Long)paramMap.get("bizentryid");
        DynamicObject twinsCostRecord = twinsCostRecordMap.get(bizEntryId);
        if (twinsCostRecord != null) {
            boolean isvoucher = twinsCostRecord.getBoolean("isvoucher");
            if (isvoucher) {
                return twinsCostRecord.getString("billno");
            }
            long groupEntryId = twinsCostRecord.getLong("entry.id");
            long groupId = twinsCostRecord.getLong("id");
            if (!isCostRecordDetail.booleanValue()) {
                BigDecimal materialCost = new BigDecimal(paramMap.get("materialcost").toString());
                BigDecimal unitMaterialCost = new BigDecimal(paramMap.get("unitmaterialcost").toString());
                BigDecimal processCost = new BigDecimal(paramMap.get("processcost").toString());
                BigDecimal unitProcessCost = new BigDecimal(paramMap.get("unitprocesscost").toString());
                if (unitMaterialCost.compareTo(BigDecimal.ZERO) < 0 || unitProcessCost.compareTo(BigDecimal.ZERO) < 0) {
                    return null;
                }
                BigDecimal bigDecimal = this.getFieldBigDecimal(twinsCostRecord, "entry.fee");
                BigDecimal groupResource = this.getFieldBigDecimal(twinsCostRecord, "entry.resource");
                BigDecimal groupManufactureCost = this.getFieldBigDecimal(twinsCostRecord, "entry.manufacturecost");
                BigDecimal groupBaseQty = this.getFieldBigDecimal(twinsCostRecord, "entry.baseqty");
                BigDecimal actualCost = materialCost.add(processCost).add(bigDecimal).add(groupResource).add(groupManufactureCost);
                BigDecimal groupUnitActualCost = actualCost.divide(groupBaseQty, 10, 4);
                Object[] groupPurchaseParam = new Object[]{groupUnitActualCost, actualCost, materialCost, unitMaterialCost, processCost, unitProcessCost, groupEntryId};
                purchaseBill.add(groupPurchaseParam);
                Long[] defaultElementIds = CostElementHelper.getDefaultMaterialElements();
                Long defaultMetriaElemnet = defaultElementIds[0];
                costDetailList.add(new Object[]{unitMaterialCost, materialCost, groupEntryId, defaultMetriaElemnet});
            } else {
                List paramStrList = (List)paramMap.get("subElementInfoList");
                if (paramStrList == null) {
                    BigDecimal actualcost = new BigDecimal(paramMap.get("actualcost").toString());
                    BigDecimal unitactualcost = new BigDecimal(paramMap.get("unitactualcost").toString());
                    Object[] purchaseParam = new Object[]{unitactualcost, actualcost, actualcost, unitactualcost, BigDecimal.ZERO, BigDecimal.ZERO, groupEntryId};
                    purchaseBill.add(purchaseParam);
                } else {
                    ArrayList<Object> subElementInfoList = new ArrayList<Object>(16);
                    for (String param : paramStrList) {
                        subElementInfoList.add(JSONUtils.cast((String)param, CostSubElementInfo.class));
                    }
                    boolean isNegSubEleUnitCost = Boolean.FALSE;
                    for (CostSubElementInfo costSubElementInfo : subElementInfoList) {
                        BigDecimal subEleUnitCost = costSubElementInfo.getUnitActualCost();
                        if (subEleUnitCost.compareTo(BigDecimal.ZERO) >= 0) continue;
                        isNegSubEleUnitCost = Boolean.TRUE;
                        break;
                    }
                    if (isNegSubEleUnitCost) {
                        return null;
                    }
                    for (CostSubElementInfo costSubElementInfo : subElementInfoList) {
                        long id = costSubElementInfo.getId();
                        BigDecimal subEleUnitCost = costSubElementInfo.getUnitActualCost();
                        BigDecimal subEleCost = costSubElementInfo.getActualCost();
                        costDetailList.add(new Object[]{subEleUnitCost, subEleCost, groupEntryId, id});
                    }
                }
            }
            entryIdSet.add(groupEntryId);
            idSet.add(groupId);
        }
        return null;
    }

    private void dealUpdateSql(List<Object[]> purchaseBill, List<Object[]> costDetailList, Set<Long> entryIdSet, Map<String, Object> cacheMap, Map<String, Long[]> cosTypeMaterialMap, Long[] defaultElementIds, Boolean isCostRecordDetail, Set<Long> idSet, Map<String, Object> mark) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                Set splitEntryIdSet;
                String costSrcFromExpBill;
                boolean isCommitStatus = mark.get("isCommitStatus") == null ? Boolean.FALSE.booleanValue() : ((Boolean)mark.get("isCommitStatus")).booleanValue();
                String string = costSrcFromExpBill = mark.get("costSrc") == null ? "" : (String)mark.get("costSrc");
                if (null != purchaseBill && !purchaseBill.isEmpty()) {
                    DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)this.getPurchaseUpdateSql(CostSrcEnum.EXPBILL.getValue().equals(costSrcFromExpBill)), purchaseBill);
                }
                if (!costDetailList.isEmpty()) {
                    DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)this.getCostRecordDetailSql(), costDetailList);
                    if (null == purchaseBill || purchaseBill.isEmpty()) {
                        CostElementHelper.calCostRecordAllCost((Long[])entryIdSet.toArray(new Long[0]), idSet);
                    }
                }
                if (!entryIdSet.isEmpty()) {
                    this.updateCostPriceSource(entryIdSet);
                }
                if (!isCommitStatus && !entryIdSet.isEmpty()) {
                    boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
                    if (isNewBalance) {
                        DLock lock = DLock.createReentrant((String)(this.costAccountId + "expcostbal"), (String)"fi-cal-ExpBillCostTask-dlock-bal");
                        CalDLockHelper.releaseLockAfterTxEnd(Collections.singletonList(lock));
                        try (TraceSpan span = Tracer.create((String)"ExpBillCostTask-newbal", (String)"ExpBillCostTask-newbal");){
                            lock.lock();
                            BalanceOpInvoker balanceOpInvoker = new BalanceOpInvoker();
                            balanceOpInvoker.setBillStatus("C");
                            balanceOpInvoker.invokeCostRecordUpdateBalOp(idSet, BalanceSourceEnum.DEAL_ABNORMAL_COST);
                        }
                    } else {
                        BalanceCalculator calculator = new BalanceCalculator();
                        calculator.updateBalance4Others(entryIdSet.toArray(new Object[entryIdSet.size()]), BalanceSourceEnum.DEAL_ABNORMAL_COST);
                    }
                }
                if (!(splitEntryIdSet = (Set)cacheMap.get("splitEntryIdSet")).isEmpty()) {
                    new ChildBillCostUpdateHelper(cosTypeMaterialMap, defaultElementIds, isCostRecordDetail.booleanValue()).updateChildBillCost(splitEntryIdSet, costSrcFromExpBill);
                }
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private void updateCostPriceSource(Set<Long> entryIdSet) {
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(16);
        QFilter pricesourceqf = new QFilter("entry.id", "in", entryIdSet);
        try (DataSet pricesourceds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"entry.id as entryid,entry.costpricesource as costpricesource", (QFilter[])pricesourceqf.toArray(), null);){
            for (Row pricesourced : pricesourceds) {
                Long entryid = pricesourced.getLong("entryid");
                String oldcostpricesource = pricesourced.getString("costpricesource");
                String newcostpricesource = CostPriceSourceTypeEnum.getCostPriceSourceValue((String)oldcostpricesource, (String)CostPriceSourceTypeEnum.EXP_BILL_SPECIFICATION.getValue());
                sqlParams.add(new Object[]{newcostpricesource, CostPriceSourceTypeEnum.EXP_BILL_SPECIFICATION.getDesignated(), entryid});
            }
            if (sqlParams.size() > 0) {
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)CostPriceSourceTypeEnum.getCostpriceSourceSql(), sqlParams);
            }
        }
    }

    private BigDecimal getFieldBigDecimal(DynamicObject twinsCostRecord, String field) {
        BigDecimal cost = twinsCostRecord.getBigDecimal(field);
        return cost == null ? BigDecimal.ZERO : cost;
    }

    private Map<String, Object> cacheActualCostMap(List<Map<String, Object>> paramList) {
        HashMap<String, Object> cacheMap = new HashMap<String, Object>();
        HashSet<Long> entryIdSet = new HashSet<Long>(100);
        HashSet<Long> bizBillEntryIdSet = new HashSet<Long>(100);
        long costAccountId = 0L;
        long bizEntryId = 0L;
        for (Map<String, Object> map : paramList) {
            entryIdSet.add((Long)map.get("entryid"));
            costAccountId = (Long)map.get("costaccountid");
            bizEntryId = (Long)map.get("bizentryid");
            bizBillEntryIdSet.add(bizEntryId);
        }
        DynamicObjectCollection actualCostCol = QueryServiceHelper.query((String)"cal_costrecord", (String)"issplit,entry.id,entry.actualcost", (QFilter[])new QFilter("entry.id", "in", entryIdSet).toArray());
        HashMap<Long, BigDecimal> oldActualCostMap = new HashMap<Long, BigDecimal>();
        boolean issplit = false;
        HashSet<Long> splitEntryIdSet = new HashSet<Long>();
        long entryId = 0L;
        for (DynamicObject entity : actualCostCol) {
            entryId = entity.getLong("entry.id");
            oldActualCostMap.put(entryId, entity.getBigDecimal("entry.actualcost"));
            issplit = entity.getBoolean("issplit");
            if (!issplit) continue;
            splitEntryIdSet.add(entryId);
        }
        cacheMap.put("oldActualCostMap", oldActualCostMap);
        cacheMap.put("splitEntryIdSet", splitEntryIdSet);
        QFilter twinsFilter = new QFilter("costaccount", "=", (Object)costAccountId);
        twinsFilter.and("entry.bizbillentryid", "in", bizBillEntryIdSet);
        twinsFilter.and("issplitcreate", "=", (Object)Boolean.FALSE);
        DynamicObjectCollection twinsCostRecords = QueryServiceHelper.query((String)"cal_costrecord", (String)"id,isvoucher,billno,entry.material.id,entry.bizbillentryid,entry.id,entry.materialcost,entry.fee,entry.resource,entry.actualcost,entry.manufacturecost,entry.processcost,entry.baseqty", (QFilter[])twinsFilter.toArray());
        long bizbillentryid = 0L;
        long twinsEntryId = 0L;
        HashMap<Long, DynamicObject> twinsCostRecordMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject costRecord : twinsCostRecords) {
            twinsEntryId = costRecord.getLong("entry.id");
            if (entryIdSet.contains(twinsEntryId)) continue;
            bizbillentryid = costRecord.getLong("entry.bizbillentryid");
            twinsCostRecordMap.put(bizbillentryid, costRecord);
        }
        cacheMap.put("twinsCostRecordMap", twinsCostRecordMap);
        return cacheMap;
    }

    private void caculateDetailUnitActual(List<Long> entryIdSet) {
        DynamicObject[] costDetailArray;
        for (DynamicObject costDetail : costDetailArray = BusinessDataServiceHelper.load((String)"cal_costrecord_detail", (String)"id,entryid,costsubelement,actualcost,unitactualcost,costsubelement.id,baseqty,standardcost,unitstandardcost,currency.priceprecision", (QFilter[])new QFilter("entryid", "in", entryIdSet).toArray())) {
            BigDecimal actualcost = costDetail.getBigDecimal("actualcost");
            BigDecimal baseqty = costDetail.getBigDecimal("baseqty");
            if (baseqty.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal unitActualcost = actualcost.divide(baseqty, 10, 4);
            costDetail.set("unitactualcost", (Object)unitActualcost);
        }
        SaveServiceHelper.save((DynamicObject[])costDetailArray);
    }

    private String getPurchaseUpdateSql(boolean costSrcFromExpBill) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cal_calcostrecordentry set ");
        sql.append(" funitactualcost = ? ,factualcost = ?, ");
        sql.append(" fmaterialcost = ?,funitmaterialcost= ?, ");
        sql.append(" fprocesscost = ?,funitprocesscost= ? ");
        sql.append(" ,fcostsrc = 'D'");
        sql.append(" where fentryid = ?");
        return sql.toString();
    }

    private String getCostRecordDetailSql() {
        return " update t_cal_costrecord_detail set funitactualcost = ?, factualcost = ? where fentryid = ? and fcostsubelementid = ?";
    }
}

