/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.calculate.in;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.business.balance.BalanceCalculator;
import kd.fi.cal.business.balance.BalanceSourceEnum;
import kd.fi.cal.business.process.inner.PrevCostAdjustProcessHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBillDiffTypeEnum;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.FeeShareHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.model.CostAdjustDetailParams;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.formplugin.calculate.in.FeeShareCommonAlgo;
import kd.fi.cal.formplugin.calculate.in.FeeSharePrepare;
import kd.fi.cal.formplugin.calculate.in.FeeShareRelation;

public class ExpenseItemFeeShare
extends FeeShareCommonAlgo {
    private boolean isNewBalance = CalBalanceModelHelper.isNewBalance();

    @Override
    public void prepareFeeShare(FeeSharePrepare feeSharePrepare, Map<String, Object> matchAndAsstAccountMap, FeeShareRelation feeShareRelation, List<DynamicObject> asstBills) {
        super.prepareFeeShare(feeSharePrepare, matchAndAsstAccountMap, feeShareRelation, asstBills);
        feeSharePrepare.dynamicField((Map)matchAndAsstAccountMap.get("asstCostRecordEntryIdMap"), feeShareRelation, asstBills);
    }

    @Override
    public void shareCostRecord(BigDecimal asstshareCost, BigDecimal mainShareCost, BigDecimal pageShareCost, DynamicObject shareRecord) {
        DynamicObject asstBill = this.feeShareRelation.getAsstBill();
        DynamicObject asstBillParent = this.feeShareRelation.getAsstParentObj();
        DynamicObject mainBillParent = this.feeShareRelation.getMainParentObj();
        long asstBillId = asstBill.getLong("id");
        long shareId = shareRecord.getLong("id");
        long supplierId = mainBillParent.getLong("asstact.id");
        String accountType = asstBill.getString("accounttype");
        this.updateCostIsallocate(asstBillId);
        if (AccountTypeEnum.STANDARDCOST.getValue().equals(accountType)) {
            this.updateParams.createStdCostDiffBill(this.feeShareRelation, asstshareCost, shareId, supplierId, this.feeSharePrepare, Boolean.FALSE, CostAdjustBillDiffTypeEnum.FEE_DIFF.getValue());
            this.updateParams.addTotalShareFee(shareId, asstBillId, asstshareCost);
        } else {
            boolean enablestandardcost = asstBillParent.getDynamicObject("costaccount").getBoolean("enablestandardcost");
            if (enablestandardcost) {
                this.updateParams.createCostAdjustBill(this.feeShareRelation, asstshareCost, shareId, supplierId, this.feeSharePrepare, Boolean.FALSE, CostAdjustBillDiffTypeEnum.FEE_DIFF.getValue());
            }
            Date mainBillDate = mainBillParent.getDate("bookdate");
            Long calOrgId = asstBillParent.getDynamicObject("calorg").getLong("id");
            String writeBackMessage = (String)ParamsHelper.getAppParam((long)calOrgId, (String)"issameperiodwriteback");
            if (writeBackMessage == null) {
                writeBackMessage = "A";
            }
            boolean nowriteBack = true;
            if ("A".equals(writeBackMessage) && PeriodHelper.isSamePeriod((DynamicObject)asstBillParent, (Date)mainBillDate)) {
                nowriteBack = this.isUpdateCostAjust(asstBillParent, asstBill);
            }
            if (nowriteBack) {
                this.updateParams.createCostAdjustBill(this.feeShareRelation, asstshareCost, shareId, supplierId, this.feeSharePrepare, Boolean.FALSE, CostAdjustBillDiffTypeEnum.ACT_COST.getValue());
                this.updateParams.addTotalShareFee(shareId, asstBillId, asstshareCost);
            } else {
                long costTypeId = asstBillParent.getDynamicObject("costaccount").getLong("costtype_id");
                long costAccountId = asstBillParent.getDynamicObject("costaccount").getLong("id");
                BigDecimal substractAmt = this.updateParams.addCostRecordDetailList(this.feeSharePrepare, asstBill, asstshareCost, this.feeShareRelation, costTypeId, costAccountId);
                this.updateParams.addRecordFeeParams(asstBillId, substractAmt);
                this.updateParams.setRecordFeeEntryIdSet(asstBillId);
                this.updateParams.addVerifyRecordDetailList(this.feeShareRelation, substractAmt, asstshareCost, shareId);
            }
        }
        this.updateParams.addRecordTotalParams(asstshareCost, asstBillId);
        Date maxDate = this.updateParams.getMaxDateFromMainAsstBill(this.feeShareRelation.getMainParentObj(), this.feeShareRelation.getAsstParentObj(), "bizdate");
        Date maxBookDate = this.updateParams.getMaxDateFromMainAsstBill(this.feeShareRelation.getMainParentObj(), this.feeShareRelation.getAsstParentObj(), "bookdate");
        Map adjustBillMap = FeeShareHelper.multiCostEstCostAdjust(this.feeSharePrepare.getMultiCostEstCostAdjust(), (Date)maxDate, (Date)maxBookDate, (Long)asstBillId, (Long)shareId, (Long)supplierId);
        this.updateParams.addFeeShareParams(adjustBillMap);
        Map stdCostDiffBillMap = FeeShareHelper.multiCostEstStdCostDiffBill(this.feeSharePrepare.getMultiCostEstStdCostDiffBill(), (Date)maxDate, (Date)maxBookDate, (Long)asstBillId, (Long)shareId, (Long)supplierId);
        this.updateParams.addFeeShareStdCostDiffBillParams(stdCostDiffBillMap);
    }

    @Override
    public void updateSqlOp(FeeSharePrepare feeSharePrepare) {
        this.updateCostEstCostAdjustBill();
        this.updateCostEstStdCostDiffBill();
        this.updateCostRecord();
        this.updateCostIsallocate();
        this.updateCostRecordDetail();
        this.updateCostRecordUnitField();
        this.updateBalanceAmt(feeSharePrepare);
        this.createCostAdjust();
        this.createStdCostDiffBill();
        this.createTotalShareFee();
        this.createShareRecoerd();
        this.updaetFinapBill(feeSharePrepare);
    }

    private void createTotalShareFee() {
        List<DynamicObject> totalSharefeeList = this.updateParams.getTotalSharefeeList();
        if (totalSharefeeList.isEmpty()) {
            return;
        }
        DynamicObject[] totalSharefeeArray = new DynamicObject[totalSharefeeList.size()];
        totalSharefeeList.toArray(totalSharefeeArray);
        SaveServiceHelper.save((DynamicObject[])totalSharefeeArray);
    }

    private void updateBalanceAmt(FeeSharePrepare feeSharePrepare) {
        Set<Long> recordFeeEntryIdSet = this.updateParams.getRecordFeeEntryIdSet();
        if (this.isNewBalance) {
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id", (QFilter[])new QFilter("entry.id", "in", recordFeeEntryIdSet).toArray(), null);){
                for (Row row : dataSet) {
                    feeSharePrepare.getSuccAssBillIds().add(row.getLong("id"));
                }
            }
        } else if (CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.DAILY_BAL).booleanValue()) {
            BalanceCalculator calculator = new BalanceCalculator();
            calculator.updateBalance4Others(recordFeeEntryIdSet.toArray(new Object[recordFeeEntryIdSet.size()]), BalanceSourceEnum.FEE_DIVIDE);
        }
    }

    private void updateCostRecordUnitField() {
        Set<Long> successCostRecord = this.updateParams.getRecordFeeEntryIdSet();
        DynamicObjectCollection costRecordCollection = QueryServiceHelper.query((String)"cal_costrecord", (String)"id,localcurrency.amtprecision,entry.id,entry.baseqty,entry.fee,entry.unitactualcost", (QFilter[])new QFilter("entry.id", "in", successCostRecord).toArray());
        if (costRecordCollection.isEmpty()) {
            return;
        }
        ArrayList<Object[]> costRecordObjList = new ArrayList<Object[]>();
        for (DynamicObject costRecord : costRecordCollection) {
            BigDecimal unitActualcost = costRecord.getBigDecimal("entry.unitactualcost");
            if (unitActualcost.compareTo(BigDecimal.ZERO) < 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5206\u644a\u540e\u5355\u4f4d\u5b9e\u9645\u6210\u672c\u4e3a\u8d1f\u6570\u3002", (String)"FeeShareVerifyTask_12", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
            int amtprecision = 10;
            BigDecimal fee = costRecord.getBigDecimal("entry.fee");
            BigDecimal baseQty = costRecord.getBigDecimal("entry.baseqty");
            BigDecimal unitFee = fee.divide(baseQty, amtprecision, 4);
            Object[] costRecordObj = new Object[]{unitFee, costRecord.getLong("entry.id")};
            costRecordObjList.add(costRecordObj);
        }
        DB.executeBatch((DBRoute)this.getCalDBRouteKey(), (String)this.getCostRecordUpdateUnitFieldSql(), costRecordObjList);
    }

    private String getCostRecordUpdateUnitFieldSql() {
        return " update t_cal_calcostrecordentry set  funitfee = ? where fentryid = ?";
    }

    private void updateCostRecordDetail() {
        Set<Long> recordFeeEntryIdSet = this.updateParams.getRecordFeeEntryIdSet();
        if (recordFeeEntryIdSet.isEmpty()) {
            return;
        }
        List<Object[]> costRecordDetailList = this.updateParams.getCostRecordDetailList();
        DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)FeeShareHelper.getAddCostRecordDetailSql(), costRecordDetailList);
        FeeShareHelper.caculateDetailUnitActual(recordFeeEntryIdSet);
        CostElementHelper.calCostpricesourceRecordCost((Long[])recordFeeEntryIdSet.toArray(new Long[recordFeeEntryIdSet.size()]), (String)"ExpenseItemFeeShare");
    }

    private void updateCostIsallocate() {
        List<Object[]> isallocate = this.updateParams.getIsallocate();
        if (isallocate.isEmpty()) {
            return;
        }
        DB.executeBatch((DBRoute)this.getCalDBRouteKey(), (String)"update T_CAL_CALCOSTRECORDENTRY set fisallocate=1 where fentryid = ?", isallocate);
    }

    private void updateCostRecord() {
        List<Object[]> recordFeeParams;
        List<Object[]> recordTotalParams = this.updateParams.getRecordTotalParams();
        if (!recordTotalParams.isEmpty()) {
            DB.executeBatch((DBRoute)this.getCalDBRouteKey(), (String)this.getCostRecordUpdateSql(), recordTotalParams);
        }
        if (!(recordFeeParams = this.updateParams.getRecordFeeParams()).isEmpty()) {
            DB.executeBatch((DBRoute)this.getCalDBRouteKey(), (String)this.getCostRecordFeeUpdateSql(), recordFeeParams);
        }
    }

    private String getCostRecordFeeUpdateSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cal_calcostrecordentry set ");
        sql.append(" ffee = ffee + ?  ");
        sql.append(" where fentryid = ? ");
        return sql.toString();
    }

    private String getCostRecordUpdateSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cal_calcostrecordentry set ");
        sql.append(" ftotalsharefee = ftotalsharefee + ? ");
        sql.append(" where fentryid = ? ");
        return sql.toString();
    }

    protected DBRoute getCalDBRouteKey() {
        return new DBRoute("cal");
    }

    private void updateCostEstCostAdjustBill() {
        List<DynamicObject> costEstAdjustBillArray = this.updateParams.getCostEstAdjustBillArray();
        List<DynamicObject> feeShareAdjustBillArray = this.updateParams.getFeeShareAdjustBillArray();
        if (costEstAdjustBillArray.size() == 0) {
            return;
        }
        SaveServiceHelper.save((DynamicObject[])costEstAdjustBillArray.toArray(new DynamicObject[costEstAdjustBillArray.size()]));
        SaveServiceHelper.save((DynamicObject[])feeShareAdjustBillArray.toArray(new DynamicObject[feeShareAdjustBillArray.size()]));
        HashSet<Long> set = new HashSet<Long>(feeShareAdjustBillArray.size());
        for (DynamicObject info : feeShareAdjustBillArray) {
            set.add(info.getLong("id"));
        }
        DynamicObject[] costAdjusts = BusinessDataServiceHelper.load((Object[])set.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cal_costadjust_subentity"));
        List<CostAdjustDetailParams> paramsList = this.updateParams.getParamsList();
        OperateOption option = OperateOption.create();
        String params = SerializationUtils.toJsonString(paramsList);
        option.setVariableValue("CostAdjustDetailParms", params);
        option.setVariableValue("ishasright", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_costadjust_subentity", (DynamicObject[])costAdjusts, (OperateOption)option);
        if (!result.isSuccess()) {
            StringBuilder errorInfo = new StringBuilder();
            errorInfo.append(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u5ba1\u6838\u5931\u8d25\uff1a", (String)"FeeShareVerifyTask_11", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            List errors = result.getAllErrorOrValidateInfo();
            if (errors != null && !errors.isEmpty()) {
                for (IOperateInfo error : errors) {
                    OperateInfo operror = (OperateInfo)error;
                    errorInfo.append(operror.getMessage());
                }
            }
            errorInfo.append(result.getMessage());
            throw new KDBizException(errorInfo.toString());
        }
        PrevCostAdjustProcessHelper prevCostAdjustProcessHelper = new PrevCostAdjustProcessHelper();
        prevCostAdjustProcessHelper.dealOutAdjustSet(set);
    }

    private void updateCostEstStdCostDiffBill() {
        List<DynamicObject> costEstAdjustBillArray = this.updateParams.getCostEstStdcostDiffBillArray();
        List<DynamicObject> feeShareAdjustBillArray = this.updateParams.getFeeShareStdCostDiffBillArray();
        if (costEstAdjustBillArray.size() == 0) {
            return;
        }
        SaveServiceHelper.save((DynamicObject[])costEstAdjustBillArray.toArray(new DynamicObject[costEstAdjustBillArray.size()]));
        SaveServiceHelper.save((DynamicObject[])feeShareAdjustBillArray.toArray(new DynamicObject[feeShareAdjustBillArray.size()]));
        HashSet<Long> set = new HashSet<Long>(feeShareAdjustBillArray.size());
        for (DynamicObject info : feeShareAdjustBillArray) {
            set.add(info.getLong("id"));
        }
        DynamicObject[] costAdjusts = BusinessDataServiceHelper.load((Object[])set.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cal_stdcostdiffbill"));
        List<CostAdjustDetailParams> paramsList = this.updateParams.getParamsStdCostDiffBillList();
        OperateOption option = OperateOption.create();
        String params = SerializationUtils.toJsonString(paramsList);
        option.setVariableValue("CostAdjustDetailParms", params);
        option.setVariableValue("ishasright", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_stdcostdiffbill", (DynamicObject[])costAdjusts, (OperateOption)option);
        if (!result.isSuccess()) {
            StringBuilder errorInfo = new StringBuilder();
            errorInfo.append(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u5ba1\u6838\u5931\u8d25\uff1a", (String)"FeeShareVerifyTask_11", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            List errors = result.getAllErrorOrValidateInfo();
            if (errors != null && !errors.isEmpty()) {
                for (IOperateInfo error : errors) {
                    OperateInfo operror = (OperateInfo)error;
                    errorInfo.append(operror.getMessage());
                }
            }
            errorInfo.append(result.getMessage());
            throw new KDBizException(errorInfo.toString());
        }
    }

    private boolean isUpdateCostAjust(DynamicObject asstParentBill, DynamicObject asstBill) {
        Date bizDate = asstParentBill.getDate("bizdate");
        Date beginDate = this.feeSharePrepare.getOrgIdMaxPeriodsDate().get(asstParentBill.getDynamicObject("costaccount").getLong("id"));
        boolean isCher = asstParentBill.getBoolean("isvoucher");
        boolean realTime = AccountTypeEnum.MOVE_ADD_AVERAGE.getValue().equals(asstBill.getString("accounttype")) || AccountTypeEnum.FIN_FOUT.getValue().equals(asstBill.getString("accounttype"));
        boolean bizDateFlag = bizDate.compareTo(beginDate) < 0;
        return bizDateFlag || realTime || isCher;
    }

    private void updateCostIsallocate(long asstBillId) {
        boolean existFeeShareRecord = this.feeSharePrepare.getVerCalEntryIdSet().contains(asstBillId);
        if (existFeeShareRecord) {
            Object[] asstBillIdObj = new Object[]{asstBillId};
            this.updateParams.addIsallocate(asstBillIdObj);
        }
    }
}

