/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.calculate.in;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.business.process.inner.PrevCostAdjustProcessHelper;
import kd.fi.cal.business.sharemodel.AmtShareModel;
import kd.fi.cal.business.sharemodel.AmtShareParams;
import kd.fi.cal.business.sharemodel.IStandardAmtExchange;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.model.CostAdjustDetailParams;
import kd.fi.cal.formplugin.calculate.in.FeeShareAlgorithm;
import kd.fi.cal.formplugin.calculate.in.FeeSharePrepare;
import kd.fi.cal.formplugin.calculate.in.FeeShareRelation;
import kd.fi.cal.formplugin.calculate.in.FeeShareUpdateParams;

public abstract class FeeShareCommonAlgo
implements FeeShareAlgorithm {
    protected FeeSharePrepare feeSharePrepare;
    protected AmtShareModel sharemodel;
    protected FeeShareRelation feeShareRelation;
    protected List<DynamicObject> asstBills;
    protected List<DynamicObject> asstUnMainAccount;
    protected FeeShareUpdateParams updateParams;

    @Override
    public void prepareFeeShare(FeeSharePrepare feeSharePrepare, Map<String, Object> matchAndAsstAccountMap, FeeShareRelation feeShareRelation, List<DynamicObject> asstBills) {
        this.feeSharePrepare = feeSharePrepare;
        this.asstBills = asstBills;
        this.sharemodel = this.getAmtShareModel(feeShareRelation, asstBills, feeSharePrepare);
        this.feeShareRelation = feeShareRelation;
        this.asstUnMainAccount = (List)matchAndAsstAccountMap.get("asstUnMainAccount");
        this.updateParams = new FeeShareUpdateParams(feeShareRelation.getMainBill().getLong("id"));
    }

    @Override
    public void excuteFeeShare(FeeSharePrepare feeSharePrepare, Map<String, Object> matchAndAsstAccountMap, FeeShareRelation feeShareRelation, List<DynamicObject> asstBills) {
        this.prepareFeeShare(feeSharePrepare, matchAndAsstAccountMap, feeShareRelation, asstBills);
        DynamicObject shareRecord = this.createMainBillRecord();
        Map<Long, Boolean> supportTaxAmtMap = this.feeSharePrepare.getSuppotTaxAmtMap();
        for (DynamicObject asstBill : this.asstBills) {
            this.feeShareRelation.setAsstBill(asstBill);
            this.shareAsstBill(shareRecord, supportTaxAmtMap);
        }
        this.updateParams.addShareRecordList(shareRecord);
        this.updateSqlOp(feeSharePrepare);
    }

    private AmtShareModel getAmtShareModel(FeeShareRelation feeShareRelation, List<DynamicObject> asstBills, FeeSharePrepare feeSharePrepare) {
        DynamicObject mainCurrency = feeShareRelation.getMainParentObj().getDynamicObject("currency");
        DynamicObject baseCurrency = feeShareRelation.getMainParentObj().getDynamicObject("basecurrency");
        AmtShareParams param = new AmtShareParams();
        param.setDividestandard(feeSharePrepare.getShareStandard());
        param.setExchange(feeSharePrepare.getIchange());
        param.setSharebills(asstBills);
        BigDecimal interCostAmt = feeShareRelation.getMainBill().getBigDecimal("intercostamt");
        if (interCostAmt != null && interCostAmt.compareTo(BigDecimal.ZERO) != 0) {
            param.setIsInterCostAmt(Boolean.TRUE);
            param.setBizdate(feeShareRelation.getMainParentObj().getDate("exratedate"));
            param.setSourcecurrency(baseCurrency);
            param.setTotalsourceamt(interCostAmt);
            param.setTotalsourcetaxamt(interCostAmt);
        } else {
            param.setIsInterCostAmt(Boolean.FALSE);
            param.setBizdate(feeSharePrepare.getShareDate());
            param.setSourcecurrency(mainCurrency);
            param.setTotalsourceamt(feeShareRelation.getMainBill().getBigDecimal("e_amount"));
            param.setTotalsourcetaxamt(feeShareRelation.getMainBill().getBigDecimal("e_pricetaxtotal"));
        }
        AmtShareModel sharemodel = new AmtShareModel(param);
        return sharemodel;
    }

    private DynamicObject createMainBillRecord() {
        DynamicObject mainBillParent = this.feeShareRelation.getMainParentObj();
        DynamicObject mainBill = this.feeShareRelation.getMainBill();
        DynamicObject shareRecord = BusinessDataServiceHelper.newDynamicObject((String)"cal_fee_sharerecord");
        shareRecord.set("id", (Object)DB.genLongId((String)"cal_fee_sharerecord"));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        long shareNum = Long.parseLong(simpleDateFormat.format(new Date()));
        shareRecord.set("billno", (Object)shareNum);
        shareRecord.set("org", (Object)this.feeSharePrepare.getCalorg());
        shareRecord.set("createtime", (Object)new Date(this.feeSharePrepare.getShareNum()));
        if (this.sharemodel.isInterCostAmt().booleanValue()) {
            shareRecord.set("maincurrency", (Object)mainBillParent.getDynamicObject("basecurrency"));
            shareRecord.set("sharedate", (Object)mainBillParent.getDate("exratedate"));
        } else {
            shareRecord.set("maincurrency", (Object)mainBillParent.getDynamicObject("currency"));
            shareRecord.set("sharedate", (Object)this.feeSharePrepare.getShareDate());
        }
        shareRecord.set("sharestandard", (Object)this.feeSharePrepare.getShareStandard());
        DynamicObject entity = shareRecord.getDynamicObjectCollection("entry").addNew();
        entity.set("billtype", (Object)mainBillParent.getDynamicObject("billtypeid"));
        entity.set("billtypeid", (Object)mainBillParent.getLong("id"));
        entity.set("billentryid", (Object)mainBill.getLong("id"));
        entity.set("bizbillentryid", (Object)mainBill.getLong("e_sourcebillentryid"));
        entity.set("billnum", mainBillParent.get("billno"));
        entity.set("bizdate", (Object)((Date)mainBillParent.get("bizdate")));
        entity.set("bookdate", (Object)mainBillParent.getDate("bookdate"));
        entity.set("asstacttype", mainBillParent.get("asstacttype"));
        entity.set("asstact", mainBillParent.get("asstact"));
        entity.set("billseq", mainBill.get("seq"));
        entity.set("material", (Object)mainBill.getDynamicObject("material"));
        entity.set("expenseitem", (Object)mainBill.getDynamicObject("expenseitem"));
        entity.set("currency", (Object)mainBillParent.getDynamicObject("currency"));
        entity.set("e_amount", (Object)mainBill.getBigDecimal("e_amount"));
        entity.set("e_taxamount", (Object)mainBill.getBigDecimal("e_pricetaxtotal"));
        entity.set("sharecurrency", (Object)this.feeSharePrepare.getSharecurrency());
        entity.set("shareamount", (Object)this.sharemodel.getTotalStandardAmt());
        entity.set("sharetaxamount", (Object)this.sharemodel.getTotalStandardTaxAmt());
        entity.set("shareuser", (Object)Long.valueOf(RequestContext.get().getUserId()));
        entity.set("ismianbill", (Object)"1");
        entity.set("billentityid", (Object)"ap_finapbill");
        return shareRecord;
    }

    protected void createAsstBillRecord(FeeShareRelation feeShareRelation, BigDecimal original_mainShareCost, BigDecimal original_pageShareCost, BigDecimal original_mainShareTaxCost, BigDecimal original_pageShareTaxCost, DynamicObject shareRecord, DynamicObject sharecurrency) {
        DynamicObject mainBill = feeShareRelation.getMainBill();
        DynamicObject mainParentBill = feeShareRelation.getMainParentObj();
        DynamicObject asstParentBill = feeShareRelation.getAsstParentObj();
        DynamicObject asstBillId = feeShareRelation.getAsstBill();
        DynamicObject entity = shareRecord.getDynamicObjectCollection("entry").addNew();
        entity.set("billtype", asstParentBill.get("billtype"));
        entity.set("billtypeid", (Object)asstParentBill.getLong("id"));
        entity.set("billentryid", (Object)asstBillId.getLong("id"));
        entity.set("bizbillentryid", (Object)asstBillId.getLong("bizbillentryid"));
        entity.set("calentryid", (Object)asstBillId.getLong("calentryid"));
        entity.set("billnum", asstParentBill.get("billno"));
        entity.set("billseq", asstBillId.get("seq"));
        entity.set("bizdate", (Object)((Date)asstParentBill.get("bizdate")));
        entity.set("bookdate", (Object)asstParentBill.getDate("bookdate"));
        entity.set("material", (Object)asstBillId.getDynamicObject("material"));
        entity.set("expenseitem", (Object)mainBill.getDynamicObject("expenseitem"));
        entity.set("currency", (Object)asstParentBill.getDynamicObject("localcurrency"));
        entity.set("e_amount", (Object)original_mainShareCost);
        entity.set("e_taxamount", (Object)original_mainShareTaxCost);
        entity.set("sharecurrency", (Object)sharecurrency);
        entity.set("shareamount", (Object)original_pageShareCost);
        entity.set("sharetaxamount", (Object)original_pageShareTaxCost);
        entity.set("shareuser", (Object)Long.valueOf(RequestContext.get().getUserId()));
        entity.set("asstacttype", mainParentBill.get("asstacttype"));
        entity.set("asstact", mainParentBill.get("asstact"));
        entity.set("ismianbill", (Object)"0");
        entity.set("billentityid", (Object)"cal_costrecord_subentity");
    }

    protected void shareAsstBill(DynamicObject shareRecord, Map<Long, Boolean> supportTaxAmtMap) {
        DynamicObject mainCurrency = this.sharemodel.isInterCostAmt() != false ? this.feeShareRelation.getMainParentObj().getDynamicObject("basecurrency") : this.feeShareRelation.getMainParentObj().getDynamicObject("currency");
        DynamicObject asstBillCurrency = this.feeShareRelation.getAsstParentObj().getDynamicObject("localcurrency");
        BigDecimal original_mainShareCost = this.sharemodel.getSharedBillAmt(this.feeShareRelation.getAsstBill().get("id"), mainCurrency);
        BigDecimal original_pageShareCost = this.sharemodel.getSharedStandardAmt(this.feeShareRelation.getAsstBill().get("id"));
        BigDecimal original_mainShareTaxCost = this.sharemodel.getSharedBillTaxAmt(this.feeShareRelation.getAsstBill().get("id"), mainCurrency);
        BigDecimal original_pageShareTaxCost = this.sharemodel.getSharedStandardTaxAmt(this.feeShareRelation.getAsstBill().get("id"));
        this.createAsstBillRecord(this.feeShareRelation, original_mainShareCost, original_pageShareCost, original_mainShareTaxCost, original_pageShareTaxCost, shareRecord, this.feeSharePrepare.getSharecurrency());
        Long costaccountId = this.feeShareRelation.getAsstParentObj().getLong("costaccount_id");
        Boolean supportTaxAmt = supportTaxAmtMap.get(costaccountId);
        boolean isTaxDeduction = this.feeShareRelation.getMainParentObj().getBoolean("istaxdeduction");
        BigDecimal mainShareCost = null;
        BigDecimal pageShareCost = null;
        if (supportTaxAmt.booleanValue()) {
            mainShareCost = original_mainShareTaxCost;
            pageShareCost = original_pageShareTaxCost;
        } else if (isTaxDeduction) {
            mainShareCost = original_mainShareCost;
            pageShareCost = original_pageShareCost;
        } else {
            mainShareCost = original_mainShareTaxCost;
            pageShareCost = original_pageShareTaxCost;
        }
        IStandardAmtExchange ichange = this.feeSharePrepare.getIchange();
        BigDecimal asstshareCost = ichange.exchangeToSourceAmt(pageShareCost, asstBillCurrency, this.feeSharePrepare.getShareDate());
        this.shareCostRecord(asstshareCost, mainShareCost, pageShareCost, shareRecord);
        long calEntryId = this.feeShareRelation.getAsstBill().getLong("calentryid");
        Map<Long, DynamicObject> unMainBillMap = this.getUnMianCaCostAccountRecord(calEntryId);
        for (DynamicObject asstCostRecord : unMainBillMap.values()) {
            this.feeShareRelation.asstShareRelation(asstCostRecord, calEntryId);
            costaccountId = asstCostRecord.getLong("costaccount_id");
            supportTaxAmt = supportTaxAmtMap.get(costaccountId);
            if (supportTaxAmt.booleanValue()) {
                mainShareCost = original_mainShareTaxCost;
                pageShareCost = original_pageShareTaxCost;
            } else if (isTaxDeduction) {
                mainShareCost = original_mainShareCost;
                pageShareCost = original_pageShareCost;
            } else {
                mainShareCost = original_mainShareTaxCost;
                pageShareCost = original_pageShareTaxCost;
            }
            asstBillCurrency = asstCostRecord.getDynamicObject("localcurrency");
            asstshareCost = ichange.exchangeToSourceAmt(pageShareCost, asstBillCurrency, this.feeSharePrepare.getShareDate());
            this.shareCostRecord(asstshareCost, mainShareCost, pageShareCost, shareRecord);
        }
    }

    private Map<Long, DynamicObject> getUnMianCaCostAccountRecord(long calEntryId) {
        HashMap<Long, DynamicObject> resultMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject dynamicObject : this.asstUnMainAccount) {
            DynamicObjectCollection entityCollection = (DynamicObjectCollection)dynamicObject.get("entry");
            for (DynamicObject entity : entityCollection) {
                if (calEntryId != entity.getLong("calentryid")) continue;
                resultMap.put(entity.getLong("id"), dynamicObject);
            }
        }
        return resultMap;
    }

    protected void createShareRecoerd() {
        List<DynamicObject> verifyRecordList = this.updateParams.getShareRecordList();
        if (!verifyRecordList.isEmpty()) {
            DynamicObject[] verifyRecordArray = new DynamicObject[verifyRecordList.size()];
            verifyRecordList.toArray(verifyRecordArray);
            SaveServiceHelper.save((DynamicObject[])verifyRecordArray);
            List<DynamicObject> verifyRecordDetailList = this.updateParams.getVerifyRecordDetailList();
            if (!verifyRecordDetailList.isEmpty()) {
                DynamicObject[] shareRecordDetailArray = new DynamicObject[verifyRecordDetailList.size()];
                verifyRecordDetailList.toArray(shareRecordDetailArray);
                SaveServiceHelper.save((DynamicObject[])shareRecordDetailArray);
            }
        }
    }

    protected void createCostAdjust() {
        if (this.updateParams.getCostAdjustList().isEmpty()) {
            return;
        }
        this.updateParams.setCostAdjustCollection();
        Collection<DynamicObject> costAdjustCollection = this.updateParams.getCostAdjustCollection();
        DynamicObject[] costAdjustBillArray = new DynamicObject[costAdjustCollection.size()];
        costAdjustCollection.toArray(costAdjustBillArray);
        SaveServiceHelper.save((DynamicObject[])costAdjustBillArray);
        HashSet<Long> set = new HashSet<Long>(costAdjustCollection.size());
        for (DynamicObject info : costAdjustCollection) {
            set.add(info.getLong("id"));
        }
        DynamicObject[] costAdjusts = BusinessDataServiceHelper.load((Object[])set.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cal_costadjust_subentity"));
        List<CostAdjustDetailParams> paramsList = this.buildCostAdjustDetail(costAdjusts);
        OperateOption option = OperateOption.create();
        String params = SerializationUtils.toJsonString(paramsList);
        option.setVariableValue("CostAdjustDetailParms", params);
        option.setVariableValue("ishasright", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_costadjust_subentity", (DynamicObject[])costAdjusts, (OperateOption)option);
        if (!result.isSuccess()) {
            List errors = result.getAllErrorOrValidateInfo();
            StringBuilder errorInfo = new StringBuilder();
            if (errors != null && !errors.isEmpty()) {
                for (IOperateInfo error : errors) {
                    OperateInfo operror = (OperateInfo)error;
                    String errMsg = ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u5ba1\u6838\u5931\u8d25\u3002", (String)"FeeShareCommonAlgo_0", (String)"fi-cal-formplugin", (Object[])new Object[0]);
                    errorInfo.append(errMsg);
                    errorInfo.append(operror.getMessage());
                }
            }
            errorInfo.append(result.getMessage());
            throw new KDBizException(errorInfo.toString());
        }
        PrevCostAdjustProcessHelper prevCostAdjustProcessHelper = new PrevCostAdjustProcessHelper();
        prevCostAdjustProcessHelper.dealOutAdjustSet(set);
    }

    protected void createStdCostDiffBill() {
        if (this.updateParams.getStdCostDiffBillList().isEmpty()) {
            return;
        }
        this.updateParams.setStdCostDiffBillCollection();
        Collection<DynamicObject> costAdjustCollection = this.updateParams.getStdCostDiffBillCollection();
        DynamicObject[] costAdjustBillArray = new DynamicObject[costAdjustCollection.size()];
        costAdjustCollection.toArray(costAdjustBillArray);
        SaveServiceHelper.save((DynamicObject[])costAdjustBillArray);
        HashSet<Long> set = new HashSet<Long>(costAdjustCollection.size());
        for (DynamicObject info : costAdjustCollection) {
            set.add(info.getLong("id"));
        }
        DynamicObject[] costAdjusts = BusinessDataServiceHelper.load((Object[])set.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cal_stdcostdiffbill"));
        List<CostAdjustDetailParams> paramsList = this.buildStdCostDiffBillDetail(costAdjusts);
        OperateOption option = OperateOption.create();
        String params = SerializationUtils.toJsonString(paramsList);
        option.setVariableValue("CostAdjustDetailParms", params);
        option.setVariableValue("ishasright", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_stdcostdiffbill", (DynamicObject[])costAdjusts, (OperateOption)option);
        if (!result.isSuccess()) {
            List errors = result.getAllErrorOrValidateInfo();
            StringBuilder errorInfo = new StringBuilder();
            if (errors != null && !errors.isEmpty()) {
                for (IOperateInfo error : errors) {
                    OperateInfo operror = (OperateInfo)error;
                    String errMsg = ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u5ba1\u6838\u5931\u8d25\u3002", (String)"FeeShareCommonAlgo_0", (String)"fi-cal-formplugin", (Object[])new Object[0]);
                    errorInfo.append(errMsg);
                    errorInfo.append(operror.getMessage());
                }
            }
            errorInfo.append(result.getMessage());
            throw new KDBizException(errorInfo.toString());
        }
    }

    private List<CostAdjustDetailParams> buildCostAdjustDetail(DynamicObject[] costAdjusts) {
        ArrayList<CostAdjustDetailParams> paramsList = new ArrayList<CostAdjustDetailParams>();
        Map<String, List<DynamicObject>> calByElementMapByCostAdjusts = this.getCalByElementMapByCostAdjusts(costAdjusts);
        List<DynamicObject> openCostAdjustList = calByElementMapByCostAdjusts.get("openCostAdjustList");
        List<DynamicObject> closeCostAdjustList = calByElementMapByCostAdjusts.get("closeCostAdjustList");
        Long[] defalutMaterialId = CostElementHelper.getDefaultMaterialElements();
        Set<Long> exitemSet = this.feeSharePrepare.getExitemAndEntryIdList().get(0);
        Set<Long> costTypeSet = this.feeSharePrepare.getExitemAndEntryIdList().get(2);
        Map projectIdElementMap = CostElementHelper.buildExitemElement(exitemSet, costTypeSet);
        for (DynamicObject dynamic : openCostAdjustList) {
            DynamicObjectCollection costadjustEntry = dynamic.getDynamicObjectCollection("entryentity");
            long costTypeid = dynamic.getLong("costaccount.costtype.id");
            for (DynamicObject entry : costadjustEntry) {
                long entryId = entry.getLong("id");
                Long feeProjectidId = entry.getLong("feeprojectid_id");
                Long[] elementIds = null;
                elementIds = feeProjectidId == null || feeProjectidId.equals(0L) ? defalutMaterialId : (Long[])projectIdElementMap.get(costTypeid + "|" + feeProjectidId);
                CostAdjustDetailParams param = new CostAdjustDetailParams();
                param.setAdjustAmt(entry.getBigDecimal("adjustamt"));
                param.setEntryid((Object)entryId);
                param.setCostElementId((Object)elementIds[1]);
                param.setCostSubElementId((Object)elementIds[0]);
                paramsList.add(param);
            }
        }
        Long[] elementIds = CostElementHelper.getDefaultMaterialElements();
        for (DynamicObject dynamic : closeCostAdjustList) {
            DynamicObjectCollection costadjustEntry = dynamic.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : costadjustEntry) {
                long entryId = entry.getLong("id");
                CostAdjustDetailParams param = new CostAdjustDetailParams();
                param.setAdjustAmt(entry.getBigDecimal("adjustamt"));
                param.setEntryid((Object)entryId);
                param.setCostElementId((Object)elementIds[1]);
                param.setCostSubElementId((Object)elementIds[0]);
                paramsList.add(param);
            }
        }
        return paramsList;
    }

    private List<CostAdjustDetailParams> buildStdCostDiffBillDetail(DynamicObject[] costAdjusts) {
        ArrayList<CostAdjustDetailParams> paramsList = new ArrayList<CostAdjustDetailParams>();
        Map<String, List<DynamicObject>> calByElementMapByCostAdjusts = this.getCalByElementMapByCostAdjusts(costAdjusts);
        List<DynamicObject> openCostAdjustList = calByElementMapByCostAdjusts.get("openCostAdjustList");
        List<DynamicObject> closeCostAdjustList = calByElementMapByCostAdjusts.get("closeCostAdjustList");
        Long[] defalutMaterialId = CostElementHelper.getDefaultMaterialElements();
        Set<Long> exitemSet = this.feeSharePrepare.getExitemAndEntryIdList().get(0);
        Set<Long> costTypeSet = this.feeSharePrepare.getExitemAndEntryIdList().get(2);
        Map projectIdElementMap = CostElementHelper.buildExitemElement(exitemSet, costTypeSet);
        for (DynamicObject dynamic : openCostAdjustList) {
            DynamicObjectCollection costadjustEntry = dynamic.getDynamicObjectCollection("entryentity");
            long costTypeid = dynamic.getLong("costaccount.costtype.id");
            for (DynamicObject entry : costadjustEntry) {
                long entryId = entry.getLong("id");
                Long feeProjectidId = entry.getLong("feeprojectid_id");
                Long[] elementIds = null;
                elementIds = feeProjectidId == null || feeProjectidId.equals(0L) ? defalutMaterialId : (Long[])projectIdElementMap.get(costTypeid + "|" + feeProjectidId);
                CostAdjustDetailParams param = new CostAdjustDetailParams();
                param.setAdjustAmt(entry.getBigDecimal("adjustamt"));
                param.setDdiff_k(entry.getBigDecimal("diff_k"));
                param.setEntryid((Object)entryId);
                param.setCostElementId((Object)elementIds[1]);
                param.setCostSubElementId((Object)elementIds[0]);
                paramsList.add(param);
            }
        }
        Long[] elementIds = CostElementHelper.getDefaultMaterialElements();
        for (DynamicObject dynamic : closeCostAdjustList) {
            DynamicObjectCollection costadjustEntry = dynamic.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : costadjustEntry) {
                long entryId = entry.getLong("id");
                CostAdjustDetailParams param = new CostAdjustDetailParams();
                param.setAdjustAmt(entry.getBigDecimal("adjustamt"));
                param.setDdiff_k(entry.getBigDecimal("diff_k"));
                param.setEntryid((Object)entryId);
                param.setCostElementId((Object)elementIds[1]);
                param.setCostSubElementId((Object)elementIds[0]);
                paramsList.add(param);
            }
        }
        return paramsList;
    }

    private Map<String, List<DynamicObject>> getCalByElementMapByCostAdjusts(DynamicObject[] costAdjusts) {
        Map<Long, Boolean> calByCostElementMap = this.feeSharePrepare.getCalByCostElementMap();
        HashMap<String, List<DynamicObject>> result = new HashMap<String, List<DynamicObject>>(16);
        ArrayList<DynamicObject> openList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> closeList = new ArrayList<DynamicObject>();
        for (DynamicObject costAdjust : costAdjusts) {
            Long costAccountId = costAdjust.getLong("costaccount.id");
            if (calByCostElementMap.get(costAccountId).booleanValue()) {
                openList.add(costAdjust);
                continue;
            }
            closeList.add(costAdjust);
        }
        result.put("openCostAdjustList", openList);
        result.put("closeCostAdjustList", closeList);
        return result;
    }

    protected void updaetFinapBill(FeeSharePrepare feeSharePrepare) {
        List<Object[]> finapBillParams = this.updateParams.getFinapBillParams();
        if (!finapBillParams.isEmpty()) {
            for (Object[] objects : finapBillParams) {
                feeSharePrepare.getSuccMainBillEntryIds().add(objects[0]);
            }
        }
    }
}

