/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.calculate.in;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.form.container.Container;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.formplugin.calculate.in.FeeShareParent;

public class FeeShareInitPlugin
extends FeeShareParent
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, "calorg");
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String sourceID = event.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        if ("calorg".equals(sourceID)) {
            long userId = Long.parseLong(RequestContext.get().getUserId());
            List calorgList = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_fee_share", (String)"47150e89000000ac");
            QFilter calorgFilter = null;
            if (calorgList != null) {
                calorgFilter = new QFilter("id", "in", (Object)calorgList);
            }
            showParameter.getListFilterParameter().setFilter(calorgFilter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Long orgId = RequestContext.get().getOrgId();
        long userId = Long.parseLong(RequestContext.get().getUserId());
        orgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)orgId, (String)"cal_fee_share");
        this.getModel().setValue("calorg", (Object)orgId);
        this.getModel().setValue("mainorg", (Object)orgId);
        Container queryPanel = (Container)this.getControl("querypanel");
        queryPanel.setCollapse(false);
        String message = "";
        message = this.initShareType();
        if (StringUtils.isNotBlank((CharSequence)message)) {
            this.getView().showTipNotification(message);
            return;
        }
        message = this.initMatch();
        if (StringUtils.isNotBlank((CharSequence)message)) {
            this.getView().showTipNotification(message);
            return;
        }
        this.buildMainFilterGrid();
        this.buildAsstFilterGrid();
        this.bindShareStandard();
        this.bindShareCurrencyAndTable();
    }

    private void bindShareStandard() {
        MainEntityType entitytype = MetadataServiceHelper.getDataEntityType((String)"cal_costdetail");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        List<String> standards = Arrays.asList(CommonSettingHelper.getEstimatestandards());
        for (IDataEntityProperty pro : entitytype.getProperties()) {
            if (!standards.contains(pro.getName())) continue;
            ComboItem item = new ComboItem(pro.getDisplayName(), pro.getName());
            items.add(item);
        }
        if (items.isEmpty()) {
            return;
        }
        ComboEdit com = (ComboEdit)this.getControl("sharestandard");
        com.setComboItems(items);
        this.getModel().beginInit();
        this.getModel().setValue("sharestandard", (Object)((ComboItem)items.get(0)).getValue());
        this.getModel().endInit();
        this.getView().updateView("sharestandard");
    }

    protected void buildMainFilterGrid() {
        this.initFilterGrid("ap_finapbill", "mainfiltergrid");
    }

    protected void buildAsstFilterGrid() {
        this.initFilterGrid("cal_costrecord", "asstfiltergrid");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setDefaultFilterValue();
    }

    private void setDefaultFilterValue() {
        Long calOrgId = this.getCalOrg();
        FilterGrid mainFilterGrid = (FilterGrid)this.getControl("mainfiltergrid");
        FilterCondition mainFilter = this.getDefaultFilter("ap_finapbill", calOrgId);
        mainFilterGrid.SetValue(mainFilter);
        FilterGrid asstFilterGrid = (FilterGrid)this.getControl("asstfiltergrid");
        FilterCondition asstFilter = this.getDefaultFilter("cal_costrecord", calOrgId);
        asstFilterGrid.SetValue(asstFilter);
    }

    private FilterCondition getDefaultFilter(String entityNumber, Long orgId) {
        FilterCondition fc = new FilterCondition();
        if ("ap_finapbill".equals(entityNumber)) {
            fc = this.getFinapBillFilter(orgId);
        } else if ("cal_costrecord".equals(entityNumber)) {
            fc = this.getCostRecordFilter(orgId);
        }
        return fc;
    }

    private FilterCondition getCostRecordFilter(Long orgId) {
        FilterCondition fc = new FilterCondition();
        ArrayList<SimpleFilterRow> rows = new ArrayList<SimpleFilterRow>();
        SimpleFilterRow bookDateRow = new SimpleFilterRow();
        bookDateRow.setCompareType(CompareTypeEnum.THISMONTH.getId());
        bookDateRow.setFieldName("bookdate");
        bookDateRow.setLogic("0");
        ArrayList<FilterValue> dateValues = new ArrayList<FilterValue>();
        FilterValue dateValue = new FilterValue();
        dateValue.setValue((Object)"");
        dateValues.add(dateValue);
        bookDateRow.setValue(dateValues);
        rows.add(bookDateRow);
        fc.setFilterRow(rows);
        SimpleFilterRow billTypeRow = new SimpleFilterRow();
        billTypeRow.setCompareType(CompareTypeEnum.IN.getId());
        billTypeRow.setFieldName("billtype.name");
        billTypeRow.setLogic("0");
        ArrayList<FilterValue> billTypeValues = new ArrayList<FilterValue>();
        FilterValue billTypeOne = new FilterValue();
        DynamicObject billTypeOneObj = BusinessDataServiceHelper.loadSingleFromCache((Object)453393238762473472L, (String)"bos_billtype");
        billTypeOne.setValue((Object)billTypeOneObj.getString("name"));
        billTypeValues.add(billTypeOne);
        FilterValue billTypeTwo = new FilterValue();
        DynamicObject billTypeTwoObj = BusinessDataServiceHelper.loadSingleFromCache((Object)366348248593474560L, (String)"bos_billtype");
        billTypeTwo.setValue((Object)billTypeTwoObj.getString("name"));
        billTypeValues.add(billTypeTwo);
        FilterValue billTypeThree = new FilterValue();
        DynamicObject billTypeThreeObj = BusinessDataServiceHelper.loadSingleFromCache((Object)1433925832400781312L, (String)"bos_billtype");
        billTypeThree.setValue((Object)billTypeThreeObj.getString("name"));
        billTypeValues.add(billTypeThree);
        billTypeRow.setValue(billTypeValues);
        rows.add(billTypeRow);
        fc.setFilterRow(rows);
        return fc;
    }

    public FilterCondition getFinapBillFilter(Long orgId) {
        DynamicObject currency;
        FilterCondition fc = new FilterCondition();
        ArrayList<SimpleFilterRow> rows = new ArrayList<SimpleFilterRow>();
        SimpleFilterRow bookDateRow = new SimpleFilterRow();
        bookDateRow.setCompareType(CompareTypeEnum.THISMONTH.getId());
        bookDateRow.setFieldName("bookdate");
        bookDateRow.setLogic("0");
        ArrayList<FilterValue> dateValues = new ArrayList<FilterValue>();
        FilterValue dateValue = new FilterValue();
        dateValue.setValue((Object)"");
        dateValues.add(dateValue);
        bookDateRow.setValue(dateValues);
        rows.add(bookDateRow);
        fc.setFilterRow(rows);
        SimpleFilterRow asstActTypeRow = new SimpleFilterRow();
        asstActTypeRow.setCompareType(CompareTypeEnum.CHECKBOXEQUAL.getId());
        asstActTypeRow.setFieldName("asstacttype");
        asstActTypeRow.setLogic("0");
        ArrayList<FilterValue> asstActTypeValues = new ArrayList<FilterValue>();
        FilterValue asstActTypeValue = new FilterValue();
        asstActTypeValue.setValue((Object)"bd_supplier");
        asstActTypeValues.add(asstActTypeValue);
        asstActTypeRow.setValue(asstActTypeValues);
        rows.add(asstActTypeRow);
        SimpleFilterRow asstActRow = new SimpleFilterRow();
        asstActRow.setCompareType(CompareTypeEnum.ITEMCLASSEQUALS.getId());
        asstActRow.setFieldName("asstact.name");
        asstActRow.setLogic("0");
        rows.add(asstActRow);
        if (orgId != null && (currency = this.getMainFinalBillCurrency(orgId)) != null) {
            SimpleFilterRow currencyRow = new SimpleFilterRow();
            currencyRow.setCompareType(CompareTypeEnum.EQUAL.getId());
            currencyRow.setFieldName("currency.name");
            currencyRow.setLogic("0");
            ArrayList<FilterValue> currencyValues = new ArrayList<FilterValue>();
            FilterValue currencyValue = new FilterValue();
            currencyValue.setValue((Object)currency.getString("name"));
            currencyValues.add(currencyValue);
            currencyRow.setValue(currencyValues);
            rows.add(currencyRow);
        }
        return fc;
    }

    private DynamicObject getMainFinalBillCurrency(long orgId) {
        DynamicObject init = BusinessDataServiceHelper.loadSingleFromCache((String)"cal_bd_costaccount", (QFilter[])new QFilter[]{new QFilter("calorg", "=", (Object)orgId).and("ismainaccount", "=", (Object)"1")});
        if (init == null || init.get("calpolicy") == null) {
            return null;
        }
        return init.getDynamicObject("calpolicy").getDynamicObject("currency");
    }

    private String initMatch() {
        DynamicObject shareTypeObj = (DynamicObject)this.getModel().getValue("sharetype");
        if (shareTypeObj == null) {
            return "";
        }
        long id = shareTypeObj.getLong("id");
        DynamicObjectCollection matchCollect = QueryServiceHelper.query((String)"cal_matchrule", (String)"id,number,name,writeofftype,nonematch,issys", (QFilter[])new QFilter("writeofftype", "=", (Object)id).and("enable", "=", (Object)"1").toArray());
        if (matchCollect == null || matchCollect.isEmpty()) {
            return ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6838\u9500\u7c7b\u522b\u5bf9\u5e94\u5339\u914d\u89c4\u5219\u3002", (String)"FeeShareInitPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        }
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(10);
        int nonematchIndex = 0;
        for (int i = 0; i < matchCollect.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)matchCollect.get(i);
            ComboItem citem = new ComboItem();
            LocaleString caption = new LocaleString(dynamicObject.getString("name"));
            citem.setCaption(caption);
            citem.setValue(dynamicObject.getString("id"));
            list.add(citem);
            if (!dynamicObject.getBoolean("issys")) continue;
            nonematchIndex = i;
        }
        if (list.isEmpty()) {
            return "";
        }
        ComboEdit com = (ComboEdit)this.getControl("matchingcondition");
        com.setComboItems(list);
        this.getModel().beginInit();
        this.getModel().setValue("matchingcondition", (Object)((ComboItem)list.get(nonematchIndex)).getValue());
        this.getModel().endInit();
        this.getView().updateView("matchingcondition");
        return "";
    }

    private String initShareType() {
        String returnStr = "";
        QFilter witrOffType = new QFilter("masterbill.number", "=", (Object)"ap_finapbill").and("asstbill.number", "=", (Object)"cal_costrecord").and("enable", "=", (Object)"1");
        DynamicObject[] writeOffObjs = BusinessDataServiceHelper.load((String)"cal_writeofftype", (String)"number,issys,masterbill.number,asstbill.number", (QFilter[])witrOffType.toArray());
        ArrayList<QFilter> calorgFilterList = new ArrayList<QFilter>();
        if (writeOffObjs.length == 0) {
            returnStr = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6838\u9500\u5e73\u53f0\u8d39\u7528\u5206\u644a\u914d\u7f6e\u3002", (String)"FeeShareInitPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            calorgFilterList.add(new QFilter("1", "=", (Object)"2"));
        } else {
            DynamicObject shareTypeObj = null;
            for (DynamicObject obj : writeOffObjs) {
                if (!obj.getBoolean("issys")) continue;
                shareTypeObj = obj;
            }
            if (shareTypeObj == null) {
                shareTypeObj = writeOffObjs[0];
            }
            this.getModel().setValue("sharetype", (Object)shareTypeObj.getLong("id"));
            calorgFilterList.add(witrOffType);
        }
        BasedataEdit orgBd = (BasedataEdit)this.getControl("sharetype");
        orgBd.setQFilters(calorgFilterList);
        return returnStr;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String propertyName = property.getName();
        if ("sharetype".equals(propertyName)) {
            this.chageShareType();
        } else if ("calorg".equals(propertyName)) {
            DynamicObject calObj = (DynamicObject)this.getModel().getValue("calorg");
            if (calObj == null) {
                return;
            }
            this.getModel().beginInit();
            this.getModel().setValue("mainorg", (Object)calObj);
            this.bindShareCurrencyAndTable();
            this.getModel().endInit();
            this.getView().updateView("mainorg");
        } else if ("sharecurrency".equals(propertyName)) {
            this.bindMainEntryCost();
        }
    }

    private void chageShareType() {
        String message = this.initMatch();
        if (StringUtils.isNotBlank((CharSequence)message)) {
            this.getView().showTipNotification(message);
            return;
        }
        this.buildMainFilterGrid();
        this.setDefaultFilterValue();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String sourceFldKey = closedCallBackEvent.getActionId();
        if ("sharesetting".equals(sourceFldKey)) {
            this.bindShareStandard();
            this.bindMainEntryCost();
        }
    }

    protected void initFilterGrid(String entityNumber, String filterGridName) {
        if (entityNumber == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u9500\u7c7b\u522b\u5355\u636e\u7c7b\u578b\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"FeeShareInitPlugin_13", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        EntityTypeUtil helper = new EntityTypeUtil();
        List<Map<String, Object>> cols = helper.getFilterColumns((IDataEntityType)mainEntityType);
        if ("ap_finapbill".equals(mainEntityType.getName())) {
            cols = this.getMainCols(cols);
        }
        if ("cal_costrecord".equals(mainEntityType.getName())) {
            cols = this.filterCols(cols);
        }
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(filterGridName);
        filterGrid.setEntityNumber(mainEntityType.getName());
        filterGrid.setFilterColumns(cols);
        this.getView().updateView(filterGridName);
    }

    private List<Map<String, Object>> filterCols(List<Map<String, Object>> cols) {
        ArrayList<Map<String, Object>> filtedList = new ArrayList<Map<String, Object>>(16);
        for (Map<String, Object> colInfos : cols) {
            String entryEntity = colInfos.get("entryEntity").toString();
            if (!"cal_costrecord".equals(entryEntity) && !"entry".equals(entryEntity)) continue;
            filtedList.add(colInfos);
        }
        return filtedList;
    }

    private List<Map<String, Object>> getMainCols(List<Map<String, Object>> cols) {
        ArrayList<String> exceptList = new ArrayList<String>();
        exceptList.add("billtypeid.name");
        exceptList.add("billtypeid.number");
        exceptList.add("billtype");
        for (int i = cols.size() - 1; i >= 0; --i) {
            Map<String, Object> middleMap = cols.get(i);
            if (!exceptList.contains(middleMap.get("fieldName").toString())) continue;
            cols.remove(i);
        }
        return cols;
    }
}

