/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.calculate.in;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.matchrule.MatchResult;
import kd.fi.cal.business.matchrule.MatchRuleAlgorithm;
import kd.fi.cal.business.sharemodel.StandardAmtExchange;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.FeeShareHelper;

public class FeeShareParent
extends AbstractFormPlugin {
    protected static final String SHARECURRENCY = "sharecurrency";
    protected static final String EXRATETABLE = "exratetable";
    protected static final String CONVERTMODE = "convertmode";
    protected static final String MAINFILTERGRID = "mainfiltergrid";
    protected static final String ASSTFILTERGRID = "asstfiltergrid";
    protected static final String SHARESTANDARD = "sharestandard";
    protected static final String SHARETYPE = "sharetype";
    protected static final String MATCHINGCONDITION = "matchingcondition";
    protected static final String CALORG = "calorg";
    protected static final String MAINCALORG = "mainorg";
    protected static final String SHARESETTING = "sharesetting";
    protected static final String THISVERIFYLOG = "thisverifylog";
    protected static final String HISVERIFYLOG = "historyverifylog";
    protected static final String VERIFYPREVIEW = "verifypreview";
    protected static final String MAIN_GRIDTABLE = "mentry";
    protected static final String ME_BILLID = "me_billid";
    protected static final String ME_BILLENTRYID = "me_billentryid";
    protected static final String ASST_GRIDTABLE = "sentry";
    protected static final String SE_BILLID = "se_billid";
    protected static final String SE_BILLENTRYID = "se_billentryid";
    protected static final String SE_CALENTRYID = "se_calentryid";
    protected static final String SHAREDATE = "sharedate";
    protected static final String QUERYPANEL = "querypanel";
    protected static final String BTNQUERY = "query";
    protected static final String PURSHARETYPENUM = "HXLB_YS_05";
    protected static final String SHARENUM = "shareNum";
    protected static final String MAINQFILTER = "mainQfilter";
    protected static final String ASSTQFILTER = "asstQfilter";

    protected String getMainBillFields() {
        StringBuilder sb = new StringBuilder();
        sb.append("id,detailentry.id,detailentry.expenseitem,billno,bizdate,bookdate,");
        sb.append("asstacttype,asstact,currency,detailentry.e_amount,detailentry.e_pricetaxtotal,billtypeid,detailentry.corebilltype,detailentry.corebillno,");
        sb.append("detailentry.corebillid,detailentry.corebillentryid,sourcebilltype,sourcebillno,sourcebillid,detailentry.e_sourcebillentryid,");
        sb.append("detailentry.material,detailentry.seq,");
        sb.append("basecurrency,exratedate,detailentry.intercostamt,org");
        return sb.toString();
    }

    protected String getBillFields(String bill) {
        String finalStr = "";
        if ("ap_finapbill".equals(bill)) {
            finalStr = this.getMainBillFields();
        } else if ("cal_costrecord".equals(bill)) {
            finalStr = FeeShareHelper.getCostRecordFields();
        }
        return finalStr;
    }

    protected boolean isUpdateCostAjust(Date orgMaxPeriodDate, DynamicObject asstParentBill, DynamicObject asstBill) {
        Date bizDate = asstParentBill.getDate("bizdate");
        boolean isCher = asstParentBill.getBoolean("isfeevoucher") || asstParentBill.getBoolean("isfivoucher") || asstParentBill.getBoolean("iscostcarryover") || asstParentBill.getBoolean("istempvoucher") || asstParentBill.getBoolean("isdischargevoucher");
        boolean realTime = AccountTypeEnum.MOVE_ADD_AVERAGE.getValue().equals(asstBill.getString("accounttype")) || AccountTypeEnum.FIN_FOUT.getValue().equals(asstBill.getString("accounttype"));
        boolean bizDateFlag = bizDate.compareTo(orgMaxPeriodDate) < 0;
        return bizDateFlag || realTime || isCher;
    }

    protected String getShareType() {
        DynamicObject shareType = (DynamicObject)this.getModel().getValue(SHARETYPE);
        if (shareType == null) {
            return null;
        }
        return shareType.getString("number");
    }

    protected Long getCalOrg() {
        DynamicObject calorg = (DynamicObject)this.getModel().getValue(CALORG);
        if (calorg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a", (String)"FeeShareParent_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return 0L;
        }
        return (Long)calorg.getPkValue();
    }

    protected int[] getSelectIndexs(String billType) {
        EntryGrid mainEntryGrid = (EntryGrid)this.getControl(billType);
        int[] indexs = mainEntryGrid.getSelectRows();
        return indexs;
    }

    protected DBRoute getCalDBRouteKey() {
        return new DBRoute("cal");
    }

    protected void isShareSettingOk() {
        String dividestandard = (String)this.getModel().getValue(SHARESTANDARD);
        if ("".equals(dividestandard)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5206\u644a\u914d\u7f6e\u6ca1\u6709\u8bbe\u7f6e\u3002", (String)"FeeShareParent_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        DynamicObject shareCurrency = (DynamicObject)this.getModel().getValue(SHARECURRENCY);
        if (StringUtils.isBlank((Object)shareCurrency)) {
            DynamicObject calOrg = (DynamicObject)this.getModel().getValue(CALORG);
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c{0}\u201d\u4e0d\u5b58\u5728\u672c\u4f4d\u5e01\u65e0\u6cd5\u5206\u644a\uff0c\u8bf7\u7ef4\u62a4\u6838\u7b97\u7ec4\u7ec7\u672c\u4f4d\u5e01\u57fa\u7840\u8d44\u6599\u3002", (String)"FeeShareParent_3", (String)"fi-cal-formplugin", (Object[])new Object[0]), calOrg.getString("name")));
        }
    }

    protected void bindShareCurrencyAndTable() {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue(CALORG);
        if (calOrg == null) {
            return;
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"bd_accountingsys_base", (String)"basecurrrency,exratetable", (QFilter[])new QFilter("baseacctorg.id", "=", calOrg.getPkValue()).toArray());
        this.getModel().beginInit();
        if (obj == null) {
            this.getModel().setValue(SHARECURRENCY, null);
            this.getModel().setValue(EXRATETABLE, null);
        } else {
            this.getModel().setValue(SHARECURRENCY, (Object)obj.getDynamicObject("basecurrrency").getLong("id"));
            this.getModel().setValue(EXRATETABLE, (Object)obj.getDynamicObject(EXRATETABLE).getLong("id"));
        }
        this.getModel().endInit();
        this.getView().updateView(SHARECURRENCY);
        this.getView().updateView(EXRATETABLE);
    }

    protected void bindMainEntryCost() {
        int[] mainGridTableIndex;
        DynamicObjectCollection mainGridTable = this.getModel().getEntryEntity(MAIN_GRIDTABLE);
        StandardAmtExchange ichange = this.getIExchange();
        for (int index : mainGridTableIndex = this.getSelectIndexs(MAIN_GRIDTABLE)) {
            DynamicObject meMainCurrency = null;
            BigDecimal apAmount = null;
            BigDecimal apTaxAmount = null;
            Date bizdate = null;
            BigDecimal apInterCostAmt = (BigDecimal)this.getModel().getValue("me_intercostamt", index);
            if (apInterCostAmt != null && apInterCostAmt.compareTo(BigDecimal.ZERO) != 0) {
                apAmount = apTaxAmount = apInterCostAmt;
                meMainCurrency = (DynamicObject)((DynamicObject)mainGridTable.get(index)).get("me_localcurrency");
                bizdate = (Date)((DynamicObject)mainGridTable.get(index)).get("me_exratedate");
            } else {
                meMainCurrency = (DynamicObject)((DynamicObject)mainGridTable.get(index)).get("me_currency");
                apAmount = (BigDecimal)this.getModel().getValue("me_amount", index);
                apTaxAmount = (BigDecimal)this.getModel().getValue("me_taxamount", index);
                bizdate = (Date)this.getModel().getValue(SHAREDATE);
            }
            this.getModel().beginInit();
            this.getModel().setValue("me_verifyamt", (Object)ichange.exchangeToStandardAmt(apAmount, meMainCurrency, bizdate), index);
            this.getModel().setValue("me_verifytaxamt", (Object)ichange.exchangeToStandardAmt(apTaxAmount, meMainCurrency, bizdate), index);
            this.getModel().endInit();
            this.getView().updateView("me_verifyamt", index);
            this.getView().updateView("me_verifytaxamt", index);
        }
    }

    protected void checkBillSelect() {
        int[] mainGridTableIndex = this.getSelectIndexs(MAIN_GRIDTABLE);
        int[] asstGridTableIndex = this.getSelectIndexs(ASST_GRIDTABLE);
        if (mainGridTableIndex.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u4e3b\u65b9\u5355\u636e\u3002", (String)"FeeShareParent_4", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        if (asstGridTableIndex.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u8f85\u65b9\u5355\u636e\u3002", (String)"FeeShareParent_5", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }

    protected Map<DynamicObject, List<DynamicObject>> getMatchResultMap() {
        Object matchruleid = this.getModel().getValue(MATCHINGCONDITION);
        Collection<DynamicObject> mainBillList = this.getBillFromPage(MAIN_GRIDTABLE, ME_BILLID, ME_BILLENTRYID, "ap_finapbill", "detailentry");
        Collection<DynamicObject> asstBillList = this.getBillFromPage(ASST_GRIDTABLE, SE_BILLID, SE_BILLENTRYID, "cal_costrecord", "entry");
        if (mainBillList.isEmpty() || asstBillList.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u88ab\u5206\u644a\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"FeeShareParent_8", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        MatchRuleAlgorithm matchRule = new MatchRuleAlgorithm(matchruleid, "detailentry", "entry");
        MatchResult resultRule = matchRule.matchRules(mainBillList, asstBillList);
        return resultRule.getResultmap();
    }

    private Collection<DynamicObject> getBillFromPage(String gridtable, String id, String entryId, String entryName, String filterEntry) {
        DynamicObject[] mainObj;
        int[] indexs = this.getSelectIndexs(gridtable);
        DynamicObjectCollection entityColl = this.getModel().getEntryEntity(gridtable);
        List<Long> ids = this.getIdByPage(indexs, entityColl, id);
        List<Long> entryIds = this.getIdByPage(indexs, entityColl, entryId);
        if ("ap_finapbill".equals(entryName)) {
            this.checkMainBillEntry(entryIds);
        } else if ("cal_costrecord".equals(entryName)) {
            this.checkAsstBillEntry(entryIds);
        }
        Object[] objArray = new Object[ids.size()];
        for (DynamicObject dynamicObject : mainObj = BusinessDataServiceHelper.load((Object[])ids.toArray(objArray), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entryName))) {
            DynamicObjectCollection entryObj = dynamicObject.getDynamicObjectCollection(filterEntry);
            for (int i = entryObj.size() - 1; i >= 0; --i) {
                long eId = ((DynamicObject)entryObj.get(i)).getLong("id");
                if (entryIds.contains(eId)) continue;
                entryObj.remove(i);
            }
        }
        return Arrays.asList(mainObj);
    }

    private void checkAsstBillEntry(List<Long> entryIds) {
        DynamicObjectCollection costRecords = QueryServiceHelper.query((String)"cal_costrecord", (String)"entry.id as entryid", (QFilter[])new QFilter("entry.id", "in", entryIds).toArray());
        ArrayList<Long> finalEntryIds = new ArrayList<Long>();
        for (DynamicObject dynamicObject : costRecords) {
            finalEntryIds.add(dynamicObject.getLong("entryid"));
        }
        if (entryIds.size() != finalEntryIds.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u88ab\u5206\u644a\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"FeeShareParent_8", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkMainBillEntry(List<Long> entryIds) {
        DynamicObjectCollection dbMainBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"detailentry.id", (QFilter[])new QFilter("detailentry.id", "in", entryIds).and("detailentry.isallocate", "=", (Object)"1").toArray());
        if (dbMainBills.size() > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u88ab\u5206\u644a\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"FeeShareParent_8", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }

    protected List<Long> getIdByPage(int[] indexs, DynamicObjectCollection entityColl, String entryId) {
        ArrayList<Long> ids = new ArrayList<Long>(32);
        for (int index : indexs) {
            long id = ((DynamicObject)entityColl.get(index)).getLong(entryId);
            ids.add(id);
        }
        return ids;
    }

    protected StandardAmtExchange getIExchange() {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue(CALORG);
        DynamicObject currency = (DynamicObject)this.getModel().getValue(SHARECURRENCY);
        DynamicObject exrateTable = (DynamicObject)this.getModel().getValue(EXRATETABLE);
        if (currency == null || exrateTable == null) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c{0}\u201d\u4e0d\u5b58\u5728\u672c\u4f4d\u5e01\u65e0\u6cd5\u5206\u644a\uff0c\u8bf7\u7ef4\u62a4\u6838\u7b97\u7ec4\u7ec7\u672c\u4f4d\u5e01\u57fa\u7840\u8d44\u6599\u3002", (String)"FeeShareParent_3", (String)"fi-cal-formplugin", (Object[])new Object[0]), calOrg.getString("name")));
        }
        return new StandardAmtExchange(currency, Long.valueOf(exrateTable.getLong("id")), "1");
    }

    protected void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        for (String str : f7Name) {
            BasedataEdit f7Control = (BasedataEdit)this.getView().getControl(str);
            if (null == f7Control) continue;
            f7Control.addBeforeF7SelectListener(form);
        }
    }

    private boolean checkEsDate(Date date) {
        long calorgId = this.getCalOrg();
        Date maxDate = this.getMaxPeriodDateByOrgid(calorgId);
        return date.compareTo(maxDate) < 0;
    }

    private Date getMaxPeriodDateByOrgid(long calorgId) {
        Date maxDate = AccountingSysHelper.getCurrentPeriodMaxDateByOrg((long)calorgId);
        if (maxDate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e0b\u6ca1\u6709\u542f\u7528\u4e2d\u7684\u6210\u672c\u8d26\u7c3f\uff0c\u6216\u6210\u672c\u8d26\u7c3f\u672a\u521d\u59cb\u5316\u3002", (String)"FeeShareParent_6", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        return maxDate;
    }

    protected void checkShareDate() {
        Date shareDate = (Date)this.getModel().getValue(SHAREDATE);
        if (this.checkEsDate(shareDate)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5206\u644a\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u7ec4\u7ec7\u4e0b\u6240\u6709\u6210\u672c\u8d26\u7c3f\u4e2d\u6700\u5927\u5f00\u59cb\u671f\u95f4\u5f00\u59cb\u65e5\u671f\u3002", (String)"FeeShareParent_7", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }
}

