/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.calculate.in;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.sharemodel.IStandardAmtExchange;
import kd.fi.cal.business.sharemodel.StandardAmtExchange;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.FeeShareHelper;
import kd.fi.cal.formplugin.calculate.in.FeeShareRelation;

public class FeeSharePrepare {
    private static final Log logger = LogFactory.getLog(FeeSharePrepare.class);
    private String shareStandard;
    private IStandardAmtExchange ichange;
    private Date shareDate;
    private long shareNum;
    private Long defaultId = 0L;
    private Map<String, Long[]> exitemElementMap = new HashMap<String, Long[]>();
    private Map<String, Long[]> cosTypeMaterialMap = new HashMap<String, Long[]>();
    private List<Set<Long>> exitemAndEntryIdList = new ArrayList<Set<Long>>();
    private Map<Long, Boolean> calByCostElementMap = new HashMap<Long, Boolean>();
    private Map<Long, Boolean> supportTaxAmtMap = new HashMap<Long, Boolean>();
    private DynamicObject calorg;
    private DynamicObject sharecurrency;
    private Set<Long> entryIdSet = new HashSet<Long>();
    private Date orgIdMaxPeriodDate = null;
    private Set<String> exFieldSet = new HashSet<String>();
    private Map<String, BigDecimal> firstCostEstCostMap = new HashMap<String, BigDecimal>();
    private Map<String, List<DynamicObject>> multiCostEstCostAdjust = new HashMap<String, List<DynamicObject>>();
    private Map<String, List<DynamicObject>> multiCostEstStdCostDiffBill = new HashMap<String, List<DynamicObject>>();
    private Map<Long, QFilter> bizDateFilterMap = null;
    private Map<Long, Date> costAccountBeginDateMap = new HashMap<Long, Date>();
    private Set<Object> succMainBillEntryIds = new HashSet<Object>(16);
    private Set<Long> succAssBillIds = new HashSet<Long>(16);

    private final void init(Map<String, Object> paramMap) {
        long shareNum;
        DynamicObject sharecurrency;
        DynamicObject calOrg;
        String sharestandard;
        this.shareStandard = sharestandard = (String)paramMap.get("sharestandard");
        String sharedateStr = (String)paramMap.get("sharedate");
        Date sharedate = null;
        try {
            sharedate = new SimpleDateFormat("yyyy-MM-dd").parse(sharedateStr);
        }
        catch (ParseException e1) {
            logger.error((Throwable)e1);
        }
        this.shareDate = sharedate;
        long calOrgId = Long.parseLong((String)paramMap.get("CALORG"));
        this.buildCostElementByCalOrgAndSupportTaxAmt(calOrgId);
        this.calorg = calOrg = BusinessDataServiceHelper.loadSingle((Object)calOrgId, (String)"bos_org");
        long sharecurrencyId = Long.parseLong((String)paramMap.get("sharecurrency"));
        this.sharecurrency = sharecurrency = BusinessDataServiceHelper.loadSingle((Object)sharecurrencyId, (String)"bd_currency");
        this.shareNum = shareNum = Long.parseLong((String)paramMap.get("shareNum"));
        long exrateTableId = Long.parseLong((String)paramMap.get("exratetable"));
        this.setIchange(exrateTableId);
        this.orgIdMaxPeriodDate = this.getMaxPeriodDateByOrgid(calOrgId);
        this.exFieldSet = CommonSettingHelper.getExFieldSet();
        this.costAccountBeginDateMap = this.getMaxPeriodsDateByOrgid(calOrgId);
    }

    private void buildCostElementByCalOrgAndSupportTaxAmt(long calOrgId) {
        QFilter q = new QFilter("calorg", "=", (Object)calOrgId).and("enable", "=", (Object)Character.valueOf('1'));
        DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,name,calpolicy.calbycostelement,calpolicy.supporttaxamt", (QFilter[])q.toArray());
        for (DynamicObject costAccount : costAccounts) {
            Long costAccountId = costAccount.getLong("id");
            Boolean calbycostelement = costAccount.getBoolean("calpolicy.calbycostelement");
            Boolean supporttaxamt = costAccount.getBoolean("calpolicy.supporttaxamt");
            this.calByCostElementMap.put(costAccountId, calbycostelement);
            this.supportTaxAmtMap.put(costAccountId, supporttaxamt);
        }
    }

    public FeeSharePrepare(Map<String, Object> paramMap, Map<DynamicObject, List<DynamicObject>> matchResultMap, List<DynamicObject> asstUnMainAccount, Map<Long, QFilter> bizDateFilterMap) {
        this.init(paramMap);
        Collection<List<DynamicObject>> mainCostRecordCollection = matchResultMap.values();
        Set<DynamicObject> mainBills = matchResultMap.keySet();
        Map returnMap = FeeShareHelper.getElementMap(mainCostRecordCollection, asstUnMainAccount, mainBills);
        this.setCostRecordDetailData(returnMap);
        this.bizDateFilterMap = bizDateFilterMap;
    }

    public Map<String, List<DynamicObject>> getMultiCostEstCostAdjust() {
        return this.multiCostEstCostAdjust;
    }

    public Map<String, List<DynamicObject>> getMultiCostEstStdCostDiffBill() {
        return this.multiCostEstStdCostDiffBill;
    }

    public void dynamicField(Map<Long, Set<Long>> asstCostRecordEntryIdMap, FeeShareRelation feeShareRelation, List<DynamicObject> asstBills) {
        DynamicObject mainBill = feeShareRelation.getMainBill();
        DynamicObject mainParentBill = feeShareRelation.getMainParentObj();
        long calEntryId = 0L;
        HashSet<Long> entryIdSet = new HashSet<Long>();
        Set<Long> asstCostRecord = null;
        for (DynamicObject costRecordEntry : asstBills) {
            calEntryId = costRecordEntry.getLong("calentryid");
            entryIdSet.add(costRecordEntry.getLong("id"));
            asstCostRecord = asstCostRecordEntryIdMap.get(calEntryId);
            if (asstCostRecord == null) continue;
            entryIdSet.addAll(asstCostRecord);
        }
        long exitemId = mainBill.getLong("expenseitem_id");
        long supplierId = mainParentBill.getLong("asstact.id");
        this.setMultiCostEstCostAdjust(entryIdSet, exitemId, feeShareRelation.getMainParentObj().getLong("id"), supplierId);
        this.setMultiCostEstStdCostDiffBill(entryIdSet, exitemId, feeShareRelation.getMainParentObj().getLong("id"), supplierId);
        this.setIsFirstCostEst(entryIdSet, exitemId, supplierId);
        this.seteEntryIdSet(entryIdSet);
    }

    public void setMultiCostEstCostAdjust(Set<Long> entryIdSet, Long exitemId, Long mainBillId, Long supplierId) {
        HashMap<String, List<DynamicObject>> multiCostEstCostAdjust = new HashMap<String, List<DynamicObject>>();
        QFilter queryFilter = new QFilter("entryentity.feeprojectid", "=", (Object)exitemId).and("entryentity.invbillentryid", "in", entryIdSet).and("entryentity.srcbizentityobject", "=", (Object)"cal_costestimatebill").and("checkstrikeaccount", "=", (Object)Boolean.FALSE);
        queryFilter.and(this.bizDateFilterMap.get(mainBillId));
        queryFilter.and("custsupplier", "=", (Object)supplierId);
        DynamicObjectCollection costAdjustBills = QueryServiceHelper.query((String)"cal_costadjust_subentity", (String)"id", (QFilter[])queryFilter.toArray());
        if (costAdjustBills.isEmpty()) {
            this.multiCostEstCostAdjust = multiCostEstCostAdjust;
            return;
        }
        HashSet<Long> ids = new HashSet<Long>();
        for (DynamicObject bill : costAdjustBills) {
            long id = bill.getLong("id");
            ids.add(id);
        }
        DynamicObject[] costAdjustBillArray = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cal_costadjust_subentity"));
        String id = "";
        ArrayList<DynamicObject> costEstAdjustBillList = null;
        for (DynamicObject dynamicObject : costAdjustBillArray) {
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryEntity) {
                id = entry.getString("invbillentryid");
                String key = id + supplierId.toString();
                costEstAdjustBillList = (ArrayList<DynamicObject>)multiCostEstCostAdjust.get(key);
                if (costEstAdjustBillList == null) {
                    costEstAdjustBillList = new ArrayList<DynamicObject>();
                }
                costEstAdjustBillList.add(dynamicObject);
                multiCostEstCostAdjust.put(key, costEstAdjustBillList);
            }
        }
        this.multiCostEstCostAdjust = multiCostEstCostAdjust;
    }

    public void setMultiCostEstStdCostDiffBill(Set<Long> entryIdSet, Long exitemId, Long mainBillId, Long supplierId) {
        HashMap<String, List<DynamicObject>> multiCostEstCostAdjust = new HashMap<String, List<DynamicObject>>();
        QFilter queryFilter = new QFilter("entryentity.feeprojectid", "=", (Object)exitemId).and("entryentity.invbillentryid", "in", entryIdSet).and("entryentity.srcbizentityobject", "=", (Object)"cal_costestimatebill").and("checkstrikeaccount", "=", (Object)Boolean.FALSE);
        queryFilter.and(this.bizDateFilterMap.get(mainBillId));
        queryFilter.and("custsupplier", "=", (Object)supplierId);
        DynamicObjectCollection costAdjustBills = QueryServiceHelper.query((String)"cal_stdcostdiffbill", (String)"id", (QFilter[])queryFilter.toArray());
        if (costAdjustBills.isEmpty()) {
            this.multiCostEstStdCostDiffBill = multiCostEstCostAdjust;
            return;
        }
        HashSet<Long> ids = new HashSet<Long>();
        for (DynamicObject bill : costAdjustBills) {
            long id = bill.getLong("id");
            ids.add(id);
        }
        DynamicObject[] costAdjustBillArray = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cal_stdcostdiffbill"));
        String id = "";
        ArrayList<DynamicObject> costEstAdjustBillList = null;
        for (DynamicObject dynamicObject : costAdjustBillArray) {
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryEntity) {
                id = entry.getString("invbillentryid");
                String key = id + supplierId.toString();
                costEstAdjustBillList = (ArrayList<DynamicObject>)multiCostEstCostAdjust.get(key);
                if (costEstAdjustBillList == null) {
                    costEstAdjustBillList = new ArrayList<DynamicObject>();
                }
                costEstAdjustBillList.add(dynamicObject);
                multiCostEstCostAdjust.put(key, costEstAdjustBillList);
            }
        }
        this.multiCostEstStdCostDiffBill = multiCostEstCostAdjust;
    }

    public void setIsFirstCostEst(Set<Long> entryIdSet, Long exitemId, Long supplierId) {
        this.firstCostEstCostMap = FeeShareHelper.getFirstCostEstCostMap(entryIdSet, (Long)exitemId, (Long)supplierId);
    }

    public String getShareStandard() {
        return this.shareStandard;
    }

    public Map<String, BigDecimal> getFirstCostEstCostMap() {
        return this.firstCostEstCostMap;
    }

    public Set<String> getExFieldSet() {
        HashSet<String> unmodifiableSet = new HashSet<String>();
        unmodifiableSet.addAll(this.exFieldSet);
        return unmodifiableSet;
    }

    public Date getOrgIdMaxPeriodDate() {
        return (Date)this.orgIdMaxPeriodDate.clone();
    }

    public Map<Long, Date> getOrgIdMaxPeriodsDate() {
        return this.costAccountBeginDateMap;
    }

    private Date getMaxPeriodDateByOrgid(long calorgId) {
        Date maxDate = AccountingSysHelper.getCurrentPeriodMaxDateByOrg((long)calorgId);
        if (maxDate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e0b\u6ca1\u6709\u542f\u7528\u4e2d\u7684\u6210\u672c\u8d26\u7c3f\uff0c\u6216\u6210\u672c\u8d26\u7c3f\u672a\u521d\u59cb\u5316\u3002", (String)"FeeSharePrepare_4", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        return maxDate;
    }

    private Map<Long, Date> getMaxPeriodsDateByOrgid(long calorgId) {
        Map maxDates = AccountingSysHelper.getCurrentPeriodsMaxDateByOrg((long)calorgId);
        if (maxDates == null || maxDates.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e0b\u6ca1\u6709\u542f\u7528\u4e2d\u7684\u6210\u672c\u8d26\u7c3f\uff0c\u6216\u6210\u672c\u8d26\u7c3f\u672a\u521d\u59cb\u5316\u3002", (String)"FeeSharePrepare_4", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        return maxDates;
    }

    public DynamicObject getSharecurrency() {
        return this.sharecurrency;
    }

    public void setIchange(Long exrateTableId) {
        if (this.sharecurrency == null || exrateTableId == 0L) {
            String content = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u4e0d\u5b58\u5728\u672c\u4f4d\u5e01\u65e0\u6cd5\u5206\u644a\uff0c\u8bf7\u7ef4\u62a4\u6838\u7b97\u7ec4\u7ec7\u672c\u4f4d\u5e01\u57fa\u7840\u8d44\u6599\u3002", (String)"FeeSharePrepare_5", (String)"fi-cal-formplugin", (Object[])new Object[0]), this.calorg.getString("name"));
            throw new KDBizException(content);
        }
        this.ichange = new StandardAmtExchange(this.sharecurrency, exrateTableId, "1");
    }

    public DynamicObject getCalorg() {
        return this.calorg;
    }

    private final void setCostRecordDetailData(Map<String, Object> returnMap) {
        this.exitemElementMap = (Map)returnMap.get("exitemElementMap");
        this.cosTypeMaterialMap = (Map)returnMap.get("cosTypeMaterialMap");
        this.exitemAndEntryIdList = (List)returnMap.get("exitemAndEntryIdList");
        this.defaultId = (Long)returnMap.get("defaultId");
    }

    public Long getDefaultId() {
        return this.defaultId;
    }

    public List<Set<Long>> getExitemAndEntryIdList() {
        ArrayList<Set<Long>> unChangeList = new ArrayList<Set<Long>>();
        unChangeList.addAll(this.exitemAndEntryIdList);
        return unChangeList;
    }

    public Map<String, Long[]> getExitemElementMap() {
        return this.exitemElementMap;
    }

    public Map<String, Long[]> getCosTypeMaterialMap() {
        return this.cosTypeMaterialMap;
    }

    public IStandardAmtExchange getIchange() {
        return this.ichange;
    }

    public Date getShareDate() {
        return (Date)this.shareDate.clone();
    }

    public Long getShareNum() {
        return this.shareNum;
    }

    public Map<Long, Boolean> getCalByCostElementMap() {
        return this.calByCostElementMap;
    }

    public void setCalByCostElementMap(Map<Long, Boolean> calByCostElementMap) {
        this.calByCostElementMap = calByCostElementMap;
    }

    public Map<Long, Boolean> getSuppotTaxAmtMap() {
        return this.supportTaxAmtMap;
    }

    public void seteEntryIdSet(Set<Long> entryIdSet) {
        Set containIdSet;
        this.entryIdSet = containIdSet = FeeShareHelper.queryIsFeeShare(entryIdSet);
    }

    public Set<Long> getVerCalEntryIdSet() {
        HashSet<Long> unChangeSet = new HashSet<Long>();
        unChangeSet.addAll(this.entryIdSet);
        return unChangeSet;
    }

    public Set<Object> getSuccMainBillEntryIds() {
        return this.succMainBillEntryIds;
    }

    public Set<Long> getSuccAssBillIds() {
        return this.succAssBillIds;
    }

    public String toString() {
        return "FeeSharePrepare [shareStandard=" + this.shareStandard + ", ichange=" + this.ichange + ", shareDate=" + this.shareDate + ", shareNum=" + this.shareNum + ", defaultId=" + this.defaultId + ", exitemElementMap=" + this.exitemElementMap + ", cosTypeMaterialMap=" + this.cosTypeMaterialMap + ", exitemAndEntryIdList=" + this.exitemAndEntryIdList + ", calorg=" + this.calorg + ", sharecurrency=" + this.sharecurrency + ", verifiedBizIdSet=" + this.entryIdSet + ", orgIdMaxPeriodDate=" + this.orgIdMaxPeriodDate + ", exFieldSet=" + this.exFieldSet + ", firstCostEstCostMap=" + this.firstCostEstCostMap + ", multiCostEstCostAdjust=" + this.multiCostEstCostAdjust + "]";
    }
}

